package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.Oeta1;

/**
 * Oeta1Dao  
 *  
 */

public interface Oeta1Dao {
    
    /**
     * Inserts a single row in the Oeta1 table.
     *
     * @param oeta1 Oeta1
     * @return Oeta1
     */
    Oeta1 add(Oeta1 oeta1);

    /**
     * Updates a single row in the Oeta1 table.
     *
     * @param oeta1 Oeta1
     * @return Oeta1
     */
    Oeta1 update(Oeta1 oeta1);

    /**
     * Finds a single row in the Oeta1 table.
     *
     * @param oeta1 Oeta1
     * @return Oeta1
     */
    Oeta1 find(Oeta1 oeta1);

    /**
     * Deletes a single row in the Oeta1 table.
     *
     * @param oeta1 Oeta1
     * @return 
     */
    void remove(Oeta1 oeta1);

    /**
     * Finds a List of rows in the Oeta1 table.
     *
     * @param oeta1 Oeta1
     * @param pagination Pagination
     * @return List
     */
    List<Oeta1> findAll(Oeta1 oeta1, Pagination pagination);

    /**
     * Counts rows in the Oeta1 table.
     *
     * @param oeta1 Oeta1
     * @return Long
     */
    Long findAllCount(Oeta1 oeta1);
	
	/**
     * Finds rows in the Oeta1 table using like.
     *
     * @param oeta1 Oeta1
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List
     */
	List<Oeta1> findAllLike(Oeta1 oeta1, Pagination pagination, Boolean startsWith);
	
    /**
     * Counts rows in the Oeta1 table using like.
     *
     * @param oeta1 Oeta1
     * @param startsWith Boolean
     * @return Long
     */
    Long findAllLikeCount(Oeta1 oeta1, Boolean startsWith);
}

