package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Ooee;
import com.ejie.y41b.model.Sector;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Oese;

/**
 * OeseDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class OeseDaoImpl implements OeseDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Oese> rwMap = new RowMapper<Oese>() {
		public Oese mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			Oese oese = new Oese();
			Ooee ooee = new Ooee();
			ooee.setOecodigo(resultSet.getString("M6COOE"));
			oese.setOoee(ooee);
			oese.setM6cose(resultSet.getString("M6COSE"));
			Sector sector = new Sector();
			sector.setSecodigo(resultSet.getString("M6COSE"));
			sector.setSenombre(resultSet.getString("SectorSENOMBRE"));
			sector.setSenombree(resultSet.getString("SectorSENOMBREE"));
			oese.setSector(sector);
			return oese;

		}

	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Oese table.
	 * 
	 * @param oese
	 *            Pagination
	 * @return Oese
	 */
	public Oese add(Oese oese) {
		String query = "INSERT INTO Y41BD1T00 (M6COOE, M6COSE) VALUES (?,?)";
		Object OoeeOecodigoAux = null;
		if (oese.getOoee() != null && oese.getOoee().getOecodigo() != null) {
			OoeeOecodigoAux = oese.getOoee().getOecodigo();
		}
		this.jdbcTemplate.update(query, OoeeOecodigoAux, oese.getM6cose());
		return oese;
	}

	/**
	 * Updates a single row in the Oese table.
	 * 
	 * @param oese
	 *            Pagination
	 * @return Oese
	 */
	public Oese update(Oese oese) {
		String query = "UPDATE OESE SET  WHERE M6COOE=? AND M6COSE=?";
		Object OoeeOecodigoAux = null;
		if (oese.getOoee() != null && oese.getOoee().getOecodigo() != null) {
			OoeeOecodigoAux = oese.getOoee().getOecodigo();
		}
		this.jdbcTemplate.update(query, OoeeOecodigoAux, oese.getM6cose());
		return oese;
	}

	/**
	 * Finds a single row in the Oese table.
	 * 
	 * @param oese
	 *            Pagination
	 * @return Oese
	 */
	@Transactional(readOnly = true)
	public Oese find(Oese oese) {
		String query = "SELECT t1.M6COOE M6COOE, t1.M6COSE M6COSE, t2.SENOMBRE SectorSENOMBRE, t2.SENOMBREE SectorSENOMBREE FROM Y41BD1T00 t1, SECTOR t2  WHERE t1.M6COSE=t2.SECODIGO(+) AND t1.M6COOE = ?   AND t1.M6COSE = ?  ";

		List<Oese> oeseList = this.jdbcTemplate.query(query, this.rwMap, oese
				.getOoee().getOecodigo(), oese.getM6cose());
		return (Oese) DataAccessUtils.uniqueResult(oeseList);
	}

	/**
	 * Removes a single row in the Oese table.
	 * 
	 * @param oese
	 *            Pagination
	 * @return
	 */
	public void remove(Oese oese) {
		StringBuilder query = new StringBuilder(
				"DELETE FROM Y41BD1T00 WHERE M6COOE=? AND M6COSE=?");
		this.jdbcTemplate.update(query.toString(),
				oese.getOoee().getOecodigo(), oese.getM6cose());
	}

	/**
	 * Finds a List of rows in the Oese table.
	 * 
	 * @param oese
	 *            Oese
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Oese> findAll(Oese oese, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.M6COOE M6COOE,t1.M6COSE M6COSE, t2.SENOMBRE SectorSENOMBRE, t2.SENOMBREE SectorSENOMBREE ");
		query.append("FROM Y41BD1T00 t1, SECTOR t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(oese);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.M6COSE=t2.SECODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Oese>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Oese table.
	 * 
	 * @param oese
	 *            Oese
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Oese oese) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM Y41BD1T00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(oese);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Oese table using like.
	 * 
	 * @param oese
	 *            Oese
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Oese> findAllLike(Oese oese, Pagination pagination,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.M6COOE M6COOE,t1.M6COSE M6COSE, t2.SENOMBRE SectorSENOMBRE, t2.SENOMBREE SectorSENOMBREE ");
		query.append("FROM Y41BD1T00 t1, SECTOR t2(+) ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(oese);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.M6COSE=t2.SECODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Oese>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Oese table using like.
	 * 
	 * @param oese
	 *            Oese
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Oese oese, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM Y41BD1T00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(oese, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Oese entity
	 * 
	 * @param oese
	 *            Oese Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Oese oese) {

		StringBuilder where = new StringBuilder(OeseDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (oese != null && oese.getOoee().getOecodigo() != null) {
			where.append(" AND t1.M6COOE = ?");
			params.add(oese.getOoee().getOecodigo());
		}
		if (oese != null && oese.getM6cose() != null) {
			where.append(" AND t1.M6COSE = ?");
			params.add(oese.getM6cose());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Oese entity
	 * 
	 * @param oese
	 *            Oese Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Oese oese, Boolean startsWith) {

		StringBuilder where = new StringBuilder(OeseDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (oese != null && oese.getOoee().getOecodigo() != null) {
			where.append(" AND UPPER(t1.M6COOE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(oese.getOoee().getOecodigo().toUpperCase() + "%");
			} else {
				params.add("%" + oese.getOoee().getOecodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.M6COOE IS NOT NULL");
		}
		if (oese != null && oese.getM6cose() != null) {
			where.append(" AND UPPER(t1.M6COSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(oese.getM6cose().toUpperCase() + "%");
			} else {
				params.add("%" + oese.getM6cose().toUpperCase() + "%");
			}
			where.append(" AND t1.M6COSE IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	@Override
	public void volcarOoeeSectores(Ooee ooee) {
		String query = "DELETE FROM Y41BD1T00 WHERE M6COOE = ? ";
		this.jdbcTemplate.update(query, ooee.getOecodigo());
		query = "INSERT INTO Y41BD1T00 SELECT M6COOE,M6COSE FROM OESE WHERE M6COOE = ? ";
		this.jdbcTemplate.update(query, ooee.getOecodigo());
	}

	@Override
	public void removeOese(Oese oese) {
		String query = "DELETE FROM OESE WHERE M6COOE = ? ";
		this.jdbcTemplate.update(query, oese.getOoee().getOecodigo());
	}

	@Override
	public void addOese(Oese oese) {
		String query = "INSERT INTO OESE (M6COOE, M6COSE) VALUES (?,?)";
		Object OoeeOecodigoAux = null;
		if (oese.getOoee() != null && oese.getOoee().getOecodigo() != null) {
			OoeeOecodigoAux = oese.getOoee().getOecodigo();
		}
		this.jdbcTemplate.update(query, OoeeOecodigoAux, oese.getM6cose());

	}

}
