package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.Oese;
import com.ejie.y41b.model.Ooee;

/**
 * OeseDao  
 * 
 *  
 */

public interface OeseDao {

	/**
	 * Inserts a single row in the Oese table.
	 * 
	 * @param oese
	 *            Oese
	 * @return Oese
	 */
	Oese add(Oese oese);

	/**
	 * Updates a single row in the Oese table.
	 * 
	 * @param oese
	 *            Oese
	 * @return Oese
	 */
	Oese update(Oese oese);

	/**
	 * Finds a single row in the Oese table.
	 * 
	 * @param oese
	 *            Oese
	 * @return Oese
	 */
	Oese find(Oese oese);

	/**
	 * Deletes a single row in the Oese table.
	 * 
	 * @param oese
	 *            Oese
	 * @return
	 */
	void remove(Oese oese);

	/**
	 * Finds a List of rows in the Oese table.
	 * 
	 * @param oese
	 *            Oese
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Oese> findAll(Oese oese, Pagination pagination);

	/**
	 * Counts rows in the Oese table.
	 * 
	 * @param oese
	 *            Oese
	 * @return Long
	 */
	Long findAllCount(Oese oese);

	/**
	 * Finds rows in the Oese table using like.
	 * 
	 * @param oese
	 *            Oese
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Oese> findAllLike(Oese oese, Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Oese table using like.
	 * 
	 * @param oese
	 *            Oese
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Oese oese, Boolean startsWith);

	/**
	 * Volcado en la tabla temporal
	 * 
	 * @param ooee
	 *            Ooee
	 */
	void volcarOoeeSectores(Ooee ooee);

	/**
	 * Borrado sobre la tabla temporal
	 * 
	 * @param oese
	 *            Oese
	 */
	void removeOese(Oese oese);

	/**
	 * Aadir sobre la tabla temporal
	 * 
	 * @param oese
	 *            Oese
	 */
	void addOese(Oese oese);
}
