package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.*;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Oear;

/**
 * OearDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class OearDaoImpl implements OearDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Oear> rwMap = new RowMapper<Oear>() {
		public Oear mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			Ooee ooee = new Ooee(resultSet.getString("M2COOE"), null, null,
					null, null, null, null, null, null, null, null, null, null,
					null, null, null, null);
			Organismo organismo = new Organismo();
			organismo.setNombreEs(resultSet.getString("OrganismoNOMBREES"));
			organismo.setNombreEu(resultSet.getString("OrganismoNOMBREEU"));
			ooee.setOrganismo(organismo);
			return new Oear(ooee, new Arbitro(resultSet.getString("M2COAR"),
					null, resultSet.getString("ArbitroARNIF"),
					resultSet.getString("ArbitroARNOMBRE"), null, null, null,
					null, null, null, null, null, null, null, null, null, null,
					null, null, null, null, null, null, null, null, null, null,
					null, null, null, null, null, null, null, null, null, null,
					null, null, null, null, null, null, null, null, null, null,
					null, null, null, null, null, null, null),
					resultSet.getString("M2CENTROAR"), null, null);
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Oear table.
	 * 
	 * @param oear
	 *            Pagination
	 * @return Oear
	 */
	public Oear add(Oear oear) {
		String query = "INSERT INTO Y41BD2T00 (M2COOE, M2COAR, M2CENTROAR) VALUES (?,?,?)";
		Object OoeeOecodigoAux = null;
		if (oear.getOoee() != null && oear.getOoee().getOecodigo() != null) {
			OoeeOecodigoAux = oear.getOoee().getOecodigo();
		}
		Object ArbitroArcodigoAux = null;
		if (oear.getArbitro() != null
				&& oear.getArbitro().getArcodigo() != null) {
			ArbitroArcodigoAux = oear.getArbitro().getArcodigo();
		}
		this.jdbcTemplate.update(query, OoeeOecodigoAux, ArbitroArcodigoAux,
				oear.getM2centroar());
		return oear;
	}

	/**
	 * Updates a single row in the Oear table.
	 * 
	 * @param oear
	 *            Pagination
	 * @return Oear
	 */
	public Oear update(Oear oear) {
		String query = "UPDATE OEAR SET M2CENTROAR=? WHERE M2COOE=? AND M2COAR=?";
		Object OoeeOecodigoAux = null;
		if (oear.getOoee() != null && oear.getOoee().getOecodigo() != null) {
			OoeeOecodigoAux = oear.getOoee().getOecodigo();
		}
		Object ArbitroArcodigoAux = null;
		if (oear.getArbitro() != null
				&& oear.getArbitro().getArcodigo() != null) {
			ArbitroArcodigoAux = oear.getArbitro().getArcodigo();
		}
		this.jdbcTemplate.update(query, oear.getM2centroar(), OoeeOecodigoAux,
				ArbitroArcodigoAux);
		return oear;
	}

	/**
	 * Finds a single row in the Oear table.
	 * 
	 * @param oear
	 *            Pagination
	 * @return Oear
	 */
	@Transactional(readOnly = true)
	public Oear find(Oear oear) {
		String query = "SELECT t1.M2COOE M2COOE, t1.M2COAR M2COAR, t1.M2CENTROAR M2CENTROAR, t2.ARNIF ArbitroARNIF, t2.ARNOMBRE ArbitroARNOMBRE, t3.NOMBRE_ES OrganismoNOMBREES, t3.NOMBRE_EU OrganismoNOMBREEU  FROM Y41BD2T00 t1, ARBITRO t2, ORGANISMO t3  WHERE t1.M2COAR=t2.ARCODIGO(+) AND t1.M2COOE=t3.COD_ORG(+) AND t1.M2COOE = ?   AND t1.M2COAR = ?  ";

		List<Oear> oearList = this.jdbcTemplate.query(query, this.rwMap, oear
				.getOoee().getOecodigo(), oear.getArbitro().getArcodigo());
		return (Oear) DataAccessUtils.uniqueResult(oearList);
	}

	/**
	 * Removes a single row in the Oear table.
	 * 
	 * @param oear
	 *            Pagination
	 * @return
	 */
	public void remove(Oear oear) {
		String query = "DELETE FROM Y41BD2T00 WHERE M2COOE=? AND M2COAR=? ";
		this.jdbcTemplate.update(query, oear.getOoee().getOecodigo(), oear
				.getArbitro().getArcodigo());
	}

	/**
	 * Finds a List of rows in the Oear table.
	 * 
	 * @param oear
	 *            Oear
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Oear> findAll(Oear oear, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.M2COOE M2COOE,t1.M2COAR M2COAR,t1.M2CENTROAR M2CENTROAR, t2.ARNIF ArbitroARNIF, t2.ARNOMBRE ArbitroARNOMBRE , t3.NOMBRE_ES OrganismoNOMBREES, t3.NOMBRE_EU OrganismoNOMBREEU ");
		query.append("FROM Y41BD2T00 t1 , ARBITRO t2, ORGANISMO t3 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(oear);
		StringBuilder where = new StringBuilder(
				" WHERE t1.M2COAR=t2.ARCODIGO(+) AND t1.M2COOE=t3.COD_ORG(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Oear>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Oear table.
	 * 
	 * @param oear
	 *            Oear
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Oear oear) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM Y41BD2T00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(oear);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Oear table using like.
	 * 
	 * @param oear
	 *            Oear
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Oear> findAllLike(Oear oear, Pagination pagination,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.M2COOE M2COOE,t1.M2COAR M2COAR,t1.M2CENTROAR M2CENTROAR, t2.ARNIF ArbitroARNIF, t2.ARNOMBRE ArbitroARNOMBRE, t3.NOMBRE_ES OrganismoNOMBREES, t3.NOMBRE_EU OrganismoNOMBREEU  ");
		query.append("FROM Y41BD2T00 t1 , ARBITRO t2, ORGANISMO t3 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(oear, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE t1.M2COAR=t2.ARCODIGO(+) AND t1.M2COOE=t3.COD_ORG(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Oear>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Oear table using like.
	 * 
	 * @param oear
	 *            Oear
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Oear oear, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM Y41BD2T00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(oear, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Oear entity
	 * 
	 * @param oear
	 *            Oear Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Oear oear) {

		StringBuilder where = new StringBuilder(OearDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (oear != null && oear.getOoee() != null
				&& oear.getOoee().getOecodigo() != null) {
			where.append(" AND t1.M2COOE = ?");
			params.add(oear.getOoee().getOecodigo());
		}
		if (oear != null && oear.getArbitro() != null
				&& oear.getArbitro().getArcodigo() != null) {
			where.append(" AND t1.M2COAR = ?");
			params.add(oear.getArbitro().getArcodigo());
		}
		if (oear != null && oear.getM2centroar() != null) {
			where.append(" AND t1.M2CENTROAR = ?");
			params.add(oear.getM2centroar());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Oear entity
	 * 
	 * @param oear
	 *            Oear Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Oear oear, Boolean startsWith) {

		StringBuilder where = new StringBuilder(OearDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (oear != null && oear.getOoee().getOecodigo() != null) {
			where.append(" AND UPPER(t1.M2COOE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(oear.getOoee().getOecodigo().toUpperCase() + "%");
			} else {
				params.add("%" + oear.getOoee().getOecodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.M2COOE IS NOT NULL");
		}
		if (oear != null && oear.getArbitro().getArcodigo() != null) {
			where.append(" AND UPPER(t1.ARCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(oear.getArbitro().getArcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + oear.getArbitro().getArcodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ARCODIGO IS NOT NULL");
		}
		if (oear != null && oear.getM2centroar() != null) {
			where.append(" AND UPPER(t1.M2CENTROAR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(oear.getM2centroar().toUpperCase() + "%");
			} else {
				params.add("%" + oear.getM2centroar().toUpperCase() + "%");
			}
			where.append(" AND t1.M2CENTROAR IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * Volcado en la tabla temporal
	 * 
	 * @param ooee
	 *            Oear
	 */
	public void volcarOoeeArbitros(Ooee ooee) {
		String query = "DELETE FROM Y41BD2T00 WHERE M2COOE = ? ";
		this.jdbcTemplate.update(query, ooee.getOecodigo());
		query = "INSERT INTO Y41BD2T00 SELECT M2COOE, M2COAR, M2CENTROAR FROM OEAR WHERE M2COOE = ? ";
		this.jdbcTemplate.update(query, ooee.getOecodigo());
	}

	/**
	 * Volcado en la tabla temporal
	 * 
	 * @param ooee
	 *            Oear
	 */
	public void volcarArbitroOoees(Arbitro arbitro) {
		String query = "DELETE FROM Y41BD2T00 WHERE M2COAR = ? ";
		this.jdbcTemplate.update(query, arbitro.getArcodigo());
		query = "INSERT INTO Y41BD2T00 SELECT M2COOE, M2COAR, M2CENTROAR FROM OEAR WHERE M2COAR = ? ";
		this.jdbcTemplate.update(query, arbitro.getArcodigo());
	}

	/**
	 * Borrado sobre la tabla temporal
	 * 
	 * @param oear
	 *            Oear
	 */
	public void removeOearOoee(Oear oear) {
		String query = "DELETE FROM OEAR WHERE M2COOE = ?  ";
		this.jdbcTemplate.update(query, oear.getOoee().getOecodigo());
	}

	/**
	 * Borrado sobre la tabla temporal
	 * 
	 * @param oear
	 *            Oear
	 */
	public void removeOearArbitro(Oear oear) {
		String query = "DELETE FROM OEAR WHERE M2COAR = ?  ";
		this.jdbcTemplate.update(query, oear.getArbitro().getArcodigo());
	}

	/**
	 * Aadir sobre la tabla temporal
	 * 
	 * @param oear
	 *            Oear
	 */
	public void addOear(Oear oear) {
		String query = "INSERT INTO OEAR (M2COOE, M2COAR, M2CENTROAR) VALUES (?,?,?)";
		Object OoeeOecodigoAux = null;
		if (oear.getOoee() != null && oear.getOoee().getOecodigo() != null) {
			OoeeOecodigoAux = oear.getOoee().getOecodigo();
		}
		Object ArbitroArcodigoAux = null;
		if (oear.getArbitro() != null
				&& oear.getArbitro().getArcodigo() != null) {
			ArbitroArcodigoAux = oear.getArbitro().getArcodigo();
		}
		this.jdbcTemplate.update(query, OoeeOecodigoAux, ArbitroArcodigoAux,
				oear.getM2centroar());
	}
}
