package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.*;

/**
 * OearDao  
 * 
 *  
 */

public interface OearDao {

	/**
	 * Inserts a single row in the Oear table.
	 * 
	 * @param oear
	 *            Oear
	 * @return Oear
	 */
	Oear add(Oear oear);

	/**
	 * Updates a single row in the Oear table.
	 * 
	 * @param oear
	 *            Oear
	 * @return Oear
	 */
	Oear update(Oear oear);

	/**
	 * Finds a single row in the Oear table.
	 * 
	 * @param oear
	 *            Oear
	 * @return Oear
	 */
	Oear find(Oear oear);

	/**
	 * Deletes a single row in the Oear table.
	 * 
	 * @param oear
	 *            Oear
	 * @return
	 */
	void remove(Oear oear);

	/**
	 * Finds a List of rows in the Oear table.
	 * 
	 * @param oear
	 *            Oear
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Oear> findAll(Oear oear, Pagination pagination);

	/**
	 * Counts rows in the Oear table.
	 * 
	 * @param oear
	 *            Oear
	 * @return Long
	 */
	Long findAllCount(Oear oear);

	/**
	 * Finds rows in the Oear table using like.
	 * 
	 * @param oear
	 *            Oear
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Oear> findAllLike(Oear oear, Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Oear table using like.
	 * 
	 * @param oear
	 *            Oear
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Oear oear, Boolean startsWith);

	/**
	 * Volcado en la tabla temporal
	 * 
	 * @param ooee
	 *            Oear
	 */
	void volcarOoeeArbitros(Ooee ooee);

	/**
	 * Volcado en la tabla temporal
	 * 
	 * @param arbitro
	 *            Arbitro
	 */
	void volcarArbitroOoees(Arbitro arbitro);

	/**
	 * Borrado sobre la tabla temporal
	 * 
	 * @param oear
	 *            Oear
	 */
	void removeOearOoee(Oear oear);

	/**
	 * Borrado sobre la tabla temporal
	 * 
	 * @param oear
	 *            Oear
	 */
	void removeOearArbitro(Oear oear);

	/**
	 * Aadir sobre la tabla temporal
	 * 
	 * @param oear
	 *            Oear
	 */
	void addOear(Oear oear);
}
