package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Denuncia;

/**
 * * NumSolicitudDaoImpl  
 * 
 *  
 */
@SuppressWarnings(value = { "deprecation" })
@Repository
@Transactional
public class NumSolicitudDaoImpl implements NumSolicitudDao {
	private JdbcTemplate jdbcTemplate;

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Num_Solicitud table.
	 * 
	 * @param denuncia
	 *            Denuncia
	 * @return Denuncia
	 */
	public Denuncia add(Denuncia denuncia) {

		String query = "INSERT INTO NUM_SOLICITUD( DECOOR,DENRAN,DENROR)"
				+ "VALUES (?,?,?)";

		this.jdbcTemplate.update(query, denuncia.getDecoor(),
				denuncia.getDenran(), denuncia.getDenror());
		return denuncia;
	}

	/**
	 * Finds a single row in the Num_Solicitud table.
	 * 
	 * @param denuncia
	 *            Denuncia
	 * @return Denuncia
	 */
	@Transactional(readOnly = true)
	public Denuncia findNumSolicitud(Denuncia denuncia) {
		String query = "SELECT NVL(MAX(ABS(DENROR)),0)+1 DENROR FROM NUM_SOLICITUD WHERE DECOOR = ? AND DENRAN = ? ";

		return (Denuncia) this.jdbcTemplate.queryForObject(query,
				new RowMapper<Denuncia>() {
					public Denuncia mapRow(ResultSet resultSet, int rowNum)
							throws SQLException {
						return new Denuncia(null, null, resultSet
								.getLong("DENROR"));
					}
				}, denuncia.getDecoor(), denuncia.getDenran());
	}

}
