package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.NaturalezaPeligro;

/**
 * NaturalezaPeligroDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class NaturalezaPeligroDaoImpl implements NaturalezaPeligroDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<NaturalezaPeligro> rwMap = new RowMapper<NaturalezaPeligro>() {
		public NaturalezaPeligro mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new NaturalezaPeligro(
					resultSet.getString("IDNATURALEZAPELIGRO"),
					resultSet.getString("NATURALEZAPELIGRO"),
					resultSet.getString("NATURALEZAPELIGROE"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the NaturalezaPeligro table.
	 * 
	 * @param naturalezapeligro
	 *            Pagination
	 * @return NaturalezaPeligro
	 */
	public NaturalezaPeligro add(NaturalezaPeligro naturalezapeligro) {
		String query = "INSERT INTO NATURALEZA_PELIGRO (IDNATURALEZAPELIGRO, NATURALEZAPELIGRO, NATURALEZAPELIGROE) VALUES (?,?,?)";
		this.jdbcTemplate.update(query,
				naturalezapeligro.getIdnaturalezapeligro(),
				naturalezapeligro.getNaturalezapeligro(),
				naturalezapeligro.getNaturalezapeligroe());
		return naturalezapeligro;
	}

	/**
	 * Updates a single row in the NaturalezaPeligro table.
	 * 
	 * @param naturalezapeligro
	 *            Pagination
	 * @return NaturalezaPeligro
	 */
	public NaturalezaPeligro update(NaturalezaPeligro naturalezapeligro) {
		String query = "UPDATE NATURALEZA_PELIGRO SET NATURALEZAPELIGRO=?, NATURALEZAPELIGROE=? WHERE IDNATURALEZAPELIGRO=?";
		this.jdbcTemplate.update(query,
				naturalezapeligro.getNaturalezapeligro(),
				naturalezapeligro.getNaturalezapeligroe(),
				naturalezapeligro.getIdnaturalezapeligro());
		return naturalezapeligro;
	}

	/**
	 * Finds a single row in the NaturalezaPeligro table.
	 * 
	 * @param naturalezapeligro
	 *            Pagination
	 * @return NaturalezaPeligro
	 */
	@Transactional(readOnly = true)
	public NaturalezaPeligro find(NaturalezaPeligro naturalezapeligro) {
		String query = "SELECT t1.IDNATURALEZAPELIGRO IDNATURALEZAPELIGRO, t1.NATURALEZAPELIGRO NATURALEZAPELIGRO, t1.NATURALEZAPELIGROE NATURALEZAPELIGROE FROM NATURALEZA_PELIGRO t1  WHERE t1.IDNATURALEZAPELIGRO = ?  ";

		List<NaturalezaPeligro> naturalezapeligroList = this.jdbcTemplate
				.query(query, this.rwMap,
						naturalezapeligro.getIdnaturalezapeligro());
		return (NaturalezaPeligro) DataAccessUtils
				.uniqueResult(naturalezapeligroList);
	}

	/**
	 * Removes a single row in the NaturalezaPeligro table.
	 * 
	 * @param naturalezapeligro
	 *            Pagination
	 * @return
	 */
	public void remove(NaturalezaPeligro naturalezapeligro) {
		String query = "DELETE FROM NATURALEZA_PELIGRO WHERE IDNATURALEZAPELIGRO=?";
		this.jdbcTemplate.update(query,
				naturalezapeligro.getIdnaturalezapeligro());
	}

	/**
	 * Finds a List of rows in the NaturalezaPeligro table.
	 * 
	 * @param naturalezapeligro
	 *            NaturalezaPeligro
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<NaturalezaPeligro> findAll(NaturalezaPeligro naturalezapeligro,
			Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDNATURALEZAPELIGRO IDNATURALEZAPELIGRO,t1.NATURALEZAPELIGRO NATURALEZAPELIGRO,t1.NATURALEZAPELIGROE NATURALEZAPELIGROE ");
		query.append("FROM NATURALEZA_PELIGRO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(naturalezapeligro);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<NaturalezaPeligro>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the NaturalezaPeligro table.
	 * 
	 * @param naturalezapeligro
	 *            NaturalezaPeligro
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(NaturalezaPeligro naturalezapeligro) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM NATURALEZA_PELIGRO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(naturalezapeligro);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the NaturalezaPeligro table using like.
	 * 
	 * @param naturalezapeligro
	 *            NaturalezaPeligro
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<NaturalezaPeligro> findAllLike(
			NaturalezaPeligro naturalezapeligro, Pagination pagination,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDNATURALEZAPELIGRO IDNATURALEZAPELIGRO,t1.NATURALEZAPELIGRO NATURALEZAPELIGRO,t1.NATURALEZAPELIGROE NATURALEZAPELIGROE ");
		query.append("FROM NATURALEZA_PELIGRO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(naturalezapeligro,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<NaturalezaPeligro>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the NaturalezaPeligro table using like.
	 * 
	 * @param naturalezapeligro
	 *            NaturalezaPeligro
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(NaturalezaPeligro naturalezapeligro,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM NATURALEZA_PELIGRO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(naturalezapeligro,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the NaturalezaPeligro entity
	 * 
	 * @param naturalezapeligro
	 *            NaturalezaPeligro Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(NaturalezaPeligro naturalezapeligro) {

		StringBuilder where = new StringBuilder(
				NaturalezaPeligroDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (naturalezapeligro != null
				&& naturalezapeligro.getIdnaturalezapeligro() != null) {
			where.append(" AND t1.IDNATURALEZAPELIGRO = ?");
			params.add(naturalezapeligro.getIdnaturalezapeligro());
		}
		if (naturalezapeligro != null
				&& naturalezapeligro.getNaturalezapeligro() != null) {
			where.append(" AND t1.NATURALEZAPELIGRO = ?");
			params.add(naturalezapeligro.getNaturalezapeligro());
		}
		if (naturalezapeligro != null
				&& naturalezapeligro.getNaturalezapeligroe() != null) {
			where.append(" AND t1.NATURALEZAPELIGROE = ?");
			params.add(naturalezapeligro.getNaturalezapeligroe());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the NaturalezaPeligro entity
	 * 
	 * @param naturalezapeligro
	 *            NaturalezaPeligro Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(NaturalezaPeligro naturalezapeligro,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				NaturalezaPeligroDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (naturalezapeligro != null
				&& naturalezapeligro.getIdnaturalezapeligro() != null) {
			where.append(" AND UPPER(t1.IDNATURALEZAPELIGRO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(naturalezapeligro.getIdnaturalezapeligro()
						.toUpperCase() + "%");
			} else {
				params.add("%"
						+ naturalezapeligro.getIdnaturalezapeligro()
								.toUpperCase() + "%");
			}
			where.append(" AND t1.IDNATURALEZAPELIGRO IS NOT NULL");
		}
		if (naturalezapeligro != null
				&& naturalezapeligro.getNaturalezapeligro() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NATURALEZAPELIGRO),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(naturalezapeligro.getNaturalezapeligro()
						.toUpperCase().replaceAll("", "A")
						.replaceAll("", "E").replaceAll("", "I")
						.replaceAll("", "O").replaceAll("", "U")
						+ "%");
			} else {
				params.add("%"
						+ naturalezapeligro.getNaturalezapeligro()
								.toUpperCase().replaceAll("", "A")
								.replaceAll("", "E").replaceAll("", "I")
								.replaceAll("", "O").replaceAll("", "U")
						+ "%");
			}
			where.append(" AND t1.NATURALEZAPELIGRO IS NOT NULL");
		}
		if (naturalezapeligro != null
				&& naturalezapeligro.getNaturalezapeligroe() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.NATURALEZAPELIGROE),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(naturalezapeligro.getNaturalezapeligroe()
						.toUpperCase().replaceAll("", "A")
						.replaceAll("", "E").replaceAll("", "I")
						.replaceAll("", "O").replaceAll("", "U")
						+ "%");
			} else {
				params.add("%"
						+ naturalezapeligro.getNaturalezapeligroe()
								.toUpperCase().replaceAll("", "A")
								.replaceAll("", "E").replaceAll("", "I")
								.replaceAll("", "O").replaceAll("", "U")
						+ "%");
			}
			where.append(" AND t1.NATURALEZAPELIGROE IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
