package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.NaturalezaPeligro;

/**
 * NaturalezaPeligroDao  
 *  
 */

public interface NaturalezaPeligroDao {
    
    /**
     * Inserts a single row in the NaturalezaPeligro table.
     *
     * @param naturalezapeligro NaturalezaPeligro
     * @return NaturalezaPeligro
     */
    NaturalezaPeligro add(NaturalezaPeligro naturalezapeligro);

    /**
     * Updates a single row in the NaturalezaPeligro table.
     *
     * @param naturalezapeligro NaturalezaPeligro
     * @return NaturalezaPeligro
     */
    NaturalezaPeligro update(NaturalezaPeligro naturalezapeligro);

    /**
     * Finds a single row in the NaturalezaPeligro table.
     *
     * @param naturalezapeligro NaturalezaPeligro
     * @return NaturalezaPeligro
     */
    NaturalezaPeligro find(NaturalezaPeligro naturalezapeligro);

    /**
     * Deletes a single row in the NaturalezaPeligro table.
     *
     * @param naturalezapeligro NaturalezaPeligro
     * @return 
     */
    void remove(NaturalezaPeligro naturalezapeligro);

    /**
     * Finds a List of rows in the NaturalezaPeligro table.
     *
     * @param naturalezapeligro NaturalezaPeligro
     * @param pagination Pagination
     * @return List
     */
    List<NaturalezaPeligro> findAll(NaturalezaPeligro naturalezapeligro, Pagination pagination);

    /**
     * Counts rows in the NaturalezaPeligro table.
     *
     * @param naturalezapeligro NaturalezaPeligro
     * @return Long
     */
    Long findAllCount(NaturalezaPeligro naturalezapeligro);
	
	/**
     * Finds rows in the NaturalezaPeligro table using like.
     *
     * @param naturalezapeligro NaturalezaPeligro
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List
     */
	List<NaturalezaPeligro> findAllLike(NaturalezaPeligro naturalezapeligro, Pagination pagination, Boolean startsWith);
	
    /**
     * Counts rows in the NaturalezaPeligro table using like.
     *
     * @param naturalezapeligro NaturalezaPeligro
     * @param startsWith Boolean
     * @return Long
     */
    Long findAllLikeCount(NaturalezaPeligro naturalezapeligro, Boolean startsWith);
}

