package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Municipi;

/**
 * MunicipiDaoImpl  
 *  
 */
 
@Repository
@Transactional
public class MunicipiDaoImpl implements MunicipiDao {
    private JdbcTemplate jdbcTemplate;
	private RowMapper<Municipi> rwMap = new RowMapper<Municipi>() {
		public Municipi mapRow(ResultSet resultSet, int rowNum) throws SQLException {
           return new Municipi(
               resultSet.getString("MUCODIGO"), resultSet.getString("MUNOMBRE"), resultSet.getString("MUCOMU"), resultSet.getString("MUCOPV")
           ); } } ;

	/**
     * Method use to set the datasource.
     *
     * @param dataSource DataSource
     * @return
     */
    @Resource
    public void setDataSource(DataSource dataSource) {
    	this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    /**
     * Inserts a single row in the Municipi table.
     *
     * @param municipi Pagination
     * @return Municipi
     */
	public Municipi add(Municipi municipi) {
    	String query = "INSERT INTO MUNICIPI (MUCODIGO, MUNOMBRE, MUCOMU, MUCOPV) VALUES (?,?,?,?)";
		this.jdbcTemplate.update(query, municipi.getMucodigo(), municipi.getMunombre(), municipi.getMucomu(), municipi.getMucopv());
		return municipi;
	}

    /**
     * Updates a single row in the Municipi table.
     *
     * @param municipi Pagination
     * @return Municipi
     */
    public Municipi update(Municipi municipi) {
		String query = "UPDATE MUNICIPI SET MUNOMBRE=?, MUCOMU=?, MUCOPV=? WHERE MUCODIGO=?";
		this.jdbcTemplate.update(query, municipi.getMunombre(), municipi.getMucomu(), municipi.getMucopv(), municipi.getMucodigo());
		return municipi;
	}

    /**
     * Finds a single row in the Municipi table.
     *
     * @param municipi Pagination
     * @return Municipi
     */
    @Transactional (readOnly = true)
    public Municipi find(Municipi municipi) {
		String query = "SELECT t1.MUCODIGO MUCODIGO, t1.MUNOMBRE MUNOMBRE, t1.MUCOMU MUCOMU, t1.MUCOPV MUCOPV FROM MUNICIPI t1  WHERE t1.MUCODIGO = ?  ";
		
		List<Municipi> municipiList = this.jdbcTemplate.query(query, this.rwMap, municipi.getMucodigo());
		return (Municipi) DataAccessUtils.uniqueResult(municipiList);
    }

    /**
     * Removes a single row in the Municipi table.
     *
     * @param municipi Pagination
     * @return
     */
    public void remove(Municipi municipi) {
		String query = "DELETE FROM MUNICIPI WHERE MUCODIGO=?";
		this.jdbcTemplate.update(query, municipi.getMucodigo());
    }
    
   /**
    * Finds a List of rows in the Municipi table.
    * 
    * @param municipi Municipi
    * @param pagination Pagination
    * @return List 
    */
	@Transactional (readOnly = true)
    public List<Municipi> findAll(Municipi municipi, Pagination pagination) {
		StringBuilder query = new StringBuilder("SELECT  t1.MUCODIGO MUCODIGO,t1.MUNOMBRE MUNOMBRE,t1.MUCOMU MUCOMU,t1.MUCOPV MUCOPV "); 
		query.append("FROM MUNICIPI t1 ");
		
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(municipi); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		
		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		
		return (List<Municipi>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}
	
    /**
     * Counts rows in the Municipi table.
     * 
     * @param municipi Municipi
     * @return Long
     */
    @Transactional (readOnly = true)
    public Long findAllCount(Municipi municipi) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM MUNICIPI t1 ");
		
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(municipi); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);		
		
		List<?> params = (List<?>) mapaWhere.get("params");
		
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
	
	/**
	 * Finds rows in the Municipi table using like.
     * 
     * @param municipi Municipi
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List 
     */
	@Transactional (readOnly = true)
    public List<Municipi> findAllLike(Municipi municipi, Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT  t1.MUCODIGO MUCODIGO,t1.MUNOMBRE MUNOMBRE,t1.MUCOMU MUCOMU,t1.MUCOPV MUCOPV "); 
        query.append("FROM MUNICIPI t1 ");
      	
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(municipi,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		
		return (List<Municipi>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}
	
	/**
	 * Counts rows in the Municipi table using like.
     * 
     * @param municipi Municipi
     * @param startsWith Boolean
     * @return Long 
     */
	@Transactional (readOnly = true)
    public Long findAllLikeCount(Municipi municipi, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM MUNICIPI t1 ");

		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(municipi,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
	
	/**
	 * Returns a map with the needed value to create the conditions to filter by 
	 * the Municipi entity 
	 * 
	 * @param municipi Municipi
	 *            Bean with the criteria values to filter by.
	 * @return Map created with two keys
	 *         key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap (Municipi municipi){
		
		StringBuilder where = new StringBuilder(MunicipiDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (municipi  != null  && municipi.getMucodigo() != null ) {
			where.append(" AND t1.MUCODIGO = ?");
			params.add(municipi.getMucodigo());
		}
		if (municipi  != null  && municipi.getMunombre() != null ) {
			where.append(" AND t1.MUNOMBRE = ?");
			params.add(municipi.getMunombre());
		}
		if (municipi  != null  && municipi.getMucomu() != null ) {
			where.append(" AND t1.MUCOMU = ?");
			params.add(municipi.getMucomu());
		}
		if (municipi  != null  && municipi.getMucopv() != null ) {
			where.append(" AND t1.MUCOPV = ?");
			params.add(municipi.getMucopv());
		}

		Map<String,Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		
		return mapWhere;		
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA
	
	/**
	 * Returns a map with the needed value to create the conditions to filter by  
	 * the Municipi entity 
	 * 
	 * @param municipi Municipi
	 *            Bean with the criteria values to filter by.
     * @param startsWith Boolean	 
	 * @return Map created with two keys
	 *         key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap (Municipi municipi, Boolean startsWith){
		
		StringBuilder where = new StringBuilder(MunicipiDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (municipi  != null  && municipi.getMucodigo() != null ) {
			where.append(" AND UPPER(t1.MUCODIGO) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(municipi.getMucodigo().toUpperCase() +"%");
			}else{
				params.add("%"+municipi.getMucodigo().toUpperCase() +"%");
			}
			where.append(" AND t1.MUCODIGO IS NOT NULL");
	     }			
		if (municipi  != null  && municipi.getMunombre() != null ) {
			where.append(" AND UPPER(t1.MUNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(municipi.getMunombre().toUpperCase() +"%");
			}else{
				params.add("%"+municipi.getMunombre().toUpperCase() +"%");
			}
			where.append(" AND t1.MUNOMBRE IS NOT NULL");
	     }			
		if (municipi  != null  && municipi.getMucomu() != null ) {
			where.append(" AND UPPER(t1.MUCOMU) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(municipi.getMucomu().toUpperCase() +"%");
			}else{
				params.add("%"+municipi.getMucomu().toUpperCase() +"%");
			}
			where.append(" AND t1.MUCOMU IS NOT NULL");
	     }			
		if (municipi  != null  && municipi.getMucopv() != null ) {
			where.append(" AND UPPER(t1.MUCOPV) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(municipi.getMucopv().toUpperCase() +"%");
			}else{
				params.add("%"+municipi.getMucopv().toUpperCase() +"%");
			}
			where.append(" AND t1.MUCOPV IS NOT NULL");
	     }			

		Map<String,Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		
		return mapWhere;		
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA
	
	/**
	 * StringBuilder initilization value
	 */
	 public static final int STRING_BUILDER_INIT = 4096;}

