package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Movimientos;

/**
 * MovimientosDaoImpl  
 *  
 */
 
@Repository
@Transactional
public class MovimientosDaoImpl implements MovimientosDao {
    private JdbcTemplate jdbcTemplate;
	private RowMapper<Movimientos> rwMap = new RowMapper<Movimientos>() {
		public Movimientos mapRow(ResultSet resultSet, int rowNum) throws SQLException {
           return new Movimientos(
               resultSet.getString("SFCODIGO"), resultSet.getString("SFREFERENCIA"), resultSet.getString("SFTIPOMOV"), resultSet.getString("SFPERIODO"), resultSet.getString("SFSENTIDO"), resultSet.getDate("SFFECHAOPERACION"), resultSet.getString("SFESTADOMOV"), resultSet.getString("SFDETALLE")
           ); } } ;

	/**
     * Method use to set the datasource.
     *
     * @param dataSource DataSource
     * @return
     */
    @Resource
    public void setDataSource(DataSource dataSource) {
    	this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    /**
     * Inserts a single row in the Movimientos table.
     *
     * @param movimientos Pagination
     * @return Movimientos
     */
	public Movimientos add(Movimientos movimientos) {
    	String query = "INSERT INTO MOVIMIENTOS (SFCODIGO, SFREFERENCIA, SFTIPOMOV, SFPERIODO, SFSENTIDO, SFFECHAOPERACION, SFESTADOMOV, SFDETALLE) VALUES (?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, movimientos.getSfcodigo(), movimientos.getSfreferencia(), movimientos.getSftipomov(), movimientos.getSfperiodo(), movimientos.getSfsentido(), movimientos.getSffechaoperacion(), movimientos.getSfestadomov(), movimientos.getSfdetalle());
		return movimientos;
	}

    /**
     * Updates a single row in the Movimientos table.
     *
     * @param movimientos Pagination
     * @return Movimientos
     */
    public Movimientos update(Movimientos movimientos) {
		String query = "UPDATE MOVIMIENTOS SET SFREFERENCIA=?, SFTIPOMOV=?, SFPERIODO=?, SFSENTIDO=?, SFFECHAOPERACION=?, SFESTADOMOV=?, SFDETALLE=? WHERE SFCODIGO=?";
		this.jdbcTemplate.update(query, movimientos.getSfreferencia(), movimientos.getSftipomov(), movimientos.getSfperiodo(), movimientos.getSfsentido(), movimientos.getSffechaoperacion(), movimientos.getSfestadomov(), movimientos.getSfdetalle(), movimientos.getSfcodigo());
		return movimientos;
	}

    /**
     * Finds a single row in the Movimientos table.
     *
     * @param movimientos Pagination
     * @return Movimientos
     */
    @Transactional (readOnly = true)
    public Movimientos find(Movimientos movimientos) {
		String query = "SELECT t1.SFCODIGO SFCODIGO, t1.SFREFERENCIA SFREFERENCIA, t1.SFTIPOMOV SFTIPOMOV, t1.SFPERIODO SFPERIODO, t1.SFSENTIDO SFSENTIDO, t1.SFFECHAOPERACION SFFECHAOPERACION, t1.SFESTADOMOV SFESTADOMOV, t1.SFDETALLE SFDETALLE FROM MOVIMIENTOS t1  WHERE t1.SFCODIGO = ?  ";
		
		List<Movimientos> movimientosList = this.jdbcTemplate.query(query, this.rwMap, movimientos.getSfcodigo());
		return (Movimientos) DataAccessUtils.uniqueResult(movimientosList);
    }

    /**
     * Removes a single row in the Movimientos table.
     *
     * @param movimientos Pagination
     * @return
     */
    public void remove(Movimientos movimientos) {
		String query = "DELETE FROM MOVIMIENTOS WHERE SFCODIGO=?";
		this.jdbcTemplate.update(query, movimientos.getSfcodigo());
    }
    
   /**
    * Finds a List of rows in the Movimientos table.
    * 
    * @param movimientos Movimientos
    * @param pagination Pagination
    * @return List 
    */
	@Transactional (readOnly = true)
    public List<Movimientos> findAll(Movimientos movimientos, Pagination pagination) {
		StringBuilder query = new StringBuilder("SELECT  t1.SFCODIGO SFCODIGO,t1.SFREFERENCIA SFREFERENCIA,t1.SFTIPOMOV SFTIPOMOV,t1.SFPERIODO SFPERIODO,t1.SFSENTIDO SFSENTIDO,t1.SFFECHAOPERACION SFFECHAOPERACION,t1.SFESTADOMOV SFESTADOMOV,t1.SFDETALLE SFDETALLE "); 
		query.append("FROM MOVIMIENTOS t1 ");
		
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(movimientos); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		
		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		
		return (List<Movimientos>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}
	
    /**
     * Counts rows in the Movimientos table.
     * 
     * @param movimientos Movimientos
     * @return Long
     */
    @Transactional (readOnly = true)
    public Long findAllCount(Movimientos movimientos) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM MOVIMIENTOS t1 ");
		
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(movimientos); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);		
		
		List<?> params = (List<?>) mapaWhere.get("params");
		
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
	
	/**
	 * Finds rows in the Movimientos table using like.
     * 
     * @param movimientos Movimientos
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List 
     */
	@Transactional (readOnly = true)
    public List<Movimientos> findAllLike(Movimientos movimientos, Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT  t1.SFCODIGO SFCODIGO,t1.SFREFERENCIA SFREFERENCIA,t1.SFTIPOMOV SFTIPOMOV,t1.SFPERIODO SFPERIODO,t1.SFSENTIDO SFSENTIDO,t1.SFFECHAOPERACION SFFECHAOPERACION,t1.SFESTADOMOV SFESTADOMOV,t1.SFDETALLE SFDETALLE "); 
        query.append("FROM MOVIMIENTOS t1 ");
      	
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(movimientos,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		
		return (List<Movimientos>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}
	
	/**
	 * Counts rows in the Movimientos table using like.
     * 
     * @param movimientos Movimientos
     * @param startsWith Boolean
     * @return Long 
     */
	@Transactional (readOnly = true)
    public Long findAllLikeCount(Movimientos movimientos, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM MOVIMIENTOS t1 ");

		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(movimientos,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
	
	/**
	 * Returns a map with the needed value to create the conditions to filter by 
	 * the Movimientos entity 
	 * 
	 * @param movimientos Movimientos
	 *            Bean with the criteria values to filter by.
	 * @return Map created with two keys
	 *         key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap (Movimientos movimientos){
		
		StringBuilder where = new StringBuilder(MovimientosDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (movimientos  != null  && movimientos.getSfcodigo() != null ) {
			where.append(" AND t1.SFCODIGO = ?");
			params.add(movimientos.getSfcodigo());
		}
		if (movimientos  != null  && movimientos.getSfreferencia() != null ) {
			where.append(" AND t1.SFREFERENCIA = ?");
			params.add(movimientos.getSfreferencia());
		}
		if (movimientos  != null  && movimientos.getSftipomov() != null ) {
			where.append(" AND t1.SFTIPOMOV = ?");
			params.add(movimientos.getSftipomov());
		}
		if (movimientos  != null  && movimientos.getSfperiodo() != null ) {
			where.append(" AND t1.SFPERIODO = ?");
			params.add(movimientos.getSfperiodo());
		}
		if (movimientos  != null  && movimientos.getSfsentido() != null ) {
			where.append(" AND t1.SFSENTIDO = ?");
			params.add(movimientos.getSfsentido());
		}
		if (movimientos  != null  && movimientos.getSffechaoperacion() != null ) {
			where.append(" AND t1.SFFECHAOPERACION = ?");
			params.add(movimientos.getSffechaoperacion());
		}
		if (movimientos  != null  && movimientos.getSfestadomov() != null ) {
			where.append(" AND t1.SFESTADOMOV = ?");
			params.add(movimientos.getSfestadomov());
		}
		if (movimientos  != null  && movimientos.getSfdetalle() != null ) {
			where.append(" AND t1.SFDETALLE = ?");
			params.add(movimientos.getSfdetalle());
		}

		Map<String,Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		
		return mapWhere;		
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA
	
	/**
	 * Returns a map with the needed value to create the conditions to filter by  
	 * the Movimientos entity 
	 * 
	 * @param movimientos Movimientos
	 *            Bean with the criteria values to filter by.
     * @param startsWith Boolean	 
	 * @return Map created with two keys
	 *         key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap (Movimientos movimientos, Boolean startsWith){
		
		StringBuilder where = new StringBuilder(MovimientosDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (movimientos  != null  && movimientos.getSfcodigo() != null ) {
			where.append(" AND UPPER(t1.SFCODIGO) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(movimientos.getSfcodigo().toUpperCase() +"%");
			}else{
				params.add("%"+movimientos.getSfcodigo().toUpperCase() +"%");
			}
			where.append(" AND t1.SFCODIGO IS NOT NULL");
	     }			
		if (movimientos  != null  && movimientos.getSfreferencia() != null ) {
			where.append(" AND UPPER(t1.SFREFERENCIA) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(movimientos.getSfreferencia().toUpperCase() +"%");
			}else{
				params.add("%"+movimientos.getSfreferencia().toUpperCase() +"%");
			}
			where.append(" AND t1.SFREFERENCIA IS NOT NULL");
	     }			
		if (movimientos  != null  && movimientos.getSftipomov() != null ) {
			where.append(" AND UPPER(t1.SFTIPOMOV) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(movimientos.getSftipomov().toUpperCase() +"%");
			}else{
				params.add("%"+movimientos.getSftipomov().toUpperCase() +"%");
			}
			where.append(" AND t1.SFTIPOMOV IS NOT NULL");
	     }			
		if (movimientos  != null  && movimientos.getSfperiodo() != null ) {
			where.append(" AND UPPER(t1.SFPERIODO) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(movimientos.getSfperiodo().toUpperCase() +"%");
			}else{
				params.add("%"+movimientos.getSfperiodo().toUpperCase() +"%");
			}
			where.append(" AND t1.SFPERIODO IS NOT NULL");
	     }			
		if (movimientos  != null  && movimientos.getSfsentido() != null ) {
			where.append(" AND UPPER(t1.SFSENTIDO) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(movimientos.getSfsentido().toUpperCase() +"%");
			}else{
				params.add("%"+movimientos.getSfsentido().toUpperCase() +"%");
			}
			where.append(" AND t1.SFSENTIDO IS NOT NULL");
	     }			
		if (movimientos  != null  && movimientos.getSffechaoperacion() != null ) {
			where.append(" AND t1.SFFECHAOPERACION = ?");
			params.add(movimientos.getSffechaoperacion());
	     }			
		if (movimientos  != null  && movimientos.getSfestadomov() != null ) {
			where.append(" AND UPPER(t1.SFESTADOMOV) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(movimientos.getSfestadomov().toUpperCase() +"%");
			}else{
				params.add("%"+movimientos.getSfestadomov().toUpperCase() +"%");
			}
			where.append(" AND t1.SFESTADOMOV IS NOT NULL");
	     }			
		if (movimientos  != null  && movimientos.getSfdetalle() != null ) {
			where.append(" AND UPPER(t1.SFDETALLE) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(movimientos.getSfdetalle().toUpperCase() +"%");
			}else{
				params.add("%"+movimientos.getSfdetalle().toUpperCase() +"%");
			}
			where.append(" AND t1.SFDETALLE IS NOT NULL");
	     }			

		Map<String,Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		
		return mapWhere;		
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA
	
	/**
	 * StringBuilder initilization value
	 */
	 public static final int STRING_BUILDER_INIT = 4096;}

