package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.Movimientos;

/**
 * MovimientosDao  
 *  
 */

public interface MovimientosDao {
    
    /**
     * Inserts a single row in the Movimientos table.
     *
     * @param movimientos Movimientos
     * @return Movimientos
     */
    Movimientos add(Movimientos movimientos);

    /**
     * Updates a single row in the Movimientos table.
     *
     * @param movimientos Movimientos
     * @return Movimientos
     */
    Movimientos update(Movimientos movimientos);

    /**
     * Finds a single row in the Movimientos table.
     *
     * @param movimientos Movimientos
     * @return Movimientos
     */
    Movimientos find(Movimientos movimientos);

    /**
     * Deletes a single row in the Movimientos table.
     *
     * @param movimientos Movimientos
     * @return 
     */
    void remove(Movimientos movimientos);

    /**
     * Finds a List of rows in the Movimientos table.
     *
     * @param movimientos Movimientos
     * @param pagination Pagination
     * @return List
     */
    List<Movimientos> findAll(Movimientos movimientos, Pagination pagination);

    /**
     * Counts rows in the Movimientos table.
     *
     * @param movimientos Movimientos
     * @return Long
     */
    Long findAllCount(Movimientos movimientos);
	
	/**
     * Finds rows in the Movimientos table using like.
     *
     * @param movimientos Movimientos
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List
     */
	List<Movimientos> findAllLike(Movimientos movimientos, Pagination pagination, Boolean startsWith);
	
    /**
     * Counts rows in the Movimientos table using like.
     *
     * @param movimientos Movimientos
     * @param startsWith Boolean
     * @return Long
     */
    Long findAllLikeCount(Movimientos movimientos, Boolean startsWith);
}

