package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.MotivosSolcolaboracion;

/**
 * MotivosSolcolaboracionDaoImpl  
 *  
 */
 
@Repository
@Transactional
public class MotivosSolcolaboracionDaoImpl implements MotivosSolcolaboracionDao {
    private JdbcTemplate jdbcTemplate;
	private RowMapper<MotivosSolcolaboracion> rwMap = new RowMapper<MotivosSolcolaboracion>() {
		public MotivosSolcolaboracion mapRow(ResultSet resultSet, int rowNum) throws SQLException {
           return new MotivosSolcolaboracion(
               resultSet.getString("UO1CODIGO"), resultSet.getString("UO1MOTIVOES"), resultSet.getString("UO1MOTIVOEU")
           ); } } ;

	/**
     * Method use to set the datasource.
     *
     * @param dataSource DataSource
     * @return
     */
    @Resource
    public void setDataSource(DataSource dataSource) {
    	this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    /**
     * Inserts a single row in the MotivosSolcolaboracion table.
     *
     * @param motivossolcolaboracion Pagination
     * @return MotivosSolcolaboracion
     */
	public MotivosSolcolaboracion add(MotivosSolcolaboracion motivossolcolaboracion) {
    	String query = "INSERT INTO MOTIVOS_SOLCOLABORACION (UO1CODIGO, UO1MOTIVOES, UO1MOTIVOEU) VALUES (?,?,?)";
		this.jdbcTemplate.update(query, motivossolcolaboracion.getUo1codigo(), motivossolcolaboracion.getUo1motivoes(), motivossolcolaboracion.getUo1motivoeu());
		return motivossolcolaboracion;
	}

    /**
     * Updates a single row in the MotivosSolcolaboracion table.
     *
     * @param motivossolcolaboracion Pagination
     * @return MotivosSolcolaboracion
     */
    public MotivosSolcolaboracion update(MotivosSolcolaboracion motivossolcolaboracion) {
		String query = "UPDATE MOTIVOS_SOLCOLABORACION SET UO1MOTIVOES=?, UO1MOTIVOEU=? WHERE UO1CODIGO=?";
		this.jdbcTemplate.update(query, motivossolcolaboracion.getUo1motivoes(), motivossolcolaboracion.getUo1motivoeu(), motivossolcolaboracion.getUo1codigo());
		return motivossolcolaboracion;
	}

    /**
     * Finds a single row in the MotivosSolcolaboracion table.
     *
     * @param motivossolcolaboracion Pagination
     * @return MotivosSolcolaboracion
     */
    @Transactional (readOnly = true)
    public MotivosSolcolaboracion find(MotivosSolcolaboracion motivossolcolaboracion) {
		String query = "SELECT t1.UO1CODIGO UO1CODIGO, t1.UO1MOTIVOES UO1MOTIVOES, t1.UO1MOTIVOEU UO1MOTIVOEU FROM MOTIVOS_SOLCOLABORACION t1  WHERE t1.UO1CODIGO = ?  ";
		
		List<MotivosSolcolaboracion> motivossolcolaboracionList = this.jdbcTemplate.query(query, this.rwMap, motivossolcolaboracion.getUo1codigo());
		return (MotivosSolcolaboracion) DataAccessUtils.uniqueResult(motivossolcolaboracionList);
    }

    /**
     * Removes a single row in the MotivosSolcolaboracion table.
     *
     * @param motivossolcolaboracion Pagination
     * @return
     */
    public void remove(MotivosSolcolaboracion motivossolcolaboracion) {
		String query = "DELETE FROM MOTIVOS_SOLCOLABORACION WHERE UO1CODIGO=?";
		this.jdbcTemplate.update(query, motivossolcolaboracion.getUo1codigo());
    }
    
   /**
    * Finds a List of rows in the MotivosSolcolaboracion table.
    * 
    * @param motivossolcolaboracion MotivosSolcolaboracion
    * @param pagination Pagination
    * @return List 
    */
	@Transactional (readOnly = true)
    public List<MotivosSolcolaboracion> findAll(MotivosSolcolaboracion motivossolcolaboracion, Pagination pagination) {
		StringBuilder query = new StringBuilder("SELECT  t1.UO1CODIGO UO1CODIGO,t1.UO1MOTIVOES UO1MOTIVOES,t1.UO1MOTIVOEU UO1MOTIVOEU "); 
		query.append("FROM MOTIVOS_SOLCOLABORACION t1 ");
		
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(motivossolcolaboracion); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		
		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		
		return (List<MotivosSolcolaboracion>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}
	
    /**
     * Counts rows in the MotivosSolcolaboracion table.
     * 
     * @param motivossolcolaboracion MotivosSolcolaboracion
     * @return Long
     */
    @Transactional (readOnly = true)
    public Long findAllCount(MotivosSolcolaboracion motivossolcolaboracion) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM MOTIVOS_SOLCOLABORACION t1 ");
		
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(motivossolcolaboracion); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);		
		
		List<?> params = (List<?>) mapaWhere.get("params");
		
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
	
	/**
	 * Finds rows in the MotivosSolcolaboracion table using like.
     * 
     * @param motivossolcolaboracion MotivosSolcolaboracion
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List 
     */
	@Transactional (readOnly = true)
    public List<MotivosSolcolaboracion> findAllLike(MotivosSolcolaboracion motivossolcolaboracion, Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT  t1.UO1CODIGO UO1CODIGO,t1.UO1MOTIVOES UO1MOTIVOES,t1.UO1MOTIVOEU UO1MOTIVOEU "); 
        query.append("FROM MOTIVOS_SOLCOLABORACION t1 ");
      	
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(motivossolcolaboracion,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		
		return (List<MotivosSolcolaboracion>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}
	
	/**
	 * Counts rows in the MotivosSolcolaboracion table using like.
     * 
     * @param motivossolcolaboracion MotivosSolcolaboracion
     * @param startsWith Boolean
     * @return Long 
     */
	@Transactional (readOnly = true)
    public Long findAllLikeCount(MotivosSolcolaboracion motivossolcolaboracion, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM MOTIVOS_SOLCOLABORACION t1 ");

		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(motivossolcolaboracion,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
	
	/**
	 * Returns a map with the needed value to create the conditions to filter by 
	 * the MotivosSolcolaboracion entity 
	 * 
	 * @param motivossolcolaboracion MotivosSolcolaboracion
	 *            Bean with the criteria values to filter by.
	 * @return Map created with two keys
	 *         key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap (MotivosSolcolaboracion motivossolcolaboracion){
		
		StringBuilder where = new StringBuilder(MotivosSolcolaboracionDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (motivossolcolaboracion  != null  && motivossolcolaboracion.getUo1codigo() != null ) {
			where.append(" AND t1.UO1CODIGO = ?");
			params.add(motivossolcolaboracion.getUo1codigo());
		}
		if (motivossolcolaboracion  != null  && motivossolcolaboracion.getUo1motivoes() != null ) {
			where.append(" AND t1.UO1MOTIVOES = ?");
			params.add(motivossolcolaboracion.getUo1motivoes());
		}
		if (motivossolcolaboracion  != null  && motivossolcolaboracion.getUo1motivoeu() != null ) {
			where.append(" AND t1.UO1MOTIVOEU = ?");
			params.add(motivossolcolaboracion.getUo1motivoeu());
		}

		Map<String,Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		
		return mapWhere;		
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA
	
	/**
	 * Returns a map with the needed value to create the conditions to filter by  
	 * the MotivosSolcolaboracion entity 
	 * 
	 * @param motivossolcolaboracion MotivosSolcolaboracion
	 *            Bean with the criteria values to filter by.
     * @param startsWith Boolean	 
	 * @return Map created with two keys
	 *         key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap (MotivosSolcolaboracion motivossolcolaboracion, Boolean startsWith){
		
		StringBuilder where = new StringBuilder(MotivosSolcolaboracionDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (motivossolcolaboracion  != null  && motivossolcolaboracion.getUo1codigo() != null ) {
			where.append(" AND UPPER(t1.UO1CODIGO) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(motivossolcolaboracion.getUo1codigo().toUpperCase() +"%");
			}else{
				params.add("%"+motivossolcolaboracion.getUo1codigo().toUpperCase() +"%");
			}
			where.append(" AND t1.UO1CODIGO IS NOT NULL");
	     }			
		if (motivossolcolaboracion  != null  && motivossolcolaboracion.getUo1motivoes() != null ) {
			where.append(" AND UPPER(t1.UO1MOTIVOES) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(motivossolcolaboracion.getUo1motivoes().toUpperCase() +"%");
			}else{
				params.add("%"+motivossolcolaboracion.getUo1motivoes().toUpperCase() +"%");
			}
			where.append(" AND t1.UO1MOTIVOES IS NOT NULL");
	     }			
		if (motivossolcolaboracion  != null  && motivossolcolaboracion.getUo1motivoeu() != null ) {
			where.append(" AND UPPER(t1.UO1MOTIVOEU) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(motivossolcolaboracion.getUo1motivoeu().toUpperCase() +"%");
			}else{
				params.add("%"+motivossolcolaboracion.getUo1motivoeu().toUpperCase() +"%");
			}
			where.append(" AND t1.UO1MOTIVOEU IS NOT NULL");
	     }			

		Map<String,Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		
		return mapWhere;		
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA
	
	/**
	 * StringBuilder initilization value
	 */
	 public static final int STRING_BUILDER_INIT = 4096;}

