package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Motivo;
import com.ejie.y41b.model.ProdAgrupado;
import com.ejie.y41b.model.Producto;

/**
 * * MotivoDaoImpl  
 * 
 *  
 */
@SuppressWarnings(value = { "deprecation" })
@Repository
@Transactional
public class MotivoDaoImpl implements MotivoDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Motivo> rwMap = new RowMapper<Motivo>() {
		public Motivo mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Motivo(resultSet.getString("TIRCODIGO"),
					resultSet.getString("TIRNOMBRE"),
					resultSet.getString("TIRNOMBREE"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Motivo table.
	 * 
	 * @param motivo
	 *            Pagination
	 * @return Motivo
	 */
	public Motivo add(Motivo motivo) {

		String query = "INSERT INTO MOTIVO( TIRCODIGO,TIRNOMBRE,TIRNOMBREE)"
				+ "VALUES (?,?,?)";

		this.jdbcTemplate.update(query, motivo.getTircodigo(),
				motivo.getTirnombre(), motivo.getTirnombree());
		return motivo;
	}

	/**
	 * Updates a single row in the Motivo table.
	 * 
	 * @param motivo
	 *            Pagination
	 * @return Motivo
	 */
	public Motivo update(Motivo motivo) {
		String query = "UPDATE MOTIVO SET TIRNOMBRE=?,TIRNOMBREE=? WHERE TIRCODIGO=?";
		this.jdbcTemplate.update(query, motivo.getTirnombre(),
				motivo.getTirnombree(), motivo.getTircodigo());
		return motivo;
	}

	/**
	 * Updates a single row in the Motivo table.
	 * 
	 * @param motivo
	 *            Pagination
	 * @return Motivo
	 */
	public Motivo updateFechaBaja(Motivo motivo) {
		String query = "UPDATE MOTIVO SET TIRFECBAJA=SYSDATE WHERE TIRCODIGO=?";
		this.jdbcTemplate.update(query, motivo.getTircodigo());
		return motivo;
	}

	/**
	 * Finds a single row in the Motivo table.
	 * 
	 * @param motivo
	 *            Pagination
	 * @return Motivo
	 */
	@Transactional(readOnly = true)
	public Motivo find(Motivo motivo) {
		String query = "SELECT t1.TIRCODIGO TIRCODIGO, t1.TIRNOMBRE TIRNOMBRE, t1.TIRNOMBREE TIRNOMBREE "
				+ "FROM MOTIVO t1  " + "WHERE t1.TIRCODIGO = ?    ";
		return (Motivo) this.jdbcTemplate.queryForObject(query, rwMap,
				motivo.getTircodigo());
	}

	/**
	 * Removes a single row in the Motivo table.
	 * 
	 * @param motivo
	 *            Pagination
	 * @return
	 */
	public void remove(Motivo motivo) {
		String query = "DELETE  FROM MOTIVO WHERE TIRCODIGO=?";
		this.jdbcTemplate.update(query, motivo.getTircodigo());
	}

	/**
	 * Finds a List of rows in the Motivo table.
	 * 
	 * @param motivo
	 *            Motivo
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Motivo> findAll(Motivo motivo, Pagination pagination) {
		StringBuffer where = new StringBuffer(Y41bConstantes.NUM_3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.TIRCODIGO TIRCODIGO,t1.TIRNOMBRE TIRNOMBRE, NVL(t1.TIRNOMBREE,t1.TIRNOMBRE) TIRNOMBREE "
						+ "FROM MOTIVO t1 ");

		if (motivo != null && motivo.getTircodigo() != null) {
			where.append(" AND t1.TIRCODIGO = ?");
			params.add(motivo.getTircodigo());
		}
		if (motivo != null && motivo.getTirnombre() != null) {
			where.append(" AND t1.TIRNOMBRE = ?");
			params.add(motivo.getTirnombre());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(Y41bConstantes.NUM_3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<Motivo>) this.jdbcTemplate.query(query.toString(), rwMap,
				params.toArray());
	}

	/**
	 * Counts rows in the Motivo table.
	 * 
	 * @param motivo
	 *            Motivo
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Motivo motivo) {

		StringBuffer where = new StringBuffer(Y41bConstantes.NUM_3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  MOTIVO t1  ");
		if (motivo != null && motivo.getTircodigo() != null) {
			where.append(" AND t1.TIRCODIGO = ?");
			params.add(motivo.getTircodigo());
		}
		if (motivo != null && motivo.getTirnombre() != null) {
			where.append(" AND t1.TIRNOMBRE = ?");
			params.add(motivo.getTirnombre());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Motivo table using like.
	 * 
	 * @param motivo
	 *            Motivo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Motivo> findAllLike(Motivo motivo, Pagination pagination,
			Boolean startsWith) {
		StringBuffer where = new StringBuffer(Y41bConstantes.NUM_3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.TIRCODIGO=t2.Q9COTIR(+)	");

		StringBuffer query = new StringBuffer(
				"SELECT  distinct t1.TIRCODIGO TIRCODIGO,t1.TIRNOMBRE TIRNOMBRE, NVL(t1.TIRNOMBREE,t1.TIRNOMBRE) TIRNOMBREE "
						+ "FROM MOTIVO t1, PROD_MOTIVO t2 ");

		if (motivo != null && motivo.getTircodigo() != null) {
			where.append(" AND UPPER(t1.TIRCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(motivo.getTircodigo().toUpperCase() + "%");
			} else {
				params.add("%" + motivo.getTircodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.TIRCODIGO IS NOT NULL");
		}
		if (motivo != null && motivo.getTirnombre() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.TIRNOMBRE),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(motivo.getTirnombre().toUpperCase()
						.replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O")
						.replaceAll("", "U")
						+ "%");
			} else {
				params.add("%"
						+ motivo.getTirnombre().toUpperCase()
								.replaceAll("", "A").replaceAll("", "E")
								.replaceAll("", "I").replaceAll("", "O")
								.replaceAll("", "U") + "%");
			}
			where.append(" AND t1.TIRNOMBRE IS NOT NULL");
		}
		if (motivo != null && motivo.getTirnombree() != null) {
			where.append(" AND ((TRANSLATE(UPPER(t1.TIRNOMBREE),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(motivo.getTirnombree().toUpperCase()
						.replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O")
						.replaceAll("", "U")
						+ "%");
			} else {
				params.add("%"
						+ motivo.getTirnombree().toUpperCase()
								.replaceAll("", "A").replaceAll("", "E")
								.replaceAll("", "I").replaceAll("", "O")
								.replaceAll("", "U") + "%");
			}
			where.append(" AND t1.TIRNOMBREE IS NOT NULL) ");

			where.append(" OR (TRANSLATE(UPPER(t1.TIRNOMBRE),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(motivo.getTirnombree().toUpperCase()
						.replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O")
						.replaceAll("", "U")
						+ "%");
			} else {
				params.add("%"
						+ motivo.getTirnombree().toUpperCase()
								.replaceAll("", "A").replaceAll("", "E")
								.replaceAll("", "I").replaceAll("", "O")
								.replaceAll("", "U") + "%");
			}
			where.append(" AND t1.TIRNOMBRE IS NOT NULL AND t1.TIRNOMBREE IS NULL))");
		}
		if (motivo != null && motivo.getE8codigo() != null) {
			where.append(" AND t2.Q9COE8 = ?");
			params.add(motivo.getE8codigo());
		}

		where.append(" AND t1.TIRFECBAJA IS NULL ");

		query.append(where);

		StringBuffer order = new StringBuffer(Y41bConstantes.NUM_3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<Motivo>) this.jdbcTemplate.query(query.toString(), rwMap,
				params.toArray());
	}

	/**
	 * Counts rows in the Motivo table.
	 * 
	 * @param motivo
	 *            Motivo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Motivo motivo, Boolean startsWith) {

		StringBuffer where = new StringBuffer(Y41bConstantes.NUM_3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.TIRCODIGO=t2.Q9COTIR(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(distinct t1.TIRCODIGO) FROM MOTIVO t1, PROD_MOTIVO t2  ");
		if (motivo != null && motivo.getTircodigo() != null) {
			where.append(" AND UPPER(t1.TIRCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(motivo.getTircodigo().toUpperCase() + "%");
			} else {
				params.add("%" + motivo.getTircodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.TIRCODIGO IS NOT NULL");
		}
		if (motivo != null && motivo.getTirnombre() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.TIRNOMBRE),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(motivo.getTirnombre().toUpperCase()
						.replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O")
						.replaceAll("", "U")
						+ "%");
			} else {
				params.add("%"
						+ motivo.getTirnombre().toUpperCase()
								.replaceAll("", "A").replaceAll("", "E")
								.replaceAll("", "I").replaceAll("", "O")
								.replaceAll("", "U") + "%");
			}
			where.append(" AND t1.TIRNOMBRE IS NOT NULL");
		}
		if (motivo != null && motivo.getTirnombree() != null) {
			where.append(" AND ((TRANSLATE(UPPER(t1.TIRNOMBREE),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(motivo.getTirnombree().toUpperCase()
						.replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O")
						.replaceAll("", "U")
						+ "%");
			} else {
				params.add("%"
						+ motivo.getTirnombree().toUpperCase()
								.replaceAll("", "A").replaceAll("", "E")
								.replaceAll("", "I").replaceAll("", "O")
								.replaceAll("", "U") + "%");
			}
			where.append(" AND t1.TIRNOMBREE IS NOT NULL) ");

			where.append(" OR (TRANSLATE(UPPER(t1.TIRNOMBRE),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(motivo.getTirnombree().toUpperCase()
						.replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O")
						.replaceAll("", "U")
						+ "%");
			} else {
				params.add("%"
						+ motivo.getTirnombree().toUpperCase()
								.replaceAll("", "A").replaceAll("", "E")
								.replaceAll("", "I").replaceAll("", "O")
								.replaceAll("", "U") + "%");
			}
			where.append(" AND t1.TIRNOMBRE IS NOT NULL AND t1.TIRNOMBREE IS NULL))");
		}
		if (motivo != null && motivo.getE8codigo() != null) {
			where.append(" AND t2.Q9COE8 = ?");
			params.add(motivo.getE8codigo());
		}

		where.append(" AND t1.TIRFECBAJA IS NULL ");

		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Inserts a single row in the ProdMotivo table.
	 * 
	 * @param motivo
	 *            Motivo
	 * @return Motivo
	 */
	public Motivo addProdMotivo(Motivo motivo) {
		String query = "INSERT INTO L21Q9T00 " + "( Q9COTIR,Q9COE8) "
				+ " values (?, ?)";

		List<ProdAgrupado> auxiliarProdagrupado = motivo.getProdAgrupados();
		Iterator<ProdAgrupado> it = auxiliarProdagrupado.iterator();
		while (it.hasNext()) {
			ProdAgrupado prodagrupado = (ProdAgrupado) it.next();
			this.jdbcTemplate.update(query, motivo.getTircodigo(),
					prodagrupado.getE8codigo());
		}
		return motivo;
	}

	/**
	 * Deletes a single row in the ProdMotivo table.
	 * 
	 * @param motivo
	 *            Motivo
	 * @return
	 */
	public void removeProdMotivo(Motivo motivo) {
		String query = "DELETE  FROM L21Q9T00 "
				+ " WHERE Q9COTIR=? AND Q9COE8=?";
		List<ProdAgrupado> auxiliarProdagrupado = motivo.getProdAgrupados();
		Iterator<ProdAgrupado> it = auxiliarProdagrupado.iterator();
		while (it.hasNext()) {
			ProdAgrupado prodagrupado = (ProdAgrupado) it.next();
			this.jdbcTemplate.update(query, motivo.getTircodigo(),
					prodagrupado.getE8codigo());
		}
	}

	/**
	 * Find a single row in the findProdMotivo Many To Many relationship.
	 * 
	 * @param motivo
	 *            Motivo
	 * @param prodagrupado
	 *            ProdAgrupado
	 * @param pagination
	 *            Pagination
	 * @return Motivo
	 */
	@Transactional(readOnly = true)
	public Motivo findProdMotivo(Motivo motivo, ProdAgrupado prodagrupado,
			Pagination pagination) {

		StringBuffer where = new StringBuffer(Y41bConstantes.NUM_3000);
		List<Object> params = new ArrayList<Object>();

		where.append("where t1.Q9COE8 = t2.E8CODIGO AND t1.Q9COTIR=?");

		params.add(motivo.getTircodigo());

		if (prodagrupado.getE8codigo() != null) {
			where.append(" AND t2.E8CODIGO = ?");
			params.add(prodagrupado.getE8codigo());
		}
		if (prodagrupado.getE8nombre() != null) {
			where.append(" AND t2.E8NOMBRE = ?");
			params.add(prodagrupado.getE8nombre());
		}

		StringBuffer query = new StringBuffer(
				"SELECT t2.E8codigo E8CODIGO, t2.E8NOMBRE E8NOMBRE,NLV(t2.E8NOMBREE,t2.E8NOMBRE) E8NOMBREE FROM L21q9t00 t1,L21E8T00 t2  ");
		query.append(where);

		StringBuffer order = new StringBuffer(Y41bConstantes.NUM_3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" order by " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		List<ProdAgrupado> listaHijo = this.jdbcTemplate.query(
				query.toString(), new RowMapper<ProdAgrupado>() {
					public ProdAgrupado mapRow(ResultSet resultSet, int rowNum)
							throws SQLException {
						return new ProdAgrupado(
								resultSet.getString("E8CODIGO"), resultSet
										.getString("E8NOMBRE"), resultSet
										.getString("E8NOMBREE"));
					}
				}, params.toArray());
		motivo.setProdAgrupados(listaHijo);
		return motivo;
	}

	/**
	 * Counts rows in the ProdMotivo table.
	 * 
	 * @param motivo
	 *            Motivo
	 * @param prodagrupado
	 *            ProdAgrupado
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findProdMotivoCount(Motivo motivo, ProdAgrupado prodagrupado) {

		StringBuffer where = new StringBuffer(Y41bConstantes.NUM_3000);
		List<Object> params = new ArrayList<Object>();
		where.append("where t1.Q9COE8 = t2.E8CODIGO AND t1.Q9COTIR=?");

		params.add(motivo.getTircodigo());

		if (prodagrupado.getE8codigo() != null) {
			where.append(" AND t2.E8CODIGO = ?");
			params.add(prodagrupado.getE8codigo());
		}
		if (prodagrupado.getE8nombre() != null) {
			where.append(" AND t2.E8NOMBRE = ?");
			params.add(prodagrupado.getE8nombre());
		}

		StringBuffer query = new StringBuffer(
				"SELECT count(1) FROM L21q9t00 t1,L21E8T00 t2  ");
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds a List of rows in the Motivo table of Producto.
	 * 
	 * @param producto
	 *            Producto
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Motivo> findAllMotivoProducto(Producto producto,
			Pagination pagination) {

		StringBuffer where = new StringBuffer(Y41bConstantes.NUM_3000);
		List<Object> params = new ArrayList<Object>();

		where.append("where t3.PSCOE8 = t4.E8CODIGO AND t4.E8CODIGO = t2.Q9COE8	AND t2.Q9COTIR = t1.TIRCODIGO AND t3.PSCODIGO= ?");

		params.add(producto.getPscodigo());

		StringBuffer query = new StringBuffer(
				"SELECT t1.TIRCODIGO TIRCODIGO,t1.TIRNOMBRE TIRNOMBRE, NVL(t1.TIRNOMBREE,t1.TIRNOMBRE) TIRNOMBREE FROM MOTIVO t1, PROD_MOTIVO t2, PRODUCTO t3, PROD_AGRUPADO t4 ");
		query.append(where);

		StringBuffer order = new StringBuffer(Y41bConstantes.NUM_3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" order by " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<Motivo>) this.jdbcTemplate.query(query.toString(), rwMap,
				params.toArray());
	}

	/**
	 * Finds a List of rows in the Motivo table of Producto.
	 * 
	 * @param producto
	 *            Producto
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Motivo> findAllMotivoProductoAlta(Producto producto,
			Pagination pagination) {

		StringBuffer where = new StringBuffer(Y41bConstantes.NUM_3000);
		List<Object> params = new ArrayList<Object>();

		where.append("where t3.PSCOE8 = t4.E8CODIGO AND t4.E8CODIGO = t2.Q9COE8	AND t2.Q9COTIR = t1.TIRCODIGO AND t3.PSCODIGO= ?");

		where.append(" AND t1.TIRFECBAJA IS NULL ");

		params.add(producto.getPscodigo());

		StringBuffer query = new StringBuffer(
				"SELECT t1.TIRCODIGO TIRCODIGO,t1.TIRNOMBRE TIRNOMBRE, NVL(t1.TIRNOMBREE,t1.TIRNOMBRE) TIRNOMBREE FROM MOTIVO t1, PROD_MOTIVO t2, PRODUCTO t3, PROD_AGRUPADO t4 ");
		query.append(where);

		StringBuffer order = new StringBuffer(Y41bConstantes.NUM_3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" order by " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<Motivo>) this.jdbcTemplate.query(query.toString(), rwMap,
				params.toArray());
	}

	/**
	 * Inserts a single row in the Prod_motivo table.
	 * 
	 * @param motivo
	 *            Motivo
	 * @param codMotivoAlta
	 *            String
	 */
	public void addAllProdMotivo(Motivo motivo, String codMotivoAlta) {

		String query = "INSERT INTO PROD_MOTIVO	(Q9COTIR, Q9COE8) SELECT ?, E8CODIGO FROM ADJUNTARPRODAGRUPADO WHERE TIRCODIGO = ? ";
		this.jdbcTemplate.update(query, motivo.getTircodigo(), codMotivoAlta);
	}

	/**
	 * Deletes a single row in the ProdMotivo table.
	 * 
	 * @param motivo
	 *            Motivo
	 * @return
	 */
	public void removeAllProdMotivo(Motivo motivo) {
		String query = "DELETE  FROM PROD_MOTIVO " + " WHERE Q9COTIR=?";

		this.jdbcTemplate.update(query, motivo.getTircodigo());
	}
}
