package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Metodopago;

/**
 * MetodopagoDaoImpl  
 *  
 */
 
@Repository
@Transactional
public class MetodopagoDaoImpl implements MetodopagoDao {
    private JdbcTemplate jdbcTemplate;
	private RowMapper<Metodopago> rwMap = new RowMapper<Metodopago>() {
		public Metodopago mapRow(ResultSet resultSet, int rowNum) throws SQLException {
           return new Metodopago(
               resultSet.getString("SBCODIGO"), resultSet.getString("SBDESCES"), resultSet.getString("SBDESCEU")
           ); } } ;

	/**
     * Method use to set the datasource.
     *
     * @param dataSource DataSource
     * @return
     */
    @Resource
    public void setDataSource(DataSource dataSource) {
    	this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    /**
     * Inserts a single row in the Metodopago table.
     *
     * @param metodopago Pagination
     * @return Metodopago
     */
	public Metodopago add(Metodopago metodopago) {
    	String query = "INSERT INTO METODOPAGO (SBCODIGO, SBDESCES, SBDESCEU) VALUES (?,?,?)";
		this.jdbcTemplate.update(query, metodopago.getSbcodigo(), metodopago.getSbdesces(), metodopago.getSbdesceu());
		return metodopago;
	}

    /**
     * Updates a single row in the Metodopago table.
     *
     * @param metodopago Pagination
     * @return Metodopago
     */
    public Metodopago update(Metodopago metodopago) {
		String query = "UPDATE METODOPAGO SET SBDESCES=?, SBDESCEU=? WHERE SBCODIGO=?";
		this.jdbcTemplate.update(query, metodopago.getSbdesces(), metodopago.getSbdesceu(), metodopago.getSbcodigo());
		return metodopago;
	}

    /**
     * Finds a single row in the Metodopago table.
     *
     * @param metodopago Pagination
     * @return Metodopago
     */
    @Transactional (readOnly = true)
    public Metodopago find(Metodopago metodopago) {
		String query = "SELECT t1.SBCODIGO SBCODIGO, t1.SBDESCES SBDESCES, t1.SBDESCEU SBDESCEU FROM METODOPAGO t1  WHERE t1.SBCODIGO = ?  ";
		
		List<Metodopago> metodopagoList = this.jdbcTemplate.query(query, this.rwMap, metodopago.getSbcodigo());
		return (Metodopago) DataAccessUtils.uniqueResult(metodopagoList);
    }

    /**
     * Removes a single row in the Metodopago table.
     *
     * @param metodopago Pagination
     * @return
     */
    public void remove(Metodopago metodopago) {
		String query = "DELETE FROM METODOPAGO WHERE SBCODIGO=?";
		this.jdbcTemplate.update(query, metodopago.getSbcodigo());
    }
    
   /**
    * Finds a List of rows in the Metodopago table.
    * 
    * @param metodopago Metodopago
    * @param pagination Pagination
    * @return List 
    */
	@Transactional (readOnly = true)
    public List<Metodopago> findAll(Metodopago metodopago, Pagination pagination) {
		StringBuilder query = new StringBuilder("SELECT  t1.SBCODIGO SBCODIGO,t1.SBDESCES SBDESCES,t1.SBDESCEU SBDESCEU "); 
		query.append("FROM METODOPAGO t1 ");
		
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(metodopago); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		
		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		
		return (List<Metodopago>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}
	
    /**
     * Counts rows in the Metodopago table.
     * 
     * @param metodopago Metodopago
     * @return Long
     */
    @Transactional (readOnly = true)
    public Long findAllCount(Metodopago metodopago) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM METODOPAGO t1 ");
		
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(metodopago); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);		
		
		List<?> params = (List<?>) mapaWhere.get("params");
		
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
	
	/**
	 * Finds rows in the Metodopago table using like.
     * 
     * @param metodopago Metodopago
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List 
     */
	@Transactional (readOnly = true)
    public List<Metodopago> findAllLike(Metodopago metodopago, Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT  t1.SBCODIGO SBCODIGO,t1.SBDESCES SBDESCES,t1.SBDESCEU SBDESCEU "); 
        query.append("FROM METODOPAGO t1 ");
      	
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(metodopago,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		
		return (List<Metodopago>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}
	
	/**
	 * Counts rows in the Metodopago table using like.
     * 
     * @param metodopago Metodopago
     * @param startsWith Boolean
     * @return Long 
     */
	@Transactional (readOnly = true)
    public Long findAllLikeCount(Metodopago metodopago, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM METODOPAGO t1 ");

		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(metodopago,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
	
	/**
	 * Returns a map with the needed value to create the conditions to filter by 
	 * the Metodopago entity 
	 * 
	 * @param metodopago Metodopago
	 *            Bean with the criteria values to filter by.
	 * @return Map created with two keys
	 *         key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap (Metodopago metodopago){
		
		StringBuilder where = new StringBuilder(MetodopagoDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (metodopago  != null  && metodopago.getSbcodigo() != null ) {
			where.append(" AND t1.SBCODIGO = ?");
			params.add(metodopago.getSbcodigo());
		}
		if (metodopago  != null  && metodopago.getSbdesces() != null ) {
			where.append(" AND t1.SBDESCES = ?");
			params.add(metodopago.getSbdesces());
		}
		if (metodopago  != null  && metodopago.getSbdesceu() != null ) {
			where.append(" AND t1.SBDESCEU = ?");
			params.add(metodopago.getSbdesceu());
		}

		Map<String,Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		
		return mapWhere;		
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA
	
	/**
	 * Returns a map with the needed value to create the conditions to filter by  
	 * the Metodopago entity 
	 * 
	 * @param metodopago Metodopago
	 *            Bean with the criteria values to filter by.
     * @param startsWith Boolean	 
	 * @return Map created with two keys
	 *         key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap (Metodopago metodopago, Boolean startsWith){
		
		StringBuilder where = new StringBuilder(MetodopagoDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (metodopago  != null  && metodopago.getSbcodigo() != null ) {
			where.append(" AND UPPER(t1.SBCODIGO) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(metodopago.getSbcodigo().toUpperCase() +"%");
			}else{
				params.add("%"+metodopago.getSbcodigo().toUpperCase() +"%");
			}
			where.append(" AND t1.SBCODIGO IS NOT NULL");
	     }			
		if (metodopago  != null  && metodopago.getSbdesces() != null ) {
			where.append(" AND UPPER(t1.SBDESCES) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(metodopago.getSbdesces().toUpperCase() +"%");
			}else{
				params.add("%"+metodopago.getSbdesces().toUpperCase() +"%");
			}
			where.append(" AND t1.SBDESCES IS NOT NULL");
	     }			
		if (metodopago  != null  && metodopago.getSbdesceu() != null ) {
			where.append(" AND UPPER(t1.SBDESCEU) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(metodopago.getSbdesceu().toUpperCase() +"%");
			}else{
				params.add("%"+metodopago.getSbdesceu().toUpperCase() +"%");
			}
			where.append(" AND t1.SBDESCEU IS NOT NULL");
	     }			

		Map<String,Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		
		return mapWhere;		
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA
	
	/**
	 * StringBuilder initilization value
	 */
	 public static final int STRING_BUILDER_INIT = 4096;}

