package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.Metodopago;

/**
 * MetodopagoDao  
 *  
 */

public interface MetodopagoDao {
    
    /**
     * Inserts a single row in the Metodopago table.
     *
     * @param metodopago Metodopago
     * @return Metodopago
     */
    Metodopago add(Metodopago metodopago);

    /**
     * Updates a single row in the Metodopago table.
     *
     * @param metodopago Metodopago
     * @return Metodopago
     */
    Metodopago update(Metodopago metodopago);

    /**
     * Finds a single row in the Metodopago table.
     *
     * @param metodopago Metodopago
     * @return Metodopago
     */
    Metodopago find(Metodopago metodopago);

    /**
     * Deletes a single row in the Metodopago table.
     *
     * @param metodopago Metodopago
     * @return 
     */
    void remove(Metodopago metodopago);

    /**
     * Finds a List of rows in the Metodopago table.
     *
     * @param metodopago Metodopago
     * @param pagination Pagination
     * @return List
     */
    List<Metodopago> findAll(Metodopago metodopago, Pagination pagination);

    /**
     * Counts rows in the Metodopago table.
     *
     * @param metodopago Metodopago
     * @return Long
     */
    Long findAllCount(Metodopago metodopago);
	
	/**
     * Finds rows in the Metodopago table using like.
     *
     * @param metodopago Metodopago
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List
     */
	List<Metodopago> findAllLike(Metodopago metodopago, Pagination pagination, Boolean startsWith);
	
    /**
     * Counts rows in the Metodopago table using like.
     *
     * @param metodopago Metodopago
     * @param startsWith Boolean
     * @return Long
     */
    Long findAllLikeCount(Metodopago metodopago, Boolean startsWith);
}

