package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Mensajecola;
import com.ejie.y41b.utils.Y41bUtils;

/**
 * MensajecolaDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class MensajecolaDaoImpl implements MensajecolaDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Mensajecola> rwMap = new RowMapper<Mensajecola>() {
		public Mensajecola mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new Mensajecola(resultSet.getString("SWCODMENSAJE"), resultSet.getString("SWDTIPOMENSAJE"),
					resultSet.getString("SWDNUMEXP"), resultSet.getString("SWIDPROCEDURE"),
					resultSet.getString("SWNUMREG"), resultSet.getString("SWFECREG"), resultSet.getClob("SWMENSAJE"),
					resultSet.getDate("SWFECRECEPCION"), resultSet.getString("SWJMSMESSAGEID"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Mensajecola table.
	 * 
	 * @param mensajecola
	 *            Pagination
	 * @return Mensajecola
	 */
	public Mensajecola add(Mensajecola mensajecola) {
		String query = "INSERT INTO MENSAJECOLA (SWCODMENSAJE, SWDTIPOMENSAJE, SWDNUMEXP, SWIDPROCEDURE, SWNUMREG, SWFECREG, SWMENSAJE, SWFECRECEPCION, SWJMSMESSAGEID) VALUES (?,?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, mensajecola.getSwcodmensaje(), mensajecola.getSwdtipomensaje(),
				mensajecola.getSwdnumexp(), mensajecola.getSwidprocedure(), mensajecola.getSwnumreg(),
				mensajecola.getSwfecreg(), Y41bUtils.clobToString(mensajecola.getSwmensaje()),
				mensajecola.getSwfecrecepcion(), mensajecola.getSwjmsmessageid());
		return mensajecola;
	}

	/**
	 * Updates a single row in the Mensajecola table.
	 * 
	 * @param mensajecola
	 *            Pagination
	 * @return Mensajecola
	 */
	public Mensajecola update(Mensajecola mensajecola) {
		String query = "UPDATE MENSAJECOLA SET SWDTIPOMENSAJE=?, SWDNUMEXP=?, SWIDPROCEDURE=?, SWNUMREG=?, SWFECREG=?, SWMENSAJE=?, SWFECRECEPCION=?, SWJMSMESSAGEID=? WHERE SWCODMENSAJE=?";
		this.jdbcTemplate.update(query, mensajecola.getSwdtipomensaje(), mensajecola.getSwdnumexp(),
				mensajecola.getSwidprocedure(), mensajecola.getSwnumreg(), mensajecola.getSwfecreg(),
				mensajecola.getSwmensaje(), mensajecola.getSwfecrecepcion(), mensajecola.getSwjmsmessageid(),
				mensajecola.getSwcodmensaje());
		return mensajecola;
	}

	/**
	 * Finds a single row in the Mensajecola table.
	 * 
	 * @param mensajecola
	 *            Pagination
	 * @return Mensajecola
	 */
	@Transactional(readOnly = true)
	public Mensajecola find(Mensajecola mensajecola) {
		String query = "SELECT t1.SWCODMENSAJE SWCODMENSAJE, t1.SWDTIPOMENSAJE SWDTIPOMENSAJE, t1.SWDNUMEXP SWDNUMEXP, t1.SWIDPROCEDURE SWIDPROCEDURE, t1.SWNUMREG SWNUMREG, t1.SWFECREG SWFECREG, t1.SWMENSAJE SWMENSAJE, t1.SWFECRECEPCION SWFECRECEPCION, t1.SWJMSMESSAGEID SWJMSMESSAGEID FROM MENSAJECOLA t1  WHERE t1.SWCODMENSAJE = ?  ";

		List<Mensajecola> mensajecolaList = this.jdbcTemplate.query(query, this.rwMap, mensajecola.getSwcodmensaje());
		return (Mensajecola) DataAccessUtils.uniqueResult(mensajecolaList);
	}

	/**
	 * Removes a single row in the Mensajecola table.
	 * 
	 * @param mensajecola
	 *            Pagination
	 * @return
	 */
	public void remove(Mensajecola mensajecola) {
		String query = "DELETE FROM MENSAJECOLA WHERE SWCODMENSAJE=?";
		this.jdbcTemplate.update(query, mensajecola.getSwcodmensaje());
	}

	/**
	 * Finds a List of rows in the Mensajecola table.
	 * 
	 * @param mensajecola
	 *            Mensajecola
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Mensajecola> findAll(Mensajecola mensajecola, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.SWCODMENSAJE SWCODMENSAJE,t1.SWDTIPOMENSAJE SWDTIPOMENSAJE,t1.SWDNUMEXP SWDNUMEXP,t1.SWIDPROCEDURE SWIDPROCEDURE,t1.SWNUMREG SWNUMREG,t1.SWFECREG SWFECREG,t1.SWMENSAJE SWMENSAJE,t1.SWFECRECEPCION SWFECRECEPCION, t1.SWJMSMESSAGEID SWJMSMESSAGEID ");
		query.append("FROM MENSAJECOLA t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(mensajecola);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Mensajecola>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Mensajecola table.
	 * 
	 * @param mensajecola
	 *            Mensajecola
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Mensajecola mensajecola) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM MENSAJECOLA t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(mensajecola);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds rows in the Mensajecola table using like.
	 * 
	 * @param mensajecola
	 *            Mensajecola
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Mensajecola> findAllLike(Mensajecola mensajecola, Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.SWCODMENSAJE SWCODMENSAJE,t1.SWDTIPOMENSAJE SWDTIPOMENSAJE,t1.SWDNUMEXP SWDNUMEXP,t1.SWIDPROCEDURE SWIDPROCEDURE,t1.SWNUMREG SWNUMREG,t1.SWFECREG SWFECREG,t1.SWMENSAJE SWMENSAJE,t1.SWFECRECEPCION SWFECRECEPCION, t1.SWJMSMESSAGEID SWJMSMESSAGEID ");
		query.append("FROM MENSAJECOLA t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(mensajecola, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Mensajecola>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Mensajecola table using like.
	 * 
	 * @param mensajecola
	 *            Mensajecola
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Mensajecola mensajecola, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM MENSAJECOLA t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(mensajecola, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Mensajecola entity
	 * 
	 * @param mensajecola
	 *            Mensajecola Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Mensajecola mensajecola) {

		StringBuilder where = new StringBuilder(MensajecolaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (mensajecola != null && mensajecola.getSwcodmensaje() != null) {
			where.append(" AND t1.SWCODMENSAJE = ?");
			params.add(mensajecola.getSwcodmensaje());
		}
		if (mensajecola != null && mensajecola.getSwdtipomensaje() != null) {
			where.append(" AND t1.SWDTIPOMENSAJE = ?");
			params.add(mensajecola.getSwdtipomensaje());
		}
		if (mensajecola != null && mensajecola.getSwdnumexp() != null) {
			where.append(" AND t1.SWDNUMEXP = ?");
			params.add(mensajecola.getSwdnumexp());
		}
		if (mensajecola != null && mensajecola.getSwidprocedure() != null) {
			where.append(" AND t1.SWIDPROCEDURE = ?");
			params.add(mensajecola.getSwidprocedure());
		}
		if (mensajecola != null && mensajecola.getSwnumreg() != null) {
			where.append(" AND t1.SWNUMREG = ?");
			params.add(mensajecola.getSwnumreg());
		}
		if (mensajecola != null && mensajecola.getSwfecreg() != null) {
			where.append(" AND t1.SWFECREG = ?");
			params.add(mensajecola.getSwfecreg());
		}
		if (mensajecola != null && mensajecola.getSwfecrecepcion() != null) {
			where.append(" AND t1.SWFECRECEPCION = ?");
			params.add(mensajecola.getSwfecrecepcion());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Mensajecola entity
	 * 
	 * @param mensajecola
	 *            Mensajecola Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Mensajecola mensajecola, Boolean startsWith) {

		StringBuilder where = new StringBuilder(MensajecolaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (mensajecola != null && mensajecola.getSwcodmensaje() != null) {
			where.append(" AND UPPER(t1.SWCODMENSAJE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(mensajecola.getSwcodmensaje().toUpperCase() + "%");
			} else {
				params.add("%" + mensajecola.getSwcodmensaje().toUpperCase() + "%");
			}
			where.append(" AND t1.SWCODMENSAJE IS NOT NULL");
		}
		if (mensajecola != null && mensajecola.getSwdtipomensaje() != null) {
			where.append(" AND UPPER(t1.SWDTIPOMENSAJE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(mensajecola.getSwdtipomensaje().toUpperCase() + "%");
			} else {
				params.add("%" + mensajecola.getSwdtipomensaje().toUpperCase() + "%");
			}
			where.append(" AND t1.SWDTIPOMENSAJE IS NOT NULL");
		}
		if (mensajecola != null && mensajecola.getSwdnumexp() != null) {
			where.append(" AND UPPER(t1.SWDNUMEXP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(mensajecola.getSwdnumexp().toUpperCase() + "%");
			} else {
				params.add("%" + mensajecola.getSwdnumexp().toUpperCase() + "%");
			}
			where.append(" AND t1.SWDNUMEXP IS NOT NULL");
		}
		if (mensajecola != null && mensajecola.getSwidprocedure() != null) {
			where.append(" AND UPPER(t1.SWIDPROCEDURE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(mensajecola.getSwidprocedure().toUpperCase() + "%");
			} else {
				params.add("%" + mensajecola.getSwidprocedure().toUpperCase() + "%");
			}
			where.append(" AND t1.SWIDPROCEDURE IS NOT NULL");
		}
		if (mensajecola != null && mensajecola.getSwnumreg() != null) {
			where.append(" AND UPPER(t1.SWNUMREG) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(mensajecola.getSwnumreg().toUpperCase() + "%");
			} else {
				params.add("%" + mensajecola.getSwnumreg().toUpperCase() + "%");
			}
			where.append(" AND t1.SWNUMREG IS NOT NULL");
		}
		if (mensajecola != null && mensajecola.getSwfecreg() != null) {
			where.append(" AND UPPER(t1.SWFECREG) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(mensajecola.getSwfecreg().toUpperCase() + "%");
			} else {
				params.add("%" + mensajecola.getSwfecreg().toUpperCase() + "%");
			}
			where.append(" AND t1.SWFECREG IS NOT NULL");
		}
		if (mensajecola != null && mensajecola.getSwfecrecepcion() != null) {
			where.append(" AND t1.SWFECRECEPCION = ?");
			params.add(mensajecola.getSwfecrecepcion());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
