package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.Mensajecola;

/**
 * MensajecolaDao  
 *  
 */

public interface MensajecolaDao {
    
    /**
     * Inserts a single row in the Mensajecola table.
     *
     * @param mensajecola Mensajecola
     * @return Mensajecola
     */
    Mensajecola add(Mensajecola mensajecola);

    /**
     * Updates a single row in the Mensajecola table.
     *
     * @param mensajecola Mensajecola
     * @return Mensajecola
     */
    Mensajecola update(Mensajecola mensajecola);

    /**
     * Finds a single row in the Mensajecola table.
     *
     * @param mensajecola Mensajecola
     * @return Mensajecola
     */
    Mensajecola find(Mensajecola mensajecola);

    /**
     * Deletes a single row in the Mensajecola table.
     *
     * @param mensajecola Mensajecola
     * @return 
     */
    void remove(Mensajecola mensajecola);

    /**
     * Finds a List of rows in the Mensajecola table.
     *
     * @param mensajecola Mensajecola
     * @param pagination Pagination
     * @return List
     */
    List<Mensajecola> findAll(Mensajecola mensajecola, Pagination pagination);

    /**
     * Counts rows in the Mensajecola table.
     *
     * @param mensajecola Mensajecola
     * @return Long
     */
    Long findAllCount(Mensajecola mensajecola);
	
	/**
     * Finds rows in the Mensajecola table using like.
     *
     * @param mensajecola Mensajecola
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List
     */
	List<Mensajecola> findAllLike(Mensajecola mensajecola, Pagination pagination, Boolean startsWith);
	
    /**
     * Counts rows in the Mensajecola table using like.
     *
     * @param mensajecola Mensajecola
     * @param startsWith Boolean
     * @return Long
     */
    Long findAllLikeCount(Mensajecola mensajecola, Boolean startsWith);
}

