package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Localida;

/**
 * LocalidaDaoImpl  
 *  
 */
 
@Repository
@Transactional
public class LocalidaDaoImpl implements LocalidaDao {
    private JdbcTemplate jdbcTemplate;
	private RowMapper<Localida> rwMap = new RowMapper<Localida>() {
		public Localida mapRow(ResultSet resultSet, int rowNum) throws SQLException {
           return new Localida(
               resultSet.getString("LOCODIGO"), resultSet.getString("LOCOLO"), resultSet.getString("LOCOPV"), resultSet.getString("LOCOMU"), resultSet.getString("LOCOPA"), resultSet.getString("LONOMBRE"), resultSet.getString("LONRCOPO")
           ); } } ;

	/**
     * Method use to set the datasource.
     *
     * @param dataSource DataSource
     * @return
     */
    @Resource
    public void setDataSource(DataSource dataSource) {
    	this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    /**
     * Inserts a single row in the Localida table.
     *
     * @param localida Pagination
     * @return Localida
     */
	public Localida add(Localida localida) {
    	String query = "INSERT INTO LOCALIDA (LOCODIGO, LOCOLO, LOCOPV, LOCOMU, LOCOPA, LONOMBRE, LONRCOPO) VALUES (?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, localida.getLocodigo(), localida.getLocolo(), localida.getLocopv(), localida.getLocomu(), localida.getLocopa(), localida.getLonombre(), localida.getLonrcopo());
		return localida;
	}

    /**
     * Updates a single row in the Localida table.
     *
     * @param localida Pagination
     * @return Localida
     */
    public Localida update(Localida localida) {
		String query = "UPDATE LOCALIDA SET LOCOLO=?, LOCOPV=?, LOCOMU=?, LOCOPA=?, LONOMBRE=?, LONRCOPO=? WHERE LOCODIGO=?";
		this.jdbcTemplate.update(query, localida.getLocolo(), localida.getLocopv(), localida.getLocomu(), localida.getLocopa(), localida.getLonombre(), localida.getLonrcopo(), localida.getLocodigo());
		return localida;
	}

    /**
     * Finds a single row in the Localida table.
     *
     * @param localida Pagination
     * @return Localida
     */
    @Transactional (readOnly = true)
    public Localida find(Localida localida) {
		String query = "SELECT t1.LOCODIGO LOCODIGO, t1.LOCOLO LOCOLO, t1.LOCOPV LOCOPV, t1.LOCOMU LOCOMU, t1.LOCOPA LOCOPA, t1.LONOMBRE LONOMBRE, t1.LONRCOPO LONRCOPO FROM LOCALIDA t1  WHERE t1.LOCODIGO = ?  ";
		
		List<Localida> localidaList = this.jdbcTemplate.query(query, this.rwMap, localida.getLocodigo());
		return (Localida) DataAccessUtils.uniqueResult(localidaList);
    }

    /**
     * Removes a single row in the Localida table.
     *
     * @param localida Pagination
     * @return
     */
    public void remove(Localida localida) {
		String query = "DELETE FROM LOCALIDA WHERE LOCODIGO=?";
		this.jdbcTemplate.update(query, localida.getLocodigo());
    }
    
   /**
    * Finds a List of rows in the Localida table.
    * 
    * @param localida Localida
    * @param pagination Pagination
    * @return List 
    */
	@Transactional (readOnly = true)
    public List<Localida> findAll(Localida localida, Pagination pagination) {
		StringBuilder query = new StringBuilder("SELECT  t1.LOCODIGO LOCODIGO,t1.LOCOLO LOCOLO,t1.LOCOPV LOCOPV,t1.LOCOMU LOCOMU,t1.LOCOPA LOCOPA,t1.LONOMBRE LONOMBRE,t1.LONRCOPO LONRCOPO "); 
		query.append("FROM LOCALIDA t1 ");
		
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(localida); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		
		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		
		return (List<Localida>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}
	
    /**
     * Counts rows in the Localida table.
     * 
     * @param localida Localida
     * @return Long
     */
    @Transactional (readOnly = true)
    public Long findAllCount(Localida localida) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM LOCALIDA t1 ");
		
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(localida); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);		
		
		List<?> params = (List<?>) mapaWhere.get("params");
		
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
	
	/**
	 * Finds rows in the Localida table using like.
     * 
     * @param localida Localida
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List 
     */
	@Transactional (readOnly = true)
    public List<Localida> findAllLike(Localida localida, Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT  t1.LOCODIGO LOCODIGO,t1.LOCOLO LOCOLO,t1.LOCOPV LOCOPV,t1.LOCOMU LOCOMU,t1.LOCOPA LOCOPA,t1.LONOMBRE LONOMBRE,t1.LONRCOPO LONRCOPO "); 
        query.append("FROM LOCALIDA t1 ");
      	
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(localida,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		
		return (List<Localida>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}
	
	/**
	 * Counts rows in the Localida table using like.
     * 
     * @param localida Localida
     * @param startsWith Boolean
     * @return Long 
     */
	@Transactional (readOnly = true)
    public Long findAllLikeCount(Localida localida, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM LOCALIDA t1 ");

		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(localida,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
	
	/**
	 * Returns a map with the needed value to create the conditions to filter by 
	 * the Localida entity 
	 * 
	 * @param localida Localida
	 *            Bean with the criteria values to filter by.
	 * @return Map created with two keys
	 *         key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap (Localida localida){
		
		StringBuilder where = new StringBuilder(LocalidaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (localida  != null  && localida.getLocodigo() != null ) {
			where.append(" AND t1.LOCODIGO = ?");
			params.add(localida.getLocodigo());
		}
		if (localida  != null  && localida.getLocolo() != null ) {
			where.append(" AND t1.LOCOLO = ?");
			params.add(localida.getLocolo());
		}
		if (localida  != null  && localida.getLocopv() != null ) {
			where.append(" AND t1.LOCOPV = ?");
			params.add(localida.getLocopv());
		}
		if (localida  != null  && localida.getLocomu() != null ) {
			where.append(" AND t1.LOCOMU = ?");
			params.add(localida.getLocomu());
		}
		if (localida  != null  && localida.getLocopa() != null ) {
			where.append(" AND t1.LOCOPA = ?");
			params.add(localida.getLocopa());
		}
		if (localida  != null  && localida.getLonombre() != null ) {
			where.append(" AND t1.LONOMBRE = ?");
			params.add(localida.getLonombre());
		}
		if (localida  != null  && localida.getLonrcopo() != null ) {
			where.append(" AND t1.LONRCOPO = ?");
			params.add(localida.getLonrcopo());
		}

		Map<String,Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		
		return mapWhere;		
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA
	
	/**
	 * Returns a map with the needed value to create the conditions to filter by  
	 * the Localida entity 
	 * 
	 * @param localida Localida
	 *            Bean with the criteria values to filter by.
     * @param startsWith Boolean	 
	 * @return Map created with two keys
	 *         key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap (Localida localida, Boolean startsWith){
		
		StringBuilder where = new StringBuilder(LocalidaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (localida  != null  && localida.getLocodigo() != null ) {
			where.append(" AND UPPER(t1.LOCODIGO) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(localida.getLocodigo().toUpperCase() +"%");
			}else{
				params.add("%"+localida.getLocodigo().toUpperCase() +"%");
			}
			where.append(" AND t1.LOCODIGO IS NOT NULL");
	     }			
		if (localida  != null  && localida.getLocolo() != null ) {
			where.append(" AND UPPER(t1.LOCOLO) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(localida.getLocolo().toUpperCase() +"%");
			}else{
				params.add("%"+localida.getLocolo().toUpperCase() +"%");
			}
			where.append(" AND t1.LOCOLO IS NOT NULL");
	     }			
		if (localida  != null  && localida.getLocopv() != null ) {
			where.append(" AND UPPER(t1.LOCOPV) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(localida.getLocopv().toUpperCase() +"%");
			}else{
				params.add("%"+localida.getLocopv().toUpperCase() +"%");
			}
			where.append(" AND t1.LOCOPV IS NOT NULL");
	     }			
		if (localida  != null  && localida.getLocomu() != null ) {
			where.append(" AND UPPER(t1.LOCOMU) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(localida.getLocomu().toUpperCase() +"%");
			}else{
				params.add("%"+localida.getLocomu().toUpperCase() +"%");
			}
			where.append(" AND t1.LOCOMU IS NOT NULL");
	     }			
		if (localida  != null  && localida.getLocopa() != null ) {
			where.append(" AND UPPER(t1.LOCOPA) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(localida.getLocopa().toUpperCase() +"%");
			}else{
				params.add("%"+localida.getLocopa().toUpperCase() +"%");
			}
			where.append(" AND t1.LOCOPA IS NOT NULL");
	     }			
		if (localida  != null  && localida.getLonombre() != null ) {
			where.append(" AND UPPER(t1.LONOMBRE) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(localida.getLonombre().toUpperCase() +"%");
			}else{
				params.add("%"+localida.getLonombre().toUpperCase() +"%");
			}
			where.append(" AND t1.LONOMBRE IS NOT NULL");
	     }			
		if (localida  != null  && localida.getLonrcopo() != null ) {
			where.append(" AND UPPER(t1.LONRCOPO) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(localida.getLonrcopo().toUpperCase() +"%");
			}else{
				params.add("%"+localida.getLonrcopo().toUpperCase() +"%");
			}
			where.append(" AND t1.LONRCOPO IS NOT NULL");
	     }			

		Map<String,Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		
		return mapWhere;		
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA
	
	/**
	 * StringBuilder initilization value
	 */
	 public static final int STRING_BUILDER_INIT = 4096;}

