package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.LaudosTipo;

/**
 * LaudosTipoDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class LaudosTipoDaoImpl implements LaudosTipoDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<LaudosTipo> rwMap = new RowMapper<LaudosTipo>() {
		public LaudosTipo mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new LaudosTipo(resultSet.getString("L21R3CODIGO"),
					resultSet.getString("L21R3TIPOC"),
					resultSet.getString("L21R3TIPOE"),
					resultSet.getString("L21R3Y41B"),
					resultSet.getDate("L21R3FECALTA"),
					resultSet.getDate("L21R3FECMODIF"),
					resultSet.getString("L21R3USUALTA"),
					resultSet.getString("L21R3USUMODIF"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the LaudosTipo table.
	 * 
	 * @param laudostipo
	 *            Pagination
	 * @return LaudosTipo
	 */
	public LaudosTipo add(LaudosTipo laudostipo) {
		String query = "INSERT INTO L21.L21R3T00 (L21R3CODIGO, L21R3TIPOC, L21R3TIPOE, L21R3Y41B, L21R3FECALTA, L21R3FECMODIF, L21R3USUALTA, L21R3USUMODIF) VALUES (?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, laudostipo.getL21r3codigo(),
				laudostipo.getL21r3tipoc(), laudostipo.getL21r3tipoe(),
				laudostipo.getL21r3y41b(), laudostipo.getL21r3fecalta(),
				laudostipo.getL21r3fecmodif(), laudostipo.getL21r3usualta(),
				laudostipo.getL21r3usumodif());
		return laudostipo;
	}

	/**
	 * Updates a single row in the LaudosTipo table.
	 * 
	 * @param laudostipo
	 *            Pagination
	 * @return LaudosTipo
	 */
	public LaudosTipo update(LaudosTipo laudostipo) {
		String query = "UPDATE L21.L21R3T00 SET L21R3TIPOC=?, L21R3TIPOE=?, L21R3Y41B=?, L21R3FECALTA=?, L21R3FECMODIF=?, L21R3USUALTA=?, L21R3USUMODIF=? WHERE L21R3CODIGO=?";
		this.jdbcTemplate.update(query, laudostipo.getL21r3tipoc(),
				laudostipo.getL21r3tipoe(), laudostipo.getL21r3y41b(),
				laudostipo.getL21r3fecalta(), laudostipo.getL21r3fecmodif(),
				laudostipo.getL21r3usualta(), laudostipo.getL21r3usumodif(),
				laudostipo.getL21r3codigo());
		return laudostipo;
	}

	/**
	 * Finds a single row in the LaudosTipo table.
	 * 
	 * @param laudostipo
	 *            Pagination
	 * @return LaudosTipo
	 */
	@Transactional(readOnly = true)
	public LaudosTipo find(LaudosTipo laudostipo) {
		String query = "SELECT t1.L21R3CODIGO L21R3CODIGO, t1.L21R3TIPOC L21R3TIPOC, t1.L21R3TIPOE L21R3TIPOE, t1.L21R3Y41B L21R3Y41B, t1.L21R3FECALTA L21R3FECALTA, t1.L21R3FECMODIF L21R3FECMODIF, t1.L21R3USUALTA L21R3USUALTA, t1.L21R3USUMODIF L21R3USUMODIF FROM L21.L21R3T00 t1  WHERE t1.L21R3CODIGO = ?  ";

		List<LaudosTipo> laudostipoList = this.jdbcTemplate.query(query,
				this.rwMap, laudostipo.getL21r3codigo());
		return (LaudosTipo) DataAccessUtils.uniqueResult(laudostipoList);
	}

	/**
	 * Removes a single row in the LaudosTipo table.
	 * 
	 * @param laudostipo
	 *            Pagination
	 * @return
	 */
	public void remove(LaudosTipo laudostipo) {
		String query = "DELETE FROM L21.L21R3T00 WHERE L21R3CODIGO=?";
		this.jdbcTemplate.update(query, laudostipo.getL21r3codigo());
	}

	/**
	 * Finds a List of rows in the LaudosTipo table.
	 * 
	 * @param laudostipo
	 *            LaudosTipo
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<LaudosTipo> findAll(LaudosTipo laudostipo, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.L21R3CODIGO L21R3CODIGO,t1.L21R3TIPOC L21R3TIPOC,t1.L21R3TIPOE L21R3TIPOE,t1.L21R3Y41B L21R3Y41B,t1.L21R3FECALTA L21R3FECALTA,t1.L21R3FECMODIF L21R3FECMODIF,t1.L21R3USUALTA L21R3USUALTA,t1.L21R3USUMODIF L21R3USUMODIF ");
		query.append("FROM L21.L21R3T00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(laudostipo);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<LaudosTipo>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the LaudosTipo table.
	 * 
	 * @param laudostipo
	 *            LaudosTipo
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(LaudosTipo laudostipo) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM L21.L21R3T00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(laudostipo);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the LaudosTipo table using like.
	 * 
	 * @param laudostipo
	 *            LaudosTipo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<LaudosTipo> findAllLike(LaudosTipo laudostipo,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.L21R3CODIGO L21R3CODIGO,t1.L21R3TIPOC L21R3TIPOC,t1.L21R3TIPOE L21R3TIPOE,t1.L21R3Y41B L21R3Y41B,t1.L21R3FECALTA L21R3FECALTA,t1.L21R3FECMODIF L21R3FECMODIF,t1.L21R3USUALTA L21R3USUALTA,t1.L21R3USUMODIF L21R3USUMODIF ");
		query.append("FROM L21.L21R3T00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(laudostipo, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<LaudosTipo>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the LaudosTipo table using like.
	 * 
	 * @param laudostipo
	 *            LaudosTipo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(LaudosTipo laudostipo, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM L21.L21R3T00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(laudostipo, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the LaudosTipo entity
	 * 
	 * @param laudostipo
	 *            LaudosTipo Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(LaudosTipo laudostipo) {

		StringBuilder where = new StringBuilder(
				LaudosTipoDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (laudostipo != null && laudostipo.getL21r3codigo() != null) {
			where.append(" AND t1.L21R3CODIGO = ?");
			params.add(laudostipo.getL21r3codigo());
		}
		if (laudostipo != null && laudostipo.getL21r3tipoc() != null) {
			where.append(" AND t1.L21R3TIPOC = ?");
			params.add(laudostipo.getL21r3tipoc());
		}
		if (laudostipo != null && laudostipo.getL21r3tipoe() != null) {
			where.append(" AND t1.L21R3TIPOE = ?");
			params.add(laudostipo.getL21r3tipoe());
		}
		if (laudostipo != null && laudostipo.getL21r3y41b() != null) {
			where.append(" AND t1.L21R3Y41B = ?");
			params.add(laudostipo.getL21r3y41b());
		}
		if (laudostipo != null && laudostipo.getL21r3fecalta() != null) {
			where.append(" AND t1.L21R3FECALTA = ?");
			params.add(laudostipo.getL21r3fecalta());
		}
		if (laudostipo != null && laudostipo.getL21r3fecmodif() != null) {
			where.append(" AND t1.L21R3FECMODIF = ?");
			params.add(laudostipo.getL21r3fecmodif());
		}
		if (laudostipo != null && laudostipo.getL21r3usualta() != null) {
			where.append(" AND t1.L21R3USUALTA = ?");
			params.add(laudostipo.getL21r3usualta());
		}
		if (laudostipo != null && laudostipo.getL21r3usumodif() != null) {
			where.append(" AND t1.L21R3USUMODIF = ?");
			params.add(laudostipo.getL21r3usumodif());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the LaudosTipo entity
	 * 
	 * @param laudostipo
	 *            LaudosTipo Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(LaudosTipo laudostipo,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				LaudosTipoDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (laudostipo != null && laudostipo.getL21r3codigo() != null) {
			where.append(" AND UPPER(t1.L21R3CODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(laudostipo.getL21r3codigo().toUpperCase() + "%");
			} else {
				params.add("%" + laudostipo.getL21r3codigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.L21R3CODIGO IS NOT NULL");
		}
		if (laudostipo != null && laudostipo.getL21r3tipoc() != null) {
			where.append(" AND UPPER(t1.L21R3TIPOC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(laudostipo.getL21r3tipoc().toUpperCase() + "%");
			} else {
				params.add("%" + laudostipo.getL21r3tipoc().toUpperCase() + "%");
			}
			where.append(" AND t1.L21R3TIPOC IS NOT NULL");
		}
		if (laudostipo != null && laudostipo.getL21r3tipoe() != null) {
			where.append(" AND UPPER(t1.L21R3TIPOE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(laudostipo.getL21r3tipoe().toUpperCase() + "%");
			} else {
				params.add("%" + laudostipo.getL21r3tipoe().toUpperCase() + "%");
			}
			where.append(" AND t1.L21R3TIPOE IS NOT NULL");
		}
		if (laudostipo != null && laudostipo.getL21r3y41b() != null) {
			where.append(" AND UPPER(t1.L21R3Y41B) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(laudostipo.getL21r3y41b().toUpperCase() + "%");
			} else {
				params.add("%" + laudostipo.getL21r3y41b().toUpperCase() + "%");
			}
			where.append(" AND t1.L21R3Y41B IS NOT NULL");
		}
		if (laudostipo != null && laudostipo.getL21r3fecalta() != null) {
			where.append(" AND t1.L21R3FECALTA = ?");
			params.add(laudostipo.getL21r3fecalta());
		}
		if (laudostipo != null && laudostipo.getL21r3fecmodif() != null) {
			where.append(" AND t1.L21R3FECMODIF = ?");
			params.add(laudostipo.getL21r3fecmodif());
		}
		if (laudostipo != null && laudostipo.getL21r3usualta() != null) {
			where.append(" AND UPPER(t1.L21R3USUALTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(laudostipo.getL21r3usualta().toUpperCase() + "%");
			} else {
				params.add("%" + laudostipo.getL21r3usualta().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.L21R3USUALTA IS NOT NULL");
		}
		if (laudostipo != null && laudostipo.getL21r3usumodif() != null) {
			where.append(" AND UPPER(t1.L21R3USUMODIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(laudostipo.getL21r3usumodif().toUpperCase() + "%");
			} else {
				params.add("%" + laudostipo.getL21r3usumodif().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.L21R3USUMODIF IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
