package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.LaudosTipo;

/**
 * LaudosTipoDao  
 *  
 */

public interface LaudosTipoDao {
    
    /**
     * Inserts a single row in the LaudosTipo table.
     *
     * @param laudostipo LaudosTipo
     * @return LaudosTipo
     */
    LaudosTipo add(LaudosTipo laudostipo);

    /**
     * Updates a single row in the LaudosTipo table.
     *
     * @param laudostipo LaudosTipo
     * @return LaudosTipo
     */
    LaudosTipo update(LaudosTipo laudostipo);

    /**
     * Finds a single row in the LaudosTipo table.
     *
     * @param laudostipo LaudosTipo
     * @return LaudosTipo
     */
    LaudosTipo find(LaudosTipo laudostipo);

    /**
     * Deletes a single row in the LaudosTipo table.
     *
     * @param laudostipo LaudosTipo
     * @return 
     */
    void remove(LaudosTipo laudostipo);

    /**
     * Finds a List of rows in the LaudosTipo table.
     *
     * @param laudostipo LaudosTipo
     * @param pagination Pagination
     * @return List
     */
    List<LaudosTipo> findAll(LaudosTipo laudostipo, Pagination pagination);

    /**
     * Counts rows in the LaudosTipo table.
     *
     * @param laudostipo LaudosTipo
     * @return Long
     */
    Long findAllCount(LaudosTipo laudostipo);
	
	/**
     * Finds rows in the LaudosTipo table using like.
     *
     * @param laudostipo LaudosTipo
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List
     */
	List<LaudosTipo> findAllLike(LaudosTipo laudostipo, Pagination pagination, Boolean startsWith);
	
    /**
     * Counts rows in the LaudosTipo table using like.
     *
     * @param laudostipo LaudosTipo
     * @param startsWith Boolean
     * @return Long
     */
    Long findAllLikeCount(LaudosTipo laudostipo, Boolean startsWith);
}

