package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.LaudosAdoptado;

/**
 * LaudosAdoptadoDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class LaudosAdoptadoDaoImpl implements LaudosAdoptadoDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<LaudosAdoptado> rwMap = new RowMapper<LaudosAdoptado>() {
		public LaudosAdoptado mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new LaudosAdoptado(resultSet.getString("L21R4CODIGO"),
					resultSet.getString("L21R4ADOPTADOC"),
					resultSet.getString("L21R4ADOPTADOE"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the LaudosAdoptado table.
	 * 
	 * @param laudosadoptado
	 *            Pagination
	 * @return LaudosAdoptado
	 */
	public LaudosAdoptado add(LaudosAdoptado laudosadoptado) {
		String query = "INSERT INTO L21.L21R4T00 (L21R4CODIGO, L21R4ADOPTADOC, L21R4ADOPTADOE) VALUES (?,?,?)";
		this.jdbcTemplate.update(query, laudosadoptado.getL21r4codigo(),
				laudosadoptado.getL21r4adoptadoc(),
				laudosadoptado.getL21r4adoptadoe());
		return laudosadoptado;
	}

	/**
	 * Updates a single row in the LaudosAdoptado table.
	 * 
	 * @param laudosadoptado
	 *            Pagination
	 * @return LaudosAdoptado
	 */
	public LaudosAdoptado update(LaudosAdoptado laudosadoptado) {
		String query = "UPDATE L21.L21R4T00 SET L21R4ADOPTADOC=?, L21R4ADOPTADOE=? WHERE L21R4CODIGO=?";
		this.jdbcTemplate.update(query, laudosadoptado.getL21r4adoptadoc(),
				laudosadoptado.getL21r4adoptadoe(),
				laudosadoptado.getL21r4codigo());
		return laudosadoptado;
	}

	/**
	 * Finds a single row in the LaudosAdoptado table.
	 * 
	 * @param laudosadoptado
	 *            Pagination
	 * @return LaudosAdoptado
	 */
	@Transactional(readOnly = true)
	public LaudosAdoptado find(LaudosAdoptado laudosadoptado) {
		String query = "SELECT t1.L21R4CODIGO L21R4CODIGO, t1.L21R4ADOPTADOC L21R4ADOPTADOC, t1.L21R4ADOPTADOE L21R4ADOPTADOE FROM L21.L21R4T00 t1  WHERE t1.L21R4CODIGO = ?  ";

		List<LaudosAdoptado> laudosadoptadoList = this.jdbcTemplate.query(
				query, this.rwMap, laudosadoptado.getL21r4codigo());
		return (LaudosAdoptado) DataAccessUtils
				.uniqueResult(laudosadoptadoList);
	}

	/**
	 * Removes a single row in the LaudosAdoptado table.
	 * 
	 * @param laudosadoptado
	 *            Pagination
	 * @return
	 */
	public void remove(LaudosAdoptado laudosadoptado) {
		String query = "DELETE FROM L21.L21R4T00 WHERE L21R4CODIGO=?";
		this.jdbcTemplate.update(query, laudosadoptado.getL21r4codigo());
	}

	/**
	 * Finds a List of rows in the LaudosAdoptado table.
	 * 
	 * @param laudosadoptado
	 *            LaudosAdoptado
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<LaudosAdoptado> findAll(LaudosAdoptado laudosadoptado,
			Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.L21R4CODIGO L21R4CODIGO,t1.L21R4ADOPTADOC L21R4ADOPTADOC,t1.L21R4ADOPTADOE L21R4ADOPTADOE ");
		query.append("FROM L21.L21R4T00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(laudosadoptado);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<LaudosAdoptado>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the LaudosAdoptado table.
	 * 
	 * @param laudosadoptado
	 *            LaudosAdoptado
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(LaudosAdoptado laudosadoptado) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM L21.L21R4T00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(laudosadoptado);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the LaudosAdoptado table using like.
	 * 
	 * @param laudosadoptado
	 *            LaudosAdoptado
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<LaudosAdoptado> findAllLike(LaudosAdoptado laudosadoptado,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.L21R4CODIGO L21R4CODIGO,t1.L21R4ADOPTADOC L21R4ADOPTADOC,t1.L21R4ADOPTADOE L21R4ADOPTADOE ");
		query.append("FROM L21.L21R4T00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(laudosadoptado,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<LaudosAdoptado>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the LaudosAdoptado table using like.
	 * 
	 * @param laudosadoptado
	 *            LaudosAdoptado
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(LaudosAdoptado laudosadoptado,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM L21.L21R4T00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(laudosadoptado,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the LaudosAdoptado entity
	 * 
	 * @param laudosadoptado
	 *            LaudosAdoptado Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(LaudosAdoptado laudosadoptado) {

		StringBuilder where = new StringBuilder(
				LaudosAdoptadoDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (laudosadoptado != null && laudosadoptado.getL21r4codigo() != null) {
			where.append(" AND t1.L21R4CODIGO = ?");
			params.add(laudosadoptado.getL21r4codigo());
		}
		if (laudosadoptado != null
				&& laudosadoptado.getL21r4adoptadoc() != null) {
			where.append(" AND t1.L21R4ADOPTADOC = ?");
			params.add(laudosadoptado.getL21r4adoptadoc());
		}
		if (laudosadoptado != null
				&& laudosadoptado.getL21r4adoptadoe() != null) {
			where.append(" AND t1.L21R4ADOPTADOE = ?");
			params.add(laudosadoptado.getL21r4adoptadoe());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the LaudosAdoptado entity
	 * 
	 * @param laudosadoptado
	 *            LaudosAdoptado Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(LaudosAdoptado laudosadoptado,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				LaudosAdoptadoDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (laudosadoptado != null && laudosadoptado.getL21r4codigo() != null) {
			where.append(" AND UPPER(t1.L21R4CODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(laudosadoptado.getL21r4codigo().toUpperCase() + "%");
			} else {
				params.add("%" + laudosadoptado.getL21r4codigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.L21R4CODIGO IS NOT NULL");
		}
		if (laudosadoptado != null
				&& laudosadoptado.getL21r4adoptadoc() != null) {
			where.append(" AND UPPER(t1.L21R4ADOPTADOC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(laudosadoptado.getL21r4adoptadoc().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ laudosadoptado.getL21r4adoptadoc().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.L21R4ADOPTADOC IS NOT NULL");
		}
		if (laudosadoptado != null
				&& laudosadoptado.getL21r4adoptadoe() != null) {
			where.append(" AND UPPER(t1.L21R4ADOPTADOE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(laudosadoptado.getL21r4adoptadoe().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ laudosadoptado.getL21r4adoptadoe().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.L21R4ADOPTADOE IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
