package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Laboratorio;

/**
 * LaboratorioDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class LaboratorioDaoImpl implements LaboratorioDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Laboratorio> rwMap = new RowMapper<Laboratorio>() {
		public Laboratorio mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Laboratorio(resultSet.getString("LACODIGO"),
					resultSet.getString("LANOMBRE"),
					resultSet.getString("LANODIR"),
					resultSet.getString("LACOLO"),
					resultSet.getString("LANRCOPO"),
					resultSet.getString("LANRTEL"),
					resultSet.getString("LANRFAX"),
					resultSet.getString("NORAPROVINCIAID"),
					resultSet.getString("NOMBREPROVINCIA"),
					resultSet.getString("NORAMUNICIPIOID"),
					resultSet.getString("NOMBREMUNICIPIO"),
					resultSet.getString("NORALOCALIDADID"),
					resultSet.getString("NOMBRELOCALIDAD"),
					resultSet.getString("NORACALLEID"),
					resultSet.getString("NOMBRECALLE"),
					resultSet.getString("NORACPID"),
					resultSet.getString("NOMBRECP"),
					resultSet.getString("NORAPORTALID"),
					resultSet.getString("NOMBREPORTAL"),
					resultSet.getString("NOMBREPISO"),
					resultSet.getString("DIRECCIONNOCAPV"),
					resultSet.getString("EXTRANJERO"),
					resultSet.getString("NORAPAISID"),
					resultSet.getString("NOMBREPAIS"),
					resultSet.getString("LAMAIL"),
					resultSet.getString("LANRTEL2"),
					resultSet.getString("LADESCRIPCION"),
					resultSet.getDate("LAFECHABAJA"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Laboratorio table.
	 * 
	 * @param laboratorio
	 *            Pagination
	 * @return Laboratorio
	 */
	public Laboratorio add(Laboratorio laboratorio) {
		String query = "INSERT INTO LABORATORIO (LACODIGO, LANOMBRE, LANODIR, LACOLO, LANRCOPO, LANRTEL, LANRFAX, NORA_PROVINCIA_ID, NOMBRE_PROVINCIA, NORA_MUNICIPIO_ID, NOMBRE_MUNICIPIO, NORA_LOCALIDAD_ID, NOMBRE_LOCALIDAD, NORA_CALLE_ID, NOMBRE_CALLE, NORA_CP_ID, NOMBRE_CP, NORA_PORTAL_ID, NOMBRE_PORTAL, NOMBRE_PISO, DIRECCION_NOCAPV, EXTRANJERO, NORA_PAIS_ID, NOMBRE_PAIS, LAMAIL, LANRTEL2, LADESCRIPCION, LAFECHABAJA) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, laboratorio.getLacodigo(),
				laboratorio.getLanombre(), laboratorio.getLanodir(),
				laboratorio.getLacolo(), laboratorio.getLanrcopo(),
				laboratorio.getLanrtel(), laboratorio.getLanrfax(),
				laboratorio.getNoraProvinciaId(),
				laboratorio.getNombreProvincia(),
				laboratorio.getNoraMunicipioId(),
				laboratorio.getNombreMunicipio(),
				laboratorio.getNoraLocalidadId(),
				laboratorio.getNombreLocalidad(), laboratorio.getNoraCalleId(),
				laboratorio.getNombreCalle(), laboratorio.getNoraCpId(),
				laboratorio.getNombreCp(), laboratorio.getNoraPortalId(),
				laboratorio.getNombrePortal(), laboratorio.getNombrePiso(),
				laboratorio.getDireccionNocapv(), laboratorio.getExtranjero(),
				laboratorio.getNoraPaisId(), laboratorio.getNombrePais(),
				laboratorio.getLamail(), laboratorio.getLanrtel2(),
				laboratorio.getLadescripcion(), laboratorio.getLafechabaja());
		return laboratorio;
	}

	/**
	 * Updates a single row in the Laboratorio table.
	 * 
	 * @param laboratorio
	 *            Pagination
	 * @return Laboratorio
	 */
	public Laboratorio update(Laboratorio laboratorio) {
		String query = "UPDATE LABORATORIO SET LANOMBRE=?, LANRTEL=?, LANRFAX=?, NORA_PROVINCIA_ID=?, NOMBRE_PROVINCIA=?, NORA_MUNICIPIO_ID=?, NOMBRE_MUNICIPIO=?, NORA_LOCALIDAD_ID=?, NOMBRE_LOCALIDAD=?, NORA_CALLE_ID=?, NOMBRE_CALLE=?, NORA_CP_ID=?, NOMBRE_CP=?, NORA_PORTAL_ID=?, NOMBRE_PORTAL=?, NOMBRE_PISO=?, DIRECCION_NOCAPV=?, EXTRANJERO=?, NORA_PAIS_ID=?, NOMBRE_PAIS=?, LAMAIL=?, LANRTEL2=?, LADESCRIPCION=?, LAFECHABAJA=? WHERE LACODIGO=?";
		this.jdbcTemplate.update(query, laboratorio.getLanombre(),
				laboratorio.getLanrtel(), laboratorio.getLanrfax(),
				laboratorio.getNoraProvinciaId(),
				laboratorio.getNombreProvincia(),
				laboratorio.getNoraMunicipioId(),
				laboratorio.getNombreMunicipio(),
				laboratorio.getNoraLocalidadId(),
				laboratorio.getNombreLocalidad(), laboratorio.getNoraCalleId(),
				laboratorio.getNombreCalle(), laboratorio.getNoraCpId(),
				laboratorio.getNombreCp(), laboratorio.getNoraPortalId(),
				laboratorio.getNombrePortal(), laboratorio.getNombrePiso(),
				laboratorio.getDireccionNocapv(), laboratorio.getExtranjero(),
				laboratorio.getNoraPaisId(), laboratorio.getNombrePais(),
				laboratorio.getLamail(), laboratorio.getLanrtel2(),
				laboratorio.getLadescripcion(), laboratorio.getLafechabaja(),
				laboratorio.getLacodigo());
		return laboratorio;
	}

	/**
	 * Updates a single row in the Laboratorio table.
	 * 
	 * @param laboratorio
	 *            Pagination
	 * @return Laboratorio
	 */
	public Laboratorio updateFechaBaja(Laboratorio laboratorio) {
		String query = "UPDATE LABORATORIO SET LAFECHABAJA=SYSDATE WHERE LACODIGO=?";
		this.jdbcTemplate.update(query, laboratorio.getLacodigo());
		return laboratorio;
	}

	/**
	 * Finds a single row in the Laboratorio table.
	 * 
	 * @param laboratorio
	 *            Pagination
	 * @return Laboratorio
	 */
	@Transactional(readOnly = true)
	public Laboratorio findNextPK(Laboratorio laboratorio) {
		String query = "SELECT 'LAB'||LPAD(NVL(max(SUBSTR(LACODIGO,4,5)),0)+1, 2, '0') LACODIGO FROM LABORATORIO ";

		List<Laboratorio> laboratorioList = this.jdbcTemplate.query(query,
				new RowMapper<Laboratorio>() {
					public Laboratorio mapRow(ResultSet resultSet, int rowNum)
							throws SQLException {
						return new Laboratorio(resultSet.getString("LACODIGO"));
					}
				});
		return (Laboratorio) DataAccessUtils.uniqueResult(laboratorioList);
	}

	/**
	 * Finds a single row in the Laboratorio table.
	 * 
	 * @param laboratorio
	 *            Pagination
	 * @return Laboratorio
	 */
	@Transactional(readOnly = true)
	public Laboratorio find(Laboratorio laboratorio) {
		String query = "SELECT t1.LACODIGO LACODIGO, t1.LANOMBRE LANOMBRE, t1.LANODIR LANODIR, t1.LACOLO LACOLO, t1.LANRCOPO LANRCOPO, t1.LANRTEL LANRTEL, t1.LANRFAX LANRFAX, t1.NORA_PROVINCIA_ID NORAPROVINCIAID, t1.NOMBRE_PROVINCIA NOMBREPROVINCIA, t1.NORA_MUNICIPIO_ID NORAMUNICIPIOID, t1.NOMBRE_MUNICIPIO NOMBREMUNICIPIO, t1.NORA_LOCALIDAD_ID NORALOCALIDADID, t1.NOMBRE_LOCALIDAD NOMBRELOCALIDAD, t1.NORA_CALLE_ID NORACALLEID, t1.NOMBRE_CALLE NOMBRECALLE, t1.NORA_CP_ID NORACPID, t1.NOMBRE_CP NOMBRECP, t1.NORA_PORTAL_ID NORAPORTALID, t1.NOMBRE_PORTAL NOMBREPORTAL, t1.NOMBRE_PISO NOMBREPISO, t1.DIRECCION_NOCAPV DIRECCIONNOCAPV, t1.EXTRANJERO EXTRANJERO, t1.NORA_PAIS_ID NORAPAISID, t1.NOMBRE_PAIS NOMBREPAIS, t1.LAMAIL LAMAIL, t1.LANRTEL2 LANRTEL2, t1.LADESCRIPCION LADESCRIPCION, t1.LAFECHABAJA LAFECHABAJA FROM LABORATORIO t1  WHERE t1.LACODIGO = ?  ";

		List<Laboratorio> laboratorioList = this.jdbcTemplate.query(query,
				this.rwMap, laboratorio.getLacodigo());
		return (Laboratorio) DataAccessUtils.uniqueResult(laboratorioList);
	}

	/**
	 * Removes a single row in the Laboratorio table.
	 * 
	 * @param laboratorio
	 *            Pagination
	 * @return
	 */
	public void remove(Laboratorio laboratorio) {
		String query = "DELETE FROM LABORATORIO WHERE LACODIGO=?";
		this.jdbcTemplate.update(query, laboratorio.getLacodigo());
	}

	/**
	 * Finds a List of rows in the Laboratorio table.
	 * 
	 * @param laboratorio
	 *            Laboratorio
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Laboratorio> findAll(Laboratorio laboratorio,
			Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.LACODIGO LACODIGO,t1.LANOMBRE LANOMBRE,t1.LANODIR LANODIR,t1.LACOLO LACOLO,t1.LANRCOPO LANRCOPO,t1.LANRTEL LANRTEL,t1.LANRFAX LANRFAX,t1.NORA_PROVINCIA_ID NORAPROVINCIAID,t1.NOMBRE_PROVINCIA NOMBREPROVINCIA,t1.NORA_MUNICIPIO_ID NORAMUNICIPIOID,t1.NOMBRE_MUNICIPIO NOMBREMUNICIPIO,t1.NORA_LOCALIDAD_ID NORALOCALIDADID,t1.NOMBRE_LOCALIDAD NOMBRELOCALIDAD,t1.NORA_CALLE_ID NORACALLEID,t1.NOMBRE_CALLE NOMBRECALLE,t1.NORA_CP_ID NORACPID,t1.NOMBRE_CP NOMBRECP,t1.NORA_PORTAL_ID NORAPORTALID,t1.NOMBRE_PORTAL NOMBREPORTAL,t1.NOMBRE_PISO NOMBREPISO,t1.DIRECCION_NOCAPV DIRECCIONNOCAPV,t1.EXTRANJERO EXTRANJERO,t1.NORA_PAIS_ID NORAPAISID,t1.NOMBRE_PAIS NOMBREPAIS,t1.LAMAIL LAMAIL,t1.LANRTEL2 LANRTEL2,t1.LADESCRIPCION LADESCRIPCION,t1.LAFECHABAJA LAFECHABAJA ");
		query.append("FROM LABORATORIO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(laboratorio);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Laboratorio>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Laboratorio table.
	 * 
	 * @param laboratorio
	 *            Laboratorio
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Laboratorio laboratorio) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM LABORATORIO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(laboratorio);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Laboratorio table using like.
	 * 
	 * @param laboratorio
	 *            Laboratorio
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Laboratorio> findAllLike(Laboratorio laboratorio,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.LACODIGO LACODIGO,t1.LANOMBRE LANOMBRE,t1.LANODIR LANODIR,t1.LACOLO LACOLO,t1.LANRCOPO LANRCOPO,t1.LANRTEL LANRTEL,t1.LANRFAX LANRFAX,t1.NORA_PROVINCIA_ID NORAPROVINCIAID,t1.NOMBRE_PROVINCIA NOMBREPROVINCIA,t1.NORA_MUNICIPIO_ID NORAMUNICIPIOID,t1.NOMBRE_MUNICIPIO NOMBREMUNICIPIO,t1.NORA_LOCALIDAD_ID NORALOCALIDADID,t1.NOMBRE_LOCALIDAD NOMBRELOCALIDAD,t1.NORA_CALLE_ID NORACALLEID,t1.NOMBRE_CALLE NOMBRECALLE,t1.NORA_CP_ID NORACPID,t1.NOMBRE_CP NOMBRECP,t1.NORA_PORTAL_ID NORAPORTALID,t1.NOMBRE_PORTAL NOMBREPORTAL,t1.NOMBRE_PISO NOMBREPISO,t1.DIRECCION_NOCAPV DIRECCIONNOCAPV,t1.EXTRANJERO EXTRANJERO,t1.NORA_PAIS_ID NORAPAISID,t1.NOMBRE_PAIS NOMBREPAIS,t1.LAMAIL LAMAIL,t1.LANRTEL2 LANRTEL2,t1.LADESCRIPCION LADESCRIPCION,t1.LAFECHABAJA LAFECHABAJA ");
		query.append("FROM LABORATORIO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(laboratorio, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Laboratorio>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Laboratorio table using like.
	 * 
	 * @param laboratorio
	 *            Laboratorio
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Laboratorio laboratorio, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM LABORATORIO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(laboratorio, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Laboratorio entity
	 * 
	 * @param laboratorio
	 *            Laboratorio Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Laboratorio laboratorio) {

		StringBuilder where = new StringBuilder(
				LaboratorioDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (laboratorio != null && laboratorio.getLacodigo() != null) {
			where.append(" AND t1.LACODIGO = ?");
			params.add(laboratorio.getLacodigo());
		}
		if (laboratorio != null && laboratorio.getLanombre() != null) {
			where.append(" AND t1.LANOMBRE = ?");
			params.add(laboratorio.getLanombre());
		}
		if (laboratorio != null && laboratorio.getLanodir() != null) {
			where.append(" AND t1.LANODIR = ?");
			params.add(laboratorio.getLanodir());
		}
		if (laboratorio != null && laboratorio.getLacolo() != null) {
			where.append(" AND t1.LACOLO = ?");
			params.add(laboratorio.getLacolo());
		}
		if (laboratorio != null && laboratorio.getLanrcopo() != null) {
			where.append(" AND t1.LANRCOPO = ?");
			params.add(laboratorio.getLanrcopo());
		}
		if (laboratorio != null && laboratorio.getLanrtel() != null) {
			where.append(" AND t1.LANRTEL = ?");
			params.add(laboratorio.getLanrtel());
		}
		if (laboratorio != null && laboratorio.getLanrfax() != null) {
			where.append(" AND t1.LANRFAX = ?");
			params.add(laboratorio.getLanrfax());
		}
		if (laboratorio != null && laboratorio.getNoraProvinciaId() != null) {
			where.append(" AND t1.NORA_PROVINCIA_ID = ?");
			params.add(laboratorio.getNoraProvinciaId());
		}
		if (laboratorio != null && laboratorio.getNombreProvincia() != null) {
			where.append(" AND t1.NOMBRE_PROVINCIA = ?");
			params.add(laboratorio.getNombreProvincia());
		}
		if (laboratorio != null && laboratorio.getNoraMunicipioId() != null) {
			where.append(" AND t1.NORA_MUNICIPIO_ID = ?");
			params.add(laboratorio.getNoraMunicipioId());
		}
		if (laboratorio != null && laboratorio.getNombreMunicipio() != null) {
			where.append(" AND t1.NOMBRE_MUNICIPIO = ?");
			params.add(laboratorio.getNombreMunicipio());
		}
		if (laboratorio != null && laboratorio.getNoraLocalidadId() != null) {
			where.append(" AND t1.NORA_LOCALIDAD_ID = ?");
			params.add(laboratorio.getNoraLocalidadId());
		}
		if (laboratorio != null && laboratorio.getNombreLocalidad() != null) {
			where.append(" AND t1.NOMBRE_LOCALIDAD = ?");
			params.add(laboratorio.getNombreLocalidad());
		}
		if (laboratorio != null && laboratorio.getNoraCalleId() != null) {
			where.append(" AND t1.NORA_CALLE_ID = ?");
			params.add(laboratorio.getNoraCalleId());
		}
		if (laboratorio != null && laboratorio.getNombreCalle() != null) {
			where.append(" AND t1.NOMBRE_CALLE = ?");
			params.add(laboratorio.getNombreCalle());
		}
		if (laboratorio != null && laboratorio.getNoraCpId() != null) {
			where.append(" AND t1.NORA_CP_ID = ?");
			params.add(laboratorio.getNoraCpId());
		}
		if (laboratorio != null && laboratorio.getNombreCp() != null) {
			where.append(" AND t1.NOMBRE_CP = ?");
			params.add(laboratorio.getNombreCp());
		}
		if (laboratorio != null && laboratorio.getNoraPortalId() != null) {
			where.append(" AND t1.NORA_PORTAL_ID = ?");
			params.add(laboratorio.getNoraPortalId());
		}
		if (laboratorio != null && laboratorio.getNombrePortal() != null) {
			where.append(" AND t1.NOMBRE_PORTAL = ?");
			params.add(laboratorio.getNombrePortal());
		}
		if (laboratorio != null && laboratorio.getNombrePiso() != null) {
			where.append(" AND t1.NOMBRE_PISO = ?");
			params.add(laboratorio.getNombrePiso());
		}
		if (laboratorio != null && laboratorio.getDireccionNocapv() != null) {
			where.append(" AND t1.DIRECCION_NOCAPV = ?");
			params.add(laboratorio.getDireccionNocapv());
		}
		if (laboratorio != null && laboratorio.getExtranjero() != null) {
			where.append(" AND t1.EXTRANJERO = ?");
			params.add(laboratorio.getExtranjero());
		}
		if (laboratorio != null && laboratorio.getNoraPaisId() != null) {
			where.append(" AND t1.NORA_PAIS_ID = ?");
			params.add(laboratorio.getNoraPaisId());
		}
		if (laboratorio != null && laboratorio.getNombrePais() != null) {
			where.append(" AND t1.NOMBRE_PAIS = ?");
			params.add(laboratorio.getNombrePais());
		}
		if (laboratorio != null && laboratorio.getLamail() != null) {
			where.append(" AND t1.LAMAIL = ?");
			params.add(laboratorio.getLamail());
		}
		if (laboratorio != null && laboratorio.getLanrtel2() != null) {
			where.append(" AND t1.LANRTEL2 = ?");
			params.add(laboratorio.getLanrtel2());
		}

		where.append(" AND t1.LAFECHABAJA IS NULL ");

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Laboratorio entity
	 * 
	 * @param laboratorio
	 *            Laboratorio Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Laboratorio laboratorio,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				LaboratorioDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (laboratorio != null && laboratorio.getLacodigo() != null) {
			where.append(" AND UPPER(t1.LACODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(laboratorio.getLacodigo().toUpperCase() + "%");
			} else {
				params.add("%" + laboratorio.getLacodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.LACODIGO IS NOT NULL");
		}
		if (laboratorio != null && laboratorio.getLanombre() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.LANOMBRE),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(laboratorio.getLanombre().toUpperCase()
						.replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O")
						.replaceAll("", "U")
						+ "%");
			} else {
				params.add("%"
						+ laboratorio.getLanombre().toUpperCase()
								.replaceAll("", "A").replaceAll("", "E")
								.replaceAll("", "I").replaceAll("", "O")
								.replaceAll("", "U") + "%");
			}
			where.append(" AND t1.LANOMBRE IS NOT NULL");
		}
		if (laboratorio != null && laboratorio.getLadescripcion() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.LADESCRIPCION),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(laboratorio.getLadescripcion().toUpperCase()
						.replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O")
						.replaceAll("", "U")
						+ "%");
			} else {
				params.add("%"
						+ laboratorio.getLadescripcion().toUpperCase()
								.replaceAll("", "A").replaceAll("", "E")
								.replaceAll("", "I").replaceAll("", "O")
								.replaceAll("", "U") + "%");
			}
			where.append(" AND t1.LADESCRIPCION IS NOT NULL");
		}
		if (laboratorio != null && laboratorio.getLanodir() != null) {
			where.append(" AND UPPER(t1.LANODIR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(laboratorio.getLanodir().toUpperCase() + "%");
			} else {
				params.add("%" + laboratorio.getLanodir().toUpperCase() + "%");
			}
			where.append(" AND t1.LANODIR IS NOT NULL");
		}
		if (laboratorio != null && laboratorio.getLacolo() != null) {
			where.append(" AND UPPER(t1.LACOLO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(laboratorio.getLacolo().toUpperCase() + "%");
			} else {
				params.add("%" + laboratorio.getLacolo().toUpperCase() + "%");
			}
			where.append(" AND t1.LACOLO IS NOT NULL");
		}
		if (laboratorio != null && laboratorio.getLanrcopo() != null) {
			where.append(" AND UPPER(t1.LANRCOPO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(laboratorio.getLanrcopo().toUpperCase() + "%");
			} else {
				params.add("%" + laboratorio.getLanrcopo().toUpperCase() + "%");
			}
			where.append(" AND t1.LANRCOPO IS NOT NULL");
		}
		if (laboratorio != null && laboratorio.getLanrtel() != null) {
			where.append(" AND UPPER(t1.LANRTEL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(laboratorio.getLanrtel().toUpperCase() + "%");
			} else {
				params.add("%" + laboratorio.getLanrtel().toUpperCase() + "%");
			}
			where.append(" AND t1.LANRTEL IS NOT NULL");
		}
		if (laboratorio != null && laboratorio.getLanrfax() != null) {
			where.append(" AND UPPER(t1.LANRFAX) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(laboratorio.getLanrfax().toUpperCase() + "%");
			} else {
				params.add("%" + laboratorio.getLanrfax().toUpperCase() + "%");
			}
			where.append(" AND t1.LANRFAX IS NOT NULL");
		}
		if (laboratorio != null && laboratorio.getNoraProvinciaId() != null) {
			where.append(" AND t1.NORA_PROVINCIA_ID = ?");
			params.add(laboratorio.getNoraProvinciaId());
		}
		if (laboratorio != null && laboratorio.getNombreProvincia() != null) {
			where.append(" AND UPPER(t1.NOMBRE_PROVINCIA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(laboratorio.getNombreProvincia().toUpperCase() + "%");
			} else {
				params.add("%" + laboratorio.getNombreProvincia().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NOMBRE_PROVINCIA IS NOT NULL");
		}
		if (laboratorio != null && laboratorio.getNoraMunicipioId() != null) {
			where.append(" AND t1.NORA_MUNICIPIO_ID = ?");
			params.add(laboratorio.getNoraMunicipioId());
		}
		if (laboratorio != null && laboratorio.getNombreMunicipio() != null) {
			where.append(" AND UPPER(t1.NOMBRE_MUNICIPIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(laboratorio.getNombreMunicipio().toUpperCase() + "%");
			} else {
				params.add("%" + laboratorio.getNombreMunicipio().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NOMBRE_MUNICIPIO IS NOT NULL");
		}
		if (laboratorio != null && laboratorio.getNoraLocalidadId() != null) {
			where.append(" AND t1.NORA_LOCALIDAD_ID = ?");
			params.add(laboratorio.getNoraLocalidadId());
		}
		if (laboratorio != null && laboratorio.getNombreLocalidad() != null) {
			where.append(" AND UPPER(t1.NOMBRE_LOCALIDAD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(laboratorio.getNombreLocalidad().toUpperCase() + "%");
			} else {
				params.add("%" + laboratorio.getNombreLocalidad().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NOMBRE_LOCALIDAD IS NOT NULL");
		}
		if (laboratorio != null && laboratorio.getNoraCalleId() != null) {
			where.append(" AND t1.NORA_CALLE_ID = ?");
			params.add(laboratorio.getNoraCalleId());
		}
		if (laboratorio != null && laboratorio.getNombreCalle() != null) {
			where.append(" AND UPPER(t1.NOMBRE_CALLE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(laboratorio.getNombreCalle().toUpperCase() + "%");
			} else {
				params.add("%" + laboratorio.getNombreCalle().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NOMBRE_CALLE IS NOT NULL");
		}
		if (laboratorio != null && laboratorio.getNoraCpId() != null) {
			where.append(" AND t1.NORA_CP_ID = ?");
			params.add(laboratorio.getNoraCpId());
		}
		if (laboratorio != null && laboratorio.getNombreCp() != null) {
			where.append(" AND t1.NOMBRE_CP = ?");
			params.add(laboratorio.getNombreCp());
		}
		if (laboratorio != null && laboratorio.getNoraPortalId() != null) {
			where.append(" AND t1.NORA_PORTAL_ID = ?");
			params.add(laboratorio.getNoraPortalId());
		}
		if (laboratorio != null && laboratorio.getNombrePortal() != null) {
			where.append(" AND UPPER(t1.NOMBRE_PORTAL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(laboratorio.getNombrePortal().toUpperCase() + "%");
			} else {
				params.add("%" + laboratorio.getNombrePortal().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NOMBRE_PORTAL IS NOT NULL");
		}
		if (laboratorio != null && laboratorio.getNombrePiso() != null) {
			where.append(" AND UPPER(t1.NOMBRE_PISO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(laboratorio.getNombrePiso().toUpperCase() + "%");
			} else {
				params.add("%" + laboratorio.getNombrePiso().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NOMBRE_PISO IS NOT NULL");
		}
		if (laboratorio != null && laboratorio.getDireccionNocapv() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.DIRECCION_NOCAPV),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(laboratorio.getDireccionNocapv().toUpperCase()
						.replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O")
						.replaceAll("", "U")
						+ "%");
			} else {
				params.add("%"
						+ laboratorio.getDireccionNocapv().toUpperCase()
								.replaceAll("", "A").replaceAll("", "E")
								.replaceAll("", "I").replaceAll("", "O")
								.replaceAll("", "U") + "%");
			}
			where.append(" AND t1.DIRECCION_NOCAPV IS NOT NULL");
		}
		if (laboratorio != null && laboratorio.getExtranjero() != null
				&& laboratorio.getEstado() == null) {
			where.append(" AND t1.EXTRANJERO = ?");
			params.add(Y41bConstantes.SI);
		}
		if (laboratorio != null && laboratorio.getEstado() != null
				&& laboratorio.getExtranjero() == null) {
			where.append(" AND t1.EXTRANJERO = ?");
			params.add(Y41bConstantes.NO);
		}
		if (laboratorio != null && laboratorio.getNoraPaisId() != null) {
			where.append(" AND t1.NORA_PAIS_ID = ?");
			params.add(laboratorio.getNoraPaisId());
		}
		if (laboratorio != null && laboratorio.getNombrePais() != null) {
			where.append(" AND UPPER(t1.NOMBRE_PAIS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(laboratorio.getNombrePais().toUpperCase() + "%");
			} else {
				params.add("%" + laboratorio.getNombrePais().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NOMBRE_PAIS IS NOT NULL");
		}
		if (laboratorio != null && laboratorio.getLamail() != null) {
			where.append(" AND UPPER(t1.LAMAIL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(laboratorio.getLamail().toUpperCase() + "%");
			} else {
				params.add("%" + laboratorio.getLamail().toUpperCase() + "%");
			}
			where.append(" AND t1.LAMAIL IS NOT NULL");
		}
		if (laboratorio != null && laboratorio.getLanrtel2() != null) {
			where.append(" AND UPPER(t1.LANRTEL2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(laboratorio.getLanrtel2().toUpperCase() + "%");
			} else {
				params.add("%" + laboratorio.getLanrtel2().toUpperCase() + "%");
			}
			where.append(" AND t1.LANRTEL2 IS NOT NULL");
		}

		where.append(" AND t1.LAFECHABAJA IS NULL ");

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
