package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Jjaa;
import com.ejie.y41b.model.Organismo;
import com.ejie.y41b.utils.Y41bUtils;

/**
 * JjaaDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class JjaaDaoImpl implements JjaaDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Jjaa> rwMap = new RowMapper<Jjaa>() {
		public Jjaa mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			Jjaa jjaa = new Jjaa(resultSet.getString("JACODIGO"),
					resultSet.getString("JANOP"),
					resultSet.getString("JANIFP"),
					resultSet.getString("JATEEMP"),
					resultSet.getString("JATEURLP"),
					resultSet.getString("JANOS"),
					resultSet.getString("JANIFS"),
					resultSet.getString("JATEEMS"),
					resultSet.getString("JATEURLS"),
					resultSet.getString("JANOA"),
					resultSet.getString("JANIFA"),
					resultSet.getString("JATEEMA"),
					resultSet.getString("JATEURLA"),
					resultSet.getString("JATELEFONOP"),
					resultSet.getString("JATELEFONOS"),
					resultSet.getString("JANOC"),
					resultSet.getString("JANIFC"),
					resultSet.getString("JATEEMC"),
					resultSet.getString("JATELEFONOC"),
					resultSet.getDate("JAFECALTA"),
					resultSet.getDate("JAFECMODIF"),
					resultSet.getString("JAUSUALTA"),
					resultSet.getString("JAUSUMODIF"));
			Organismo organismo = new Organismo();
			organismo.setNombreEs(resultSet.getString("OrganismoNOMBREES"));
			organismo.setNombreEu(resultSet.getString("OrganismoNOMBREEU"));
			organismo.setNombreMunicipio(resultSet
					.getString("OrganismoNOMBREMUNICIPIO"));
			organismo.setNombreProvincia(resultSet
					.getString("OrganismoNOMBREPROVINCIA"));
			jjaa.setOrganismo(organismo);
			return jjaa;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Jjaa table.
	 * 
	 * @param jjaa
	 *            Pagination
	 * @return Jjaa
	 */
	public Jjaa add(Jjaa jjaa) {
		String query = "INSERT INTO JJAA (JACODIGO, JANOP, JANIFP, JATEEMP, JATEURLP, JANOS, JANIFS, JATEEMS, JATEURLS, JANOA, JANIFA, JATEEMA, JATEURLA, JATELEFONOP, JATELEFONOS, JANOC, JANIFC, JATEEMC, JATELEFONOC) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, jjaa.getJacodigo(), jjaa.getJanop(),
				jjaa.getJanifp(), jjaa.getJateemp(), jjaa.getJateurlp(),
				jjaa.getJanos(), jjaa.getJanifs(), jjaa.getJateems(),
				jjaa.getJateurls(), jjaa.getJanoa(), jjaa.getJanifa(),
				jjaa.getJateema(), jjaa.getJateurla(), jjaa.getJatelefonop(),
				jjaa.getJatelefonos(), jjaa.getJanoc(), jjaa.getJanifc(),
				jjaa.getJateemc(), jjaa.getJatelefonoc());
		return jjaa;
	}

	/**
	 * Updates a single row in the Jjaa table.
	 * 
	 * @param jjaa
	 *            Pagination
	 * @return Jjaa
	 */
	public Jjaa update(Jjaa jjaa) {
		String query = "UPDATE JJAA SET JANOP=?, JANIFP=?, JATEEMP=?, JANOS=?, JANIFS=?, JATEEMS=?, JATELEFONOP=?, JATELEFONOS=?, JANOC=?, JANIFC=?, JATEEMC=?, JATELEFONOC=? WHERE JACODIGO=?";
		this.jdbcTemplate.update(query, jjaa.getJanop(), jjaa.getJanifp(),
				jjaa.getJateemp(), jjaa.getJanos(), jjaa.getJanifs(),
				jjaa.getJateems(), jjaa.getJatelefonop(),
				jjaa.getJatelefonos(), jjaa.getJanoc(), jjaa.getJanifc(),
				jjaa.getJateemc(), jjaa.getJatelefonoc(), jjaa.getJacodigo());
		return jjaa;
	}

	/**
	 * Finds a single row in the Jjaa table.
	 * 
	 * @param jjaa
	 *            Pagination
	 * @return Jjaa
	 */
	@Transactional(readOnly = true)
	public Jjaa find(Jjaa jjaa) {
		String query = "SELECT t1.JACODIGO JACODIGO, t1.JANOP JANOP, t1.JANIFP JANIFP, t1.JATEEMP JATEEMP, t1.JATEURLP JATEURLP, t1.JANOS JANOS, t1.JANIFS JANIFS, t1.JATEEMS JATEEMS, t1.JATEURLS JATEURLS, t1.JANOA JANOA, t1.JANIFA JANIFA, t1.JATEEMA JATEEMA, t1.JATEURLA JATEURLA, t1.JATELEFONOP JATELEFONOP, t1.JATELEFONOS JATELEFONOS, t1.JANOC JANOC, t1.JANIFC JANIFC, t1.JATEEMC JATEEMC, t1.JATELEFONOC JATELEFONOC, t1.JAFECALTA JAFECALTA, t1.JAFECMODIF JAFECMODIF, t1.JAUSUALTA JAUSUALTA, t2.USUARIOXLNET JAUSUMODIF, '' OrganismoNOMBREES, '' OrganismoNOMBREEU, '' OrganismoNOMBREMUNICIPIO,  '' OrganismoNOMBREPROVINCIA FROM JJAA t1, CENSO_MONITOR t2  WHERE t1.JAUSUMODIF=t2.MOCODIGO(+) AND t1.JACODIGO = ?  ";

		List<Jjaa> jjaaList = this.jdbcTemplate.query(query, this.rwMap,
				jjaa.getJacodigo());
		return (Jjaa) DataAccessUtils.uniqueResult(jjaaList);
	}

	/**
	 * Removes a single row in the Jjaa table.
	 * 
	 * @param jjaa
	 *            Pagination
	 * @return
	 */
	public void remove(Jjaa jjaa) {
		String query = "DELETE FROM JJAA WHERE JACODIGO=?";
		this.jdbcTemplate.update(query, jjaa.getJacodigo());
	}

	/**
	 * Finds a List of rows in the Jjaa table.
	 * 
	 * @param jjaa
	 *            Jjaa
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Jjaa> findAll(Jjaa jjaa, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.JACODIGO JACODIGO,t1.JANOP JANOP,t1.JANIFP JANIFP,t1.JATEEMP JATEEMP,t1.JATEURLP JATEURLP,t1.JANOS JANOS,t1.JANIFS JANIFS,t1.JATEEMS JATEEMS,t1.JATEURLS JATEURLS,t1.JANOA JANOA,t1.JANIFA JANIFA,t1.JATEEMA JATEEMA,t1.JATEURLA JATEURLA,t1.JATELEFONOP JATELEFONOP,t1.JATELEFONOS JATELEFONOS,t1.JANOC JANOC,t1.JANIFC JANIFC,t1.JATEEMC JATEEMC,t1.JATELEFONOC JATELEFONOC,t1.JAFECALTA JAFECALTA,t1.JAFECMODIF JAFECMODIF,t1.JAUSUALTA JAUSUALTA,t1.JAUSUMODIF JAUSUMODIF ");
		query.append(", t2.NOMBRE_ES OrganismoNOMBREES, t2.NOMBRE_EU OrganismoNOMBREEU, t2.NOMBRE_MUNICIPIO OrganismoNOMBREMUNICIPIO, t2.NOMBRE_PROVINCIA OrganismoNOMBREPROVINCIA ");
		query.append("FROM JJAA t1, ORGANISMO t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(jjaa);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.JACODIGO=t2.COD_ORG(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Jjaa>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Jjaa table.
	 * 
	 * @param jjaa
	 *            Jjaa
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Jjaa jjaa) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM JJAA t1, ORGANISMO t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(jjaa);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.JACODIGO=t2.COD_ORG(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Jjaa table using like.
	 * 
	 * @param jjaa
	 *            Jjaa
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Jjaa> findAllLike(Jjaa jjaa, Pagination pagination,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.JACODIGO JACODIGO,t1.JANOP JANOP,t1.JANIFP JANIFP,t1.JATEEMP JATEEMP,t1.JATEURLP JATEURLP,t1.JANOS JANOS,t1.JANIFS JANIFS,t1.JATEEMS JATEEMS,t1.JATEURLS JATEURLS,t1.JANOA JANOA,t1.JANIFA JANIFA,t1.JATEEMA JATEEMA,t1.JATEURLA JATEURLA,t1.JATELEFONOP JATELEFONOP,t1.JATELEFONOS JATELEFONOS,t1.JANOC JANOC,t1.JANIFC JANIFC,t1.JATEEMC JATEEMC,t1.JATELEFONOC JATELEFONOC,t1.JAFECALTA JAFECALTA,t1.JAFECMODIF JAFECMODIF,t1.JAUSUALTA JAUSUALTA,t1.JAUSUMODIF JAUSUMODIF, '' OrganismoNOMBREES, '' OrganismoNOMBREEU, '' OrganismoNOMBREMUNICIPIO, '' OrganismoNOMBREPROVINCIA ");
		query.append("FROM JJAA t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(jjaa, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Jjaa>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Jjaa table using like.
	 * 
	 * @param jjaa
	 *            Jjaa
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Jjaa jjaa, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM JJAA t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(jjaa, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Jjaa entity
	 * 
	 * @param jjaa
	 *            Jjaa Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Jjaa jjaa) {

		StringBuilder where = new StringBuilder(JjaaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (jjaa != null && jjaa.getJacodigo() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.JACODIGO),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%"
					+ jjaa.getJacodigo().toUpperCase().replaceAll("", "A")
							.replaceAll("", "E").replaceAll("", "I")
							.replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t1.JACODIGO IS NOT NULL");
		}
		// Organismo
		if (jjaa != null && jjaa.getOrganismo() != null) {
			if (!Y41bUtils
					.esNullOCadenaVacia(jjaa.getOrganismo().getNombreEs())) {
				where.append(" AND TRANSLATE(UPPER(t2.NOMBRE_ES),'','AEIOU') like ? ESCAPE  '\\'");
				params.add("%"
						+ jjaa.getOrganismo().getNombreEs().toUpperCase()
								.replaceAll("", "A").replaceAll("", "E")
								.replaceAll("", "I").replaceAll("", "O")
								.replaceAll("", "U") + "%");
				where.append(" AND t2.NOMBRE_ES IS NOT NULL");
			}
			if (!Y41bUtils
					.esNullOCadenaVacia(jjaa.getOrganismo().getNombreEu())) {
				where.append(" AND TRANSLATE(UPPER(t2.NOMBRE_EU),'','AEIOU') like ? ESCAPE  '\\'");
				params.add("%"
						+ jjaa.getOrganismo().getNombreEu().toUpperCase()
								.replaceAll("", "A").replaceAll("", "E")
								.replaceAll("", "I").replaceAll("", "O")
								.replaceAll("", "U") + "%");
				where.append(" AND t2.NOMBRE_EU IS NOT NULL");
			}
			if (!Y41bUtils.esNullOCadenaVacia(jjaa.getOrganismo()
					.getNoraProvinciaId())) {
				where.append(" AND t2.NORA_PROVINCIA_ID = ?");
				params.add(jjaa.getOrganismo().getNoraProvinciaId());
			}
			if (!Y41bUtils.esNullOCadenaVacia(jjaa.getOrganismo()
					.getNoraMunicipioId())) {
				where.append(" AND t2.NORA_MUNICIPIO_ID = ?");
				params.add(jjaa.getOrganismo().getNoraMunicipioId());
			}
			if (!Y41bUtils.esNullOCadenaVacia(jjaa.getOrganismo()
					.getNoraLocalidadId())) {
				where.append(" AND t2.NORA_LOCALIDAD_ID = ?");
				params.add(jjaa.getOrganismo().getNoraLocalidadId());
			}
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Jjaa entity
	 * 
	 * @param jjaa
	 *            Jjaa Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Jjaa jjaa, Boolean startsWith) {

		StringBuilder where = new StringBuilder(JjaaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (jjaa != null && jjaa.getJacodigo() != null) {
			where.append(" AND UPPER(t1.JACODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(jjaa.getJacodigo().toUpperCase() + "%");
			} else {
				params.add("%" + jjaa.getJacodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.JACODIGO IS NOT NULL");
		}
		if (jjaa != null && jjaa.getJanop() != null) {
			where.append(" AND UPPER(t1.JANOP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(jjaa.getJanop().toUpperCase() + "%");
			} else {
				params.add("%" + jjaa.getJanop().toUpperCase() + "%");
			}
			where.append(" AND t1.JANOP IS NOT NULL");
		}
		if (jjaa != null && jjaa.getJanifp() != null) {
			where.append(" AND UPPER(t1.JANIFP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(jjaa.getJanifp().toUpperCase() + "%");
			} else {
				params.add("%" + jjaa.getJanifp().toUpperCase() + "%");
			}
			where.append(" AND t1.JANIFP IS NOT NULL");
		}
		if (jjaa != null && jjaa.getJateemp() != null) {
			where.append(" AND UPPER(t1.JATEEMP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(jjaa.getJateemp().toUpperCase() + "%");
			} else {
				params.add("%" + jjaa.getJateemp().toUpperCase() + "%");
			}
			where.append(" AND t1.JATEEMP IS NOT NULL");
		}
		if (jjaa != null && jjaa.getJateurlp() != null) {
			where.append(" AND UPPER(t1.JATEURLP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(jjaa.getJateurlp().toUpperCase() + "%");
			} else {
				params.add("%" + jjaa.getJateurlp().toUpperCase() + "%");
			}
			where.append(" AND t1.JATEURLP IS NOT NULL");
		}
		if (jjaa != null && jjaa.getJanos() != null) {
			where.append(" AND UPPER(t1.JANOS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(jjaa.getJanos().toUpperCase() + "%");
			} else {
				params.add("%" + jjaa.getJanos().toUpperCase() + "%");
			}
			where.append(" AND t1.JANOS IS NOT NULL");
		}
		if (jjaa != null && jjaa.getJanifs() != null) {
			where.append(" AND UPPER(t1.JANIFS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(jjaa.getJanifs().toUpperCase() + "%");
			} else {
				params.add("%" + jjaa.getJanifs().toUpperCase() + "%");
			}
			where.append(" AND t1.JANIFS IS NOT NULL");
		}
		if (jjaa != null && jjaa.getJateems() != null) {
			where.append(" AND UPPER(t1.JATEEMS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(jjaa.getJateems().toUpperCase() + "%");
			} else {
				params.add("%" + jjaa.getJateems().toUpperCase() + "%");
			}
			where.append(" AND t1.JATEEMS IS NOT NULL");
		}
		if (jjaa != null && jjaa.getJateurls() != null) {
			where.append(" AND UPPER(t1.JATEURLS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(jjaa.getJateurls().toUpperCase() + "%");
			} else {
				params.add("%" + jjaa.getJateurls().toUpperCase() + "%");
			}
			where.append(" AND t1.JATEURLS IS NOT NULL");
		}
		if (jjaa != null && jjaa.getJanoa() != null) {
			where.append(" AND UPPER(t1.JANOA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(jjaa.getJanoa().toUpperCase() + "%");
			} else {
				params.add("%" + jjaa.getJanoa().toUpperCase() + "%");
			}
			where.append(" AND t1.JANOA IS NOT NULL");
		}
		if (jjaa != null && jjaa.getJanifa() != null) {
			where.append(" AND UPPER(t1.JANIFA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(jjaa.getJanifa().toUpperCase() + "%");
			} else {
				params.add("%" + jjaa.getJanifa().toUpperCase() + "%");
			}
			where.append(" AND t1.JANIFA IS NOT NULL");
		}
		if (jjaa != null && jjaa.getJateema() != null) {
			where.append(" AND UPPER(t1.JATEEMA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(jjaa.getJateema().toUpperCase() + "%");
			} else {
				params.add("%" + jjaa.getJateema().toUpperCase() + "%");
			}
			where.append(" AND t1.JATEEMA IS NOT NULL");
		}
		if (jjaa != null && jjaa.getJateurla() != null) {
			where.append(" AND UPPER(t1.JATEURLA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(jjaa.getJateurla().toUpperCase() + "%");
			} else {
				params.add("%" + jjaa.getJateurla().toUpperCase() + "%");
			}
			where.append(" AND t1.JATEURLA IS NOT NULL");
		}
		if (jjaa != null && jjaa.getJatelefonop() != null) {
			where.append(" AND UPPER(t1.JATELEFONOP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(jjaa.getJatelefonop().toUpperCase() + "%");
			} else {
				params.add("%" + jjaa.getJatelefonop().toUpperCase() + "%");
			}
			where.append(" AND t1.JATELEFONOP IS NOT NULL");
		}
		if (jjaa != null && jjaa.getJatelefonos() != null) {
			where.append(" AND UPPER(t1.JATELEFONOS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(jjaa.getJatelefonos().toUpperCase() + "%");
			} else {
				params.add("%" + jjaa.getJatelefonos().toUpperCase() + "%");
			}
			where.append(" AND t1.JATELEFONOS IS NOT NULL");
		}
		if (jjaa != null && jjaa.getJanoc() != null) {
			where.append(" AND UPPER(t1.JANOC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(jjaa.getJanoc().toUpperCase() + "%");
			} else {
				params.add("%" + jjaa.getJanoc().toUpperCase() + "%");
			}
			where.append(" AND t1.JANOC IS NOT NULL");
		}
		if (jjaa != null && jjaa.getJanifc() != null) {
			where.append(" AND UPPER(t1.JANIFC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(jjaa.getJanifc().toUpperCase() + "%");
			} else {
				params.add("%" + jjaa.getJanifc().toUpperCase() + "%");
			}
			where.append(" AND t1.JANIFC IS NOT NULL");
		}
		if (jjaa != null && jjaa.getJateemc() != null) {
			where.append(" AND UPPER(t1.JATEEMC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(jjaa.getJateemc().toUpperCase() + "%");
			} else {
				params.add("%" + jjaa.getJateemc().toUpperCase() + "%");
			}
			where.append(" AND t1.JATEEMC IS NOT NULL");
		}
		if (jjaa != null && jjaa.getJatelefonoc() != null) {
			where.append(" AND UPPER(t1.JATELEFONOC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(jjaa.getJatelefonoc().toUpperCase() + "%");
			} else {
				params.add("%" + jjaa.getJatelefonoc().toUpperCase() + "%");
			}
			where.append(" AND t1.JATELEFONOC IS NOT NULL");
		}
		if (jjaa != null && jjaa.getJafecalta() != null) {
			where.append(" AND t1.JAFECALTA = ?");
			params.add(jjaa.getJafecalta());
		}
		if (jjaa != null && jjaa.getJafecmodif() != null) {
			where.append(" AND t1.JAFECMODIF = ?");
			params.add(jjaa.getJafecmodif());
		}
		if (jjaa != null && jjaa.getJausualta() != null) {
			where.append(" AND UPPER(t1.JAUSUALTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(jjaa.getJausualta().toUpperCase() + "%");
			} else {
				params.add("%" + jjaa.getJausualta().toUpperCase() + "%");
			}
			where.append(" AND t1.JAUSUALTA IS NOT NULL");
		}
		if (jjaa != null && jjaa.getJausumodif() != null) {
			where.append(" AND UPPER(t1.JAUSUMODIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(jjaa.getJausumodif().toUpperCase() + "%");
			} else {
				params.add("%" + jjaa.getJausumodif().toUpperCase() + "%");
			}
			where.append(" AND t1.JAUSUMODIF IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
