package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.Jjaa;

/**
 * JjaaDao  
 *  
 */

public interface JjaaDao {
    
    /**
     * Inserts a single row in the Jjaa table.
     *
     * @param jjaa Jjaa
     * @return Jjaa
     */
    Jjaa add(Jjaa jjaa);

    /**
     * Updates a single row in the Jjaa table.
     *
     * @param jjaa Jjaa
     * @return Jjaa
     */
    Jjaa update(Jjaa jjaa);

    /**
     * Finds a single row in the Jjaa table.
     *
     * @param jjaa Jjaa
     * @return Jjaa
     */
    Jjaa find(Jjaa jjaa);

    /**
     * Deletes a single row in the Jjaa table.
     *
     * @param jjaa Jjaa
     * @return 
     */
    void remove(Jjaa jjaa);

    /**
     * Finds a List of rows in the Jjaa table.
     *
     * @param jjaa Jjaa
     * @param pagination Pagination
     * @return List
     */
    List<Jjaa> findAll(Jjaa jjaa, Pagination pagination);

    /**
     * Counts rows in the Jjaa table.
     *
     * @param jjaa Jjaa
     * @return Long
     */
    Long findAllCount(Jjaa jjaa);
	
	/**
     * Finds rows in the Jjaa table using like.
     *
     * @param jjaa Jjaa
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List
     */
	List<Jjaa> findAllLike(Jjaa jjaa, Pagination pagination, Boolean startsWith);
	
    /**
     * Counts rows in the Jjaa table using like.
     *
     * @param jjaa Jjaa
     * @param startsWith Boolean
     * @return Long
     */
    Long findAllLikeCount(Jjaa jjaa, Boolean startsWith);
}

