package com.ejie.y41b.dao;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.IntervinientesTramite;

/**
 * IntervinientesTramiteDao  
 * 
 *  
 */

@Repository
@Transactional
public class IntervinientesTramiteDaoImpl implements IntervinientesTramiteDao {
	private JdbcTemplate jdbcTemplate;

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Mtodo para insertar los arbitros de un tramite
	 * 
	 * @param intervinientesTramite
	 *            IntervinientesTramite
	 * @return IntervinientesTramite
	 */
	public IntervinientesTramite add(IntervinientesTramite intervinientesTramite) {
		String query = "INSERT INTO INTERVINIENTES_TRAMITE (Z4IDINTERVINIENTE , Z4TRID) VALUES (?,?)";

		String getIdIntervinienteAux = null;
		if (intervinientesTramite.getInterviniente() != null
				&& intervinientesTramite.getInterviniente()
						.getIdinterviniente() != null) {
			getIdIntervinienteAux = intervinientesTramite.getInterviniente()
					.getIdinterviniente();
		}
		String getIdTramiteAux = null;
		if (intervinientesTramite.getArbtramexp() != null
				&& intervinientesTramite.getArbtramexp().getTrid() != null) {
			getIdTramiteAux = intervinientesTramite.getArbtramexp().getTrid();
		}

		this.jdbcTemplate.update(query, getIdIntervinienteAux, getIdTramiteAux);

		return intervinientesTramite;
	}

	/**
	 * Mtodo para borrar los arbitros de un tramite
	 * 
	 * @param idTramite
	 *            String
	 * @return
	 */
	public void remove(String idTramite) {
		String query = "DELETE FROM INTERVINIENTES_TRAMITE WHERE Z4TRID=?";
		this.jdbcTemplate.update(query, idTramite);
	}

	/**
	 * Mtodo para coger los rbitros asociados al trmite
	 * 
	 * @param idTramite
	 *            String
	 * @return String
	 */
	public String cogerArbitros(String idTramite) {
		String query = "SELECT LISTAGG(Z4IDINTERVINIENTE,',') WITHIN GROUP (ORDER BY Z4TRID) LISTA_ARBITROS FROM INTERVINIENTES_TRAMITE WHERE Z4TRID=?";
		return this.jdbcTemplate.queryForObject(query, String.class,
				new Object[] { idTramite });
	}
}
