package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Instructor;

/**
 * InstructorDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class InstructorDaoImpl implements InstructorDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Instructor> rwMap = new RowMapper<Instructor>() {
		public Instructor mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Instructor(resultSet.getString("ITCODIGO"),
					resultSet.getString("ITNOMBRE"),
					resultSet.getString("ITCOOR"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Instructor table.
	 * 
	 * @param instructor
	 *            Pagination
	 * @return Instructor
	 */
	public Instructor add(Instructor instructor) {
		String query = "INSERT INTO INSTRUCTOR (ITCODIGO, ITNOMBRE, ITCOOR) VALUES (?,?,?)";
		this.jdbcTemplate.update(query, instructor.getItcodigo(),
				instructor.getItnombre(), instructor.getItcoor());
		return instructor;
	}

	/**
	 * Updates a single row in the Instructor table.
	 * 
	 * @param instructor
	 *            Pagination
	 * @return Instructor
	 */
	public Instructor update(Instructor instructor) {
		String query = "UPDATE INSTRUCTOR SET ITNOMBRE=?, ITCOOR=? WHERE ITCODIGO=?";
		this.jdbcTemplate.update(query, instructor.getItnombre(),
				instructor.getItcoor(), instructor.getItcodigo());
		return instructor;
	}

	/**
	 * Finds a single row in the Instructor table.
	 * 
	 * @param instructor
	 *            Pagination
	 * @return Instructor
	 */
	@Transactional(readOnly = true)
	public Instructor find(Instructor instructor) {
		String query = "SELECT t1.ITCODIGO ITCODIGO, t1.ITNOMBRE ITNOMBRE, t1.ITCOOR ITCOOR FROM INSTRUCTOR t1  WHERE t1.ITCODIGO = ?  ";

		List<Instructor> instructorList = this.jdbcTemplate.query(query,
				this.rwMap, instructor.getItcodigo());
		return (Instructor) DataAccessUtils.uniqueResult(instructorList);
	}

	/**
	 * Removes a single row in the Instructor table.
	 * 
	 * @param instructor
	 *            Pagination
	 * @return
	 */
	public void remove(Instructor instructor) {
		String query = "DELETE FROM INSTRUCTOR WHERE ITCODIGO=?";
		this.jdbcTemplate.update(query, instructor.getItcodigo());
	}

	/**
	 * Finds a List of rows in the Instructor table.
	 * 
	 * @param instructor
	 *            Instructor
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Instructor> findAll(Instructor instructor, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ITCODIGO ITCODIGO,t1.ITNOMBRE ITNOMBRE,t1.ITCOOR ITCOOR ");
		query.append("FROM INSTRUCTOR t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(instructor);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Instructor>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Instructor table.
	 * 
	 * @param instructor
	 *            Instructor
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Instructor instructor) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM INSTRUCTOR t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(instructor);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Instructor table using like.
	 * 
	 * @param instructor
	 *            Instructor
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Instructor> findAllLike(Instructor instructor,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ITCODIGO ITCODIGO,t1.ITNOMBRE ITNOMBRE,t1.ITCOOR ITCOOR ");
		query.append("FROM INSTRUCTOR t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(instructor, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Instructor>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Instructor table using like.
	 * 
	 * @param instructor
	 *            Instructor
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Instructor instructor, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM INSTRUCTOR t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(instructor, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Instructor entity
	 * 
	 * @param instructor
	 *            Instructor Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Instructor instructor) {

		StringBuilder where = new StringBuilder(
				InstructorDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (instructor != null && instructor.getItcodigo() != null) {
			where.append(" AND t1.ITCODIGO = ?");
			params.add(instructor.getItcodigo());
		}
		if (instructor != null && instructor.getItnombre() != null) {
			where.append(" AND t1.ITNOMBRE = ?");
			params.add(instructor.getItnombre());
		}
		if (instructor != null && instructor.getItcoor() != null) {
			where.append(" AND t1.ITCOOR = ?");
			params.add(instructor.getItcoor());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Instructor entity
	 * 
	 * @param instructor
	 *            Instructor Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Instructor instructor,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				InstructorDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (instructor != null && instructor.getItcodigo() != null) {
			where.append(" AND UPPER(t1.ITCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(instructor.getItcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + instructor.getItcodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.ITCODIGO IS NOT NULL");
		}
		if (instructor != null && instructor.getItnombre() != null) {
			where.append(" AND UPPER(t1.ITNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(instructor.getItnombre().toUpperCase() + "%");
			} else {
				params.add("%" + instructor.getItnombre().toUpperCase() + "%");
			}
			where.append(" AND t1.ITNOMBRE IS NOT NULL");
		}
		if (instructor != null && instructor.getItcoor() != null) {
			where.append(" AND UPPER(t1.ITCOOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(instructor.getItcoor().toUpperCase() + "%");
			} else {
				params.add("%" + instructor.getItcoor().toUpperCase() + "%");
			}
			where.append(" AND t1.ITCOOR IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * findItcoor
	 * 
	 * @param instructor
	 *            Instructor
	 * @return String
	 */
	public String findItcoor(Instructor instructor) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuffer query = new StringBuffer(
				"SELECT t1.MOCOOR FROM  CENSO_MONITOR t1  ");
		if (instructor != null && instructor.getItcodigo() != null) {
			where.append(" AND t1.MOCODIGO = ?");
			params.add(instructor.getItcodigo());
		}
		query.append(where);
		return (String) this.jdbcTemplate.queryForObject(query.toString(),
				String.class, params.toArray());
	}
}
