package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.Instructor;

/**
 * InstructorDao  
 * 
 *  
 */

public interface InstructorDao {

	/**
	 * Inserts a single row in the Instructor table.
	 * 
	 * @param instructor
	 *            Instructor
	 * @return Instructor
	 */
	Instructor add(Instructor instructor);

	/**
	 * Updates a single row in the Instructor table.
	 * 
	 * @param instructor
	 *            Instructor
	 * @return Instructor
	 */
	Instructor update(Instructor instructor);

	/**
	 * Finds a single row in the Instructor table.
	 * 
	 * @param instructor
	 *            Instructor
	 * @return Instructor
	 */
	Instructor find(Instructor instructor);

	/**
	 * Deletes a single row in the Instructor table.
	 * 
	 * @param instructor
	 *            Instructor
	 * @return
	 */
	void remove(Instructor instructor);

	/**
	 * Finds a List of rows in the Instructor table.
	 * 
	 * @param instructor
	 *            Instructor
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Instructor> findAll(Instructor instructor, Pagination pagination);

	/**
	 * Counts rows in the Instructor table.
	 * 
	 * @param instructor
	 *            Instructor
	 * @return Long
	 */
	Long findAllCount(Instructor instructor);

	/**
	 * Finds rows in the Instructor table using like.
	 * 
	 * @param instructor
	 *            Instructor
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Instructor> findAllLike(Instructor instructor, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Instructor table using like.
	 * 
	 * @param instructor
	 *            Instructor
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Instructor instructor, Boolean startsWith);

	/**
	 * findItcoor
	 * 
	 * @param instructor
	 *            Instructor
	 * @return String
	 */
	String findItcoor(Instructor instructor);
}
