package com.ejie.y41b.dao;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Inspector;

/**
 * * InspectorDao  
 * 
 *  
 */

public interface InspectorDao {

	/**
	 * Inserts a single row in the Inspector table.
	 * 
	 * @param inspector
	 *            Inspector
	 * @return Inspector
	 */
	Inspector add(Inspector inspector);

	/**
	 * Updates a single row in the Inspector table.
	 * 
	 * @param inspector
	 *            Inspector
	 * @return Inspector
	 */
	Inspector update(Inspector inspector);

	/**
	 * Finds a single row in the Inspector table.
	 * 
	 * @param inspector
	 *            Inspector
	 * @return Inspector
	 */
	Inspector find(Inspector inspector);

	/**
	 * Deletes a single row in the Inspector table.
	 * 
	 * @param inspector
	 *            Inspector
	 * @return
	 */
	void remove(Inspector inspector);

	/**
	 * Finds a List of rows in the Inspector table.
	 * 
	 * @param inspector
	 *            Inspector
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Inspector> findAll(Inspector inspector, Pagination pagination);

	/**
	 * Counts rows in the Inspector table.
	 * 
	 * @param inspector
	 *            Inspector
	 * @return List
	 */
	Long findAllCount(Inspector inspector);

	/**
	 * Finds rows in the Inspector table using like.
	 * 
	 * @param inspector
	 *            Inspector
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Inspector> findAllLike(Inspector inspector, Pagination pagination,
			Boolean startsWith);
}
