package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.InspeccionesTipoDocumento;

/**
 * InspeccionesTipoDocumentoDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class InspeccionesTipoDocumentoDaoImpl implements
		InspeccionesTipoDocumentoDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<InspeccionesTipoDocumento> rwMap = new RowMapper<InspeccionesTipoDocumento>() {
		public InspeccionesTipoDocumento mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new InspeccionesTipoDocumento(
					resultSet.getString("IDTIPODOC"),
					resultSet.getString("TDNOMBRE"),
					resultSet.getString("TDNOMBREE"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the InspeccionesTipoDocumento table.
	 * 
	 * @param inspeccionestipodocumento
	 *            Pagination
	 * @return InspeccionesTipoDocumento
	 */
	public InspeccionesTipoDocumento add(
			InspeccionesTipoDocumento inspeccionestipodocumento) {
		String query = "INSERT INTO INSPECCIONES_TIPO_DOCUMENTO (ID_TIPODOC, TDNOMBRE, TDNOMBREE) VALUES (?,?,?)";
		this.jdbcTemplate.update(query,
				inspeccionestipodocumento.getIdTipodoc(),
				inspeccionestipodocumento.getTdnombre(),
				inspeccionestipodocumento.getTdnombree());
		return inspeccionestipodocumento;
	}

	/**
	 * Updates a single row in the InspeccionesTipoDocumento table.
	 * 
	 * @param inspeccionestipodocumento
	 *            Pagination
	 * @return InspeccionesTipoDocumento
	 */
	public InspeccionesTipoDocumento update(
			InspeccionesTipoDocumento inspeccionestipodocumento) {
		String query = "UPDATE INSPECCIONES_TIPO_DOCUMENTO SET  WHERE ID_TIPODOC=? AND TDNOMBRE=? AND TDNOMBREE=?";
		this.jdbcTemplate.update(query,
				inspeccionestipodocumento.getIdTipodoc(),
				inspeccionestipodocumento.getTdnombre(),
				inspeccionestipodocumento.getTdnombree());
		return inspeccionestipodocumento;
	}

	/**
	 * Finds a single row in the InspeccionesTipoDocumento table.
	 * 
	 * @param inspeccionestipodocumento
	 *            Pagination
	 * @return InspeccionesTipoDocumento
	 */
	@Transactional(readOnly = true)
	public InspeccionesTipoDocumento find(
			InspeccionesTipoDocumento inspeccionestipodocumento) {
		String query = "SELECT t1.ID_TIPODOC IDTIPODOC, t1.TDNOMBRE TDNOMBRE, t1.TDNOMBREE TDNOMBREE FROM INSPECCIONES_TIPO_DOCUMENTO t1  WHERE t1.ID_TIPODOC = ? ";

		List<InspeccionesTipoDocumento> inspeccionestipodocumentoList = this.jdbcTemplate
				.query(query, this.rwMap,
						inspeccionestipodocumento.getIdTipodoc());
		return (InspeccionesTipoDocumento) DataAccessUtils
				.uniqueResult(inspeccionestipodocumentoList);
	}

	/**
	 * Removes a single row in the InspeccionesTipoDocumento table.
	 * 
	 * @param inspeccionestipodocumento
	 *            Pagination
	 * @return
	 */
	public void remove(InspeccionesTipoDocumento inspeccionestipodocumento) {
		String query = "DELETE FROM INSPECCIONES_TIPO_DOCUMENTO WHERE ID_TIPODOC=? AND TDNOMBRE=? AND TDNOMBREE=?";
		this.jdbcTemplate.update(query,
				inspeccionestipodocumento.getIdTipodoc(),
				inspeccionestipodocumento.getTdnombre(),
				inspeccionestipodocumento.getTdnombree());
	}

	/**
	 * Finds a List of rows in the InspeccionesTipoDocumento table.
	 * 
	 * @param inspeccionestipodocumento
	 *            InspeccionesTipoDocumento
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<InspeccionesTipoDocumento> findAll(
			InspeccionesTipoDocumento inspeccionestipodocumento,
			Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_TIPODOC IDTIPODOC,t1.TDNOMBRE TDNOMBRE,t1.TDNOMBREE TDNOMBREE ");
		query.append("FROM INSPECCIONES_TIPO_DOCUMENTO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(inspeccionestipodocumento);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<InspeccionesTipoDocumento>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the InspeccionesTipoDocumento table.
	 * 
	 * @param inspeccionestipodocumento
	 *            InspeccionesTipoDocumento
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(InspeccionesTipoDocumento inspeccionestipodocumento) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM INSPECCIONES_TIPO_DOCUMENTO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(inspeccionestipodocumento);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the InspeccionesTipoDocumento table using like.
	 * 
	 * @param inspeccionestipodocumento
	 *            InspeccionesTipoDocumento
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<InspeccionesTipoDocumento> findAllLike(
			InspeccionesTipoDocumento inspeccionestipodocumento,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_TIPODOC IDTIPODOC,t1.TDNOMBRE TDNOMBRE,t1.TDNOMBREE TDNOMBREE ");
		query.append("FROM INSPECCIONES_TIPO_DOCUMENTO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(
				inspeccionestipodocumento, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<InspeccionesTipoDocumento>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the InspeccionesTipoDocumento table using like.
	 * 
	 * @param inspeccionestipodocumento
	 *            InspeccionesTipoDocumento
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(
			InspeccionesTipoDocumento inspeccionestipodocumento,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM INSPECCIONES_TIPO_DOCUMENTO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(
				inspeccionestipodocumento, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the InspeccionesTipoDocumento entity
	 * 
	 * @param inspeccionestipodocumento
	 *            InspeccionesTipoDocumento Bean with the criteria values to
	 *            filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(
			InspeccionesTipoDocumento inspeccionestipodocumento) {

		StringBuilder where = new StringBuilder(
				InspeccionesTipoDocumentoDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (inspeccionestipodocumento != null
				&& inspeccionestipodocumento.getIdTipodoc() != null) {
			where.append(" AND t1.ID_TIPODOC = ?");
			params.add(inspeccionestipodocumento.getIdTipodoc());
		}
		if (inspeccionestipodocumento != null
				&& inspeccionestipodocumento.getTdnombre() != null) {
			where.append(" AND t1.TDNOMBRE = ?");
			params.add(inspeccionestipodocumento.getTdnombre());
		}
		if (inspeccionestipodocumento != null
				&& inspeccionestipodocumento.getTdnombree() != null) {
			where.append(" AND t1.TDNOMBREE = ?");
			params.add(inspeccionestipodocumento.getTdnombree());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the InspeccionesTipoDocumento entity
	 * 
	 * @param inspeccionestipodocumento
	 *            InspeccionesTipoDocumento Bean with the criteria values to
	 *            filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(
			InspeccionesTipoDocumento inspeccionestipodocumento,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				InspeccionesTipoDocumentoDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (inspeccionestipodocumento != null
				&& inspeccionestipodocumento.getIdTipodoc() != null) {
			where.append(" AND UPPER(t1.ID_TIPODOC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(inspeccionestipodocumento.getIdTipodoc()
						.toUpperCase() + "%");
			} else {
				params.add("%"
						+ inspeccionestipodocumento.getIdTipodoc()
								.toUpperCase() + "%");
			}
			where.append(" AND t1.ID_TIPODOC IS NOT NULL");
		}
		if (inspeccionestipodocumento != null
				&& inspeccionestipodocumento.getTdnombre() != null) {
			where.append(" AND UPPER(t1.TDNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(inspeccionestipodocumento.getTdnombre()
						.toUpperCase() + "%");
			} else {
				params.add("%"
						+ inspeccionestipodocumento.getTdnombre().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TDNOMBRE IS NOT NULL");
		}
		if (inspeccionestipodocumento != null
				&& inspeccionestipodocumento.getTdnombree() != null) {
			where.append(" AND UPPER(t1.TDNOMBREE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(inspeccionestipodocumento.getTdnombree()
						.toUpperCase() + "%");
			} else {
				params.add("%"
						+ inspeccionestipodocumento.getTdnombree()
								.toUpperCase() + "%");
			}
			where.append(" AND t1.TDNOMBREE IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
