package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.InspeccionesPropBandeja;
import com.ejie.y41b.model.Intervinientes;
import com.ejie.y41b.model.TipoProcedimiento;

/**
 * InspeccionesPropBandejaDaoImpl  
 * 
 *  
 */

@Repository()
@Transactional()
public class InspeccionesPropBandejaDaoImpl implements
		InspeccionesPropBandejaDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<InspeccionesPropBandeja> rwMap = new RowMapper<InspeccionesPropBandeja>() {
		public InspeccionesPropBandeja mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new InspeccionesPropBandeja(
					resultSet.getString("BAPRINSID"),
					resultSet.getString("BAPRINSEXCODIGO"),
					resultSet.getString("BAPRINSEXESDENUNCIA"),
					resultSet.getString("BAPRINSEXCODCOMPLETO"),
					new TipoProcedimiento(
							resultSet.getString("BAPRINSPCODIGO"), resultSet
									.getString("PNOMBRE"), resultSet
									.getString("PNOMBREE"), resultSet
									.getTimestamp("PBAJA")),
					resultSet.getDate("BAPRINSFEC"), new Intervinientes(
							resultSet.getString("BAPRINSESTABLEC"),
							resultSet.getString("NOMBRE"),
							resultSet.getString("NIF"),
							resultSet.getString("ESNOCO")),
					resultSet.getString("BAPRINSPROV"),
					resultSet.getString("BAPRINSMUNIC"),
					resultSet.getString("BAPRINSPROVNOMBRE"),
					resultSet.getString("BAPRINSMUNICNOMBRE"),
					new CensoMonitor(resultSet.getString("BAPRINSRESPEXP"),
							resultSet.getString("MONOMBRE")),
					resultSet.getString("BAPRINSCOOR"),
					resultSet.getString("BAPRINSINSTRUCINSPECC"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the InspeccionesPropBandeja table.
	 * 
	 * @param inspeccionespropbandeja
	 *            Pagination
	 * @return InspeccionesPropBandeja
	 */
	public InspeccionesPropBandeja add(
			InspeccionesPropBandeja inspeccionespropbandeja) {
		String query = "INSERT INTO INSPECCIONES_PROP_BANDEJA (BAPRINSID, BAPRINSEXCODIGO, BAPRINSEXESDENUNCIA, BAPRINSEXCODCOMPLETO, BAPRINSPCODIGO, BAPRINSFEC, BAPRINSESTABLEC, BAPRINSPROV, BAPRINSMUNIC, BAPRINSRESPEXP, BAPRINSCOOR, BAPRINSINSTRUCINSPECC) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)";

		Object getBaprinspcodigoAux = null;
		if (inspeccionespropbandeja.getBaprinstipoprocedimiento() != null
				&& inspeccionespropbandeja.getBaprinstipoprocedimiento()
						.getPcodigo() != null) {
			getBaprinspcodigoAux = inspeccionespropbandeja
					.getBaprinstipoprocedimiento().getPcodigo();
		}
		Object getBaprinsestablecAux = null;
		if (inspeccionespropbandeja.getBaprinsestablecimiento() != null
				&& inspeccionespropbandeja.getBaprinsestablecimiento()
						.getEscodigo() != null) {
			getBaprinsestablecAux = inspeccionespropbandeja
					.getBaprinsestablecimiento().getEscodigo();
		}
		Object getBaprinsrespexpAux = null;
		if (inspeccionespropbandeja.getBaprinsresponsable() != null
				&& inspeccionespropbandeja.getBaprinsresponsable()
						.getMocodigo() != null) {
			getBaprinsrespexpAux = inspeccionespropbandeja
					.getBaprinsresponsable().getMocodigo();
		}

		this.jdbcTemplate.update(query, inspeccionespropbandeja.getBaprinsid(),
				inspeccionespropbandeja.getBaprinsexcodigo(),
				inspeccionespropbandeja.getBaprinsexesdenuncia(),
				inspeccionespropbandeja.getBaprinsexcodcompleto(),
				getBaprinspcodigoAux, inspeccionespropbandeja.getBaprinsfec(),
				getBaprinsestablecAux,
				inspeccionespropbandeja.getBaprinsprov(),
				inspeccionespropbandeja.getBaprinsmunic(),
				getBaprinsrespexpAux, inspeccionespropbandeja.getBaprinscoor(),
				inspeccionespropbandeja.getBaprinsinstrucinspecc());
		return inspeccionespropbandeja;
	}

	/**
	 * Updates a single row in the InspeccionesPropBandeja table.
	 * 
	 * @param inspeccionespropbandeja
	 *            Pagination
	 * @return InspeccionesPropBandeja
	 */
	public InspeccionesPropBandeja update(
			InspeccionesPropBandeja inspeccionespropbandeja) {
		String query = "UPDATE INSPECCIONES_PROP_BANDEJA SET BAPRINSEXCODIGO=?, BAPRINSEXESDENUNCIA=?, BAPRINSEXCODCOMPLETO=?, BAPRINSPCODIGO=?, BAPRINSFEC=?, BAPRINSESTABLEC=?, BAPRINSPROV=?, BAPRINSMUNIC=?, BAPRINSRESPEXP=?, BAPRINSCOOR=?, BAPRINSINSTRUCINSPECC=? WHERE BAPRINSID=?";

		Object getBaprinspcodigoAux = null;
		if (inspeccionespropbandeja.getBaprinstipoprocedimiento() != null
				&& inspeccionespropbandeja.getBaprinstipoprocedimiento()
						.getPcodigo() != null) {
			getBaprinspcodigoAux = inspeccionespropbandeja
					.getBaprinstipoprocedimiento().getPcodigo();
		}
		Object getBaprinsestablecAux = null;
		if (inspeccionespropbandeja.getBaprinsestablecimiento() != null
				&& inspeccionespropbandeja.getBaprinsestablecimiento()
						.getEscodigo() != null) {
			getBaprinsestablecAux = inspeccionespropbandeja
					.getBaprinsestablecimiento().getEscodigo();
		}
		Object getBaprinsrespexpAux = null;
		if (inspeccionespropbandeja.getBaprinsresponsable() != null
				&& inspeccionespropbandeja.getBaprinsresponsable()
						.getMocodigo() != null) {
			getBaprinsrespexpAux = inspeccionespropbandeja
					.getBaprinsresponsable().getMocodigo();
		}

		this.jdbcTemplate.update(query,
				inspeccionespropbandeja.getBaprinsexcodigo(),
				inspeccionespropbandeja.getBaprinsexesdenuncia(),
				inspeccionespropbandeja.getBaprinsexcodcompleto(),
				getBaprinspcodigoAux, inspeccionespropbandeja.getBaprinsfec(),
				getBaprinsestablecAux,
				inspeccionespropbandeja.getBaprinsprov(),
				inspeccionespropbandeja.getBaprinsmunic(),
				getBaprinsrespexpAux, inspeccionespropbandeja.getBaprinscoor(),
				inspeccionespropbandeja.getBaprinsinstrucinspecc(),
				inspeccionespropbandeja.getBaprinsid());
		return inspeccionespropbandeja;
	}

	/**
	 * Finds a single row in the InspeccionesPropBandeja table.
	 * 
	 * @param inspeccionespropbandeja
	 *            Pagination
	 * @return InspeccionesPropBandeja
	 */
	@Transactional(readOnly = true)
	public InspeccionesPropBandeja find(
			InspeccionesPropBandeja inspeccionespropbandeja) {
		String query = "SELECT t1.BAPRINSID BAPRINSID, t1.BAPRINSEXCODIGO BAPRINSEXCODIGO, t1.BAPRINSEXESDENUNCIA BAPRINSEXESDENUNCIA, t1.BAPRINSEXCODCOMPLETO BAPRINSEXCODCOMPLETO, t1.BAPRINSPCODIGO BAPRINSPCODIGO, t1.BAPRINSFEC BAPRINSFEC, t1.BAPRINSESTABLEC BAPRINSESTABLEC, t1.BAPRINSPROV BAPRINSPROV, t1.BAPRINSMUNIC BAPRINSMUNIC, t1.BAPRINSRESPEXP BAPRINSRESPEXP, t1.BAPRINSINSTRUCINSPECC BAPRINSINSTRUCINSPECC, t2.PNOMBRE PNOMBRE, t2.PNOMBREE PNOMBREE, t2.PBAJA PBAJA, t3.NOMBRE NOMBRE, t3.NIF NIF, t3.ESNOCO ESNOCO, t4.MONOMBRE, t5.DS_O BAPRINSPROVNOMBRE, t6.DS_O BAPRINSMUNICNOMBRE, t1.BAPRINSCOOR BAPRINSCOOR FROM INSPECCIONES_PROP_BANDEJA t1, TIPO_PROCEDIMIENTO t2, INTERVINIENTES t3, CENSO_MONITOR t4, T17_PROVINCIA t5, T17_MUNICIPIO t6 WHERE t1.BAPRINSPCODIGO = t2.PCODIGO AND t1.BAPRINSESTABLEC = t3.ESCODIGO AND t1.BAPRINSEXCODIGO = t3.HDCODIGO AND t1.BAPRINSRESPEXP = t4.MOCODIGO AND t1.BAPRINSMUNIC = t6.ID(+) AND t1.BAPRINSPROV = t5.ID(+) AND t1.BAPRINSPROV = t6.PROVINCIA_ID(+) AND t1.BAPRINSID = ?";

		List<InspeccionesPropBandeja> inspeccionespropbandejaList = this.jdbcTemplate
				.query(query, this.rwMap,
						inspeccionespropbandeja.getBaprinsid());
		return (InspeccionesPropBandeja) DataAccessUtils
				.uniqueResult(inspeccionespropbandejaList);
	}

	/**
	 * Removes a single row in the InspeccionesPropBandeja table.
	 * 
	 * @param inspeccionespropbandeja
	 *            Pagination
	 * @return
	 */
	public void remove(InspeccionesPropBandeja inspeccionespropbandeja) {
		String query = "DELETE FROM INSPECCIONES_PROP_BANDEJA WHERE BAPRINSID=?";
		this.jdbcTemplate.update(query, inspeccionespropbandeja.getBaprinsid());
	}

	/**
	 * Finds a List of rows in the InspeccionesPropBandeja table.
	 * 
	 * @param inspeccionespropbandeja
	 *            InspeccionesPropBandeja
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<InspeccionesPropBandeja> findAll(
			InspeccionesPropBandeja inspeccionespropbandeja,
			Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.BAPRINSID BAPRINSID,t1.BAPRINSEXCODIGO BAPRINSEXCODIGO,t1.BAPRINSEXESDENUNCIA BAPRINSEXESDENUNCIA, t1.BAPRINSEXCODCOMPLETO BAPRINSEXCODCOMPLETO,t1.BAPRINSPCODIGO BAPRINSPCODIGO,t1.BAPRINSFEC BAPRINSFEC,t1.BAPRINSESTABLEC BAPRINSESTABLEC,t1.BAPRINSPROV BAPRINSPROV,t1.BAPRINSMUNIC BAPRINSMUNIC,t1.BAPRINSRESPEXP BAPRINSRESPEXP, t1.BAPRINSINSTRUCINSPECC BAPRINSINSTRUCINSPECC, t2.PNOMBRE PNOMBRE, t2.PNOMBREE PNOMBREE, t2.PBAJA PBAJA, t3.NOMBRE NOMBRE, t3.NIF NIF, t3.ESNOCO ESNOCO, t4.MONOMBRE, t5.DS_O BAPRINSPROVNOMBRE, t6.DS_O BAPRINSMUNICNOMBRE, t1.BAPRINSCOOR BAPRINSCOOR ");
		query.append("FROM INSPECCIONES_PROP_BANDEJA t1, TIPO_PROCEDIMIENTO t2, INTERVINIENTES t3, CENSO_MONITOR t4, T17_PROVINCIA t5, T17_MUNICIPIO t6 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(inspeccionespropbandeja);
		StringBuilder where = new StringBuilder(
				" WHERE t1.BAPRINSPCODIGO = t2.PCODIGO AND t1.BAPRINSESTABLEC = t3.ESCODIGO AND t1.BAPRINSEXCODIGO = t3.HDCODIGO AND t1.BAPRINSRESPEXP = t4.MOCODIGO AND t1.BAPRINSMUNIC = t6.ID(+) AND t1.BAPRINSPROV = t5.ID(+) AND t1.BAPRINSPROV = t6.PROVINCIA_ID(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<InspeccionesPropBandeja>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the InspeccionesPropBandeja table.
	 * 
	 * @param inspeccionespropbandeja
	 *            InspeccionesPropBandeja
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(InspeccionesPropBandeja inspeccionespropbandeja) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM INSPECCIONES_PROP_BANDEJA t1, TIPO_PROCEDIMIENTO t2, INTERVINIENTES t3, CENSO_MONITOR t4 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(inspeccionespropbandeja);
		StringBuilder where = new StringBuilder(
				" WHERE t1.BAPRINSPCODIGO = t2.PCODIGO AND t1.BAPRINSESTABLEC = t3.ESCODIGO AND t1.BAPRINSEXCODIGO = t3.HDCODIGO AND t1.BAPRINSRESPEXP = t4.MOCODIGO ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the InspeccionesPropBandeja table using like.
	 * 
	 * @param inspeccionespropbandeja
	 *            InspeccionesPropBandeja
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<InspeccionesPropBandeja> findAllLike(
			InspeccionesPropBandeja inspeccionespropbandeja,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.BAPRINSID BAPRINSID,t1.BAPRINSEXCODIGO BAPRINSEXCODIGO,t1.BAPRINSEXESDENUNCIA BAPRINSEXESDENUNCIA,t1.BAPRINSEXCODCOMPLETO BAPRINSEXCODCOMPLETO,t1.BAPRINSPCODIGO BAPRINSPCODIGO,t1.BAPRINSFEC BAPRINSFEC,t1.BAPRINSESTABLEC BAPRINSESTABLEC,t1.BAPRINSPROV BAPRINSPROV,t1.BAPRINSMUNIC BAPRINSMUNIC,t1.BAPRINSRESPEXP BAPRINSRESPEXP, t1.BAPRINSINSTRUCINSPECC BAPRINSINSTRUCINSPECC, t2.PNOMBRE PNOMBRE, t2.PNOMBREE PNOMBREE, t2.PBAJA PBAJA, t3.NOMBRE NOMBRE, t3.NIF NIF, t3.ESNOCO ESNOCO, t4.MONOMBRE, t5.DS_O BAPRINSPROVNOMBRE, t6.DS_O BAPRINSMUNICNOMBRE, t1.BAPRINSCOOR BAPRINSCOOR ");
		query.append("FROM INSPECCIONES_PROP_BANDEJA t1, TIPO_PROCEDIMIENTO t2, INTERVINIENTES t3, CENSO_MONITOR t4, T17_PROVINCIA t5, T17_MUNICIPIO t6 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(
				inspeccionespropbandeja, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE t1.BAPRINSPCODIGO = t2.PCODIGO AND t1.BAPRINSESTABLEC = t3.ESCODIGO AND t1.BAPRINSEXCODIGO = t3.HDCODIGO AND t1.BAPRINSRESPEXP = t4.MOCODIGO AND t1.BAPRINSMUNIC = t6.ID(+) AND t1.BAPRINSPROV = t5.ID(+) AND t1.BAPRINSPROV = t6.PROVINCIA_ID(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<InspeccionesPropBandeja>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the InspeccionesPropBandeja table using like.
	 * 
	 * @param inspeccionespropbandeja
	 *            InspeccionesPropBandeja
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(
			InspeccionesPropBandeja inspeccionespropbandeja, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM INSPECCIONES_PROP_BANDEJA t1, TIPO_PROCEDIMIENTO t2, INTERVINIENTES t3, CENSO_MONITOR t4 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(
				inspeccionespropbandeja, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE t1.BAPRINSPCODIGO = t2.PCODIGO AND t1.BAPRINSESTABLEC = t3.ESCODIGO AND t1.BAPRINSEXCODIGO = t3.HDCODIGO AND t1.BAPRINSRESPEXP = t4.MOCODIGO ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the InspeccionesPropBandeja entity
	 * 
	 * @param inspeccionespropbandeja
	 *            InspeccionesPropBandeja Bean with the criteria values to
	 *            filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(
			InspeccionesPropBandeja inspeccionespropbandeja) {

		StringBuilder where = new StringBuilder(
				InspeccionesPropBandejaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (inspeccionespropbandeja != null
				&& inspeccionespropbandeja.getBaprinsid() != null) {
			where.append(" AND t1.BAPRINSID = ?");
			params.add(inspeccionespropbandeja.getBaprinsid());
		}
		if (inspeccionespropbandeja != null
				&& inspeccionespropbandeja.getBaprinsexcodigo() != null) {
			where.append(" AND t1.BAPRINSEXCODIGO = ?");
			params.add(inspeccionespropbandeja.getBaprinsexcodigo());
		}
		if (inspeccionespropbandeja != null
				&& inspeccionespropbandeja.getBaprinsexesdenuncia() != null) {
			where.append(" AND t1.BAPRINSEXESDENUNCIA = ?");
			params.add(inspeccionespropbandeja.getBaprinsexesdenuncia());
		}
		if (inspeccionespropbandeja != null
				&& inspeccionespropbandeja.getBaprinsexcodcompleto() != null) {
			where.append(" AND t1.BAPRINSEXCODCOMPLETO = ?");
			params.add(inspeccionespropbandeja.getBaprinsexcodcompleto());
		}
		if (inspeccionespropbandeja != null
				&& inspeccionespropbandeja.getBaprinstipoprocedimiento() != null
				&& inspeccionespropbandeja.getBaprinstipoprocedimiento()
						.getPcodigo() != null) {
			where.append(" AND t1.BAPRINSPCODIGO = ?");
			params.add(inspeccionespropbandeja.getBaprinstipoprocedimiento()
					.getPcodigo());
		}
		if (inspeccionespropbandeja != null
				&& inspeccionespropbandeja.getBaprinsfec() != null) {
			where.append(" AND t1.BAPRINSFEC = ?");
			params.add(inspeccionespropbandeja.getBaprinsfec());
		}
		if (inspeccionespropbandeja != null
				&& inspeccionespropbandeja.getBaprinsestablecimiento() != null
				&& inspeccionespropbandeja.getBaprinsestablecimiento()
						.getEscodigo() != null) {
			where.append(" AND t1.BAPRINSESTABLEC = ?");
			params.add(inspeccionespropbandeja.getBaprinsestablecimiento()
					.getEscodigo());
		}
		if (inspeccionespropbandeja != null
				&& inspeccionespropbandeja.getBaprinsprov() != null) {
			where.append(" AND t1.BAPRINSPROV = ?");
			params.add(inspeccionespropbandeja.getBaprinsprov());
		}
		if (inspeccionespropbandeja != null
				&& inspeccionespropbandeja.getBaprinsmunic() != null) {
			where.append(" AND t1.BAPRINSMUNIC = ?");
			params.add(inspeccionespropbandeja.getBaprinsmunic());
		}
		if (inspeccionespropbandeja != null
				&& inspeccionespropbandeja.getBaprinstipoprocedimiento() != null
				&& inspeccionespropbandeja.getBaprinstipoprocedimiento()
						.getPnombre() != null) {
			where.append(" AND t2.PNOMBRE = ?");
			params.add(inspeccionespropbandeja.getBaprinstipoprocedimiento()
					.getPnombre());
		}
		if (inspeccionespropbandeja != null
				&& inspeccionespropbandeja.getBaprinstipoprocedimiento() != null
				&& inspeccionespropbandeja.getBaprinstipoprocedimiento()
						.getPnombree() != null) {
			where.append(" AND t2.PNOMBREE = ?");
			params.add(inspeccionespropbandeja.getBaprinstipoprocedimiento()
					.getPnombree());
		}
		if (inspeccionespropbandeja != null
				&& inspeccionespropbandeja.getBaprinsestablecimiento() != null
				&& inspeccionespropbandeja.getBaprinsestablecimiento()
						.getEsnoco() != null) {
			where.append(" AND t3.ESNOCO = ?");
			params.add(inspeccionespropbandeja.getBaprinsestablecimiento()
					.getEsnoco());
		}
		if (inspeccionespropbandeja != null
				&& inspeccionespropbandeja.getBaprinsresponsable() != null
				&& inspeccionespropbandeja.getBaprinsresponsable()
						.getMocodigo() != null) {
			where.append(" AND t4.MOCODIGO = ?");
			params.add(inspeccionespropbandeja.getBaprinsresponsable()
					.getMocodigo());
		}
		if (inspeccionespropbandeja != null
				&& inspeccionespropbandeja.getBaprinsresponsable() != null
				&& inspeccionespropbandeja.getBaprinsresponsable()
						.getOrganismo() != null
				&& inspeccionespropbandeja.getBaprinsresponsable()
						.getOrganismo().getCodOrg() != null) {
			where.append(" AND t4.MOCOOR = ?");
			params.add(inspeccionespropbandeja.getBaprinsresponsable()
					.getOrganismo().getCodOrg());
		}
		if (inspeccionespropbandeja != null
				&& inspeccionespropbandeja.getBaprinscoor() != null) {
			where.append(" AND t1.BAPRINSCOOR = ?");
			params.add(inspeccionespropbandeja.getBaprinscoor());
		}
		if (inspeccionespropbandeja != null
				&& inspeccionespropbandeja.getBaprinsresponsable() != null
				&& inspeccionespropbandeja.getBaprinsresponsable()
						.getMonombre() != null) {
			where.append(" AND t4.MONOMBRE = ?");
			params.add(inspeccionespropbandeja.getBaprinsresponsable()
					.getMonombre());
		}
		if (inspeccionespropbandeja != null
				&& inspeccionespropbandeja.getBaprinsprovnombre() != null) {
			where.append(" AND t5.DS_O = ?");
			params.add(inspeccionespropbandeja.getBaprinsprovnombre());
		}
		if (inspeccionespropbandeja != null
				&& inspeccionespropbandeja.getBaprinsmunicnombre() != null) {
			where.append(" AND t6.DS_O = ?");
			params.add(inspeccionespropbandeja.getBaprinsmunicnombre());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generacion de codigo de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the InspeccionesPropBandeja entity
	 * 
	 * @param inspeccionespropbandeja
	 *            InspeccionesPropBandeja Bean with the criteria values to
	 *            filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(
			InspeccionesPropBandeja inspeccionespropbandeja, Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				InspeccionesPropBandejaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (inspeccionespropbandeja != null
				&& inspeccionespropbandeja.getBaprinsid() != null) {
			where.append(" AND UPPER(t1.BAPRINSID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(inspeccionespropbandeja.getBaprinsid().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ inspeccionespropbandeja.getBaprinsid().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.BAPRINSID IS NOT NULL");
		}
		if (inspeccionespropbandeja != null
				&& inspeccionespropbandeja.getBaprinsexcodigo() != null) {
			where.append(" AND UPPER(t1.BAPRINSEXCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(inspeccionespropbandeja.getBaprinsexcodigo()
						.toUpperCase() + "%");
			} else {
				params.add("%"
						+ inspeccionespropbandeja.getBaprinsexcodigo()
								.toUpperCase() + "%");
			}
			where.append(" AND t1.BAPRINSEXCODIGO IS NOT NULL");
		}
		if (inspeccionespropbandeja != null
				&& inspeccionespropbandeja.getBaprinsexesdenuncia() != null) {
			where.append(" AND UPPER(t1.BAPRINSEXESDENUNCIA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(inspeccionespropbandeja.getBaprinsexesdenuncia()
						.toUpperCase() + "%");
			} else {
				params.add("%"
						+ inspeccionespropbandeja.getBaprinsexesdenuncia()
								.toUpperCase() + "%");
			}
			where.append(" AND t1.BAPRINSEXESDENUNCIA IS NOT NULL");
		}
		if (inspeccionespropbandeja != null
				&& inspeccionespropbandeja.getBaprinsexcodcompleto() != null) {
			where.append(" AND UPPER(t1.BAPRINSEXCODCOMPLETO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(inspeccionespropbandeja.getBaprinsexcodcompleto()
						.toUpperCase() + "%");
			} else {
				params.add("%"
						+ inspeccionespropbandeja.getBaprinsexcodcompleto()
								.toUpperCase() + "%");
			}
			where.append(" AND t1.BAPRINSEXCODCOMPLETO IS NOT NULL");
		}
		if (inspeccionespropbandeja != null
				&& inspeccionespropbandeja.getBaprinstipoprocedimiento() != null
				&& inspeccionespropbandeja.getBaprinstipoprocedimiento()
						.getPcodigo() != null) {
			where.append(" AND UPPER(t1.BAPRINSPCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(inspeccionespropbandeja
						.getBaprinstipoprocedimiento().getPcodigo()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ inspeccionespropbandeja.getBaprinstipoprocedimiento()
								.getPcodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.BAPRINSPCODIGO IS NOT NULL");
		}
		if (inspeccionespropbandeja != null
				&& inspeccionespropbandeja.getBaprinsfec() != null) {
			where.append(" AND t1.BAPRINSFEC = ?");
			params.add(inspeccionespropbandeja.getBaprinsfec());
		}
		if (inspeccionespropbandeja != null
				&& inspeccionespropbandeja.getBaprinsestablecimiento() != null
				&& inspeccionespropbandeja.getBaprinsestablecimiento()
						.getEscodigo() != null) {
			where.append(" AND UPPER(t1.BAPRINSESTABLEC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(inspeccionespropbandeja.getBaprinsestablecimiento()
						.getEscodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ inspeccionespropbandeja.getBaprinsestablecimiento()
								.getEscodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.BAPRINSESTABLEC IS NOT NULL");
		}
		if (inspeccionespropbandeja != null
				&& inspeccionespropbandeja.getBaprinsprov() != null) {
			where.append(" AND UPPER(t1.BAPRINSPROV) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(inspeccionespropbandeja.getBaprinsprov()
						.toUpperCase() + "%");
			} else {
				params.add("%"
						+ inspeccionespropbandeja.getBaprinsprov()
								.toUpperCase() + "%");
			}
			where.append(" AND t1.BAPRINSPROV IS NOT NULL");
		}
		if (inspeccionespropbandeja != null
				&& inspeccionespropbandeja.getBaprinsmunic() != null) {
			where.append(" AND UPPER(t1.BAPRINSMUNIC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(inspeccionespropbandeja.getBaprinsmunic()
						.toUpperCase() + "%");
			} else {
				params.add("%"
						+ inspeccionespropbandeja.getBaprinsmunic()
								.toUpperCase() + "%");
			}
			where.append(" AND t1.BAPRINSMUNIC IS NOT NULL");
		}
		if (inspeccionespropbandeja != null
				&& inspeccionespropbandeja.getBaprinsresponsable() != null
				&& inspeccionespropbandeja.getBaprinsresponsable()
						.getMocodigo() != null) {
			where.append(" AND UPPER(t1.BAPRINSRESPEXP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(inspeccionespropbandeja.getBaprinsresponsable()
						.getMocodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ inspeccionespropbandeja.getBaprinsresponsable()
								.getMocodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.BAPRINSRESPEXP IS NOT NULL");
		}
		if (inspeccionespropbandeja != null
				&& inspeccionespropbandeja.getBaprinstipoprocedimiento() != null
				&& inspeccionespropbandeja.getBaprinstipoprocedimiento()
						.getPnombre() != null) {
			where.append(" AND UPPER(t2.PNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(inspeccionespropbandeja
						.getBaprinstipoprocedimiento().getPnombre()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ inspeccionespropbandeja.getBaprinstipoprocedimiento()
								.getPnombre().toUpperCase() + "%");
			}
			where.append(" AND t2.PNOMBRE IS NOT NULL");
		}
		if (inspeccionespropbandeja != null
				&& inspeccionespropbandeja.getBaprinstipoprocedimiento() != null
				&& inspeccionespropbandeja.getBaprinstipoprocedimiento()
						.getPnombree() != null) {
			where.append(" AND UPPER(t2.PNOMBREE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(inspeccionespropbandeja
						.getBaprinstipoprocedimiento().getPnombree()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ inspeccionespropbandeja.getBaprinstipoprocedimiento()
								.getPnombree().toUpperCase() + "%");
			}
			where.append(" AND t2.PNOMBREE IS NOT NULL");
		}
		if (inspeccionespropbandeja != null
				&& inspeccionespropbandeja.getBaprinsestablecimiento() != null
				&& inspeccionespropbandeja.getBaprinsestablecimiento()
						.getEsnoco() != null) {
			where.append(" AND UPPER(t3.ESNOCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(inspeccionespropbandeja.getBaprinsestablecimiento()
						.getEsnoco().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ inspeccionespropbandeja.getBaprinsestablecimiento()
								.getEsnoco().toUpperCase() + "%");
			}
			where.append(" AND t3.ESNOCO IS NOT NULL");
		}
		if (inspeccionespropbandeja != null
				&& inspeccionespropbandeja.getBaprinsresponsable() != null
				&& inspeccionespropbandeja.getBaprinsresponsable()
						.getOrganismo() != null
				&& inspeccionespropbandeja.getBaprinsresponsable()
						.getMocodigo() != null) {
			where.append(" AND UPPER(t4.MOCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(inspeccionespropbandeja.getBaprinsresponsable()
						.getMocodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ inspeccionespropbandeja.getBaprinsresponsable()
								.getMocodigo().toUpperCase() + "%");
			}
			where.append(" AND t4.MOCODIGO IS NOT NULL");
		}
		if (inspeccionespropbandeja != null
				&& inspeccionespropbandeja.getBaprinsresponsable() != null
				&& inspeccionespropbandeja.getBaprinsresponsable()
						.getOrganismo() != null
				&& inspeccionespropbandeja.getBaprinsresponsable()
						.getOrganismo().getCodOrg() != null) {
			where.append(" AND UPPER(t4.MOCOOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(inspeccionespropbandeja.getBaprinsresponsable()
						.getOrganismo().getCodOrg().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ inspeccionespropbandeja.getBaprinsresponsable()
								.getOrganismo().getCodOrg().toUpperCase() + "%");
			}
			where.append(" AND t4.MOCOOR IS NOT NULL");
		}
		if (inspeccionespropbandeja != null
				&& inspeccionespropbandeja.getBaprinscoor() != null) {
			where.append(" AND UPPER(t1.BAPRINSCOOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(inspeccionespropbandeja.getBaprinscoor()
						.toUpperCase() + "%");
			} else {
				params.add("%"
						+ inspeccionespropbandeja.getBaprinscoor()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.BAPRINSCOOR IS NOT NULL");
		}
		if (inspeccionespropbandeja != null
				&& inspeccionespropbandeja.getBaprinsresponsable() != null
				&& inspeccionespropbandeja.getBaprinsresponsable()
						.getMonombre() != null) {
			where.append(" AND UPPER(t4.MONOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(inspeccionespropbandeja.getBaprinsresponsable()
						.getMonombre().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ inspeccionespropbandeja.getBaprinsresponsable()
								.getMonombre().toUpperCase() + "%");
			}
			where.append(" AND t4.MONOMBRE IS NOT NULL");
		}
		if (inspeccionespropbandeja != null
				&& inspeccionespropbandeja.getBaprinsprovnombre() != null) {
			where.append(" AND UPPER(t5.DS_O) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(inspeccionespropbandeja.getBaprinsprovnombre()
						.toUpperCase() + "%");
			} else {
				params.add("%"
						+ inspeccionespropbandeja.getBaprinsprovnombre()
								.toUpperCase() + "%");
			}
			where.append(" AND t5.DS_O IS NOT NULL");
		}
		if (inspeccionespropbandeja != null
				&& inspeccionespropbandeja.getBaprinsmunicnombre() != null) {
			where.append(" AND UPPER(t6.DS_O) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(inspeccionespropbandeja.getBaprinsmunicnombre()
						.toUpperCase() + "%");
			} else {
				params.add("%"
						+ inspeccionespropbandeja.getBaprinsmunicnombre()
								.toUpperCase() + "%");
			}
			where.append(" AND t6.DS_O IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generacion de codigo de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
