package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.InfraccHechoDen;
import com.ejie.y41b.model.TipReqNormativo;
import com.ejie.y41b.model.Tipopronunciamento;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.InfraccHechoDenExpSanc;

/**
 * InfraccHechoDenExpSancDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class InfraccHechoDenExpSancDaoImpl implements InfraccHechoDenExpSancDao {
	private JdbcTemplate jdbcTemplate;

	private static final Logger logger = LoggerFactory
			.getLogger(InfraccHechoDenExpSancDaoImpl.class);

	private RowMapper<InfraccHechoDenExpSanc> rwMap = new RowMapper<InfraccHechoDenExpSanc>() {
		public InfraccHechoDenExpSanc mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			TipReqNormativo tipReqNormativo = new TipReqNormativo();
			tipReqNormativo.setTticodigo(resultSet
					.getString("InfraccHechoDenHICOTTI"));
			return new InfraccHechoDenExpSanc(resultSet.getString("DXCODIGO"),
					resultSet.getString("DXCOEX"), new InfraccHechoDen(
							resultSet.getString("InfraccHechoDenHICODIGO"),
							resultSet.getString("InfraccHechoDenHICOHD"),
							tipReqNormativo,
							resultSet.getString("InfraccHechoDenHIINEXII"),
							resultSet.getString("InfraccHechoDenHIIFID")),
					new Tipopronunciamento(resultSet
							.getString("TipopronunciamentoTTPCODIGO"),
							resultSet.getString("TipopronunciamentoTTPNOMBRE")));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the InfraccHechoDenExpSanc table.
	 * 
	 * @param infracchechodenexpsanc
	 *            Pagination
	 * @return InfraccHechoDenExpSanc
	 */
	public InfraccHechoDenExpSanc add(
			InfraccHechoDenExpSanc infracchechodenexpsanc) {
		String query = "INSERT INTO INFRACC_HECHO_DEN_EXP_SANC (DXCODIGO, DXCOHI, DXCOTTP, DXCOEX) VALUES (?,?,?,?)";
		Object getInfraccHechoDenHicodigoAux = null;
		if (infracchechodenexpsanc.getInfraccHechoDen() != null
				&& infracchechodenexpsanc.getInfraccHechoDen().getHicodigo() != null) {
			getInfraccHechoDenHicodigoAux = infracchechodenexpsanc
					.getInfraccHechoDen().getHicodigo();
		}
		Object getTipopronunciamentoTtpcodigoAux = null;
		if (infracchechodenexpsanc.getTipopronunciamento() != null
				&& infracchechodenexpsanc.getTipopronunciamento()
						.getTtpcodigo() != null) {
			getTipopronunciamentoTtpcodigoAux = infracchechodenexpsanc
					.getTipopronunciamento().getTtpcodigo();
		}
		this.jdbcTemplate.update(query, infracchechodenexpsanc.getDxcodigo(),
				getInfraccHechoDenHicodigoAux,
				getTipopronunciamentoTtpcodigoAux,
				infracchechodenexpsanc.getDxcoex());
		return infracchechodenexpsanc;
	}

	/**
	 * Updates a single row in the InfraccHechoDenExpSanc table.
	 * 
	 * @param infracchechodenexpsanc
	 *            Pagination
	 * @return InfraccHechoDenExpSanc
	 */
	public InfraccHechoDenExpSanc update(
			InfraccHechoDenExpSanc infracchechodenexpsanc) {
		String query = "UPDATE INFRACC_HECHO_DEN_EXP_SANC SET DXCOHI=?, DXCOTTP=?, DXCOEX=? WHERE DXCODIGO=?";
		Object getInfraccHechoDenHicodigoAux = null;
		if (infracchechodenexpsanc.getInfraccHechoDen() != null
				&& infracchechodenexpsanc.getInfraccHechoDen().getHicodigo() != null) {
			getInfraccHechoDenHicodigoAux = infracchechodenexpsanc
					.getInfraccHechoDen().getHicodigo();
		}
		Object getTipopronunciamentoTtpcodigoAux = null;
		if (infracchechodenexpsanc.getTipopronunciamento() != null
				&& infracchechodenexpsanc.getTipopronunciamento()
						.getTtpcodigo() != null) {
			getTipopronunciamentoTtpcodigoAux = infracchechodenexpsanc
					.getTipopronunciamento().getTtpcodigo();
		}
		this.jdbcTemplate.update(query, getInfraccHechoDenHicodigoAux,
				getTipopronunciamentoTtpcodigoAux,
				infracchechodenexpsanc.getDxcoex(),
				infracchechodenexpsanc.getDxcodigo());
		return infracchechodenexpsanc;
	}

	/**
	 * Finds a single row in the InfraccHechoDenExpSanc table.
	 * 
	 * @param infracchechodenexpsanc
	 *            Pagination
	 * @return InfraccHechoDenExpSanc
	 */
	@Transactional(readOnly = true)
	public InfraccHechoDenExpSanc find(
			InfraccHechoDenExpSanc infracchechodenexpsanc) {
		String query = "SELECT t1.DXCODIGO DXCODIGO, t1.DXCOEX DXCOEX, t2.HICODIGO INFRACCHECHODENHICODIGO, t2.HICOHD INFRACCHECHODENHICOHD, t2.HICOTTI INFRACCHECHODENHICOTTI, t2.HIINEXII INFRACCHECHODENHIINEXII, t2.HIIFID INFRACCHECHODENHIIFID, t3.TTPCODIGO TIPOPRONUNCIAMENTOTTPCODIGO, t3.TTPNOMBRE TIPOPRONUNCIAMENTOTTPNOMBRE FROM INFRACC_HECHO_DEN_EXP_SANC t1 , INFRACC_HECHO_DEN t2 , TIPOPRONUNCIAMENTO t3  WHERE t1.DXCODIGO = ?   AND t1.DXCOHI= t2.HICODIGO(+) AND t1.DXCOTTP= t3.TTPCODIGO(+)";

		List<InfraccHechoDenExpSanc> infracchechodenexpsancList = this.jdbcTemplate
				.query(query, this.rwMap, infracchechodenexpsanc.getDxcodigo());
		return (InfraccHechoDenExpSanc) DataAccessUtils
				.uniqueResult(infracchechodenexpsancList);
	}

	/**
	 * Removes a single row in the InfraccHechoDenExpSanc table.
	 * 
	 * @param infracchechodenexpsanc
	 *            Pagination
	 * @return
	 */
	public void remove(InfraccHechoDenExpSanc infracchechodenexpsanc) {
		String query = "DELETE FROM INFRACC_HECHO_DEN_EXP_SANC WHERE DXCODIGO=?";
		this.jdbcTemplate.update(query, infracchechodenexpsanc.getDxcodigo());
	}

	public void borraArticulosMaterias(String codigoExpediente) {
		String query = "DELETE FROM INFRACC_HECHO_DEN_EXP_SANC WHERE DXCOEX = ?";
		this.jdbcTemplate.update(query, codigoExpediente);
	}

	/**
	 * Finds a List of rows in the InfraccHechoDenExpSanc table.
	 * 
	 * @param infracchechodenexpsanc
	 *            InfraccHechoDenExpSanc
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<InfraccHechoDenExpSanc> findAll(
			InfraccHechoDenExpSanc infracchechodenexpsanc, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.DXCODIGO DXCODIGO,t1.DXCOEX DXCOEX,t2.HICODIGO INFRACCHECHODENHICODIGO,t2.HICOHD INFRACCHECHODENHICOHD,t2.HICOTTI INFRACCHECHODENHICOTTI,t2.HIINEXII INFRACCHECHODENHIINEXII,t2.HIIFID INFRACCHECHODENHIIFID,t3.TTPCODIGO TIPOPRONUNCIAMENTOTTPCODIGO,t3.TTPNOMBRE TIPOPRONUNCIAMENTOTTPNOMBRE ");
		query.append("FROM INFRACC_HECHO_DEN_EXP_SANC t1 ,INFRACC_HECHO_DEN t2 ,TIPOPRONUNCIAMENTO t3 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(infracchechodenexpsanc);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.DXCOHI= t2.HICODIGO(+) AND t1.DXCOTTP= t3.TTPCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<InfraccHechoDenExpSanc>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the InfraccHechoDenExpSanc table.
	 * 
	 * @param infracchechodenexpsanc
	 *            InfraccHechoDenExpSanc
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(InfraccHechoDenExpSanc infracchechodenexpsanc) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM INFRACC_HECHO_DEN_EXP_SANC t1 , INFRACC_HECHO_DEN t2 , TIPOPRONUNCIAMENTO t3 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(infracchechodenexpsanc);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.DXCOHI= t2.HICODIGO(+) AND t1.DXCOTTP= t3.TTPCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the InfraccHechoDenExpSanc table using like.
	 * 
	 * @param infracchechodenexpsanc
	 *            InfraccHechoDenExpSanc
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<InfraccHechoDenExpSanc> findAllLike(
			InfraccHechoDenExpSanc infracchechodenexpsanc,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.DXCODIGO DXCODIGO,t1.DXCOEX DXCOEX,t2.HICODIGO INFRACCHECHODENHICODIGO,t2.HICOHD INFRACCHECHODENHICOHD,t2.HICOTTI INFRACCHECHODENHICOTTI,t2.HIINEXII INFRACCHECHODENHIINEXII,t2.HIIFID INFRACCHECHODENHIIFID,t3.TTPCODIGO TIPOPRONUNCIAMENTOTTPCODIGO,t3.TTPNOMBRE TIPOPRONUNCIAMENTOTTPNOMBRE ");
		query.append("FROM INFRACC_HECHO_DEN_EXP_SANC t1 ,INFRACC_HECHO_DEN t2 ,TIPOPRONUNCIAMENTO t3 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(infracchechodenexpsanc,
				startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.DXCOHI= t2.HICODIGO(+) AND t1.DXCOTTP= t3.TTPCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<InfraccHechoDenExpSanc>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the InfraccHechoDenExpSanc table using like.
	 * 
	 * @param infracchechodenexpsanc
	 *            InfraccHechoDenExpSanc
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(InfraccHechoDenExpSanc infracchechodenexpsanc,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM INFRACC_HECHO_DEN_EXP_SANC t1 ,INFRACC_HECHO_DEN t2 ,TIPOPRONUNCIAMENTO t3 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(infracchechodenexpsanc,
				startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.DXCOHI= t2.HICODIGO(+) AND t1.DXCOTTP= t3.TTPCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the InfraccHechoDenExpSanc entity
	 * 
	 * @param infracchechodenexpsanc
	 *            InfraccHechoDenExpSanc Bean with the criteria values to filter
	 *            by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(
			InfraccHechoDenExpSanc infracchechodenexpsanc) {

		StringBuilder where = new StringBuilder(
				InfraccHechoDenExpSancDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (infracchechodenexpsanc != null
				&& infracchechodenexpsanc.getDxcodigo() != null) {
			where.append(" AND t1.DXCODIGO = ?");
			params.add(infracchechodenexpsanc.getDxcodigo());
		}
		if (infracchechodenexpsanc != null
				&& infracchechodenexpsanc.getInfraccHechoDen() != null
				&& infracchechodenexpsanc.getInfraccHechoDen().getHicodigo() != null) {
			where.append(" AND t2.HICODIGO = ?");
			params.add(infracchechodenexpsanc.getInfraccHechoDen()
					.getHicodigo());
		}
		if (infracchechodenexpsanc != null
				&& infracchechodenexpsanc.getInfraccHechoDen() != null
				&& infracchechodenexpsanc.getInfraccHechoDen().getHicohd() != null) {
			where.append(" AND t2.HICOHD = ?");
			params.add(infracchechodenexpsanc.getInfraccHechoDen().getHicohd());
		}
		if (infracchechodenexpsanc != null
				&& infracchechodenexpsanc.getInfraccHechoDen() != null
				&& infracchechodenexpsanc.getInfraccHechoDen()
						.getTipReqNormativo() != null
				&& infracchechodenexpsanc.getInfraccHechoDen()
						.getTipReqNormativo().getTticodigo() != null) {
			where.append(" AND t2.HICOTTI = ?");
			params.add(infracchechodenexpsanc.getInfraccHechoDen()
					.getTipReqNormativo().getTticodigo());
		}
		if (infracchechodenexpsanc != null
				&& infracchechodenexpsanc.getInfraccHechoDen() != null
				&& infracchechodenexpsanc.getInfraccHechoDen().getHiinexii() != null) {
			where.append(" AND t2.HIINEXII = ?");
			params.add(infracchechodenexpsanc.getInfraccHechoDen()
					.getHiinexii());
		}
		if (infracchechodenexpsanc != null
				&& infracchechodenexpsanc.getInfraccHechoDen() != null
				&& infracchechodenexpsanc.getInfraccHechoDen().getHiifid() != null) {
			where.append(" AND t2.HIIFID = ?");
			params.add(infracchechodenexpsanc.getInfraccHechoDen().getHiifid());
		}
		if (infracchechodenexpsanc != null
				&& infracchechodenexpsanc.getTipopronunciamento() != null
				&& infracchechodenexpsanc.getTipopronunciamento()
						.getTtpcodigo() != null) {
			where.append(" AND t3.TTPCODIGO = ?");
			params.add(infracchechodenexpsanc.getTipopronunciamento()
					.getTtpcodigo());
		}
		if (infracchechodenexpsanc != null
				&& infracchechodenexpsanc.getTipopronunciamento() != null
				&& infracchechodenexpsanc.getTipopronunciamento()
						.getTtpnombre() != null) {
			where.append(" AND t3.TTPNOMBRE = ?");
			params.add(infracchechodenexpsanc.getTipopronunciamento()
					.getTtpnombre());
		}
		if (infracchechodenexpsanc != null
				&& infracchechodenexpsanc.getDxcoex() != null) {
			where.append(" AND t1.DXCOEX = ?");
			params.add(infracchechodenexpsanc.getDxcoex());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the InfraccHechoDenExpSanc entity
	 * 
	 * @param infracchechodenexpsanc
	 *            InfraccHechoDenExpSanc Bean with the criteria values to filter
	 *            by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(
			InfraccHechoDenExpSanc infracchechodenexpsanc, Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				InfraccHechoDenExpSancDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (infracchechodenexpsanc != null
				&& infracchechodenexpsanc.getDxcodigo() != null) {
			where.append(" AND UPPER(t1.DXCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(infracchechodenexpsanc.getDxcodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ infracchechodenexpsanc.getDxcodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.DXCODIGO IS NOT NULL");
		}
		if (infracchechodenexpsanc != null
				&& infracchechodenexpsanc.getInfraccHechoDen() != null
				&& infracchechodenexpsanc.getInfraccHechoDen().getHicodigo() != null) {
			where.append(" AND t2.HICODIGO = ?");
			params.add(infracchechodenexpsanc.getInfraccHechoDen()
					.getHicodigo());
		}
		if (infracchechodenexpsanc != null
				&& infracchechodenexpsanc.getInfraccHechoDen() != null
				&& infracchechodenexpsanc.getInfraccHechoDen().getHicohd() != null) {
			where.append(" AND UPPER(t2.HICOHD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(infracchechodenexpsanc.getInfraccHechoDen()
						.getHicohd().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ infracchechodenexpsanc.getInfraccHechoDen()
								.getHicohd().toUpperCase() + "%");
			}
			where.append(" AND t2.HICOHD IS NOT NULL");
		}
		if (infracchechodenexpsanc != null
				&& infracchechodenexpsanc.getInfraccHechoDen() != null
				&& infracchechodenexpsanc.getInfraccHechoDen()
						.getTipReqNormativo() != null
				&& infracchechodenexpsanc.getInfraccHechoDen()
						.getTipReqNormativo().getTticodigo() != null) {
			where.append(" AND UPPER(t2.HICOTTI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(infracchechodenexpsanc.getInfraccHechoDen()
						.getTipReqNormativo().getTticodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ infracchechodenexpsanc.getInfraccHechoDen()
								.getTipReqNormativo().getTticodigo()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.HICOTTI IS NOT NULL");
		}
		if (infracchechodenexpsanc != null
				&& infracchechodenexpsanc.getInfraccHechoDen() != null
				&& infracchechodenexpsanc.getInfraccHechoDen().getHiinexii() != null) {
			where.append(" AND UPPER(t2.HIINEXII) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(infracchechodenexpsanc.getInfraccHechoDen()
						.getHiinexii().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ infracchechodenexpsanc.getInfraccHechoDen()
								.getHiinexii().toUpperCase() + "%");
			}
			where.append(" AND t2.HIINEXII IS NOT NULL");
		}
		if (infracchechodenexpsanc != null
				&& infracchechodenexpsanc.getInfraccHechoDen() != null
				&& infracchechodenexpsanc.getInfraccHechoDen().getHiifid() != null) {
			where.append(" AND UPPER(t2.HIIFID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(infracchechodenexpsanc.getInfraccHechoDen()
						.getHiifid().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ infracchechodenexpsanc.getInfraccHechoDen()
								.getHiifid().toUpperCase() + "%");
			}
			where.append(" AND t2.HIIFID IS NOT NULL");
		}
		if (infracchechodenexpsanc != null
				&& infracchechodenexpsanc.getTipopronunciamento() != null
				&& infracchechodenexpsanc.getTipopronunciamento()
						.getTtpcodigo() != null) {
			where.append(" AND t3.TTPCODIGO = ?");
			params.add(infracchechodenexpsanc.getTipopronunciamento()
					.getTtpcodigo());
		}
		if (infracchechodenexpsanc != null
				&& infracchechodenexpsanc.getTipopronunciamento() != null
				&& infracchechodenexpsanc.getTipopronunciamento()
						.getTtpnombre() != null) {
			where.append(" AND UPPER(t3.TTPNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(infracchechodenexpsanc.getTipopronunciamento()
						.getTtpnombre().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ infracchechodenexpsanc.getTipopronunciamento()
								.getTtpnombre().toUpperCase() + "%");
			}
			where.append(" AND t3.TTPNOMBRE IS NOT NULL");
		}
		if (infracchechodenexpsanc != null
				&& infracchechodenexpsanc.getDxcoex() != null) {
			where.append(" AND UPPER(t1.DXCOEX) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(infracchechodenexpsanc.getDxcoex().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ infracchechodenexpsanc.getDxcoex().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.DXCOEX IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ejie.y41b.dao.InfraccHechoDenDao#findArticulos(java.lang.String)
	 */
	@Transactional(readOnly = true)
	public boolean existeArticuloMateria(String codigoExpediente, String hicotti) {

		StringBuilder prequery = new StringBuilder("SELECT count(1) FROM (");

		StringBuilder query = new StringBuilder(
				"SELECT  t1.HICODIGO HICODIGO,t1.HICOHD HICOHD,t1.HICOTTI HICOTTI,t1.HIINEXII HIINEXII,t1.HIIFID HIIFID, t3.TTINOMBRE TTINOMBRE, t3.TTICODIGO TTICODIGO, t3.TTINOMBREE TTINOMBREE,'A' as tipo ");
		query.append(" FROM INFRACC_HECHO_DEN t1,INFRACC_HECHO_DEN_EXP_SANC t2,TIP_REQ_NORMATIVO t3 ");

		StringBuilder where = new StringBuilder(
				" WHERE t2.DXCOEX = ? AND t1.HICOTTI=? AND t1.HIINEXII = 'S'");
		where.append(" AND t1.HICODIGO = t2.DXCOHI AND t1.HICOTTI =t3.TTICODIGO ");

		query.append(where);

		StringBuilder query2 = new StringBuilder(
				"SELECT  t1.HICODIGO HICODIGO,t1.HICOHD HICOHD,t1.HICOTTI HICOTTI,t1.HIINEXII HIINEXII,t1.HIIFID HIIFID, t3.TTINOMBRE TTINOMBRE, t3.TTICODIGO TTICODIGO, t3.TTINOMBREE TTINOMBREE,'M' as tipo ");
		query2.append("FROM INFRACC_HECHO_DEN t1, INFRACC_HECHO_DEN_EXP_SANC t2,TIP_REQ_NORMATIVO t3 WHERE t1.HICODIGO = t2.DXCOHI AND t1.HICOTTI =t3.TTICODIGO ");

		StringBuilder where2 = new StringBuilder(
				" AND t2.DXCOEX = ? AND t1.HICOTTI=? AND t1.HIINEXII IS NULL");

		query2.append(where2);

		StringBuilder postquery = new StringBuilder(") tunion WHERE 1=1 ");

		List<Object> params = new ArrayList<Object>();
		params.add(codigoExpediente);
		params.add(hicotti);
		params.add(codigoExpediente);
		params.add(hicotti);

		query = prequery.append(query).append(" UNION ").append(query2)
				.append(postquery);

		InfraccHechoDenExpSancDaoImpl.logger.info("[SQL_ARTICULOS]"
				+ query.toString() + ".EXPEDIEN." + codigoExpediente + ".");

		return (this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray()) > 0);

	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
