package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.InfraccHechoDen;
import com.ejie.y41b.model.TipReqNormativo;
import com.ejie.y41b.model.TramiteComun;

/**
 * InfraccHechoDenDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class InfraccHechoDenDaoImpl implements InfraccHechoDenDao {
	private JdbcTemplate jdbcTemplate;

	private static final Logger logger = LoggerFactory.getLogger(InfraccHechoDenDaoImpl.class);

	private RowMapper<InfraccHechoDen> rwMapArticulos = new RowMapper<InfraccHechoDen>() {
		public InfraccHechoDen mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			TipReqNormativo tipReqNormativo = new TipReqNormativo();
			tipReqNormativo.setTticodigo(resultSet.getString("HICOTTI"));
			tipReqNormativo.setTtinombre(resultSet.getString("TTINOMBRE"));
			tipReqNormativo.setTtinombree(resultSet.getString("TTINOMBREE"));
			return new InfraccHechoDen(resultSet.getString("HICODIGO"), resultSet.getString("HICOHD"), tipReqNormativo,
					resultSet.getString("HIINEXII"), resultSet.getString("HIIFID"));
		}

	};

	private RowMapper<InfraccHechoDen> rwMapArticulosMaterias = new RowMapper<InfraccHechoDen>() {
		public InfraccHechoDen mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			TipReqNormativo tipReqNormativo = new TipReqNormativo();
			tipReqNormativo.setTticodigo(resultSet.getString("HICOTTI"));
			tipReqNormativo.setTtinombre(resultSet.getString("TTINOMBRE"));
			return new InfraccHechoDen(resultSet.getString("HICODIGO"), resultSet.getString("HICOHD"), tipReqNormativo,
					resultSet.getString("HIINEXII"), resultSet.getString("HIIFID"), resultSet.getString("tipo"));
		}

	};

	private RowMapper<InfraccHechoDen> rwMap = new RowMapper<InfraccHechoDen>() {
		public InfraccHechoDen mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			TipReqNormativo tipReqNormativo = new TipReqNormativo();
			tipReqNormativo.setTticodigo(resultSet.getString("HICOTTI"));
			tipReqNormativo.setTtinombre(resultSet.getString("TTINOMBRE"));
			tipReqNormativo.setTtinombree(resultSet.getString("TTINOMBREE"));

			return new InfraccHechoDen(resultSet.getString("HICODIGO"), resultSet.getString("HICOHD"), tipReqNormativo,
					resultSet.getString("HIINEXII"), resultSet.getString("HIIFID"));
		}

	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the InfraccHechoDen table.
	 * 
	 * @param infracchechoden
	 *            Pagination
	 * @return InfraccHechoDen
	 */
	public InfraccHechoDen add(InfraccHechoDen infracchechoden) {
		String query = "INSERT INTO INFRACC_HECHO_DEN (HICODIGO, HICOHD, HICOTTI, HIINEXII, HIIFID) VALUES (?,?,?,?,?)";
		this.jdbcTemplate.update(query, infracchechoden.getHicodigo(), infracchechoden.getHicohd(),
				infracchechoden.getTipReqNormativo() == null ? null
						: infracchechoden.getTipReqNormativo().getTticodigo(),
				infracchechoden.getHiinexii(), infracchechoden.getHiifid());
		return infracchechoden;
	}

	/**
	 * Inserts a single row in the InfraccHechoDen table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	public void addAllInfraccionesHechoAdjuntarInfracciones(TramiteComun tramiteComun) {

		String query = "INSERT INTO INFRACC_HECHO_DEN (HICODIGO, HICOHD, HICOTTI, HIINEXII, HIIFID) SELECT HICODIGO, HICOHD, HICOTTI, HIINEXII, HIIFID FROM ADJUN_INFRACC_HECHO_DENUN WHERE HICOHD = ? ";
		this.jdbcTemplate.update(query, tramiteComun.getIdExpediente());
	}

	/**
	 * Inserts a single row in the InfraccHechoDen table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return modificaciones
	 */
	public int addAllInfraccionesHechoAdjuntarInfraccionesControlMercado(TramiteComun tramiteComun) {

		String query = "INSERT INTO ACTA_INFRACCION (AICODIGO, AICOAT, AICOTTI, AIINEXII, AICOTP) SELECT HICODIGO, HICOHD, HICOTTI, HIINEXII, HICOTP FROM ADJUN_INFRACC_HECHO_DENUN WHERE HICOHD = ? ";
		return this.jdbcTemplate.update(query, tramiteComun.getIdExpediente());
	}

	/**
	 * Inserts a single row in the AdjunInfraccHechoDenun table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	public void addAdjuntarInfracciones(TramiteComun tramiteComun) {

		String query = "INSERT INTO ADJUN_INFRACC_HECHO_DENUN (HICODIGO, HICOHD, HICOTTI, HIINEXII, HIIFID) SELECT HICODIGO, HICOHD, HICOTTI, HIINEXII, HIIFID FROM INFRACC_HECHO_DEN  WHERE HICOHD = ?";
		this.jdbcTemplate.update(query, tramiteComun.getIdExpediente());
	}

	/**
	 * Inserts a single row in the AdjunInfraccHechoDenun table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */

	public void addAdjuntarInfraccionesControlMercado(TramiteComun tramiteComun) {
		// 0207976: Error en registro decisin cuando se repiten cdigos de
		// infraccin en distintas actas de una inspeccin.
		// String query = "INSERT INTO ADJUN_INFRACC_HECHO_DENUN (HICODIGO,
		// HICOHD, HICOTTI, HIINEXII, HICOTP) SELECT AICODIGO, AICOAT, AICOTTI,
		// AIINEXII, AICOTP FROM ACTA_INFRACCION WHERE AICOAT = ?";
		String query = "INSERT INTO ADJUN_INFRACC_HECHO_DENUN (HICODIGO, HICOHD, HICOTTI, HIINEXII, HICOTP) SELECT t.aicodigo, t.aicoat, t.aicotti, t.aiinexii, t.aicotp FROM "
				+ "(SELECT o.* , ROW_NUMBER() OVER (PARTITION BY o.aicotti ORDER BY o.aicotti) rn FROM acta_infraccion o where  aicoat = ?) t WHERE rn = 1";
		this.jdbcTemplate.update(query, tramiteComun.getIdExpediente());
	}

	/**
	 * Updates a single row in the InfraccHechoDen table.
	 * 
	 * @param infracchechoden
	 *            Pagination
	 * @return InfraccHechoDen
	 */
	public InfraccHechoDen update(InfraccHechoDen infracchechoden) {
		String query = "UPDATE INFRACC_HECHO_DEN SET HICOHD=?, HICOTTI=?, HIINEXII=?, HIIFID=? WHERE HICODIGO=?";
		this.jdbcTemplate.update(query, infracchechoden.getHicohd(),
				infracchechoden.getTipReqNormativo() == null ? null
						: infracchechoden.getTipReqNormativo().getTticodigo(),
				infracchechoden.getHiinexii(), infracchechoden.getHiifid(), infracchechoden.getHicodigo());
		return infracchechoden;
	}

	/**
	 * Finds a single row in the InfraccHechoDen table.
	 * 
	 * @param infracchechoden
	 *            Pagination
	 * @return InfraccHechoDen
	 */
	@Transactional(readOnly = true)
	public InfraccHechoDen find(InfraccHechoDen infracchechoden) {
		String query = "SELECT t1.HICODIGO HICODIGO, t1.HICOHD HICOHD, t1.HICOTTI HICOTTI, t1.HIINEXII HIINEXII, t1.HIIFID HIIFID, t2.TTINOMBRE TTINOMBRE, t2.TTINOMBREE TTINOMBREE FROM INFRACC_HECHO_DEN t1, TIP_REQ_NORMATIVO t2 WHERE t1.HICOTTI = t2.TTICODIGO AND t1.HICODIGO = ?  ";

		List<InfraccHechoDen> infracchechodenList = this.jdbcTemplate.query(query, this.rwMap,
				infracchechoden.getHicodigo());
		return (InfraccHechoDen) DataAccessUtils.uniqueResult(infracchechodenList);
	}

	/**
	 * Removes a single row in the InfraccHechoDen table.
	 * 
	 * @param infracchechoden
	 *            Pagination
	 * @return
	 */
	public void remove(InfraccHechoDen infracchechoden) {
		String query = "DELETE FROM INFRACC_HECHO_DEN WHERE HICODIGO=?";
		this.jdbcTemplate.update(query, infracchechoden.getHicodigo());
	}

	/**
	 * Deletes a single row in the InfraccHechoDen table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return
	 */
	public void removeAllInfraccionesHecho(TramiteComun tramiteComun) {
		String query = "DELETE  FROM INFRACC_HECHO_DEN " + " WHERE HICOHD=?";

		this.jdbcTemplate.update(query, tramiteComun.getIdExpediente());
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.y41b.dao.InfraccHechoDenDao#borraArticulosMaterias(java.lang
	 * .String)
	 */
	public void borraArticulosMaterias(String codigoExpediente) {
		String query = "DELETE FROM INFRACC_HECHO_DEN WHERE HICODIGO IN (SELECT DXCOHI FROM INFRACC_HECHO_DEN_EXP_SANC WHERE DXCOEX = ?)";
		this.jdbcTemplate.update(query, codigoExpediente);
	}

	/**
	 * Finds a List of rows in the InfraccHechoDen table.
	 * 
	 * @param infracchechoden
	 *            InfraccHechoDen
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<InfraccHechoDen> findAll(InfraccHechoDen infracchechoden, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.HICODIGO HICODIGO,t1.HICOHD HICOHD,t1.HICOTTI HICOTTI,t1.HIINEXII HIINEXII,t1.HIIFID HIIFID, t2.TTINOMBRE TTINOMBRE, t2.TTINOMBREE TTINOMBREE ");
		query.append("FROM INFRACC_HECHO_DEN t1, TIP_REQ_NORMATIVO t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(infracchechoden);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.HICOTTI = t2.TTICODIGO ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<InfraccHechoDen>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ejie.y41b.dao.InfraccHechoDenDao#findArticulos(java.lang.String)
	 */
	@Transactional(readOnly = true)
	public List<InfraccHechoDen> findArticulosMaterias(String codigoExpediente, Pagination pagination) {

		StringBuilder prequery = new StringBuilder("SELECT tunion.* FROM (");

		StringBuilder query = new StringBuilder(
				"SELECT  t1.HICODIGO HICODIGO,t1.HICOHD HICOHD,t1.HICOTTI HICOTTI,t1.HIINEXII HIINEXII,t1.HIIFID HIIFID, t3.TTINOMBRE TTINOMBRE, t3.TTICODIGO TTICODIGO, t3.TTINOMBREE TTINOMBREE,'A' as tipo ");
		query.append(" FROM INFRACC_HECHO_DEN t1,INFRACC_HECHO_DEN_EXP_SANC t2,TIP_REQ_NORMATIVO t3 ");

		StringBuilder where = new StringBuilder(" WHERE t2.DXCOEX = ? AND t1.HIINEXII = 'S'");
		where.append(" AND t1.HICODIGO = t2.DXCOHI AND t1.HICOTTI =t3.TTICODIGO ");

		query.append(where);

		StringBuilder query2 = new StringBuilder(
				"SELECT  t1.HICODIGO HICODIGO,t1.HICOHD HICOHD,t1.HICOTTI HICOTTI,t1.HIINEXII HIINEXII,t1.HIIFID HIIFID, t3.TTINOMBRE TTINOMBRE, t3.TTICODIGO TTICODIGO, t3.TTINOMBREE TTINOMBREE,'M' as tipo ");
		query2.append(
				"FROM INFRACC_HECHO_DEN t1, INFRACC_HECHO_DEN_EXP_SANC t2,TIP_REQ_NORMATIVO t3 WHERE t1.HICODIGO = t2.DXCOHI AND t1.HICOTTI =t3.TTICODIGO ");

		StringBuilder where2 = new StringBuilder(" AND t2.DXCOEX = ? AND t1.HIINEXII IS NULL");
		query2.append(where2);

		StringBuilder postquery = new StringBuilder(") tunion WHERE 1=1 ");

		if (pagination != null) {
			query = pagination
					.getPaginationQuery(prequery.append(query).append(" UNION ").append(query2).append(postquery));
		} else {
			query = prequery.append(query).append(" UNION ").append(query2).append(postquery);
		}

		List<Object> params = new ArrayList<Object>();
		params.add(codigoExpediente);
		params.add(codigoExpediente);

		InfraccHechoDenDaoImpl.logger
				.info("[SQL_ARTICULOS]" + query.toString() + ".EXPEDIEN." + codigoExpediente + ".");

		return (List<InfraccHechoDen>) this.jdbcTemplate.query(query.toString(), this.rwMapArticulosMaterias,
				params.toArray());

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ejie.y41b.dao.InfraccHechoDenDao#findArticulos(java.lang.String)
	 */
	@Transactional(readOnly = true)
	public Long findArticulosMateriasCount(String codigoExpediente) {

		StringBuilder prequery = new StringBuilder("SELECT count(1) FROM (");

		StringBuilder query = new StringBuilder(
				"SELECT  t1.HICODIGO HICODIGO,t1.HICOHD HICOHD,t1.HICOTTI HICOTTI,t1.HIINEXII HIINEXII,t1.HIIFID HIIFID, t3.TTINOMBRE TTINOMBRE, t3.TTICODIGO TTICODIGO, t3.TTINOMBREE TTINOMBREE,'A' as tipo ");
		query.append(" FROM INFRACC_HECHO_DEN t1,INFRACC_HECHO_DEN_EXP_SANC t2,TIP_REQ_NORMATIVO t3 ");

		StringBuilder where = new StringBuilder(" WHERE t2.DXCOEX = ? AND t1.HIINEXII = 'S'");
		where.append(" AND t1.HICODIGO = t2.DXCOHI AND t1.HICOTTI =t3.TTICODIGO ");

		query.append(where);

		StringBuilder query2 = new StringBuilder(
				"SELECT  t1.HICODIGO HICODIGO,t1.HICOHD HICOHD,t1.HICOTTI HICOTTI,t1.HIINEXII HIINEXII,t1.HIIFID HIIFID, t3.TTINOMBRE TTINOMBRE, t3.TTICODIGO TTICODIGO, t3.TTINOMBREE TTINOMBREE,'M' as tipo ");
		query2.append(
				"FROM INFRACC_HECHO_DEN t1, INFRACC_HECHO_DEN_EXP_SANC t2,TIP_REQ_NORMATIVO t3 WHERE t1.HICODIGO = t2.DXCOHI AND t1.HICOTTI =t3.TTICODIGO ");

		StringBuilder where2 = new StringBuilder(" AND t2.DXCOEX = ? AND t1.HIINEXII IS NULL");

		query2.append(where2);

		StringBuilder postquery = new StringBuilder(") tunion WHERE 1=1 ");

		List<Object> params = new ArrayList<Object>();
		params.add(codigoExpediente);
		params.add(codigoExpediente);

		query = prequery.append(query).append(" UNION ").append(query2).append(postquery);

		InfraccHechoDenDaoImpl.logger
				.info("[SQL_ARTICULOS]" + query.toString() + ".EXPEDIEN." + codigoExpediente + ".");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ejie.y41b.dao.InfraccHechoDenDao#findArticulos(java.lang.String)
	 */
	@Transactional(readOnly = true)
	public List<InfraccHechoDen> findArticulos(String codigoExpediente, Pagination pagination) {

		StringBuilder query = new StringBuilder(
				"SELECT  t1.HICODIGO HICODIGO,t1.HICOHD HICOHD,t1.HICOTTI HICOTTI,t1.HIINEXII HIINEXII,t1.HIIFID HIIFID, t3.TTINOMBRE TTINOMBRE, t3.TTICODIGO TTICODIGO, t3.TTINOMBREE TTINOMBREE,'A' as tipo ");
		query.append(" FROM INFRACC_HECHO_DEN t1,INFRACC_HECHO_DEN_EXP_SANC t2,TIP_REQ_NORMATIVO t3 ");

		StringBuilder where = new StringBuilder(" WHERE t2.DXCOEX = ? AND t1.HIINEXII = 'S'");
		where.append(" AND t1.HICODIGO = t2.DXCOHI AND t1.HICOTTI =t3.TTICODIGO ");

		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		List<Object> params = new ArrayList<Object>();
		params.add(codigoExpediente);

		return (List<InfraccHechoDen>) this.jdbcTemplate.query(query.toString(), this.rwMapArticulos, params.toArray());

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.y41b.dao.InfraccHechoDenDao#findAllArticulosSolicitudesCount
	 * (java.lang.String)
	 */
	@Transactional(readOnly = true)
	public Long findAllArticulosSolicitudesCount(String codigoExpediente) {

		StringBuilder query = new StringBuilder("SELECT  count(1) ");
		query.append("FROM ADJUN_INFRACC_HECHO_DENUN WHERE 1=1 ");

		StringBuilder where = new StringBuilder(" AND HICOHD = ? AND HIINEXII= 'S'");

		query.append(where);

		List<Object> params = new ArrayList<Object>();
		params.add(codigoExpediente);

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ejie.y41b.dao.InfraccHechoDenDao#findMaterias(java.lang.String)
	 */
	@Transactional(readOnly = true)
	public List<InfraccHechoDen> findMaterias(String codigoExpediente, Pagination pagination) {

		StringBuilder query = new StringBuilder(
				"SELECT  t1.HICODIGO HICODIGO,t1.HICOHD HICOHD,t1.HICOTTI HICOTTI,t1.HIINEXII HIINEXII,t1.HIIFID HIIFID, t3.TTINOMBRE TTINOMBRE, t3.TTICODIGO TTICODIGO, t3.TTINOMBREE TTINOMBREE ");
		query.append(
				"FROM INFRACC_HECHO_DEN t1, INFRACC_HECHO_DEN_EXP_SANC t2,TIP_REQ_NORMATIVO t3 WHERE t1.HICODIGO = t2.DXCOHI AND t1.HICOTTI =t3.TTICODIGO ");

		StringBuilder where = new StringBuilder(" AND DXCOEX = ? AND HIINEXII IS NULL");

		query.append(where);

		List<Object> params = new ArrayList<Object>();
		params.add(codigoExpediente);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<InfraccHechoDen>) this.jdbcTemplate.query(query.toString(), this.rwMapArticulos, params.toArray());
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ejie.y41b.dao.InfraccHechoDenDao#findArticulos(java.lang.String)
	 */
	@Transactional(readOnly = true)
	public Long findMateriasCount(String codigoExpediente) {

		StringBuilder query = new StringBuilder("SELECT  count(1) ");
		query.append(
				"FROM INFRACC_HECHO_DEN t1, INFRACC_HECHO_DEN_EXP_SANC t2,TIP_REQ_NORMATIVO t3 WHERE t1.HICODIGO = t2.DXCOHI AND t1.HICOTTI =t3.TTICODIGO ");

		StringBuilder where = new StringBuilder(" AND DXCOEX = ? AND HIINEXII IS NULL");

		query.append(where);

		List<Object> params = new ArrayList<Object>();
		params.add(codigoExpediente);

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.y41b.dao.InfraccHechoDenDao#findAllMateriasSolicitudesCount(
	 * java.lang.String)
	 */
	@Transactional(readOnly = true)
	public Long findAllMateriasSolicitudesCount(String codigoExpediente) {

		StringBuilder query = new StringBuilder("SELECT  count(1) ");
		query.append("FROM ADJUN_INFRACC_HECHO_DENUN WHERE 1=1 ");

		StringBuilder where = new StringBuilder(" AND HICOHD = ? AND HIINEXII IS NULL");

		query.append(where);

		List<Object> params = new ArrayList<Object>();
		params.add(codigoExpediente);

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());

	}

	/**
	 * Counts rows in the InfraccHechoDen table.
	 * 
	 * @param infracchechoden
	 *            InfraccHechoDen
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(InfraccHechoDen infracchechoden) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM INFRACC_HECHO_DEN t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(infracchechoden);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds rows in the InfraccHechoDen table using like.
	 * 
	 * @param infracchechoden
	 *            InfraccHechoDen
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<InfraccHechoDen> findAllLike(InfraccHechoDen infracchechoden, Pagination pagination,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.HICODIGO HICODIGO,t1.HICOHD HICOHD,t1.HICOTTI HICOTTI,t1.HIINEXII HIINEXII,t1.HIIFID HIIFID, t2.TTINOMBRE TTINOMBRE, t2.TTINOMBREE TTINOMBREE ");
		query.append("FROM INFRACC_HECHO_DEN t1, TIP_REQ_NORMATIVO t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(infracchechoden, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.HICOTTI = t2.TTICODIGO ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<InfraccHechoDen>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the InfraccHechoDen table using like.
	 * 
	 * @param infracchechoden
	 *            InfraccHechoDen
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(InfraccHechoDen infracchechoden, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM INFRACC_HECHO_DEN t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(infracchechoden, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the InfraccHechoDen entity
	 * 
	 * @param infracchechoden
	 *            InfraccHechoDen Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(InfraccHechoDen infracchechoden) {

		StringBuilder where = new StringBuilder(InfraccHechoDenDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (infracchechoden != null && infracchechoden.getHicodigo() != null) {
			where.append(" AND t1.HICODIGO = ?");
			params.add(infracchechoden.getHicodigo());
		}
		if (infracchechoden != null && infracchechoden.getHicohd() != null) {
			where.append(" AND t1.HICOHD = ?");
			params.add(infracchechoden.getHicohd());
		}
		if (infracchechoden != null && infracchechoden.getTipReqNormativo() != null
				&& infracchechoden.getTipReqNormativo().getTticodigo() != null) {
			where.append(" AND t1.HICOTTI = ?");
			params.add(infracchechoden.getTipReqNormativo().getTticodigo());
		}
		if (infracchechoden != null && infracchechoden.getHiinexii() != null) {
			where.append(" AND t1.HIINEXII = ?");
			params.add(infracchechoden.getHiinexii());
		}
		if (infracchechoden != null && infracchechoden.getHiifid() != null) {
			where.append(" AND t1.HIIFID = ?");
			params.add(infracchechoden.getHiifid());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the InfraccHechoDen entity
	 * 
	 * @param infracchechoden
	 *            InfraccHechoDen Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(InfraccHechoDen infracchechoden, Boolean startsWith) {

		StringBuilder where = new StringBuilder(InfraccHechoDenDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (infracchechoden != null && infracchechoden.getHicodigo() != null) {
			where.append(" AND UPPER(t1.HICODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(infracchechoden.getHicodigo().toUpperCase() + "%");
			} else {
				params.add("%" + infracchechoden.getHicodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.HICODIGO IS NOT NULL");
		}
		if (infracchechoden != null && infracchechoden.getHicohd() != null) {
			where.append(" AND UPPER(t1.HICOHD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(infracchechoden.getHicohd().toUpperCase() + "%");
			} else {
				params.add("%" + infracchechoden.getHicohd().toUpperCase() + "%");
			}
			where.append(" AND t1.HICOHD IS NOT NULL");
		}
		if (infracchechoden != null && infracchechoden.getTipReqNormativo() != null
				&& infracchechoden.getTipReqNormativo().getTticodigo() != null) {
			where.append(" AND UPPER(t1.HICOTTI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(infracchechoden.getTipReqNormativo().getTticodigo().toUpperCase() + "%");
			} else {
				params.add("%" + infracchechoden.getTipReqNormativo().getTticodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.HICOTTI IS NOT NULL");
		}
		if (infracchechoden != null && infracchechoden.getHiinexii() != null) {
			where.append(" AND UPPER(t1.HIINEXII) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(infracchechoden.getHiinexii().toUpperCase() + "%");
			} else {
				params.add("%" + infracchechoden.getHiinexii().toUpperCase() + "%");
			}
			where.append(" AND t1.HIINEXII IS NOT NULL");
		}
		if (infracchechoden != null && infracchechoden.getHiifid() != null) {
			where.append(" AND UPPER(t1.HIIFID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(infracchechoden.getHiifid().toUpperCase() + "%");
			} else {
				params.add("%" + infracchechoden.getHiifid().toUpperCase() + "%");
			}
			where.append(" AND t1.HIIFID IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

}
