package com.ejie.y41b.dao;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.InfraccHechoDen;
import com.ejie.y41b.model.TramiteComun;

/**
 * InfraccHechoDenDao  
 * 
 *  
 */

public interface InfraccHechoDenDao {

	/**
	 * Inserts a single row in the InfraccHechoDen table.
	 * 
	 * @param infracchechoden
	 *            InfraccHechoDen
	 * @return InfraccHechoDen
	 */
	InfraccHechoDen add(InfraccHechoDen infracchechoden);

	/**
	 * Inserts a single row in the InfraccHechoDen table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	public void addAllInfraccionesHechoAdjuntarInfracciones(
			TramiteComun tramiteComun);

	/**
	 * Inserts a single row in the AdjunInfraccHechoDenun table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	public void addAdjuntarInfracciones(TramiteComun tramiteComun);

	/**
	 * Inserts a single row in the InfraccHechoDen table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return modificaciones
	 */
	public int addAllInfraccionesHechoAdjuntarInfraccionesControlMercado(
			TramiteComun tramiteComun);

	/**
	 * Inserts a single row in the AdjunInfraccHechoDenun table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	public void addAdjuntarInfraccionesControlMercado(TramiteComun tramiteComun);

	void borraArticulosMaterias(String codigoExpediente);

	/**
	 * Updates a single row in the InfraccHechoDen table.
	 * 
	 * @param infracchechoden
	 *            InfraccHechoDen
	 * @return InfraccHechoDen
	 */
	InfraccHechoDen update(InfraccHechoDen infracchechoden);

	/**
	 * Finds a single row in the InfraccHechoDen table.
	 * 
	 * @param infracchechoden
	 *            InfraccHechoDen
	 * @return InfraccHechoDen
	 */
	InfraccHechoDen find(InfraccHechoDen infracchechoden);

	/**
	 * Deletes a single row in the InfraccHechoDen table.
	 * 
	 * @param infracchechoden
	 *            InfraccHechoDen
	 * @return
	 */
	void remove(InfraccHechoDen infracchechoden);

	/**
	 * Deletes a single row in the InfraccHechoDen table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return
	 */
	public void removeAllInfraccionesHecho(TramiteComun tramiteComun);

	/**
	 * Finds a List of rows in the InfraccHechoDen table.
	 * 
	 * @param infracchechoden
	 *            InfraccHechoDen
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<InfraccHechoDen> findAll(InfraccHechoDen infracchechoden,
			Pagination pagination);

	/**
	 * Find articulos.
	 * 
	 * @param codigoExpediente
	 *            the codigo expediente
	 * @return the list
	 * @throws Y41bUDAException
	 *             the y41b uda exception
	 */
	List<InfraccHechoDen> findArticulosMaterias(String codigoExpediente,
			Pagination pagination);

	/**
	 * Find articulos.
	 * 
	 * @param codigoExpediente
	 *            the codigo expediente
	 * @return the list
	 * @throws Y41bUDAException
	 *             the y41b uda exception
	 */
	List<InfraccHechoDen> findArticulos(String codigoExpediente,
			Pagination pagination);

	/**
	 * Find materias.
	 * 
	 * @param codigoExpediente
	 *            the codigo expediente
	 * @return the list
	 */
	List<InfraccHechoDen> findMaterias(String codigoExpediente,
			Pagination pagination);

	/**
	 * Counts rows in the InfraccHechoDen table.
	 * 
	 * @param infracchechoden
	 *            InfraccHechoDen
	 * @return Long
	 */
	Long findAllCount(InfraccHechoDen infracchechoden);

	/**
	 * Finds rows in the InfraccHechoDen table using like.
	 * 
	 * @param infracchechoden
	 *            InfraccHechoDen
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<InfraccHechoDen> findAllLike(InfraccHechoDen infracchechoden,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the InfraccHechoDen table using like.
	 * 
	 * @param infracchechoden
	 *            InfraccHechoDen
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(InfraccHechoDen infracchechoden, Boolean startsWith);

	/**
	 * @param excodigo
	 * @return
	 */
	Long findArticulosMateriasCount(String excodigo);

	/**
	 * @param excodigo
	 * @return
	 */
	Long findMateriasCount(String excodigo);

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.y41b.dao.InfraccHechoDenDao#findAllArticulosSolicitudesCount
	 * (java.lang.String)
	 */
	public Long findAllArticulosSolicitudesCount(String codigoExpediente);

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.y41b.dao.InfraccHechoDenDao#findAllMateriasSolicitudesCount(
	 * java.lang.String)
	 */
	public Long findAllMateriasSolicitudesCount(String codigoExpediente);
}
