package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.InfraccArb;
import com.ejie.y41b.model.TipReqNormativo;
import com.ejie.y41b.model.TramiteComun;

/**
 * InfraccArbDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class InfraccArbDaoImpl implements InfraccArbDao {
	private JdbcTemplate jdbcTemplate;

	private RowMapper<InfraccArb> rwMap = new RowMapper<InfraccArb>() {
		public InfraccArb mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			TipReqNormativo tipReqNormativo = new TipReqNormativo();
			tipReqNormativo.setTticodigo(resultSet.getString("HICOTTI"));

			return new InfraccArb(resultSet.getString("HICODIGO"),
					resultSet.getString("HICOARB"), tipReqNormativo,
					resultSet.getString("HIINEXII"),
					resultSet.getString("HIIFID"));
		}

	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the InfraccArb table.
	 * 
	 * @param infraccArb
	 *            Pagination
	 * @return InfraccArb
	 */
	public InfraccArb add(InfraccArb infraccArb) {
		String query = "INSERT INTO INFRACC_ARB (HICODIGO, HICOARB, HICOTTI, HIINEXII, HIIFID) VALUES (?,?,?,?,?)";
		this.jdbcTemplate.update(query, infraccArb.getHicodigo(), infraccArb
				.getHicoarb(), infraccArb.getTipReqNormativo() == null ? null
				: infraccArb.getTipReqNormativo().getTticodigo(), infraccArb
				.getHiinexii(), infraccArb.getHiifid());
		return infraccArb;
	}

	/**
	 * Inserts a single row in the InfraccArb table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	public void addAllInfraccionesArbAdjuntarInfracciones(
			TramiteComun tramiteComun) {

		String query = "INSERT INTO INFRACC_ARB (HICODIGO, HICOARB, HICOTTI, HIINEXII, HIIFID) SELECT HICODIGO, HICOARB, HICOTTI, HIINEXII, HIIFID FROM ADJUN_INFRACC_ARB WHERE HICOARB = ? ";
		this.jdbcTemplate.update(query, tramiteComun.getIdExpediente());
	}

	/**
	 * Inserts a single row in the AdjunInfraccArbun table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	public void addAdjuntarInfracciones(TramiteComun tramiteComun) {

		String query = "INSERT INTO ADJUN_INFRACC_ARB (HICODIGO, HICOARB, HICOTTI, HIINEXII, HIIFID) SELECT HICODIGO, HICOARB, HICOTTI, HIINEXII, HIIFID FROM INFRACC_ARB  WHERE HICOARB = ?";
		this.jdbcTemplate.update(query, tramiteComun.getIdExpediente());
	}

	/**
	 * Updates a single row in the InfraccArb table.
	 * 
	 * @param infraccArb
	 *            Pagination
	 * @return InfraccArb
	 */
	public InfraccArb update(InfraccArb infraccArb) {
		String query = "UPDATE INFRACC_ARB SET HICOARB=?, HICOTTI=?, HIINEXII=?, HIIFID=? WHERE HICODIGO=?";
		this.jdbcTemplate.update(query, infraccArb.getHicoarb(), infraccArb
				.getTipReqNormativo() == null ? null : infraccArb
				.getTipReqNormativo().getTticodigo(), infraccArb.getHiinexii(),
				infraccArb.getHiifid(), infraccArb.getHicodigo());
		return infraccArb;
	}

	/**
	 * Finds a single row in the InfraccArb table.
	 * 
	 * @param infraccArb
	 *            Pagination
	 * @return InfraccArb
	 */
	@Transactional(readOnly = true)
	public InfraccArb find(InfraccArb infraccArb) {
		String query = "SELECT t1.HICODIGO HICODIGO, t1.HICOARB HICOARB, t1.HICOTTI HICOTTI, t1.HIINEXII HIINEXII, t1.HIIFID HIIFID FROM INFRACC_ARB t1  WHERE t1.HICODIGO = ?  ";

		List<InfraccArb> infraccArbList = this.jdbcTemplate.query(query,
				this.rwMap, infraccArb.getHicodigo());
		return (InfraccArb) DataAccessUtils.uniqueResult(infraccArbList);
	}

	/**
	 * Removes a single row in the InfraccArb table.
	 * 
	 * @param infraccArb
	 *            Pagination
	 * @return
	 */
	public void remove(InfraccArb infraccArb) {
		String query = "DELETE FROM INFRACC_ARB WHERE HICODIGO=?";
		this.jdbcTemplate.update(query, infraccArb.getHicodigo());
	}

	/**
	 * Deletes a single row in the InfraccArb table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return
	 */
	public void removeAllInfraccionesArb(TramiteComun tramiteComun) {
		String query = "DELETE  FROM INFRACC_ARB " + " WHERE HICOARB=?";

		this.jdbcTemplate.update(query, tramiteComun.getIdExpediente());
	}

	/**
	 * Finds a List of rows in the InfraccArb table.
	 * 
	 * @param infraccArb
	 *            InfraccArb
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<InfraccArb> findAll(InfraccArb infraccArb, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.HICODIGO HICODIGO,t1.HICOARB HICOARB,t1.HICOTTI HICOTTI,t1.HIINEXII HIINEXII,t1.HIIFID HIIFID ");
		query.append("FROM INFRACC_ARB t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(infraccArb);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<InfraccArb>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ejie.y41b.dao.InfraccArbDao#findAllArticulosSolicitudesCount
	 * (java.lang.String)
	 */
	@Transactional(readOnly = true)
	public Long findAllArticulosSolicitudesCount(String codigoExpediente) {

		StringBuilder query = new StringBuilder("SELECT  count(1) ");
		query.append("FROM ADJUN_INFRACC_ARB WHERE 1=1 ");

		StringBuilder where = new StringBuilder(
				" AND HICOARB = ? AND HIINEXII= 'S'");

		query.append(where);

		List<Object> params = new ArrayList<Object>();
		params.add(codigoExpediente);

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ejie.y41b.dao.InfraccArbDao#findAllMateriasSolicitudesCount(
	 * java.lang.String)
	 */
	@Transactional(readOnly = true)
	public Long findAllMateriasSolicitudesCount(String codigoExpediente) {

		StringBuilder query = new StringBuilder("SELECT  count(1) ");
		query.append("FROM ADJUN_INFRACC_ARB WHERE 1=1 ");

		StringBuilder where = new StringBuilder(
				" AND HICOARB = ? AND HIINEXII IS NULL");

		query.append(where);

		List<Object> params = new ArrayList<Object>();
		params.add(codigoExpediente);

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());

	}

	/**
	 * Counts rows in the InfraccArb table.
	 * 
	 * @param infraccArb
	 *            InfraccArb
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(InfraccArb infraccArb) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM INFRACC_ARB t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(infraccArb);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the InfraccArb table using like.
	 * 
	 * @param infraccArb
	 *            InfraccArb
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<InfraccArb> findAllLike(InfraccArb infraccArb,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.HICODIGO HICODIGO,t1.HICOARB HICOARB,t1.HICOTTI HICOTTI,t1.HIINEXII HIINEXII,t1.HIIFID HIIFID ");
		query.append("FROM INFRACC_ARB t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(infraccArb, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<InfraccArb>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the InfraccArb table using like.
	 * 
	 * @param infraccArb
	 *            InfraccArb
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(InfraccArb infraccArb, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM INFRACC_ARB t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(infraccArb, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the InfraccArb entity
	 * 
	 * @param infraccArb
	 *            InfraccArb Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(InfraccArb infraccArb) {

		StringBuilder where = new StringBuilder(
				InfraccArbDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (infraccArb != null && infraccArb.getHicodigo() != null) {
			where.append(" AND t1.HICODIGO = ?");
			params.add(infraccArb.getHicodigo());
		}
		if (infraccArb != null && infraccArb.getHicoarb() != null) {
			where.append(" AND t1.HICOARB = ?");
			params.add(infraccArb.getHicoarb());
		}
		if (infraccArb != null && infraccArb.getTipReqNormativo() != null
				&& infraccArb.getTipReqNormativo().getTticodigo() != null) {
			where.append(" AND t1.HICOTTI = ?");
			params.add(infraccArb.getTipReqNormativo().getTticodigo());
		}
		if (infraccArb != null && infraccArb.getHiinexii() != null) {
			where.append(" AND t1.HIINEXII = ?");
			params.add(infraccArb.getHiinexii());
		}
		if (infraccArb != null && infraccArb.getHiifid() != null) {
			where.append(" AND t1.HIIFID = ?");
			params.add(infraccArb.getHiifid());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the InfraccArb entity
	 * 
	 * @param infraccArb
	 *            InfraccArb Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(InfraccArb infraccArb,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				InfraccArbDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (infraccArb != null && infraccArb.getHicodigo() != null) {
			where.append(" AND UPPER(t1.HICODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(infraccArb.getHicodigo().toUpperCase() + "%");
			} else {
				params.add("%" + infraccArb.getHicodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.HICODIGO IS NOT NULL");
		}
		if (infraccArb != null && infraccArb.getHicoarb() != null) {
			where.append(" AND UPPER(t1.HICOARB) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(infraccArb.getHicoarb().toUpperCase() + "%");
			} else {
				params.add("%" + infraccArb.getHicoarb().toUpperCase() + "%");
			}
			where.append(" AND t1.HICOARB IS NOT NULL");
		}
		if (infraccArb != null && infraccArb.getTipReqNormativo() != null
				&& infraccArb.getTipReqNormativo().getTticodigo() != null) {
			where.append(" AND UPPER(t1.HICOTTI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(infraccArb.getTipReqNormativo().getTticodigo()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ infraccArb.getTipReqNormativo().getTticodigo()
								.toUpperCase() + "%");
			}
			where.append(" AND t1.HICOTTI IS NOT NULL");
		}
		if (infraccArb != null && infraccArb.getHiinexii() != null) {
			where.append(" AND UPPER(t1.HIINEXII) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(infraccArb.getHiinexii().toUpperCase() + "%");
			} else {
				params.add("%" + infraccArb.getHiinexii().toUpperCase() + "%");
			}
			where.append(" AND t1.HIINEXII IS NOT NULL");
		}
		if (infraccArb != null && infraccArb.getHiifid() != null) {
			where.append(" AND UPPER(t1.HIIFID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(infraccArb.getHiifid().toUpperCase() + "%");
			} else {
				params.add("%" + infraccArb.getHiifid().toUpperCase() + "%");
			}
			where.append(" AND t1.HIIFID IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

}
