package com.ejie.y41b.dao;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.InfraccArb;
import com.ejie.y41b.model.TramiteComun;

/**
 * InfraccArbDao  
 * 
 *  
 */

public interface InfraccArbDao {

	/**
	 * Inserts a single row in the InfraccArb table.
	 * 
	 * @param infraccArb
	 *            InfraccArb
	 * @return InfraccArb
	 */
	InfraccArb add(InfraccArb infraccArb);

	/**
	 * Inserts a single row in the InfraccArb table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	public void addAllInfraccionesArbAdjuntarInfracciones(
			TramiteComun tramiteComun);

	/**
	 * Inserts a single row in the AdjunInfraccArbun table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	public void addAdjuntarInfracciones(TramiteComun tramiteComun);

	/**
	 * Updates a single row in the InfraccArb table.
	 * 
	 * @param infraccArb
	 *            InfraccArb
	 * @return InfraccArb
	 */
	InfraccArb update(InfraccArb infraccArb);

	/**
	 * Finds a single row in the InfraccArb table.
	 * 
	 * @param infraccArb
	 *            InfraccArb
	 * @return InfraccArb
	 */
	InfraccArb find(InfraccArb infraccArb);

	/**
	 * Deletes a single row in the InfraccArb table.
	 * 
	 * @param infraccArb
	 *            InfraccArb
	 * @return
	 */
	void remove(InfraccArb infraccArb);

	/**
	 * Deletes a single row in the InfraccArb table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return
	 */
	public void removeAllInfraccionesArb(TramiteComun tramiteComun);

	/**
	 * Finds a List of rows in the InfraccArb table.
	 * 
	 * @param infraccArb
	 *            InfraccArb
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<InfraccArb> findAll(InfraccArb infraccArb, Pagination pagination);

	/**
	 * Counts rows in the InfraccArb table.
	 * 
	 * @param infraccArb
	 *            InfraccArb
	 * @return Long
	 */
	Long findAllCount(InfraccArb infraccArb);

	/**
	 * Finds rows in the InfraccArb table using like.
	 * 
	 * @param infraccArb
	 *            InfraccArb
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<InfraccArb> findAllLike(InfraccArb infraccArb, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the InfraccArb table using like.
	 * 
	 * @param infraccArb
	 *            InfraccArb
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(InfraccArb infraccArb, Boolean startsWith);

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ejie.y41b.dao.InfraccArbDao#findAllArticulosSolicitudesCount
	 * (java.lang.String)
	 */
	public Long findAllArticulosSolicitudesCount(String codigoExpediente);

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ejie.y41b.dao.InfraccArbDao#findAllMateriasSolicitudesCount(
	 * java.lang.String)
	 */
	public Long findAllMateriasSolicitudesCount(String codigoExpediente);
}
