package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Inc;

/**
 * IncDaoImpl  
 *  
 */
 
@Repository
@Transactional
public class IncDaoImpl implements IncDao {
    private JdbcTemplate jdbcTemplate;
	private RowMapper<Inc> rwMap = new RowMapper<Inc>() {
		public Inc mapRow(ResultSet resultSet, int rowNum) throws SQLException {
           return new Inc(
               resultSet.getString("INCCODIGO"), resultSet.getString("INCNOMBRE")
           ); } } ;

	/**
     * Method use to set the datasource.
     *
     * @param dataSource DataSource
     * @return
     */
    @Resource
    public void setDataSource(DataSource dataSource) {
    	this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    /**
     * Inserts a single row in the Inc table.
     *
     * @param inc Pagination
     * @return Inc
     */
	public Inc add(Inc inc) {
    	String query = "INSERT INTO INC (INCCODIGO, INCNOMBRE) VALUES (?,?)";
		this.jdbcTemplate.update(query, inc.getInccodigo(), inc.getIncnombre());
		return inc;
	}

    /**
     * Updates a single row in the Inc table.
     *
     * @param inc Pagination
     * @return Inc
     */
    public Inc update(Inc inc) {
		String query = "UPDATE INC SET INCNOMBRE=? WHERE INCCODIGO=?";
		this.jdbcTemplate.update(query, inc.getIncnombre(), inc.getInccodigo());
		return inc;
	}

    /**
     * Finds a single row in the Inc table.
     *
     * @param inc Pagination
     * @return Inc
     */
    @Transactional (readOnly = true)
    public Inc find(Inc inc) {
		String query = "SELECT t1.INCCODIGO INCCODIGO, t1.INCNOMBRE INCNOMBRE FROM INC t1  WHERE t1.INCCODIGO = ?  ";
		
		List<Inc> incList = this.jdbcTemplate.query(query, this.rwMap, inc.getInccodigo());
		return (Inc) DataAccessUtils.uniqueResult(incList);
    }

    /**
     * Removes a single row in the Inc table.
     *
     * @param inc Pagination
     * @return
     */
    public void remove(Inc inc) {
		String query = "DELETE FROM INC WHERE INCCODIGO=?";
		this.jdbcTemplate.update(query, inc.getInccodigo());
    }
    
   /**
    * Finds a List of rows in the Inc table.
    * 
    * @param inc Inc
    * @param pagination Pagination
    * @return List 
    */
	@Transactional (readOnly = true)
    public List<Inc> findAll(Inc inc, Pagination pagination) {
		StringBuilder query = new StringBuilder("SELECT  t1.INCCODIGO INCCODIGO,t1.INCNOMBRE INCNOMBRE "); 
		query.append("FROM INC t1 ");
		
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(inc); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		
		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		
		return (List<Inc>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}
	
    /**
     * Counts rows in the Inc table.
     * 
     * @param inc Inc
     * @return Long
     */
    @Transactional (readOnly = true)
    public Long findAllCount(Inc inc) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM INC t1 ");
		
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(inc); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);		
		
		List<?> params = (List<?>) mapaWhere.get("params");
		
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
	
	/**
	 * Finds rows in the Inc table using like.
     * 
     * @param inc Inc
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List 
     */
	@Transactional (readOnly = true)
    public List<Inc> findAllLike(Inc inc, Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT  t1.INCCODIGO INCCODIGO,t1.INCNOMBRE INCNOMBRE "); 
        query.append("FROM INC t1 ");
      	
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(inc,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		
		return (List<Inc>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}
	
	/**
	 * Counts rows in the Inc table using like.
     * 
     * @param inc Inc
     * @param startsWith Boolean
     * @return Long 
     */
	@Transactional (readOnly = true)
    public Long findAllLikeCount(Inc inc, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM INC t1 ");

		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(inc,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
	
	/**
	 * Returns a map with the needed value to create the conditions to filter by 
	 * the Inc entity 
	 * 
	 * @param inc Inc
	 *            Bean with the criteria values to filter by.
	 * @return Map created with two keys
	 *         key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap (Inc inc){
		
		StringBuilder where = new StringBuilder(IncDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (inc  != null  && inc.getInccodigo() != null ) {
			where.append(" AND t1.INCCODIGO = ?");
			params.add(inc.getInccodigo());
		}
		if (inc  != null  && inc.getIncnombre() != null ) {
			where.append(" AND t1.INCNOMBRE = ?");
			params.add(inc.getIncnombre());
		}

		Map<String,Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		
		return mapWhere;		
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA
	
	/**
	 * Returns a map with the needed value to create the conditions to filter by  
	 * the Inc entity 
	 * 
	 * @param inc Inc
	 *            Bean with the criteria values to filter by.
     * @param startsWith Boolean	 
	 * @return Map created with two keys
	 *         key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap (Inc inc, Boolean startsWith){
		
		StringBuilder where = new StringBuilder(IncDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (inc  != null  && inc.getInccodigo() != null ) {
			where.append(" AND UPPER(t1.INCCODIGO) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(inc.getInccodigo().toUpperCase() +"%");
			}else{
				params.add("%"+inc.getInccodigo().toUpperCase() +"%");
			}
			where.append(" AND t1.INCCODIGO IS NOT NULL");
	     }			
		if (inc  != null  && inc.getIncnombre() != null ) {
			where.append(" AND UPPER(t1.INCNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(inc.getIncnombre().toUpperCase() +"%");
			}else{
				params.add("%"+inc.getIncnombre().toUpperCase() +"%");
			}
			where.append(" AND t1.INCNOMBRE IS NOT NULL");
	     }			

		Map<String,Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		
		return mapWhere;		
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA
	
	/**
	 * StringBuilder initilization value
	 */
	 public static final int STRING_BUILDER_INIT = 4096;}

