package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.Inc;

/**
 * IncDao  
 *  
 */

public interface IncDao {
    
    /**
     * Inserts a single row in the Inc table.
     *
     * @param inc Inc
     * @return Inc
     */
    Inc add(Inc inc);

    /**
     * Updates a single row in the Inc table.
     *
     * @param inc Inc
     * @return Inc
     */
    Inc update(Inc inc);

    /**
     * Finds a single row in the Inc table.
     *
     * @param inc Inc
     * @return Inc
     */
    Inc find(Inc inc);

    /**
     * Deletes a single row in the Inc table.
     *
     * @param inc Inc
     * @return 
     */
    void remove(Inc inc);

    /**
     * Finds a List of rows in the Inc table.
     *
     * @param inc Inc
     * @param pagination Pagination
     * @return List
     */
    List<Inc> findAll(Inc inc, Pagination pagination);

    /**
     * Counts rows in the Inc table.
     *
     * @param inc Inc
     * @return Long
     */
    Long findAllCount(Inc inc);
	
	/**
     * Finds rows in the Inc table using like.
     *
     * @param inc Inc
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List
     */
	List<Inc> findAllLike(Inc inc, Pagination pagination, Boolean startsWith);
	
    /**
     * Counts rows in the Inc table using like.
     *
     * @param inc Inc
     * @param startsWith Boolean
     * @return Long
     */
    Long findAllLikeCount(Inc inc, Boolean startsWith);
}

