package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Historicofases;

/**
 * HistoricofasesDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class HistoricofasesDaoImpl implements HistoricofasesDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Historicofases> rwMap = new RowMapper<Historicofases>() {
		public Historicofases mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Historicofases(resultSet.getString("HFHDCODIGO"),
					resultSet.getString("HFEXCODIGO"),
					resultSet.getString("HFFCODIGO"),
					resultSet.getDate("HFFINICIO"),
					resultSet.getDate("HFFFIN"),
					resultSet.getString("HFSACODIGO"));
		}
	};

	private RowMapper<Historicofases> rwMapFasesHistoricoAbiertas = new RowMapper<Historicofases>() {
		public Historicofases mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Historicofases(resultSet.getString("HFCODIGO"),
					resultSet.getString("HFHDCODIGO"),
					resultSet.getString("HFEXCODIGO"),
					resultSet.getString("HFFCODIGO"),
					resultSet.getDate("HFFINICIO"),
					resultSet.getDate("HFFFIN"),
					resultSet.getString("HFSACODIGO"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Historicofases table.
	 * 
	 * @param historicofases
	 *            Pagination
	 * @return Historicofases
	 */
	public Historicofases add(Historicofases historicofases) {
		String query = "INSERT INTO HISTORICOFASES (HFHDCODIGO, HFEXCODIGO, HFFCODIGO, HFFINICIO, HFFFIN,HFSACODIGO) VALUES (?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, historicofases.getHfhdcodigo(),
				historicofases.getHfexcodigo(), historicofases.getHffcodigo(),
				historicofases.getHffinicio(), historicofases.getHfffin(),
				historicofases.getHfsacodigo());
		return historicofases;
	}

	/**
	 * Updates a single row in the Historicofases table.
	 * 
	 * @param historicofases
	 *            Pagination
	 * @return Historicofases
	 */
	public Historicofases update(Historicofases historicofases) {
		String query = "UPDATE HISTORICOFASES SET HFHDCODIGO=?, HFEXCODIGO=?, HFFCODIGO=?, HFFINICIO=?, HFFFIN=?, HFFECALTA=?, HFFECMODIF=?, HFUSUALTA=?, HFUSUMODIF=?, HFSACODIGO=?  WHERE HFCODIGO=?";
		this.jdbcTemplate.update(query, historicofases.getHfhdcodigo(),
				historicofases.getHfexcodigo(), historicofases.getHffcodigo(),
				historicofases.getHffinicio(), historicofases.getHfffin(),
				historicofases.getHffecalta(), historicofases.getHffecmodif(),
				historicofases.getHfusualta(), historicofases.getHfusumodif(),
				historicofases.getHfsacodigo(), historicofases.getHfcodigo());
		return historicofases;
	}

	/**
	 * Updates a single row in the Historicofases table. (Solamente la FechaFin)
	 * 
	 * @param historicofases
	 *            Historicofases
	 * @return Historicofases
	 */
	public Historicofases updateFechaFin(Historicofases historicofases) {
		String query = "UPDATE HISTORICOFASES SET HFFFIN=? WHERE HFCODIGO=?";
		this.jdbcTemplate.update(query, historicofases.getHfffin(),
				historicofases.getHfcodigo());
		return historicofases;
	}

	/**
	 * Finds a single row in the Historicofases table.
	 * 
	 * @param historicofases
	 *            Pagination
	 * @return Historicofases
	 */
	@Transactional(readOnly = true)
	public Historicofases find(Historicofases historicofases) {
		String query = "SELECT t1.HFCODIGO HFCODIGO, t1.HFHDCODIGO HFHDCODIGO, t1.HFEXCODIGO HFEXCODIGO, t1.HFFCODIGO HFFCODIGO, t1.HFFINICIO HFFINICIO, t1.HFFFIN HFFFIN, t1.HFFECALTA HFFECALTA, t1.HFFECMODIF HFFECMODIF, t1.HFUSUALTA HFUSUALTA, t1.HFUSUMODIF HFUSUMODIF,t1.HFSACODIGO HFSACODIGO FROM HISTORICOFASES t1  WHERE t1.HFCODIGO = ?  ";

		List<Historicofases> historicofasesList = this.jdbcTemplate.query(
				query, this.rwMap, historicofases.getHfcodigo());
		return (Historicofases) DataAccessUtils
				.uniqueResult(historicofasesList);
	}

	/**
	 * Removes a single row in the Historicofases table.
	 * 
	 * @param historicofases
	 *            Pagination
	 * @return
	 */
	public void remove(Historicofases historicofases) {
		String query = "DELETE FROM HISTORICOFASES WHERE HFCODIGO=?";
		this.jdbcTemplate.update(query, historicofases.getHfcodigo());
	}

	/**
	 * Removes a single row in the Historicofases table.
	 * 
	 * @param historicofases
	 *            Pagination
	 * @return
	 */
	public void removeHistoricoFasesExpediente(Historicofases historicofases) {
		String query = "DELETE FROM HISTORICOFASES WHERE HFHDCODIGO=?";
		this.jdbcTemplate.update(query, historicofases.getHfhdcodigo());
	}

	/**
	 * Finds a List of rows in the Historicofases table.
	 * 
	 * @param historicofases
	 *            Historicofases
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Historicofases> findAll(Historicofases historicofases,
			Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.HFCODIGO HFCODIGO,t1.HFHDCODIGO HFHDCODIGO,t1.HFEXCODIGO HFEXCODIGO,t1.HFFCODIGO HFFCODIGO,t1.HFFINICIO HFFINICIO,t1.HFFFIN HFFFIN,t1.HFFECALTA HFFECALTA,t1.HFFECMODIF HFFECMODIF,t1.HFUSUALTA HFUSUALTA,t1.HFUSUMODIF HFUSUMODIF, t1.HFSACODIGO HFSACODIGO ");
		query.append("FROM HISTORICOFASES t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(historicofases);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Historicofases>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds a List of rows in the Historicofases table. Solo devuelve aquellas
	 * fases que tengan la fecha de fin a null
	 * 
	 * @param historicofases
	 *            Historicofases
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Historicofases> findAllFasesHistoricoAbiertas(
			Historicofases historicofases) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.HFCODIGO HFCODIGO,t1.HFHDCODIGO HFHDCODIGO,t1.HFEXCODIGO HFEXCODIGO,t1.HFFCODIGO HFFCODIGO,t1.HFFINICIO HFFINICIO,t1.HFFFIN HFFFIN,t1.HFFECALTA HFFECALTA,t1.HFFECMODIF HFFECMODIF,t1.HFUSUALTA HFUSUALTA,t1.HFUSUMODIF HFUSUMODIF, t1.HFSACODIGO HFSACODIGO ");
		query.append("FROM HISTORICOFASES t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(historicofases);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.HFFFIN IS NULL ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return (List<Historicofases>) this.jdbcTemplate.query(query.toString(),
				this.rwMapFasesHistoricoAbiertas, params.toArray());
	}

	/**
	 * Counts rows in the Historicofases table.
	 * 
	 * @param historicofases
	 *            Historicofases
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Historicofases historicofases) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM HISTORICOFASES t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(historicofases);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Historicofases table using like.
	 * 
	 * @param historicofases
	 *            Historicofases
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Historicofases> findAllLike(Historicofases historicofases,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.HFCODIGO HFCODIGO,t1.HFHDCODIGO HFHDCODIGO,t1.HFEXCODIGO HFEXCODIGO,t1.HFFCODIGO HFFCODIGO,t1.HFFINICIO HFFINICIO,t1.HFFFIN HFFFIN,t1.HFFECALTA HFFECALTA,t1.HFFECMODIF HFFECMODIF,t1.HFUSUALTA HFUSUALTA,t1.HFUSUMODIF HFUSUMODIF, t1.HFSACODIGO HFSACODIGO ");
		query.append("FROM HISTORICOFASES t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(historicofases,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Historicofases>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Historicofases table using like.
	 * 
	 * @param historicofases
	 *            Historicofases
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Historicofases historicofases,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM HISTORICOFASES t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(historicofases,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Historicofases entity
	 * 
	 * @param historicofases
	 *            Historicofases Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Historicofases historicofases) {

		StringBuilder where = new StringBuilder(
				HistoricofasesDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (historicofases != null && historicofases.getHfcodigo() != null) {
			where.append(" AND t1.HFCODIGO = ?");
			params.add(historicofases.getHfcodigo());
		}
		if (historicofases != null && historicofases.getHfhdcodigo() != null) {
			where.append(" AND t1.HFHDCODIGO = ?");
			params.add(historicofases.getHfhdcodigo());
		}
		if (historicofases != null && historicofases.getHfexcodigo() != null) {
			where.append(" AND t1.HFEXCODIGO = ?");
			params.add(historicofases.getHfexcodigo());
		}
		if (historicofases != null && historicofases.getHffcodigo() != null) {
			where.append(" AND t1.HFFCODIGO = ?");
			params.add(historicofases.getHffcodigo());
		}
		if (historicofases != null && historicofases.getHffinicio() != null) {
			where.append(" AND t1.HFFINICIO = ?");
			params.add(historicofases.getHffinicio());
		}
		if (historicofases != null && historicofases.getHfffin() != null) {
			where.append(" AND t1.HFFFIN = ?");
			params.add(historicofases.getHfffin());
		}
		if (historicofases != null && historicofases.getHffecalta() != null) {
			where.append(" AND t1.HFFECALTA = ?");
			params.add(historicofases.getHffecalta());
		}
		if (historicofases != null && historicofases.getHffecmodif() != null) {
			where.append(" AND t1.HFFECMODIF = ?");
			params.add(historicofases.getHffecmodif());
		}
		if (historicofases != null && historicofases.getHfusualta() != null) {
			where.append(" AND t1.HFUSUALTA = ?");
			params.add(historicofases.getHfusualta());
		}
		if (historicofases != null && historicofases.getHfusumodif() != null) {
			where.append(" AND t1.HFUSUMODIF = ?");
			params.add(historicofases.getHfusumodif());
		}
		if (historicofases != null && historicofases.getHfsacodigo() != null) {
			where.append(" AND t1.HFSACODIGO = ?");
			params.add(historicofases.getHfsacodigo());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Historicofases entity
	 * 
	 * @param historicofases
	 *            Historicofases Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Historicofases historicofases,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				HistoricofasesDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (historicofases != null && historicofases.getHfcodigo() != null) {
			where.append(" AND UPPER(t1.HFCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(historicofases.getHfcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + historicofases.getHfcodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.HFCODIGO IS NOT NULL");
		}
		if (historicofases != null && historicofases.getHfhdcodigo() != null) {
			where.append(" AND UPPER(t1.HFHDCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(historicofases.getHfhdcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + historicofases.getHfhdcodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.HFHDCODIGO IS NOT NULL");
		}
		if (historicofases != null && historicofases.getHfexcodigo() != null) {
			where.append(" AND UPPER(t1.HFEXCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(historicofases.getHfexcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + historicofases.getHfexcodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.HFEXCODIGO IS NOT NULL");
		}
		if (historicofases != null && historicofases.getHffcodigo() != null) {
			where.append(" AND UPPER(t1.HFFCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(historicofases.getHffcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + historicofases.getHffcodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.HFFCODIGO IS NOT NULL");
		}
		if (historicofases != null && historicofases.getHffinicio() != null) {
			where.append(" AND t1.HFFINICIO = ?");
			params.add(historicofases.getHffinicio());
		}
		if (historicofases != null && historicofases.getHfffin() != null) {
			where.append(" AND t1.HFFFIN = ?");
			params.add(historicofases.getHfffin());
		}
		if (historicofases != null && historicofases.getHffecalta() != null) {
			where.append(" AND t1.HFFECALTA = ?");
			params.add(historicofases.getHffecalta());
		}
		if (historicofases != null && historicofases.getHffecmodif() != null) {
			where.append(" AND t1.HFFECMODIF = ?");
			params.add(historicofases.getHffecmodif());
		}
		if (historicofases != null && historicofases.getHfusualta() != null) {
			where.append(" AND UPPER(t1.HFUSUALTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(historicofases.getHfusualta().toUpperCase() + "%");
			} else {
				params.add("%" + historicofases.getHfusualta().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.HFUSUALTA IS NOT NULL");
		}
		if (historicofases != null && historicofases.getHfusumodif() != null) {
			where.append(" AND UPPER(t1.HFUSUMODIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(historicofases.getHfusumodif().toUpperCase() + "%");
			} else {
				params.add("%" + historicofases.getHfusumodif().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.HFUSUMODIF IS NOT NULL");
		}

		if (historicofases != null && historicofases.getHfsacodigo() != null) {
			where.append(" AND UPPER(t1.HFSACODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(historicofases.getHfsacodigo().toUpperCase() + "%");
			} else {
				params.add("%" + historicofases.getHfsacodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.HFSACODIGO IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
