package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Movimientos;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Historico;

/**
 * HistoricoDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class HistoricoDaoImpl implements HistoricoDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Historico> rwMap = new RowMapper<Historico>() {
		public Historico mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Historico(resultSet.getString("SHCODIGO"),
					resultSet.getString("SHREFERENCIA"),
					resultSet.getString("SHEXPEDIENTE"),
					resultSet.getString("SHIDEXPEDIENTE"),
					resultSet.getString("SHCODPROC"),
					resultSet.getString("SHIDESTABLECIMIENTO"),
					resultSet.getDate("SHFECHAEMISION"),
					resultSet.getString("SHIDESTADOPAGO"),
					resultSet.getDate("SHFECHAESTADO"),
					resultSet.getDate("SHFECHALIMITEPAGO"),
					resultSet.getDate("SHFECHAPAGO"),
					resultSet.getString("SHIDMETODOPAGO"),
					resultSet.getString("SHFRACCIONADO"),
					resultSet.getBigDecimal("SHIMPORTE"),
					resultSet.getString("SHIDCONCEPTO"),
					resultSet.getString("SHDESCRIPCIONPAGO"),
					resultSet.getString("SHOBSERVACIONES"),
					resultSet.getString("SHDIGITOCONTROL"),
					resultSet.getString("SHREFERENCIAFRACC"),
					resultSet.getBigDecimal("SHIMPORTEINTERES"),
					resultSet.getLong("SHNUMFRACCION"), new Movimientos(
							resultSet.getString("MovimientosSFCODIGO"),
							resultSet.getString("MovimientosSFREFERENCIA"),
							resultSet.getString("MovimientosSFTIPOMOV"),
							resultSet.getString("MovimientosSFPERIODO"),
							resultSet.getString("MovimientosSFSENTIDO"),
							resultSet.getDate("MovimientosSFFECHAOPERACION"),
							resultSet.getString("MovimientosSFESTADOMOV"),
							resultSet.getString("MovimientosSFDETALLE")));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Historico table.
	 * 
	 * @param historico
	 *            Pagination
	 * @return Historico
	 */
	public Historico add(Historico historico) {
		String query = "INSERT INTO HISTORICO (SHCODIGO, SHIDMOVIMIENTO, SHREFERENCIA, SHEXPEDIENTE, SHIDEXPEDIENTE, SHCODPROC, SHIDESTABLECIMIENTO, SHFECHAEMISION, SHIDESTADOPAGO, SHFECHAESTADO, SHFECHALIMITEPAGO, SHFECHAPAGO, SHIDMETODOPAGO, SHFRACCIONADO, SHIMPORTE, SHIDCONCEPTO, SHDESCRIPCIONPAGO, SHOBSERVACIONES, SHDIGITOCONTROL, SHREFERENCIAFRACC, SHIMPORTEINTERES, SHNUMFRACCION) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		Object getMovimientosSfcodigoAux = null;
		if (historico.getMovimientos() != null
				&& historico.getMovimientos().getSfcodigo() != null) {
			getMovimientosSfcodigoAux = historico.getMovimientos()
					.getSfcodigo();
		}
		this.jdbcTemplate.update(query, historico.getShcodigo(),
				getMovimientosSfcodigoAux, historico.getShreferencia(),
				historico.getShexpediente(), historico.getShidexpediente(),
				historico.getShcodproc(), historico.getShidestablecimiento(),
				historico.getShfechaemision(), historico.getShidestadopago(),
				historico.getShfechaestado(), historico.getShfechalimitepago(),
				historico.getShfechapago(), historico.getShidmetodopago(),
				historico.getShfraccionado(), historico.getShimporte(),
				historico.getShidconcepto(), historico.getShdescripcionpago(),
				historico.getShobservaciones(), historico.getShdigitocontrol(),
				historico.getShreferenciafracc(),
				historico.getShimporteinteres(), historico.getShnumfraccion());
		return historico;
	}

	/**
	 * Updates a single row in the Historico table.
	 * 
	 * @param historico
	 *            Pagination
	 * @return Historico
	 */
	public Historico update(Historico historico) {
		String query = "UPDATE HISTORICO SET SHIDMOVIMIENTO=?, SHREFERENCIA=?, SHEXPEDIENTE=?, SHIDEXPEDIENTE=?, SHCODPROC=?, SHIDESTABLECIMIENTO=?, SHFECHAEMISION=?, SHIDESTADOPAGO=?, SHFECHAESTADO=?, SHFECHALIMITEPAGO=?, SHFECHAPAGO=?, SHIDMETODOPAGO=?, SHFRACCIONADO=?, SHIMPORTE=?, SHIDCONCEPTO=?, SHDESCRIPCIONPAGO=?, SHOBSERVACIONES=?, SHDIGITOCONTROL=?, SHREFERENCIAFRACC=?, SHIMPORTEINTERES=?, SHNUMFRACCION=? WHERE SHCODIGO=?";
		Object getMovimientosSfcodigoAux = null;
		if (historico.getMovimientos() != null
				&& historico.getMovimientos().getSfcodigo() != null) {
			getMovimientosSfcodigoAux = historico.getMovimientos()
					.getSfcodigo();
		}
		this.jdbcTemplate.update(query, getMovimientosSfcodigoAux,
				historico.getShreferencia(), historico.getShexpediente(),
				historico.getShidexpediente(), historico.getShcodproc(),
				historico.getShidestablecimiento(),
				historico.getShfechaemision(), historico.getShidestadopago(),
				historico.getShfechaestado(), historico.getShfechalimitepago(),
				historico.getShfechapago(), historico.getShidmetodopago(),
				historico.getShfraccionado(), historico.getShimporte(),
				historico.getShidconcepto(), historico.getShdescripcionpago(),
				historico.getShobservaciones(), historico.getShdigitocontrol(),
				historico.getShreferenciafracc(),
				historico.getShimporteinteres(), historico.getShnumfraccion(),
				historico.getShcodigo());
		return historico;
	}

	/**
	 * Updates a single row in the Historico table.
	 * 
	 * @param escodigoBueno
	 *            Pagination
	 * @param escodigoAfusionar
	 *            Pagination
	 */
	public void updateEstablecimiento(String escodigoBueno,
			String escodigoAfusionar) {
		String query = "UPDATE HISTORICO SET SHIDESTABLECIMIENTO=? WHERE SHIDESTABLECIMIENTO=?";
		this.jdbcTemplate.update(query, escodigoBueno, escodigoAfusionar);
	}

	/**
	 * Finds a single row in the Historico table.
	 * 
	 * @param historico
	 *            Pagination
	 * @return Historico
	 */
	@Transactional(readOnly = true)
	public Historico find(Historico historico) {
		String query = "SELECT t1.SHCODIGO SHCODIGO, t1.SHREFERENCIA SHREFERENCIA, t1.SHEXPEDIENTE SHEXPEDIENTE, t1.SHIDEXPEDIENTE SHIDEXPEDIENTE, t1.SHCODPROC SHCODPROC, t1.SHIDESTABLECIMIENTO SHIDESTABLECIMIENTO, t1.SHFECHAEMISION SHFECHAEMISION, t1.SHIDESTADOPAGO SHIDESTADOPAGO, t1.SHFECHAESTADO SHFECHAESTADO, t1.SHFECHALIMITEPAGO SHFECHALIMITEPAGO, t1.SHFECHAPAGO SHFECHAPAGO, t1.SHIDMETODOPAGO SHIDMETODOPAGO, t1.SHFRACCIONADO SHFRACCIONADO, t1.SHIMPORTE SHIMPORTE, t1.SHIDCONCEPTO SHIDCONCEPTO, t1.SHDESCRIPCIONPAGO SHDESCRIPCIONPAGO, t1.SHOBSERVACIONES SHOBSERVACIONES, t1.SHDIGITOCONTROL SHDIGITOCONTROL, t1.SHREFERENCIAFRACC SHREFERENCIAFRACC, t1.SHIMPORTEINTERES SHIMPORTEINTERES, t1.SHNUMFRACCION SHNUMFRACCION, t2.SFCODIGO MOVIMIENTOSSFCODIGO, t2.SFREFERENCIA MOVIMIENTOSSFREFERENCIA, t2.SFTIPOMOV MOVIMIENTOSSFTIPOMOV, t2.SFPERIODO MOVIMIENTOSSFPERIODO, t2.SFSENTIDO MOVIMIENTOSSFSENTIDO, t2.SFFECHAOPERACION MOVIMIENTOSSFFECHAOPERACION, t2.SFESTADOMOV MOVIMIENTOSSFESTADOMOV, t2.SFDETALLE MOVIMIENTOSSFDETALLE FROM HISTORICO t1 , MOVIMIENTOS t2  WHERE t1.SHCODIGO = ?   AND t1.SHIDMOVIMIENTO= t2.SFCODIGO(+)";

		List<Historico> historicoList = this.jdbcTemplate.query(query,
				this.rwMap, historico.getShcodigo());
		return (Historico) DataAccessUtils.uniqueResult(historicoList);
	}

	/**
	 * Removes a single row in the Historico table.
	 * 
	 * @param historico
	 *            Pagination
	 * @return
	 */
	public void remove(Historico historico) {
		String query = "DELETE FROM HISTORICO WHERE SHCODIGO=?";
		this.jdbcTemplate.update(query, historico.getShcodigo());
	}

	/**
	 * Finds a List of rows in the Historico table.
	 * 
	 * @param historico
	 *            Historico
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Historico> findAll(Historico historico, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.SHCODIGO SHCODIGO,t1.SHREFERENCIA SHREFERENCIA,t1.SHEXPEDIENTE SHEXPEDIENTE,t1.SHIDEXPEDIENTE SHIDEXPEDIENTE,t1.SHCODPROC SHCODPROC,t1.SHIDESTABLECIMIENTO SHIDESTABLECIMIENTO,t1.SHFECHAEMISION SHFECHAEMISION,t1.SHIDESTADOPAGO SHIDESTADOPAGO,t1.SHFECHAESTADO SHFECHAESTADO,t1.SHFECHALIMITEPAGO SHFECHALIMITEPAGO,t1.SHFECHAPAGO SHFECHAPAGO,t1.SHIDMETODOPAGO SHIDMETODOPAGO,t1.SHFRACCIONADO SHFRACCIONADO,t1.SHIMPORTE SHIMPORTE,t1.SHIDCONCEPTO SHIDCONCEPTO,t1.SHDESCRIPCIONPAGO SHDESCRIPCIONPAGO,t1.SHOBSERVACIONES SHOBSERVACIONES,t1.SHDIGITOCONTROL SHDIGITOCONTROL,t1.SHREFERENCIAFRACC SHREFERENCIAFRACC,t1.SHIMPORTEINTERES SHIMPORTEINTERES,t1.SHNUMFRACCION SHNUMFRACCION,t2.SFCODIGO MOVIMIENTOSSFCODIGO,t2.SFREFERENCIA MOVIMIENTOSSFREFERENCIA,t2.SFTIPOMOV MOVIMIENTOSSFTIPOMOV,t2.SFPERIODO MOVIMIENTOSSFPERIODO,t2.SFSENTIDO MOVIMIENTOSSFSENTIDO,t2.SFFECHAOPERACION MOVIMIENTOSSFFECHAOPERACION,t2.SFESTADOMOV MOVIMIENTOSSFESTADOMOV,t2.SFDETALLE MOVIMIENTOSSFDETALLE ");
		query.append("FROM HISTORICO t1 ,MOVIMIENTOS t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(historico);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.SHIDMOVIMIENTO= t2.SFCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Historico>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Historico table.
	 * 
	 * @param historico
	 *            Historico
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Historico historico) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM HISTORICO t1 , MOVIMIENTOS t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(historico);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.SHIDMOVIMIENTO= t2.SFCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Historico table using like.
	 * 
	 * @param historico
	 *            Historico
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Historico> findAllLike(Historico historico,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.SHCODIGO SHCODIGO,t1.SHREFERENCIA SHREFERENCIA,t1.SHEXPEDIENTE SHEXPEDIENTE,t1.SHIDEXPEDIENTE SHIDEXPEDIENTE,t1.SHCODPROC SHCODPROC,t1.SHIDESTABLECIMIENTO SHIDESTABLECIMIENTO,t1.SHFECHAEMISION SHFECHAEMISION,t1.SHIDESTADOPAGO SHIDESTADOPAGO,t1.SHFECHAESTADO SHFECHAESTADO,t1.SHFECHALIMITEPAGO SHFECHALIMITEPAGO,t1.SHFECHAPAGO SHFECHAPAGO,t1.SHIDMETODOPAGO SHIDMETODOPAGO,t1.SHFRACCIONADO SHFRACCIONADO,t1.SHIMPORTE SHIMPORTE,t1.SHIDCONCEPTO SHIDCONCEPTO,t1.SHDESCRIPCIONPAGO SHDESCRIPCIONPAGO,t1.SHOBSERVACIONES SHOBSERVACIONES,t1.SHDIGITOCONTROL SHDIGITOCONTROL,t1.SHREFERENCIAFRACC SHREFERENCIAFRACC,t1.SHIMPORTEINTERES SHIMPORTEINTERES,t1.SHNUMFRACCION SHNUMFRACCION,t2.SFCODIGO MOVIMIENTOSSFCODIGO,t2.SFREFERENCIA MOVIMIENTOSSFREFERENCIA,t2.SFTIPOMOV MOVIMIENTOSSFTIPOMOV,t2.SFPERIODO MOVIMIENTOSSFPERIODO,t2.SFSENTIDO MOVIMIENTOSSFSENTIDO,t2.SFFECHAOPERACION MOVIMIENTOSSFFECHAOPERACION,t2.SFESTADOMOV MOVIMIENTOSSFESTADOMOV,t2.SFDETALLE MOVIMIENTOSSFDETALLE ");
		query.append("FROM HISTORICO t1 ,MOVIMIENTOS t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(historico, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.SHIDMOVIMIENTO= t2.SFCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Historico>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Historico table using like.
	 * 
	 * @param historico
	 *            Historico
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Historico historico, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM HISTORICO t1 ,MOVIMIENTOS t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(historico, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.SHIDMOVIMIENTO= t2.SFCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Historico entity
	 * 
	 * @param historico
	 *            Historico Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Historico historico) {

		StringBuilder where = new StringBuilder(
				HistoricoDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (historico != null && historico.getShcodigo() != null) {
			where.append(" AND t1.SHCODIGO = ?");
			params.add(historico.getShcodigo());
		}
		if (historico != null && historico.getMovimientos() != null
				&& historico.getMovimientos().getSfcodigo() != null) {
			where.append(" AND t2.SFCODIGO = ?");
			params.add(historico.getMovimientos().getSfcodigo());
		}
		if (historico != null && historico.getMovimientos() != null
				&& historico.getMovimientos().getSfreferencia() != null) {
			where.append(" AND t2.SFREFERENCIA = ?");
			params.add(historico.getMovimientos().getSfreferencia());
		}
		if (historico != null && historico.getMovimientos() != null
				&& historico.getMovimientos().getSftipomov() != null) {
			where.append(" AND t2.SFTIPOMOV = ?");
			params.add(historico.getMovimientos().getSftipomov());
		}
		if (historico != null && historico.getMovimientos() != null
				&& historico.getMovimientos().getSfperiodo() != null) {
			where.append(" AND t2.SFPERIODO = ?");
			params.add(historico.getMovimientos().getSfperiodo());
		}
		if (historico != null && historico.getMovimientos() != null
				&& historico.getMovimientos().getSfsentido() != null) {
			where.append(" AND t2.SFSENTIDO = ?");
			params.add(historico.getMovimientos().getSfsentido());
		}
		if (historico != null && historico.getMovimientos() != null
				&& historico.getMovimientos().getSffechaoperacion() != null) {
			where.append(" AND t2.SFFECHAOPERACION = ?");
			params.add(historico.getMovimientos().getSffechaoperacion());
		}
		if (historico != null && historico.getMovimientos() != null
				&& historico.getMovimientos().getSfestadomov() != null) {
			where.append(" AND t2.SFESTADOMOV = ?");
			params.add(historico.getMovimientos().getSfestadomov());
		}
		if (historico != null && historico.getMovimientos() != null
				&& historico.getMovimientos().getSfdetalle() != null) {
			where.append(" AND t2.SFDETALLE = ?");
			params.add(historico.getMovimientos().getSfdetalle());
		}
		if (historico != null && historico.getShreferencia() != null) {
			where.append(" AND t1.SHREFERENCIA = ?");
			params.add(historico.getShreferencia());
		}
		if (historico != null && historico.getShexpediente() != null) {
			where.append(" AND t1.SHEXPEDIENTE = ?");
			params.add(historico.getShexpediente());
		}
		if (historico != null && historico.getShidexpediente() != null) {
			where.append(" AND t1.SHIDEXPEDIENTE = ?");
			params.add(historico.getShidexpediente());
		}
		if (historico != null && historico.getShcodproc() != null) {
			where.append(" AND t1.SHCODPROC = ?");
			params.add(historico.getShcodproc());
		}
		if (historico != null && historico.getShidestablecimiento() != null) {
			where.append(" AND t1.SHIDESTABLECIMIENTO = ?");
			params.add(historico.getShidestablecimiento());
		}
		if (historico != null && historico.getShfechaemision() != null) {
			where.append(" AND t1.SHFECHAEMISION = ?");
			params.add(historico.getShfechaemision());
		}
		if (historico != null && historico.getShidestadopago() != null) {
			where.append(" AND t1.SHIDESTADOPAGO = ?");
			params.add(historico.getShidestadopago());
		}
		if (historico != null && historico.getShfechaestado() != null) {
			where.append(" AND t1.SHFECHAESTADO = ?");
			params.add(historico.getShfechaestado());
		}
		if (historico != null && historico.getShfechalimitepago() != null) {
			where.append(" AND t1.SHFECHALIMITEPAGO = ?");
			params.add(historico.getShfechalimitepago());
		}
		if (historico != null && historico.getShfechapago() != null) {
			where.append(" AND t1.SHFECHAPAGO = ?");
			params.add(historico.getShfechapago());
		}
		if (historico != null && historico.getShidmetodopago() != null) {
			where.append(" AND t1.SHIDMETODOPAGO = ?");
			params.add(historico.getShidmetodopago());
		}
		if (historico != null && historico.getShfraccionado() != null) {
			where.append(" AND t1.SHFRACCIONADO = ?");
			params.add(historico.getShfraccionado());
		}
		if (historico != null && historico.getShimporte() != null) {
			where.append(" AND t1.SHIMPORTE = ?");
			params.add(historico.getShimporte());
		}
		if (historico != null && historico.getShidconcepto() != null) {
			where.append(" AND t1.SHIDCONCEPTO = ?");
			params.add(historico.getShidconcepto());
		}
		if (historico != null && historico.getShdescripcionpago() != null) {
			where.append(" AND t1.SHDESCRIPCIONPAGO = ?");
			params.add(historico.getShdescripcionpago());
		}
		if (historico != null && historico.getShobservaciones() != null) {
			where.append(" AND t1.SHOBSERVACIONES = ?");
			params.add(historico.getShobservaciones());
		}
		if (historico != null && historico.getShdigitocontrol() != null) {
			where.append(" AND t1.SHDIGITOCONTROL = ?");
			params.add(historico.getShdigitocontrol());
		}
		if (historico != null && historico.getShreferenciafracc() != null) {
			where.append(" AND t1.SHREFERENCIAFRACC = ?");
			params.add(historico.getShreferenciafracc());
		}
		if (historico != null && historico.getShimporteinteres() != null) {
			where.append(" AND t1.SHIMPORTEINTERES = ?");
			params.add(historico.getShimporteinteres());
		}
		if (historico != null && historico.getShnumfraccion() != null) {
			where.append(" AND t1.SHNUMFRACCION = ?");
			params.add(historico.getShnumfraccion());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Historico entity
	 * 
	 * @param historico
	 *            Historico Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Historico historico,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				HistoricoDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (historico != null && historico.getShcodigo() != null) {
			where.append(" AND UPPER(t1.SHCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(historico.getShcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + historico.getShcodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.SHCODIGO IS NOT NULL");
		}
		if (historico != null && historico.getMovimientos() != null
				&& historico.getMovimientos().getSfcodigo() != null) {
			where.append(" AND t2.SFCODIGO = ?");
			params.add(historico.getMovimientos().getSfcodigo());
		}
		if (historico != null && historico.getMovimientos() != null
				&& historico.getMovimientos().getSfreferencia() != null) {
			where.append(" AND UPPER(t2.SFREFERENCIA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(historico.getMovimientos().getSfreferencia()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ historico.getMovimientos().getSfreferencia()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.SFREFERENCIA IS NOT NULL");
		}
		if (historico != null && historico.getMovimientos() != null
				&& historico.getMovimientos().getSftipomov() != null) {
			where.append(" AND UPPER(t2.SFTIPOMOV) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(historico.getMovimientos().getSftipomov()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ historico.getMovimientos().getSftipomov()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.SFTIPOMOV IS NOT NULL");
		}
		if (historico != null && historico.getMovimientos() != null
				&& historico.getMovimientos().getSfperiodo() != null) {
			where.append(" AND UPPER(t2.SFPERIODO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(historico.getMovimientos().getSfperiodo()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ historico.getMovimientos().getSfperiodo()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.SFPERIODO IS NOT NULL");
		}
		if (historico != null && historico.getMovimientos() != null
				&& historico.getMovimientos().getSfsentido() != null) {
			where.append(" AND UPPER(t2.SFSENTIDO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(historico.getMovimientos().getSfsentido()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ historico.getMovimientos().getSfsentido()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.SFSENTIDO IS NOT NULL");
		}
		if (historico != null && historico.getMovimientos() != null
				&& historico.getMovimientos().getSffechaoperacion() != null) {
			where.append(" AND t2.SFFECHAOPERACION = ?");
			params.add(historico.getMovimientos().getSffechaoperacion());
		}
		if (historico != null && historico.getMovimientos() != null
				&& historico.getMovimientos().getSfestadomov() != null) {
			where.append(" AND UPPER(t2.SFESTADOMOV) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(historico.getMovimientos().getSfestadomov()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ historico.getMovimientos().getSfestadomov()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.SFESTADOMOV IS NOT NULL");
		}
		if (historico != null && historico.getMovimientos() != null
				&& historico.getMovimientos().getSfdetalle() != null) {
			where.append(" AND UPPER(t2.SFDETALLE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(historico.getMovimientos().getSfdetalle()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ historico.getMovimientos().getSfdetalle()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.SFDETALLE IS NOT NULL");
		}
		if (historico != null && historico.getShreferencia() != null) {
			where.append(" AND UPPER(t1.SHREFERENCIA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(historico.getShreferencia().toUpperCase() + "%");
			} else {
				params.add("%" + historico.getShreferencia().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SHREFERENCIA IS NOT NULL");
		}
		if (historico != null && historico.getShexpediente() != null) {
			where.append(" AND UPPER(t1.SHEXPEDIENTE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(historico.getShexpediente().toUpperCase() + "%");
			} else {
				params.add("%" + historico.getShexpediente().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SHEXPEDIENTE IS NOT NULL");
		}
		if (historico != null && historico.getShidexpediente() != null) {
			where.append(" AND UPPER(t1.SHIDEXPEDIENTE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(historico.getShidexpediente().toUpperCase() + "%");
			} else {
				params.add("%" + historico.getShidexpediente().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SHIDEXPEDIENTE IS NOT NULL");
		}
		if (historico != null && historico.getShcodproc() != null) {
			where.append(" AND UPPER(t1.SHCODPROC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(historico.getShcodproc().toUpperCase() + "%");
			} else {
				params.add("%" + historico.getShcodproc().toUpperCase() + "%");
			}
			where.append(" AND t1.SHCODPROC IS NOT NULL");
		}
		if (historico != null && historico.getShidestablecimiento() != null) {
			where.append(" AND UPPER(t1.SHIDESTABLECIMIENTO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(historico.getShidestablecimiento().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ historico.getShidestablecimiento().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SHIDESTABLECIMIENTO IS NOT NULL");
		}
		if (historico != null && historico.getShfechaemision() != null) {
			where.append(" AND t1.SHFECHAEMISION = ?");
			params.add(historico.getShfechaemision());
		}
		if (historico != null && historico.getShidestadopago() != null) {
			where.append(" AND UPPER(t1.SHIDESTADOPAGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(historico.getShidestadopago().toUpperCase() + "%");
			} else {
				params.add("%" + historico.getShidestadopago().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SHIDESTADOPAGO IS NOT NULL");
		}
		if (historico != null && historico.getShfechaestado() != null) {
			where.append(" AND t1.SHFECHAESTADO = ?");
			params.add(historico.getShfechaestado());
		}
		if (historico != null && historico.getShfechalimitepago() != null) {
			where.append(" AND t1.SHFECHALIMITEPAGO = ?");
			params.add(historico.getShfechalimitepago());
		}
		if (historico != null && historico.getShfechapago() != null) {
			where.append(" AND t1.SHFECHAPAGO = ?");
			params.add(historico.getShfechapago());
		}
		if (historico != null && historico.getShidmetodopago() != null) {
			where.append(" AND UPPER(t1.SHIDMETODOPAGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(historico.getShidmetodopago().toUpperCase() + "%");
			} else {
				params.add("%" + historico.getShidmetodopago().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SHIDMETODOPAGO IS NOT NULL");
		}
		if (historico != null && historico.getShfraccionado() != null) {
			where.append(" AND UPPER(t1.SHFRACCIONADO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(historico.getShfraccionado().toUpperCase() + "%");
			} else {
				params.add("%" + historico.getShfraccionado().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SHFRACCIONADO IS NOT NULL");
		}
		if (historico != null && historico.getShimporte() != null) {
			where.append(" AND t1.SHIMPORTE = ?");
			params.add(historico.getShimporte());
		}
		if (historico != null && historico.getShidconcepto() != null) {
			where.append(" AND UPPER(t1.SHIDCONCEPTO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(historico.getShidconcepto().toUpperCase() + "%");
			} else {
				params.add("%" + historico.getShidconcepto().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SHIDCONCEPTO IS NOT NULL");
		}
		if (historico != null && historico.getShdescripcionpago() != null) {
			where.append(" AND UPPER(t1.SHDESCRIPCIONPAGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(historico.getShdescripcionpago().toUpperCase() + "%");
			} else {
				params.add("%" + historico.getShdescripcionpago().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SHDESCRIPCIONPAGO IS NOT NULL");
		}
		if (historico != null && historico.getShobservaciones() != null) {
			where.append(" AND UPPER(t1.SHOBSERVACIONES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(historico.getShobservaciones().toUpperCase() + "%");
			} else {
				params.add("%" + historico.getShobservaciones().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SHOBSERVACIONES IS NOT NULL");
		}
		if (historico != null && historico.getShdigitocontrol() != null) {
			where.append(" AND UPPER(t1.SHDIGITOCONTROL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(historico.getShdigitocontrol().toUpperCase() + "%");
			} else {
				params.add("%" + historico.getShdigitocontrol().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SHDIGITOCONTROL IS NOT NULL");
		}
		if (historico != null && historico.getShreferenciafracc() != null) {
			where.append(" AND UPPER(t1.SHREFERENCIAFRACC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(historico.getShreferenciafracc().toUpperCase() + "%");
			} else {
				params.add("%" + historico.getShreferenciafracc().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SHREFERENCIAFRACC IS NOT NULL");
		}
		if (historico != null && historico.getShimporteinteres() != null) {
			where.append(" AND t1.SHIMPORTEINTERES = ?");
			params.add(historico.getShimporteinteres());
		}
		if (historico != null && historico.getShnumfraccion() != null) {
			where.append(" AND t1.SHNUMFRACCION = ?");
			params.add(historico.getShnumfraccion());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
