package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.Historico;

/**
 * HistoricoDao  
 * 
 *  
 */

public interface HistoricoDao {

	/**
	 * Inserts a single row in the Historico table.
	 * 
	 * @param historico
	 *            Historico
	 * @return Historico
	 */
	Historico add(Historico historico);

	/**
	 * Updates a single row in the Historico table.
	 * 
	 * @param historico
	 *            Historico
	 * @return Historico
	 */
	Historico update(Historico historico);

	/**
	 * Updates a single row in the Historico table.
	 * 
	 * @param escodigoBueno
	 *            Pagination
	 * @param escodigoAfusionar
	 *            Pagination
	 */
	public void updateEstablecimiento(String escodigoBueno,
			String escodigoAfusionar);

	/**
	 * Finds a single row in the Historico table.
	 * 
	 * @param historico
	 *            Historico
	 * @return Historico
	 */
	Historico find(Historico historico);

	/**
	 * Deletes a single row in the Historico table.
	 * 
	 * @param historico
	 *            Historico
	 * @return
	 */
	void remove(Historico historico);

	/**
	 * Finds a List of rows in the Historico table.
	 * 
	 * @param historico
	 *            Historico
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Historico> findAll(Historico historico, Pagination pagination);

	/**
	 * Counts rows in the Historico table.
	 * 
	 * @param historico
	 *            Historico
	 * @return Long
	 */
	Long findAllCount(Historico historico);

	/**
	 * Finds rows in the Historico table using like.
	 * 
	 * @param historico
	 *            Historico
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Historico> findAllLike(Historico historico, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Historico table using like.
	 * 
	 * @param historico
	 *            Historico
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Historico historico, Boolean startsWith);
}
