package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.HistorialAlerta;

/**
 * HistorialAlertaDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class HistorialAlertaDaoImpl implements HistorialAlertaDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<HistorialAlerta> rwMap = new RowMapper<HistorialAlerta>() {
		public HistorialAlerta mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new HistorialAlerta(resultSet.getString("IDHISTORIAL"),
					resultSet.getString("CODIGO"),
					resultSet.getString("ORGANISMOORIGEN"),
					resultSet.getString("ORGANISMODESTINO"),
					resultSet.getString("DESCRIPCION"),
					resultSet.getString("GENERADO"),
					resultSet.getDate("FECHA"),
					resultSet.getString("COMOHISTORIAL"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the HistorialAlerta table.
	 * 
	 * @param historialalerta
	 *            Pagination
	 * @return HistorialAlerta
	 */
	public HistorialAlerta add(HistorialAlerta historialalerta) {
		String query = "INSERT INTO HISTORIAL_ALERTA (IDHISTORIAL, CODIGO, ORGANISMOORIGEN, ORGANISMODESTINO, DESCRIPCION, GENERADO, FECHA, COMOHISTORIAL) VALUES (?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, historialalerta.getIdhistorial(),
				historialalerta.getCodigo(),
				historialalerta.getOrganismoorigen(),
				historialalerta.getOrganismodestino(),
				historialalerta.getDescripcion(),
				historialalerta.getGenerado(), historialalerta.getFecha(),
				historialalerta.getComohistorial());
		return historialalerta;
	}

	/**
	 * Updates a single row in the HistorialAlerta table.
	 * 
	 * @param historialalerta
	 *            Pagination
	 * @return HistorialAlerta
	 */
	public HistorialAlerta update(HistorialAlerta historialalerta) {
		String query = "UPDATE HISTORIAL_ALERTA SET CODIGO=?, ORGANISMOORIGEN=?, ORGANISMODESTINO=?, DESCRIPCION=?, GENERADO=?, FECHA=?, COMOHISTORIAL=? WHERE IDHISTORIAL=?";
		this.jdbcTemplate.update(query, historialalerta.getCodigo(),
				historialalerta.getOrganismoorigen(),
				historialalerta.getOrganismodestino(),
				historialalerta.getDescripcion(),
				historialalerta.getGenerado(), historialalerta.getFecha(),
				historialalerta.getComohistorial(),
				historialalerta.getIdhistorial());
		return historialalerta;
	}

	/**
	 * Finds a single row in the HistorialAlerta table.
	 * 
	 * @param historialalerta
	 *            Pagination
	 * @return HistorialAlerta
	 */
	@Transactional(readOnly = true)
	public HistorialAlerta find(HistorialAlerta historialalerta) {
		String query = "SELECT t1.IDHISTORIAL IDHISTORIAL, t1.CODIGO CODIGO, t1.ORGANISMOORIGEN ORGANISMOORIGEN, t1.ORGANISMODESTINO ORGANISMODESTINO, t1.DESCRIPCION DESCRIPCION, t1.GENERADO GENERADO, t1.FECHA FECHA, t1.COMOHISTORIAL COMOHISTORIAL FROM HISTORIAL_ALERTA t1  WHERE t1.IDHISTORIAL = ?  ";

		List<HistorialAlerta> historialalertaList = this.jdbcTemplate.query(
				query, this.rwMap, historialalerta.getIdhistorial());
		return (HistorialAlerta) DataAccessUtils
				.uniqueResult(historialalertaList);
	}

	/**
	 * Removes a single row in the HistorialAlerta table.
	 * 
	 * @param historialalerta
	 *            Pagination
	 * @return
	 */
	public void remove(HistorialAlerta historialalerta) {
		String query = "DELETE FROM HISTORIAL_ALERTA WHERE IDHISTORIAL=?";
		this.jdbcTemplate.update(query, historialalerta.getIdhistorial());
	}

	/**
	 * Removes a single row in the HistorialAlerta table.
	 * 
	 * @param historialalerta
	 *            Pagination
	 * @return
	 */
	public void removeAllExpediente(HistorialAlerta historialalerta) {
		String query = "DELETE FROM HISTORIAL_ALERTA WHERE CODIGO=?";
		this.jdbcTemplate.update(query, historialalerta.getCodigo());
	}

	/**
	 * Finds a List of rows in the HistorialAlerta table.
	 * 
	 * @param historialalerta
	 *            HistorialAlerta
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<HistorialAlerta> findAll(HistorialAlerta historialalerta,
			Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDHISTORIAL IDHISTORIAL,t1.CODIGO CODIGO,t1.ORGANISMOORIGEN ORGANISMOORIGEN,t1.ORGANISMODESTINO ORGANISMODESTINO,t1.DESCRIPCION DESCRIPCION,t1.GENERADO GENERADO,t1.FECHA FECHA, t1.COMOHISTORIAL COMOHISTORIAL ");
		query.append("FROM HISTORIAL_ALERTA t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(historialalerta);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<HistorialAlerta>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the HistorialAlerta table.
	 * 
	 * @param historialalerta
	 *            HistorialAlerta
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(HistorialAlerta historialalerta) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM HISTORIAL_ALERTA t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(historialalerta);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the HistorialAlerta table using like.
	 * 
	 * @param historialalerta
	 *            HistorialAlerta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<HistorialAlerta> findAllLike(HistorialAlerta historialalerta,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDHISTORIAL IDHISTORIAL,t1.CODIGO CODIGO,t1.ORGANISMOORIGEN ORGANISMOORIGEN,t1.ORGANISMODESTINO ORGANISMODESTINO,t1.DESCRIPCION DESCRIPCION,t1.GENERADO GENERADO,t1.FECHA FECHA, t1.COMOHISTORIAL COMOHISTORIAL ");
		query.append("FROM HISTORIAL_ALERTA t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(historialalerta,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<HistorialAlerta>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the HistorialAlerta table using like.
	 * 
	 * @param historialalerta
	 *            HistorialAlerta
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(HistorialAlerta historialalerta,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM HISTORIAL_ALERTA t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(historialalerta,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the HistorialAlerta entity
	 * 
	 * @param historialalerta
	 *            HistorialAlerta Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(HistorialAlerta historialalerta) {

		StringBuilder where = new StringBuilder(
				HistorialAlertaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (historialalerta != null && historialalerta.getIdhistorial() != null) {
			where.append(" AND t1.IDHISTORIAL = ?");
			params.add(historialalerta.getIdhistorial());
		}
		if (historialalerta != null && historialalerta.getCodigo() != null) {
			where.append(" AND t1.CODIGO = ?");
			params.add(historialalerta.getCodigo());
		}
		if (historialalerta != null
				&& historialalerta.getOrganismoorigen() != null) {
			where.append(" AND t1.ORGANISMOORIGEN = ?");
			params.add(historialalerta.getOrganismoorigen());
		}
		if (historialalerta != null
				&& historialalerta.getOrganismodestino() != null) {
			where.append(" AND t1.ORGANISMODESTINO = ?");
			params.add(historialalerta.getOrganismodestino());
		}
		if (historialalerta != null && historialalerta.getDescripcion() != null) {
			where.append(" AND t1.DESCRIPCION = ?");
			params.add(historialalerta.getDescripcion());
		}
		if (historialalerta != null && historialalerta.getGenerado() != null) {
			where.append(" AND t1.GENERADO = ?");
			params.add(historialalerta.getGenerado());
		}
		if (historialalerta != null && historialalerta.getFecha() != null) {
			where.append(" AND t1.FECHA = ?");
			params.add(historialalerta.getFecha());
		}
		if (historialalerta != null
				&& historialalerta.getComohistorial() != null) {
			where.append(" AND t1.COMOHISTORIAL = ?");
			params.add(historialalerta.getComohistorial());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the HistorialAlerta entity
	 * 
	 * @param historialalerta
	 *            HistorialAlerta Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(HistorialAlerta historialalerta,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				HistorialAlertaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (historialalerta != null && historialalerta.getIdhistorial() != null) {
			where.append(" AND UPPER(t1.IDHISTORIAL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(historialalerta.getIdhistorial().toUpperCase() + "%");
			} else {
				params.add("%" + historialalerta.getIdhistorial().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.IDHISTORIAL IS NOT NULL");
		}
		if (historialalerta != null && historialalerta.getCodigo() != null) {
			where.append(" AND UPPER(t1.CODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(historialalerta.getCodigo().toUpperCase() + "%");
			} else {
				params.add("%" + historialalerta.getCodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.CODIGO IS NOT NULL");
		}
		if (historialalerta != null
				&& historialalerta.getOrganismoorigen() != null) {
			where.append(" AND UPPER(t1.ORGANISMOORIGEN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(historialalerta.getOrganismoorigen().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ historialalerta.getOrganismoorigen().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ORGANISMOORIGEN IS NOT NULL");
		}
		if (historialalerta != null
				&& historialalerta.getOrganismodestino() != null) {
			where.append(" AND UPPER(t1.ORGANISMODESTINO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(historialalerta.getOrganismodestino().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ historialalerta.getOrganismodestino().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ORGANISMODESTINO IS NOT NULL");
		}
		if (historialalerta != null && historialalerta.getDescripcion() != null) {
			where.append(" AND UPPER(t1.DESCRIPCION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(historialalerta.getDescripcion().toUpperCase() + "%");
			} else {
				params.add("%" + historialalerta.getDescripcion().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.DESCRIPCION IS NOT NULL");
		}
		if (historialalerta != null && historialalerta.getGenerado() != null) {
			where.append(" AND UPPER(t1.GENERADO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(historialalerta.getGenerado().toUpperCase() + "%");
			} else {
				params.add("%" + historialalerta.getGenerado().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.GENERADO IS NOT NULL");
		}
		if (historialalerta != null && historialalerta.getFecha() != null) {
			where.append(" AND t1.FECHA = ?");
			params.add(historialalerta.getFecha());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
