package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.HistorialAlerta;

/**
 * HistorialAlertaDao  
 * 
 *  
 */

public interface HistorialAlertaDao {

	/**
	 * Inserts a single row in the HistorialAlerta table.
	 * 
	 * @param historialalerta
	 *            HistorialAlerta
	 * @return HistorialAlerta
	 */
	HistorialAlerta add(HistorialAlerta historialalerta);

	/**
	 * Updates a single row in the HistorialAlerta table.
	 * 
	 * @param historialalerta
	 *            HistorialAlerta
	 * @return HistorialAlerta
	 */
	HistorialAlerta update(HistorialAlerta historialalerta);

	/**
	 * Finds a single row in the HistorialAlerta table.
	 * 
	 * @param historialalerta
	 *            HistorialAlerta
	 * @return HistorialAlerta
	 */
	HistorialAlerta find(HistorialAlerta historialalerta);

	/**
	 * Deletes a single row in the HistorialAlerta table.
	 * 
	 * @param historialalerta
	 *            HistorialAlerta
	 * @return
	 */
	void remove(HistorialAlerta historialalerta);

	/**
	 * Removes a single row in the HistorialAlerta table.
	 * 
	 * @param historialalerta
	 *            Pagination
	 * @return
	 */
	public void removeAllExpediente(HistorialAlerta historialalerta);

	/**
	 * Finds a List of rows in the HistorialAlerta table.
	 * 
	 * @param historialalerta
	 *            HistorialAlerta
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<HistorialAlerta> findAll(HistorialAlerta historialalerta,
			Pagination pagination);

	/**
	 * Counts rows in the HistorialAlerta table.
	 * 
	 * @param historialalerta
	 *            HistorialAlerta
	 * @return Long
	 */
	Long findAllCount(HistorialAlerta historialalerta);

	/**
	 * Finds rows in the HistorialAlerta table using like.
	 * 
	 * @param historialalerta
	 *            HistorialAlerta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<HistorialAlerta> findAllLike(HistorialAlerta historialalerta,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the HistorialAlerta table using like.
	 * 
	 * @param historialalerta
	 *            HistorialAlerta
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(HistorialAlerta historialalerta, Boolean startsWith);
}
