// CHECKSTYLE:OFF
package com.ejie.y41b.dao;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.BusquedaCombinada;
import com.ejie.y41b.model.CargaTrabajo;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Consumidor;
import com.ejie.y41b.model.ConsumidorReclamaciones;
import com.ejie.y41b.model.Denuncia;
import com.ejie.y41b.model.Descriptor;
import com.ejie.y41b.model.Establecimiento;
import com.ejie.y41b.model.EstablecimientoDecisionAnyo;
import com.ejie.y41b.model.EstablecimientoReclamacionesAnyo;
import com.ejie.y41b.model.FormaPresentacion;
import com.ejie.y41b.model.HechoDenunciado;
import com.ejie.y41b.model.Intervinientes;
import com.ejie.y41b.model.Motivo;
import com.ejie.y41b.model.Organismo;
import com.ejie.y41b.model.PlantillaSolicitudDetalle;
import com.ejie.y41b.model.ProdAgrupado;
import com.ejie.y41b.model.Producto;
import com.ejie.y41b.model.Sector;
import com.ejie.y41b.model.SectorAgrupado;
import com.ejie.y41b.model.SolicitudBusqueda;
import com.ejie.y41b.model.SolicitudDetalle;
import com.ejie.y41b.model.TipoReclamacion;
import com.ejie.y41b.model.TramiteHechoDetalle;
import com.ejie.y41b.utils.Y41bUtils;

/**
 * * HechoDenunciadoDaoImpl  
 * 
 *  
 */
// CHECKSTYLE:OFF
@SuppressWarnings(value = { "deprecation" })
@Repository
@Transactional
public class HechoDenunciadoDaoImpl implements HechoDenunciadoDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<HechoDenunciado> rwMap = new RowMapper<HechoDenunciado>() {
		public HechoDenunciado mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new HechoDenunciado(resultSet.getString("HDCODIGO"), resultSet.getLong("HDNROR"),
					resultSet.getString("HDTE"), resultSet.getString("HDTEDOAD"), resultSet.getString("HDCOAV"),
					resultSet.getString("HDNOPS"), resultSet.getString("HDNOMAPS"), resultSet.getString("HDNOMOPS"),
					resultSet.getString("HDNRLOPS"), resultSet.getString("HDCODIGOBARRAS"),
					resultSet.getDate("HDFEDMPS"), resultSet.getString("HDINSOTR"), resultSet.getString("HDINSOMA"),
					resultSet.getBigDecimal("HDCAPTSO"), resultSet.getString("HDTESO"), resultSet.getDate("HDFEARDT"),
					resultSet.getDate("HDFEIOHD"), resultSet.getString("HDINININ"), resultSet.getDate("HDFEIOPC"),
					resultSet.getDate("HDFEROPC"), resultSet.getString("HDCOREPC"), resultSet.getDate("HDFEIORP"),
					resultSet.getDate("HDFERORP"), resultSet.getString("HDCOREAP"), resultSet.getDate("HDFEIORA"),
					resultSet.getString("HDTEACPA"), resultSet.getDate("HDFECEAC"), resultSet.getString("HDHOCEAC"),
					resultSet.getDate("HDFEIOCA"), resultSet.getString("HDTEACDE"), resultSet.getDate("HDFEIOAC"),
					resultSet.getDate("HDFEIOFC"), resultSet.getString("HDCOTRA"), resultSet.getString("HDTE02"),
					resultSet.getString("HDTE03"), resultSet.getString("HDTE04"), resultSet.getString("HDTE05"),
					resultSet.getString("HDTE06"), resultSet.getString("HDTE07"), resultSet.getString("HDTE08"),
					resultSet.getString("HDTE09"), resultSet.getString("HDTE10"), resultSet.getString("HDCOSC"),
					resultSet.getString("HDIDAL"), resultSet.getDate("HDFEROAD"), resultSet.getDate("HDFEROAT"),
					resultSet.getString("HDTEALDT"), resultSet.getString("HDTEDEAT"), resultSet.getDate("HDFEDEAT"),
					resultSet.getDate("HDFEHD"), resultSet.getString("HDTEDOADE"), resultSet.getString("HDTEDOADI"),
					resultSet.getString("HDTEDOADF"), resultSet.getString("HDTEDOADA"), resultSet.getString("HDNOPSE"),
					resultSet.getString("HDNOPSI"), resultSet.getString("HDNOPSF"), resultSet.getString("HDNOPSA"),
					resultSet.getString("HDCOCODIGO"), null, resultSet.getString("HDFORMANOTIFICACION"),
					resultSet.getString("HDFORMANOTIFESTABLECIMIENTO"), null, null, resultSet.getString("HDFORMAVENTA"),
					resultSet.getString("HDIDIOMA"), resultSet.getString("HDINTERESADO"),
					new Denuncia(resultSet.getString("DenunciaDECODIGO"), resultSet.getString("DenunciaDECOCP"),
							resultSet.getString("DenunciaDECOOR"), resultSet.getInt("DenunciaDENRAN"),
							resultSet.getLong("DenunciaDENROR"), resultSet.getDate("DenunciaDEFEDE"),
							resultSet.getDate("DenunciaDEFERE"), resultSet.getDate("DenunciaDEFEEX"),
							resultSet.getDate("DenunciaDEFEIM"), resultSet.getString("DenunciaDEINRE"),
							resultSet.getString("DenunciaDENRRGEN"),
							new FormaPresentacion(resultSet.getString("DenunciaDECOTFP"), null, null, null, null, null,
									null),
							new Consumidor(resultSet.getString("DenunciaDECODT"), null, null, null, null, null, null,
									null, null, null, null, null, null, null, null, null, null, null, null, null, null,
									null, null, null, null, null, null, null, null, null, null, null, null, null, null,
									null, null, null, null, null, null, null, null, null, null, null, null, null, null,
									null, null, null, null, null, null, null, null, null, null, null)),
					new Establecimiento(resultSet.getString("EstablecimientoESCODIGO"),
							resultSet.getString("EstablecimientoESNOMBRE"),
							resultSet.getString("EstablecimientoESTIPID"), resultSet.getString("EstablecimientoESNIF"),
							resultSet.getString("EstablecimientoESNOAN"), resultSet.getString("EstablecimientoESNOCO"),
							resultSet.getString("EstablecimientoESNODIR"), resultSet.getString("EstablecimientoESCOLO"),
							resultSet.getString("EstablecimientoESNRCOPO"),
							resultSet.getString("EstablecimientoESNRTEL"),
							resultSet.getString("EstablecimientoESNRFAX"), resultSet.getString("EstablecimientoESCOPA"),
							resultSet.getString("EstablecimientoESINCAPR"),
							resultSet.getString("EstablecimientoESINDEMP"),
							resultSet.getString("EstablecimientoESTECO"),
							resultSet.getString("EstablecimientoESINADAR"),
							resultSet.getDate("EstablecimientoESFEADAR"), resultSet.getString("EstablecimientoESCOEM"),
							null, resultSet.getString("EstablecimientoESINEMPR"),
							resultSet.getString("EstablecimientoESNRTEL2"), resultSet.getDate("EstablecimientoESFEBA"),
							resultSet.getString("EstablecimientoESNOAP1"),
							resultSet.getString("EstablecimientoESNOAP2"), resultSet.getString("EstablecimientoESNOLO"),
							resultSet.getString("EstablecimientoESCOMAPV"),
							resultSet.getString("EstablecimientoESCOCA"),
							resultSet.getString("EstablecimientoESNOPECO"),
							resultSet.getString("EstablecimientoESCOIDCO"),
							resultSet.getString("EstablecimientoESINRECO"),
							resultSet.getString("EstablecimientoESFEMOD"),
							resultSet.getString("EstablecimientoESINESCO"),
							resultSet.getString("EstablecimientoESNOMU"), resultSet.getString("EstablecimientoESNOREP"),
							resultSet.getString("EstablecimientoESNIFREP"),
							resultSet.getString("EstablecimientoDTTEEMR"),
							resultSet.getString("EstablecimientoESCAREP"),
							resultSet.getString("EstablecimientoESTEURL"), resultSet.getString("EstablecimientoESCOOE"),
							resultSet.getString("EstablecimientoESNODECO"),
							resultSet.getString("EstablecimientoESINTIAR"),
							resultSet.getDate("EstablecimientoESFEPLAD"),
							resultSet.getString("EstablecimientoESINDEME"), resultSet.getString("EstableESNORAPAISID"),
							resultSet.getString("EstableESNORAPAISNOMBRE"),
							resultSet.getString("EstableESNORAPROVINCIAID"),
							resultSet.getString("EstableESNOMBREPROVINCIA"),
							resultSet.getString("EstableESNORAMUNICIPIOID"),
							resultSet.getString("EstableESNOMBREMUNICIPIO"),
							resultSet.getString("EstableESNORALOCALIDADID"),
							resultSet.getString("EstableESNOMBRELOCALIDAD"),
							resultSet.getString("EstableESNORACALLEID"), resultSet.getString("EstableESNOMBRECALLE"),
							resultSet.getString("EstableESNORACPID"), resultSet.getString("EstableESNOMBRECP"),
							resultSet.getString("EstableESNORAPORTALID"), resultSet.getString("EstableESNOMBREPORTAL"),
							resultSet.getString("EstableESNOMBREPISO"),
							resultSet.getString("ESTABLEESDIRECCION_NOCAPV"),
							resultSet.getString("EstableESEXTRANJERO"), null, null,
							new CensoMonitor(resultSet.getString("EstablecimientoESCOZS"), null, null, null, null, null,
									null, null, null, null, null, null, null, null, null, null, null, null, null, null,
									null, null)),
					new Sector(resultSet.getString("SectorSECODIGO"), resultSet.getString("SectorSENOMBRE"),
							resultSet.getString("SectorSENOCO"), resultSet.getString("SectorSEDESCRI"),
							resultSet.getString("SectorSECOSE"), resultSet.getString("SectorSENOCO2"),
							resultSet.getString("SectorSEINSEL1"), resultSet.getString("SectorSENOMBREE"),
							resultSet.getString("SectorSENOMBREI"), resultSet.getString("SectorSENOMBREF"),
							resultSet.getString("SectorSENOCOE"), resultSet.getString("SectorSENOCOI"),
							resultSet.getString("SectorSENOCOF"), resultSet.getString("SectorSEDESCRIE"),
							resultSet.getString("SectorSEDESCRII"), resultSet.getString("SectorSEDESCRIF"),
							resultSet.getString("SectorSECODGRUPO"), resultSet.getString("SectorSENOMBREA"),
							resultSet.getString("SectorSEDESCRIA"), resultSet.getString("SectorSENOCOA"),
							new SectorAgrupado(resultSet.getString("SectorSECOL0"), null, null, null, null)),
					new CensoMonitor(resultSet.getString("CensoMonitorMOCODIGO"),
							resultSet.getString("CensoMonitorMONOMBRE"), resultSet.getString("CensoMonitorMOCOEM"),
							resultSet.getString("CensoMonitorMODNI"), resultSet.getString("CensoMonitorUSUARIOXLNET"),
							resultSet.getString("CensoMonitorPUESTOXLNET"), resultSet.getDate("CensoMonitorMOFECBAJA"),
							new Organismo(resultSet.getString("CensoMonitorMOCOOR")), null, null, null, null, null,
							null, null, null, null, null, null, null, null, null),
					new Producto(resultSet.getString("ProductoPSCODIGO"), resultSet.getString("ProductoPSNOMBRE"),
							resultSet.getString("ProductoPSNOCO"), resultSet.getString("ProductoPSDESCRI"),
							resultSet.getString("ProductoPSCOSE"), resultSet.getString("ProductoPSNOMBREE"),
							resultSet.getString("ProductoPSNOMBREI"), resultSet.getString("ProductoPSNOMBREF"),
							resultSet.getString("ProductoPSNOMBREA"), resultSet.getString("ProductoPSNOCOE"),
							resultSet.getString("ProductoPSNOCOI"), resultSet.getString("ProductoPSNOCOF"),
							resultSet.getString("ProductoPSNOCOA"), resultSet.getString("ProductoPSDESCRIE"),
							resultSet.getString("ProductoPSDESCRII"), resultSet.getString("ProductoPSDESCRIF"),
							resultSet.getString("ProductoPSDESCRIA"), resultSet.getString("ProductoPSSEL1"),
							resultSet.getString("ProductoPSCOINC"),
							new ProdAgrupado(resultSet.getString("ProductoPSCOE8"), null, null)),
					new TipoReclamacion(resultSet.getString("TipoReclamacionTSRCODIGO"),
							resultSet.getString("TipoReclamacionTSRNOMBRE"),
							resultSet.getString("TipoReclamacionTSRNOMBREE"),
							resultSet.getString("TipoReclamacionTSRNOMBREI"),
							resultSet.getString("TipoReclamacionTSRNOMBREF"),
							resultSet.getString("TipoReclamacionTSRNOMBREA"),
							resultSet.getString("TipoReclamacionTSRIMPORTE")),
					new Motivo(resultSet.getString("MotivoTIRCODIGO"), resultSet.getString("MotivoTIRNOMBRE"), null));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the HechoDenunciado table.
	 * 
	 * @param hechodenunciado
	 *            Pagination
	 * @return HechoDenunciado
	 */
	public HechoDenunciado add(HechoDenunciado hechodenunciado) {

		String query = "INSERT INTO HECHO_DENUNCIADO( HDCODIGO,HDCODE,HDCOES,HDCOSE,HDCOMO,HDCOPS,HDCOTSR,HDCOTIR,HDNROR,HDTE,HDTEDOAD,HDCOAV,HDNOPS,HDNOMAPS,HDNOMOPS,HDNRLOPS,HDFEDMPS,HDINSOTR,HDINSOMA,HDCAPTSO,HDTESO,HDFEARDT,HDFEIOHD,HDINININ,HDFEIOPC,HDFEROPC,HDCOREPC,HDFEIORP,HDFERORP,HDCOREAP,HDFEIORA,HDTEACPA,HDFECEAC,HDHOCEAC,HDFEIOCA,HDTEACDE,HDFEIOAC,HDFEIOFC,HDCOTRA,HDTE02,HDTE03,HDTE04,HDTE05,HDTE06,HDTE07,HDTE08,HDTE09,HDTE10,HDCOSC,HDIDAL,HDFEROAD,HDFEROAT,HDTEALDT,HDTEDEAT,HDFEDEAT,HDFEHD,HDTEDOADE,HDTEDOADI,HDTEDOADF,HDTEDOADA,HDNOPSE,HDNOPSI,HDNOPSF,HDNOPSA,HDCOCODIGO)"
				+ "VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

		Object getDenunciaDecodigoAux = null;
		if (hechodenunciado.getDenuncia() != null && hechodenunciado.getDenuncia().getDecodigo() != null) {
			getDenunciaDecodigoAux = hechodenunciado.getDenuncia().getDecodigo();
		}
		Object getEstablecimientoEscodigoAux = null;
		if (hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEscodigo() != null) {
			getEstablecimientoEscodigoAux = hechodenunciado.getEstablecimiento().getEscodigo();
		}
		Object getSectorSecodigoAux = null;
		if (hechodenunciado.getSector() != null && hechodenunciado.getSector().getSecodigo() != null) {
			getSectorSecodigoAux = hechodenunciado.getSector().getSecodigo();
		}
		Object getCensoMonitorMocodigoAux = null;
		if (hechodenunciado.getCensoMonitor() != null && hechodenunciado.getCensoMonitor().getMocodigo() != null) {
			getCensoMonitorMocodigoAux = hechodenunciado.getCensoMonitor().getMocodigo();
		}
		Object getProductoPscodigoAux = null;
		if (hechodenunciado.getProducto() != null && hechodenunciado.getProducto().getPscodigo() != null) {
			getProductoPscodigoAux = hechodenunciado.getProducto().getPscodigo();
		}
		Object getTipoReclamacionTsrcodigoAux = null;
		if (hechodenunciado.getTipoReclamacion() != null
				&& hechodenunciado.getTipoReclamacion().getTsrcodigo() != null) {
			getTipoReclamacionTsrcodigoAux = hechodenunciado.getTipoReclamacion().getTsrcodigo();
		}
		Object getMotivoTircodigoAux = null;
		if (hechodenunciado.getMotivo() != null && hechodenunciado.getMotivo().getTircodigo() != null) {
			getMotivoTircodigoAux = hechodenunciado.getMotivo().getTircodigo();
		}
		this.jdbcTemplate.update(query, hechodenunciado.getHdcodigo(), getDenunciaDecodigoAux,
				getEstablecimientoEscodigoAux, getSectorSecodigoAux, getCensoMonitorMocodigoAux, getProductoPscodigoAux,
				getTipoReclamacionTsrcodigoAux, getMotivoTircodigoAux, hechodenunciado.getHdnror(),
				hechodenunciado.getHdte(), hechodenunciado.getHdtedoad(), hechodenunciado.getHdcoav(),
				hechodenunciado.getHdnops(), hechodenunciado.getHdnomaps(), hechodenunciado.getHdnomops(),
				hechodenunciado.getHdnrlops(), hechodenunciado.getHdfedmps(), hechodenunciado.getHdinsotr(),
				hechodenunciado.getHdinsoma(), hechodenunciado.getHdcaptso(), hechodenunciado.getHdteso(),
				hechodenunciado.getHdfeardt(), hechodenunciado.getHdfeiohd(), hechodenunciado.getHdininin(),
				hechodenunciado.getHdfeiopc(), hechodenunciado.getHdferopc(), hechodenunciado.getHdcorepc(),
				hechodenunciado.getHdfeiorp(), hechodenunciado.getHdferorp(), hechodenunciado.getHdcoreap(),
				hechodenunciado.getHdfeiora(), hechodenunciado.getHdteacpa(), hechodenunciado.getHdfeceac(),
				hechodenunciado.getHdhoceac(), hechodenunciado.getHdfeioca(), hechodenunciado.getHdteacde(),
				hechodenunciado.getHdfeioac(), hechodenunciado.getHdfeiofc(), hechodenunciado.getHdcotra(),
				hechodenunciado.getHdte02(), hechodenunciado.getHdte03(), hechodenunciado.getHdte04(),
				hechodenunciado.getHdte05(), hechodenunciado.getHdte06(), hechodenunciado.getHdte07(),
				hechodenunciado.getHdte08(), hechodenunciado.getHdte09(), hechodenunciado.getHdte10(),
				hechodenunciado.getHdcosc(), hechodenunciado.getHdidal(), hechodenunciado.getHdferoad(),
				hechodenunciado.getHdferoat(), hechodenunciado.getHdtealdt(), hechodenunciado.getHdtedeat(),
				hechodenunciado.getHdfedeat(), hechodenunciado.getHdfehd(), hechodenunciado.getHdtedoade(),
				hechodenunciado.getHdtedoadi(), hechodenunciado.getHdtedoadf(), hechodenunciado.getHdtedoada(),
				hechodenunciado.getHdnopse(), hechodenunciado.getHdnopsi(), hechodenunciado.getHdnopsf(),
				hechodenunciado.getHdnopsa(), hechodenunciado.getHdcocodigo());
		return hechodenunciado;
	}

	/**
	 * Inserts a single row in the HechoDenunciado table.
	 * 
	 * @param hechodenunciado
	 *            Pagination
	 * @return HechoDenunciado
	 */
	public HechoDenunciado addHechoDenunciado(HechoDenunciado hechodenunciado) {

		String query = "INSERT INTO HECHO_DENUNCIADO( HDCODIGO,HDCODE,HDCOES,HDCOSE,HDCOMO,HDCOPS,HDCOTSR,HDCOTIR,HDNROR,HDTE,HDTEDOAD,HDCOAV,HDNOPS,HDNOMAPS,HDNOMOPS,HDNRLOPS,HDFEDMPS,HDINSOTR,HDINSOMA,HDCAPTSO,HDTESO,HDFEARDT,HDFEIOHD,HDINININ,HDFEIOPC,HDFEROPC,HDCOREPC,HDFEIORP,HDFERORP,HDCOREAP,HDFEIORA,HDTEACPA,HDFECEAC,HDHOCEAC,HDFEIOCA,HDTEACDE,HDFEIOAC,HDFEIOFC,HDCOTRA,HDTE02,HDTE03,HDTE04,HDTE05,HDTE06,HDTE07,HDTE08,HDTE09,HDTE10,HDCOSC,HDIDAL,HDFEROAD,HDFEROAT,HDTEALDT,HDTEDEAT,HDFEDEAT,HDFEHD,HDTEDOADE,HDTEDOADI,HDTEDOADF,HDTEDOADA,HDNOPSE,HDNOPSI,HDNOPSF,HDNOPSA,HDCOCODIGO,ISKONTSUMOBIDE,HDFORMANOTIFICACION,HDFORMANOTIFESTABLECIMIENTO,HDCODEXPEDIENTEORIGEN,HDNUMREGISTROENTRADA,HDIDIOMA,HDNUMREGISTROORIGEN,HDFECHAREGISTROORIGEN,HDFORMAVENTA,HDFORMAVENTATELEMATICA,HDCODIGOBARRAS,HDINTERESADO,HDDENUNCIAAACCEMPRESAS,HDTIPODENUNCIANTE, HDIDIOMARECLAMADO, HDPARTICIPACIONRECLAMADO, HDDESTNOTIFICARECLAMANTE, HDDESTNOTIFICARECLAMADO, ISTELEMATICO, HDESNOMBRETELEMATICO, HDESDIRECCIONTELEMATICO, ISSIR, ARSOLICITANTE, ARRESUMEN)"
				+ "VALUES (?,?,?,?,?,?,?,?,(SELECT NVL(MAX(ABS(HDNROR)),0)+1 FROM HECHO_DENUNCIADO WHERE HDCODE =?),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

		Object getDenunciaDecodigoAux = null;
		if (hechodenunciado.getDenuncia() != null && hechodenunciado.getDenuncia().getDecodigo() != null) {
			getDenunciaDecodigoAux = hechodenunciado.getDenuncia().getDecodigo();
		}
		Object getEstablecimientoEscodigoAux = null;
		if (hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEscodigo() != null) {
			getEstablecimientoEscodigoAux = hechodenunciado.getEstablecimiento().getEscodigo();
		}
		Object getSectorSecodigoAux = null;
		if (hechodenunciado.getSector() != null && hechodenunciado.getSector().getSecodigo() != null) {
			getSectorSecodigoAux = hechodenunciado.getSector().getSecodigo();
		}
		Object getCensoMonitorMocodigoAux = null;
		if (hechodenunciado.getCensoMonitor() != null && hechodenunciado.getCensoMonitor().getMocodigo() != null) {
			getCensoMonitorMocodigoAux = hechodenunciado.getCensoMonitor().getMocodigo();
		}
		Object getProductoPscodigoAux = null;
		if (hechodenunciado.getProducto() != null && hechodenunciado.getProducto().getPscodigo() != null) {
			getProductoPscodigoAux = hechodenunciado.getProducto().getPscodigo();
		}
		Object getTipoReclamacionTsrcodigoAux = null;
		if (hechodenunciado.getTipoReclamacion() != null
				&& hechodenunciado.getTipoReclamacion().getTsrcodigo() != null) {
			getTipoReclamacionTsrcodigoAux = hechodenunciado.getTipoReclamacion().getTsrcodigo();
		}
		Object getMotivoTircodigoAux = null;
		if (hechodenunciado.getMotivo() != null && hechodenunciado.getMotivo().getTircodigo() != null) {
			getMotivoTircodigoAux = hechodenunciado.getMotivo().getTircodigo();
		}
		this.jdbcTemplate.update(query, hechodenunciado.getHdcodigo(), getDenunciaDecodigoAux,
				getEstablecimientoEscodigoAux, getSectorSecodigoAux, getCensoMonitorMocodigoAux, getProductoPscodigoAux,
				getTipoReclamacionTsrcodigoAux, getMotivoTircodigoAux, getDenunciaDecodigoAux,
				hechodenunciado.getHdte(), hechodenunciado.getHdtedoad(), hechodenunciado.getHdcoav(),
				hechodenunciado.getHdnops(), hechodenunciado.getHdnomaps(), hechodenunciado.getHdnomops(),
				hechodenunciado.getHdnrlops(), hechodenunciado.getHdfedmps(), hechodenunciado.getHdinsotr(),
				hechodenunciado.getHdinsoma(), hechodenunciado.getHdcaptso(), hechodenunciado.getHdteso(),
				hechodenunciado.getHdfeardt(), hechodenunciado.getHdfeiohd(), hechodenunciado.getHdininin(),
				hechodenunciado.getHdfeiopc(), hechodenunciado.getHdferopc(), hechodenunciado.getHdcorepc(),
				hechodenunciado.getHdfeiorp(), hechodenunciado.getHdferorp(), hechodenunciado.getHdcoreap(),
				hechodenunciado.getHdfeiora(), hechodenunciado.getHdteacpa(), hechodenunciado.getHdfeceac(),
				hechodenunciado.getHdhoceac(), hechodenunciado.getHdfeioca(), hechodenunciado.getHdteacde(),
				hechodenunciado.getHdfeioac(), hechodenunciado.getHdfeiofc(), hechodenunciado.getHdcotra(),
				hechodenunciado.getHdte02(), hechodenunciado.getHdte03(), hechodenunciado.getHdte04(),
				hechodenunciado.getHdte05(), hechodenunciado.getHdte06(), hechodenunciado.getHdte07(),
				hechodenunciado.getHdte08(), hechodenunciado.getHdte09(), hechodenunciado.getHdte10(),
				hechodenunciado.getHdcosc(), hechodenunciado.getHdidal(), hechodenunciado.getHdferoad(),
				hechodenunciado.getHdferoat(), hechodenunciado.getHdtealdt(), hechodenunciado.getHdtedeat(),
				hechodenunciado.getHdfedeat(), hechodenunciado.getHdfehd(), hechodenunciado.getHdtedoade(),
				hechodenunciado.getHdtedoadi(), hechodenunciado.getHdtedoadf(), hechodenunciado.getHdtedoada(),
				hechodenunciado.getHdnopse(), hechodenunciado.getHdnopsi(), hechodenunciado.getHdnopsf(),
				hechodenunciado.getHdnopsa(), hechodenunciado.getHdcocodigo(), hechodenunciado.getIskontsumobide(),
				hechodenunciado.getHdformanotificacion(), hechodenunciado.getHdformanotificacionestablecimiento(),
				hechodenunciado.getHdcodexpedienteorigen(), hechodenunciado.getNumregistroentrada(),
				hechodenunciado.getHdidioma(), hechodenunciado.getHdnumregistroentradaorigen(),
				hechodenunciado.getHdfecharegistroorigen(), hechodenunciado.getHdformaventa(),
				hechodenunciado.getHdformaventatelematica(), hechodenunciado.getHdcodigobarras(),
				hechodenunciado.getHdinteresado(), hechodenunciado.getHddenunciaaaccempresas(),
				hechodenunciado.getHdtipodenunciante(), hechodenunciado.getHdidiomareclamado(),
				hechodenunciado.getHdparticipacionreclamado(), hechodenunciado.getHddestnotificareclamante(),
				hechodenunciado.getHddestnotificareclamado(), hechodenunciado.getIstelematico(),
				hechodenunciado.getHdesnombretelematico(), hechodenunciado.getHdesdirecciontelematico(),
				hechodenunciado.getIsSir(), hechodenunciado.getArSolicitante(), hechodenunciado.getArResumen());
		return hechodenunciado;
	}

	/**
	 * Inserts a single row in the Denuncia table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 */
	public void enviarHechoDenunciadoTelematico(SolicitudDetalle solicitudDetalle) {

		String query = "INSERT INTO HECHO_DENUNCIADO( HDCODIGO,HDCODE,HDCOES,HDCOSE,HDCOMO,HDCOPS,HDCOTSR,HDCOTIR,HDNROR,HDTEDOAD,HDCOAV,HDNOPS,HDNOMAPS,HDNOMOPS,HDNRLOPS,HDFEDMPS,HDINSOTR,HDINSOMA,HDCAPTSO,HDTESO,HDFEARDT,HDFEIOHD,HDINININ,HDFEIOPC,HDFEROPC,HDCOREPC,HDFEIORP,HDFERORP,HDCOREAP,HDFEIORA,HDTEACPA,HDFECEAC,HDHOCEAC,HDFEIOCA,HDTEACDE,HDFEIOAC,HDFEIOFC,HDCOTRA,HDTE02,HDTE03,HDTE04,HDTE05,HDTE06,HDTE07,HDTE08,HDTE09,HDTE10,HDCOSC,HDIDAL,HDFEROAD,HDFEROAT,HDTEALDT,HDTEDEAT,HDFEDEAT,HDFEHD,HDTEDOADE,HDTEDOADI,HDTEDOADF,HDTEDOADA,HDNOPSE,HDNOPSI,HDNOPSF,HDNOPSA,HDCOCODIGO,ISKONTSUMOBIDE,HDFORMANOTIFICACION,HDCODEXPEDIENTEORIGEN,HDNUMREGISTROENTRADA,HDESNOMBRETELEMATICO,HDESDIRECCIONTELEMATICO,ISTELEMATICO,HDIDIOMA,HDFORMAVENTA) SELECT HDCODIGO,HDCODE,HDCOES,HDCOSE,HDCOMO,HDCOPS,HDCOTSR,HDCOTIR,HDNROR,HDTEDOAD,HDCOAV,HDNOPS,HDNOMAPS,HDNOMOPS,HDNRLOPS,HDFEDMPS,HDINSOTR,HDINSOMA,HDCAPTSO,HDTESO,HDFEARDT,HDFEIOHD,HDINININ,HDFEIOPC,HDFEROPC,HDCOREPC,HDFEIORP,HDFERORP,HDCOREAP,HDFEIORA,HDTEACPA,HDFECEAC,HDHOCEAC,HDFEIOCA,HDTEACDE,HDFEIOAC,HDFEIOFC,HDCOTRA,HDTE02,HDTE03,HDTE04,HDTE05,HDTE06,HDTE07,HDTE08,HDTE09,HDTE10,HDCOSC,HDIDAL,HDFEROAD,HDFEROAT,HDTEALDT,HDTEDEAT,HDFEDEAT,HDFEHD,HDTEDOADE,HDTEDOADI,HDTEDOADF,HDTEDOADA,HDNOPSE,HDNOPSI,HDNOPSF,HDNOPSA,HDCOCODIGO,ISKONTSUMOBIDE,HDFORMANOTIFICACION,HDCODEXPEDIENTEORIGEN,HDNUMREGISTROENTRADA,HDESNOMBRETELEMATICO,HDESDIRECCIONTELEMATICO,ISTELEMATICO,HDIDIOMA,HDFORMAVENTA FROM HECHO_TELE WHERE HDNUMREGISTROENTRADA = ?";
		this.jdbcTemplate.update(query, solicitudDetalle.getNumregistroentrada());
	}

	/**
	 * Removes a single row in the Denuncia table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @return
	 */
	public void removeHechoDenunciadoTelematico(SolicitudDetalle solicitudDetalle) {
		String query = "DELETE  FROM HECHO_TELE WHERE HDCODIGO=?";
		this.jdbcTemplate.update(query, solicitudDetalle.getHdcodigo());
	}

	/**
	 * Finds a single row in the HechoDenunciado table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @return SolicitudDetalle
	 */
	public SolicitudDetalle findLobTablaTemporalTelematica(SolicitudDetalle solicitudDetalle) {
		String query = "SELECT HDCODIGO, HDTE " + "FROM HECHO_TELE  " + "WHERE HDNUMREGISTROENTRADA = ? ";
		return (SolicitudDetalle) this.jdbcTemplate.queryForObject(query, new RowMapper<SolicitudDetalle>() {
			public SolicitudDetalle mapRow(ResultSet resultSet, int rowNum) throws SQLException {
				return new SolicitudDetalle(resultSet.getString("HDCODIGO"), resultSet.getString("HDTE"));
			}
		}, solicitudDetalle.getNumregistroentrada());
	}

	/**
	 * Updates a single row in the HechoDenunciado table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @return SolicitudDetalle
	 */
	public SolicitudDetalle updateHDTE(SolicitudDetalle solicitudDetalle) {
		String query = "UPDATE HECHO_DENUNCIADO SET HDTE=? WHERE HDCODIGO=?";

		this.jdbcTemplate.update(query, solicitudDetalle.getHdte(), solicitudDetalle.getHdcodigo());
		return solicitudDetalle;
	}

	/**
	 * Updates a single row in the HechoDenunciado table.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @return Intervinientes
	 */
	public Intervinientes updateHDIDPARTICIPACIONRECLAMANTE(Intervinientes intervinientes) {
		String query = "UPDATE HECHO_DENUNCIADO SET HDIDPARTICIPACIONRECLAMANTE=? WHERE HDCODIGO=?";

		this.jdbcTemplate.update(query, intervinientes.getNif(), intervinientes.getIdExpediente());
		return intervinientes;
	}

	/**
	 * Updates a single row in the HechoDenunciado table.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @return Intervinientes
	 */
	public Intervinientes updateHDIDPARTICIPACIONRECLAMADO(Intervinientes intervinientes) {
		String query = "UPDATE HECHO_DENUNCIADO SET HDIDPARTICIPACIONRECLAMADO=? WHERE HDCODIGO=?";

		this.jdbcTemplate.update(query, intervinientes.getNif(), intervinientes.getIdExpediente());
		return intervinientes;
	}

	/**
	 * Updates a single row in the HechoDenunciado table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @return SolicitudDetalle
	 */
	public SolicitudDetalle updateFechaCierre(SolicitudDetalle solicitudDetalle) {
		String query = "UPDATE HECHO_DENUNCIADO SET HDFECHACIERRE=SYSDATE WHERE HDCODIGO=?";

		this.jdbcTemplate.update(query, solicitudDetalle.getHdcodigo());
		return solicitudDetalle;
	}

	/**
	 * Updates a single row in the HechoDenunciado table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @return SolicitudDetalle
	 */
	public SolicitudDetalle updateDenunciaAACC(SolicitudDetalle solicitudDetalle) {
		String query = "UPDATE HECHO_DENUNCIADO SET HDDENUNCIAAACCEMPRESAS=?,HDTIPODENUNCIANTE=?, HDCOSC=? WHERE HDCODIGO=?";

		this.jdbcTemplate.update(query, Y41bConstantes.SI, Y41bConstantes.SOLICITUDES_TIPO_DENUNCIA_EMPRESAS,
				Y41bConstantes.TIPO_DENUNCIA, solicitudDetalle.getHdcodigo());
		return solicitudDetalle;
	}

	/**
	 * Updates a single row in the HechoDenunciado table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @return SolicitudDetalle
	 */
	public SolicitudDetalle updateDenunciaAACCEnSolicitud(SolicitudDetalle solicitudDetalle) {
		String query = "UPDATE HECHO_DENUNCIADO SET HDDENUNCIAAACCEMPRESAS=?,HDTIPODENUNCIANTE=? WHERE HDCODIGO=?";

		this.jdbcTemplate.update(query, null, null, solicitudDetalle.getHdcodigo());
		return solicitudDetalle;
	}

	/**
	 * Updates a single row in the HechoDenunciado table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @return SolicitudDetalle
	 */
	public SolicitudDetalle updateFechaCierreReabrirExpediente(SolicitudDetalle solicitudDetalle) {
		String query = "UPDATE HECHO_DENUNCIADO SET HDFECHACIERRE=null WHERE HDCODIGO=?";

		this.jdbcTemplate.update(query, solicitudDetalle.getHdcodigo());
		return solicitudDetalle;
	}

	/**
	 * Updates a single row in the HechoDenunciado table.
	 * 
	 * @param hechodenunciado
	 *            Pagination
	 * @return HechoDenunciado
	 */
	public HechoDenunciado update(HechoDenunciado hechodenunciado) {
		String query = "UPDATE HECHO_DENUNCIADO SET HDCODE=?,HDCOES=?,HDCOSE=?,HDCOPS=?,HDCOTSR=?,HDCOTIR=?,HDNROR=?,HDTE=?,HDTEDOAD=?,HDCOAV=?,HDNOPS=?,HDNOMAPS=?,HDNOMOPS=?,HDNRLOPS=?,HDFEDMPS=?,HDINSOTR=?,HDINSOMA=?,HDCAPTSO=?,HDTESO=?,HDFEARDT=?,HDFEIOHD=?,HDINININ=?,HDFEIOPC=?,HDFEROPC=?,HDCOREPC=?,HDFEIORP=?,HDFERORP=?,HDCOREAP=?,HDFEIORA=?,HDTEACPA=?,HDFECEAC=?,HDHOCEAC=?,HDFEIOCA=?,HDTEACDE=?,HDFEIOAC=?,HDFEIOFC=?,HDCOTRA=?,HDTE02=?,HDTE03=?,HDTE04=?,HDTE05=?,HDTE06=?,HDTE07=?,HDTE08=?,HDTE09=?,HDTE10=?,HDCOSC=?,HDIDAL=?,HDFEROAD=?,HDFEROAT=?,HDTEALDT=?,HDTEDEAT=?,HDFEDEAT=?,HDFEHD=?,HDTEDOADE=?,HDTEDOADI=?,HDTEDOADF=?,HDTEDOADA=?,HDNOPSE=?,HDNOPSI=?,HDNOPSF=?,HDNOPSA=?,HDCOCODIGO=?,HDFORMANOTIFICACION=?,HDFORMANOTIFESTABLECIMIENTO=?,HDCODEXPEDIENTEORIGEN=?,HDNUMREGISTROENTRADA=?,HDIDIOMA=?,HDNUMREGISTROORIGEN=?,HDFECHAREGISTROORIGEN=?,HDFORMAVENTA=?,HDCODIGOBARRAS=?,HDINTERESADO=?,HDTIPODENUNCIANTE=?, HDIDIOMARECLAMADO=?, HDDESTNOTIFICARECLAMANTE=?, HDDESTNOTIFICARECLAMADO=? WHERE HDCODIGO=?";
		Object getDenunciaDecodigoAux = null;
		if (hechodenunciado.getDenuncia() != null && hechodenunciado.getDenuncia().getDecodigo() != null) {
			getDenunciaDecodigoAux = hechodenunciado.getDenuncia().getDecodigo();
		}
		Object getEstablecimientoEscodigoAux = null;
		if (hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEscodigo() != null) {
			getEstablecimientoEscodigoAux = hechodenunciado.getEstablecimiento().getEscodigo();
		}
		Object getSectorSecodigoAux = null;
		if (hechodenunciado.getSector() != null && hechodenunciado.getSector().getSecodigo() != null) {
			getSectorSecodigoAux = hechodenunciado.getSector().getSecodigo();
		}
		Object getProductoPscodigoAux = null;
		if (hechodenunciado.getProducto() != null && hechodenunciado.getProducto().getPscodigo() != null) {
			getProductoPscodigoAux = hechodenunciado.getProducto().getPscodigo();
		}
		Object getTipoReclamacionTsrcodigoAux = null;
		if (hechodenunciado.getTipoReclamacion() != null
				&& hechodenunciado.getTipoReclamacion().getTsrcodigo() != null) {
			getTipoReclamacionTsrcodigoAux = hechodenunciado.getTipoReclamacion().getTsrcodigo();
		}
		Object getMotivoTircodigoAux = null;
		if (hechodenunciado.getMotivo() != null && hechodenunciado.getMotivo().getTircodigo() != null) {
			getMotivoTircodigoAux = hechodenunciado.getMotivo().getTircodigo();
		}
		this.jdbcTemplate.update(query, getDenunciaDecodigoAux, getEstablecimientoEscodigoAux, getSectorSecodigoAux,
				getProductoPscodigoAux, getTipoReclamacionTsrcodigoAux, getMotivoTircodigoAux,
				hechodenunciado.getHdnror(), hechodenunciado.getHdte(), hechodenunciado.getHdtedoad(),
				hechodenunciado.getHdcoav(), hechodenunciado.getHdnops(), hechodenunciado.getHdnomaps(),
				hechodenunciado.getHdnomops(), hechodenunciado.getHdnrlops(), hechodenunciado.getHdfedmps(),
				hechodenunciado.getHdinsotr(), hechodenunciado.getHdinsoma(), hechodenunciado.getHdcaptso(),
				hechodenunciado.getHdteso(), hechodenunciado.getHdfeardt(), hechodenunciado.getHdfeiohd(),
				hechodenunciado.getHdininin(), hechodenunciado.getHdfeiopc(), hechodenunciado.getHdferopc(),
				hechodenunciado.getHdcorepc(), hechodenunciado.getHdfeiorp(), hechodenunciado.getHdferorp(),
				hechodenunciado.getHdcoreap(), hechodenunciado.getHdfeiora(), hechodenunciado.getHdteacpa(),
				hechodenunciado.getHdfeceac(), hechodenunciado.getHdhoceac(), hechodenunciado.getHdfeioca(),
				hechodenunciado.getHdteacde(), hechodenunciado.getHdfeioac(), hechodenunciado.getHdfeiofc(),
				hechodenunciado.getHdcotra(), hechodenunciado.getHdte02(), hechodenunciado.getHdte03(),
				hechodenunciado.getHdte04(), hechodenunciado.getHdte05(), hechodenunciado.getHdte06(),
				hechodenunciado.getHdte07(), hechodenunciado.getHdte08(), hechodenunciado.getHdte09(),
				hechodenunciado.getHdte10(), hechodenunciado.getHdcosc(), hechodenunciado.getHdidal(),
				hechodenunciado.getHdferoad(), hechodenunciado.getHdferoat(), hechodenunciado.getHdtealdt(),
				hechodenunciado.getHdtedeat(), hechodenunciado.getHdfedeat(), hechodenunciado.getHdfehd(),
				hechodenunciado.getHdtedoade(), hechodenunciado.getHdtedoadi(), hechodenunciado.getHdtedoadf(),
				hechodenunciado.getHdtedoada(), hechodenunciado.getHdnopse(), hechodenunciado.getHdnopsi(),
				hechodenunciado.getHdnopsf(), hechodenunciado.getHdnopsa(), hechodenunciado.getHdcocodigo(),
				hechodenunciado.getHdformanotificacion(), hechodenunciado.getHdformanotificacionestablecimiento(),
				hechodenunciado.getHdcodexpedienteorigen(), hechodenunciado.getNumregistroentrada(),
				hechodenunciado.getHdidioma(), hechodenunciado.getHdnumregistroentradaorigen(),
				hechodenunciado.getHdfecharegistroorigen(), hechodenunciado.getHdformaventa(),
				hechodenunciado.getHdcodigobarras(), hechodenunciado.getHdinteresado(),
				hechodenunciado.getHdtipodenunciante(), hechodenunciado.getHdidiomareclamado(),
				hechodenunciado.getHddestnotificareclamante(), hechodenunciado.getHddestnotificareclamado(),
				hechodenunciado.getHdcodigo());
		return hechodenunciado;
	}

	/**
	 * Updates a single row in the HechoDenunciado table.
	 * 
	 * @param hechodenunciado
	 *            Pagination
	 * @return HechoDenunciado
	 */
	public HechoDenunciado updateEstablecimiento(HechoDenunciado hechodenunciado) {
		String query = "UPDATE HECHO_DENUNCIADO SET HDCOES=? WHERE HDCODIGO=?";
		Object getEstablecimientoEscodigoAux = null;
		if (hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEscodigo() != null) {
			getEstablecimientoEscodigoAux = hechodenunciado.getEstablecimiento().getEscodigo();
		}
		this.jdbcTemplate.update(query, getEstablecimientoEscodigoAux, hechodenunciado.getHdcodigo());
		return hechodenunciado;
	}

	/**
	 * Updates a single row in the HechoDenunciado table.
	 * 
	 * @param hechodenunciado
	 *            Pagination
	 * @return HechoDenunciado
	 */
	public HechoDenunciado updateIndicadorArbitraje(HechoDenunciado hechodenunciado) {
		String query = "UPDATE HECHO_DENUNCIADO SET HDINSOMA=? WHERE HDCODIGO=?";

		this.jdbcTemplate.update(query, hechodenunciado.getHdinsoma(), hechodenunciado.getHdcodigo());
		return hechodenunciado;
	}

	/**
	 * Updates a single row in the HechoDenunciado table.
	 * 
	 * @param hechodenunciado
	 *            Pagination
	 * @return HechoDenunciado
	 */
	public HechoDenunciado updateTramiteCambioInstructor(HechoDenunciado hechodenunciado) {
		String query = "UPDATE HECHO_DENUNCIADO SET HDCOSC=?,HDCOMO=? WHERE HDCODIGO=?";

		this.jdbcTemplate.update(query, hechodenunciado.getHdcosc(), hechodenunciado.getCensoMonitor().getMocodigo(),
				hechodenunciado.getHdcodigo());
		return hechodenunciado;
	}

	/**
	 * Updates a single row in the HechoDenunciado table.
	 * 
	 * @param hechodenunciado
	 *            Pagination
	 * @return HechoDenunciado
	 */
	public HechoDenunciado updateNumregistroEntrada(HechoDenunciado hechodenunciado) {
		String query = "UPDATE HECHO_DENUNCIADO SET HDNUMREGISTROENTRADA=? WHERE HDCODIGO=?";

		this.jdbcTemplate.update(query, hechodenunciado.getNumregistroentrada(), hechodenunciado.getHdcodigo());
		return hechodenunciado;
	}

	/**
	 * Updates a single row in the HechoDenunciado table.
	 * 
	 * @param hechodenunciado
	 *            Pagination
	 * @return HechoDenunciado
	 */
	public HechoDenunciado updateInstructor(HechoDenunciado hechodenunciado) {
		String query = "UPDATE HECHO_DENUNCIADO SET HDCOMO=? WHERE HDCODIGO=?";

		this.jdbcTemplate.update(query, hechodenunciado.getCensoMonitor().getMocodigo(), hechodenunciado.getHdcodigo());
		return hechodenunciado;
	}

	/**
	 * Updates a single row in the HechoDenunciado table.
	 * 
	 * @param hechodenunciado
	 *            Pagination
	 * @return HechoDenunciado
	 */
	public HechoDenunciado updateFormaNotificacion(HechoDenunciado hechodenunciado) {
		String query = "UPDATE HECHO_DENUNCIADO SET HDFORMANOTIFICACION=? WHERE HDCODIGO=?";

		this.jdbcTemplate.update(query, hechodenunciado.getHdformanotificacion(), hechodenunciado.getHdcodigo());
		return hechodenunciado;
	}

	/**
	 * Updates a single row in the HechoDenunciado table.
	 * 
	 * @param hechodenunciado
	 *            Pagination
	 * @return HechoDenunciado
	 */
	public HechoDenunciado updateIdiomaReclamante(HechoDenunciado hechodenunciado) {
		String query = "UPDATE HECHO_DENUNCIADO SET HDIDIOMA=? WHERE HDCODIGO=?";

		this.jdbcTemplate.update(query, hechodenunciado.getHdidioma(), hechodenunciado.getHdcodigo());
		return hechodenunciado;
	}

	/**
	 * Updates a single row in the HechoDenunciado table.
	 * 
	 * @param hechodenunciado
	 *            Pagination
	 * @return HechoDenunciado
	 */
	public HechoDenunciado updateIdiomaReclamado(HechoDenunciado hechodenunciado) {
		String query = "UPDATE HECHO_DENUNCIADO SET HDIDIOMARECLAMADO=? WHERE HDCODIGO=?";

		this.jdbcTemplate.update(query, hechodenunciado.getHdidiomareclamado(), hechodenunciado.getHdcodigo());
		return hechodenunciado;
	}

	/**
	 * Updates a single row in the HechoDenunciado table.
	 * 
	 * @param hechodenunciado
	 *            Pagination
	 * @return HechoDenunciado
	 */
	public HechoDenunciado updateUltimoTramiteConFase(HechoDenunciado hechodenunciado) {
		String query = "UPDATE HECHO_DENUNCIADO SET FCODIGOACTUAL=?,TRCODIGOACTUAL=?,TRPOSIBLECODIGO=? WHERE HDCODIGO=?";

		this.jdbcTemplate.update(query, hechodenunciado.getFcodigoactual(), hechodenunciado.getTrcodigoactual(),
				hechodenunciado.getTrposiblecodigo(), hechodenunciado.getHdcodigo());
		return hechodenunciado;
	}

	/**
	 * Updates a single row in the HechoDenunciado table.
	 * 
	 * @param hechodenunciado
	 *            Pagination
	 * @return HechoDenunciado
	 */
	public HechoDenunciado updateUltimoTramiteGenerico(HechoDenunciado hechodenunciado) {
		String query = "UPDATE HECHO_DENUNCIADO SET TRCODIGOACTUAL=? WHERE HDCODIGO=?";

		this.jdbcTemplate.update(query, hechodenunciado.getTrcodigoactual(), hechodenunciado.getHdcodigo());
		return hechodenunciado;
	}

	/**
	 * Updates a single row in the HechoDenunciado table.
	 * 
	 * @param hechodenunciado
	 *            Pagination
	 * @return HechoDenunciado
	 */
	public HechoDenunciado updateUltimoTramiteConFaseGenerico(HechoDenunciado hechodenunciado) {
		String query = "UPDATE HECHO_DENUNCIADO SET FCODIGOACTUAL=?,TRCODIGOACTUAL=? WHERE HDCODIGO=?";

		this.jdbcTemplate.update(query, hechodenunciado.getFcodigoactual(), hechodenunciado.getTrcodigoactual(),
				hechodenunciado.getHdcodigo());
		return hechodenunciado;
	}

	/**
	 * Updates a single row in the HechoDenunciado table.
	 * 
	 * @param hechodenunciado
	 *            Pagination
	 * @return HechoDenunciado
	 */
	public HechoDenunciado updateTramitacionTramitePosible(HechoDenunciado hechodenunciado) {
		String query = "UPDATE HECHO_DENUNCIADO SET TRPOSIBLECODIGO=? WHERE HDCODIGO=?";

		this.jdbcTemplate.update(query, hechodenunciado.getTrposiblecodigo(), hechodenunciado.getHdcodigo());
		return hechodenunciado;
	}

	/**
	 * Finds a single row in the HechoDenunciado table.
	 * 
	 * @param hechodenunciado
	 *            Pagination
	 * @return HechoDenunciado
	 */
	@Transactional(readOnly = true)
	public HechoDenunciado find(HechoDenunciado hechodenunciado) {
		String query = "SELECT t1.HDCODIGO HDCODIGO, t1.HDNROR HDNROR, t1.HDTE HDTE, t1.HDTEDOAD HDTEDOAD, t1.HDCOAV HDCOAV, t1.HDNOPS HDNOPS, t1.HDNOMAPS HDNOMAPS, t1.HDNOMOPS HDNOMOPS, t1.HDNRLOPS HDNRLOPS, t1.HDCODIGOBARRAS HDCODIGOBARRAS, t1.HDINTERESADO HDINTERESADO, t1.HDFEDMPS HDFEDMPS, t1.HDINSOTR HDINSOTR, t1.HDINSOMA HDINSOMA, t1.HDCAPTSO HDCAPTSO, t1.HDTESO HDTESO, t1.HDFEARDT HDFEARDT, t1.HDFEIOHD HDFEIOHD, t1.HDINININ HDINININ, t1.HDFEIOPC HDFEIOPC, t1.HDFEROPC HDFEROPC, t1.HDCOREPC HDCOREPC, t1.HDFEIORP HDFEIORP, t1.HDFERORP HDFERORP, t1.HDCOREAP HDCOREAP, t1.HDFEIORA HDFEIORA, t1.HDTEACPA HDTEACPA, t1.HDFECEAC HDFECEAC, t1.HDHOCEAC HDHOCEAC, t1.HDFEIOCA HDFEIOCA, t1.HDTEACDE HDTEACDE, t1.HDFEIOAC HDFEIOAC, t1.HDFEIOFC HDFEIOFC, t1.HDCOTRA HDCOTRA, t1.HDTE02 HDTE02, t1.HDTE03 HDTE03, t1.HDTE04 HDTE04, t1.HDTE05 HDTE05, t1.HDTE06 HDTE06, t1.HDTE07 HDTE07, t1.HDTE08 HDTE08, t1.HDTE09 HDTE09, t1.HDTE10 HDTE10, t1.HDCOSC HDCOSC, t1.HDIDAL HDIDAL, t1.HDFEROAD HDFEROAD, t1.HDFEROAT HDFEROAT, t1.HDTEALDT HDTEALDT, t1.HDTEDEAT HDTEDEAT, t1.HDFEDEAT HDFEDEAT, t1.HDFEHD HDFEHD, t1.HDTEDOADE HDTEDOADE, t1.HDTEDOADI HDTEDOADI, t1.HDTEDOADF HDTEDOADF, t1.HDTEDOADA HDTEDOADA, t1.HDNOPSE HDNOPSE, t1.HDNOPSI HDNOPSI, t1.HDNOPSF HDNOPSF, t1.HDNOPSA HDNOPSA, t1.HDCOCODIGO HDCOCODIGO, t2.DECODIGO DENUNCIADECODIGO, t2.DECOCP DENUNCIADECOCP, t2.DECOOR DENUNCIADECOOR, t2.DENRAN DENUNCIADENRAN, t2.DENROR DENUNCIADENROR, t2.DEFEDE DENUNCIADEFEDE, t2.DEFERE DENUNCIADEFERE, t2.DEFEEX DENUNCIADEFEEX, t2.DEFEIM DENUNCIADEFEIM, t2.DEINRE DENUNCIADEINRE, t2.DENRRGEN DENUNCIADENRRGEN, t3.ESCODIGO ESTABLECIMIENTOESCODIGO, t3.ESNOMBRE ESTABLECIMIENTOESNOMBRE, t3.ESTIPID ESTABLECIMIENTOESTIPID, t3.ESNIF ESTABLECIMIENTOESNIF, t3.ESNOAN ESTABLECIMIENTOESNOAN, t3.ESNOCO ESTABLECIMIENTOESNOCO, t3.ESNODIR ESTABLECIMIENTOESNODIR, t3.ESCOLO ESTABLECIMIENTOESCOLO, t3.ESNRCOPO ESTABLECIMIENTOESNRCOPO, t3.ESNRTEL ESTABLECIMIENTOESNRTEL, t3.ESNRFAX ESTABLECIMIENTOESNRFAX, t3.ESCOPA ESTABLECIMIENTOESCOPA, t3.ESINCAPR ESTABLECIMIENTOESINCAPR, t3.ESINDEMP ESTABLECIMIENTOESINDEMP, t3.ESTECO ESTABLECIMIENTOESTECO, t3.ESINADAR ESTABLECIMIENTOESINADAR, t3.ESFEADAR ESTABLECIMIENTOESFEADAR, t3.ESCOEM ESTABLECIMIENTOESCOEM, t3.ESINEMPR ESTABLECIMIENTOESINEMPR, t3.ESNRTEL2 ESTABLECIMIENTOESNRTEL2, t3.ESFEBA ESTABLECIMIENTOESFEBA, t3.ESNOAP1 ESTABLECIMIENTOESNOAP1, t3.ESNOAP2 ESTABLECIMIENTOESNOAP2, t3.ESNOLO ESTABLECIMIENTOESNOLO, t3.ESCOMAPV ESTABLECIMIENTOESCOMAPV, t3.ESCOCA ESTABLECIMIENTOESCOCA, t3.ESNOPECO ESTABLECIMIENTOESNOPECO, t3.ESCOIDCO ESTABLECIMIENTOESCOIDCO, t3.ESINRECO ESTABLECIMIENTOESINRECO, t3.ESFEMOD ESTABLECIMIENTOESFEMOD, t3.ESINESCO ESTABLECIMIENTOESINESCO, t3.ESNOMU ESTABLECIMIENTOESNOMU, t3.ESNOREP ESTABLECIMIENTOESNOREP, t3.ESNIFREP ESTABLECIMIENTOESNIFREP, t3.DTTEEMR ESTABLECIMIENTODTTEEMR, t3.ESCAREP ESTABLECIMIENTOESCAREP, t3.ESTEURL ESTABLECIMIENTOESTEURL, t3.ESCOOE ESTABLECIMIENTOESCOOE, t3.ESNODECO ESTABLECIMIENTOESNODECO, t3.ESINTIAR ESTABLECIMIENTOESINTIAR, t3.ESFEPLAD ESTABLECIMIENTOESFEPLAD, t3.ESINDEME ESTABLECIMIENTOESINDEME, t3.ESNORA_PAIS_ID ESTABLEESNORAPAISID, t3.ESNORA_PAIS_NOMBRE ESTABLEESNORAPAISNOMBRE, t3.ESNORA_PROVINCIA_ID ESTABLEESNORAPROVINCIAID, t3.ESNOMBRE_PROVINCIA ESTABLEESNOMBREPROVINCIA, t3.ESNORA_MUNICIPIO_ID ESTABLEESNORAMUNICIPIOID, t3.ESNOMBRE_MUNICIPIO ESTABLEESNOMBREMUNICIPIO, t3.ESNORA_LOCALIDAD_ID ESTABLEESNORALOCALIDADID, t3.ESNOMBRE_LOCALIDAD ESTABLEESNOMBRELOCALIDAD, t3.ESNORA_CALLE_ID ESTABLEESNORACALLEID, t3.ESNOMBRE_CALLE ESTABLEESNOMBRECALLE, t3.ESNORA_CP_ID ESTABLEESNORACPID, t3.ESNOMBRE_CP ESTABLEESNOMBRECP, t3.ESNORA_PORTAL_ID ESTABLEESNORAPORTALID, t3.ESNOMBRE_PORTAL ESTABLEESNOMBREPORTAL, t3.ESNOMBRE_PISO ESTABLEESNOMBREPISO, t3.ESDIRECCION_NOCAPV ESTABLEESDIRECCION_NOCAPV, t3.ESEXTRANJERO EstableESEXTRANJERO, t4.SECODIGO SECTORSECODIGO, t4.SENOMBRE SECTORSENOMBRE, t4.SENOCO SECTORSENOCO, t4.SEDESCRI SECTORSEDESCRI, t4.SECOSE SECTORSECOSE, t4.SENOCO2 SECTORSENOCO2, t4.SEINSEL1 SECTORSEINSEL1, t4.SENOMBREE SECTORSENOMBREE, t4.SENOMBREI SECTORSENOMBREI, t4.SENOMBREF SECTORSENOMBREF, t4.SENOCOE SECTORSENOCOE, t4.SENOCOI SECTORSENOCOI, t4.SENOCOF SECTORSENOCOF, t4.SEDESCRIE SECTORSEDESCRIE, t4.SEDESCRII SECTORSEDESCRII, t4.SEDESCRIF SECTORSEDESCRIF, t4.SECODGRUPO SECTORSECODGRUPO, t4.SENOMBREA SECTORSENOMBREA, t4.SEDESCRIA SECTORSEDESCRIA, t4.SENOCOA SECTORSENOCOA, t5.MOCODIGO CENSOMONITORMOCODIGO, t5.MONOMBRE CENSOMONITORMONOMBRE, t5.MOCOEM CENSOMONITORMOCOEM, t5.MODNI CENSOMONITORMODNI, t5.USUARIOXLNET CENSOMONITORUSUARIOXLNET, t5.PUESTOXLNET CENSOMONITORPUESTOXLNET, t5.MOFECBAJA CENSOMONITORMOFECBAJA, t6.PSCODIGO PRODUCTOPSCODIGO, t6.PSNOMBRE PRODUCTOPSNOMBRE, t6.PSNOCO PRODUCTOPSNOCO, t6.PSDESCRI PRODUCTOPSDESCRI, t6.PSCOSE PRODUCTOPSCOSE, t6.PSNOMBREE PRODUCTOPSNOMBREE, t6.PSNOMBREI PRODUCTOPSNOMBREI, t6.PSNOMBREF PRODUCTOPSNOMBREF, t6.PSNOMBREA PRODUCTOPSNOMBREA, t6.PSNOCOE PRODUCTOPSNOCOE, t6.PSNOCOI PRODUCTOPSNOCOI, t6.PSNOCOF PRODUCTOPSNOCOF, t6.PSNOCOA PRODUCTOPSNOCOA, t6.PSDESCRIE PRODUCTOPSDESCRIE, t6.PSDESCRII PRODUCTOPSDESCRII, t6.PSDESCRIF PRODUCTOPSDESCRIF, t6.PSDESCRIA PRODUCTOPSDESCRIA, t6.PSSEL1 PRODUCTOPSSEL1, t6.PSCOINC PRODUCTOPSCOINC, t7.TSRCODIGO TIPORECLAMACIONTSRCODIGO, t7.TSRNOMBRE TIPORECLAMACIONTSRNOMBRE, t7.TSRNOMBREE TIPORECLAMACIONTSRNOMBREE, t7.TSRNOMBREI TIPORECLAMACIONTSRNOMBREI, t7.TSRNOMBREF TIPORECLAMACIONTSRNOMBREF, t7.TSRNOMBREA TIPORECLAMACIONTSRNOMBREA, t7.TSRIMPORTE TIPORECLAMACIONTSRIMPORTE, t8.TIRCODIGO MOTIVOTIRCODIGO, t8.TIRNOMBRE MOTIVOTIRNOMBRE, t2.DECOTFP DENUNCIADECOTFP, t2.DECODT DENUNCIADECODT, t3.ESCOZS ESTABLECIMIENTOESCOZS, t4.SECOL0 SECTORSECOL0, t5.MOCOOR CENSOMONITORMOCOOR, t6.PSCOE8 PRODUCTOPSCOE8, t1.HDFORMANOTIFICACION HDFORMANOTIFICACION, t1.HDFORMANOTIFESTABLECIMIENTO HDFORMANOTIFESTABLECIMIENTO, t1.HDFORMAVENTA HDFORMAVENTA, t1.HDIDIOMA HDIDIOMA  "
				+ "FROM HECHO_DENUNCIADO t1 , DENUNCIA t2 , ESTABLECIMIENTO t3 , SECTOR t4 , CENSO_MONITOR t5 , PRODUCTO t6 , TIPO_RECLAMACION t7 , MOTIVO t8  "
				+ "WHERE t1.HDCODIGO = ?   AND t1.HDCODE= t2.DECODIGO(+) AND t1.HDCOES= t3.ESCODIGO(+) AND t1.HDCOSE= t4.SECODIGO(+) AND t1.HDCOMO= t5.MOCODIGO(+) AND t1.HDCOPS= t6.PSCODIGO(+) AND t1.HDCOTSR= t7.TSRCODIGO(+) AND t1.HDCOTIR= t8.TIRCODIGO(+)  ";
		return (HechoDenunciado) this.jdbcTemplate.queryForObject(query, rwMap, hechodenunciado.getHdcodigo());
	}

	/**
	 * Removes a single row in the HechoDenunciado table.
	 * 
	 * @param hechodenunciado
	 *            Pagination
	 * @return
	 */
	public void remove(HechoDenunciado hechodenunciado) {
		String query = "DELETE  FROM HECHO_DENUNCIADO WHERE HDCODIGO=?";
		this.jdbcTemplate.update(query, hechodenunciado.getHdcodigo());
	}

	/**
	 * Finds a List of rows in the HechoDenunciado table.
	 * 
	 * @param hechodenunciado
	 *            HechoDenunciado
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<HechoDenunciado> findAllHechosEstablecimiento(HechoDenunciado hechodenunciado, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.HDCOES= t2.ESCODIGO(+)	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.HDCODIGO HDCODIGO " + "FROM HECHO_DENUNCIADO t1, ESTABLECIMIENTO t2");

		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEscodigo() != null) {
			where.append(" AND t2.ESCODIGO = ?");
			params.add(hechodenunciado.getEstablecimiento().getEscodigo());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		}
		return (List<HechoDenunciado>) this.jdbcTemplate.query(query.toString(), new RowMapper<HechoDenunciado>() {
			public HechoDenunciado mapRow(ResultSet resultSet, int rowNum) throws SQLException {
				return new HechoDenunciado(resultSet.getString("HDCODIGO"), null, null, null, null, null, null, null,
						null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
						null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
						null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
						null, null, null, null, null, null, null, null, null, null, null, null, new Establecimiento(),
						null, null, null, null, null);
			}
		}, params.toArray());
	}

	/**
	 * Finds a List of rows in the HechoDenunciado table.
	 * 
	 * @param hechodenunciado
	 *            HechoDenunciado
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<HechoDenunciado> findAll(HechoDenunciado hechodenunciado, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(
				" WHERE 1=1 AND t1.HDCODE= t2.DECODIGO(+) AND t1.HDCOES= t3.ESCODIGO(+) AND t1.HDCOSE= t4.SECODIGO(+) AND t1.HDCOMO= t5.MOCODIGO(+) AND t1.HDCOPS= t6.PSCODIGO(+) AND t1.HDCOTSR= t7.TSRCODIGO(+) AND t1.HDCOTIR= t8.TIRCODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				// Campo HDTE devuelto como blanco por error con LONG y DBLINK
				// "SELECT t1.HDCODIGO HDCODIGO,t1.HDNROR HDNROR,t1.HDTE
				// HDTE,t1.HDTEDOAD HDTEDOAD,t1.HDCOAV HDCOAV,t1.HDNOPS
				// HDNOPS,t1.HDNOMAPS HDNOMAPS,t1.HDNOMOPS HDNOMOPS,t1.HDNRLOPS
				// HDNRLOPS, t1.HDCODIGOBARRAS HDCODIGOBARRAS, t1.HDINTERESADO
				// HDINTERESADO,t1.HDFEDMPS HDFEDMPS,t1.HDINSOTR
				// HDINSOTR,t1.HDINSOMA HDINSOMA,t1.HDCAPTSO HDCAPTSO,t1.HDTESO
				// HDTESO,t1.HDFEARDT HDFEARDT,t1.HDFEIOHD HDFEIOHD,t1.HDINININ
				// HDINININ,t1.HDFEIOPC HDFEIOPC,t1.HDFEROPC
				// HDFEROPC,t1.HDCOREPC HDCOREPC,t1.HDFEIORP
				// HDFEIORP,t1.HDFERORP HDFERORP,t1.HDCOREAP
				// HDCOREAP,t1.HDFEIORA HDFEIORA,t1.HDTEACPA
				// HDTEACPA,t1.HDFECEAC HDFECEAC,t1.HDHOCEAC
				// HDHOCEAC,t1.HDFEIOCA HDFEIOCA,t1.HDTEACDE
				// HDTEACDE,t1.HDFEIOAC HDFEIOAC,t1.HDFEIOFC HDFEIOFC,t1.HDCOTRA
				// HDCOTRA,t1.HDTE02 HDTE02,t1.HDTE03 HDTE03,t1.HDTE04
				// HDTE04,t1.HDTE05 HDTE05,t1.HDTE06 HDTE06,t1.HDTE07
				// HDTE07,t1.HDTE08 HDTE08,t1.HDTE09 HDTE09,t1.HDTE10
				// HDTE10,t1.HDCOSC HDCOSC,t1.HDIDAL HDIDAL,t1.HDFEROAD
				// HDFEROAD,t1.HDFEROAT HDFEROAT,t1.HDTEALDT
				// HDTEALDT,t1.HDTEDEAT HDTEDEAT,t1.HDFEDEAT HDFEDEAT,t1.HDFEHD
				// HDFEHD,t1.HDTEDOADE HDTEDOADE,t1.HDTEDOADI
				// HDTEDOADI,t1.HDTEDOADF HDTEDOADF,t1.HDTEDOADA
				// HDTEDOADA,t1.HDNOPSE HDNOPSE,t1.HDNOPSI HDNOPSI,t1.HDNOPSF
				// HDNOPSF,t1.HDNOPSA HDNOPSA,t1.HDCOCODIGO
				// HDCOCODIGO,t2.DECODIGO DENUNCIADECODIGO,t2.DECOCP
				// DENUNCIADECOCP,t2.DECOOR DENUNCIADECOOR,t2.DENRAN
				// DENUNCIADENRAN,t2.DENROR DENUNCIADENROR,t2.DEFEDE
				// DENUNCIADEFEDE,t2.DEFERE DENUNCIADEFERE,t2.DEFEEX
				// DENUNCIADEFEEX,t2.DEFEIM DENUNCIADEFEIM,t2.DEINRE
				// DENUNCIADEINRE,t2.DENRRGEN DENUNCIADENRRGEN,t3.ESCODIGO
				// ESTABLECIMIENTOESCODIGO,t3.ESNOMBRE
				// ESTABLECIMIENTOESNOMBRE,t3.ESNIF
				// ESTABLECIMIENTOESNIF,t3.ESNOAN
				// ESTABLECIMIENTOESNOAN,t3.ESNOCO
				// ESTABLECIMIENTOESNOCO,t3.ESNODIR
				// ESTABLECIMIENTOESNODIR,t3.ESCOLO
				// ESTABLECIMIENTOESCOLO,t3.ESNRCOPO
				// ESTABLECIMIENTOESNRCOPO,t3.ESNRTEL
				// ESTABLECIMIENTOESNRTEL,t3.ESNRFAX
				// ESTABLECIMIENTOESNRFAX,t3.ESCOPA
				// ESTABLECIMIENTOESCOPA,t3.ESINCAPR
				// ESTABLECIMIENTOESINCAPR,t3.ESINDEMP
				// ESTABLECIMIENTOESINDEMP,t3.ESTECO
				// ESTABLECIMIENTOESTECO,t3.ESINADAR
				// ESTABLECIMIENTOESINADAR,t3.ESFEADAR
				// ESTABLECIMIENTOESFEADAR,t3.ESCOEM
				// ESTABLECIMIENTOESCOEM,t3.ESINEMPR
				// ESTABLECIMIENTOESINEMPR,t3.ESNRTEL2
				// ESTABLECIMIENTOESNRTEL2,t3.ESFEBA
				// ESTABLECIMIENTOESFEBA,t3.ESNOAP1
				// ESTABLECIMIENTOESNOAP1,t3.ESNOAP2
				// ESTABLECIMIENTOESNOAP2,t3.ESNOLO
				// ESTABLECIMIENTOESNOLO,t3.ESCOMAPV
				// ESTABLECIMIENTOESCOMAPV,t3.ESCOCA
				// ESTABLECIMIENTOESCOCA,t3.ESNOPECO
				// ESTABLECIMIENTOESNOPECO,t3.ESCOIDCO
				// ESTABLECIMIENTOESCOIDCO,t3.ESINRECO
				// ESTABLECIMIENTOESINRECO,t3.ESFEMOD
				// ESTABLECIMIENTOESFEMOD,t3.ESINESCO
				// ESTABLECIMIENTOESINESCO,t3.ESNOMU
				// ESTABLECIMIENTOESNOMU,t3.ESNOREP
				// ESTABLECIMIENTOESNOREP,t3.ESNIFREP
				// ESTABLECIMIENTOESNIFREP,t3.DTTEEMR
				// ESTABLECIMIENTODTTEEMR,t3.ESCAREP
				// ESTABLECIMIENTOESCAREP,t3.ESTEURL
				// ESTABLECIMIENTOESTEURL,t3.ESCOOE
				// ESTABLECIMIENTOESCOOE,t3.ESNODECO
				// ESTABLECIMIENTOESNODECO,t3.ESINTIAR
				// ESTABLECIMIENTOESINTIAR,t3.ESFEPLAD
				// ESTABLECIMIENTOESFEPLAD,t3.ESINDEME
				// ESTABLECIMIENTOESINDEME,t3.ESNORA_PAIS_ID
				// ESTABLEESNORAPAISID,t3.ESNORA_PAIS_NOMBRE
				// ESTABLEESNORAPAISNOMBRE,t3.ESNORA_PROVINCIA_ID
				// ESTABLEESNORAPROVINCIAID,t3.ESNOMBRE_PROVINCIA
				// ESTABLEESNOMBREPROVINCIA,t3.ESNORA_MUNICIPIO_ID
				// ESTABLEESNORAMUNICIPIOID,t3.ESNOMBRE_MUNICIPIO
				// ESTABLEESNOMBREMUNICIPIO,t3.ESNORA_LOCALIDAD_ID
				// ESTABLEESNORALOCALIDADID,t3.ESNOMBRE_LOCALIDAD
				// ESTABLEESNOMBRELOCALIDAD,t3.ESNORA_CALLE_ID
				// ESTABLEESNORACALLEID,t3.ESNOMBRE_CALLE
				// ESTABLEESNOMBRECALLE,t3.ESNORA_CP_ID
				// ESTABLEESNORACPID,t3.ESNOMBRE_CP
				// ESTABLEESNOMBRECP,t3.ESNORA_PORTAL_ID
				// ESTABLEESNORAPORTALID,t3.ESNOMBRE_PORTAL
				// ESTABLEESNOMBREPORTAL,t3.ESNOMBRE_PISO ESTABLEESNOMBREPISO,
				// t3.ESDIRECCION_NOCAPV ESTABLEESDIRECCION_NOCAPV,
				// t3.ESEXTRANJERO EstableESEXTRANJERO,t4.SECODIGO
				// SECTORSECODIGO,t4.SENOMBRE SECTORSENOMBRE,t4.SENOCO
				// SECTORSENOCO,t4.SEDESCRI SECTORSEDESCRI,t4.SECOSE
				// SECTORSECOSE,t4.SENOCO2 SECTORSENOCO2,t4.SEINSEL1
				// SECTORSEINSEL1,t4.SENOMBREE SECTORSENOMBREE,t4.SENOMBREI
				// SECTORSENOMBREI,t4.SENOMBREF SECTORSENOMBREF,t4.SENOCOE
				// SECTORSENOCOE,t4.SENOCOI SECTORSENOCOI,t4.SENOCOF
				// SECTORSENOCOF,t4.SEDESCRIE SECTORSEDESCRIE,t4.SEDESCRII
				// SECTORSEDESCRII,t4.SEDESCRIF SECTORSEDESCRIF,t4.SECODGRUPO
				// SECTORSECODGRUPO,t4.SENOMBREA SECTORSENOMBREA,t4.SEDESCRIA
				// SECTORSEDESCRIA,t4.SENOCOA SECTORSENOCOA,t5.MOCODIGO
				// CENSOMONITORMOCODIGO,t5.MONOMBRE
				// CENSOMONITORMONOMBRE,t5.MOCOEM CENSOMONITORMOCOEM, t5.MODNI
				// CENSOMONITORMODNI, t5.USUARIOXLNET
				// CENSOMONITORUSUARIOXLNET,t5.PUESTOXLNET
				// CENSOMONITORPUESTOXLNET, t5.MOFECBAJA
				// CENSOMONITORMOFECBAJA,t6.PSCODIGO
				// PRODUCTOPSCODIGO,t6.PSNOMBRE PRODUCTOPSNOMBRE,t6.PSNOCO
				// PRODUCTOPSNOCO,t6.PSDESCRI PRODUCTOPSDESCRI,t6.PSCOSE
				// PRODUCTOPSCOSE,t6.PSNOMBREE PRODUCTOPSNOMBREE,t6.PSNOMBREI
				// PRODUCTOPSNOMBREI,t6.PSNOMBREF PRODUCTOPSNOMBREF,t6.PSNOMBREA
				// PRODUCTOPSNOMBREA,t6.PSNOCOE PRODUCTOPSNOCOE,t6.PSNOCOI
				// PRODUCTOPSNOCOI,t6.PSNOCOF PRODUCTOPSNOCOF,t6.PSNOCOA
				// PRODUCTOPSNOCOA,t6.PSDESCRIE PRODUCTOPSDESCRIE,t6.PSDESCRII
				// PRODUCTOPSDESCRII,t6.PSDESCRIF PRODUCTOPSDESCRIF,t6.PSDESCRIA
				// PRODUCTOPSDESCRIA,t6.PSSEL1 PRODUCTOPSSEL1,t6.PSCOINC
				// PRODUCTOPSCOINC,t7.TSRCODIGO
				// TIPORECLAMACIONTSRCODIGO,t7.TSRNOMBRE
				// TIPORECLAMACIONTSRNOMBRE,t7.TSRNOMBREE
				// TIPORECLAMACIONTSRNOMBREE,t7.TSRNOMBREI
				// TIPORECLAMACIONTSRNOMBREI,t7.TSRNOMBREF
				// TIPORECLAMACIONTSRNOMBREF,t7.TSRNOMBREA
				// TIPORECLAMACIONTSRNOMBREA, t7.TSRIMPORTE
				// TIPORECLAMACIONTSRIMPORTE,t8.TIRCODIGO
				// MOTIVOTIRCODIGO,t8.TIRNOMBRE MOTIVOTIRNOMBRE,t2.DECOTFP
				// DENUNCIADECOTFP,t2.DECODT DENUNCIADECODT,t3.ESCOZS
				// ESTABLECIMIENTOESCOZS,t4.SECOL0 SECTORSECOL0,t5.MOCOOR
				// CENSOMONITORMOCOOR,t6.PSCOE8 PRODUCTOPSCOE8 "
				"SELECT  t1.HDCODIGO HDCODIGO,t1.HDNROR HDNROR,'' HDTE,t1.HDTEDOAD HDTEDOAD,t1.HDCOAV HDCOAV,t1.HDNOPS HDNOPS,t1.HDNOMAPS HDNOMAPS,t1.HDNOMOPS HDNOMOPS,t1.HDNRLOPS HDNRLOPS, t1.HDCODIGOBARRAS HDCODIGOBARRAS, t1.HDINTERESADO HDINTERESADO,t1.HDFEDMPS HDFEDMPS,t1.HDINSOTR HDINSOTR,t1.HDINSOMA HDINSOMA,t1.HDCAPTSO HDCAPTSO,t1.HDTESO HDTESO,t1.HDFEARDT HDFEARDT,t1.HDFEIOHD HDFEIOHD,t1.HDINININ HDINININ,t1.HDFEIOPC HDFEIOPC,t1.HDFEROPC HDFEROPC,t1.HDCOREPC HDCOREPC,t1.HDFEIORP HDFEIORP,t1.HDFERORP HDFERORP,t1.HDCOREAP HDCOREAP,t1.HDFEIORA HDFEIORA,t1.HDTEACPA HDTEACPA,t1.HDFECEAC HDFECEAC,t1.HDHOCEAC HDHOCEAC,t1.HDFEIOCA HDFEIOCA,t1.HDTEACDE HDTEACDE,t1.HDFEIOAC HDFEIOAC,t1.HDFEIOFC HDFEIOFC,t1.HDCOTRA HDCOTRA,t1.HDTE02 HDTE02,t1.HDTE03 HDTE03,t1.HDTE04 HDTE04,t1.HDTE05 HDTE05,t1.HDTE06 HDTE06,t1.HDTE07 HDTE07,t1.HDTE08 HDTE08,t1.HDTE09 HDTE09,t1.HDTE10 HDTE10,t1.HDCOSC HDCOSC,t1.HDIDAL HDIDAL,t1.HDFEROAD HDFEROAD,t1.HDFEROAT HDFEROAT,t1.HDTEALDT HDTEALDT,t1.HDTEDEAT HDTEDEAT,t1.HDFEDEAT HDFEDEAT,t1.HDFEHD HDFEHD,t1.HDTEDOADE HDTEDOADE,t1.HDTEDOADI HDTEDOADI,t1.HDTEDOADF HDTEDOADF,t1.HDTEDOADA HDTEDOADA,t1.HDNOPSE HDNOPSE,t1.HDNOPSI HDNOPSI,t1.HDNOPSF HDNOPSF,t1.HDNOPSA HDNOPSA,t1.HDCOCODIGO HDCOCODIGO,t2.DECODIGO DENUNCIADECODIGO,t2.DECOCP DENUNCIADECOCP,t2.DECOOR DENUNCIADECOOR,t2.DENRAN DENUNCIADENRAN,t2.DENROR DENUNCIADENROR,t2.DEFEDE DENUNCIADEFEDE,t2.DEFERE DENUNCIADEFERE,t2.DEFEEX DENUNCIADEFEEX,t2.DEFEIM DENUNCIADEFEIM,t2.DEINRE DENUNCIADEINRE,t2.DENRRGEN DENUNCIADENRRGEN,t3.ESCODIGO ESTABLECIMIENTOESCODIGO,t3.ESNOMBRE ESTABLECIMIENTOESNOMBRE, t3.ESTIPID ESTABLECIMIENTOESTIPID,t3.ESNIF ESTABLECIMIENTOESNIF,t3.ESNOAN ESTABLECIMIENTOESNOAN,t3.ESNOCO ESTABLECIMIENTOESNOCO,t3.ESNODIR ESTABLECIMIENTOESNODIR,t3.ESCOLO ESTABLECIMIENTOESCOLO,t3.ESNRCOPO ESTABLECIMIENTOESNRCOPO,t3.ESNRTEL ESTABLECIMIENTOESNRTEL,t3.ESNRFAX ESTABLECIMIENTOESNRFAX,t3.ESCOPA ESTABLECIMIENTOESCOPA,t3.ESINCAPR ESTABLECIMIENTOESINCAPR,t3.ESINDEMP ESTABLECIMIENTOESINDEMP,t3.ESTECO ESTABLECIMIENTOESTECO,t3.ESINADAR ESTABLECIMIENTOESINADAR,t3.ESFEADAR ESTABLECIMIENTOESFEADAR,t3.ESCOEM ESTABLECIMIENTOESCOEM,t3.ESINEMPR ESTABLECIMIENTOESINEMPR,t3.ESNRTEL2 ESTABLECIMIENTOESNRTEL2,t3.ESFEBA ESTABLECIMIENTOESFEBA,t3.ESNOAP1 ESTABLECIMIENTOESNOAP1,t3.ESNOAP2 ESTABLECIMIENTOESNOAP2,t3.ESNOLO ESTABLECIMIENTOESNOLO,t3.ESCOMAPV ESTABLECIMIENTOESCOMAPV,t3.ESCOCA ESTABLECIMIENTOESCOCA,t3.ESNOPECO ESTABLECIMIENTOESNOPECO,t3.ESCOIDCO ESTABLECIMIENTOESCOIDCO,t3.ESINRECO ESTABLECIMIENTOESINRECO,t3.ESFEMOD ESTABLECIMIENTOESFEMOD,t3.ESINESCO ESTABLECIMIENTOESINESCO,t3.ESNOMU ESTABLECIMIENTOESNOMU,t3.ESNOREP ESTABLECIMIENTOESNOREP,t3.ESNIFREP ESTABLECIMIENTOESNIFREP,t3.DTTEEMR ESTABLECIMIENTODTTEEMR,t3.ESCAREP ESTABLECIMIENTOESCAREP,t3.ESTEURL ESTABLECIMIENTOESTEURL,t3.ESCOOE ESTABLECIMIENTOESCOOE,t3.ESNODECO ESTABLECIMIENTOESNODECO,t3.ESINTIAR ESTABLECIMIENTOESINTIAR,t3.ESFEPLAD ESTABLECIMIENTOESFEPLAD,t3.ESINDEME ESTABLECIMIENTOESINDEME,t3.ESNORA_PAIS_ID ESTABLEESNORAPAISID,t3.ESNORA_PAIS_NOMBRE ESTABLEESNORAPAISNOMBRE,t3.ESNORA_PROVINCIA_ID ESTABLEESNORAPROVINCIAID,t3.ESNOMBRE_PROVINCIA ESTABLEESNOMBREPROVINCIA,t3.ESNORA_MUNICIPIO_ID ESTABLEESNORAMUNICIPIOID,t3.ESNOMBRE_MUNICIPIO ESTABLEESNOMBREMUNICIPIO,t3.ESNORA_LOCALIDAD_ID ESTABLEESNORALOCALIDADID,t3.ESNOMBRE_LOCALIDAD ESTABLEESNOMBRELOCALIDAD,t3.ESNORA_CALLE_ID ESTABLEESNORACALLEID,t3.ESNOMBRE_CALLE ESTABLEESNOMBRECALLE,t3.ESNORA_CP_ID ESTABLEESNORACPID,t3.ESNOMBRE_CP ESTABLEESNOMBRECP,t3.ESNORA_PORTAL_ID ESTABLEESNORAPORTALID,t3.ESNOMBRE_PORTAL ESTABLEESNOMBREPORTAL,t3.ESNOMBRE_PISO ESTABLEESNOMBREPISO, t3.ESDIRECCION_NOCAPV ESTABLEESDIRECCION_NOCAPV, t3.ESEXTRANJERO EstableESEXTRANJERO,t4.SECODIGO SECTORSECODIGO,t4.SENOMBRE SECTORSENOMBRE,t4.SENOCO SECTORSENOCO,t4.SEDESCRI SECTORSEDESCRI,t4.SECOSE SECTORSECOSE,t4.SENOCO2 SECTORSENOCO2,t4.SEINSEL1 SECTORSEINSEL1,t4.SENOMBREE SECTORSENOMBREE,t4.SENOMBREI SECTORSENOMBREI,t4.SENOMBREF SECTORSENOMBREF,t4.SENOCOE SECTORSENOCOE,t4.SENOCOI SECTORSENOCOI,t4.SENOCOF SECTORSENOCOF,t4.SEDESCRIE SECTORSEDESCRIE,t4.SEDESCRII SECTORSEDESCRII,t4.SEDESCRIF SECTORSEDESCRIF,t4.SECODGRUPO SECTORSECODGRUPO,t4.SENOMBREA SECTORSENOMBREA,t4.SEDESCRIA SECTORSEDESCRIA,t4.SENOCOA SECTORSENOCOA,t5.MOCODIGO CENSOMONITORMOCODIGO,t5.MONOMBRE CENSOMONITORMONOMBRE,t5.MOCOEM CENSOMONITORMOCOEM, t5.MODNI CENSOMONITORMODNI, t5.USUARIOXLNET CENSOMONITORUSUARIOXLNET,t5.PUESTOXLNET CENSOMONITORPUESTOXLNET, t5.MOFECBAJA CENSOMONITORMOFECBAJA,t6.PSCODIGO PRODUCTOPSCODIGO,t6.PSNOMBRE PRODUCTOPSNOMBRE,t6.PSNOCO PRODUCTOPSNOCO,t6.PSDESCRI PRODUCTOPSDESCRI,t6.PSCOSE PRODUCTOPSCOSE,t6.PSNOMBREE PRODUCTOPSNOMBREE,t6.PSNOMBREI PRODUCTOPSNOMBREI,t6.PSNOMBREF PRODUCTOPSNOMBREF,t6.PSNOMBREA PRODUCTOPSNOMBREA,t6.PSNOCOE PRODUCTOPSNOCOE,t6.PSNOCOI PRODUCTOPSNOCOI,t6.PSNOCOF PRODUCTOPSNOCOF,t6.PSNOCOA PRODUCTOPSNOCOA,t6.PSDESCRIE PRODUCTOPSDESCRIE,t6.PSDESCRII PRODUCTOPSDESCRII,t6.PSDESCRIF PRODUCTOPSDESCRIF,t6.PSDESCRIA PRODUCTOPSDESCRIA,t6.PSSEL1 PRODUCTOPSSEL1,t6.PSCOINC PRODUCTOPSCOINC,t7.TSRCODIGO TIPORECLAMACIONTSRCODIGO,t7.TSRNOMBRE TIPORECLAMACIONTSRNOMBRE,t7.TSRNOMBREE TIPORECLAMACIONTSRNOMBREE,t7.TSRNOMBREI TIPORECLAMACIONTSRNOMBREI,t7.TSRNOMBREF TIPORECLAMACIONTSRNOMBREF,t7.TSRNOMBREA TIPORECLAMACIONTSRNOMBREA, t7.TSRIMPORTE TIPORECLAMACIONTSRIMPORTE,t8.TIRCODIGO MOTIVOTIRCODIGO,t8.TIRNOMBRE MOTIVOTIRNOMBRE,t2.DECOTFP DENUNCIADECOTFP,t2.DECODT DENUNCIADECODT,t3.ESCOZS ESTABLECIMIENTOESCOZS,t4.SECOL0 SECTORSECOL0,t5.MOCOOR CENSOMONITORMOCOOR,t6.PSCOE8 PRODUCTOPSCOE8, t1.HDFORMANOTIFICACION HDFORMANOTIFICACION, t1.HDFORMANOTIFESTABLECIMIENTO HDFORMANOTIFESTABLECIMIENTO,t1.HDFORMAVENTA HDFORMAVENTA, t1.HDIDIOMA HDIDIOMA  "
						+ "FROM HECHO_DENUNCIADO t1 ,DENUNCIA t2 ,ESTABLECIMIENTO t3 ,SECTOR t4 ,CENSO_MONITOR t5 ,PRODUCTO t6 ,TIPO_RECLAMACION t7 ,MOTIVO t8 ");

		if (hechodenunciado != null && hechodenunciado.getHdcodigo() != null) {
			where.append(" AND t1.HDCODIGO = ?");
			params.add(hechodenunciado.getHdcodigo());
		}
		if (hechodenunciado != null && hechodenunciado.getDenuncia() != null
				&& hechodenunciado.getDenuncia().getDecodigo() != null) {
			where.append(" AND t2.DECODIGO = ?");
			params.add(hechodenunciado.getDenuncia().getDecodigo());
		}
		if (hechodenunciado != null && hechodenunciado.getDenuncia() != null
				&& hechodenunciado.getDenuncia().getFormaPresentacion() != null
				&& hechodenunciado.getDenuncia().getFormaPresentacion().getTfpcodigo() != null) {
			where.append(" AND t2.DECOTFP = ?");
			params.add(hechodenunciado.getDenuncia().getFormaPresentacion().getTfpcodigo());
		}
		if (hechodenunciado != null && hechodenunciado.getDenuncia() != null
				&& hechodenunciado.getDenuncia().getConsumidor() != null
				&& hechodenunciado.getDenuncia().getConsumidor().getDtcodigo() != null) {
			where.append(" AND t2.DECODT = ?");
			params.add(hechodenunciado.getDenuncia().getConsumidor().getDtcodigo());
		}
		if (hechodenunciado != null && hechodenunciado.getDenuncia() != null
				&& hechodenunciado.getDenuncia().getDecocp() != null) {
			where.append(" AND t2.DECOCP = ?");
			params.add(hechodenunciado.getDenuncia().getDecocp());
		}
		if (hechodenunciado != null && hechodenunciado.getDenuncia() != null
				&& hechodenunciado.getDenuncia().getDecoor() != null) {
			where.append(" AND t2.DECOOR = ?");
			params.add(hechodenunciado.getDenuncia().getDecoor());
		}
		if (hechodenunciado != null && hechodenunciado.getDenuncia() != null
				&& hechodenunciado.getDenuncia().getDenran() != null) {
			where.append(" AND t2.DENRAN = ?");
			params.add(hechodenunciado.getDenuncia().getDenran());
		}
		if (hechodenunciado != null && hechodenunciado.getDenuncia() != null
				&& hechodenunciado.getDenuncia().getDenror() != null) {
			where.append(" AND t2.DENROR = ?");
			params.add(hechodenunciado.getDenuncia().getDenror());
		}
		if (hechodenunciado != null && hechodenunciado.getDenuncia() != null
				&& hechodenunciado.getDenuncia().getDefede() != null) {
			where.append(" AND t2.DEFEDE = ?");
			params.add(hechodenunciado.getDenuncia().getDefede());
		}
		if (hechodenunciado != null && hechodenunciado.getDenuncia() != null
				&& hechodenunciado.getDenuncia().getDefere() != null) {
			where.append(" AND t2.DEFERE = ?");
			params.add(hechodenunciado.getDenuncia().getDefere());
		}
		if (hechodenunciado != null && hechodenunciado.getDenuncia() != null
				&& hechodenunciado.getDenuncia().getDefeex() != null) {
			where.append(" AND t2.DEFEEX = ?");
			params.add(hechodenunciado.getDenuncia().getDefeex());
		}
		if (hechodenunciado != null && hechodenunciado.getDenuncia() != null
				&& hechodenunciado.getDenuncia().getDefeim() != null) {
			where.append(" AND t2.DEFEIM = ?");
			params.add(hechodenunciado.getDenuncia().getDefeim());
		}
		if (hechodenunciado != null && hechodenunciado.getDenuncia() != null
				&& hechodenunciado.getDenuncia().getDeinre() != null) {
			where.append(" AND t2.DEINRE = ?");
			params.add(hechodenunciado.getDenuncia().getDeinre());
		}
		if (hechodenunciado != null && hechodenunciado.getDenuncia() != null
				&& hechodenunciado.getDenuncia().getDenrrgen() != null) {
			where.append(" AND t2.DENRRGEN = ?");
			params.add(hechodenunciado.getDenuncia().getDenrrgen());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEscodigo() != null) {
			where.append(" AND t3.ESCODIGO = ?");
			params.add(hechodenunciado.getEstablecimiento().getEscodigo());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getCensoMonitor() != null
				&& hechodenunciado.getEstablecimiento().getCensoMonitor().getMocodigo() != null) {
			where.append(" AND t3.ESCOZS = ?");
			params.add(hechodenunciado.getEstablecimiento().getCensoMonitor().getMocodigo());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnombre() != null) {
			where.append(" AND t3.ESNOMBRE = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsnombre());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnif() != null) {
			where.append(" AND t3.ESNIF = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsnif());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnoan() != null) {
			where.append(" AND t3.ESNOAN = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsnoan());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnoco() != null) {
			where.append(" AND t3.ESNOCO = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsnoco());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnodir() != null) {
			where.append(" AND t3.ESNODIR = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsnodir());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEscolo() != null) {
			where.append(" AND t3.ESCOLO = ?");
			params.add(hechodenunciado.getEstablecimiento().getEscolo());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnrcopo() != null) {
			where.append(" AND t3.ESNRCOPO = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsnrcopo());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnrtel() != null) {
			where.append(" AND t3.ESNRTEL = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsnrtel());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnrfax() != null) {
			where.append(" AND t3.ESNRFAX = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsnrfax());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEscopa() != null) {
			where.append(" AND t3.ESCOPA = ?");
			params.add(hechodenunciado.getEstablecimiento().getEscopa());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsincapr() != null) {
			where.append(" AND t3.ESINCAPR = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsincapr());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsindemp() != null) {
			where.append(" AND t3.ESINDEMP = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsindemp());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsteco() != null) {
			where.append(" AND t3.ESTECO = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsteco());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsinadar() != null) {
			where.append(" AND t3.ESINADAR = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsinadar());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsfeadar() != null) {
			where.append(" AND t3.ESFEADAR = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsfeadar());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEscoem() != null) {
			where.append(" AND t3.ESCOEM = ?");
			params.add(hechodenunciado.getEstablecimiento().getEscoem());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsinempr() != null) {
			where.append(" AND t3.ESINEMPR = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsinempr());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnrtel2() != null) {
			where.append(" AND t3.ESNRTEL2 = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsnrtel2());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsfeba() != null) {
			where.append(" AND t3.ESFEBA = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsfeba());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnoap1() != null) {
			where.append(" AND t3.ESNOAP1 = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsnoap1());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnoap2() != null) {
			where.append(" AND t3.ESNOAP2 = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsnoap2());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnolo() != null) {
			where.append(" AND t3.ESNOLO = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsnolo());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEscomapv() != null) {
			where.append(" AND t3.ESCOMAPV = ?");
			params.add(hechodenunciado.getEstablecimiento().getEscomapv());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEscoca() != null) {
			where.append(" AND t3.ESCOCA = ?");
			params.add(hechodenunciado.getEstablecimiento().getEscoca());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnopeco() != null) {
			where.append(" AND t3.ESNOPECO = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsnopeco());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEscoidco() != null) {
			where.append(" AND t3.ESCOIDCO = ?");
			params.add(hechodenunciado.getEstablecimiento().getEscoidco());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsinreco() != null) {
			where.append(" AND t3.ESINRECO = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsinreco());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsfemod() != null) {
			where.append(" AND t3.ESFEMOD = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsfemod());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsinesco() != null) {
			where.append(" AND t3.ESINESCO = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsinesco());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnomu() != null) {
			where.append(" AND t3.ESNOMU = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsnomu());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnorep() != null) {
			where.append(" AND t3.ESNOREP = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsnorep());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnifrep() != null) {
			where.append(" AND t3.ESNIFREP = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsnifrep());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getDtteemr() != null) {
			where.append(" AND t3.DTTEEMR = ?");
			params.add(hechodenunciado.getEstablecimiento().getDtteemr());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEscarep() != null) {
			where.append(" AND t3.ESCAREP = ?");
			params.add(hechodenunciado.getEstablecimiento().getEscarep());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsteurl() != null) {
			where.append(" AND t3.ESTEURL = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsteurl());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEscooe() != null) {
			where.append(" AND t3.ESCOOE = ?");
			params.add(hechodenunciado.getEstablecimiento().getEscooe());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnodeco() != null) {
			where.append(" AND t3.ESNODECO = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsnodeco());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsintiar() != null) {
			where.append(" AND t3.ESINTIAR = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsintiar());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsfeplad() != null) {
			where.append(" AND t3.ESFEPLAD = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsfeplad());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsindeme() != null) {
			where.append(" AND t3.ESINDEME = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsindeme());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnoraPaisId() != null) {
			where.append(" AND t3.ESNORA_PAIS_ID = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsnoraPaisId());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnoraPaisNombre() != null) {
			where.append(" AND t3.ESNORA_PAIS_NOMBRE = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsnoraPaisNombre());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnoraProvinciaId() != null) {
			where.append(" AND t3.ESNORA_PROVINCIA_ID = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsnoraProvinciaId());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnombreProvincia() != null) {
			where.append(" AND t3.ESNOMBRE_PROVINCIA = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsnombreProvincia());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnoraMunicipioId() != null) {
			where.append(" AND t3.ESNORA_MUNICIPIO_ID = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsnoraMunicipioId());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnombreMunicipio() != null) {
			where.append(" AND t3.ESNOMBRE_MUNICIPIO = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsnombreMunicipio());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnoraLocalidadId() != null) {
			where.append(" AND t3.ESNORA_LOCALIDAD_ID = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsnoraLocalidadId());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnombreLocalidad() != null) {
			where.append(" AND t3.ESNOMBRE_LOCALIDAD = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsnombreLocalidad());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnoraCalleId() != null) {
			where.append(" AND t3.ESNORA_CALLE_ID = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsnoraCalleId());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnombreCalle() != null) {
			where.append(" AND t3.ESNOMBRE_CALLE = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsnombreCalle());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnoraCpId() != null) {
			where.append(" AND t3.ESNORA_CP_ID = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsnoraCpId());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnombreCp() != null) {
			where.append(" AND t3.ESNOMBRE_CP = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsnombreCp());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnoraPortalId() != null) {
			where.append(" AND t3.ESNORA_PORTAL_ID = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsnoraPortalId());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnombrePortal() != null) {
			where.append(" AND t3.ESNOMBRE_PORTAL = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsnombrePortal());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnombrePiso() != null) {
			where.append(" AND t3.ESNOMBRE_PISO = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsnombrePiso());
		}
		if (hechodenunciado != null && hechodenunciado.getSector() != null
				&& hechodenunciado.getSector().getSecodigo() != null) {
			where.append(" AND t4.SECODIGO = ?");
			params.add(hechodenunciado.getSector().getSecodigo());
		}
		if (hechodenunciado != null && hechodenunciado.getSector() != null
				&& hechodenunciado.getSector().getSectorAgrupado() != null
				&& hechodenunciado.getSector().getSectorAgrupado().getL0codigo() != null) {
			where.append(" AND t4.SECOL0 = ?");
			params.add(hechodenunciado.getSector().getSectorAgrupado().getL0codigo());
		}
		if (hechodenunciado != null && hechodenunciado.getSector() != null
				&& hechodenunciado.getSector().getSenombre() != null) {
			where.append(" AND t4.SENOMBRE = ?");
			params.add(hechodenunciado.getSector().getSenombre());
		}
		if (hechodenunciado != null && hechodenunciado.getSector() != null
				&& hechodenunciado.getSector().getSenoco() != null) {
			where.append(" AND t4.SENOCO = ?");
			params.add(hechodenunciado.getSector().getSenoco());
		}
		if (hechodenunciado != null && hechodenunciado.getSector() != null
				&& hechodenunciado.getSector().getSedescri() != null) {
			where.append(" AND t4.SEDESCRI = ?");
			params.add(hechodenunciado.getSector().getSedescri());
		}
		if (hechodenunciado != null && hechodenunciado.getSector() != null
				&& hechodenunciado.getSector().getSecose() != null) {
			where.append(" AND t4.SECOSE = ?");
			params.add(hechodenunciado.getSector().getSecose());
		}
		if (hechodenunciado != null && hechodenunciado.getSector() != null
				&& hechodenunciado.getSector().getSenoco2() != null) {
			where.append(" AND t4.SENOCO2 = ?");
			params.add(hechodenunciado.getSector().getSenoco2());
		}
		if (hechodenunciado != null && hechodenunciado.getSector() != null
				&& hechodenunciado.getSector().getSeinsel1() != null) {
			where.append(" AND t4.SEINSEL1 = ?");
			params.add(hechodenunciado.getSector().getSeinsel1());
		}
		if (hechodenunciado != null && hechodenunciado.getSector() != null
				&& hechodenunciado.getSector().getSenombree() != null) {
			where.append(" AND t4.SENOMBREE = ?");
			params.add(hechodenunciado.getSector().getSenombree());
		}
		if (hechodenunciado != null && hechodenunciado.getSector() != null
				&& hechodenunciado.getSector().getSenombrei() != null) {
			where.append(" AND t4.SENOMBREI = ?");
			params.add(hechodenunciado.getSector().getSenombrei());
		}
		if (hechodenunciado != null && hechodenunciado.getSector() != null
				&& hechodenunciado.getSector().getSenombref() != null) {
			where.append(" AND t4.SENOMBREF = ?");
			params.add(hechodenunciado.getSector().getSenombref());
		}
		if (hechodenunciado != null && hechodenunciado.getSector() != null
				&& hechodenunciado.getSector().getSenocoe() != null) {
			where.append(" AND t4.SENOCOE = ?");
			params.add(hechodenunciado.getSector().getSenocoe());
		}
		if (hechodenunciado != null && hechodenunciado.getSector() != null
				&& hechodenunciado.getSector().getSenocoi() != null) {
			where.append(" AND t4.SENOCOI = ?");
			params.add(hechodenunciado.getSector().getSenocoi());
		}
		if (hechodenunciado != null && hechodenunciado.getSector() != null
				&& hechodenunciado.getSector().getSenocof() != null) {
			where.append(" AND t4.SENOCOF = ?");
			params.add(hechodenunciado.getSector().getSenocof());
		}
		if (hechodenunciado != null && hechodenunciado.getSector() != null
				&& hechodenunciado.getSector().getSedescrie() != null) {
			where.append(" AND t4.SEDESCRIE = ?");
			params.add(hechodenunciado.getSector().getSedescrie());
		}
		if (hechodenunciado != null && hechodenunciado.getSector() != null
				&& hechodenunciado.getSector().getSedescrii() != null) {
			where.append(" AND t4.SEDESCRII = ?");
			params.add(hechodenunciado.getSector().getSedescrii());
		}
		if (hechodenunciado != null && hechodenunciado.getSector() != null
				&& hechodenunciado.getSector().getSedescrif() != null) {
			where.append(" AND t4.SEDESCRIF = ?");
			params.add(hechodenunciado.getSector().getSedescrif());
		}
		if (hechodenunciado != null && hechodenunciado.getSector() != null
				&& hechodenunciado.getSector().getSecodgrupo() != null) {
			where.append(" AND t4.SECODGRUPO = ?");
			params.add(hechodenunciado.getSector().getSecodgrupo());
		}
		if (hechodenunciado != null && hechodenunciado.getSector() != null
				&& hechodenunciado.getSector().getSenombrea() != null) {
			where.append(" AND t4.SENOMBREA = ?");
			params.add(hechodenunciado.getSector().getSenombrea());
		}
		if (hechodenunciado != null && hechodenunciado.getSector() != null
				&& hechodenunciado.getSector().getSedescria() != null) {
			where.append(" AND t4.SEDESCRIA = ?");
			params.add(hechodenunciado.getSector().getSedescria());
		}
		if (hechodenunciado != null && hechodenunciado.getSector() != null
				&& hechodenunciado.getSector().getSenocoa() != null) {
			where.append(" AND t4.SENOCOA = ?");
			params.add(hechodenunciado.getSector().getSenocoa());
		}
		if (hechodenunciado != null && hechodenunciado.getCensoMonitor() != null
				&& hechodenunciado.getCensoMonitor().getMocodigo() != null) {
			where.append(" AND t5.MOCODIGO = ?");
			params.add(hechodenunciado.getCensoMonitor().getMocodigo());
		}
		if (hechodenunciado != null && hechodenunciado.getCensoMonitor() != null
				&& hechodenunciado.getCensoMonitor().getOrganismo() != null
				&& hechodenunciado.getCensoMonitor().getOrganismo().getCodOrg() != null) {
			where.append(" AND t5.MOCOOR = ?");
			params.add(hechodenunciado.getCensoMonitor().getOrganismo().getCodOrg());
		}
		if (hechodenunciado != null && hechodenunciado.getCensoMonitor() != null
				&& hechodenunciado.getCensoMonitor().getMonombre() != null) {
			where.append(" AND t5.MONOMBRE = ?");
			params.add(hechodenunciado.getCensoMonitor().getMonombre());
		}
		if (hechodenunciado != null && hechodenunciado.getCensoMonitor() != null
				&& hechodenunciado.getCensoMonitor().getMocoem() != null) {
			where.append(" AND t5.MOCOEM = ?");
			params.add(hechodenunciado.getCensoMonitor().getMocoem());
		}

		if (hechodenunciado != null && hechodenunciado.getCensoMonitor() != null
				&& hechodenunciado.getCensoMonitor().getMofecbaja() != null) {
			where.append(" AND t5.MOFECBAJA = ?");
			params.add(hechodenunciado.getCensoMonitor().getMofecbaja());
		}

		if (hechodenunciado != null && hechodenunciado.getProducto() != null
				&& hechodenunciado.getProducto().getPscodigo() != null) {
			where.append(" AND t6.PSCODIGO = ?");
			params.add(hechodenunciado.getProducto().getPscodigo());
		}
		if (hechodenunciado != null && hechodenunciado.getProducto() != null
				&& hechodenunciado.getProducto().getProdAgrupado() != null
				&& hechodenunciado.getProducto().getProdAgrupado().getE8codigo() != null) {
			where.append(" AND t6.PSCOE8 = ?");
			params.add(hechodenunciado.getProducto().getProdAgrupado().getE8codigo());
		}
		if (hechodenunciado != null && hechodenunciado.getProducto() != null
				&& hechodenunciado.getProducto().getPsnombre() != null) {
			where.append(" AND t6.PSNOMBRE = ?");
			params.add(hechodenunciado.getProducto().getPsnombre());
		}
		if (hechodenunciado != null && hechodenunciado.getProducto() != null
				&& hechodenunciado.getProducto().getPsnoco() != null) {
			where.append(" AND t6.PSNOCO = ?");
			params.add(hechodenunciado.getProducto().getPsnoco());
		}
		if (hechodenunciado != null && hechodenunciado.getProducto() != null
				&& hechodenunciado.getProducto().getPsdescri() != null) {
			where.append(" AND t6.PSDESCRI = ?");
			params.add(hechodenunciado.getProducto().getPsdescri());
		}
		if (hechodenunciado != null && hechodenunciado.getProducto() != null
				&& hechodenunciado.getProducto().getPscose() != null) {
			where.append(" AND t6.PSCOSE = ?");
			params.add(hechodenunciado.getProducto().getPscose());
		}
		if (hechodenunciado != null && hechodenunciado.getProducto() != null
				&& hechodenunciado.getProducto().getPsnombree() != null) {
			where.append(" AND t6.PSNOMBREE = ?");
			params.add(hechodenunciado.getProducto().getPsnombree());
		}
		if (hechodenunciado != null && hechodenunciado.getProducto() != null
				&& hechodenunciado.getProducto().getPsnombrei() != null) {
			where.append(" AND t6.PSNOMBREI = ?");
			params.add(hechodenunciado.getProducto().getPsnombrei());
		}
		if (hechodenunciado != null && hechodenunciado.getProducto() != null
				&& hechodenunciado.getProducto().getPsnombref() != null) {
			where.append(" AND t6.PSNOMBREF = ?");
			params.add(hechodenunciado.getProducto().getPsnombref());
		}
		if (hechodenunciado != null && hechodenunciado.getProducto() != null
				&& hechodenunciado.getProducto().getPsnombrea() != null) {
			where.append(" AND t6.PSNOMBREA = ?");
			params.add(hechodenunciado.getProducto().getPsnombrea());
		}
		if (hechodenunciado != null && hechodenunciado.getProducto() != null
				&& hechodenunciado.getProducto().getPsnocoe() != null) {
			where.append(" AND t6.PSNOCOE = ?");
			params.add(hechodenunciado.getProducto().getPsnocoe());
		}
		if (hechodenunciado != null && hechodenunciado.getProducto() != null
				&& hechodenunciado.getProducto().getPsnocoi() != null) {
			where.append(" AND t6.PSNOCOI = ?");
			params.add(hechodenunciado.getProducto().getPsnocoi());
		}
		if (hechodenunciado != null && hechodenunciado.getProducto() != null
				&& hechodenunciado.getProducto().getPsnocof() != null) {
			where.append(" AND t6.PSNOCOF = ?");
			params.add(hechodenunciado.getProducto().getPsnocof());
		}
		if (hechodenunciado != null && hechodenunciado.getProducto() != null
				&& hechodenunciado.getProducto().getPsnocoa() != null) {
			where.append(" AND t6.PSNOCOA = ?");
			params.add(hechodenunciado.getProducto().getPsnocoa());
		}
		if (hechodenunciado != null && hechodenunciado.getProducto() != null
				&& hechodenunciado.getProducto().getPsdescrie() != null) {
			where.append(" AND t6.PSDESCRIE = ?");
			params.add(hechodenunciado.getProducto().getPsdescrie());
		}
		if (hechodenunciado != null && hechodenunciado.getProducto() != null
				&& hechodenunciado.getProducto().getPsdescrii() != null) {
			where.append(" AND t6.PSDESCRII = ?");
			params.add(hechodenunciado.getProducto().getPsdescrii());
		}
		if (hechodenunciado != null && hechodenunciado.getProducto() != null
				&& hechodenunciado.getProducto().getPsdescrif() != null) {
			where.append(" AND t6.PSDESCRIF = ?");
			params.add(hechodenunciado.getProducto().getPsdescrif());
		}
		if (hechodenunciado != null && hechodenunciado.getProducto() != null
				&& hechodenunciado.getProducto().getPsdescria() != null) {
			where.append(" AND t6.PSDESCRIA = ?");
			params.add(hechodenunciado.getProducto().getPsdescria());
		}
		if (hechodenunciado != null && hechodenunciado.getProducto() != null
				&& hechodenunciado.getProducto().getPssel1() != null) {
			where.append(" AND t6.PSSEL1 = ?");
			params.add(hechodenunciado.getProducto().getPssel1());
		}
		if (hechodenunciado != null && hechodenunciado.getProducto() != null
				&& hechodenunciado.getProducto().getPscoinc() != null) {
			where.append(" AND t6.PSCOINC = ?");
			params.add(hechodenunciado.getProducto().getPscoinc());
		}
		if (hechodenunciado != null && hechodenunciado.getTipoReclamacion() != null
				&& hechodenunciado.getTipoReclamacion().getTsrcodigo() != null) {
			where.append(" AND t7.TSRCODIGO = ?");
			params.add(hechodenunciado.getTipoReclamacion().getTsrcodigo());
		}
		if (hechodenunciado != null && hechodenunciado.getTipoReclamacion() != null
				&& hechodenunciado.getTipoReclamacion().getTsrnombre() != null) {
			where.append(" AND t7.TSRNOMBRE = ?");
			params.add(hechodenunciado.getTipoReclamacion().getTsrnombre());
		}
		if (hechodenunciado != null && hechodenunciado.getTipoReclamacion() != null
				&& hechodenunciado.getTipoReclamacion().getTsrnombree() != null) {
			where.append(" AND t7.TSRNOMBREE = ?");
			params.add(hechodenunciado.getTipoReclamacion().getTsrnombree());
		}
		if (hechodenunciado != null && hechodenunciado.getTipoReclamacion() != null
				&& hechodenunciado.getTipoReclamacion().getTsrnombrei() != null) {
			where.append(" AND t7.TSRNOMBREI = ?");
			params.add(hechodenunciado.getTipoReclamacion().getTsrnombrei());
		}
		if (hechodenunciado != null && hechodenunciado.getTipoReclamacion() != null
				&& hechodenunciado.getTipoReclamacion().getTsrnombref() != null) {
			where.append(" AND t7.TSRNOMBREF = ?");
			params.add(hechodenunciado.getTipoReclamacion().getTsrnombref());
		}
		if (hechodenunciado != null && hechodenunciado.getTipoReclamacion() != null
				&& hechodenunciado.getTipoReclamacion().getTsrnombrea() != null) {
			where.append(" AND t7.TSRNOMBREA = ?");
			params.add(hechodenunciado.getTipoReclamacion().getTsrnombrea());
		}
		if (hechodenunciado != null && hechodenunciado.getMotivo() != null
				&& hechodenunciado.getMotivo().getTircodigo() != null) {
			where.append(" AND t8.TIRCODIGO = ?");
			params.add(hechodenunciado.getMotivo().getTircodigo());
		}
		if (hechodenunciado != null && hechodenunciado.getMotivo() != null
				&& hechodenunciado.getMotivo().getTirnombre() != null) {
			where.append(" AND t8.TIRNOMBRE = ?");
			params.add(hechodenunciado.getMotivo().getTirnombre());
		}
		if (hechodenunciado != null && hechodenunciado.getHdnror() != null) {
			where.append(" AND t1.HDNROR = ?");
			params.add(hechodenunciado.getHdnror());
		}
		if (hechodenunciado != null && hechodenunciado.getHdte() != null) {
			where.append(" AND t1.HDTE = ?");
			params.add(hechodenunciado.getHdte());
		}
		if (hechodenunciado != null && hechodenunciado.getHdtedoad() != null) {
			where.append(" AND t1.HDTEDOAD = ?");
			params.add(hechodenunciado.getHdtedoad());
		}
		if (hechodenunciado != null && hechodenunciado.getHdcoav() != null) {
			where.append(" AND t1.HDCOAV = ?");
			params.add(hechodenunciado.getHdcoav());
		}
		if (hechodenunciado != null && hechodenunciado.getHdnops() != null) {
			where.append(" AND t1.HDNOPS = ?");
			params.add(hechodenunciado.getHdnops());
		}
		if (hechodenunciado != null && hechodenunciado.getHdnomaps() != null) {
			where.append(" AND t1.HDNOMAPS = ?");
			params.add(hechodenunciado.getHdnomaps());
		}
		if (hechodenunciado != null && hechodenunciado.getHdnomops() != null) {
			where.append(" AND t1.HDNOMOPS = ?");
			params.add(hechodenunciado.getHdnomops());
		}
		if (hechodenunciado != null && hechodenunciado.getHdnrlops() != null) {
			where.append(" AND t1.HDNRLOPS = ?");
			params.add(hechodenunciado.getHdnrlops());
		}
		if (hechodenunciado != null && hechodenunciado.getHdcodigobarras() != null) {
			where.append(" AND t1.HDCODIGOBARRAS = ?");
			params.add(hechodenunciado.getHdcodigobarras());
		}
		if (hechodenunciado != null && hechodenunciado.getHdinteresado() != null) {
			where.append(" AND t1.HDINTERESADO = ?");
			params.add(hechodenunciado.getHdinteresado());
		}
		if (hechodenunciado != null && hechodenunciado.getHdfedmps() != null) {
			where.append(" AND t1.HDFEDMPS = ?");
			params.add(hechodenunciado.getHdfedmps());
		}
		if (hechodenunciado != null && hechodenunciado.getHdinsotr() != null) {
			where.append(" AND t1.HDINSOTR = ?");
			params.add(hechodenunciado.getHdinsotr());
		}
		if (hechodenunciado != null && hechodenunciado.getHdinsoma() != null) {
			where.append(" AND t1.HDINSOMA = ?");
			params.add(hechodenunciado.getHdinsoma());
		}
		if (hechodenunciado != null && hechodenunciado.getHdcaptso() != null) {
			where.append(" AND t1.HDCAPTSO = ?");
			params.add(hechodenunciado.getHdcaptso());
		}
		if (hechodenunciado != null && hechodenunciado.getHdteso() != null) {
			where.append(" AND t1.HDTESO = ?");
			params.add(hechodenunciado.getHdteso());
		}
		if (hechodenunciado != null && hechodenunciado.getHdfeardt() != null) {
			where.append(" AND t1.HDFEARDT = ?");
			params.add(hechodenunciado.getHdfeardt());
		}
		if (hechodenunciado != null && hechodenunciado.getHdfeiohd() != null) {
			where.append(" AND t1.HDFEIOHD = ?");
			params.add(hechodenunciado.getHdfeiohd());
		}
		if (hechodenunciado != null && hechodenunciado.getHdininin() != null) {
			where.append(" AND t1.HDINININ = ?");
			params.add(hechodenunciado.getHdininin());
		}
		if (hechodenunciado != null && hechodenunciado.getHdfeiopc() != null) {
			where.append(" AND t1.HDFEIOPC = ?");
			params.add(hechodenunciado.getHdfeiopc());
		}
		if (hechodenunciado != null && hechodenunciado.getHdferopc() != null) {
			where.append(" AND t1.HDFEROPC = ?");
			params.add(hechodenunciado.getHdferopc());
		}
		if (hechodenunciado != null && hechodenunciado.getHdcorepc() != null) {
			where.append(" AND t1.HDCOREPC = ?");
			params.add(hechodenunciado.getHdcorepc());
		}
		if (hechodenunciado != null && hechodenunciado.getHdfeiorp() != null) {
			where.append(" AND t1.HDFEIORP = ?");
			params.add(hechodenunciado.getHdfeiorp());
		}
		if (hechodenunciado != null && hechodenunciado.getHdferorp() != null) {
			where.append(" AND t1.HDFERORP = ?");
			params.add(hechodenunciado.getHdferorp());
		}
		if (hechodenunciado != null && hechodenunciado.getHdcoreap() != null) {
			where.append(" AND t1.HDCOREAP = ?");
			params.add(hechodenunciado.getHdcoreap());
		}
		if (hechodenunciado != null && hechodenunciado.getHdfeiora() != null) {
			where.append(" AND t1.HDFEIORA = ?");
			params.add(hechodenunciado.getHdfeiora());
		}
		if (hechodenunciado != null && hechodenunciado.getHdteacpa() != null) {
			where.append(" AND t1.HDTEACPA = ?");
			params.add(hechodenunciado.getHdteacpa());
		}
		if (hechodenunciado != null && hechodenunciado.getHdfeceac() != null) {
			where.append(" AND t1.HDFECEAC = ?");
			params.add(hechodenunciado.getHdfeceac());
		}
		if (hechodenunciado != null && hechodenunciado.getHdhoceac() != null) {
			where.append(" AND t1.HDHOCEAC = ?");
			params.add(hechodenunciado.getHdhoceac());
		}
		if (hechodenunciado != null && hechodenunciado.getHdfeioca() != null) {
			where.append(" AND t1.HDFEIOCA = ?");
			params.add(hechodenunciado.getHdfeioca());
		}
		if (hechodenunciado != null && hechodenunciado.getHdteacde() != null) {
			where.append(" AND t1.HDTEACDE = ?");
			params.add(hechodenunciado.getHdteacde());
		}
		if (hechodenunciado != null && hechodenunciado.getHdfeioac() != null) {
			where.append(" AND t1.HDFEIOAC = ?");
			params.add(hechodenunciado.getHdfeioac());
		}
		if (hechodenunciado != null && hechodenunciado.getHdfeiofc() != null) {
			where.append(" AND t1.HDFEIOFC = ?");
			params.add(hechodenunciado.getHdfeiofc());
		}
		if (hechodenunciado != null && hechodenunciado.getHdcotra() != null) {
			where.append(" AND t1.HDCOTRA = ?");
			params.add(hechodenunciado.getHdcotra());
		}
		if (hechodenunciado != null && hechodenunciado.getHdte02() != null) {
			where.append(" AND t1.HDTE02 = ?");
			params.add(hechodenunciado.getHdte02());
		}
		if (hechodenunciado != null && hechodenunciado.getHdte03() != null) {
			where.append(" AND t1.HDTE03 = ?");
			params.add(hechodenunciado.getHdte03());
		}
		if (hechodenunciado != null && hechodenunciado.getHdte04() != null) {
			where.append(" AND t1.HDTE04 = ?");
			params.add(hechodenunciado.getHdte04());
		}
		if (hechodenunciado != null && hechodenunciado.getHdte05() != null) {
			where.append(" AND t1.HDTE05 = ?");
			params.add(hechodenunciado.getHdte05());
		}
		if (hechodenunciado != null && hechodenunciado.getHdte06() != null) {
			where.append(" AND t1.HDTE06 = ?");
			params.add(hechodenunciado.getHdte06());
		}
		if (hechodenunciado != null && hechodenunciado.getHdte07() != null) {
			where.append(" AND t1.HDTE07 = ?");
			params.add(hechodenunciado.getHdte07());
		}
		if (hechodenunciado != null && hechodenunciado.getHdte08() != null) {
			where.append(" AND t1.HDTE08 = ?");
			params.add(hechodenunciado.getHdte08());
		}
		if (hechodenunciado != null && hechodenunciado.getHdte09() != null) {
			where.append(" AND t1.HDTE09 = ?");
			params.add(hechodenunciado.getHdte09());
		}
		if (hechodenunciado != null && hechodenunciado.getHdte10() != null) {
			where.append(" AND t1.HDTE10 = ?");
			params.add(hechodenunciado.getHdte10());
		}
		if (hechodenunciado != null && hechodenunciado.getHdcosc() != null) {
			where.append(" AND t1.HDCOSC = ?");
			params.add(hechodenunciado.getHdcosc());
		}
		if (hechodenunciado != null && hechodenunciado.getHdidal() != null) {
			where.append(" AND t1.HDIDAL = ?");
			params.add(hechodenunciado.getHdidal());
		}
		if (hechodenunciado != null && hechodenunciado.getHdferoad() != null) {
			where.append(" AND t1.HDFEROAD = ?");
			params.add(hechodenunciado.getHdferoad());
		}
		if (hechodenunciado != null && hechodenunciado.getHdferoat() != null) {
			where.append(" AND t1.HDFEROAT = ?");
			params.add(hechodenunciado.getHdferoat());
		}
		if (hechodenunciado != null && hechodenunciado.getHdtealdt() != null) {
			where.append(" AND t1.HDTEALDT = ?");
			params.add(hechodenunciado.getHdtealdt());
		}
		if (hechodenunciado != null && hechodenunciado.getHdtedeat() != null) {
			where.append(" AND t1.HDTEDEAT = ?");
			params.add(hechodenunciado.getHdtedeat());
		}
		if (hechodenunciado != null && hechodenunciado.getHdfedeat() != null) {
			where.append(" AND t1.HDFEDEAT = ?");
			params.add(hechodenunciado.getHdfedeat());
		}
		if (hechodenunciado != null && hechodenunciado.getHdfehd() != null) {
			where.append(" AND t1.HDFEHD = ?");
			params.add(hechodenunciado.getHdfehd());
		}
		if (hechodenunciado != null && hechodenunciado.getHdtedoade() != null) {
			where.append(" AND t1.HDTEDOADE = ?");
			params.add(hechodenunciado.getHdtedoade());
		}
		if (hechodenunciado != null && hechodenunciado.getHdtedoadi() != null) {
			where.append(" AND t1.HDTEDOADI = ?");
			params.add(hechodenunciado.getHdtedoadi());
		}
		if (hechodenunciado != null && hechodenunciado.getHdtedoadf() != null) {
			where.append(" AND t1.HDTEDOADF = ?");
			params.add(hechodenunciado.getHdtedoadf());
		}
		if (hechodenunciado != null && hechodenunciado.getHdtedoada() != null) {
			where.append(" AND t1.HDTEDOADA = ?");
			params.add(hechodenunciado.getHdtedoada());
		}
		if (hechodenunciado != null && hechodenunciado.getHdnopse() != null) {
			where.append(" AND t1.HDNOPSE = ?");
			params.add(hechodenunciado.getHdnopse());
		}
		if (hechodenunciado != null && hechodenunciado.getHdnopsi() != null) {
			where.append(" AND t1.HDNOPSI = ?");
			params.add(hechodenunciado.getHdnopsi());
		}
		if (hechodenunciado != null && hechodenunciado.getHdnopsf() != null) {
			where.append(" AND t1.HDNOPSF = ?");
			params.add(hechodenunciado.getHdnopsf());
		}
		if (hechodenunciado != null && hechodenunciado.getHdnopsa() != null) {
			where.append(" AND t1.HDNOPSA = ?");
			params.add(hechodenunciado.getHdnopsa());
		}
		if (hechodenunciado != null && hechodenunciado.getHdcocodigo() != null) {
			where.append(" AND t1.HDCOCODIGO = ?");
			params.add(hechodenunciado.getHdcocodigo());
		}

		if (hechodenunciado != null && hechodenunciado.getHdcodexpedienteorigen() != null) {
			where.append(" AND t1.HDCODEXPEDIENTEORIGEN = ?");
			params.add(hechodenunciado.getHdcodexpedienteorigen());
		}

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		}
		return (List<HechoDenunciado>) this.jdbcTemplate.query(query.toString(), rwMap, params.toArray());
	}

	/**
	 * Counts rows in the HechoDenunciado table.
	 * 
	 * @param hechodenunciado
	 *            HechoDenunciado
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(HechoDenunciado hechodenunciado) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(
				" WHERE 1=1  and t1.HDCODE= t2.DECODIGO(+) and t1.HDCOES= t3.ESCODIGO(+) and t1.HDCOSE= t4.SECODIGO(+) and t1.HDCOMO= t5.MOCODIGO(+) and t1.HDCOPS= t6.PSCODIGO(+) and t1.HDCOTSR= t7.TSRCODIGO(+) and t1.HDCOTIR= t8.TIRCODIGO(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  HECHO_DENUNCIADO t1   ,  DENUNCIA t2   ,  ESTABLECIMIENTO t3   ,  SECTOR t4   ,  CENSO_MONITOR t5   ,  PRODUCTO t6   ,  TIPO_RECLAMACION t7   ,  MOTIVO t8  ");
		if (hechodenunciado != null && hechodenunciado.getHdcodigo() != null) {
			where.append(" AND t1.HDCODIGO = ?");
			params.add(hechodenunciado.getHdcodigo());
		}
		if (hechodenunciado != null && hechodenunciado.getDenuncia() != null
				&& hechodenunciado.getDenuncia().getDecodigo() != null) {
			where.append(" AND t2.DECODIGO = ?");
			params.add(hechodenunciado.getDenuncia().getDecodigo());
		}
		if (hechodenunciado != null && hechodenunciado.getDenuncia() != null
				&& hechodenunciado.getDenuncia().getFormaPresentacion() != null
				&& hechodenunciado.getDenuncia().getFormaPresentacion().getTfpcodigo() != null) {
			where.append(" AND t2.DECOTFP = ?");
			params.add(hechodenunciado.getDenuncia().getFormaPresentacion().getTfpcodigo());
		}
		if (hechodenunciado != null && hechodenunciado.getDenuncia() != null
				&& hechodenunciado.getDenuncia().getConsumidor() != null
				&& hechodenunciado.getDenuncia().getConsumidor().getDtcodigo() != null) {
			where.append(" AND t2.DECODT = ?");
			params.add(hechodenunciado.getDenuncia().getConsumidor().getDtcodigo());
		}
		if (hechodenunciado != null && hechodenunciado.getDenuncia() != null
				&& hechodenunciado.getDenuncia().getDecocp() != null) {
			where.append(" AND t2.DECOCP = ?");
			params.add(hechodenunciado.getDenuncia().getDecocp());
		}
		if (hechodenunciado != null && hechodenunciado.getDenuncia() != null
				&& hechodenunciado.getDenuncia().getDecoor() != null) {
			where.append(" AND t2.DECOOR = ?");
			params.add(hechodenunciado.getDenuncia().getDecoor());
		}
		if (hechodenunciado != null && hechodenunciado.getDenuncia() != null
				&& hechodenunciado.getDenuncia().getDenran() != null) {
			where.append(" AND t2.DENRAN = ?");
			params.add(hechodenunciado.getDenuncia().getDenran());
		}
		if (hechodenunciado != null && hechodenunciado.getDenuncia() != null
				&& hechodenunciado.getDenuncia().getDenror() != null) {
			where.append(" AND t2.DENROR = ?");
			params.add(hechodenunciado.getDenuncia().getDenror());
		}
		if (hechodenunciado != null && hechodenunciado.getDenuncia() != null
				&& hechodenunciado.getDenuncia().getDefede() != null) {
			where.append(" AND t2.DEFEDE = ?");
			params.add(hechodenunciado.getDenuncia().getDefede());
		}
		if (hechodenunciado != null && hechodenunciado.getDenuncia() != null
				&& hechodenunciado.getDenuncia().getDefere() != null) {
			where.append(" AND t2.DEFERE = ?");
			params.add(hechodenunciado.getDenuncia().getDefere());
		}
		if (hechodenunciado != null && hechodenunciado.getDenuncia() != null
				&& hechodenunciado.getDenuncia().getDefeex() != null) {
			where.append(" AND t2.DEFEEX = ?");
			params.add(hechodenunciado.getDenuncia().getDefeex());
		}
		if (hechodenunciado != null && hechodenunciado.getDenuncia() != null
				&& hechodenunciado.getDenuncia().getDefeim() != null) {
			where.append(" AND t2.DEFEIM = ?");
			params.add(hechodenunciado.getDenuncia().getDefeim());
		}
		if (hechodenunciado != null && hechodenunciado.getDenuncia() != null
				&& hechodenunciado.getDenuncia().getDeinre() != null) {
			where.append(" AND t2.DEINRE = ?");
			params.add(hechodenunciado.getDenuncia().getDeinre());
		}
		if (hechodenunciado != null && hechodenunciado.getDenuncia() != null
				&& hechodenunciado.getDenuncia().getDenrrgen() != null) {
			where.append(" AND t2.DENRRGEN = ?");
			params.add(hechodenunciado.getDenuncia().getDenrrgen());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEscodigo() != null) {
			where.append(" AND t3.ESCODIGO = ?");
			params.add(hechodenunciado.getEstablecimiento().getEscodigo());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getCensoMonitor() != null
				&& hechodenunciado.getEstablecimiento().getCensoMonitor().getMocodigo() != null) {
			where.append(" AND t3.ESCOZS = ?");
			params.add(hechodenunciado.getEstablecimiento().getCensoMonitor().getMocodigo());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnombre() != null) {
			where.append(" AND t3.ESNOMBRE = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsnombre());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnif() != null) {
			where.append(" AND t3.ESNIF = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsnif());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnoan() != null) {
			where.append(" AND t3.ESNOAN = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsnoan());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnoco() != null) {
			where.append(" AND t3.ESNOCO = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsnoco());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnodir() != null) {
			where.append(" AND t3.ESNODIR = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsnodir());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEscolo() != null) {
			where.append(" AND t3.ESCOLO = ?");
			params.add(hechodenunciado.getEstablecimiento().getEscolo());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnrcopo() != null) {
			where.append(" AND t3.ESNRCOPO = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsnrcopo());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnrtel() != null) {
			where.append(" AND t3.ESNRTEL = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsnrtel());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnrfax() != null) {
			where.append(" AND t3.ESNRFAX = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsnrfax());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEscopa() != null) {
			where.append(" AND t3.ESCOPA = ?");
			params.add(hechodenunciado.getEstablecimiento().getEscopa());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsincapr() != null) {
			where.append(" AND t3.ESINCAPR = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsincapr());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsindemp() != null) {
			where.append(" AND t3.ESINDEMP = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsindemp());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsteco() != null) {
			where.append(" AND t3.ESTECO = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsteco());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsinadar() != null) {
			where.append(" AND t3.ESINADAR = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsinadar());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsfeadar() != null) {
			where.append(" AND t3.ESFEADAR = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsfeadar());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEscoem() != null) {
			where.append(" AND t3.ESCOEM = ?");
			params.add(hechodenunciado.getEstablecimiento().getEscoem());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsinempr() != null) {
			where.append(" AND t3.ESINEMPR = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsinempr());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnrtel2() != null) {
			where.append(" AND t3.ESNRTEL2 = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsnrtel2());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsfeba() != null) {
			where.append(" AND t3.ESFEBA = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsfeba());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnoap1() != null) {
			where.append(" AND t3.ESNOAP1 = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsnoap1());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnoap2() != null) {
			where.append(" AND t3.ESNOAP2 = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsnoap2());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnolo() != null) {
			where.append(" AND t3.ESNOLO = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsnolo());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEscomapv() != null) {
			where.append(" AND t3.ESCOMAPV = ?");
			params.add(hechodenunciado.getEstablecimiento().getEscomapv());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEscoca() != null) {
			where.append(" AND t3.ESCOCA = ?");
			params.add(hechodenunciado.getEstablecimiento().getEscoca());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnopeco() != null) {
			where.append(" AND t3.ESNOPECO = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsnopeco());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEscoidco() != null) {
			where.append(" AND t3.ESCOIDCO = ?");
			params.add(hechodenunciado.getEstablecimiento().getEscoidco());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsinreco() != null) {
			where.append(" AND t3.ESINRECO = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsinreco());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsfemod() != null) {
			where.append(" AND t3.ESFEMOD = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsfemod());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsinesco() != null) {
			where.append(" AND t3.ESINESCO = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsinesco());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnomu() != null) {
			where.append(" AND t3.ESNOMU = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsnomu());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnorep() != null) {
			where.append(" AND t3.ESNOREP = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsnorep());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnifrep() != null) {
			where.append(" AND t3.ESNIFREP = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsnifrep());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getDtteemr() != null) {
			where.append(" AND t3.DTTEEMR = ?");
			params.add(hechodenunciado.getEstablecimiento().getDtteemr());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEscarep() != null) {
			where.append(" AND t3.ESCAREP = ?");
			params.add(hechodenunciado.getEstablecimiento().getEscarep());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsteurl() != null) {
			where.append(" AND t3.ESTEURL = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsteurl());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEscooe() != null) {
			where.append(" AND t3.ESCOOE = ?");
			params.add(hechodenunciado.getEstablecimiento().getEscooe());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnodeco() != null) {
			where.append(" AND t3.ESNODECO = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsnodeco());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsintiar() != null) {
			where.append(" AND t3.ESINTIAR = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsintiar());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsfeplad() != null) {
			where.append(" AND t3.ESFEPLAD = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsfeplad());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsindeme() != null) {
			where.append(" AND t3.ESINDEME = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsindeme());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnoraPaisId() != null) {
			where.append(" AND t3.ESNORA_PAIS_ID = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsnoraPaisId());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnoraPaisNombre() != null) {
			where.append(" AND t3.ESNORA_PAIS_NOMBRE = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsnoraPaisNombre());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnoraProvinciaId() != null) {
			where.append(" AND t3.ESNORA_PROVINCIA_ID = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsnoraProvinciaId());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnombreProvincia() != null) {
			where.append(" AND t3.ESNOMBRE_PROVINCIA = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsnombreProvincia());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnoraMunicipioId() != null) {
			where.append(" AND t3.ESNORA_MUNICIPIO_ID = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsnoraMunicipioId());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnombreMunicipio() != null) {
			where.append(" AND t3.ESNOMBRE_MUNICIPIO = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsnombreMunicipio());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnoraLocalidadId() != null) {
			where.append(" AND t3.ESNORA_LOCALIDAD_ID = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsnoraLocalidadId());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnombreLocalidad() != null) {
			where.append(" AND t3.ESNOMBRE_LOCALIDAD = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsnombreLocalidad());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnoraCalleId() != null) {
			where.append(" AND t3.ESNORA_CALLE_ID = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsnoraCalleId());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnombreCalle() != null) {
			where.append(" AND t3.ESNOMBRE_CALLE = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsnombreCalle());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnoraCpId() != null) {
			where.append(" AND t3.ESNORA_CP_ID = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsnoraCpId());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnombreCp() != null) {
			where.append(" AND t3.ESNOMBRE_CP = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsnombreCp());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnoraPortalId() != null) {
			where.append(" AND t3.ESNORA_PORTAL_ID = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsnoraPortalId());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnombrePortal() != null) {
			where.append(" AND t3.ESNOMBRE_PORTAL = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsnombrePortal());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnombrePiso() != null) {
			where.append(" AND t3.ESNOMBRE_PISO = ?");
			params.add(hechodenunciado.getEstablecimiento().getEsnombrePiso());
		}
		if (hechodenunciado != null && hechodenunciado.getSector() != null
				&& hechodenunciado.getSector().getSecodigo() != null) {
			where.append(" AND t4.SECODIGO = ?");
			params.add(hechodenunciado.getSector().getSecodigo());
		}
		if (hechodenunciado != null && hechodenunciado.getSector() != null
				&& hechodenunciado.getSector().getSectorAgrupado() != null
				&& hechodenunciado.getSector().getSectorAgrupado().getL0codigo() != null) {
			where.append(" AND t4.SECOL0 = ?");
			params.add(hechodenunciado.getSector().getSectorAgrupado().getL0codigo());
		}
		if (hechodenunciado != null && hechodenunciado.getSector() != null
				&& hechodenunciado.getSector().getSenombre() != null) {
			where.append(" AND t4.SENOMBRE = ?");
			params.add(hechodenunciado.getSector().getSenombre());
		}
		if (hechodenunciado != null && hechodenunciado.getSector() != null
				&& hechodenunciado.getSector().getSenoco() != null) {
			where.append(" AND t4.SENOCO = ?");
			params.add(hechodenunciado.getSector().getSenoco());
		}
		if (hechodenunciado != null && hechodenunciado.getSector() != null
				&& hechodenunciado.getSector().getSedescri() != null) {
			where.append(" AND t4.SEDESCRI = ?");
			params.add(hechodenunciado.getSector().getSedescri());
		}
		if (hechodenunciado != null && hechodenunciado.getSector() != null
				&& hechodenunciado.getSector().getSecose() != null) {
			where.append(" AND t4.SECOSE = ?");
			params.add(hechodenunciado.getSector().getSecose());
		}
		if (hechodenunciado != null && hechodenunciado.getSector() != null
				&& hechodenunciado.getSector().getSenoco2() != null) {
			where.append(" AND t4.SENOCO2 = ?");
			params.add(hechodenunciado.getSector().getSenoco2());
		}
		if (hechodenunciado != null && hechodenunciado.getSector() != null
				&& hechodenunciado.getSector().getSeinsel1() != null) {
			where.append(" AND t4.SEINSEL1 = ?");
			params.add(hechodenunciado.getSector().getSeinsel1());
		}
		if (hechodenunciado != null && hechodenunciado.getSector() != null
				&& hechodenunciado.getSector().getSenombree() != null) {
			where.append(" AND t4.SENOMBREE = ?");
			params.add(hechodenunciado.getSector().getSenombree());
		}
		if (hechodenunciado != null && hechodenunciado.getSector() != null
				&& hechodenunciado.getSector().getSenombrei() != null) {
			where.append(" AND t4.SENOMBREI = ?");
			params.add(hechodenunciado.getSector().getSenombrei());
		}
		if (hechodenunciado != null && hechodenunciado.getSector() != null
				&& hechodenunciado.getSector().getSenombref() != null) {
			where.append(" AND t4.SENOMBREF = ?");
			params.add(hechodenunciado.getSector().getSenombref());
		}
		if (hechodenunciado != null && hechodenunciado.getSector() != null
				&& hechodenunciado.getSector().getSenocoe() != null) {
			where.append(" AND t4.SENOCOE = ?");
			params.add(hechodenunciado.getSector().getSenocoe());
		}
		if (hechodenunciado != null && hechodenunciado.getSector() != null
				&& hechodenunciado.getSector().getSenocoi() != null) {
			where.append(" AND t4.SENOCOI = ?");
			params.add(hechodenunciado.getSector().getSenocoi());
		}
		if (hechodenunciado != null && hechodenunciado.getSector() != null
				&& hechodenunciado.getSector().getSenocof() != null) {
			where.append(" AND t4.SENOCOF = ?");
			params.add(hechodenunciado.getSector().getSenocof());
		}
		if (hechodenunciado != null && hechodenunciado.getSector() != null
				&& hechodenunciado.getSector().getSedescrie() != null) {
			where.append(" AND t4.SEDESCRIE = ?");
			params.add(hechodenunciado.getSector().getSedescrie());
		}
		if (hechodenunciado != null && hechodenunciado.getSector() != null
				&& hechodenunciado.getSector().getSedescrii() != null) {
			where.append(" AND t4.SEDESCRII = ?");
			params.add(hechodenunciado.getSector().getSedescrii());
		}
		if (hechodenunciado != null && hechodenunciado.getSector() != null
				&& hechodenunciado.getSector().getSedescrif() != null) {
			where.append(" AND t4.SEDESCRIF = ?");
			params.add(hechodenunciado.getSector().getSedescrif());
		}
		if (hechodenunciado != null && hechodenunciado.getSector() != null
				&& hechodenunciado.getSector().getSecodgrupo() != null) {
			where.append(" AND t4.SECODGRUPO = ?");
			params.add(hechodenunciado.getSector().getSecodgrupo());
		}
		if (hechodenunciado != null && hechodenunciado.getSector() != null
				&& hechodenunciado.getSector().getSenombrea() != null) {
			where.append(" AND t4.SENOMBREA = ?");
			params.add(hechodenunciado.getSector().getSenombrea());
		}
		if (hechodenunciado != null && hechodenunciado.getSector() != null
				&& hechodenunciado.getSector().getSedescria() != null) {
			where.append(" AND t4.SEDESCRIA = ?");
			params.add(hechodenunciado.getSector().getSedescria());
		}
		if (hechodenunciado != null && hechodenunciado.getSector() != null
				&& hechodenunciado.getSector().getSenocoa() != null) {
			where.append(" AND t4.SENOCOA = ?");
			params.add(hechodenunciado.getSector().getSenocoa());
		}
		if (hechodenunciado != null && hechodenunciado.getCensoMonitor() != null
				&& hechodenunciado.getCensoMonitor().getMocodigo() != null) {
			where.append(" AND t5.MOCODIGO = ?");
			params.add(hechodenunciado.getCensoMonitor().getMocodigo());
		}
		if (hechodenunciado != null && hechodenunciado.getCensoMonitor() != null
				&& hechodenunciado.getCensoMonitor().getOrganismo() != null
				&& hechodenunciado.getCensoMonitor().getOrganismo().getCodOrg() != null) {
			where.append(" AND t5.MOCOOR = ?");
			params.add(hechodenunciado.getCensoMonitor().getOrganismo().getCodOrg());
		}
		if (hechodenunciado != null && hechodenunciado.getCensoMonitor() != null
				&& hechodenunciado.getCensoMonitor().getMonombre() != null) {
			where.append(" AND t5.MONOMBRE = ?");
			params.add(hechodenunciado.getCensoMonitor().getMonombre());
		}
		if (hechodenunciado != null && hechodenunciado.getCensoMonitor() != null
				&& hechodenunciado.getCensoMonitor().getMocoem() != null) {
			where.append(" AND t5.MOCOEM = ?");
			params.add(hechodenunciado.getCensoMonitor().getMocoem());
		}
		if (hechodenunciado != null && hechodenunciado.getCensoMonitor() != null
				&& hechodenunciado.getCensoMonitor().getMofecbaja() != null) {
			where.append(" AND t5.MOFECBAJA = ?");
			params.add(hechodenunciado.getCensoMonitor().getMofecbaja());
		}

		if (hechodenunciado != null && hechodenunciado.getProducto() != null
				&& hechodenunciado.getProducto().getPscodigo() != null) {
			where.append(" AND t6.PSCODIGO = ?");
			params.add(hechodenunciado.getProducto().getPscodigo());
		}
		if (hechodenunciado != null && hechodenunciado.getProducto() != null
				&& hechodenunciado.getProducto().getProdAgrupado() != null
				&& hechodenunciado.getProducto().getProdAgrupado().getE8codigo() != null) {
			where.append(" AND t6.PSCOE8 = ?");
			params.add(hechodenunciado.getProducto().getProdAgrupado().getE8codigo());
		}
		if (hechodenunciado != null && hechodenunciado.getProducto() != null
				&& hechodenunciado.getProducto().getPsnombre() != null) {
			where.append(" AND t6.PSNOMBRE = ?");
			params.add(hechodenunciado.getProducto().getPsnombre());
		}
		if (hechodenunciado != null && hechodenunciado.getProducto() != null
				&& hechodenunciado.getProducto().getPsnoco() != null) {
			where.append(" AND t6.PSNOCO = ?");
			params.add(hechodenunciado.getProducto().getPsnoco());
		}
		if (hechodenunciado != null && hechodenunciado.getProducto() != null
				&& hechodenunciado.getProducto().getPsdescri() != null) {
			where.append(" AND t6.PSDESCRI = ?");
			params.add(hechodenunciado.getProducto().getPsdescri());
		}
		if (hechodenunciado != null && hechodenunciado.getProducto() != null
				&& hechodenunciado.getProducto().getPscose() != null) {
			where.append(" AND t6.PSCOSE = ?");
			params.add(hechodenunciado.getProducto().getPscose());
		}
		if (hechodenunciado != null && hechodenunciado.getProducto() != null
				&& hechodenunciado.getProducto().getPsnombree() != null) {
			where.append(" AND t6.PSNOMBREE = ?");
			params.add(hechodenunciado.getProducto().getPsnombree());
		}
		if (hechodenunciado != null && hechodenunciado.getProducto() != null
				&& hechodenunciado.getProducto().getPsnombrei() != null) {
			where.append(" AND t6.PSNOMBREI = ?");
			params.add(hechodenunciado.getProducto().getPsnombrei());
		}
		if (hechodenunciado != null && hechodenunciado.getProducto() != null
				&& hechodenunciado.getProducto().getPsnombref() != null) {
			where.append(" AND t6.PSNOMBREF = ?");
			params.add(hechodenunciado.getProducto().getPsnombref());
		}
		if (hechodenunciado != null && hechodenunciado.getProducto() != null
				&& hechodenunciado.getProducto().getPsnombrea() != null) {
			where.append(" AND t6.PSNOMBREA = ?");
			params.add(hechodenunciado.getProducto().getPsnombrea());
		}
		if (hechodenunciado != null && hechodenunciado.getProducto() != null
				&& hechodenunciado.getProducto().getPsnocoe() != null) {
			where.append(" AND t6.PSNOCOE = ?");
			params.add(hechodenunciado.getProducto().getPsnocoe());
		}
		if (hechodenunciado != null && hechodenunciado.getProducto() != null
				&& hechodenunciado.getProducto().getPsnocoi() != null) {
			where.append(" AND t6.PSNOCOI = ?");
			params.add(hechodenunciado.getProducto().getPsnocoi());
		}
		if (hechodenunciado != null && hechodenunciado.getProducto() != null
				&& hechodenunciado.getProducto().getPsnocof() != null) {
			where.append(" AND t6.PSNOCOF = ?");
			params.add(hechodenunciado.getProducto().getPsnocof());
		}
		if (hechodenunciado != null && hechodenunciado.getProducto() != null
				&& hechodenunciado.getProducto().getPsnocoa() != null) {
			where.append(" AND t6.PSNOCOA = ?");
			params.add(hechodenunciado.getProducto().getPsnocoa());
		}
		if (hechodenunciado != null && hechodenunciado.getProducto() != null
				&& hechodenunciado.getProducto().getPsdescrie() != null) {
			where.append(" AND t6.PSDESCRIE = ?");
			params.add(hechodenunciado.getProducto().getPsdescrie());
		}
		if (hechodenunciado != null && hechodenunciado.getProducto() != null
				&& hechodenunciado.getProducto().getPsdescrii() != null) {
			where.append(" AND t6.PSDESCRII = ?");
			params.add(hechodenunciado.getProducto().getPsdescrii());
		}
		if (hechodenunciado != null && hechodenunciado.getProducto() != null
				&& hechodenunciado.getProducto().getPsdescrif() != null) {
			where.append(" AND t6.PSDESCRIF = ?");
			params.add(hechodenunciado.getProducto().getPsdescrif());
		}
		if (hechodenunciado != null && hechodenunciado.getProducto() != null
				&& hechodenunciado.getProducto().getPsdescria() != null) {
			where.append(" AND t6.PSDESCRIA = ?");
			params.add(hechodenunciado.getProducto().getPsdescria());
		}
		if (hechodenunciado != null && hechodenunciado.getProducto() != null
				&& hechodenunciado.getProducto().getPssel1() != null) {
			where.append(" AND t6.PSSEL1 = ?");
			params.add(hechodenunciado.getProducto().getPssel1());
		}
		if (hechodenunciado != null && hechodenunciado.getProducto() != null
				&& hechodenunciado.getProducto().getPscoinc() != null) {
			where.append(" AND t6.PSCOINC = ?");
			params.add(hechodenunciado.getProducto().getPscoinc());
		}
		if (hechodenunciado != null && hechodenunciado.getTipoReclamacion() != null
				&& hechodenunciado.getTipoReclamacion().getTsrcodigo() != null) {
			where.append(" AND t7.TSRCODIGO = ?");
			params.add(hechodenunciado.getTipoReclamacion().getTsrcodigo());
		}
		if (hechodenunciado != null && hechodenunciado.getTipoReclamacion() != null
				&& hechodenunciado.getTipoReclamacion().getTsrnombre() != null) {
			where.append(" AND t7.TSRNOMBRE = ?");
			params.add(hechodenunciado.getTipoReclamacion().getTsrnombre());
		}
		if (hechodenunciado != null && hechodenunciado.getTipoReclamacion() != null
				&& hechodenunciado.getTipoReclamacion().getTsrnombree() != null) {
			where.append(" AND t7.TSRNOMBREE = ?");
			params.add(hechodenunciado.getTipoReclamacion().getTsrnombree());
		}
		if (hechodenunciado != null && hechodenunciado.getTipoReclamacion() != null
				&& hechodenunciado.getTipoReclamacion().getTsrnombrei() != null) {
			where.append(" AND t7.TSRNOMBREI = ?");
			params.add(hechodenunciado.getTipoReclamacion().getTsrnombrei());
		}
		if (hechodenunciado != null && hechodenunciado.getTipoReclamacion() != null
				&& hechodenunciado.getTipoReclamacion().getTsrnombref() != null) {
			where.append(" AND t7.TSRNOMBREF = ?");
			params.add(hechodenunciado.getTipoReclamacion().getTsrnombref());
		}
		if (hechodenunciado != null && hechodenunciado.getTipoReclamacion() != null
				&& hechodenunciado.getTipoReclamacion().getTsrnombrea() != null) {
			where.append(" AND t7.TSRNOMBREA = ?");
			params.add(hechodenunciado.getTipoReclamacion().getTsrnombrea());
		}
		if (hechodenunciado != null && hechodenunciado.getMotivo() != null
				&& hechodenunciado.getMotivo().getTircodigo() != null) {
			where.append(" AND t8.TIRCODIGO = ?");
			params.add(hechodenunciado.getMotivo().getTircodigo());
		}
		if (hechodenunciado != null && hechodenunciado.getMotivo() != null
				&& hechodenunciado.getMotivo().getTirnombre() != null) {
			where.append(" AND t8.TIRNOMBRE = ?");
			params.add(hechodenunciado.getMotivo().getTirnombre());
		}
		if (hechodenunciado != null && hechodenunciado.getHdnror() != null) {
			where.append(" AND t1.HDNROR = ?");
			params.add(hechodenunciado.getHdnror());
		}
		if (hechodenunciado != null && hechodenunciado.getHdte() != null) {
			where.append(" AND t1.HDTE = ?");
			params.add(hechodenunciado.getHdte());
		}
		if (hechodenunciado != null && hechodenunciado.getHdtedoad() != null) {
			where.append(" AND t1.HDTEDOAD = ?");
			params.add(hechodenunciado.getHdtedoad());
		}
		if (hechodenunciado != null && hechodenunciado.getHdcoav() != null) {
			where.append(" AND t1.HDCOAV = ?");
			params.add(hechodenunciado.getHdcoav());
		}
		if (hechodenunciado != null && hechodenunciado.getHdnops() != null) {
			where.append(" AND t1.HDNOPS = ?");
			params.add(hechodenunciado.getHdnops());
		}
		if (hechodenunciado != null && hechodenunciado.getHdnomaps() != null) {
			where.append(" AND t1.HDNOMAPS = ?");
			params.add(hechodenunciado.getHdnomaps());
		}
		if (hechodenunciado != null && hechodenunciado.getHdnomops() != null) {
			where.append(" AND t1.HDNOMOPS = ?");
			params.add(hechodenunciado.getHdnomops());
		}
		if (hechodenunciado != null && hechodenunciado.getHdnrlops() != null) {
			where.append(" AND t1.HDNRLOPS = ?");
			params.add(hechodenunciado.getHdnrlops());
		}
		if (hechodenunciado != null && hechodenunciado.getHdfedmps() != null) {
			where.append(" AND t1.HDFEDMPS = ?");
			params.add(hechodenunciado.getHdfedmps());
		}
		if (hechodenunciado != null && hechodenunciado.getHdinsotr() != null) {
			where.append(" AND t1.HDINSOTR = ?");
			params.add(hechodenunciado.getHdinsotr());
		}
		if (hechodenunciado != null && hechodenunciado.getHdinsoma() != null) {
			where.append(" AND t1.HDINSOMA = ?");
			params.add(hechodenunciado.getHdinsoma());
		}
		if (hechodenunciado != null && hechodenunciado.getHdcaptso() != null) {
			where.append(" AND t1.HDCAPTSO = ?");
			params.add(hechodenunciado.getHdcaptso());
		}
		if (hechodenunciado != null && hechodenunciado.getHdteso() != null) {
			where.append(" AND t1.HDTESO = ?");
			params.add(hechodenunciado.getHdteso());
		}
		if (hechodenunciado != null && hechodenunciado.getHdfeardt() != null) {
			where.append(" AND t1.HDFEARDT = ?");
			params.add(hechodenunciado.getHdfeardt());
		}
		if (hechodenunciado != null && hechodenunciado.getHdfeiohd() != null) {
			where.append(" AND t1.HDFEIOHD = ?");
			params.add(hechodenunciado.getHdfeiohd());
		}
		if (hechodenunciado != null && hechodenunciado.getHdininin() != null) {
			where.append(" AND t1.HDINININ = ?");
			params.add(hechodenunciado.getHdininin());
		}
		if (hechodenunciado != null && hechodenunciado.getHdfeiopc() != null) {
			where.append(" AND t1.HDFEIOPC = ?");
			params.add(hechodenunciado.getHdfeiopc());
		}
		if (hechodenunciado != null && hechodenunciado.getHdferopc() != null) {
			where.append(" AND t1.HDFEROPC = ?");
			params.add(hechodenunciado.getHdferopc());
		}
		if (hechodenunciado != null && hechodenunciado.getHdcorepc() != null) {
			where.append(" AND t1.HDCOREPC = ?");
			params.add(hechodenunciado.getHdcorepc());
		}
		if (hechodenunciado != null && hechodenunciado.getHdfeiorp() != null) {
			where.append(" AND t1.HDFEIORP = ?");
			params.add(hechodenunciado.getHdfeiorp());
		}
		if (hechodenunciado != null && hechodenunciado.getHdferorp() != null) {
			where.append(" AND t1.HDFERORP = ?");
			params.add(hechodenunciado.getHdferorp());
		}
		if (hechodenunciado != null && hechodenunciado.getHdcoreap() != null) {
			where.append(" AND t1.HDCOREAP = ?");
			params.add(hechodenunciado.getHdcoreap());
		}
		if (hechodenunciado != null && hechodenunciado.getHdfeiora() != null) {
			where.append(" AND t1.HDFEIORA = ?");
			params.add(hechodenunciado.getHdfeiora());
		}
		if (hechodenunciado != null && hechodenunciado.getHdteacpa() != null) {
			where.append(" AND t1.HDTEACPA = ?");
			params.add(hechodenunciado.getHdteacpa());
		}
		if (hechodenunciado != null && hechodenunciado.getHdfeceac() != null) {
			where.append(" AND t1.HDFECEAC = ?");
			params.add(hechodenunciado.getHdfeceac());
		}
		if (hechodenunciado != null && hechodenunciado.getHdhoceac() != null) {
			where.append(" AND t1.HDHOCEAC = ?");
			params.add(hechodenunciado.getHdhoceac());
		}
		if (hechodenunciado != null && hechodenunciado.getHdfeioca() != null) {
			where.append(" AND t1.HDFEIOCA = ?");
			params.add(hechodenunciado.getHdfeioca());
		}
		if (hechodenunciado != null && hechodenunciado.getHdteacde() != null) {
			where.append(" AND t1.HDTEACDE = ?");
			params.add(hechodenunciado.getHdteacde());
		}
		if (hechodenunciado != null && hechodenunciado.getHdfeioac() != null) {
			where.append(" AND t1.HDFEIOAC = ?");
			params.add(hechodenunciado.getHdfeioac());
		}
		if (hechodenunciado != null && hechodenunciado.getHdfeiofc() != null) {
			where.append(" AND t1.HDFEIOFC = ?");
			params.add(hechodenunciado.getHdfeiofc());
		}
		if (hechodenunciado != null && hechodenunciado.getHdcotra() != null) {
			where.append(" AND t1.HDCOTRA = ?");
			params.add(hechodenunciado.getHdcotra());
		}
		if (hechodenunciado != null && hechodenunciado.getHdte02() != null) {
			where.append(" AND t1.HDTE02 = ?");
			params.add(hechodenunciado.getHdte02());
		}
		if (hechodenunciado != null && hechodenunciado.getHdte03() != null) {
			where.append(" AND t1.HDTE03 = ?");
			params.add(hechodenunciado.getHdte03());
		}
		if (hechodenunciado != null && hechodenunciado.getHdte04() != null) {
			where.append(" AND t1.HDTE04 = ?");
			params.add(hechodenunciado.getHdte04());
		}
		if (hechodenunciado != null && hechodenunciado.getHdte05() != null) {
			where.append(" AND t1.HDTE05 = ?");
			params.add(hechodenunciado.getHdte05());
		}
		if (hechodenunciado != null && hechodenunciado.getHdte06() != null) {
			where.append(" AND t1.HDTE06 = ?");
			params.add(hechodenunciado.getHdte06());
		}
		if (hechodenunciado != null && hechodenunciado.getHdte07() != null) {
			where.append(" AND t1.HDTE07 = ?");
			params.add(hechodenunciado.getHdte07());
		}
		if (hechodenunciado != null && hechodenunciado.getHdte08() != null) {
			where.append(" AND t1.HDTE08 = ?");
			params.add(hechodenunciado.getHdte08());
		}
		if (hechodenunciado != null && hechodenunciado.getHdte09() != null) {
			where.append(" AND t1.HDTE09 = ?");
			params.add(hechodenunciado.getHdte09());
		}
		if (hechodenunciado != null && hechodenunciado.getHdte10() != null) {
			where.append(" AND t1.HDTE10 = ?");
			params.add(hechodenunciado.getHdte10());
		}
		if (hechodenunciado != null && hechodenunciado.getHdcosc() != null) {
			where.append(" AND t1.HDCOSC = ?");
			params.add(hechodenunciado.getHdcosc());
		}
		if (hechodenunciado != null && hechodenunciado.getHdidal() != null) {
			where.append(" AND t1.HDIDAL = ?");
			params.add(hechodenunciado.getHdidal());
		}
		if (hechodenunciado != null && hechodenunciado.getHdferoad() != null) {
			where.append(" AND t1.HDFEROAD = ?");
			params.add(hechodenunciado.getHdferoad());
		}
		if (hechodenunciado != null && hechodenunciado.getHdferoat() != null) {
			where.append(" AND t1.HDFEROAT = ?");
			params.add(hechodenunciado.getHdferoat());
		}
		if (hechodenunciado != null && hechodenunciado.getHdtealdt() != null) {
			where.append(" AND t1.HDTEALDT = ?");
			params.add(hechodenunciado.getHdtealdt());
		}
		if (hechodenunciado != null && hechodenunciado.getHdtedeat() != null) {
			where.append(" AND t1.HDTEDEAT = ?");
			params.add(hechodenunciado.getHdtedeat());
		}
		if (hechodenunciado != null && hechodenunciado.getHdfedeat() != null) {
			where.append(" AND t1.HDFEDEAT = ?");
			params.add(hechodenunciado.getHdfedeat());
		}
		if (hechodenunciado != null && hechodenunciado.getHdfehd() != null) {
			where.append(" AND t1.HDFEHD = ?");
			params.add(hechodenunciado.getHdfehd());
		}
		if (hechodenunciado != null && hechodenunciado.getHdtedoade() != null) {
			where.append(" AND t1.HDTEDOADE = ?");
			params.add(hechodenunciado.getHdtedoade());
		}
		if (hechodenunciado != null && hechodenunciado.getHdtedoadi() != null) {
			where.append(" AND t1.HDTEDOADI = ?");
			params.add(hechodenunciado.getHdtedoadi());
		}
		if (hechodenunciado != null && hechodenunciado.getHdtedoadf() != null) {
			where.append(" AND t1.HDTEDOADF = ?");
			params.add(hechodenunciado.getHdtedoadf());
		}
		if (hechodenunciado != null && hechodenunciado.getHdtedoada() != null) {
			where.append(" AND t1.HDTEDOADA = ?");
			params.add(hechodenunciado.getHdtedoada());
		}
		if (hechodenunciado != null && hechodenunciado.getHdnopse() != null) {
			where.append(" AND t1.HDNOPSE = ?");
			params.add(hechodenunciado.getHdnopse());
		}
		if (hechodenunciado != null && hechodenunciado.getHdnopsi() != null) {
			where.append(" AND t1.HDNOPSI = ?");
			params.add(hechodenunciado.getHdnopsi());
		}
		if (hechodenunciado != null && hechodenunciado.getHdnopsf() != null) {
			where.append(" AND t1.HDNOPSF = ?");
			params.add(hechodenunciado.getHdnopsf());
		}
		if (hechodenunciado != null && hechodenunciado.getHdnopsa() != null) {
			where.append(" AND t1.HDNOPSA = ?");
			params.add(hechodenunciado.getHdnopsa());
		}
		if (hechodenunciado != null && hechodenunciado.getHdcocodigo() != null) {
			where.append(" AND t1.HDCOCODIGO = ?");
			params.add(hechodenunciado.getHdcocodigo());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Counts rows in the HechoDenunciado table.
	 * 
	 * @param hechodenunciado
	 *            HechoDenunciado
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllExpedientesAbiertosCount(HechoDenunciado hechodenunciado) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 and t1.HDCODE= t2.DECODIGO(+) ");
		where.append(" AND ((SELECT COUNT(1) FROM DECISION_HECHO WHERE HCCOHD = t1.HDCODIGO)=0 ");
		where.append(" OR (SELECT COUNT(1) FROM DECISION_HECHO WHERE HCCOHD = t1.HDCODIGO AND HCCOTTD IS NULL)> 0) ");

		StringBuffer query = new StringBuffer("SELECT COUNT(1) FROM  HECHO_DENUNCIADO t1,  DENUNCIA t2 ");
		if (hechodenunciado != null && hechodenunciado.getDenuncia() != null
				&& hechodenunciado.getDenuncia().getConsumidor() != null
				&& hechodenunciado.getDenuncia().getConsumidor().getDtcodigo() != null) {
			where.append(" AND t2.DECODT = ?");
			params.add(hechodenunciado.getDenuncia().getConsumidor().getDtcodigo());
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEscodigo() != null) {
			where.append(" AND t1.HDCOES = ?");
			params.add(hechodenunciado.getEstablecimiento().getEscodigo());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds rows in the HechoDenunciado table using like.
	 * 
	 * @param hechodenunciado
	 *            HechoDenunciado
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<HechoDenunciado> findAllLike(HechoDenunciado hechodenunciado, Pagination pagination,
			Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(
				" WHERE 1=1 AND t1.HDCODE= t2.DECODIGO(+) AND t1.HDCOES= t3.ESCODIGO(+) AND t1.HDCOSE= t4.SECODIGO(+) AND t1.HDCOMO= t5.MOCODIGO(+) AND t1.HDCOPS= t6.PSCODIGO(+) AND t1.HDCOTSR= t7.TSRCODIGO(+) AND t1.HDCOTIR= t8.TIRCODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.HDCODIGO HDCODIGO,t1.HDNROR HDNROR,t1.HDTE HDTE,t1.HDTEDOAD HDTEDOAD,t1.HDCOAV HDCOAV,t1.HDNOPS HDNOPS,t1.HDNOMAPS HDNOMAPS,t1.HDNOMOPS HDNOMOPS,t1.HDNRLOPS HDNRLOPS, t1.HDCODIGOBARRAS HDCODIGOBARRAS,t1.HDINTERESADO HDINTERESADO,t1.HDFEDMPS HDFEDMPS,t1.HDINSOTR HDINSOTR,t1.HDINSOMA HDINSOMA,t1.HDCAPTSO HDCAPTSO,t1.HDTESO HDTESO,t1.HDFEARDT HDFEARDT,t1.HDFEIOHD HDFEIOHD,t1.HDINININ HDINININ,t1.HDFEIOPC HDFEIOPC,t1.HDFEROPC HDFEROPC,t1.HDCOREPC HDCOREPC,t1.HDFEIORP HDFEIORP,t1.HDFERORP HDFERORP,t1.HDCOREAP HDCOREAP,t1.HDFEIORA HDFEIORA,t1.HDTEACPA HDTEACPA,t1.HDFECEAC HDFECEAC,t1.HDHOCEAC HDHOCEAC,t1.HDFEIOCA HDFEIOCA,t1.HDTEACDE HDTEACDE,t1.HDFEIOAC HDFEIOAC,t1.HDFEIOFC HDFEIOFC,t1.HDCOTRA HDCOTRA,t1.HDTE02 HDTE02,t1.HDTE03 HDTE03,t1.HDTE04 HDTE04,t1.HDTE05 HDTE05,t1.HDTE06 HDTE06,t1.HDTE07 HDTE07,t1.HDTE08 HDTE08,t1.HDTE09 HDTE09,t1.HDTE10 HDTE10,t1.HDCOSC HDCOSC,t1.HDIDAL HDIDAL,t1.HDFEROAD HDFEROAD,t1.HDFEROAT HDFEROAT,t1.HDTEALDT HDTEALDT,t1.HDTEDEAT HDTEDEAT,t1.HDFEDEAT HDFEDEAT,t1.HDFEHD HDFEHD,t1.HDTEDOADE HDTEDOADE,t1.HDTEDOADI HDTEDOADI,t1.HDTEDOADF HDTEDOADF,t1.HDTEDOADA HDTEDOADA,t1.HDNOPSE HDNOPSE,t1.HDNOPSI HDNOPSI,t1.HDNOPSF HDNOPSF,t1.HDNOPSA HDNOPSA,t1.HDCOCODIGO HDCOCODIGO,t2.DECODIGO DENUNCIADECODIGO,t2.DECOCP DENUNCIADECOCP,t2.DECOOR DENUNCIADECOOR,t2.DENRAN DENUNCIADENRAN,t2.DENROR DENUNCIADENROR,t2.DEFEDE DENUNCIADEFEDE,t2.DEFERE DENUNCIADEFERE,t2.DEFEEX DENUNCIADEFEEX,t2.DEFEIM DENUNCIADEFEIM,t2.DEINRE DENUNCIADEINRE,t2.DENRRGEN DENUNCIADENRRGEN,t3.ESCODIGO ESTABLECIMIENTOESCODIGO,t3.ESNOMBRE ESTABLECIMIENTOESNOMBRE, t3.ESTIPID ESTABLECIMIENTOESTIPID,t3.ESNIF ESTABLECIMIENTOESNIF,t3.ESNOAN ESTABLECIMIENTOESNOAN,t3.ESNOCO ESTABLECIMIENTOESNOCO,t3.ESNODIR ESTABLECIMIENTOESNODIR,t3.ESCOLO ESTABLECIMIENTOESCOLO,t3.ESNRCOPO ESTABLECIMIENTOESNRCOPO,t3.ESNRTEL ESTABLECIMIENTOESNRTEL,t3.ESNRFAX ESTABLECIMIENTOESNRFAX,t3.ESCOPA ESTABLECIMIENTOESCOPA,t3.ESINCAPR ESTABLECIMIENTOESINCAPR,t3.ESINDEMP ESTABLECIMIENTOESINDEMP,t3.ESTECO ESTABLECIMIENTOESTECO,t3.ESINADAR ESTABLECIMIENTOESINADAR,t3.ESFEADAR ESTABLECIMIENTOESFEADAR,t3.ESCOEM ESTABLECIMIENTOESCOEM,t3.ESINEMPR ESTABLECIMIENTOESINEMPR,t3.ESNRTEL2 ESTABLECIMIENTOESNRTEL2,t3.ESFEBA ESTABLECIMIENTOESFEBA,t3.ESNOAP1 ESTABLECIMIENTOESNOAP1,t3.ESNOAP2 ESTABLECIMIENTOESNOAP2,t3.ESNOLO ESTABLECIMIENTOESNOLO,t3.ESCOMAPV ESTABLECIMIENTOESCOMAPV,t3.ESCOCA ESTABLECIMIENTOESCOCA,t3.ESNOPECO ESTABLECIMIENTOESNOPECO,t3.ESCOIDCO ESTABLECIMIENTOESCOIDCO,t3.ESINRECO ESTABLECIMIENTOESINRECO,t3.ESFEMOD ESTABLECIMIENTOESFEMOD,t3.ESINESCO ESTABLECIMIENTOESINESCO,t3.ESNOMU ESTABLECIMIENTOESNOMU,t3.ESNOREP ESTABLECIMIENTOESNOREP,t3.ESNIFREP ESTABLECIMIENTOESNIFREP,t3.DTTEEMR ESTABLECIMIENTODTTEEMR,t3.ESCAREP ESTABLECIMIENTOESCAREP,t3.ESTEURL ESTABLECIMIENTOESTEURL,t3.ESCOOE ESTABLECIMIENTOESCOOE,t3.ESNODECO ESTABLECIMIENTOESNODECO,t3.ESINTIAR ESTABLECIMIENTOESINTIAR,t3.ESFEPLAD ESTABLECIMIENTOESFEPLAD,t3.ESINDEME ESTABLECIMIENTOESINDEME,t3.ESNORA_PAIS_ID ESTABLEESNORAPAISID,t3.ESNORA_PAIS_NOMBRE ESTABLEESNORAPAISNOMBRE,t3.ESNORA_PROVINCIA_ID ESTABLEESNORAPROVINCIAID,t3.ESNOMBRE_PROVINCIA ESTABLEESNOMBREPROVINCIA,t3.ESNORA_MUNICIPIO_ID ESTABLEESNORAMUNICIPIOID,t3.ESNOMBRE_MUNICIPIO ESTABLEESNOMBREMUNICIPIO,t3.ESNORA_LOCALIDAD_ID ESTABLEESNORALOCALIDADID,t3.ESNOMBRE_LOCALIDAD ESTABLEESNOMBRELOCALIDAD,t3.ESNORA_CALLE_ID ESTABLEESNORACALLEID,t3.ESNOMBRE_CALLE ESTABLEESNOMBRECALLE,t3.ESNORA_CP_ID ESTABLEESNORACPID,t3.ESNOMBRE_CP ESTABLEESNOMBRECP,t3.ESNORA_PORTAL_ID ESTABLEESNORAPORTALID,t3.ESNOMBRE_PORTAL ESTABLEESNOMBREPORTAL,t3.ESNOMBRE_PISO ESTABLEESNOMBREPISO, t3.ESDIRECCION_NOCAPV ESTABLEESDIRECCION_NOCAPV, t3.ESEXTRANJERO EstableESEXTRANJERO,t4.SECODIGO SECTORSECODIGO,t4.SENOMBRE SECTORSENOMBRE,t4.SENOCO SECTORSENOCO,t4.SEDESCRI SECTORSEDESCRI,t4.SECOSE SECTORSECOSE,t4.SENOCO2 SECTORSENOCO2,t4.SEINSEL1 SECTORSEINSEL1,t4.SENOMBREE SECTORSENOMBREE,t4.SENOMBREI SECTORSENOMBREI,t4.SENOMBREF SECTORSENOMBREF,t4.SENOCOE SECTORSENOCOE,t4.SENOCOI SECTORSENOCOI,t4.SENOCOF SECTORSENOCOF,t4.SEDESCRIE SECTORSEDESCRIE,t4.SEDESCRII SECTORSEDESCRII,t4.SEDESCRIF SECTORSEDESCRIF,t4.SECODGRUPO SECTORSECODGRUPO,t4.SENOMBREA SECTORSENOMBREA,t4.SEDESCRIA SECTORSEDESCRIA,t4.SENOCOA SECTORSENOCOA,t5.MOCODIGO CENSOMONITORMOCODIGO,t5.MONOMBRE CENSOMONITORMONOMBRE,t5.MOCOEM CENSOMONITORMOCOEM, t5.MODNI CENSOMONITORMODNI, t5.USUARIOXLNET CENSOMONITORUSUARIOXLNET,t5.PUESTOXLNET CENSOMONITORPUESTOXLNET, t5.MOFECBAJA CENSOMONITORMOFECBAJA,t6.PSCODIGO PRODUCTOPSCODIGO,t6.PSNOMBRE PRODUCTOPSNOMBRE,t6.PSNOCO PRODUCTOPSNOCO,t6.PSDESCRI PRODUCTOPSDESCRI,t6.PSCOSE PRODUCTOPSCOSE,t6.PSNOMBREE PRODUCTOPSNOMBREE,t6.PSNOMBREI PRODUCTOPSNOMBREI,t6.PSNOMBREF PRODUCTOPSNOMBREF,t6.PSNOMBREA PRODUCTOPSNOMBREA,t6.PSNOCOE PRODUCTOPSNOCOE,t6.PSNOCOI PRODUCTOPSNOCOI,t6.PSNOCOF PRODUCTOPSNOCOF,t6.PSNOCOA PRODUCTOPSNOCOA,t6.PSDESCRIE PRODUCTOPSDESCRIE,t6.PSDESCRII PRODUCTOPSDESCRII,t6.PSDESCRIF PRODUCTOPSDESCRIF,t6.PSDESCRIA PRODUCTOPSDESCRIA,t6.PSSEL1 PRODUCTOPSSEL1,t6.PSCOINC PRODUCTOPSCOINC,t7.TSRCODIGO TIPORECLAMACIONTSRCODIGO,t7.TSRNOMBRE TIPORECLAMACIONTSRNOMBRE,t7.TSRNOMBREE TIPORECLAMACIONTSRNOMBREE,t7.TSRNOMBREI TIPORECLAMACIONTSRNOMBREI,t7.TSRNOMBREF TIPORECLAMACIONTSRNOMBREF,t7.TSRNOMBREA TIPORECLAMACIONTSRNOMBREA, t7.TSRIMPORTE TIPORECLAMACIONTSRIMPORTE,t8.TIRCODIGO MOTIVOTIRCODIGO,t8.TIRNOMBRE MOTIVOTIRNOMBRE,t2.DECOTFP DENUNCIADECOTFP,t2.DECODT DENUNCIADECODT,t3.ESCOZS ESTABLECIMIENTOESCOZS,t4.SECOL0 SECTORSECOL0,t5.MOCOOR CENSOMONITORMOCOOR,t6.PSCOE8 PRODUCTOPSCOE8, t1.HDFORMANOTIFICACION HDFORMANOTIFICACION, t1.HDFORMANOTIFESTABLECIMIENTO HDFORMANOTIFESTABLECIMIENTO,t1.HDFORMAVENTA HDFORMAVENTA, t1.HDIDIOMA HDIDIOMA  "
						+ "FROM HECHO_DENUNCIADO t1 ,DENUNCIA t2 ,ESTABLECIMIENTO t3 ,SECTOR t4 ,CENSO_MONITOR t5 ,PRODUCTO t6 ,TIPO_RECLAMACION t7 ,MOTIVO t8 ");

		if (hechodenunciado != null && hechodenunciado.getHdcodigo() != null) {
			where.append(" AND UPPER(t1.HDCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getHdcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getHdcodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.HDCODIGO IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getDenuncia() != null
				&& hechodenunciado.getDenuncia().getDecodigo() != null) {
			where.append(" AND t2.DECODIGO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getDenuncia().getDecodigo() + "%");
			} else {
				params.add("%" + hechodenunciado.getDenuncia().getDecodigo() + "%");
			}
			where.append(" AND t2.DECODIGO IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getDenuncia() != null
				&& hechodenunciado.getDenuncia().getFormaPresentacion() != null
				&& hechodenunciado.getDenuncia().getFormaPresentacion().getTfpcodigo() != null) {
			where.append(" AND UPPER(t2.DECOTFP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getDenuncia().getFormaPresentacion().getTfpcodigo().toUpperCase() + "%");
			} else {
				params.add(
						"%" + hechodenunciado.getDenuncia().getFormaPresentacion().getTfpcodigo().toUpperCase() + "%");
			}
			where.append(" AND t2.DECOTFP IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getDenuncia() != null
				&& hechodenunciado.getDenuncia().getConsumidor() != null
				&& hechodenunciado.getDenuncia().getConsumidor().getDtcodigo() != null) {
			where.append(" AND UPPER(t2.DECODT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getDenuncia().getConsumidor().getDtcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getDenuncia().getConsumidor().getDtcodigo().toUpperCase() + "%");
			}
			where.append(" AND t2.DECODT IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getDenuncia() != null
				&& hechodenunciado.getDenuncia().getDecocp() != null) {
			where.append(" AND UPPER(t2.DECOCP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getDenuncia().getDecocp().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getDenuncia().getDecocp().toUpperCase() + "%");
			}
			where.append(" AND t2.DECOCP IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getDenuncia() != null
				&& hechodenunciado.getDenuncia().getDecoor() != null) {
			where.append(" AND UPPER(t2.DECOOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getDenuncia().getDecoor().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getDenuncia().getDecoor().toUpperCase() + "%");
			}
			where.append(" AND t2.DECOOR IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getDenuncia() != null
				&& hechodenunciado.getDenuncia().getDenran() != null) {
			where.append(" AND t2.DENRAN like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getDenuncia().getDenran() + "%");
			} else {
				params.add("%" + hechodenunciado.getDenuncia().getDenran() + "%");
			}
			where.append(" AND t2.DENRAN IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getDenuncia() != null
				&& hechodenunciado.getDenuncia().getDenror() != null) {
			where.append(" AND t2.DENROR like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getDenuncia().getDenror() + "%");
			} else {
				params.add("%" + hechodenunciado.getDenuncia().getDenror() + "%");
			}
			where.append(" AND t2.DENROR IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getDenuncia() != null
				&& hechodenunciado.getDenuncia().getDefede() != null) {
			where.append(" AND t2.DEFEDE like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getDenuncia().getDefede() + "%");
			} else {
				params.add("%" + hechodenunciado.getDenuncia().getDefede() + "%");
			}
			where.append(" AND t2.DEFEDE IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getDenuncia() != null
				&& hechodenunciado.getDenuncia().getDefere() != null) {
			where.append(" AND t2.DEFERE like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getDenuncia().getDefere() + "%");
			} else {
				params.add("%" + hechodenunciado.getDenuncia().getDefere() + "%");
			}
			where.append(" AND t2.DEFERE IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getDenuncia() != null
				&& hechodenunciado.getDenuncia().getDefeex() != null) {
			where.append(" AND t2.DEFEEX like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getDenuncia().getDefeex() + "%");
			} else {
				params.add("%" + hechodenunciado.getDenuncia().getDefeex() + "%");
			}
			where.append(" AND t2.DEFEEX IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getDenuncia() != null
				&& hechodenunciado.getDenuncia().getDefeim() != null) {
			where.append(" AND t2.DEFEIM like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getDenuncia().getDefeim() + "%");
			} else {
				params.add("%" + hechodenunciado.getDenuncia().getDefeim() + "%");
			}
			where.append(" AND t2.DEFEIM IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getDenuncia() != null
				&& hechodenunciado.getDenuncia().getDeinre() != null) {
			where.append(" AND UPPER(t2.DEINRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getDenuncia().getDeinre().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getDenuncia().getDeinre().toUpperCase() + "%");
			}
			where.append(" AND t2.DEINRE IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getDenuncia() != null
				&& hechodenunciado.getDenuncia().getDenrrgen() != null) {
			where.append(" AND UPPER(t2.DENRRGEN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getDenuncia().getDenrrgen().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getDenuncia().getDenrrgen().toUpperCase() + "%");
			}
			where.append(" AND t2.DENRRGEN IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEscodigo() != null) {
			where.append(" AND t3.ESCODIGO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getEstablecimiento().getEscodigo() + "%");
			} else {
				params.add("%" + hechodenunciado.getEstablecimiento().getEscodigo() + "%");
			}
			where.append(" AND t3.ESCODIGO IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getCensoMonitor() != null
				&& hechodenunciado.getEstablecimiento().getCensoMonitor().getMocodigo() != null) {
			where.append(" AND UPPER(t3.ESCOZS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getEstablecimiento().getCensoMonitor().getMocodigo().toUpperCase() + "%");
			} else {
				params.add(
						"%" + hechodenunciado.getEstablecimiento().getCensoMonitor().getMocodigo().toUpperCase() + "%");
			}
			where.append(" AND t3.ESCOZS IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnombre() != null) {
			where.append(" AND UPPER(t3.ESNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getEstablecimiento().getEsnombre().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getEstablecimiento().getEsnombre().toUpperCase() + "%");
			}
			where.append(" AND t3.ESNOMBRE IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnif() != null) {
			where.append(" AND UPPER(t3.ESNIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getEstablecimiento().getEsnif().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getEstablecimiento().getEsnif().toUpperCase() + "%");
			}
			where.append(" AND t3.ESNIF IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnoan() != null) {
			where.append(" AND UPPER(t3.ESNOAN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getEstablecimiento().getEsnoan().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getEstablecimiento().getEsnoan().toUpperCase() + "%");
			}
			where.append(" AND t3.ESNOAN IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnoco() != null) {
			where.append(" AND UPPER(t3.ESNOCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getEstablecimiento().getEsnoco().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getEstablecimiento().getEsnoco().toUpperCase() + "%");
			}
			where.append(" AND t3.ESNOCO IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnodir() != null) {
			where.append(" AND UPPER(t3.ESNODIR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getEstablecimiento().getEsnodir().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getEstablecimiento().getEsnodir().toUpperCase() + "%");
			}
			where.append(" AND t3.ESNODIR IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEscolo() != null) {
			where.append(" AND UPPER(t3.ESCOLO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getEstablecimiento().getEscolo().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getEstablecimiento().getEscolo().toUpperCase() + "%");
			}
			where.append(" AND t3.ESCOLO IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnrcopo() != null) {
			where.append(" AND UPPER(t3.ESNRCOPO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getEstablecimiento().getEsnrcopo().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getEstablecimiento().getEsnrcopo().toUpperCase() + "%");
			}
			where.append(" AND t3.ESNRCOPO IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnrtel() != null) {
			where.append(" AND UPPER(t3.ESNRTEL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getEstablecimiento().getEsnrtel().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getEstablecimiento().getEsnrtel().toUpperCase() + "%");
			}
			where.append(" AND t3.ESNRTEL IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnrfax() != null) {
			where.append(" AND UPPER(t3.ESNRFAX) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getEstablecimiento().getEsnrfax().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getEstablecimiento().getEsnrfax().toUpperCase() + "%");
			}
			where.append(" AND t3.ESNRFAX IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEscopa() != null) {
			where.append(" AND UPPER(t3.ESCOPA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getEstablecimiento().getEscopa().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getEstablecimiento().getEscopa().toUpperCase() + "%");
			}
			where.append(" AND t3.ESCOPA IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsincapr() != null) {
			where.append(" AND UPPER(t3.ESINCAPR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getEstablecimiento().getEsincapr().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getEstablecimiento().getEsincapr().toUpperCase() + "%");
			}
			where.append(" AND t3.ESINCAPR IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsindemp() != null) {
			where.append(" AND UPPER(t3.ESINDEMP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getEstablecimiento().getEsindemp().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getEstablecimiento().getEsindemp().toUpperCase() + "%");
			}
			where.append(" AND t3.ESINDEMP IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsteco() != null) {
			where.append(" AND UPPER(t3.ESTECO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getEstablecimiento().getEsteco().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getEstablecimiento().getEsteco().toUpperCase() + "%");
			}
			where.append(" AND t3.ESTECO IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsinadar() != null) {
			where.append(" AND UPPER(t3.ESINADAR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getEstablecimiento().getEsinadar().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getEstablecimiento().getEsinadar().toUpperCase() + "%");
			}
			where.append(" AND t3.ESINADAR IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsfeadar() != null) {
			where.append(" AND t3.ESFEADAR like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getEstablecimiento().getEsfeadar() + "%");
			} else {
				params.add("%" + hechodenunciado.getEstablecimiento().getEsfeadar() + "%");
			}
			where.append(" AND t3.ESFEADAR IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEscoem() != null) {
			where.append(" AND UPPER(t3.ESCOEM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getEstablecimiento().getEscoem().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getEstablecimiento().getEscoem().toUpperCase() + "%");
			}
			where.append(" AND t3.ESCOEM IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsinempr() != null) {
			where.append(" AND UPPER(t3.ESINEMPR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getEstablecimiento().getEsinempr().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getEstablecimiento().getEsinempr().toUpperCase() + "%");
			}
			where.append(" AND t3.ESINEMPR IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnrtel2() != null) {
			where.append(" AND UPPER(t3.ESNRTEL2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getEstablecimiento().getEsnrtel2().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getEstablecimiento().getEsnrtel2().toUpperCase() + "%");
			}
			where.append(" AND t3.ESNRTEL2 IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsfeba() != null) {
			where.append(" AND t3.ESFEBA like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getEstablecimiento().getEsfeba() + "%");
			} else {
				params.add("%" + hechodenunciado.getEstablecimiento().getEsfeba() + "%");
			}
			where.append(" AND t3.ESFEBA IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnoap1() != null) {
			where.append(" AND UPPER(t3.ESNOAP1) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getEstablecimiento().getEsnoap1().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getEstablecimiento().getEsnoap1().toUpperCase() + "%");
			}
			where.append(" AND t3.ESNOAP1 IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnoap2() != null) {
			where.append(" AND UPPER(t3.ESNOAP2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getEstablecimiento().getEsnoap2().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getEstablecimiento().getEsnoap2().toUpperCase() + "%");
			}
			where.append(" AND t3.ESNOAP2 IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnolo() != null) {
			where.append(" AND UPPER(t3.ESNOLO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getEstablecimiento().getEsnolo().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getEstablecimiento().getEsnolo().toUpperCase() + "%");
			}
			where.append(" AND t3.ESNOLO IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEscomapv() != null) {
			where.append(" AND UPPER(t3.ESCOMAPV) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getEstablecimiento().getEscomapv().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getEstablecimiento().getEscomapv().toUpperCase() + "%");
			}
			where.append(" AND t3.ESCOMAPV IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEscoca() != null) {
			where.append(" AND UPPER(t3.ESCOCA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getEstablecimiento().getEscoca().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getEstablecimiento().getEscoca().toUpperCase() + "%");
			}
			where.append(" AND t3.ESCOCA IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnopeco() != null) {
			where.append(" AND UPPER(t3.ESNOPECO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getEstablecimiento().getEsnopeco().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getEstablecimiento().getEsnopeco().toUpperCase() + "%");
			}
			where.append(" AND t3.ESNOPECO IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEscoidco() != null) {
			where.append(" AND UPPER(t3.ESCOIDCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getEstablecimiento().getEscoidco().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getEstablecimiento().getEscoidco().toUpperCase() + "%");
			}
			where.append(" AND t3.ESCOIDCO IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsinreco() != null) {
			where.append(" AND UPPER(t3.ESINRECO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getEstablecimiento().getEsinreco().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getEstablecimiento().getEsinreco().toUpperCase() + "%");
			}
			where.append(" AND t3.ESINRECO IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsfemod() != null) {
			where.append(" AND UPPER(t3.ESFEMOD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getEstablecimiento().getEsfemod().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getEstablecimiento().getEsfemod().toUpperCase() + "%");
			}
			where.append(" AND t3.ESFEMOD IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsinesco() != null) {
			where.append(" AND UPPER(t3.ESINESCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getEstablecimiento().getEsinesco().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getEstablecimiento().getEsinesco().toUpperCase() + "%");
			}
			where.append(" AND t3.ESINESCO IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnomu() != null) {
			where.append(" AND UPPER(t3.ESNOMU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getEstablecimiento().getEsnomu().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getEstablecimiento().getEsnomu().toUpperCase() + "%");
			}
			where.append(" AND t3.ESNOMU IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnorep() != null) {
			where.append(" AND UPPER(t3.ESNOREP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getEstablecimiento().getEsnorep().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getEstablecimiento().getEsnorep().toUpperCase() + "%");
			}
			where.append(" AND t3.ESNOREP IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnifrep() != null) {
			where.append(" AND UPPER(t3.ESNIFREP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getEstablecimiento().getEsnifrep().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getEstablecimiento().getEsnifrep().toUpperCase() + "%");
			}
			where.append(" AND t3.ESNIFREP IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getDtteemr() != null) {
			where.append(" AND UPPER(t3.DTTEEMR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getEstablecimiento().getDtteemr().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getEstablecimiento().getDtteemr().toUpperCase() + "%");
			}
			where.append(" AND t3.DTTEEMR IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEscarep() != null) {
			where.append(" AND UPPER(t3.ESCAREP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getEstablecimiento().getEscarep().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getEstablecimiento().getEscarep().toUpperCase() + "%");
			}
			where.append(" AND t3.ESCAREP IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsteurl() != null) {
			where.append(" AND UPPER(t3.ESTEURL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getEstablecimiento().getEsteurl().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getEstablecimiento().getEsteurl().toUpperCase() + "%");
			}
			where.append(" AND t3.ESTEURL IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEscooe() != null) {
			where.append(" AND UPPER(t3.ESCOOE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getEstablecimiento().getEscooe().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getEstablecimiento().getEscooe().toUpperCase() + "%");
			}
			where.append(" AND t3.ESCOOE IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnodeco() != null) {
			where.append(" AND UPPER(t3.ESNODECO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getEstablecimiento().getEsnodeco().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getEstablecimiento().getEsnodeco().toUpperCase() + "%");
			}
			where.append(" AND t3.ESNODECO IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsintiar() != null) {
			where.append(" AND UPPER(t3.ESINTIAR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getEstablecimiento().getEsintiar().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getEstablecimiento().getEsintiar().toUpperCase() + "%");
			}
			where.append(" AND t3.ESINTIAR IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsfeplad() != null) {
			where.append(" AND t3.ESFEPLAD like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getEstablecimiento().getEsfeplad() + "%");
			} else {
				params.add("%" + hechodenunciado.getEstablecimiento().getEsfeplad() + "%");
			}
			where.append(" AND t3.ESFEPLAD IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsindeme() != null) {
			where.append(" AND UPPER(t3.ESINDEME) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getEstablecimiento().getEsindeme().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getEstablecimiento().getEsindeme().toUpperCase() + "%");
			}
			where.append(" AND t3.ESINDEME IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnoraPaisId() != null) {
			where.append(" AND UPPER(t3.ESNORA_PAIS_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getEstablecimiento().getEsnoraPaisId().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getEstablecimiento().getEsnoraPaisId().toUpperCase() + "%");
			}
			where.append(" AND t3.ESNORA_PAIS_ID IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnoraPaisNombre() != null) {
			where.append(" AND UPPER(t3.ESNORA_PAIS_NOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getEstablecimiento().getEsnoraPaisNombre().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getEstablecimiento().getEsnoraPaisNombre().toUpperCase() + "%");
			}
			where.append(" AND t3.ESNORA_PAIS_NOMBRE IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnoraProvinciaId() != null) {
			where.append(" AND UPPER(t3.ESNORA_PROVINCIA_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getEstablecimiento().getEsnoraProvinciaId().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getEstablecimiento().getEsnoraProvinciaId().toUpperCase() + "%");
			}
			where.append(" AND t3.ESNORA_PROVINCIA_ID IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnombreProvincia() != null) {
			where.append(" AND UPPER(t3.ESNOMBRE_PROVINCIA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getEstablecimiento().getEsnombreProvincia().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getEstablecimiento().getEsnombreProvincia().toUpperCase() + "%");
			}
			where.append(" AND t3.ESNOMBRE_PROVINCIA IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnoraMunicipioId() != null) {
			where.append(" AND UPPER(t3.ESNORA_MUNICIPIO_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getEstablecimiento().getEsnoraMunicipioId().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getEstablecimiento().getEsnoraMunicipioId().toUpperCase() + "%");
			}
			where.append(" AND t3.ESNORA_MUNICIPIO_ID IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnombreMunicipio() != null) {
			where.append(" AND UPPER(t3.ESNOMBRE_MUNICIPIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getEstablecimiento().getEsnombreMunicipio().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getEstablecimiento().getEsnombreMunicipio().toUpperCase() + "%");
			}
			where.append(" AND t3.ESNOMBRE_MUNICIPIO IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnoraLocalidadId() != null) {
			where.append(" AND UPPER(t3.ESNORA_LOCALIDAD_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getEstablecimiento().getEsnoraLocalidadId().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getEstablecimiento().getEsnoraLocalidadId().toUpperCase() + "%");
			}
			where.append(" AND t3.ESNORA_LOCALIDAD_ID IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnombreLocalidad() != null) {
			where.append(" AND UPPER(t3.ESNOMBRE_LOCALIDAD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getEstablecimiento().getEsnombreLocalidad().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getEstablecimiento().getEsnombreLocalidad().toUpperCase() + "%");
			}
			where.append(" AND t3.ESNOMBRE_LOCALIDAD IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnoraCalleId() != null) {
			where.append(" AND UPPER(t3.ESNORA_CALLE_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getEstablecimiento().getEsnoraCalleId().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getEstablecimiento().getEsnoraCalleId().toUpperCase() + "%");
			}
			where.append(" AND t3.ESNORA_CALLE_ID IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnombreCalle() != null) {
			where.append(" AND UPPER(t3.ESNOMBRE_CALLE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getEstablecimiento().getEsnombreCalle().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getEstablecimiento().getEsnombreCalle().toUpperCase() + "%");
			}
			where.append(" AND t3.ESNOMBRE_CALLE IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnoraCpId() != null) {
			where.append(" AND UPPER(t3.ESNORA_CP_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getEstablecimiento().getEsnoraCpId().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getEstablecimiento().getEsnoraCpId().toUpperCase() + "%");
			}
			where.append(" AND t3.ESNORA_CP_ID IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnombreCp() != null) {
			where.append(" AND UPPER(t3.ESNOMBRE_CP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getEstablecimiento().getEsnombreCp().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getEstablecimiento().getEsnombreCp().toUpperCase() + "%");
			}
			where.append(" AND t3.ESNOMBRE_CP IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnoraPortalId() != null) {
			where.append(" AND UPPER(t3.ESNORA_PORTAL_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getEstablecimiento().getEsnoraPortalId().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getEstablecimiento().getEsnoraPortalId().toUpperCase() + "%");
			}
			where.append(" AND t3.ESNORA_PORTAL_ID IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnombrePortal() != null) {
			where.append(" AND UPPER(t3.ESNOMBRE_PORTAL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getEstablecimiento().getEsnombrePortal().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getEstablecimiento().getEsnombrePortal().toUpperCase() + "%");
			}
			where.append(" AND t3.ESNOMBRE_PORTAL IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEsnombrePiso() != null) {
			where.append(" AND UPPER(t3.ESNOMBRE_PISO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getEstablecimiento().getEsnombrePiso().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getEstablecimiento().getEsnombrePiso().toUpperCase() + "%");
			}
			where.append(" AND t3.ESNOMBRE_PISO IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getSector() != null
				&& hechodenunciado.getSector().getSecodigo() != null) {
			where.append(" AND t4.SECODIGO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getSector().getSecodigo() + "%");
			} else {
				params.add("%" + hechodenunciado.getSector().getSecodigo() + "%");
			}
			where.append(" AND t4.SECODIGO IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getSector() != null
				&& hechodenunciado.getSector().getSectorAgrupado() != null
				&& hechodenunciado.getSector().getSectorAgrupado().getL0codigo() != null) {
			where.append(" AND UPPER(t4.SECOL0) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getSector().getSectorAgrupado().getL0codigo().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getSector().getSectorAgrupado().getL0codigo().toUpperCase() + "%");
			}
			where.append(" AND t4.SECOL0 IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getSector() != null
				&& hechodenunciado.getSector().getSenombre() != null) {
			where.append(" AND UPPER(t4.SENOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getSector().getSenombre().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getSector().getSenombre().toUpperCase() + "%");
			}
			where.append(" AND t4.SENOMBRE IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getSector() != null
				&& hechodenunciado.getSector().getSenoco() != null) {
			where.append(" AND UPPER(t4.SENOCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getSector().getSenoco().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getSector().getSenoco().toUpperCase() + "%");
			}
			where.append(" AND t4.SENOCO IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getSector() != null
				&& hechodenunciado.getSector().getSedescri() != null) {
			where.append(" AND UPPER(t4.SEDESCRI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getSector().getSedescri().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getSector().getSedescri().toUpperCase() + "%");
			}
			where.append(" AND t4.SEDESCRI IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getSector() != null
				&& hechodenunciado.getSector().getSecose() != null) {
			where.append(" AND UPPER(t4.SECOSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getSector().getSecose().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getSector().getSecose().toUpperCase() + "%");
			}
			where.append(" AND t4.SECOSE IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getSector() != null
				&& hechodenunciado.getSector().getSenoco2() != null) {
			where.append(" AND UPPER(t4.SENOCO2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getSector().getSenoco2().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getSector().getSenoco2().toUpperCase() + "%");
			}
			where.append(" AND t4.SENOCO2 IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getSector() != null
				&& hechodenunciado.getSector().getSeinsel1() != null) {
			where.append(" AND UPPER(t4.SEINSEL1) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getSector().getSeinsel1().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getSector().getSeinsel1().toUpperCase() + "%");
			}
			where.append(" AND t4.SEINSEL1 IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getSector() != null
				&& hechodenunciado.getSector().getSenombree() != null) {
			where.append(" AND UPPER(t4.SENOMBREE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getSector().getSenombree().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getSector().getSenombree().toUpperCase() + "%");
			}
			where.append(" AND t4.SENOMBREE IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getSector() != null
				&& hechodenunciado.getSector().getSenombrei() != null) {
			where.append(" AND UPPER(t4.SENOMBREI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getSector().getSenombrei().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getSector().getSenombrei().toUpperCase() + "%");
			}
			where.append(" AND t4.SENOMBREI IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getSector() != null
				&& hechodenunciado.getSector().getSenombref() != null) {
			where.append(" AND UPPER(t4.SENOMBREF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getSector().getSenombref().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getSector().getSenombref().toUpperCase() + "%");
			}
			where.append(" AND t4.SENOMBREF IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getSector() != null
				&& hechodenunciado.getSector().getSenocoe() != null) {
			where.append(" AND UPPER(t4.SENOCOE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getSector().getSenocoe().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getSector().getSenocoe().toUpperCase() + "%");
			}
			where.append(" AND t4.SENOCOE IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getSector() != null
				&& hechodenunciado.getSector().getSenocoi() != null) {
			where.append(" AND UPPER(t4.SENOCOI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getSector().getSenocoi().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getSector().getSenocoi().toUpperCase() + "%");
			}
			where.append(" AND t4.SENOCOI IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getSector() != null
				&& hechodenunciado.getSector().getSenocof() != null) {
			where.append(" AND UPPER(t4.SENOCOF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getSector().getSenocof().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getSector().getSenocof().toUpperCase() + "%");
			}
			where.append(" AND t4.SENOCOF IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getSector() != null
				&& hechodenunciado.getSector().getSedescrie() != null) {
			where.append(" AND UPPER(t4.SEDESCRIE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getSector().getSedescrie().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getSector().getSedescrie().toUpperCase() + "%");
			}
			where.append(" AND t4.SEDESCRIE IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getSector() != null
				&& hechodenunciado.getSector().getSedescrii() != null) {
			where.append(" AND UPPER(t4.SEDESCRII) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getSector().getSedescrii().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getSector().getSedescrii().toUpperCase() + "%");
			}
			where.append(" AND t4.SEDESCRII IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getSector() != null
				&& hechodenunciado.getSector().getSedescrif() != null) {
			where.append(" AND UPPER(t4.SEDESCRIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getSector().getSedescrif().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getSector().getSedescrif().toUpperCase() + "%");
			}
			where.append(" AND t4.SEDESCRIF IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getSector() != null
				&& hechodenunciado.getSector().getSecodgrupo() != null) {
			where.append(" AND UPPER(t4.SECODGRUPO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getSector().getSecodgrupo().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getSector().getSecodgrupo().toUpperCase() + "%");
			}
			where.append(" AND t4.SECODGRUPO IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getSector() != null
				&& hechodenunciado.getSector().getSenombrea() != null) {
			where.append(" AND UPPER(t4.SENOMBREA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getSector().getSenombrea().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getSector().getSenombrea().toUpperCase() + "%");
			}
			where.append(" AND t4.SENOMBREA IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getSector() != null
				&& hechodenunciado.getSector().getSedescria() != null) {
			where.append(" AND UPPER(t4.SEDESCRIA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getSector().getSedescria().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getSector().getSedescria().toUpperCase() + "%");
			}
			where.append(" AND t4.SEDESCRIA IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getSector() != null
				&& hechodenunciado.getSector().getSenocoa() != null) {
			where.append(" AND UPPER(t4.SENOCOA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getSector().getSenocoa().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getSector().getSenocoa().toUpperCase() + "%");
			}
			where.append(" AND t4.SENOCOA IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getCensoMonitor() != null
				&& hechodenunciado.getCensoMonitor().getMocodigo() != null) {
			where.append(" AND t5.MOCODIGO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getCensoMonitor().getMocodigo() + "%");
			} else {
				params.add("%" + hechodenunciado.getCensoMonitor().getMocodigo() + "%");
			}
			where.append(" AND t5.MOCODIGO IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getCensoMonitor() != null
				&& hechodenunciado.getCensoMonitor().getOrganismo() != null
				&& hechodenunciado.getCensoMonitor().getOrganismo().getCodOrg() != null) {
			where.append(" AND UPPER(t5.MOCOOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getCensoMonitor().getOrganismo().getCodOrg().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getCensoMonitor().getOrganismo().getCodOrg().toUpperCase() + "%");
			}
			where.append(" AND t5.MOCOOR IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getCensoMonitor() != null
				&& hechodenunciado.getCensoMonitor().getMonombre() != null) {
			where.append(" AND UPPER(t5.MONOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getCensoMonitor().getMonombre().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getCensoMonitor().getMonombre().toUpperCase() + "%");
			}
			where.append(" AND t5.MONOMBRE IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getCensoMonitor() != null
				&& hechodenunciado.getCensoMonitor().getMocoem() != null) {
			where.append(" AND UPPER(t5.MOCOEM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getCensoMonitor().getMocoem().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getCensoMonitor().getMocoem().toUpperCase() + "%");
			}
			where.append(" AND t5.MOCOEM IS NOT NULL");
		}

		if (hechodenunciado != null && hechodenunciado.getCensoMonitor() != null
				&& hechodenunciado.getCensoMonitor().getMofecbaja() != null) {
			where.append(" AND t5.MOFECBAJA like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getCensoMonitor().getMofecbaja() + "%");
			} else {
				params.add("%" + hechodenunciado.getCensoMonitor().getMofecbaja() + "%");
			}
			where.append(" AND t5.MOFECBAJA IS NOT NULL");
		}

		if (hechodenunciado != null && hechodenunciado.getProducto() != null
				&& hechodenunciado.getProducto().getPscodigo() != null) {
			where.append(" AND t6.PSCODIGO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getProducto().getPscodigo() + "%");
			} else {
				params.add("%" + hechodenunciado.getProducto().getPscodigo() + "%");
			}
			where.append(" AND t6.PSCODIGO IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getProducto() != null
				&& hechodenunciado.getProducto().getProdAgrupado() != null
				&& hechodenunciado.getProducto().getProdAgrupado().getE8codigo() != null) {
			where.append(" AND UPPER(t6.PSCOE8) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getProducto().getProdAgrupado().getE8codigo().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getProducto().getProdAgrupado().getE8codigo().toUpperCase() + "%");
			}
			where.append(" AND t6.PSCOE8 IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getProducto() != null
				&& hechodenunciado.getProducto().getPsnombre() != null) {
			where.append(" AND UPPER(t6.PSNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getProducto().getPsnombre().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getProducto().getPsnombre().toUpperCase() + "%");
			}
			where.append(" AND t6.PSNOMBRE IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getProducto() != null
				&& hechodenunciado.getProducto().getPsnoco() != null) {
			where.append(" AND UPPER(t6.PSNOCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getProducto().getPsnoco().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getProducto().getPsnoco().toUpperCase() + "%");
			}
			where.append(" AND t6.PSNOCO IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getProducto() != null
				&& hechodenunciado.getProducto().getPsdescri() != null) {
			where.append(" AND UPPER(t6.PSDESCRI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getProducto().getPsdescri().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getProducto().getPsdescri().toUpperCase() + "%");
			}
			where.append(" AND t6.PSDESCRI IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getProducto() != null
				&& hechodenunciado.getProducto().getPscose() != null) {
			where.append(" AND UPPER(t6.PSCOSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getProducto().getPscose().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getProducto().getPscose().toUpperCase() + "%");
			}
			where.append(" AND t6.PSCOSE IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getProducto() != null
				&& hechodenunciado.getProducto().getPsnombree() != null) {
			where.append(" AND UPPER(t6.PSNOMBREE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getProducto().getPsnombree().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getProducto().getPsnombree().toUpperCase() + "%");
			}
			where.append(" AND t6.PSNOMBREE IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getProducto() != null
				&& hechodenunciado.getProducto().getPsnombrei() != null) {
			where.append(" AND UPPER(t6.PSNOMBREI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getProducto().getPsnombrei().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getProducto().getPsnombrei().toUpperCase() + "%");
			}
			where.append(" AND t6.PSNOMBREI IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getProducto() != null
				&& hechodenunciado.getProducto().getPsnombref() != null) {
			where.append(" AND UPPER(t6.PSNOMBREF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getProducto().getPsnombref().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getProducto().getPsnombref().toUpperCase() + "%");
			}
			where.append(" AND t6.PSNOMBREF IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getProducto() != null
				&& hechodenunciado.getProducto().getPsnombrea() != null) {
			where.append(" AND UPPER(t6.PSNOMBREA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getProducto().getPsnombrea().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getProducto().getPsnombrea().toUpperCase() + "%");
			}
			where.append(" AND t6.PSNOMBREA IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getProducto() != null
				&& hechodenunciado.getProducto().getPsnocoe() != null) {
			where.append(" AND UPPER(t6.PSNOCOE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getProducto().getPsnocoe().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getProducto().getPsnocoe().toUpperCase() + "%");
			}
			where.append(" AND t6.PSNOCOE IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getProducto() != null
				&& hechodenunciado.getProducto().getPsnocoi() != null) {
			where.append(" AND UPPER(t6.PSNOCOI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getProducto().getPsnocoi().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getProducto().getPsnocoi().toUpperCase() + "%");
			}
			where.append(" AND t6.PSNOCOI IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getProducto() != null
				&& hechodenunciado.getProducto().getPsnocof() != null) {
			where.append(" AND UPPER(t6.PSNOCOF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getProducto().getPsnocof().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getProducto().getPsnocof().toUpperCase() + "%");
			}
			where.append(" AND t6.PSNOCOF IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getProducto() != null
				&& hechodenunciado.getProducto().getPsnocoa() != null) {
			where.append(" AND UPPER(t6.PSNOCOA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getProducto().getPsnocoa().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getProducto().getPsnocoa().toUpperCase() + "%");
			}
			where.append(" AND t6.PSNOCOA IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getProducto() != null
				&& hechodenunciado.getProducto().getPsdescrie() != null) {
			where.append(" AND UPPER(t6.PSDESCRIE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getProducto().getPsdescrie().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getProducto().getPsdescrie().toUpperCase() + "%");
			}
			where.append(" AND t6.PSDESCRIE IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getProducto() != null
				&& hechodenunciado.getProducto().getPsdescrii() != null) {
			where.append(" AND UPPER(t6.PSDESCRII) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getProducto().getPsdescrii().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getProducto().getPsdescrii().toUpperCase() + "%");
			}
			where.append(" AND t6.PSDESCRII IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getProducto() != null
				&& hechodenunciado.getProducto().getPsdescrif() != null) {
			where.append(" AND UPPER(t6.PSDESCRIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getProducto().getPsdescrif().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getProducto().getPsdescrif().toUpperCase() + "%");
			}
			where.append(" AND t6.PSDESCRIF IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getProducto() != null
				&& hechodenunciado.getProducto().getPsdescria() != null) {
			where.append(" AND UPPER(t6.PSDESCRIA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getProducto().getPsdescria().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getProducto().getPsdescria().toUpperCase() + "%");
			}
			where.append(" AND t6.PSDESCRIA IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getProducto() != null
				&& hechodenunciado.getProducto().getPssel1() != null) {
			where.append(" AND UPPER(t6.PSSEL1) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getProducto().getPssel1().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getProducto().getPssel1().toUpperCase() + "%");
			}
			where.append(" AND t6.PSSEL1 IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getProducto() != null
				&& hechodenunciado.getProducto().getPscoinc() != null) {
			where.append(" AND UPPER(t6.PSCOINC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getProducto().getPscoinc().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getProducto().getPscoinc().toUpperCase() + "%");
			}
			where.append(" AND t6.PSCOINC IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getTipoReclamacion() != null
				&& hechodenunciado.getTipoReclamacion().getTsrcodigo() != null) {
			where.append(" AND t7.TSRCODIGO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getTipoReclamacion().getTsrcodigo() + "%");
			} else {
				params.add("%" + hechodenunciado.getTipoReclamacion().getTsrcodigo() + "%");
			}
			where.append(" AND t7.TSRCODIGO IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getTipoReclamacion() != null
				&& hechodenunciado.getTipoReclamacion().getTsrnombre() != null) {
			where.append(" AND UPPER(t7.TSRNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getTipoReclamacion().getTsrnombre().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getTipoReclamacion().getTsrnombre().toUpperCase() + "%");
			}
			where.append(" AND t7.TSRNOMBRE IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getTipoReclamacion() != null
				&& hechodenunciado.getTipoReclamacion().getTsrnombree() != null) {
			where.append(" AND UPPER(t7.TSRNOMBREE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getTipoReclamacion().getTsrnombree().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getTipoReclamacion().getTsrnombree().toUpperCase() + "%");
			}
			where.append(" AND t7.TSRNOMBREE IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getTipoReclamacion() != null
				&& hechodenunciado.getTipoReclamacion().getTsrnombrei() != null) {
			where.append(" AND UPPER(t7.TSRNOMBREI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getTipoReclamacion().getTsrnombrei().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getTipoReclamacion().getTsrnombrei().toUpperCase() + "%");
			}
			where.append(" AND t7.TSRNOMBREI IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getTipoReclamacion() != null
				&& hechodenunciado.getTipoReclamacion().getTsrnombref() != null) {
			where.append(" AND UPPER(t7.TSRNOMBREF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getTipoReclamacion().getTsrnombref().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getTipoReclamacion().getTsrnombref().toUpperCase() + "%");
			}
			where.append(" AND t7.TSRNOMBREF IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getTipoReclamacion() != null
				&& hechodenunciado.getTipoReclamacion().getTsrnombrea() != null) {
			where.append(" AND UPPER(t7.TSRNOMBREA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getTipoReclamacion().getTsrnombrea().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getTipoReclamacion().getTsrnombrea().toUpperCase() + "%");
			}
			where.append(" AND t7.TSRNOMBREA IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getMotivo() != null
				&& hechodenunciado.getMotivo().getTircodigo() != null) {
			where.append(" AND t8.TIRCODIGO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getMotivo().getTircodigo() + "%");
			} else {
				params.add("%" + hechodenunciado.getMotivo().getTircodigo() + "%");
			}
			where.append(" AND t8.TIRCODIGO IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getMotivo() != null
				&& hechodenunciado.getMotivo().getTirnombre() != null) {
			where.append(" AND UPPER(t8.TIRNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getMotivo().getTirnombre().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getMotivo().getTirnombre().toUpperCase() + "%");
			}
			where.append(" AND t8.TIRNOMBRE IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getHdnror() != null) {
			where.append(" AND t1.HDNROR like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getHdnror() + "%");
			} else {
				params.add("%" + hechodenunciado.getHdnror() + "%");
			}
			where.append(" AND t1.HDNROR IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getHdte() != null) {
			where.append(" AND UPPER(t1.HDTE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getHdte().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getHdte().toUpperCase() + "%");
			}
			where.append(" AND t1.HDTE IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getHdtedoad() != null) {
			where.append(" AND UPPER(t1.HDTEDOAD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getHdtedoad().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getHdtedoad().toUpperCase() + "%");
			}
			where.append(" AND t1.HDTEDOAD IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getHdcoav() != null) {
			where.append(" AND UPPER(t1.HDCOAV) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getHdcoav().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getHdcoav().toUpperCase() + "%");
			}
			where.append(" AND t1.HDCOAV IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getHdnops() != null) {
			where.append(" AND UPPER(t1.HDNOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getHdnops().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getHdnops().toUpperCase() + "%");
			}
			where.append(" AND t1.HDNOPS IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getHdnomaps() != null) {
			where.append(" AND UPPER(t1.HDNOMAPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getHdnomaps().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getHdnomaps().toUpperCase() + "%");
			}
			where.append(" AND t1.HDNOMAPS IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getHdnomops() != null) {
			where.append(" AND UPPER(t1.HDNOMOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getHdnomops().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getHdnomops().toUpperCase() + "%");
			}
			where.append(" AND t1.HDNOMOPS IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getHdnrlops() != null) {
			where.append(" AND UPPER(t1.HDNRLOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getHdnrlops().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getHdnrlops().toUpperCase() + "%");
			}
			where.append(" AND t1.HDNRLOPS IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getHdcodigobarras() != null) {
			where.append(" AND UPPER(t1.HDCODIGOBARRAS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getHdcodigobarras().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getHdcodigobarras().toUpperCase() + "%");
			}
			where.append(" AND t1.HDCODIGOBARRAS IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getHdinteresado() != null) {
			where.append(" AND UPPER(t1.HDINTERESADO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getHdinteresado().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getHdinteresado().toUpperCase() + "%");
			}
			where.append(" AND t1.HDINTERESADO IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getHdfedmps() != null) {
			where.append(" AND t1.HDFEDMPS like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getHdfedmps() + "%");
			} else {
				params.add("%" + hechodenunciado.getHdfedmps() + "%");
			}
			where.append(" AND t1.HDFEDMPS IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getHdinsotr() != null) {
			where.append(" AND UPPER(t1.HDINSOTR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getHdinsotr().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getHdinsotr().toUpperCase() + "%");
			}
			where.append(" AND t1.HDINSOTR IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getHdinsoma() != null) {
			where.append(" AND UPPER(t1.HDINSOMA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getHdinsoma().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getHdinsoma().toUpperCase() + "%");
			}
			where.append(" AND t1.HDINSOMA IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getHdcaptso() != null) {
			where.append(" AND t1.HDCAPTSO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getHdcaptso() + "%");
			} else {
				params.add("%" + hechodenunciado.getHdcaptso() + "%");
			}
			where.append(" AND t1.HDCAPTSO IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getHdteso() != null) {
			where.append(" AND UPPER(t1.HDTESO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getHdteso().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getHdteso().toUpperCase() + "%");
			}
			where.append(" AND t1.HDTESO IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getHdfeardt() != null) {
			where.append(" AND t1.HDFEARDT like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getHdfeardt() + "%");
			} else {
				params.add("%" + hechodenunciado.getHdfeardt() + "%");
			}
			where.append(" AND t1.HDFEARDT IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getHdfeiohd() != null) {
			where.append(" AND t1.HDFEIOHD like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getHdfeiohd() + "%");
			} else {
				params.add("%" + hechodenunciado.getHdfeiohd() + "%");
			}
			where.append(" AND t1.HDFEIOHD IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getHdininin() != null) {
			where.append(" AND UPPER(t1.HDINININ) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getHdininin().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getHdininin().toUpperCase() + "%");
			}
			where.append(" AND t1.HDINININ IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getHdfeiopc() != null) {
			where.append(" AND t1.HDFEIOPC like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getHdfeiopc() + "%");
			} else {
				params.add("%" + hechodenunciado.getHdfeiopc() + "%");
			}
			where.append(" AND t1.HDFEIOPC IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getHdferopc() != null) {
			where.append(" AND t1.HDFEROPC like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getHdferopc() + "%");
			} else {
				params.add("%" + hechodenunciado.getHdferopc() + "%");
			}
			where.append(" AND t1.HDFEROPC IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getHdcorepc() != null) {
			where.append(" AND UPPER(t1.HDCOREPC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getHdcorepc().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getHdcorepc().toUpperCase() + "%");
			}
			where.append(" AND t1.HDCOREPC IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getHdfeiorp() != null) {
			where.append(" AND t1.HDFEIORP like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getHdfeiorp() + "%");
			} else {
				params.add("%" + hechodenunciado.getHdfeiorp() + "%");
			}
			where.append(" AND t1.HDFEIORP IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getHdferorp() != null) {
			where.append(" AND t1.HDFERORP like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getHdferorp() + "%");
			} else {
				params.add("%" + hechodenunciado.getHdferorp() + "%");
			}
			where.append(" AND t1.HDFERORP IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getHdcoreap() != null) {
			where.append(" AND UPPER(t1.HDCOREAP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getHdcoreap().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getHdcoreap().toUpperCase() + "%");
			}
			where.append(" AND t1.HDCOREAP IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getHdfeiora() != null) {
			where.append(" AND t1.HDFEIORA like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getHdfeiora() + "%");
			} else {
				params.add("%" + hechodenunciado.getHdfeiora() + "%");
			}
			where.append(" AND t1.HDFEIORA IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getHdteacpa() != null) {
			where.append(" AND UPPER(t1.HDTEACPA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getHdteacpa().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getHdteacpa().toUpperCase() + "%");
			}
			where.append(" AND t1.HDTEACPA IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getHdfeceac() != null) {
			where.append(" AND t1.HDFECEAC like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getHdfeceac() + "%");
			} else {
				params.add("%" + hechodenunciado.getHdfeceac() + "%");
			}
			where.append(" AND t1.HDFECEAC IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getHdhoceac() != null) {
			where.append(" AND UPPER(t1.HDHOCEAC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getHdhoceac().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getHdhoceac().toUpperCase() + "%");
			}
			where.append(" AND t1.HDHOCEAC IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getHdfeioca() != null) {
			where.append(" AND t1.HDFEIOCA like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getHdfeioca() + "%");
			} else {
				params.add("%" + hechodenunciado.getHdfeioca() + "%");
			}
			where.append(" AND t1.HDFEIOCA IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getHdteacde() != null) {
			where.append(" AND UPPER(t1.HDTEACDE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getHdteacde().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getHdteacde().toUpperCase() + "%");
			}
			where.append(" AND t1.HDTEACDE IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getHdfeioac() != null) {
			where.append(" AND t1.HDFEIOAC like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getHdfeioac() + "%");
			} else {
				params.add("%" + hechodenunciado.getHdfeioac() + "%");
			}
			where.append(" AND t1.HDFEIOAC IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getHdfeiofc() != null) {
			where.append(" AND t1.HDFEIOFC like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getHdfeiofc() + "%");
			} else {
				params.add("%" + hechodenunciado.getHdfeiofc() + "%");
			}
			where.append(" AND t1.HDFEIOFC IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getHdcotra() != null) {
			where.append(" AND UPPER(t1.HDCOTRA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getHdcotra().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getHdcotra().toUpperCase() + "%");
			}
			where.append(" AND t1.HDCOTRA IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getHdte02() != null) {
			where.append(" AND UPPER(t1.HDTE02) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getHdte02().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getHdte02().toUpperCase() + "%");
			}
			where.append(" AND t1.HDTE02 IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getHdte03() != null) {
			where.append(" AND UPPER(t1.HDTE03) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getHdte03().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getHdte03().toUpperCase() + "%");
			}
			where.append(" AND t1.HDTE03 IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getHdte04() != null) {
			where.append(" AND UPPER(t1.HDTE04) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getHdte04().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getHdte04().toUpperCase() + "%");
			}
			where.append(" AND t1.HDTE04 IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getHdte05() != null) {
			where.append(" AND UPPER(t1.HDTE05) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getHdte05().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getHdte05().toUpperCase() + "%");
			}
			where.append(" AND t1.HDTE05 IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getHdte06() != null) {
			where.append(" AND UPPER(t1.HDTE06) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getHdte06().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getHdte06().toUpperCase() + "%");
			}
			where.append(" AND t1.HDTE06 IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getHdte07() != null) {
			where.append(" AND UPPER(t1.HDTE07) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getHdte07().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getHdte07().toUpperCase() + "%");
			}
			where.append(" AND t1.HDTE07 IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getHdte08() != null) {
			where.append(" AND UPPER(t1.HDTE08) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getHdte08().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getHdte08().toUpperCase() + "%");
			}
			where.append(" AND t1.HDTE08 IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getHdte09() != null) {
			where.append(" AND UPPER(t1.HDTE09) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getHdte09().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getHdte09().toUpperCase() + "%");
			}
			where.append(" AND t1.HDTE09 IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getHdte10() != null) {
			where.append(" AND UPPER(t1.HDTE10) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getHdte10().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getHdte10().toUpperCase() + "%");
			}
			where.append(" AND t1.HDTE10 IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getHdcosc() != null) {
			where.append(" AND UPPER(t1.HDCOSC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getHdcosc().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getHdcosc().toUpperCase() + "%");
			}
			where.append(" AND t1.HDCOSC IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getHdidal() != null) {
			where.append(" AND UPPER(t1.HDIDAL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getHdidal().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getHdidal().toUpperCase() + "%");
			}
			where.append(" AND t1.HDIDAL IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getHdferoad() != null) {
			where.append(" AND t1.HDFEROAD like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getHdferoad() + "%");
			} else {
				params.add("%" + hechodenunciado.getHdferoad() + "%");
			}
			where.append(" AND t1.HDFEROAD IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getHdferoat() != null) {
			where.append(" AND t1.HDFEROAT like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getHdferoat() + "%");
			} else {
				params.add("%" + hechodenunciado.getHdferoat() + "%");
			}
			where.append(" AND t1.HDFEROAT IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getHdtealdt() != null) {
			where.append(" AND UPPER(t1.HDTEALDT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getHdtealdt().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getHdtealdt().toUpperCase() + "%");
			}
			where.append(" AND t1.HDTEALDT IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getHdtedeat() != null) {
			where.append(" AND UPPER(t1.HDTEDEAT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getHdtedeat().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getHdtedeat().toUpperCase() + "%");
			}
			where.append(" AND t1.HDTEDEAT IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getHdfedeat() != null) {
			where.append(" AND t1.HDFEDEAT like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getHdfedeat() + "%");
			} else {
				params.add("%" + hechodenunciado.getHdfedeat() + "%");
			}
			where.append(" AND t1.HDFEDEAT IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getHdfehd() != null) {
			where.append(" AND t1.HDFEHD like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getHdfehd() + "%");
			} else {
				params.add("%" + hechodenunciado.getHdfehd() + "%");
			}
			where.append(" AND t1.HDFEHD IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getHdtedoade() != null) {
			where.append(" AND UPPER(t1.HDTEDOADE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getHdtedoade().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getHdtedoade().toUpperCase() + "%");
			}
			where.append(" AND t1.HDTEDOADE IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getHdtedoadi() != null) {
			where.append(" AND UPPER(t1.HDTEDOADI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getHdtedoadi().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getHdtedoadi().toUpperCase() + "%");
			}
			where.append(" AND t1.HDTEDOADI IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getHdtedoadf() != null) {
			where.append(" AND UPPER(t1.HDTEDOADF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getHdtedoadf().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getHdtedoadf().toUpperCase() + "%");
			}
			where.append(" AND t1.HDTEDOADF IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getHdtedoada() != null) {
			where.append(" AND UPPER(t1.HDTEDOADA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getHdtedoada().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getHdtedoada().toUpperCase() + "%");
			}
			where.append(" AND t1.HDTEDOADA IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getHdnopse() != null) {
			where.append(" AND UPPER(t1.HDNOPSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getHdnopse().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getHdnopse().toUpperCase() + "%");
			}
			where.append(" AND t1.HDNOPSE IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getHdnopsi() != null) {
			where.append(" AND UPPER(t1.HDNOPSI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getHdnopsi().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getHdnopsi().toUpperCase() + "%");
			}
			where.append(" AND t1.HDNOPSI IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getHdnopsf() != null) {
			where.append(" AND UPPER(t1.HDNOPSF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getHdnopsf().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getHdnopsf().toUpperCase() + "%");
			}
			where.append(" AND t1.HDNOPSF IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getHdnopsa() != null) {
			where.append(" AND UPPER(t1.HDNOPSA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getHdnopsa().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getHdnopsa().toUpperCase() + "%");
			}
			where.append(" AND t1.HDNOPSA IS NOT NULL");
		}
		if (hechodenunciado != null && hechodenunciado.getHdcocodigo() != null) {
			where.append(" AND UPPER(t1.HDCOCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(hechodenunciado.getHdcocodigo().toUpperCase() + "%");
			} else {
				params.add("%" + hechodenunciado.getHdcocodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.HDCOCODIGO IS NOT NULL");
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		}
		return (List<HechoDenunciado>) this.jdbcTemplate.query(query.toString(), rwMap, params.toArray());
	}

	/**
	 * Devuelve una lista con el numero de reclamaciones de un establecimiento
	 * por año.
	 * 
	 * @param hechodenunciado
	 *            HechoDenunciado
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<EstablecimientoReclamacionesAnyo> findAllEstablecimientoReclamacionesAnyo(
			HechoDenunciado hechodenunciado, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 and t1.HDCODE= t2.DECODIGO ");

		StringBuffer query = new StringBuffer(
				"SELECT t2.DENRAN DENRAN, COUNT(1) NUMRECLAMACIONES FROM  HECHO_DENUNCIADO t1,  DENUNCIA t2 ");

		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEscodigo() != null) {
			where.append(" and t1.HDCOES= ? ");
			params.add(hechodenunciado.getEstablecimiento().getEscodigo());
		}
		where.append(" GROUP BY DENRAN ");
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		}
		return (List<EstablecimientoReclamacionesAnyo>) this.jdbcTemplate.query(query.toString(),
				new RowMapper<EstablecimientoReclamacionesAnyo>() {
					public EstablecimientoReclamacionesAnyo mapRow(ResultSet resultSet, int rowNum)
							throws SQLException {
						return new EstablecimientoReclamacionesAnyo(resultSet.getBigDecimal("DENRAN"),
								resultSet.getBigDecimal("NUMRECLAMACIONES"));
					}
				}, params.toArray());
	}

	/**
	 * Counts rows in the HechoDenunciado table.
	 * 
	 * @param hechodenunciado
	 *            HechoDenunciado
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllEstablecimientoReclamacionesAnyoCount(HechoDenunciado hechodenunciado) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 and t1.HDCODE= t2.DECODIGO ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM(SELECT t2.DENRAN DENRAN, COUNT(1) FROM  HECHO_DENUNCIADO t1,  DENUNCIA t2 ");
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEscodigo() != null) {
			where.append(" and t1.HDCOES= ? ");
			params.add(hechodenunciado.getEstablecimiento().getEscodigo());
		}
		where.append(" GROUP BY DENRAN )");
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Devuelve una lista con el numero de reclamaciones de un establecimiento
	 * por decision y por año.
	 * 
	 * @param hechodenunciado
	 *            HechoDenunciado
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<EstablecimientoDecisionAnyo> findAllEstablecimientoDecisionAnyo(HechoDenunciado hechodenunciado,
			Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 and t1.HDCODE= t2.DECODIGO and t1.HDCODIGO = t4.HCCOHD and t4.HCCOTTD = t5.DECODIGO ");

		StringBuffer query = new StringBuffer(
				"SELECT t5.DECODIGO DECODIGO,t5.DENOMBRE DENOMBRE,t5.DENOMBREE DENOMBREE,t2.DENRAN DENRAN, COUNT(1) NUMRECLAMACIONES FROM  HECHO_DENUNCIADO t1,  DENUNCIA t2, DECISION_HECHO t4, DECISION t5 ");

		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEscodigo() != null) {
			where.append(" and t1.HDCOES =  ?");
			params.add(hechodenunciado.getEstablecimiento().getEscodigo());
		}
		where.append(" GROUP BY t5.DECODIGO,t5.DENOMBRE,t5.DENOMBREE,t2.DENRAN ");
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		}

		return (List<EstablecimientoDecisionAnyo>) this.jdbcTemplate.query(query.toString(),
				new RowMapper<EstablecimientoDecisionAnyo>() {
					public EstablecimientoDecisionAnyo mapRow(ResultSet resultSet, int rowNum) throws SQLException {
						return new EstablecimientoDecisionAnyo(resultSet.getString("DECODIGO"),
								resultSet.getString("DENOMBRE"), resultSet.getString("DENOMBREE"),
								resultSet.getBigDecimal("DENRAN"), resultSet.getBigDecimal("NUMRECLAMACIONES"));
					}
				}, params.toArray());
	}

	/**
	 * Counts rows in the HechoDenunciado table.
	 * 
	 * @param hechodenunciado
	 *            HechoDenunciado
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllEstablecimientoDecisionAnyoCount(HechoDenunciado hechodenunciado) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 and t1.HDCODE= t2.DECODIGO and t1.HDCODIGO = t4.HCCOHD and t4.HCCOTTD = t5.DECODIGO ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  (SELECT t5.DECODIGO DECODIGO,t5.DENOMBRE DENOMBRE,t5.DENOMBREE DENOMBREE,t2.DENRAN DENRAN, COUNT(1) NUMRECLAMACIONES FROM HECHO_DENUNCIADO t1,  DENUNCIA t2, DECISION_HECHO t4, DECISION t5   ");
		if (hechodenunciado != null && hechodenunciado.getEstablecimiento() != null
				&& hechodenunciado.getEstablecimiento().getEscodigo() != null) {
			where.append(" and t1.HDCOES =  ?");
			params.add(hechodenunciado.getEstablecimiento().getEscodigo());
		}
		where.append(" GROUP BY t5.DECODIGO,t5.DENOMBRE,t5.DENOMBREE,t2.DENRAN ) ");
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Devuelve una lista con las reclamaciones de un consumidor.
	 * 
	 * @param hechodenunciado
	 *            HechoDenunciado
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<ConsumidorReclamaciones> findAllConsumidorReclamaciones(HechoDenunciado hechodenunciado,
			Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND  t1.DECODIGO = t2.HDCODE AND t2.HDCOES= t3.ESCODIGO ");

		StringBuffer query = new StringBuffer(
				"SELECT t1.DECOOR DECOOR, t1.DENRAN DENRAN, t1.DENROR DENROR, t2.HDNROR HDNROR, t1.DEFEDE DEFEDE, t3.ESNOMBRE ESNOMBRE, t3.ESNIF ESNIF FROM DENUNCIA t1, HECHO_DENUNCIADO t2, ESTABLECIMIENTO t3 ");

		if (hechodenunciado != null && hechodenunciado.getDenuncia() != null
				&& hechodenunciado.getDenuncia().getConsumidor() != null
				&& hechodenunciado.getDenuncia().getConsumidor().getDtcodigo() != null) {
			where.append(" AND t1.DECODT = ? ");
			params.add(hechodenunciado.getDenuncia().getConsumidor().getDtcodigo());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		}

		return (List<ConsumidorReclamaciones>) this.jdbcTemplate.query(query.toString(),
				new RowMapper<ConsumidorReclamaciones>() {
					public ConsumidorReclamaciones mapRow(ResultSet resultSet, int rowNum) throws SQLException {
						return new ConsumidorReclamaciones(null, resultSet.getString("DECOOR"),
								resultSet.getBigDecimal("DENRAN"), resultSet.getBigDecimal("DENROR"),
								resultSet.getBigDecimal("HDNROR"), resultSet.getDate("DEFEDE"),
								resultSet.getString("ESNOMBRE"), resultSet.getString("ESNIF"), null);
					}
				}, params.toArray());
	}

	/**
	 * Counts rows in the HechoDenunciado table.
	 * 
	 * @param hechodenunciado
	 *            HechoDenunciado
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllConsumidorReclamacionesCount(HechoDenunciado hechodenunciado) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND  t1.DECODIGO = t2.HDCODE AND t2.HDCOES= t3.ESCODIGO ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM DENUNCIA t1, HECHO_DENUNCIADO t2, ESTABLECIMIENTO t3   ");
		if (hechodenunciado != null && hechodenunciado.getDenuncia() != null
				&& hechodenunciado.getDenuncia().getConsumidor() != null
				&& hechodenunciado.getDenuncia().getConsumidor().getDtcodigo() != null) {
			where.append(" AND t1.DECODT = ? ");
			params.add(hechodenunciado.getDenuncia().getConsumidor().getDtcodigo());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Devuelve una lista con las solicitudes de un organismo.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<SolicitudBusqueda> findAllLikeSolicitudes(SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();

		where.append(
				" WHERE 1=1  AND t1.DECODIGO= t4.HDCODE AND t1.DECODT= tt3CONSUMIDOR.DTCODIGO(+) AND t4.HDCODIGO= t3CONSUMIDOR.HDCODIGO(+) AND t3CONSUMIDOR.TIPO_INTERVINIENTE(+)='I' AND t4.HDCOES= tt7ESTABLECIMIENTO.ESCODIGO(+) AND t4.HDCODIGO= t7ESTABLECIMIENTO.HDCODIGO(+) AND t7ESTABLECIMIENTO.TIPO_INTERVINIENTE(+)='D' AND t4.FCODIGOACTUAL = t5.FCODIGO(+) AND t4.TRCODIGOACTUAL = t6.TRCODIGO(+) AND t4.HDCOMO = t8.MOCODIGO(+) AND t4.HDCODIGO = t9.HCCOHD AND t9.HCCOTTD=t14.DECODIGO(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT t1.DECOOR DECOOR, t1.DENRAN DENRAN, t1.DENROR DENROR, t4.HDNROR HDNROR, t4.HDCODIGO HDCODIGO, t1.DEFEDE DEFEDE, t1.DECODT DECODT, t3CONSUMIDOR.NOMBRE DTNOMBRE, t3CONSUMIDOR.APELLIDO1 DTAPELLIDO1, t3CONSUMIDOR.APELLIDO2 DTAPELLIDO2, t3CONSUMIDOR.NIF DTNIF, t3CONSUMIDOR.NOMBRE_MUNICIPIO DTNOMBRE_MUNICIPIO, t4.HDCOES HDCOES, t7ESTABLECIMIENTO.NOMBRE ESNOMBRE, t7ESTABLECIMIENTO.ESNOCO ESNOCO, t7ESTABLECIMIENTO.NIF ESNIF, t5.FCODIGO FCODIGO, t5.FNOMBRE FNOMBRE, t5.FNOMBREE FNOMBREE, t6.TRCODIGO TRCODIGO, t6.TRNOMBRE TRNOMBRE, t6.TRNOMBREE TRNOMBREE, t8.MOCODIGO MOCODIGO, t8.MONOMBRE MONOMBRE, t9.HCCOTTD DECODIGO, t14.DENOMBRE DENOMBRE, t14.DENOMBREE DENOMBREE "
						+ "FROM DENUNCIA t1,INTERVINIENTES t3CONSUMIDOR, CONSUMIDOR tt3CONSUMIDOR, HECHO_DENUNCIADO t4, INTERVINIENTES t7ESTABLECIMIENTO, ESTABLECIMIENTO tt7ESTABLECIMIENTO, FASE t5, TRAMITE t6, CENSO_MONITOR t8,DECISION_HECHO t9, DECISION t14 ");

		// hddenunciaaaccempresas
		if (solicitudesBusqueda != null && solicitudesBusqueda.getHddenunciaaaccempresas() != null
				&& Y41bConstantes.VALOR_SI.equals(solicitudesBusqueda.getHddenunciaaaccempresas())) {
			where.append(" AND UPPER(t4.HDDENUNCIAAACCEMPRESAS) = ?");
			params.add(Y41bConstantes.VALOR_SI);
			where.append(" AND t4.HDDENUNCIAAACCEMPRESAS IS NOT NULL");
		} else if (solicitudesBusqueda != null && solicitudesBusqueda.getHddenunciaaaccempresas() != null
				&& Y41bConstantes.SOLICITUDES_ACCESO_DESDE_TODOS
						.equals(solicitudesBusqueda.getHddenunciaaaccempresas())) {
			// Busca tanto en Solicitudes como en Denuncias AACC.
		} else {
			where.append(" AND t4.HDDENUNCIAAACCEMPRESAS IS NULL");
		}

		// organismo
		if (solicitudesBusqueda != null && solicitudesBusqueda.getDecoor() != null) {
			where.append(" AND UPPER(t1.DECOOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudesBusqueda.getDecoor().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudesBusqueda.getDecoor().toUpperCase() + "%");
			}
			where.append(" AND t1.DECOOR IS NOT NULL");
		}

		// anyo
		if (solicitudesBusqueda != null && solicitudesBusqueda.getDenran() != null) {
			where.append(" AND t1.DENRAN = ? ");
			params.add(solicitudesBusqueda.getDenran());
		}

		// correlativo
		if (solicitudesBusqueda != null && solicitudesBusqueda.getDenror() != null) {
			where.append(" AND t1.DENROR = ? ");
			params.add(solicitudesBusqueda.getDenror());
		}

		// organismo seleccionado
		if (solicitudesBusqueda != null && solicitudesBusqueda.getCodOrgSeleccionado() != null) {
			where.append(" AND t9.HCCOOR = ? ");
			params.add(solicitudesBusqueda.getCodOrgSeleccionado());
		}

		// Instructor Expediente
		if (solicitudesBusqueda != null && solicitudesBusqueda.getMocodigoExpediente() != null) {
			where.append(" AND t4.HDCOMO = ? ");
			params.add(solicitudesBusqueda.getMocodigoExpediente());
		}

		// fecha presentacion desde
		if (solicitudesBusqueda != null && solicitudesBusqueda.getDefedeDesde() != null) {
			where.append(" AND t1.DEFEDE >= ?");
			params.add(solicitudesBusqueda.getDefedeDesde());
		}
		// fecha presentacion hasta
		if (solicitudesBusqueda != null && solicitudesBusqueda.getDefedeHasta() != null) {
			where.append(" AND t1.DEFEDE <= ?");
			params.add(solicitudesBusqueda.getDefedeHasta());
		}

		// Tipo solicitud
		if (solicitudesBusqueda != null && solicitudesBusqueda.getHdcosc() != null) {
			where.append(" AND t4.HDCOSC = ? ");
			params.add(solicitudesBusqueda.getHdcosc());
		}

		// fecha registro desde
		if (solicitudesBusqueda != null && solicitudesBusqueda.getDefereDesde() != null) {
			where.append(" AND t1.DEFERE >= ?");
			params.add(solicitudesBusqueda.getDefereDesde());
		}
		// fecha registro hasta
		if (solicitudesBusqueda != null && solicitudesBusqueda.getDefereHasta() != null) {
			where.append(" AND t1.DEFERE <= ?");
			params.add(solicitudesBusqueda.getDefereHasta());
		}

		// tipo forma presentacion
		if (solicitudesBusqueda != null && solicitudesBusqueda.getTfpcodigo() != null) {
			where.append(" AND t1.DECOTFP = ? ");
			params.add(solicitudesBusqueda.getTfpcodigo());
		}

		/*
		 * Colección de descriptores a las que pueden pertenecer las denuncias
		 */
		if (solicitudesBusqueda != null && solicitudesBusqueda.getDescriptores() != null
				&& solicitudesBusqueda.getDescriptores().size() > 0) {

			where.append(" AND t4.HDCODIGO IN (SELECT HDCODIGO FROM HECHODENUNCIA_DESCRIPTOR WHERE ");
			boolean firstElement = true;

			for (Descriptor e : solicitudesBusqueda.getDescriptores()) {

				if (firstElement) {

					where.append("ID_DESCRIPTOR = ?");
					params.add(e.getIdDescriptor());
					firstElement = false;

				} else {

					where.append(" OR ID_DESCRIPTOR = ?");
					params.add(e.getIdDescriptor());
				}
			}

			where.append(") ");
		}

		// tipo forma notificacion
		if (solicitudesBusqueda != null && solicitudesBusqueda.getHdformanotificacion() != null) {
			where.append(" AND t4.HDFORMANOTIFICACION = ? ");
			params.add(solicitudesBusqueda.getHdformanotificacion());
		}

		// Codigo expediente origen
		if (solicitudesBusqueda != null && solicitudesBusqueda.getHdcodexpedienteorigen() != null) {
			where.append(" AND UPPER(t4.HDCODEXPEDIENTEORIGEN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudesBusqueda.getHdcodexpedienteorigen().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudesBusqueda.getHdcodexpedienteorigen().toUpperCase() + "%");
			}
			where.append(" AND t4.HDCODEXPEDIENTEORIGEN IS NOT NULL");
		}

		// Numero registro de entrada
		if (solicitudesBusqueda != null && solicitudesBusqueda.getNumregistroentrada() != null) {
			where.append(" AND UPPER(t4.HDNUMREGISTROENTRADA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudesBusqueda.getNumregistroentrada().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudesBusqueda.getNumregistroentrada().toUpperCase() + "%");
			}
			where.append(" AND t4.HDNUMREGISTROENTRADA IS NOT NULL");
		}

		// Tipo denunciante
		if (solicitudesBusqueda != null && solicitudesBusqueda.getHdtipodenunciante() != null) {
			where.append(" AND t4.HDTIPODENUNCIANTE = ? ");
			params.add(solicitudesBusqueda.getHdtipodenunciante());
		}

		// Fase
		if (solicitudesBusqueda != null && solicitudesBusqueda.getFcodigo() != null) {
			where.append(" AND t4.FCODIGOACTUAL = ? ");
			params.add(solicitudesBusqueda.getFcodigo());
		}

		// Tramite
		if (solicitudesBusqueda != null && solicitudesBusqueda.getTrcodigo() != null) {
			where.append(
					" AND EXISTS (SELECT EHCOHD FROM TRAMITE_HECHO tr1 WHERE tr1.EHCOHD=t4.HDCODIGO AND EHCOTEE = ?) ");
			params.add(solicitudesBusqueda.getTrcodigo());

			if (solicitudesBusqueda != null && solicitudesBusqueda.getIndUltimoTramite() != null
					&& solicitudesBusqueda.getIndUltimoTramite().equals(Y41bConstantes.VALOR_SI)) {
				where.append(" AND t4.TRCODIGOACTUAL = ? ");
				params.add(solicitudesBusqueda.getTrcodigo());
			}
		}

		// Decision
		if (solicitudesBusqueda != null && solicitudesBusqueda.getDecodigo() != null) {
			// where.append(" AND t9.HCCOTTD IN (SELECT t1.DECODIGO DECODIGO
			// FROM DECISION t1 WHERE 1=1 AND t1.DENOMBRE = (SELECT t1.DENOMBRE
			// DENOMBRE FROM DECISION t1 WHERE t1.DECODIGO=?)) ");
			where.append(
					" AND (EXISTS (SELECT t1.DECODIGO DECODIGO FROM DECISION t1, DECISION_HECHO t2 WHERE 1=1 AND t1.DECODIGO=t2.HCCOTTD AND t2.HCCOHD=t4.HDCODIGO AND t1.DENOMBRE = (SELECT t1.DENOMBRE DENOMBRE FROM DECISION t1 WHERE t1.DECODIGO=?)) ");
			params.add(solicitudesBusqueda.getDecodigo());

			where.append(
					" OR EXISTS (SELECT tt2.HCCOTTD HCCOTTD FROM DECISION_HECHO tt2 WHERE 1=1 AND tt2.HCCOHD=t4.HDCODIGO AND tt2.HCCOTTD IN (SELECT t1.DECODIGOL21 FROM CORRESPONDENCIA_DECISION_L21 t1 WHERE t1.DECODIGOY41B=?))) ");
			params.add(solicitudesBusqueda.getDecodigo());
		}

		// Tramitador
		if (solicitudesBusqueda != null && solicitudesBusqueda.getMocodigoTramitador() != null) {

			if (solicitudesBusqueda != null && solicitudesBusqueda.getIndUltimoTramite() != null
					&& solicitudesBusqueda.getIndUltimoTramite().equals(Y41bConstantes.VALOR_SI)) {
				where.append(
						" AND t4.TRCODIGOACTUAL IN (SELECT EHCOTEE FROM TRAMITE_HECHO tr1 WHERE tr1.EHCOHD=t4.HDCODIGO AND tr1.EHCOMO = ?  AND EHFECHA = (SELECT MAX(EHFECHA) FROM TRAMITE_HECHO tr2 WHERE tr2.EHCOHD=t4.HDCODIGO ) AND NVL(EHHORA, 0) = (SELECT NVL(MAX(EHHORA), 0) FROM TRAMITE_HECHO tr3 WHERE tr1.EHFECHA = tr3.EHFECHA AND tr3.EHCOHD=t4.HDCODIGO)) ");
				params.add(solicitudesBusqueda.getMocodigoTramitador());
			} else {
				where.append(
						" AND EXISTS (SELECT EHCOHD FROM TRAMITE_HECHO tr1 WHERE tr1.EHCOHD=t4.HDCODIGO AND tr1.EHCOMO = ?) ");
				params.add(solicitudesBusqueda.getMocodigoTramitador());
			}
		}

		// Incluir expedientes cerrados
		if ((solicitudesBusqueda != null && solicitudesBusqueda.getIndIncluirCerrados() == null)
				|| (solicitudesBusqueda != null && solicitudesBusqueda.getIndIncluirCerrados() != null
						&& !solicitudesBusqueda.getIndIncluirCerrados().equals(Y41bConstantes.VALOR_SI))) {
			where.append(" AND t4.HDFECHACIERRE IS NULL ");
		}

		// Con acuse de recibo pendientes
		if (solicitudesBusqueda != null && solicitudesBusqueda.getIndPendienteAcuse() != null
				&& solicitudesBusqueda.getIndPendienteAcuse().equals(Y41bConstantes.VALOR_SI)) {
			where.append(
					" AND EXISTS (SELECT EHCOHD FROM TRAMITE_HECHO tr1 WHERE tr1.EHCOHD=t4.HDCODIGO AND tr1.EHCOTEE = ? AND tr1.EHFECHAFIN IS NULL) ");
			params.add(Y41bConstantes.TRAMITE_ACUSE_RECIBO);
		}

		// Con decision pendiente
		if (solicitudesBusqueda != null && solicitudesBusqueda.getIndPendienteDecision() != null
				&& solicitudesBusqueda.getIndPendienteDecision().equals(Y41bConstantes.VALOR_SI)) {
			where.append(" AND (t9.HCCOTTD IS NULL ");

			where.append(" OR t9.HCCOTTD=?) ");
			params.add(Y41bConstantes.DECISION_SINDECISION);
		}

		// Con pendiente firma
		if (solicitudesBusqueda != null && solicitudesBusqueda.getIndPendienteFirma() != null
				&& solicitudesBusqueda.getIndPendienteFirma().equals(Y41bConstantes.VALOR_SI)) {
			where.append(
					" AND EXISTS (SELECT EHCOHD FROM TRAMITE_HECHO tr1 WHERE tr1.EHCOHD=t4.HDCODIGO AND tr1.EHESTADOTRAMITE = ?) ");
			params.add(Y41bConstantes.ESTADO_TRAMITE_PENDIENTEFIRMA);
		}

		// fecha decision desde
		if (solicitudesBusqueda != null && solicitudesBusqueda.getEhfechafinDecisionDesde() != null) {
			where.append(" AND t9.HCFEDE >= ?");
			params.add(solicitudesBusqueda.getEhfechafinDecisionDesde());
		}

		// fecha decision hasta
		if (solicitudesBusqueda != null && solicitudesBusqueda.getEhfechafinDecisionHasta() != null) {
			where.append(" AND t9.HCFEDE <= ?");
			params.add(solicitudesBusqueda.getEhfechafinDecisionHasta());
		}

		// Nombre persona consumidora
		if (solicitudesBusqueda != null && solicitudesBusqueda.getDtnombre() != null) {
			where.append(" AND ((TRANSLATE(UPPER(t3CONSUMIDOR.NOMBRE),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudesBusqueda.getDtnombre().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + solicitudesBusqueda.getDtnombre().toUpperCase().replaceAll("", "A")
						.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t3CONSUMIDOR.NOMBRE IS NOT NULL AND t4.FCODIGOACTUAL IS NOT NULL) ");

			where.append(" OR (TRANSLATE(UPPER(tt3CONSUMIDOR.DTNOMBRE),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudesBusqueda.getDtnombre().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + solicitudesBusqueda.getDtnombre().toUpperCase().replaceAll("", "A")
						.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND tt3CONSUMIDOR.DTNOMBRE IS NOT NULL  AND t4.FCODIGOACTUAL IS NULL)) ");
		}

		// Apellido1 persona consumidora
		if (solicitudesBusqueda != null && solicitudesBusqueda.getDtapellido1() != null) {
			where.append(" AND ((TRANSLATE(UPPER(t3CONSUMIDOR.APELLIDO1),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudesBusqueda.getDtapellido1().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + solicitudesBusqueda.getDtapellido1().toUpperCase().replaceAll("", "A")
						.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t3CONSUMIDOR.APELLIDO1 IS NOT NULL  AND t4.FCODIGOACTUAL IS NOT NULL) ");

			where.append(" OR (TRANSLATE(UPPER(tt3CONSUMIDOR.DTAPELLIDO1),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudesBusqueda.getDtapellido1().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + solicitudesBusqueda.getDtapellido1().toUpperCase().replaceAll("", "A")
						.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND tt3CONSUMIDOR.DTAPELLIDO1 IS NOT NULL AND t4.FCODIGOACTUAL IS NULL)) ");

		}

		// Apellido2 persona consumidora
		if (solicitudesBusqueda != null && solicitudesBusqueda.getDtapellido2() != null) {
			where.append(" AND ((TRANSLATE(UPPER(t3CONSUMIDOR.APELLIDO2),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudesBusqueda.getDtapellido2().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + solicitudesBusqueda.getDtapellido2().toUpperCase().replaceAll("", "A")
						.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t3CONSUMIDOR.APELLIDO2 IS NOT NULL AND t4.FCODIGOACTUAL IS NOT NULL) ");

			where.append(" OR (TRANSLATE(UPPER(tt3CONSUMIDOR.DTAPELLIDO2),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudesBusqueda.getDtapellido2().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + solicitudesBusqueda.getDtapellido2().toUpperCase().replaceAll("", "A")
						.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND tt3CONSUMIDOR.DTAPELLIDO2 IS NOT NULL AND t4.FCODIGOACTUAL IS NULL)) ");
		}

		// Dni persona consumidora
		if (solicitudesBusqueda != null && solicitudesBusqueda.getDtnif() != null) {
			where.append(" AND ((UPPER(t3CONSUMIDOR.NIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudesBusqueda.getDtnif().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudesBusqueda.getDtnif().toUpperCase() + "%");
			}
			where.append(" AND t3CONSUMIDOR.NIF IS NOT NULL AND t4.FCODIGOACTUAL IS NOT NULL) ");

			where.append(" OR (UPPER(tt3CONSUMIDOR.DTNIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudesBusqueda.getDtnif().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudesBusqueda.getDtnif().toUpperCase() + "%");
			}
			where.append(" AND tt3CONSUMIDOR.DTNIF IS NOT NULL AND t4.FCODIGOACTUAL IS NULL)) ");
		}

		if (solicitudesBusqueda != null && solicitudesBusqueda.getDtextranjero() != null
				&& solicitudesBusqueda.getDtestado() == null) {
			where.append(" AND ((t3CONSUMIDOR.EXTRANJERO = ? AND t4.FCODIGOACTUAL IS NOT NULL)");
			params.add(Y41bConstantes.SI);

			where.append(" OR (tt3CONSUMIDOR.DTEXTRANJERO = ? AND t4.FCODIGOACTUAL IS NULL)) ");
			params.add(Y41bConstantes.SI);
		}
		if (solicitudesBusqueda != null && solicitudesBusqueda.getDtestado() != null
				&& solicitudesBusqueda.getDtextranjero() == null) {
			where.append(" AND ((t3CONSUMIDOR.EXTRANJERO = ? AND t4.FCODIGOACTUAL IS NOT NULL)");
			params.add(Y41bConstantes.NO);

			where.append(" OR (tt3CONSUMIDOR.DTEXTRANJERO = ? AND t4.FCODIGOACTUAL IS NULL)) ");
			params.add(Y41bConstantes.NO);
		}

		// Provincia persona consumidora
		if (solicitudesBusqueda != null && solicitudesBusqueda.getDtnoraProvinciaId() != null) {
			where.append(" AND ((t3CONSUMIDOR.NORA_PROVINCIA_ID = ? AND t4.FCODIGOACTUAL IS NOT NULL)");
			params.add(solicitudesBusqueda.getDtnoraProvinciaId());

			where.append(" OR (tt3CONSUMIDOR.DTNORA_PROVINCIA_ID = ? AND t4.FCODIGOACTUAL IS NULL)) ");
			params.add(solicitudesBusqueda.getDtnoraProvinciaId());
		}

		// Municipio persona consumidora
		if (solicitudesBusqueda != null && solicitudesBusqueda.getDtnoraMunicipioId() != null) {
			where.append(" AND ((t3CONSUMIDOR.NORA_MUNICIPIO_ID = ? AND t4.FCODIGOACTUAL IS NOT NULL)");
			params.add(solicitudesBusqueda.getDtnoraMunicipioId());

			where.append(" OR (tt3CONSUMIDOR.DTNORA_MUNICIPIO_ID = ? AND t4.FCODIGOACTUAL IS NULL)) ");
			params.add(solicitudesBusqueda.getDtnoraMunicipioId());

		}

		// Localidad persona consumidora
		if (solicitudesBusqueda != null && solicitudesBusqueda.getDtnoraLocalidadId() != null) {
			where.append(" AND ((t3CONSUMIDOR.NORA_LOCALIDAD_ID = ?  AND t4.FCODIGOACTUAL IS NOT NULL) ");
			params.add(solicitudesBusqueda.getDtnoraLocalidadId());

			where.append(" OR (tt3CONSUMIDOR.DTNORA_LOCALIDAD_ID = ? AND t4.FCODIGOACTUAL IS NULL)) ");
			params.add(solicitudesBusqueda.getDtnoraLocalidadId());

		}

		// Pais persona consumidora
		if (solicitudesBusqueda != null && solicitudesBusqueda.getDtnoraPaisId() != null) {
			where.append(" AND ((t3CONSUMIDOR.NORA_PAIS_ID = ? AND t4.FCODIGOACTUAL IS NOT NULL) ");
			params.add(solicitudesBusqueda.getDtnoraPaisId());

			where.append(" OR (tt3CONSUMIDOR.DTNORA_PAIS_ID = ? AND t4.FCODIGOACTUAL IS NULL)) ");
			params.add(solicitudesBusqueda.getDtnoraPaisId());

		}

		// Direccion extranjera persona consumidora
		if (solicitudesBusqueda != null && solicitudesBusqueda.getDtdireccion_nocapv() != null) {
			where.append(" AND ((TRANSLATE(UPPER(t3CONSUMIDOR.DIRECCION_NOCAPV),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudesBusqueda.getDtdireccion_nocapv().toUpperCase().replaceAll("", "A")
						.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%"
						+ solicitudesBusqueda.getDtdireccion_nocapv().toUpperCase().replaceAll("", "A")
								.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U")
						+ "%");
			}
			where.append(" AND t3CONSUMIDOR.DIRECCION_NOCAPV IS NOT NULL AND t4.FCODIGOACTUAL IS NOT NULL) ");

			where.append(" OR (TRANSLATE(UPPER(tt3CONSUMIDOR.DTDIRECCION_NOCAPV),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudesBusqueda.getDtdireccion_nocapv().toUpperCase().replaceAll("", "A")
						.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%"
						+ solicitudesBusqueda.getDtdireccion_nocapv().toUpperCase().replaceAll("", "A")
								.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U")
						+ "%");
			}
			where.append(" AND tt3CONSUMIDOR.DTDIRECCION_NOCAPV IS NOT NULL AND t4.FCODIGOACTUAL IS NULL))");

		}

		// Establecimiento por nombre o normbre comercial
		if (solicitudesBusqueda != null && solicitudesBusqueda.getEsnombre() != null) {
			where.append(" AND ((TRANSLATE(UPPER(t7ESTABLECIMIENTO.NOMBRE),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudesBusqueda.getEsnombre().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + solicitudesBusqueda.getEsnombre().toUpperCase().replaceAll("", "A")
						.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t7ESTABLECIMIENTO.NOMBRE IS NOT NULL AND t4.FCODIGOACTUAL IS NOT NULL) ");

			where.append(" OR (TRANSLATE(UPPER(tt7ESTABLECIMIENTO.ESNOMBRE),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudesBusqueda.getEsnombre().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + solicitudesBusqueda.getEsnombre().toUpperCase().replaceAll("", "A")
						.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND tt7ESTABLECIMIENTO.ESNOMBRE IS NOT NULL AND t4.FCODIGOACTUAL IS NULL) ");

			where.append(" OR (TRANSLATE(UPPER(t7ESTABLECIMIENTO.ESNOCO),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudesBusqueda.getEsnombre().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + solicitudesBusqueda.getEsnombre().toUpperCase().replaceAll("", "A")
						.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t7ESTABLECIMIENTO.ESNOCO IS NOT NULL AND t4.FCODIGOACTUAL IS NOT NULL) ");

			where.append(" OR (TRANSLATE(UPPER(tt7ESTABLECIMIENTO.ESNOCO),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudesBusqueda.getEsnombre().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + solicitudesBusqueda.getEsnombre().toUpperCase().replaceAll("", "A")
						.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND tt7ESTABLECIMIENTO.ESNOCO IS NOT NULL AND t4.FCODIGOACTUAL IS NULL)) ");

		}

		// NIF establecimiento
		if (solicitudesBusqueda != null && solicitudesBusqueda.getEsnif() != null) {
			where.append(" AND ((UPPER(t7ESTABLECIMIENTO.NIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudesBusqueda.getEsnif().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudesBusqueda.getEsnif().toUpperCase() + "%");
			}
			where.append(" AND t7ESTABLECIMIENTO.NIF IS NOT NULL  AND t4.FCODIGOACTUAL IS NOT NULL) ");

			where.append(" OR (UPPER(tt7ESTABLECIMIENTO.ESNIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudesBusqueda.getEsnif().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudesBusqueda.getEsnif().toUpperCase() + "%");
			}
			where.append(" AND tt7ESTABLECIMIENTO.ESNIF IS NOT NULL AND t4.FCODIGOACTUAL IS NULL)) ");

		}

		if (solicitudesBusqueda != null && solicitudesBusqueda.getEsextranjero() != null
				&& solicitudesBusqueda.getEsestado() == null) {
			where.append(" AND ((t7ESTABLECIMIENTO.EXTRANJERO = ? AND t4.FCODIGOACTUAL IS NOT NULL) ");
			params.add(Y41bConstantes.SI);
			where.append(" OR (tt7ESTABLECIMIENTO.ESEXTRANJERO = ? AND t4.FCODIGOACTUAL IS NULL))");
			params.add(Y41bConstantes.SI);
		}
		if (solicitudesBusqueda != null && solicitudesBusqueda.getEsestado() != null
				&& solicitudesBusqueda.getEsextranjero() == null) {
			where.append(" AND ((t7ESTABLECIMIENTO.EXTRANJERO = ? AND t4.FCODIGOACTUAL IS NOT NULL)");
			params.add(Y41bConstantes.NO);
			where.append(" OR (tt7ESTABLECIMIENTO.ESEXTRANJERO = ? AND t4.FCODIGOACTUAL IS NULL)) ");
			params.add(Y41bConstantes.NO);
		}

		// Provincia establecimiento
		if (solicitudesBusqueda != null && solicitudesBusqueda.getEsnoraProvinciaId() != null) {
			where.append(" AND ((t7ESTABLECIMIENTO.NORA_PROVINCIA_ID = ? AND t4.FCODIGOACTUAL IS NOT NULL)");
			params.add(solicitudesBusqueda.getEsnoraProvinciaId());
			where.append(" OR (tt7ESTABLECIMIENTO.ESNORA_PROVINCIA_ID = ? AND t4.FCODIGOACTUAL IS NULL)) ");
			params.add(solicitudesBusqueda.getEsnoraProvinciaId());
		}

		// Municipio establecimiento
		if (solicitudesBusqueda != null && solicitudesBusqueda.getEsnoraMunicipioId() != null) {
			where.append(" AND ((t7ESTABLECIMIENTO.NORA_MUNICIPIO_ID = ? AND t4.FCODIGOACTUAL IS NOT NULL)");
			params.add(solicitudesBusqueda.getEsnoraMunicipioId());
			where.append(" OR (tt7ESTABLECIMIENTO.ESNORA_MUNICIPIO_ID = ? AND t4.FCODIGOACTUAL IS NULL)) ");
			params.add(solicitudesBusqueda.getEsnoraMunicipioId());
		}

		// Localidad establecimiento
		if (solicitudesBusqueda != null && solicitudesBusqueda.getEsnoraLocalidadId() != null) {
			where.append(" AND ((t7ESTABLECIMIENTO.NORA_LOCALIDAD_ID = ?  AND t4.FCODIGOACTUAL IS NOT NULL)");
			params.add(solicitudesBusqueda.getEsnoraLocalidadId());
			where.append(" OR (tt7ESTABLECIMIENTO.ESNORA_LOCALIDAD_ID = ? AND t4.FCODIGOACTUAL IS NULL)) ");
			params.add(solicitudesBusqueda.getEsnoraLocalidadId());
		}

		// Pais establecimiento
		if (solicitudesBusqueda != null && solicitudesBusqueda.getEsnoraPaisId() != null) {
			where.append(" AND ((t7ESTABLECIMIENTO.NORA_PAIS_ID = ? AND t4.FCODIGOACTUAL IS NOT NULL)");
			params.add(solicitudesBusqueda.getEsnoraPaisId());
			where.append(" OR (tt7ESTABLECIMIENTO.ESNORA_PAIS_ID = ? AND t4.FCODIGOACTUAL IS NULL)) ");
			params.add(solicitudesBusqueda.getEsnoraPaisId());
		}

		// Direccion extranjera establecimiento
		if (solicitudesBusqueda != null && solicitudesBusqueda.getEsdireccion_nocapv() != null) {
			where.append(
					" AND ((TRANSLATE(UPPER(t7ESTABLECIMIENTO.DIRECCION_NOCAPV),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudesBusqueda.getEsdireccion_nocapv().toUpperCase().replaceAll("", "A")
						.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%"
						+ solicitudesBusqueda.getEsdireccion_nocapv().toUpperCase().replaceAll("", "A")
								.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U")
						+ "%");
			}
			where.append(" AND t7ESTABLECIMIENTO.DIRECCION_NOCAPV IS NOT NULL AND t4.FCODIGOACTUAL IS NOT NULL)");

			where.append(
					" OR (TRANSLATE(UPPER(tt7ESTABLECIMIENTO.ESDIRECCION_NOCAPV),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudesBusqueda.getEsdireccion_nocapv().toUpperCase().replaceAll("", "A")
						.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%"
						+ solicitudesBusqueda.getEsdireccion_nocapv().toUpperCase().replaceAll("", "A")
								.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U")
						+ "%");
			}
			where.append(" AND tt7ESTABLECIMIENTO.ESDIRECCION_NOCAPV IS NOT NULL AND t4.FCODIGOACTUAL IS NULL))");
		}
		// Busqueda de solicitudes para alta de arbitrajes
		/*
		 * if (solicitudesBusqueda != null && solicitudesBusqueda.getOrigen() !=
		 * null && solicitudesBusqueda.getOrigen().equals(
		 * Y41bConstantes.TIPO_PROC_ARBITRAJE)) { // est cerrada //
		 * where.append(" AND t4.HDFECHACIERRE IS NOT NULL ");
		 * 
		 * // no este relacionada con solicitud previa de arbitraje
		 * //where.append( //
		 * " AND NOT EXISTS (SELECT 1 FROM SANEXPREL t10SANEXPREL WHERE  t10SANEXPREL.RLARBCODIGO IS NOT NULL  AND t10SANEXPREL.RLHDCODREL=t4.HDCODIGO AND (t10SANEXPREL.RLESORIG=?)  ) "
		 * //); params.add(Y41bConstantes.TIPO_ARB_EXPREL_ORIGEN); // // y que
		 * exista fecha de decisin where.append(" AND t9.HCFEDE IS NOT NULL ");
		 * // la solicitud tiene que tener decisin y de un tipo concreto if
		 * (Y41bConstantes.DECISIONES_ARBITRAJE_NO_ADMITIDAS != null &&
		 * Y41bConstantes.DECISIONES_ARBITRAJE_NO_ADMITIDAS.length > 0) {
		 * where.append("AND t9.HCCOTTD IS NOT NULL AND t9.HCCOTTD NOT IN (");
		 * 
		 * for (int i = 0; i <
		 * Y41bConstantes.DECISIONES_ARBITRAJE_NO_ADMITIDAS.length; i++) {
		 * where.append("? "); if (i !=
		 * Y41bConstantes.DECISIONES_ARBITRAJE_NO_ADMITIDAS.length - 1) {
		 * where.append(", "); }
		 * params.add(Y41bConstantes.DECISIONES_ARBITRAJE_NO_ADMITIDAS[i]); }
		 * 
		 * where.append(" ) ");
		 * 
		 * } }
		 */

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		}

		return (List<SolicitudBusqueda>) this.jdbcTemplate.query(query.toString(), new RowMapper<SolicitudBusqueda>() {
			public SolicitudBusqueda mapRow(ResultSet resultSet, int rowNum) throws SQLException {
				return new SolicitudBusqueda(resultSet.getString("HDCODIGO"), resultSet.getString("DECOOR"),
						resultSet.getBigDecimal("DENRAN"), resultSet.getBigDecimal("DENROR"),
						resultSet.getBigDecimal("HDNROR"), null, null, null, resultSet.getString("MOCODIGO"),
						resultSet.getString("MONOMBRE"), resultSet.getDate("DEFEDE"), null, null, null, null, null,
						null, null, null, null, resultSet.getString("FCODIGO"), resultSet.getString("FNOMBRE"),
						resultSet.getString("FNOMBREE"), resultSet.getString("TRCODIGO"),
						resultSet.getString("TRNOMBRE"), resultSet.getString("TRNOMBREE"),
						resultSet.getString("DECODIGO"), resultSet.getString("DENOMBRE"),
						resultSet.getString("DENOMBREE"), null, null, null, null, null, null, null, null, null,
						resultSet.getString("DTNOMBRE"), resultSet.getString("DTAPELLIDO1"),
						resultSet.getString("DTAPELLIDO2"), resultSet.getString("DTNIF"), null, null, null, null, null,
						null, null, null, null, null, null, resultSet.getString("ESNOMBRE"),
						resultSet.getString("ESNIF"), resultSet.getString("ESNOCO"), null, null, null, null, null, null,
						null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
						null, null, resultSet.getString("DECODT"), resultSet.getString("HDCOES"), null, null);
			}
		}, params.toArray());
	}

	/**
	 * Counts rows in the HechoDenunciado table.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeSolicitudesCount(SolicitudBusqueda solicitudesBusqueda, Boolean startsWith) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(
				" WHERE 1=1  AND t1.DECODIGO= t4.HDCODE AND t1.DECODT= tt3CONSUMIDOR.DTCODIGO(+) AND t4.HDCODIGO= t3CONSUMIDOR.HDCODIGO(+) AND t3CONSUMIDOR.TIPO_INTERVINIENTE(+)='I' AND t4.HDCOES= tt7ESTABLECIMIENTO.ESCODIGO(+) AND t4.HDCODIGO= t7ESTABLECIMIENTO.HDCODIGO(+) AND t7ESTABLECIMIENTO.TIPO_INTERVINIENTE(+)='D' AND t4.FCODIGOACTUAL = t5.FCODIGO(+) AND t4.TRCODIGOACTUAL = t6.TRCODIGO(+) AND t4.HDCOMO = t8.MOCODIGO(+) AND t4.HDCODIGO = t9.HCCOHD AND t9.HCCOTTD=t14.DECODIGO(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(t4.HDCODIGO) FROM DENUNCIA t1,INTERVINIENTES t3CONSUMIDOR, CONSUMIDOR tt3CONSUMIDOR, HECHO_DENUNCIADO t4, INTERVINIENTES t7ESTABLECIMIENTO, ESTABLECIMIENTO tt7ESTABLECIMIENTO, FASE t5, TRAMITE t6, CENSO_MONITOR t8,DECISION_HECHO t9, DECISION t14 ");

		// hddenunciaaaccempresas
		if (solicitudesBusqueda != null && solicitudesBusqueda.getHddenunciaaaccempresas() != null
				&& Y41bConstantes.VALOR_SI.equals(solicitudesBusqueda.getHddenunciaaaccempresas())) {
			where.append(" AND UPPER(t4.HDDENUNCIAAACCEMPRESAS) = ?");
			params.add(Y41bConstantes.VALOR_SI);
			where.append(" AND t4.HDDENUNCIAAACCEMPRESAS IS NOT NULL");
		} else if (solicitudesBusqueda != null && solicitudesBusqueda.getHddenunciaaaccempresas() != null
				&& Y41bConstantes.SOLICITUDES_ACCESO_DESDE_TODOS
						.equals(solicitudesBusqueda.getHddenunciaaaccempresas())) {
			// Busca tanto en Solicitudes como en Denuncias AACC.
		} else {
			where.append(" AND t4.HDDENUNCIAAACCEMPRESAS IS NULL");
		}

		// organismo
		if (solicitudesBusqueda != null && solicitudesBusqueda.getDecoor() != null) {
			where.append(" AND UPPER(t1.DECOOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudesBusqueda.getDecoor().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudesBusqueda.getDecoor().toUpperCase() + "%");
			}
			where.append(" AND t1.DECOOR IS NOT NULL");
		}

		// anyo
		if (solicitudesBusqueda != null && solicitudesBusqueda.getDenran() != null) {
			where.append(" AND t1.DENRAN = ? ");
			params.add(solicitudesBusqueda.getDenran());
		}

		// correlativo
		if (solicitudesBusqueda != null && solicitudesBusqueda.getDenror() != null) {
			where.append(" AND t1.DENROR = ? ");
			params.add(solicitudesBusqueda.getDenror());
		}

		// organismo seleccionado
		if (solicitudesBusqueda != null && solicitudesBusqueda.getCodOrgSeleccionado() != null) {
			where.append(" AND t9.HCCOOR = ? ");
			params.add(solicitudesBusqueda.getCodOrgSeleccionado());
		}

		// Instructor Expediente
		if (solicitudesBusqueda != null && solicitudesBusqueda.getMocodigoExpediente() != null) {
			where.append(" AND t4.HDCOMO = ? ");
			params.add(solicitudesBusqueda.getMocodigoExpediente());
		}

		// fecha presentacion desde
		if (solicitudesBusqueda != null && solicitudesBusqueda.getDefedeDesde() != null) {
			where.append(" AND t1.DEFEDE >= ?");
			params.add(solicitudesBusqueda.getDefedeDesde());
		}
		// fecha presentacion hasta
		if (solicitudesBusqueda != null && solicitudesBusqueda.getDefedeHasta() != null) {
			where.append(" AND t1.DEFEDE <= ?");
			params.add(solicitudesBusqueda.getDefedeHasta());
		}

		// Tipo solicitud
		if (solicitudesBusqueda != null && solicitudesBusqueda.getHdcosc() != null) {
			where.append(" AND t4.HDCOSC = ? ");
			params.add(solicitudesBusqueda.getHdcosc());
		}

		// fecha registro desde
		if (solicitudesBusqueda != null && solicitudesBusqueda.getDefereDesde() != null) {
			where.append(" AND t1.DEFERE >= ?");
			params.add(solicitudesBusqueda.getDefereDesde());
		}
		// fecha registro hasta
		if (solicitudesBusqueda != null && solicitudesBusqueda.getDefereHasta() != null) {
			where.append(" AND t1.DEFERE <= ?");
			params.add(solicitudesBusqueda.getDefereHasta());
		}

		// tipo forma presentacion
		if (solicitudesBusqueda != null && solicitudesBusqueda.getTfpcodigo() != null) {
			where.append(" AND t1.DECOTFP = ? ");
			params.add(solicitudesBusqueda.getTfpcodigo());
		}

		/*
		 * Colección de descriptores a las que pueden pertenecer las denuncias
		 */
		if (solicitudesBusqueda != null && solicitudesBusqueda.getDescriptores() != null
				&& solicitudesBusqueda.getDescriptores().size() > 0) {

			where.append(" AND t4.HDCODIGO IN (SELECT HDCODIGO FROM HECHODENUNCIA_DESCRIPTOR WHERE ");
			boolean firstElement = true;

			for (Descriptor e : solicitudesBusqueda.getDescriptores()) {

				if (firstElement) {

					where.append("ID_DESCRIPTOR = ?");
					params.add(e.getIdDescriptor());
					firstElement = false;

				} else {

					where.append(" OR ID_DESCRIPTOR = ?");
					params.add(e.getIdDescriptor());
				}
			}

			where.append(") ");
		}

		// tipo forma notificacion
		if (solicitudesBusqueda != null && solicitudesBusqueda.getHdformanotificacion() != null) {
			where.append(" AND t4.HDFORMANOTIFICACION = ? ");
			params.add(solicitudesBusqueda.getHdformanotificacion());
		}

		// Codigo expediente origen
		if (solicitudesBusqueda != null && solicitudesBusqueda.getHdcodexpedienteorigen() != null) {
			where.append(" AND UPPER(t4.HDCODEXPEDIENTEORIGEN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudesBusqueda.getHdcodexpedienteorigen().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudesBusqueda.getHdcodexpedienteorigen().toUpperCase() + "%");
			}
			where.append(" AND t4.HDCODEXPEDIENTEORIGEN IS NOT NULL");
		}

		// Numero registro de entrada
		if (solicitudesBusqueda != null && solicitudesBusqueda.getNumregistroentrada() != null) {
			where.append(" AND UPPER(t4.HDNUMREGISTROENTRADA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudesBusqueda.getNumregistroentrada().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudesBusqueda.getNumregistroentrada().toUpperCase() + "%");
			}
			where.append(" AND t4.HDNUMREGISTROENTRADA IS NOT NULL");
		}

		// Tipo denunciante
		if (solicitudesBusqueda != null && solicitudesBusqueda.getHdtipodenunciante() != null) {
			where.append(" AND t4.HDTIPODENUNCIANTE = ? ");
			params.add(solicitudesBusqueda.getHdtipodenunciante());
		}

		// Fase
		if (solicitudesBusqueda != null && solicitudesBusqueda.getFcodigo() != null) {
			where.append(" AND t4.FCODIGOACTUAL = ? ");
			params.add(solicitudesBusqueda.getFcodigo());
		}

		// Tramite
		if (solicitudesBusqueda != null && solicitudesBusqueda.getTrcodigo() != null) {
			where.append(
					" AND EXISTS (SELECT EHCOHD FROM TRAMITE_HECHO tr1 WHERE tr1.EHCOHD=t4.HDCODIGO AND EHCOTEE = ?) ");
			params.add(solicitudesBusqueda.getTrcodigo());

			if (solicitudesBusqueda != null && solicitudesBusqueda.getIndUltimoTramite() != null
					&& solicitudesBusqueda.getIndUltimoTramite().equals(Y41bConstantes.VALOR_SI)) {
				where.append(" AND t4.TRCODIGOACTUAL = ? ");
				params.add(solicitudesBusqueda.getTrcodigo());
			}
		}

		// Decision
		if (solicitudesBusqueda != null && solicitudesBusqueda.getDecodigo() != null) {
			// where.append(" AND t9.HCCOTTD IN (SELECT t1.DECODIGO DECODIGO
			// FROM DECISION t1 WHERE 1=1 AND t1.DENOMBRE = (SELECT t1.DENOMBRE
			// DENOMBRE FROM DECISION t1 WHERE t1.DECODIGO=?)) ");
			where.append(
					" AND (EXISTS (SELECT t1.DECODIGO DECODIGO FROM DECISION t1, DECISION_HECHO t2 WHERE 1=1 AND t1.DECODIGO=t2.HCCOTTD AND t2.HCCOHD=t4.HDCODIGO AND t1.DENOMBRE = (SELECT t1.DENOMBRE DENOMBRE FROM DECISION t1 WHERE t1.DECODIGO=?)) ");
			params.add(solicitudesBusqueda.getDecodigo());

			where.append(
					" OR EXISTS (SELECT tt2.HCCOTTD HCCOTTD FROM DECISION_HECHO tt2 WHERE 1=1 AND tt2.HCCOHD=t4.HDCODIGO AND tt2.HCCOTTD IN (SELECT t1.DECODIGOL21 FROM CORRESPONDENCIA_DECISION_L21 t1 WHERE t1.DECODIGOY41B=?))) ");
			params.add(solicitudesBusqueda.getDecodigo());
		}

		// Tramitador
		if (solicitudesBusqueda != null && solicitudesBusqueda.getMocodigoTramitador() != null) {

			if (solicitudesBusqueda != null && solicitudesBusqueda.getIndUltimoTramite() != null
					&& solicitudesBusqueda.getIndUltimoTramite().equals(Y41bConstantes.VALOR_SI)) {
				where.append(
						" AND t4.TRCODIGOACTUAL IN (SELECT EHCOTEE FROM TRAMITE_HECHO tr1 WHERE tr1.EHCOHD=t4.HDCODIGO AND tr1.EHCOMO = ?  AND EHFECHA = (SELECT MAX(EHFECHA) FROM TRAMITE_HECHO tr2 WHERE tr2.EHCOHD=t4.HDCODIGO ) AND NVL(EHHORA, 0) = (SELECT NVL(MAX(EHHORA), 0) FROM TRAMITE_HECHO tr3 WHERE tr1.EHFECHA = tr3.EHFECHA AND tr3.EHCOHD=t4.HDCODIGO)) ");
				params.add(solicitudesBusqueda.getMocodigoTramitador());
			} else {
				where.append(
						" AND EXISTS (SELECT EHCOHD FROM TRAMITE_HECHO tr1 WHERE tr1.EHCOHD=t4.HDCODIGO AND tr1.EHCOMO = ?) ");
				params.add(solicitudesBusqueda.getMocodigoTramitador());
			}
		}

		// Incluir expedientes cerrados
		if ((solicitudesBusqueda != null && solicitudesBusqueda.getIndIncluirCerrados() == null)
				|| (solicitudesBusqueda != null && solicitudesBusqueda.getIndIncluirCerrados() != null
						&& !solicitudesBusqueda.getIndIncluirCerrados().equals(Y41bConstantes.VALOR_SI))) {
			where.append(" AND t4.HDFECHACIERRE IS NULL ");
		}

		// Con acuse de recibo pendientes
		if (solicitudesBusqueda != null && solicitudesBusqueda.getIndPendienteAcuse() != null
				&& solicitudesBusqueda.getIndPendienteAcuse().equals(Y41bConstantes.VALOR_SI)) {
			where.append(
					" AND EXISTS (SELECT EHCOHD FROM TRAMITE_HECHO tr1 WHERE tr1.EHCOHD=t4.HDCODIGO AND tr1.EHCOTEE = ? AND tr1.EHFECHAFIN IS NULL) ");
			params.add(Y41bConstantes.TRAMITE_ACUSE_RECIBO);
		}

		// Con decision pendiente
		if (solicitudesBusqueda != null && solicitudesBusqueda.getIndPendienteDecision() != null
				&& solicitudesBusqueda.getIndPendienteDecision().equals(Y41bConstantes.VALOR_SI)) {
			where.append(" AND (t9.HCCOTTD IS NULL ");

			where.append(" OR t9.HCCOTTD=?) ");
			params.add(Y41bConstantes.DECISION_SINDECISION);
		}

		// Con pendiente firma
		if (solicitudesBusqueda != null && solicitudesBusqueda.getIndPendienteFirma() != null
				&& solicitudesBusqueda.getIndPendienteFirma().equals(Y41bConstantes.VALOR_SI)) {
			where.append(
					" AND EXISTS (SELECT EHCOHD FROM TRAMITE_HECHO tr1 WHERE tr1.EHCOHD=t4.HDCODIGO AND tr1.EHESTADOTRAMITE = ?) ");
			params.add(Y41bConstantes.ESTADO_TRAMITE_PENDIENTEFIRMA);
		}

		// fecha decision desde
		if (solicitudesBusqueda != null && solicitudesBusqueda.getEhfechafinDecisionDesde() != null) {
			where.append(" AND t9.HCFEDE >= ?");
			params.add(solicitudesBusqueda.getEhfechafinDecisionDesde());
		}

		// fecha decision hasta
		if (solicitudesBusqueda != null && solicitudesBusqueda.getEhfechafinDecisionHasta() != null) {
			where.append(" AND t9.HCFEDE <= ?");
			params.add(solicitudesBusqueda.getEhfechafinDecisionHasta());
		}

		// Nombre persona consumidora
		if (solicitudesBusqueda != null && solicitudesBusqueda.getDtnombre() != null) {
			where.append(" AND ((TRANSLATE(UPPER(t3CONSUMIDOR.NOMBRE),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudesBusqueda.getDtnombre().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + solicitudesBusqueda.getDtnombre().toUpperCase().replaceAll("", "A")
						.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t3CONSUMIDOR.NOMBRE IS NOT NULL AND t4.FCODIGOACTUAL IS NOT NULL) ");

			where.append(" OR (TRANSLATE(UPPER(tt3CONSUMIDOR.DTNOMBRE),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudesBusqueda.getDtnombre().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + solicitudesBusqueda.getDtnombre().toUpperCase().replaceAll("", "A")
						.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND tt3CONSUMIDOR.DTNOMBRE IS NOT NULL  AND t4.FCODIGOACTUAL IS NULL)) ");
		}

		// Apellido1 persona consumidora
		if (solicitudesBusqueda != null && solicitudesBusqueda.getDtapellido1() != null) {
			where.append(" AND ((TRANSLATE(UPPER(t3CONSUMIDOR.APELLIDO1),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudesBusqueda.getDtapellido1().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + solicitudesBusqueda.getDtapellido1().toUpperCase().replaceAll("", "A")
						.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t3CONSUMIDOR.APELLIDO1 IS NOT NULL  AND t4.FCODIGOACTUAL IS NOT NULL) ");

			where.append(" OR (TRANSLATE(UPPER(tt3CONSUMIDOR.DTAPELLIDO1),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudesBusqueda.getDtapellido1().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + solicitudesBusqueda.getDtapellido1().toUpperCase().replaceAll("", "A")
						.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND tt3CONSUMIDOR.DTAPELLIDO1 IS NOT NULL AND t4.FCODIGOACTUAL IS NULL)) ");

		}

		// Apellido2 persona consumidora
		if (solicitudesBusqueda != null && solicitudesBusqueda.getDtapellido2() != null) {
			where.append(" AND ((TRANSLATE(UPPER(t3CONSUMIDOR.APELLIDO2),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudesBusqueda.getDtapellido2().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + solicitudesBusqueda.getDtapellido2().toUpperCase().replaceAll("", "A")
						.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t3CONSUMIDOR.APELLIDO2 IS NOT NULL AND t4.FCODIGOACTUAL IS NOT NULL) ");

			where.append(" OR (TRANSLATE(UPPER(tt3CONSUMIDOR.DTAPELLIDO2),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudesBusqueda.getDtapellido2().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + solicitudesBusqueda.getDtapellido2().toUpperCase().replaceAll("", "A")
						.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND tt3CONSUMIDOR.DTAPELLIDO2 IS NOT NULL AND t4.FCODIGOACTUAL IS NULL)) ");
		}

		// Dni persona consumidora
		if (solicitudesBusqueda != null && solicitudesBusqueda.getDtnif() != null) {
			where.append(" AND ((UPPER(t3CONSUMIDOR.NIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudesBusqueda.getDtnif().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudesBusqueda.getDtnif().toUpperCase() + "%");
			}
			where.append(" AND t3CONSUMIDOR.NIF IS NOT NULL AND t4.FCODIGOACTUAL IS NOT NULL) ");

			where.append(" OR (UPPER(tt3CONSUMIDOR.DTNIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudesBusqueda.getDtnif().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudesBusqueda.getDtnif().toUpperCase() + "%");
			}
			where.append(" AND tt3CONSUMIDOR.DTNIF IS NOT NULL AND t4.FCODIGOACTUAL IS NULL)) ");
		}

		if (solicitudesBusqueda != null && solicitudesBusqueda.getDtextranjero() != null
				&& solicitudesBusqueda.getDtestado() == null) {
			where.append(" AND ((t3CONSUMIDOR.EXTRANJERO = ? AND t4.FCODIGOACTUAL IS NOT NULL)");
			params.add(Y41bConstantes.SI);

			where.append(" OR (tt3CONSUMIDOR.DTEXTRANJERO = ? AND t4.FCODIGOACTUAL IS NULL)) ");
			params.add(Y41bConstantes.SI);
		}
		if (solicitudesBusqueda != null && solicitudesBusqueda.getDtestado() != null
				&& solicitudesBusqueda.getDtextranjero() == null) {
			where.append(" AND ((t3CONSUMIDOR.EXTRANJERO = ? AND t4.FCODIGOACTUAL IS NOT NULL)");
			params.add(Y41bConstantes.NO);

			where.append(" OR (tt3CONSUMIDOR.DTEXTRANJERO = ? AND t4.FCODIGOACTUAL IS NULL)) ");
			params.add(Y41bConstantes.NO);
		}

		// Provincia persona consumidora
		if (solicitudesBusqueda != null && solicitudesBusqueda.getDtnoraProvinciaId() != null) {
			where.append(" AND ((t3CONSUMIDOR.NORA_PROVINCIA_ID = ? AND t4.FCODIGOACTUAL IS NOT NULL)");
			params.add(solicitudesBusqueda.getDtnoraProvinciaId());

			where.append(" OR (tt3CONSUMIDOR.DTNORA_PROVINCIA_ID = ? AND t4.FCODIGOACTUAL IS NULL)) ");
			params.add(solicitudesBusqueda.getDtnoraProvinciaId());
		}

		// Municipio persona consumidora
		if (solicitudesBusqueda != null && solicitudesBusqueda.getDtnoraMunicipioId() != null) {
			where.append(" AND ((t3CONSUMIDOR.NORA_MUNICIPIO_ID = ? AND t4.FCODIGOACTUAL IS NOT NULL)");
			params.add(solicitudesBusqueda.getDtnoraMunicipioId());

			where.append(" OR (tt3CONSUMIDOR.DTNORA_MUNICIPIO_ID = ? AND t4.FCODIGOACTUAL IS NULL)) ");
			params.add(solicitudesBusqueda.getDtnoraMunicipioId());

		}

		// Localidad persona consumidora
		if (solicitudesBusqueda != null && solicitudesBusqueda.getDtnoraLocalidadId() != null) {
			where.append(" AND ((t3CONSUMIDOR.NORA_LOCALIDAD_ID = ?  AND t4.FCODIGOACTUAL IS NOT NULL) ");
			params.add(solicitudesBusqueda.getDtnoraLocalidadId());

			where.append(" OR (tt3CONSUMIDOR.DTNORA_LOCALIDAD_ID = ? AND t4.FCODIGOACTUAL IS NULL)) ");
			params.add(solicitudesBusqueda.getDtnoraLocalidadId());

		}

		// Pais persona consumidora
		if (solicitudesBusqueda != null && solicitudesBusqueda.getDtnoraPaisId() != null) {
			where.append(" AND ((t3CONSUMIDOR.NORA_PAIS_ID = ? AND t4.FCODIGOACTUAL IS NOT NULL) ");
			params.add(solicitudesBusqueda.getDtnoraPaisId());

			where.append(" OR (tt3CONSUMIDOR.DTNORA_PAIS_ID = ? AND t4.FCODIGOACTUAL IS NULL)) ");
			params.add(solicitudesBusqueda.getDtnoraPaisId());

		}

		// Direccion extranjera persona consumidora
		if (solicitudesBusqueda != null && solicitudesBusqueda.getDtdireccion_nocapv() != null) {
			where.append(" AND ((TRANSLATE(UPPER(t3CONSUMIDOR.DIRECCION_NOCAPV),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudesBusqueda.getDtdireccion_nocapv().toUpperCase().replaceAll("", "A")
						.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%"
						+ solicitudesBusqueda.getDtdireccion_nocapv().toUpperCase().replaceAll("", "A")
								.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U")
						+ "%");
			}
			where.append(" AND t3CONSUMIDOR.DIRECCION_NOCAPV IS NOT NULL AND t4.FCODIGOACTUAL IS NOT NULL) ");

			where.append(" OR (TRANSLATE(UPPER(tt3CONSUMIDOR.DTDIRECCION_NOCAPV),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudesBusqueda.getDtdireccion_nocapv().toUpperCase().replaceAll("", "A")
						.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%"
						+ solicitudesBusqueda.getDtdireccion_nocapv().toUpperCase().replaceAll("", "A")
								.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U")
						+ "%");
			}
			where.append(" AND tt3CONSUMIDOR.DTDIRECCION_NOCAPV IS NOT NULL AND t4.FCODIGOACTUAL IS NULL))");

		}

		// Establecimiento por nombre o normbre comercial
		if (solicitudesBusqueda != null && solicitudesBusqueda.getEsnombre() != null) {
			where.append(" AND ((TRANSLATE(UPPER(t7ESTABLECIMIENTO.NOMBRE),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudesBusqueda.getEsnombre().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + solicitudesBusqueda.getEsnombre().toUpperCase().replaceAll("", "A")
						.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t7ESTABLECIMIENTO.NOMBRE IS NOT NULL AND t4.FCODIGOACTUAL IS NOT NULL) ");

			where.append(" OR (TRANSLATE(UPPER(tt7ESTABLECIMIENTO.ESNOMBRE),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudesBusqueda.getEsnombre().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + solicitudesBusqueda.getEsnombre().toUpperCase().replaceAll("", "A")
						.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND tt7ESTABLECIMIENTO.ESNOMBRE IS NOT NULL AND t4.FCODIGOACTUAL IS NULL) ");

			where.append(" OR (TRANSLATE(UPPER(t7ESTABLECIMIENTO.ESNOCO),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudesBusqueda.getEsnombre().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + solicitudesBusqueda.getEsnombre().toUpperCase().replaceAll("", "A")
						.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t7ESTABLECIMIENTO.ESNOCO IS NOT NULL AND t4.FCODIGOACTUAL IS NOT NULL) ");

			where.append(" OR (TRANSLATE(UPPER(tt7ESTABLECIMIENTO.ESNOCO),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudesBusqueda.getEsnombre().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + solicitudesBusqueda.getEsnombre().toUpperCase().replaceAll("", "A")
						.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND tt7ESTABLECIMIENTO.ESNOCO IS NOT NULL AND t4.FCODIGOACTUAL IS NULL)) ");

		}

		// NIF establecimiento
		if (solicitudesBusqueda != null && solicitudesBusqueda.getEsnif() != null) {
			where.append(" AND ((UPPER(t7ESTABLECIMIENTO.NIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudesBusqueda.getEsnif().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudesBusqueda.getEsnif().toUpperCase() + "%");
			}
			where.append(" AND t7ESTABLECIMIENTO.NIF IS NOT NULL  AND t4.FCODIGOACTUAL IS NOT NULL) ");

			where.append(" OR (UPPER(tt7ESTABLECIMIENTO.ESNIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudesBusqueda.getEsnif().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudesBusqueda.getEsnif().toUpperCase() + "%");
			}
			where.append(" AND tt7ESTABLECIMIENTO.ESNIF IS NOT NULL AND t4.FCODIGOACTUAL IS NULL)) ");

		}

		if (solicitudesBusqueda != null && solicitudesBusqueda.getEsextranjero() != null
				&& solicitudesBusqueda.getEsestado() == null) {
			where.append(" AND ((t7ESTABLECIMIENTO.EXTRANJERO = ? AND t4.FCODIGOACTUAL IS NOT NULL) ");
			params.add(Y41bConstantes.SI);
			where.append(" OR (tt7ESTABLECIMIENTO.ESEXTRANJERO = ? AND t4.FCODIGOACTUAL IS NULL))");
			params.add(Y41bConstantes.SI);
		}
		if (solicitudesBusqueda != null && solicitudesBusqueda.getEsestado() != null
				&& solicitudesBusqueda.getEsextranjero() == null) {
			where.append(" AND ((t7ESTABLECIMIENTO.EXTRANJERO = ? AND t4.FCODIGOACTUAL IS NOT NULL)");
			params.add(Y41bConstantes.NO);
			where.append(" OR (tt7ESTABLECIMIENTO.ESEXTRANJERO = ? AND t4.FCODIGOACTUAL IS NULL)) ");
			params.add(Y41bConstantes.NO);
		}

		// Provincia establecimiento
		if (solicitudesBusqueda != null && solicitudesBusqueda.getEsnoraProvinciaId() != null) {
			where.append(" AND ((t7ESTABLECIMIENTO.NORA_PROVINCIA_ID = ? AND t4.FCODIGOACTUAL IS NOT NULL)");
			params.add(solicitudesBusqueda.getEsnoraProvinciaId());
			where.append(" OR (tt7ESTABLECIMIENTO.ESNORA_PROVINCIA_ID = ? AND t4.FCODIGOACTUAL IS NULL)) ");
			params.add(solicitudesBusqueda.getEsnoraProvinciaId());
		}

		// Municipio establecimiento
		if (solicitudesBusqueda != null && solicitudesBusqueda.getEsnoraMunicipioId() != null) {
			where.append(" AND ((t7ESTABLECIMIENTO.NORA_MUNICIPIO_ID = ? AND t4.FCODIGOACTUAL IS NOT NULL)");
			params.add(solicitudesBusqueda.getEsnoraMunicipioId());
			where.append(" OR (tt7ESTABLECIMIENTO.ESNORA_MUNICIPIO_ID = ? AND t4.FCODIGOACTUAL IS NULL)) ");
			params.add(solicitudesBusqueda.getEsnoraMunicipioId());
		}

		// Localidad establecimiento
		if (solicitudesBusqueda != null && solicitudesBusqueda.getEsnoraLocalidadId() != null) {
			where.append(" AND ((t7ESTABLECIMIENTO.NORA_LOCALIDAD_ID = ?  AND t4.FCODIGOACTUAL IS NOT NULL)");
			params.add(solicitudesBusqueda.getEsnoraLocalidadId());
			where.append(" OR (tt7ESTABLECIMIENTO.ESNORA_LOCALIDAD_ID = ? AND t4.FCODIGOACTUAL IS NULL)) ");
			params.add(solicitudesBusqueda.getEsnoraLocalidadId());
		}

		// Pais establecimiento
		if (solicitudesBusqueda != null && solicitudesBusqueda.getEsnoraPaisId() != null) {
			where.append(" AND ((t7ESTABLECIMIENTO.NORA_PAIS_ID = ? AND t4.FCODIGOACTUAL IS NOT NULL)");
			params.add(solicitudesBusqueda.getEsnoraPaisId());
			where.append(" OR (tt7ESTABLECIMIENTO.ESNORA_PAIS_ID = ? AND t4.FCODIGOACTUAL IS NULL)) ");
			params.add(solicitudesBusqueda.getEsnoraPaisId());
		}

		// Direccion extranjera establecimiento
		if (solicitudesBusqueda != null && solicitudesBusqueda.getEsdireccion_nocapv() != null) {
			where.append(
					" AND ((TRANSLATE(UPPER(t7ESTABLECIMIENTO.DIRECCION_NOCAPV),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudesBusqueda.getEsdireccion_nocapv().toUpperCase().replaceAll("", "A")
						.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%"
						+ solicitudesBusqueda.getEsdireccion_nocapv().toUpperCase().replaceAll("", "A")
								.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U")
						+ "%");
			}
			where.append(" AND t7ESTABLECIMIENTO.DIRECCION_NOCAPV IS NOT NULL AND t4.FCODIGOACTUAL IS NOT NULL)");

			where.append(
					" OR (TRANSLATE(UPPER(tt7ESTABLECIMIENTO.ESDIRECCION_NOCAPV),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudesBusqueda.getEsdireccion_nocapv().toUpperCase().replaceAll("", "A")
						.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%"
						+ solicitudesBusqueda.getEsdireccion_nocapv().toUpperCase().replaceAll("", "A")
								.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U")
						+ "%");
			}
			where.append(" AND tt7ESTABLECIMIENTO.ESDIRECCION_NOCAPV IS NOT NULL AND t4.FCODIGOACTUAL IS NULL))");
		}
		// Busqueda de solicitudes para alta de arbitrajes
		/*
		 * if (solicitudesBusqueda != null && solicitudesBusqueda.getOrigen() !=
		 * null && solicitudesBusqueda.getOrigen().equals(
		 * Y41bConstantes.TIPO_PROC_ARBITRAJE)) { // est cerrada //
		 * where.append(" AND t4.HDFECHACIERRE IS NOT NULL ");
		 * 
		 * // no este relacionada con solicitud previa de arbitraje
		 * //where.append( //
		 * " AND NOT EXISTS (SELECT 1 FROM SANEXPREL t10SANEXPREL WHERE  t10SANEXPREL.RLARBCODIGO IS NOT NULL  AND t10SANEXPREL.RLHDCODREL=t4.HDCODIGO AND (t10SANEXPREL.RLESORIG=?)  ) "
		 * //); params.add(Y41bConstantes.TIPO_ARB_EXPREL_ORIGEN); // // y que
		 * exista fecha de decisin where.append(" AND t9.HCFEDE IS NOT NULL ");
		 * // la solicitud tiene que tener decisin y de un tipo concreto if
		 * (Y41bConstantes.DECISIONES_ARBITRAJE_NO_ADMITIDAS != null &&
		 * Y41bConstantes.DECISIONES_ARBITRAJE_NO_ADMITIDAS.length > 0) {
		 * where.append("AND t9.HCCOTTD IS NOT NULL AND t9.HCCOTTD NOT IN (");
		 * 
		 * for (int i = 0; i <
		 * Y41bConstantes.DECISIONES_ARBITRAJE_NO_ADMITIDAS.length; i++) {
		 * where.append("? "); if (i !=
		 * Y41bConstantes.DECISIONES_ARBITRAJE_NO_ADMITIDAS.length - 1) {
		 * where.append(", "); }
		 * params.add(Y41bConstantes.DECISIONES_ARBITRAJE_NO_ADMITIDAS[i]); }
		 * 
		 * where.append(" ) ");
		 * 
		 * } }
		 */
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Devuelve una lista con las solicitudes de un organismo.
	 * 
	 * @param busquedaCombinada
	 *            BusquedaCombinada
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<SolicitudBusqueda> findAllLikeSolicitudesBusquedaCombinada(BusquedaCombinada busquedaCombinada,
			Pagination pagination, Boolean startsWith) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();

		where.append(
				" WHERE 1=1  AND t1.DECODIGO= t4.HDCODE AND t1.DECODT= tt3CONSUMIDOR.DTCODIGO(+) AND t4.HDCODIGO= t3CONSUMIDOR.HDCODIGO(+) AND t3CONSUMIDOR.TIPO_INTERVINIENTE(+)='I' AND t4.HDCOES= tt7ESTABLECIMIENTO.ESCODIGO(+) AND t4.HDCODIGO= t7ESTABLECIMIENTO.HDCODIGO(+) AND t7ESTABLECIMIENTO.TIPO_INTERVINIENTE(+)='D' AND t4.FCODIGOACTUAL = t5.FCODIGO(+) AND t4.TRCODIGOACTUAL = t6.TRCODIGO(+) AND t4.HDCOMO = t8.MOCODIGO(+) AND t4.HDCODIGO = t9.HCCOHD AND t9.HCCOTTD=t14.DECODIGO(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT t1.DECOOR DECOOR, t1.DENRAN DENRAN, t1.DENROR DENROR, t4.HDNROR HDNROR, t4.HDCODIGO HDCODIGO, t1.DEFEDE DEFEDE, t1.DECODT DECODT, t3CONSUMIDOR.NOMBRE DTNOMBRE, t3CONSUMIDOR.APELLIDO1 DTAPELLIDO1, t3CONSUMIDOR.APELLIDO2 DTAPELLIDO2, t3CONSUMIDOR.NIF DTNIF, t3CONSUMIDOR.NOMBRE_MUNICIPIO DTNOMBRE_MUNICIPIO, t4.HDCOES HDCOES, t7ESTABLECIMIENTO.NOMBRE ESNOMBRE, t7ESTABLECIMIENTO.NIF ESNIF, t7ESTABLECIMIENTO.ESNOCO ESNOCO, t5.FCODIGO FCODIGO, t5.FNOMBRE FNOMBRE, t5.FNOMBREE FNOMBREE, t6.TRCODIGO TRCODIGO, t6.TRNOMBRE TRNOMBRE, t6.TRNOMBREE TRNOMBREE, t8.MOCODIGO MOCODIGO, t8.MONOMBRE MONOMBRE, t14.DECODIGO DECODIGO, t14.DENOMBRE DENOMBRE, t14.DENOMBREE DENOMBREE "
						+ "FROM DENUNCIA t1,INTERVINIENTES t3CONSUMIDOR, CONSUMIDOR tt3CONSUMIDOR, HECHO_DENUNCIADO t4, INTERVINIENTES t7ESTABLECIMIENTO, ESTABLECIMIENTO tt7ESTABLECIMIENTO, FASE t5, TRAMITE t6, CENSO_MONITOR t8,DECISION_HECHO t9, DECISION t14 ");

		// DTCODIGO
		if (busquedaCombinada != null && busquedaCombinada.getDtcodigo() != null) {
			where.append(" AND t1.DECODT = ? ");
			params.add(busquedaCombinada.getDtcodigo());
		}

		// Nombre persona consumidora
		if (busquedaCombinada != null && busquedaCombinada.getDtnombre() != null) {
			where.append(" AND ((TRANSLATE(UPPER(t3CONSUMIDOR.NOMBRE),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(busquedaCombinada.getDtnombre().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + busquedaCombinada.getDtnombre().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t3CONSUMIDOR.NOMBRE IS NOT NULL AND t4.FCODIGOACTUAL IS NOT NULL) ");

			where.append(" OR (TRANSLATE(UPPER(tt3CONSUMIDOR.DTNOMBRE),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(busquedaCombinada.getDtnombre().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + busquedaCombinada.getDtnombre().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND tt3CONSUMIDOR.DTNOMBRE IS NOT NULL  AND t4.FCODIGOACTUAL IS NULL)) ");
		}

		// Apellido1 persona consumidora
		if (busquedaCombinada != null && busquedaCombinada.getDtapellido1() != null) {
			where.append(" AND ((TRANSLATE(UPPER(t3CONSUMIDOR.APELLIDO1),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(busquedaCombinada.getDtapellido1().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + busquedaCombinada.getDtapellido1().toUpperCase().replaceAll("", "A")
						.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t3CONSUMIDOR.APELLIDO1 IS NOT NULL  AND t4.FCODIGOACTUAL IS NOT NULL) ");

			where.append(" OR (TRANSLATE(UPPER(tt3CONSUMIDOR.DTAPELLIDO1),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(busquedaCombinada.getDtapellido1().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + busquedaCombinada.getDtapellido1().toUpperCase().replaceAll("", "A")
						.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND tt3CONSUMIDOR.DTAPELLIDO1 IS NOT NULL AND t4.FCODIGOACTUAL IS NULL)) ");

		}

		// Apellido2 persona consumidora
		if (busquedaCombinada != null && busquedaCombinada.getDtapellido2() != null) {
			where.append(" AND ((TRANSLATE(UPPER(t3CONSUMIDOR.APELLIDO2),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(busquedaCombinada.getDtapellido2().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + busquedaCombinada.getDtapellido2().toUpperCase().replaceAll("", "A")
						.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t3CONSUMIDOR.APELLIDO2 IS NOT NULL AND t4.FCODIGOACTUAL IS NOT NULL) ");

			where.append(" OR (TRANSLATE(UPPER(tt3CONSUMIDOR.DTAPELLIDO2),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(busquedaCombinada.getDtapellido2().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + busquedaCombinada.getDtapellido2().toUpperCase().replaceAll("", "A")
						.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND tt3CONSUMIDOR.DTAPELLIDO2 IS NOT NULL AND t4.FCODIGOACTUAL IS NULL)) ");
		}

		// Dni persona consumidora
		if (busquedaCombinada != null && busquedaCombinada.getDtnif() != null) {
			where.append(" AND ((UPPER(t3CONSUMIDOR.NIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(busquedaCombinada.getDtnif().toUpperCase() + "%");
			} else {
				params.add("%" + busquedaCombinada.getDtnif().toUpperCase() + "%");
			}
			where.append(" AND t3CONSUMIDOR.NIF IS NOT NULL AND t4.FCODIGOACTUAL IS NOT NULL) ");

			where.append(" OR (UPPER(tt3CONSUMIDOR.DTNIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(busquedaCombinada.getDtnif().toUpperCase() + "%");
			} else {
				params.add("%" + busquedaCombinada.getDtnif().toUpperCase() + "%");
			}
			where.append(" AND tt3CONSUMIDOR.DTNIF IS NOT NULL AND t4.FCODIGOACTUAL IS NULL)) ");
		}

		if (busquedaCombinada != null && busquedaCombinada.getDtextranjero() != null
				&& busquedaCombinada.getDtestado() == null) {
			where.append(" AND ((t3CONSUMIDOR.EXTRANJERO = ? AND t4.FCODIGOACTUAL IS NOT NULL)");
			params.add(Y41bConstantes.SI);

			where.append(" OR (tt3CONSUMIDOR.DTEXTRANJERO = ? AND t4.FCODIGOACTUAL IS NULL)) ");
			params.add(Y41bConstantes.SI);
		}
		if (busquedaCombinada != null && busquedaCombinada.getDtestado() != null
				&& busquedaCombinada.getDtextranjero() == null) {
			where.append(" AND ((t3CONSUMIDOR.EXTRANJERO = ? AND t4.FCODIGOACTUAL IS NOT NULL)");
			params.add(Y41bConstantes.NO);

			where.append(" OR (tt3CONSUMIDOR.DTEXTRANJERO = ? AND t4.FCODIGOACTUAL IS NULL)) ");
			params.add(Y41bConstantes.NO);
		}

		// Provincia persona consumidora
		if (busquedaCombinada != null && busquedaCombinada.getDtnoraProvinciaId() != null) {
			where.append(" AND ((t3CONSUMIDOR.NORA_PROVINCIA_ID = ? AND t4.FCODIGOACTUAL IS NOT NULL)");
			params.add(busquedaCombinada.getDtnoraProvinciaId());

			where.append(" OR (tt3CONSUMIDOR.DTNORA_PROVINCIA_ID = ? AND t4.FCODIGOACTUAL IS NULL)) ");
			params.add(busquedaCombinada.getDtnoraProvinciaId());
		}

		// Municipio persona consumidora
		if (busquedaCombinada != null && busquedaCombinada.getDtnoraMunicipioId() != null) {
			where.append(" AND ((t3CONSUMIDOR.NORA_MUNICIPIO_ID = ? AND t4.FCODIGOACTUAL IS NOT NULL)");
			params.add(busquedaCombinada.getDtnoraMunicipioId());

			where.append(" OR (tt3CONSUMIDOR.DTNORA_MUNICIPIO_ID = ? AND t4.FCODIGOACTUAL IS NULL)) ");
			params.add(busquedaCombinada.getDtnoraMunicipioId());

		}

		// Localidad persona consumidora
		if (busquedaCombinada != null && busquedaCombinada.getDtnoraLocalidadId() != null) {
			where.append(" AND ((t3CONSUMIDOR.NORA_LOCALIDAD_ID = ?  AND t4.FCODIGOACTUAL IS NOT NULL) ");
			params.add(busquedaCombinada.getDtnoraLocalidadId());

			where.append(" OR (tt3CONSUMIDOR.DTNORA_LOCALIDAD_ID = ? AND t4.FCODIGOACTUAL IS NULL)) ");
			params.add(busquedaCombinada.getDtnoraLocalidadId());

		}

		// Pais persona consumidora
		if (busquedaCombinada != null && busquedaCombinada.getDtnoraPaisId() != null) {
			where.append(" AND ((t3CONSUMIDOR.NORA_PAIS_ID = ? AND t4.FCODIGOACTUAL IS NOT NULL) ");
			params.add(busquedaCombinada.getDtnoraPaisId());

			where.append(" OR (tt3CONSUMIDOR.DTNORA_PAIS_ID = ? AND t4.FCODIGOACTUAL IS NULL)) ");
			params.add(busquedaCombinada.getDtnoraPaisId());

		}

		// Direccion extranjera persona consumidora
		if (busquedaCombinada != null && busquedaCombinada.getDtdireccion_nocapv() != null) {
			where.append(" AND ((TRANSLATE(UPPER(t3CONSUMIDOR.DIRECCION_NOCAPV),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(busquedaCombinada.getDtdireccion_nocapv().toUpperCase().replaceAll("", "A")
						.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%"
						+ busquedaCombinada.getDtdireccion_nocapv().toUpperCase().replaceAll("", "A")
								.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U")
						+ "%");
			}
			where.append(" AND t3CONSUMIDOR.DIRECCION_NOCAPV IS NOT NULL AND t4.FCODIGOACTUAL IS NOT NULL) ");

			where.append(" OR (TRANSLATE(UPPER(tt3CONSUMIDOR.DTDIRECCION_NOCAPV),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(busquedaCombinada.getDtdireccion_nocapv().toUpperCase().replaceAll("", "A")
						.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%"
						+ busquedaCombinada.getDtdireccion_nocapv().toUpperCase().replaceAll("", "A")
								.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U")
						+ "%");
			}
			where.append(" AND tt3CONSUMIDOR.DTDIRECCION_NOCAPV IS NOT NULL AND t4.FCODIGOACTUAL IS NULL))");

		}

		// ESCODIGO
		if (busquedaCombinada != null && busquedaCombinada.getEscodigo() != null) {
			where.append(" AND t4.HDCOES = ? ");
			params.add(busquedaCombinada.getEscodigo());
		}

		// Establecimiento por nombre o normbre comercial
		if (busquedaCombinada != null && busquedaCombinada.getEsnombre() != null) {
			where.append(" AND ((TRANSLATE(UPPER(t7ESTABLECIMIENTO.NOMBRE),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(busquedaCombinada.getEsnombre().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + busquedaCombinada.getEsnombre().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t7ESTABLECIMIENTO.NOMBRE IS NOT NULL AND t4.FCODIGOACTUAL IS NOT NULL) ");

			where.append(" OR (TRANSLATE(UPPER(tt7ESTABLECIMIENTO.ESNOMBRE),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(busquedaCombinada.getEsnombre().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + busquedaCombinada.getEsnombre().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND tt7ESTABLECIMIENTO.ESNOMBRE IS NOT NULL AND t4.FCODIGOACTUAL IS NULL)) ");

		}

		// NIF establecimiento
		if (busquedaCombinada != null && busquedaCombinada.getEsnif() != null) {
			where.append(" AND ((UPPER(t7ESTABLECIMIENTO.NIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(busquedaCombinada.getEsnif().toUpperCase() + "%");
			} else {
				params.add("%" + busquedaCombinada.getEsnif().toUpperCase() + "%");
			}
			where.append(" AND t7ESTABLECIMIENTO.NIF IS NOT NULL  AND t4.FCODIGOACTUAL IS NOT NULL) ");

			where.append(" OR (UPPER(tt7ESTABLECIMIENTO.ESNIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(busquedaCombinada.getEsnif().toUpperCase() + "%");
			} else {
				params.add("%" + busquedaCombinada.getEsnif().toUpperCase() + "%");
			}
			where.append(" AND tt7ESTABLECIMIENTO.ESNIF IS NOT NULL AND t4.FCODIGOACTUAL IS NULL)) ");

		}

		// Nombre Comercial establecimiento
		if (busquedaCombinada != null && busquedaCombinada.getEsnoco() != null) {
			where.append(" AND ((TRANSLATE(UPPER(t7ESTABLECIMIENTO.ESNOCO),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(busquedaCombinada.getEsnoco().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + busquedaCombinada.getEsnoco().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t7ESTABLECIMIENTO.ESNOCO IS NOT NULL AND t4.FCODIGOACTUAL IS NOT NULL) ");

			where.append(" OR (TRANSLATE(UPPER(tt7ESTABLECIMIENTO.ESNOCO),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(busquedaCombinada.getEsnoco().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + busquedaCombinada.getEsnoco().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND tt7ESTABLECIMIENTO.ESNOCO IS NOT NULL AND t4.FCODIGOACTUAL IS NULL)) ");

		}

		if (busquedaCombinada != null && busquedaCombinada.getEsextranjero() != null
				&& busquedaCombinada.getEsestado() == null) {
			where.append(" AND ((t7ESTABLECIMIENTO.EXTRANJERO = ? AND t4.FCODIGOACTUAL IS NOT NULL) ");
			params.add(Y41bConstantes.SI);
			where.append(" OR (tt7ESTABLECIMIENTO.ESEXTRANJERO = ? AND t4.FCODIGOACTUAL IS NULL))");
			params.add(Y41bConstantes.SI);
		}
		if (busquedaCombinada != null && busquedaCombinada.getEsestado() != null
				&& busquedaCombinada.getEsextranjero() == null) {
			where.append(" AND ((t7ESTABLECIMIENTO.EXTRANJERO = ? AND t4.FCODIGOACTUAL IS NOT NULL)");
			params.add(Y41bConstantes.NO);
			where.append(" OR (tt7ESTABLECIMIENTO.ESEXTRANJERO = ? AND t4.FCODIGOACTUAL IS NULL)) ");
			params.add(Y41bConstantes.NO);
		}

		// Provincia establecimiento
		if (busquedaCombinada != null && busquedaCombinada.getEsnoraProvinciaId() != null) {
			where.append(" AND ((t7ESTABLECIMIENTO.NORA_PROVINCIA_ID = ? AND t4.FCODIGOACTUAL IS NOT NULL)");
			params.add(busquedaCombinada.getEsnoraProvinciaId());
			where.append(" OR (tt7ESTABLECIMIENTO.ESNORA_PROVINCIA_ID = ? AND t4.FCODIGOACTUAL IS NULL)) ");
			params.add(busquedaCombinada.getEsnoraProvinciaId());
		}

		// Municipio establecimiento
		if (busquedaCombinada != null && busquedaCombinada.getEsnoraMunicipioId() != null) {
			where.append(" AND ((t7ESTABLECIMIENTO.NORA_MUNICIPIO_ID = ? AND t4.FCODIGOACTUAL IS NOT NULL)");
			params.add(busquedaCombinada.getEsnoraMunicipioId());
			where.append(" OR (tt7ESTABLECIMIENTO.ESNORA_MUNICIPIO_ID = ? AND t4.FCODIGOACTUAL IS NULL)) ");
			params.add(busquedaCombinada.getEsnoraMunicipioId());
		}

		// Localidad establecimiento
		if (busquedaCombinada != null && busquedaCombinada.getEsnoraLocalidadId() != null) {
			where.append(" AND ((t7ESTABLECIMIENTO.NORA_LOCALIDAD_ID = ?  AND t4.FCODIGOACTUAL IS NOT NULL)");
			params.add(busquedaCombinada.getEsnoraLocalidadId());
			where.append(" OR (tt7ESTABLECIMIENTO.ESNORA_LOCALIDAD_ID = ? AND t4.FCODIGOACTUAL IS NULL)) ");
			params.add(busquedaCombinada.getEsnoraLocalidadId());
		}

		// Pais establecimiento
		if (busquedaCombinada != null && busquedaCombinada.getEsnoraPaisId() != null) {
			where.append(" AND ((t7ESTABLECIMIENTO.NORA_PAIS_ID = ? AND t4.FCODIGOACTUAL IS NOT NULL)");
			params.add(busquedaCombinada.getEsnoraPaisId());
			where.append(" OR (tt7ESTABLECIMIENTO.ESNORA_PAIS_ID = ? AND t4.FCODIGOACTUAL IS NULL)) ");
			params.add(busquedaCombinada.getEsnoraPaisId());
		}

		// Direccion extranjera establecimiento
		if (busquedaCombinada != null && busquedaCombinada.getEsdireccion_nocapv() != null) {
			where.append(
					" AND ((TRANSLATE(UPPER(t7ESTABLECIMIENTO.DIRECCION_NOCAPV),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(busquedaCombinada.getEsdireccion_nocapv().toUpperCase().replaceAll("", "A")
						.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%"
						+ busquedaCombinada.getEsdireccion_nocapv().toUpperCase().replaceAll("", "A")
								.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U")
						+ "%");
			}
			where.append(" AND t7ESTABLECIMIENTO.DIRECCION_NOCAPV IS NOT NULL AND t4.FCODIGOACTUAL IS NOT NULL)");

			where.append(
					" OR (TRANSLATE(UPPER(tt7ESTABLECIMIENTO.ESDIRECCION_NOCAPV),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(busquedaCombinada.getEsdireccion_nocapv().toUpperCase().replaceAll("", "A")
						.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%"
						+ busquedaCombinada.getEsdireccion_nocapv().toUpperCase().replaceAll("", "A")
								.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U")
						+ "%");
			}
			where.append(" AND tt7ESTABLECIMIENTO.ESDIRECCION_NOCAPV IS NOT NULL AND t4.FCODIGOACTUAL IS NULL))");
		}

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		}

		return (List<SolicitudBusqueda>) this.jdbcTemplate.query(query.toString(), new RowMapper<SolicitudBusqueda>() {
			public SolicitudBusqueda mapRow(ResultSet resultSet, int rowNum) throws SQLException {
				return new SolicitudBusqueda(resultSet.getString("HDCODIGO"), resultSet.getString("DECOOR"),
						resultSet.getBigDecimal("DENRAN"), resultSet.getBigDecimal("DENROR"),
						resultSet.getBigDecimal("HDNROR"), null, null, null, resultSet.getString("MOCODIGO"),
						resultSet.getString("MONOMBRE"), resultSet.getDate("DEFEDE"), null, null, null, null, null,
						null, null, null, null, resultSet.getString("FCODIGO"), resultSet.getString("FNOMBRE"),
						resultSet.getString("FNOMBREE"), resultSet.getString("TRCODIGO"),
						resultSet.getString("TRNOMBRE"), resultSet.getString("TRNOMBREE"),
						resultSet.getString("DECODIGO"), resultSet.getString("DENOMBRE"),
						resultSet.getString("DENOMBREE"), null, null, null, null, null, null, null, null, null,
						resultSet.getString("DTNOMBRE"), resultSet.getString("DTAPELLIDO1"),
						resultSet.getString("DTAPELLIDO2"), resultSet.getString("DTNIF"), null, null, null, null,
						resultSet.getString("DTNOMBRE_MUNICIPIO"), null, null, null, null, null, null,
						resultSet.getString("ESNOMBRE"), resultSet.getString("ESNIF"), resultSet.getString("ESNOCO"),
						null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
						null, null, null, null, null, null, null, null, resultSet.getString("DECODT"),
						resultSet.getString("HDCOES"), null, null);
			}
		}, params.toArray());
	}

	/**
	 * Counts rows in the HechoDenunciado table.
	 * 
	 * @param busquedaCombinada
	 *            BusquedaCombinada
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeSolicitudesBusquedaCombinadaCount(BusquedaCombinada busquedaCombinada, Boolean startsWith) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(
				" WHERE 1=1  AND t1.DECODIGO= t4.HDCODE AND t1.DECODT= tt3CONSUMIDOR.DTCODIGO(+) AND t4.HDCODIGO= t3CONSUMIDOR.HDCODIGO(+) AND t3CONSUMIDOR.TIPO_INTERVINIENTE(+)='I' AND t4.HDCOES= tt7ESTABLECIMIENTO.ESCODIGO(+) AND t4.HDCODIGO= t7ESTABLECIMIENTO.HDCODIGO(+) AND t7ESTABLECIMIENTO.TIPO_INTERVINIENTE(+)='D' AND t4.FCODIGOACTUAL = t5.FCODIGO(+) AND t4.TRCODIGOACTUAL = t6.TRCODIGO(+) AND t4.HDCOMO = t8.MOCODIGO(+) AND t4.HDCODIGO = t9.HCCOHD AND t9.HCCOTTD=t14.DECODIGO(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(t4.HDCODIGO) FROM DENUNCIA t1,INTERVINIENTES t3CONSUMIDOR, CONSUMIDOR tt3CONSUMIDOR, HECHO_DENUNCIADO t4, INTERVINIENTES t7ESTABLECIMIENTO, ESTABLECIMIENTO tt7ESTABLECIMIENTO, FASE t5, TRAMITE t6, CENSO_MONITOR t8,DECISION_HECHO t9, DECISION t14 ");

		// DTCODIGO
		if (busquedaCombinada != null && busquedaCombinada.getDtcodigo() != null) {
			where.append(" AND t1.DECODT = ? ");
			params.add(busquedaCombinada.getDtcodigo());
		}

		// Nombre persona consumidora
		if (busquedaCombinada != null && busquedaCombinada.getDtnombre() != null) {
			where.append(" AND ((TRANSLATE(UPPER(t3CONSUMIDOR.NOMBRE),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(busquedaCombinada.getDtnombre().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + busquedaCombinada.getDtnombre().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t3CONSUMIDOR.NOMBRE IS NOT NULL AND t4.FCODIGOACTUAL IS NOT NULL) ");

			where.append(" OR (TRANSLATE(UPPER(tt3CONSUMIDOR.DTNOMBRE),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(busquedaCombinada.getDtnombre().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + busquedaCombinada.getDtnombre().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND tt3CONSUMIDOR.DTNOMBRE IS NOT NULL  AND t4.FCODIGOACTUAL IS NULL)) ");
		}

		// Apellido1 persona consumidora
		if (busquedaCombinada != null && busquedaCombinada.getDtapellido1() != null) {
			where.append(" AND ((TRANSLATE(UPPER(t3CONSUMIDOR.APELLIDO1),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(busquedaCombinada.getDtapellido1().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + busquedaCombinada.getDtapellido1().toUpperCase().replaceAll("", "A")
						.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t3CONSUMIDOR.APELLIDO1 IS NOT NULL  AND t4.FCODIGOACTUAL IS NOT NULL) ");

			where.append(" OR (TRANSLATE(UPPER(tt3CONSUMIDOR.DTAPELLIDO1),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(busquedaCombinada.getDtapellido1().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + busquedaCombinada.getDtapellido1().toUpperCase().replaceAll("", "A")
						.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND tt3CONSUMIDOR.DTAPELLIDO1 IS NOT NULL AND t4.FCODIGOACTUAL IS NULL)) ");

		}

		// Apellido2 persona consumidora
		if (busquedaCombinada != null && busquedaCombinada.getDtapellido2() != null) {
			where.append(" AND ((TRANSLATE(UPPER(t3CONSUMIDOR.APELLIDO2),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(busquedaCombinada.getDtapellido2().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + busquedaCombinada.getDtapellido2().toUpperCase().replaceAll("", "A")
						.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t3CONSUMIDOR.APELLIDO2 IS NOT NULL AND t4.FCODIGOACTUAL IS NOT NULL) ");

			where.append(" OR (TRANSLATE(UPPER(tt3CONSUMIDOR.DTAPELLIDO2),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(busquedaCombinada.getDtapellido2().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + busquedaCombinada.getDtapellido2().toUpperCase().replaceAll("", "A")
						.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND tt3CONSUMIDOR.DTAPELLIDO2 IS NOT NULL AND t4.FCODIGOACTUAL IS NULL)) ");
		}

		// Dni persona consumidora
		if (busquedaCombinada != null && busquedaCombinada.getDtnif() != null) {
			where.append(" AND ((UPPER(t3CONSUMIDOR.NIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(busquedaCombinada.getDtnif().toUpperCase() + "%");
			} else {
				params.add("%" + busquedaCombinada.getDtnif().toUpperCase() + "%");
			}
			where.append(" AND t3CONSUMIDOR.NIF IS NOT NULL AND t4.FCODIGOACTUAL IS NOT NULL) ");

			where.append(" OR (UPPER(tt3CONSUMIDOR.DTNIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(busquedaCombinada.getDtnif().toUpperCase() + "%");
			} else {
				params.add("%" + busquedaCombinada.getDtnif().toUpperCase() + "%");
			}
			where.append(" AND tt3CONSUMIDOR.DTNIF IS NOT NULL AND t4.FCODIGOACTUAL IS NULL)) ");
		}

		if (busquedaCombinada != null && busquedaCombinada.getDtextranjero() != null
				&& busquedaCombinada.getDtestado() == null) {
			where.append(" AND ((t3CONSUMIDOR.EXTRANJERO = ? AND t4.FCODIGOACTUAL IS NOT NULL)");
			params.add(Y41bConstantes.SI);

			where.append(" OR (tt3CONSUMIDOR.DTEXTRANJERO = ? AND t4.FCODIGOACTUAL IS NULL)) ");
			params.add(Y41bConstantes.SI);
		}
		if (busquedaCombinada != null && busquedaCombinada.getDtestado() != null
				&& busquedaCombinada.getDtextranjero() == null) {
			where.append(" AND ((t3CONSUMIDOR.EXTRANJERO = ? AND t4.FCODIGOACTUAL IS NOT NULL)");
			params.add(Y41bConstantes.NO);

			where.append(" OR (tt3CONSUMIDOR.DTEXTRANJERO = ? AND t4.FCODIGOACTUAL IS NULL)) ");
			params.add(Y41bConstantes.NO);
		}

		// Provincia persona consumidora
		if (busquedaCombinada != null && busquedaCombinada.getDtnoraProvinciaId() != null) {
			where.append(" AND ((t3CONSUMIDOR.NORA_PROVINCIA_ID = ? AND t4.FCODIGOACTUAL IS NOT NULL)");
			params.add(busquedaCombinada.getDtnoraProvinciaId());

			where.append(" OR (tt3CONSUMIDOR.DTNORA_PROVINCIA_ID = ? AND t4.FCODIGOACTUAL IS NULL)) ");
			params.add(busquedaCombinada.getDtnoraProvinciaId());
		}

		// Municipio persona consumidora
		if (busquedaCombinada != null && busquedaCombinada.getDtnoraMunicipioId() != null) {
			where.append(" AND ((t3CONSUMIDOR.NORA_MUNICIPIO_ID = ? AND t4.FCODIGOACTUAL IS NOT NULL)");
			params.add(busquedaCombinada.getDtnoraMunicipioId());

			where.append(" OR (tt3CONSUMIDOR.DTNORA_MUNICIPIO_ID = ? AND t4.FCODIGOACTUAL IS NULL)) ");
			params.add(busquedaCombinada.getDtnoraMunicipioId());

		}

		// Localidad persona consumidora
		if (busquedaCombinada != null && busquedaCombinada.getDtnoraLocalidadId() != null) {
			where.append(" AND ((t3CONSUMIDOR.NORA_LOCALIDAD_ID = ?  AND t4.FCODIGOACTUAL IS NOT NULL) ");
			params.add(busquedaCombinada.getDtnoraLocalidadId());

			where.append(" OR (tt3CONSUMIDOR.DTNORA_LOCALIDAD_ID = ? AND t4.FCODIGOACTUAL IS NULL)) ");
			params.add(busquedaCombinada.getDtnoraLocalidadId());

		}

		// Pais persona consumidora
		if (busquedaCombinada != null && busquedaCombinada.getDtnoraPaisId() != null) {
			where.append(" AND ((t3CONSUMIDOR.NORA_PAIS_ID = ? AND t4.FCODIGOACTUAL IS NOT NULL) ");
			params.add(busquedaCombinada.getDtnoraPaisId());

			where.append(" OR (tt3CONSUMIDOR.DTNORA_PAIS_ID = ? AND t4.FCODIGOACTUAL IS NULL)) ");
			params.add(busquedaCombinada.getDtnoraPaisId());

		}

		// Direccion extranjera persona consumidora
		if (busquedaCombinada != null && busquedaCombinada.getDtdireccion_nocapv() != null) {
			where.append(" AND ((TRANSLATE(UPPER(t3CONSUMIDOR.DIRECCION_NOCAPV),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(busquedaCombinada.getDtdireccion_nocapv().toUpperCase().replaceAll("", "A")
						.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%"
						+ busquedaCombinada.getDtdireccion_nocapv().toUpperCase().replaceAll("", "A")
								.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U")
						+ "%");
			}
			where.append(" AND t3CONSUMIDOR.DIRECCION_NOCAPV IS NOT NULL AND t4.FCODIGOACTUAL IS NOT NULL) ");

			where.append(" OR (TRANSLATE(UPPER(tt3CONSUMIDOR.DTDIRECCION_NOCAPV),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(busquedaCombinada.getDtdireccion_nocapv().toUpperCase().replaceAll("", "A")
						.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%"
						+ busquedaCombinada.getDtdireccion_nocapv().toUpperCase().replaceAll("", "A")
								.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U")
						+ "%");
			}
			where.append(" AND tt3CONSUMIDOR.DTDIRECCION_NOCAPV IS NOT NULL AND t4.FCODIGOACTUAL IS NULL))");

		}

		// ESCODIGO
		if (busquedaCombinada != null && busquedaCombinada.getEscodigo() != null) {
			where.append(" AND t4.HDCOES = ? ");
			params.add(busquedaCombinada.getEscodigo());
		}

		// Establecimiento por nombre o normbre comercial
		if (busquedaCombinada != null && busquedaCombinada.getEsnombre() != null) {
			where.append(" AND ((TRANSLATE(UPPER(t7ESTABLECIMIENTO.NOMBRE),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(busquedaCombinada.getEsnombre().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + busquedaCombinada.getEsnombre().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t7ESTABLECIMIENTO.NOMBRE IS NOT NULL AND t4.FCODIGOACTUAL IS NOT NULL) ");

			where.append(" OR (TRANSLATE(UPPER(tt7ESTABLECIMIENTO.ESNOMBRE),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(busquedaCombinada.getEsnombre().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + busquedaCombinada.getEsnombre().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND tt7ESTABLECIMIENTO.ESNOMBRE IS NOT NULL AND t4.FCODIGOACTUAL IS NULL)) ");

		}

		// NIF establecimiento
		if (busquedaCombinada != null && busquedaCombinada.getEsnif() != null) {
			where.append(" AND ((UPPER(t7ESTABLECIMIENTO.NIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(busquedaCombinada.getEsnif().toUpperCase() + "%");
			} else {
				params.add("%" + busquedaCombinada.getEsnif().toUpperCase() + "%");
			}
			where.append(" AND t7ESTABLECIMIENTO.NIF IS NOT NULL  AND t4.FCODIGOACTUAL IS NOT NULL) ");

			where.append(" OR (UPPER(tt7ESTABLECIMIENTO.ESNIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(busquedaCombinada.getEsnif().toUpperCase() + "%");
			} else {
				params.add("%" + busquedaCombinada.getEsnif().toUpperCase() + "%");
			}
			where.append(" AND tt7ESTABLECIMIENTO.ESNIF IS NOT NULL AND t4.FCODIGOACTUAL IS NULL)) ");

		}

		// Nombre Comercial establecimiento
		if (busquedaCombinada != null && busquedaCombinada.getEsnoco() != null) {
			where.append(" AND ((TRANSLATE(UPPER(t7ESTABLECIMIENTO.ESNOCO),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(busquedaCombinada.getEsnoco().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + busquedaCombinada.getEsnoco().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t7ESTABLECIMIENTO.ESNOCO IS NOT NULL AND t4.FCODIGOACTUAL IS NOT NULL) ");

			where.append(" OR (TRANSLATE(UPPER(tt7ESTABLECIMIENTO.ESNOCO),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(busquedaCombinada.getEsnoco().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + busquedaCombinada.getEsnoco().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND tt7ESTABLECIMIENTO.ESNOCO IS NOT NULL AND t4.FCODIGOACTUAL IS NULL)) ");

		}

		if (busquedaCombinada != null && busquedaCombinada.getEsextranjero() != null
				&& busquedaCombinada.getEsestado() == null) {
			where.append(" AND ((t7ESTABLECIMIENTO.EXTRANJERO = ? AND t4.FCODIGOACTUAL IS NOT NULL) ");
			params.add(Y41bConstantes.SI);
			where.append(" OR (tt7ESTABLECIMIENTO.ESEXTRANJERO = ? AND t4.FCODIGOACTUAL IS NULL))");
			params.add(Y41bConstantes.SI);
		}
		if (busquedaCombinada != null && busquedaCombinada.getEsestado() != null
				&& busquedaCombinada.getEsextranjero() == null) {
			where.append(" AND ((t7ESTABLECIMIENTO.EXTRANJERO = ? AND t4.FCODIGOACTUAL IS NOT NULL)");
			params.add(Y41bConstantes.NO);
			where.append(" OR (tt7ESTABLECIMIENTO.ESEXTRANJERO = ? AND t4.FCODIGOACTUAL IS NULL)) ");
			params.add(Y41bConstantes.NO);
		}

		// Provincia establecimiento
		if (busquedaCombinada != null && busquedaCombinada.getEsnoraProvinciaId() != null) {
			where.append(" AND ((t7ESTABLECIMIENTO.NORA_PROVINCIA_ID = ? AND t4.FCODIGOACTUAL IS NOT NULL)");
			params.add(busquedaCombinada.getEsnoraProvinciaId());
			where.append(" OR (tt7ESTABLECIMIENTO.ESNORA_PROVINCIA_ID = ? AND t4.FCODIGOACTUAL IS NULL)) ");
			params.add(busquedaCombinada.getEsnoraProvinciaId());
		}

		// Municipio establecimiento
		if (busquedaCombinada != null && busquedaCombinada.getEsnoraMunicipioId() != null) {
			where.append(" AND ((t7ESTABLECIMIENTO.NORA_MUNICIPIO_ID = ? AND t4.FCODIGOACTUAL IS NOT NULL)");
			params.add(busquedaCombinada.getEsnoraMunicipioId());
			where.append(" OR (tt7ESTABLECIMIENTO.ESNORA_MUNICIPIO_ID = ? AND t4.FCODIGOACTUAL IS NULL)) ");
			params.add(busquedaCombinada.getEsnoraMunicipioId());
		}

		// Localidad establecimiento
		if (busquedaCombinada != null && busquedaCombinada.getEsnoraLocalidadId() != null) {
			where.append(" AND ((t7ESTABLECIMIENTO.NORA_LOCALIDAD_ID = ?  AND t4.FCODIGOACTUAL IS NOT NULL)");
			params.add(busquedaCombinada.getEsnoraLocalidadId());
			where.append(" OR (tt7ESTABLECIMIENTO.ESNORA_LOCALIDAD_ID = ? AND t4.FCODIGOACTUAL IS NULL)) ");
			params.add(busquedaCombinada.getEsnoraLocalidadId());
		}

		// Pais establecimiento
		if (busquedaCombinada != null && busquedaCombinada.getEsnoraPaisId() != null) {
			where.append(" AND ((t7ESTABLECIMIENTO.NORA_PAIS_ID = ? AND t4.FCODIGOACTUAL IS NOT NULL)");
			params.add(busquedaCombinada.getEsnoraPaisId());
			where.append(" OR (tt7ESTABLECIMIENTO.ESNORA_PAIS_ID = ? AND t4.FCODIGOACTUAL IS NULL)) ");
			params.add(busquedaCombinada.getEsnoraPaisId());
		}

		// Direccion extranjera establecimiento
		if (busquedaCombinada != null && busquedaCombinada.getEsdireccion_nocapv() != null) {
			where.append(
					" AND ((TRANSLATE(UPPER(t7ESTABLECIMIENTO.DIRECCION_NOCAPV),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(busquedaCombinada.getEsdireccion_nocapv().toUpperCase().replaceAll("", "A")
						.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%"
						+ busquedaCombinada.getEsdireccion_nocapv().toUpperCase().replaceAll("", "A")
								.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U")
						+ "%");
			}
			where.append(" AND t7ESTABLECIMIENTO.DIRECCION_NOCAPV IS NOT NULL AND t4.FCODIGOACTUAL IS NOT NULL)");

			where.append(
					" OR (TRANSLATE(UPPER(tt7ESTABLECIMIENTO.ESDIRECCION_NOCAPV),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(busquedaCombinada.getEsdireccion_nocapv().toUpperCase().replaceAll("", "A")
						.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%"
						+ busquedaCombinada.getEsdireccion_nocapv().toUpperCase().replaceAll("", "A")
								.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U")
						+ "%");
			}
			where.append(" AND tt7ESTABLECIMIENTO.ESDIRECCION_NOCAPV IS NOT NULL AND t4.FCODIGOACTUAL IS NULL))");
		}

		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Devuelve una lista con las solicitudes de un organismo.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<SolicitudBusqueda> findAllSolicitudesAbiertasInstructor(SolicitudBusqueda solicitudesBusqueda,
			Pagination pagination) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();

		where.append(
				" WHERE 1=1  AND t1.DECODIGO= t4.HDCODE AND t4.HDCODIGO= t3CONSUMIDOR.HDCODIGO AND t3CONSUMIDOR.TIPO_INTERVINIENTE='I' AND t4.HDCODIGO= t7ESTABLECIMIENTO.HDCODIGO AND t7ESTABLECIMIENTO.TIPO_INTERVINIENTE='D' AND t4.FCODIGOACTUAL = t5.FCODIGO AND t4.TRCODIGOACTUAL = t6.TRCODIGO AND t4.HDCOMO = t8.MOCODIGO AND t4.HDCODIGO = t9.HCCOHD AND t4.ISKONTSUMOBIDE = 'S' ");

		StringBuffer query = new StringBuffer(
				"SELECT t1.DECOOR DECOOR, t1.DENRAN DENRAN, t1.DENROR DENROR, t4.HDNROR HDNROR, t4.HDCODIGO HDCODIGO, t1.DEFEDE DEFEDE, t3CONSUMIDOR.NOMBRE DTNOMBRE, t3CONSUMIDOR.APELLIDO1 DTAPELLIDO1, t3CONSUMIDOR.APELLIDO2 DTAPELLIDO2, t3CONSUMIDOR.NIF DTNIF, t3CONSUMIDOR.NOMBRE_MUNICIPIO DTNOMBRE_MUNICIPIO, t7ESTABLECIMIENTO.NOMBRE ESNOMBRE, t7ESTABLECIMIENTO.NIF ESNIF, t7ESTABLECIMIENTO.ESNOCO ESNOCO, t5.FCODIGO FCODIGO, t5.FNOMBRE FNOMBRE, t5.FNOMBREE FNOMBREE, t6.TRCODIGO TRCODIGO, t6.TRNOMBRE TRNOMBRE, t6.TRNOMBREE TRNOMBREE, t8.MOCODIGO MOCODIGO, t8.MONOMBRE MONOMBRE "
						+ "FROM DENUNCIA t1,INTERVINIENTES t3CONSUMIDOR, HECHO_DENUNCIADO t4, INTERVINIENTES t7ESTABLECIMIENTO, FASE t5, TRAMITE t6, CENSO_MONITOR t8,DECISION_HECHO t9 ");

		where.append(" AND t4.HDCOMO = ? ");
		params.add(solicitudesBusqueda.getMocodigoExpediente());

		where.append(" AND t4.HDFECHACIERRE IS NULL ");

		// organismo seleccionado
		where.append(
				" AND (t9.HCCOOR = ? OR (EXISTS (SELECT IHCOORTR FROM TRASLADO tr WHERE (IHCOORTR = ? OR IHCOORDT= ?)AND IHCOHC=t9.HCCODIGO))) ");
		params.add(solicitudesBusqueda.getCodOrgSeleccionado());
		params.add(solicitudesBusqueda.getCodOrgSeleccionado());
		params.add(solicitudesBusqueda.getCodOrgSeleccionado());

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		}

		return (List<SolicitudBusqueda>) this.jdbcTemplate.query(query.toString(), new RowMapper<SolicitudBusqueda>() {
			public SolicitudBusqueda mapRow(ResultSet resultSet, int rowNum) throws SQLException {
				return new SolicitudBusqueda(resultSet.getString("HDCODIGO"), resultSet.getString("DECOOR"),
						resultSet.getBigDecimal("DENRAN"), resultSet.getBigDecimal("DENROR"),
						resultSet.getBigDecimal("HDNROR"), null, null, null, resultSet.getString("MOCODIGO"),
						resultSet.getString("MONOMBRE"), resultSet.getDate("DEFEDE"), null, null, null, null, null,
						null, null, null, null, resultSet.getString("FCODIGO"), resultSet.getString("FNOMBRE"),
						resultSet.getString("FNOMBREE"), resultSet.getString("TRCODIGO"),
						resultSet.getString("TRNOMBRE"), resultSet.getString("TRNOMBREE"), null, null, null, null, null,
						null, null, null, null, null, null, null, resultSet.getString("DTNOMBRE"),
						resultSet.getString("DTAPELLIDO1"), resultSet.getString("DTAPELLIDO2"),
						resultSet.getString("DTNIF"), null, null, null, null, resultSet.getString("DTNOMBRE_MUNICIPIO"),
						null, null, null, null, null, null, resultSet.getString("ESNOMBRE"),
						resultSet.getString("ESNIF"), resultSet.getString("ESNOCO"), null, null, null, null, null, null,
						null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
						null, null, null, null, null, null);
			}
		}, params.toArray());
	}

	/**
	 * Counts rows in the HechoDenunciado table.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllSolicitudesAbiertasInstructorCount(SolicitudBusqueda solicitudesBusqueda) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(
				" WHERE 1=1  AND t1.DECODIGO= t4.HDCODE AND t4.HDCODIGO= t3CONSUMIDOR.HDCODIGO AND t3CONSUMIDOR.TIPO_INTERVINIENTE='I' AND t4.HDCODIGO= t7ESTABLECIMIENTO.HDCODIGO AND t7ESTABLECIMIENTO.TIPO_INTERVINIENTE='D' AND t4.FCODIGOACTUAL = t5.FCODIGO AND t4.TRCODIGOACTUAL = t6.TRCODIGO AND t4.HDCOMO = t8.MOCODIGO AND t4.HDCODIGO = t9.HCCOHD AND t4.ISKONTSUMOBIDE = 'S' ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(t4.HDCODIGO) FROM DENUNCIA t1,INTERVINIENTES t3CONSUMIDOR, HECHO_DENUNCIADO t4, INTERVINIENTES t7ESTABLECIMIENTO, FASE t5, TRAMITE t6, CENSO_MONITOR t8,DECISION_HECHO t9 ");

		where.append(" AND t4.HDCOMO = ? ");
		params.add(solicitudesBusqueda.getMocodigoExpediente());

		where.append(" AND t4.HDFECHACIERRE IS NULL ");

		// organismo seleccionado
		where.append(
				" AND (t9.HCCOOR = ? OR (EXISTS (SELECT IHCOORTR FROM TRASLADO tr WHERE (IHCOORTR = ? OR IHCOORDT= ?)AND IHCOHC=t9.HCCODIGO))) ");
		params.add(solicitudesBusqueda.getCodOrgSeleccionado());
		params.add(solicitudesBusqueda.getCodOrgSeleccionado());
		params.add(solicitudesBusqueda.getCodOrgSeleccionado());

		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds a single row in the Tramite Hecho table.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @return TramiteHechoDetalle
	 */
	@Transactional(readOnly = true)
	public TramiteHechoDetalle findUltimoTramite(SolicitudBusqueda solicitudesBusqueda) {

		String query = "SELECT * FROM (SELECT tr1.EHCODIGO EHCODIGO, tr4.TRCODIGO TRCODIGO, tr4.TRNOMBRE TRNOMBRE, tr4.TRNOMBREE TRNOMBREE, tr4.TRBAJA TRBAJA "
				+ "FROM TRAMITE_HECHO tr1, TRAMITE tr4 "
				+ "WHERE tr1.EHCOTEE= tr4.TRCODIGO AND tr1.EHCOHD=? ORDER BY EHFECHA DESC, EHHORA DESC) WHERE ROWNUM=1";

		return (TramiteHechoDetalle) this.jdbcTemplate.queryForObject(query, new RowMapper<TramiteHechoDetalle>() {
			public TramiteHechoDetalle mapRow(ResultSet resultSet, int rowNum) throws SQLException {
				return new TramiteHechoDetalle(resultSet.getString("EHCODIGO"), null, null, null, null,
						resultSet.getString("TRCODIGO"), resultSet.getString("TRNOMBRE"),
						resultSet.getString("TRNOMBREE"), null, null, null, null, null, null, null, null, null, null,
						null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
						null, null, null, null, null, null, null, null);
			}
		}, solicitudesBusqueda.getHdcodigo());
	}

	/**
	 * Finds a single row in the HechoDenunciado table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @return SolicitudDetalle
	 */
	@Transactional(readOnly = true)
	public SolicitudDetalle findSolicitud(SolicitudDetalle solicitudDetalle) {

		String query = "SELECT t1.DECODIGO DECODIGO, t1.DECOOR DECOOR, t1.DENRAN DENRAN, t1.DENROR DENROR, t1.DEFEDE DEFEDE, t1.DEFERE DEFERE, t1.DEHOJARECLAMACION DEHOJARECLAMACION, t2.TFPCODIGO TFPCODIGO, t2.TFPNOMBRE TFPNOMBRE, t2.TFPNOMBREE TFPNOMBREE, t4.HDCODEXPEDIENTEORIGEN HDCODEXPEDIENTEORIGEN, t4.HDFORMANOTIFICACION HDFORMANOTIFICACION, t4.HDFORMANOTIFESTABLECIMIENTO HDFORMANOTIFESTABLECIMIENTO,t4.HDESNOMBRETELEMATICO HDESNOMBRETELEMATICO, t4.HDESDIRECCIONTELEMATICO HDESDIRECCIONTELEMATICO, t4.ISTELEMATICO ISTELEMATICO, t4.HDNUMREGISTROENTRADA HDNUMREGISTROENTRADA, t1.DECODT DECODT, t3CONSUMIDOR.NIF DTNIF, t3CONSUMIDOR.NOMBRE DTNOMBRE,  t3CONSUMIDOR.APELLIDO1 DTAPELLIDO1, t3CONSUMIDOR.APELLIDO2 DTAPELLIDO2, t3CONSUMIDOR.COEM DTTECOEM,  t3CONSUMIDOR.NRTEL DTNRTEL, t3CONSUMIDOR.NOMBRE_PROVINCIA DTNOMBRE_PROVINCIA,t3CONSUMIDOR.NOMBRE_MUNICIPIO DTNOMBRE_MUNICIPIO,t3CONSUMIDOR.NOMBRE_LOCALIDAD DTNOMBRE_LOCALIDAD, t3CONSUMIDOR.EXTRANJERO DTEXTRANJERO,t3CONSUMIDOR.NOMBRE_PAIS DTNOMBRE_PAIS,t3CONSUMIDOR.DIRECCION_NOCAPV DTDIRECCION_NOCAPV, t4.HDCOES HDCOES, t5ESTABLECIMIENTO.NOMBRE ESNOMBRE, t5ESTABLECIMIENTO.NIF ESNIF, t5ESTABLECIMIENTO.ESNOCO ESNOCO, t5ESTABLECIMIENTO.COEM ESCOEM, t5ESTABLECIMIENTO.NRTEL ESNRTEL, t5ESTABLECIMIENTO.INADAR ESINADAR, t5ESTABLECIMIENTO.NOMBRE_PROVINCIA ESNOMBRE_PROVINCIA,t5ESTABLECIMIENTO.NOMBRE_MUNICIPIO ESNOMBRE_MUNICIPIO,t5ESTABLECIMIENTO.NOMBRE_LOCALIDAD ESNOMBRE_LOCALIDAD, t5ESTABLECIMIENTO.EXTRANJERO ESEXTRANJERO,t5ESTABLECIMIENTO.NOMBRE_PAIS ESNOMBRE_PAIS,t5ESTABLECIMIENTO.DIRECCION_NOCAPV ESDIRECCION_NOCAPV, t5ESTABLECIMIENTO.SECODIGO SECODIGO, t5ESTABLECIMIENTO.SENOMBRE SENOMBRE, t5ESTABLECIMIENTO.SENOMBREE SENOMBREE, t4.HDCODIGO HDCODIGO, t4.HDFEHD HDFEHD, t4.HDNROR HDNROR, t4.HDINSOMA HDINSOMA, t4.HDCAPTSO HDCAPTSO, t4.HDTESO HDTESO, t4.HDCOSC HDCOSC, t8.MOCODIGO MOCODIGO, t8.MONOMBRE MONOMBRE, t9.PSCODIGO PSCODIGO, t9.PSNOMBRE PSNOMBRE, t9.PSNOMBREE PSNOMBREE, t4.HDNOPS HDNOPS, t4.HDNOMAPS HDNOMAPS, t4.HDNOMOPS HDNOMOPS, t4.HDNRLOPS HDNRLOPS, t4.HDFEDMPS HDFEDMPS, t10.TIRCODIGO TIRCODIGO, t10.TIRNOMBRE TIRNOMBRE, t11.TSRCODIGO TSRCODIGO,t11.TSRNOMBRE TSRNOMBRE,t11.TSRNOMBREE TSRNOMBREE, t12.HCCOOR HCCOOR, t13.FCODIGO FCODIGO, t13.FNOMBRE FNOMBRE, t13.FNOMBREE FNOMBREE, t14.TRCODIGO TRCODIGO, t14.TRNOMBRE TRNOMBRE, t14.TRNOMBREE TRNOMBREE, t4.HDFECHACIERRE HDFECHACIERRE, t4.TRPOSIBLECODIGO TRPOSIBLECODIGO, t4.HDIDIOMA HDIDIOMA,t4.HDNUMREGISTROORIGEN HDNUMREGISTROORIGEN,t4.HDFECHAREGISTROORIGEN HDFECHAREGISTROORIGEN,t4.HDFORMAVENTA HDFORMAVENTA, t15.FVNOMBRE FVNOMBRE, t15.FVNOMBREE FVNOMBREE, t4.HDFORMAVENTATELEMATICA HDFORMAVENTATELEMATICA, t16.FVNOMBRE FVNOMBRETELEMATICA, t16.FVNOMBREE FVNOMBREETELEMATICA,t4.HDCODIGOBARRAS HDCODIGOBARRAS, t4.HDINTERESADO HDINTERESADO, t4.HDDENUNCIAAACCEMPRESAS HDDENUNCIAAACCEMPRESAS, t1.DENOMBRETELEMATICO DENOMBRETELEMATICO, t1.DEDIRECCIONTELEMATICO DEDIRECCIONTELEMATICO, t4.HDESNOMBRETELEMATICO HDNOMBRETELEMATICO, t4.HDESDIRECCIONTELEMATICO HDDIRECCIONTELEMATICO, t4.HDTIPODENUNCIANTE HDTIPODENUNCIANTE, t4.HDIDIOMARECLAMADO HDIDIOMARECLAMADO, t4.HDPARTICIPACIONRECLAMADO HDPARTICIPACIONRECLAMADO, t4.HDDESTNOTIFICARECLAMANTE HDDESTNOTIFICARECLAMANTE, t4.HDDESTNOTIFICARECLAMADO HDDESTNOTIFICARECLAMADO, t4.HDIDPARTICIPACIONRECLAMANTE HDIDPARTICIPACIONRECLAMANTE, t4.HDIDPARTICIPACIONRECLAMADO HDIDPARTICIPACIONRECLAMADO, t4.ISSIR ISSIR, t4.ARSOLICITANTE ARSOLICITANTE, t4.ARRESUMEN ARRESUMEN "
				+ "FROM DENUNCIA t1 ,FORMA_PRESENTACION t2,INTERVINIENTES t3CONSUMIDOR,HECHO_DENUNCIADO t4, INTERVINIENTES t5ESTABLECIMIENTO, CENSO_MONITOR t8, PRODUCTO t9, MOTIVO t10, TIPO_RECLAMACION t11, DECISION_HECHO t12, FASE t13, TRAMITE t14, FORMAS_VENTA t15 , FORMAS_VENTA t16 "
				+ "WHERE 1=1 AND t1.DECOTFP= t2.TFPCODIGO(+) AND t1.DECODIGO= t4.HDCODE(+) AND t4.HDCODIGO= t3CONSUMIDOR.HDCODIGO(+) AND t3CONSUMIDOR.TIPO_INTERVINIENTE(+)='I' AND t4.HDCODIGO= t5ESTABLECIMIENTO.HDCODIGO(+) AND t5ESTABLECIMIENTO.TIPO_INTERVINIENTE(+)='D' AND t4.HDCOMO = t8.MOCODIGO(+) AND t4.HDCOPS = t9.PSCODIGO(+) AND t4.HDCOTIR = t10.TIRCODIGO(+) AND t4.HDCOTSR = t11.TSRCODIGO(+) AND t4.HDCODIGO = t12.HCCOHD(+) AND t4.FCODIGOACTUAL = t13.FCODIGO(+) AND t4.TRCODIGOACTUAL = t14.TRCODIGO(+) AND t4.HDFORMAVENTA = t15.FVCODIGO(+) AND t4.HDFORMAVENTATELEMATICA = t16.FVCODIGO(+) AND t4.HDCODIGO=? AND ROWNUM = 1 ";

		return (SolicitudDetalle) this.jdbcTemplate.queryForObject(query, new RowMapper<SolicitudDetalle>() {
			public SolicitudDetalle mapRow(ResultSet resultSet, int rowNum) throws SQLException {

				return new SolicitudDetalle(resultSet.getString("DECODIGO"), resultSet.getString("DECOOR"),
						resultSet.getInt("DENRAN"), resultSet.getLong("DENROR"), resultSet.getDate("DEFEDE"),
						resultSet.getDate("DEFERE"), resultSet.getString("DEHOJARECLAMACION"),
						resultSet.getString("TFPCODIGO"), resultSet.getString("TFPNOMBRE"),
						resultSet.getString("TFPNOMBREE"), resultSet.getString("HDCODEXPEDIENTEORIGEN"),
						resultSet.getString("HDFORMANOTIFICACION"), resultSet.getString("HDFORMANOTIFESTABLECIMIENTO"),
						resultSet.getString("HDESNOMBRETELEMATICO"), resultSet.getString("HDESDIRECCIONTELEMATICO"),
						resultSet.getString("ISTELEMATICO"),

						resultSet.getString("HDNUMREGISTROENTRADA"), resultSet.getString("DECODT"),
						resultSet.getString("DTNOMBRE"), resultSet.getString("DTAPELLIDO1"),
						resultSet.getString("DTAPELLIDO2"), resultSet.getString("DTNIF"),
						resultSet.getString("DTTECOEM"), resultSet.getString("DTNRTEL"),
						resultSet.getString("DTNOMBRE_PROVINCIA"), resultSet.getString("DTNOMBRE_MUNICIPIO"),
						resultSet.getString("DTNOMBRE_LOCALIDAD"), resultSet.getString("DTEXTRANJERO"),
						resultSet.getString("DTNOMBRE_PAIS"), resultSet.getString("DTDIRECCION_NOCAPV"),
						resultSet.getString("HDCOES"), resultSet.getString("ESNOMBRE"), resultSet.getString("ESNIF"),
						resultSet.getString("ESNOCO"), resultSet.getString("ESCOEM"), resultSet.getString("ESNRTEL"),
						resultSet.getString("ESINADAR"), resultSet.getString("ESNOMBRE_PROVINCIA"),
						resultSet.getString("ESNOMBRE_MUNICIPIO"), resultSet.getString("ESNOMBRE_LOCALIDAD"),
						resultSet.getString("ESEXTRANJERO"), resultSet.getString("ESNOMBRE_PAIS"),
						resultSet.getString("ESDIRECCION_NOCAPV"), resultSet.getString("SECODIGO"),
						resultSet.getString("SENOMBRE"), resultSet.getString("SENOMBREE"),
						resultSet.getString("HDCODIGO"), resultSet.getDate("HDFEHD"), null, resultSet.getLong("HDNROR"),
						resultSet.getString("HDINSOMA"), resultSet.getBigDecimal("HDCAPTSO"),
						resultSet.getString("HDTESO"), resultSet.getString("HDCOSC"), resultSet.getString("MOCODIGO"),
						resultSet.getString("MONOMBRE"), resultSet.getString("PSCODIGO"),
						resultSet.getString("PSNOMBRE"), resultSet.getString("PSNOMBREE"),
						resultSet.getString("HDNOPS"), resultSet.getString("HDNOMAPS"),
						resultSet.getString("HDCODIGOBARRAS"), resultSet.getString("HDINTERESADO"),
						resultSet.getString("HDNOMOPS"), resultSet.getString("HDNRLOPS"), resultSet.getDate("HDFEDMPS"),
						resultSet.getString("TIRCODIGO"), resultSet.getString("TIRNOMBRE"),
						resultSet.getString("TSRCODIGO"), resultSet.getString("TSRNOMBRE"),
						resultSet.getString("TSRNOMBREE"), null, null, null, resultSet.getString("HCCOOR"), null, null,
						null, null, resultSet.getString("FCODIGO"), resultSet.getString("FNOMBRE"),
						resultSet.getString("FNOMBREE"), resultSet.getString("TRCODIGO"),
						resultSet.getString("TRNOMBRE"), resultSet.getString("TRNOMBREE"),
						resultSet.getString("TRPOSIBLECODIGO"), null, null, null, null,
						resultSet.getDate("HDFECHACIERRE"), resultSet.getString("HDIDIOMA"),
						resultSet.getString("HDNUMREGISTROORIGEN"), resultSet.getDate("HDFECHAREGISTROORIGEN"),
						resultSet.getString("HDFORMAVENTA"), resultSet.getString("FVNOMBRE"),
						resultSet.getString("FVNOMBREE"), resultSet.getString("HDFORMAVENTATELEMATICA"),
						resultSet.getString("FVNOMBRETELEMATICA"), resultSet.getString("FVNOMBREETELEMATICA"), null,
						null, resultSet.getString("HDDENUNCIAAACCEMPRESAS"),

						resultSet.getString("DENOMBRETELEMATICO"), resultSet.getString("DEDIRECCIONTELEMATICO"),
						resultSet.getString("HDNOMBRETELEMATICO"), resultSet.getString("HDDIRECCIONTELEMATICO"),
						resultSet.getString("HDTIPODENUNCIANTE"), resultSet.getString("HDIDIOMARECLAMADO"),
						resultSet.getString("HDPARTICIPACIONRECLAMADO"),
						resultSet.getString("HDDESTNOTIFICARECLAMANTE"), resultSet.getString("HDDESTNOTIFICARECLAMADO"),
						resultSet.getString("HDIDPARTICIPACIONRECLAMANTE"),
						resultSet.getString("HDIDPARTICIPACIONRECLAMADO"), resultSet.getString("ISSIR"),
						resultSet.getString("ARSOLICITANTE"), resultSet.getString("ARRESUMEN"));
			}
		}, solicitudDetalle.getHdcodigo()

		);
	}

	/**
	 * Finds a single row in the HechoDenunciado table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @return SolicitudDetalle
	 */
	@Transactional(readOnly = true)
	public SolicitudDetalle findSolicitudByNumeroExpediente(SolicitudDetalle solicitudDetalle) {

		try {
			String query = "SELECT t1.DECODIGO DECODIGO, t1.DECOOR DECOOR, t1.DENRAN DENRAN, t1.DENROR DENROR, t1.DEFEDE DEFEDE, t1.DEFERE DEFERE, t1.DEHOJARECLAMACION DEHOJARECLAMACION, t2.TFPCODIGO TFPCODIGO, t2.TFPNOMBRE TFPNOMBRE, t2.TFPNOMBREE TFPNOMBREE, t4.HDCODEXPEDIENTEORIGEN HDCODEXPEDIENTEORIGEN, t4.HDFORMANOTIFICACION HDFORMANOTIFICACION, t4.HDFORMANOTIFESTABLECIMIENTO HDFORMANOTIFESTABLECIMIENTO, t4.HDESNOMBRETELEMATICO HDESNOMBRETELEMATICO, t4.HDESDIRECCIONTELEMATICO HDESDIRECCIONTELEMATICO, t4.ISTELEMATICO ISTELEMATICO, t4.HDNUMREGISTROENTRADA HDNUMREGISTROENTRADA, t1.DECODT DECODT, t3CONSUMIDOR.NIF DTNIF, t3CONSUMIDOR.NOMBRE DTNOMBRE,  t3CONSUMIDOR.APELLIDO1 DTAPELLIDO1, t3CONSUMIDOR.APELLIDO2 DTAPELLIDO2, t3CONSUMIDOR.COEM DTTECOEM,  t3CONSUMIDOR.NRTEL DTNRTEL, t3CONSUMIDOR.NOMBRE_PROVINCIA DTNOMBRE_PROVINCIA,t3CONSUMIDOR.NOMBRE_MUNICIPIO DTNOMBRE_MUNICIPIO,t3CONSUMIDOR.NOMBRE_LOCALIDAD DTNOMBRE_LOCALIDAD, t3CONSUMIDOR.EXTRANJERO DTEXTRANJERO,t3CONSUMIDOR.NOMBRE_PAIS DTNOMBRE_PAIS,t3CONSUMIDOR.DIRECCION_NOCAPV DTDIRECCION_NOCAPV, t4.HDCOES HDCOES, t5ESTABLECIMIENTO.NOMBRE ESNOMBRE, t5ESTABLECIMIENTO.NIF ESNIF, t5ESTABLECIMIENTO.ESNOCO ESNOCO, t5ESTABLECIMIENTO.COEM ESCOEM, t5ESTABLECIMIENTO.NRTEL ESNRTEL, t5ESTABLECIMIENTO.INADAR ESINADAR, t5ESTABLECIMIENTO.NOMBRE_PROVINCIA ESNOMBRE_PROVINCIA,t5ESTABLECIMIENTO.NOMBRE_MUNICIPIO ESNOMBRE_MUNICIPIO,t5ESTABLECIMIENTO.NOMBRE_LOCALIDAD ESNOMBRE_LOCALIDAD, t5ESTABLECIMIENTO.EXTRANJERO ESEXTRANJERO,t5ESTABLECIMIENTO.NOMBRE_PAIS ESNOMBRE_PAIS,t5ESTABLECIMIENTO.DIRECCION_NOCAPV ESDIRECCION_NOCAPV, t5ESTABLECIMIENTO.SECODIGO SECODIGO, t5ESTABLECIMIENTO.SENOMBRE SENOMBRE, t5ESTABLECIMIENTO.SENOMBREE SENOMBREE, t4.HDCODIGO HDCODIGO, t4.HDFEHD HDFEHD, t4.HDNROR HDNROR, t4.HDINSOMA HDINSOMA, t4.HDCAPTSO HDCAPTSO, t4.HDTESO HDTESO, t4.HDCOSC HDCOSC, t8.MOCODIGO MOCODIGO, t8.MONOMBRE MONOMBRE, t9.PSCODIGO PSCODIGO, t9.PSNOMBRE PSNOMBRE, t9.PSNOMBREE PSNOMBREE, t4.HDNOPS HDNOPS, t4.HDNOMAPS HDNOMAPS, t4.HDNOMOPS HDNOMOPS, t4.HDNRLOPS HDNRLOPS, t4.HDFEDMPS HDFEDMPS, t10.TIRCODIGO TIRCODIGO, t10.TIRNOMBRE TIRNOMBRE, t11.TSRCODIGO TSRCODIGO,t11.TSRNOMBRE TSRNOMBRE,t11.TSRNOMBREE TSRNOMBREE, t12.HCCOOR HCCOOR, t13.FCODIGO FCODIGO, t13.FNOMBRE FNOMBRE, t13.FNOMBREE FNOMBREE, t14.TRCODIGO TRCODIGO, t14.TRNOMBRE TRNOMBRE, t14.TRNOMBREE TRNOMBREE, t4.HDFECHACIERRE HDFECHACIERRE, t4.TRPOSIBLECODIGO TRPOSIBLECODIGO, t4.HDIDIOMA HDIDIOMA,t4.HDNUMREGISTROORIGEN HDNUMREGISTROORIGEN,t4.HDFECHAREGISTROORIGEN HDFECHAREGISTROORIGEN,t4.HDFORMAVENTA HDFORMAVENTA, t15.FVNOMBRE FVNOMBRE, t15.FVNOMBREE FVNOMBREE, t12.HCCOTTD HCCOTTD, t12.HCFEDE HCFEDE, t4.HDCODIGOBARRAS HDCODIGOBARRAS, t4.HDINTERESADO HDINTERESADO, t4.HDDENUNCIAAACCEMPRESAS HDDENUNCIAAACCEMPRESAS, t1.DENOMBRETELEMATICO DENOMBRETELEMATICO, t1.DEDIRECCIONTELEMATICO DEDIRECCIONTELEMATICO, t4.HDESNOMBRETELEMATICO HDNOMBRETELEMATICO, t4.HDESDIRECCIONTELEMATICO HDDIRECCIONTELEMATICO, t4.HDTIPODENUNCIANTE HDTIPODENUNCIANTE, t4.HDIDIOMARECLAMADO HDIDIOMARECLAMADO, t4.HDPARTICIPACIONRECLAMADO HDPARTICIPACIONRECLAMADO, t4.HDDESTNOTIFICARECLAMANTE HDDESTNOTIFICARECLAMANTE, t4.HDDESTNOTIFICARECLAMADO HDDESTNOTIFICARECLAMADO, t4.HDIDPARTICIPACIONRECLAMANTE HDIDPARTICIPACIONRECLAMANTE, t4.HDIDPARTICIPACIONRECLAMADO HDIDPARTICIPACIONRECLAMADO, t4.ISSIR ISSIR,t4.ARSOLICITANTE ARSOLICITANTE,t4.ARRESUMEN ARRESUMEN "
					+ "FROM DENUNCIA t1 ,FORMA_PRESENTACION t2,INTERVINIENTES t3CONSUMIDOR,HECHO_DENUNCIADO t4, INTERVINIENTES t5ESTABLECIMIENTO, CENSO_MONITOR t8, PRODUCTO t9, MOTIVO t10, TIPO_RECLAMACION t11, DECISION_HECHO t12, FASE t13, TRAMITE t14, FORMAS_VENTA t15 "
					+ "WHERE 1=1 AND t1.DECOTFP= t2.TFPCODIGO(+) AND t1.DECODIGO= t4.HDCODE(+) AND t4.HDCODIGO= t3CONSUMIDOR.HDCODIGO(+) AND t3CONSUMIDOR.TIPO_INTERVINIENTE(+)='I' AND t4.HDCODIGO= t5ESTABLECIMIENTO.HDCODIGO(+) AND t5ESTABLECIMIENTO.TIPO_INTERVINIENTE(+)='D' AND t4.HDCOMO = t8.MOCODIGO(+) AND t4.HDCOPS = t9.PSCODIGO(+) AND t4.HDCOTIR = t10.TIRCODIGO(+) AND t4.HDCOTSR = t11.TSRCODIGO(+) AND t4.HDCODIGO = t12.HCCOHD(+) AND t4.FCODIGOACTUAL = t13.FCODIGO(+) AND t4.TRCODIGOACTUAL = t14.TRCODIGO(+) AND t4.HDFORMAVENTA = t15.FVCODIGO(+) AND t1.DECOOR=? AND t1.DENRAN=? AND t1.DENROR=? AND t4.HDNROR=? AND ROWNUM = 1 ";

			return (SolicitudDetalle) this.jdbcTemplate.queryForObject(query, new RowMapper<SolicitudDetalle>() {
				public SolicitudDetalle mapRow(ResultSet resultSet, int rowNum) throws SQLException {

					return new SolicitudDetalle(resultSet.getString("DECODIGO"), resultSet.getString("DECOOR"),
							resultSet.getInt("DENRAN"), resultSet.getLong("DENROR"), resultSet.getDate("DEFEDE"),
							resultSet.getDate("DEFERE"), resultSet.getString("DEHOJARECLAMACION"),
							resultSet.getString("TFPCODIGO"), resultSet.getString("TFPNOMBRE"),
							resultSet.getString("TFPNOMBREE"), resultSet.getString("HDCODEXPEDIENTEORIGEN"),
							resultSet.getString("HDFORMANOTIFICACION"),
							resultSet.getString("HDFORMANOTIFESTABLECIMIENTO"),

							resultSet.getString("HDESNOMBRETELEMATICO"), resultSet.getString("HDESDIRECCIONTELEMATICO"),
							resultSet.getString("ISTELEMATICO"),

							resultSet.getString("HDNUMREGISTROENTRADA"), resultSet.getString("DECODT"),
							resultSet.getString("DTNOMBRE"), resultSet.getString("DTAPELLIDO1"),
							resultSet.getString("DTAPELLIDO2"), resultSet.getString("DTNIF"),
							resultSet.getString("DTTECOEM"), resultSet.getString("DTNRTEL"),
							resultSet.getString("DTNOMBRE_PROVINCIA"), resultSet.getString("DTNOMBRE_MUNICIPIO"),
							resultSet.getString("DTNOMBRE_LOCALIDAD"), resultSet.getString("DTEXTRANJERO"),
							resultSet.getString("DTNOMBRE_PAIS"), resultSet.getString("DTDIRECCION_NOCAPV"),
							resultSet.getString("HDCOES"), resultSet.getString("ESNOMBRE"),
							resultSet.getString("ESNIF"), resultSet.getString("ESNOCO"), resultSet.getString("ESCOEM"),
							resultSet.getString("ESNRTEL"), resultSet.getString("ESINADAR"),
							resultSet.getString("ESNOMBRE_PROVINCIA"), resultSet.getString("ESNOMBRE_MUNICIPIO"),
							resultSet.getString("ESNOMBRE_LOCALIDAD"), resultSet.getString("ESEXTRANJERO"),
							resultSet.getString("ESNOMBRE_PAIS"), resultSet.getString("ESDIRECCION_NOCAPV"),
							resultSet.getString("SECODIGO"), resultSet.getString("SENOMBRE"),
							resultSet.getString("SENOMBREE"), resultSet.getString("HDCODIGO"),
							resultSet.getDate("HDFEHD"), null, resultSet.getLong("HDNROR"),
							resultSet.getString("HDINSOMA"), resultSet.getBigDecimal("HDCAPTSO"),
							resultSet.getString("HDTESO"), resultSet.getString("HDCOSC"),
							resultSet.getString("MOCODIGO"), resultSet.getString("MONOMBRE"),
							resultSet.getString("PSCODIGO"), resultSet.getString("PSNOMBRE"),
							resultSet.getString("PSNOMBREE"), resultSet.getString("HDNOPS"),
							resultSet.getString("HDNOMAPS"), resultSet.getString("HDCODIGOBARRAS"),
							resultSet.getString("HDINTERESADO"), resultSet.getString("HDNOMOPS"),
							resultSet.getString("HDNRLOPS"), resultSet.getDate("HDFEDMPS"),
							resultSet.getString("TIRCODIGO"), resultSet.getString("TIRNOMBRE"),
							resultSet.getString("TSRCODIGO"), resultSet.getString("TSRNOMBRE"),
							resultSet.getString("TSRNOMBREE"), null, null, null, resultSet.getString("HCCOOR"),
							resultSet.getDate("HCFEDE"), null, null, null, resultSet.getString("FCODIGO"),
							resultSet.getString("FNOMBRE"), resultSet.getString("FNOMBREE"),
							resultSet.getString("TRCODIGO"), resultSet.getString("TRNOMBRE"),
							resultSet.getString("TRNOMBREE"), resultSet.getString("TRPOSIBLECODIGO"), null, null, null,
							null, resultSet.getDate("HDFECHACIERRE"), resultSet.getString("HDIDIOMA"),
							resultSet.getString("HDNUMREGISTROORIGEN"), resultSet.getDate("HDFECHAREGISTROORIGEN"),
							resultSet.getString("HDFORMAVENTA"), resultSet.getString("FVNOMBRE"),
							resultSet.getString("FVNOMBREE"), null, null, null, resultSet.getString("HCCOTTD"), null,
							resultSet.getString("HDDENUNCIAAACCEMPRESAS"),

							resultSet.getString("DENOMBRETELEMATICO"), resultSet.getString("DEDIRECCIONTELEMATICO"),
							resultSet.getString("HDNOMBRETELEMATICO"), resultSet.getString("HDDIRECCIONTELEMATICO"),
							resultSet.getString("HDTIPODENUNCIANTE"), resultSet.getString("HDIDIOMARECLAMADO"),
							resultSet.getString("HDPARTICIPACIONRECLAMADO"),
							resultSet.getString("HDDESTNOTIFICARECLAMANTE"),
							resultSet.getString("HDDESTNOTIFICARECLAMADO"),
							resultSet.getString("HDIDPARTICIPACIONRECLAMANTE"),
							resultSet.getString("HDIDPARTICIPACIONRECLAMADO"), resultSet.getString("ISSIR"),
							resultSet.getString("ARSOLICITANTE"), resultSet.getString("ARRESUMEN"));

				}
			}, solicitudDetalle.getDecoor(), solicitudDetalle.getDenran(), solicitudDetalle.getDenror(),
					solicitudDetalle.getHdnror());
		} catch (EmptyResultDataAccessException e) {
			return new SolicitudDetalle();
		}
	}

	/**
	 * Finds a single row in the HechoDenunciado table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @return SolicitudDetalle
	 */
	@Transactional(readOnly = true)
	public SolicitudDetalle findSolicitudByRegistryNumber(SolicitudDetalle solicitudDetalle) {

		try {
			String query = "SELECT t1.DECODIGO DECODIGO, t1.DECOOR DECOOR, t1.DENRAN DENRAN, t1.DENROR DENROR, t1.DEFEDE DEFEDE, t1.DEFERE DEFERE, t1.DEHOJARECLAMACION DEHOJARECLAMACION, t2.TFPCODIGO TFPCODIGO, t2.TFPNOMBRE TFPNOMBRE, t2.TFPNOMBREE TFPNOMBREE, t4.HDCODEXPEDIENTEORIGEN HDCODEXPEDIENTEORIGEN, t4.HDFORMANOTIFICACION HDFORMANOTIFICACION, t4.HDFORMANOTIFESTABLECIMIENTO HDFORMANOTIFESTABLECIMIENTO, t4.HDESNOMBRETELEMATICO HDESNOMBRETELEMATICO, t4.HDESDIRECCIONTELEMATICO HDESDIRECCIONTELEMATICO, t4.ISTELEMATICO ISTELEMATICO, t4.HDNUMREGISTROENTRADA HDNUMREGISTROENTRADA, t1.DECODT DECODT, t3CONSUMIDOR.NIF DTNIF, t3CONSUMIDOR.NOMBRE DTNOMBRE,  t3CONSUMIDOR.APELLIDO1 DTAPELLIDO1, t3CONSUMIDOR.APELLIDO2 DTAPELLIDO2, t3CONSUMIDOR.COEM DTTECOEM,  t3CONSUMIDOR.NRTEL DTNRTEL, t3CONSUMIDOR.NOMBRE_PROVINCIA DTNOMBRE_PROVINCIA,t3CONSUMIDOR.NOMBRE_MUNICIPIO DTNOMBRE_MUNICIPIO,t3CONSUMIDOR.NOMBRE_LOCALIDAD DTNOMBRE_LOCALIDAD, t3CONSUMIDOR.EXTRANJERO DTEXTRANJERO,t3CONSUMIDOR.NOMBRE_PAIS DTNOMBRE_PAIS,t3CONSUMIDOR.DIRECCION_NOCAPV DTDIRECCION_NOCAPV, t4.HDCOES HDCOES, t5ESTABLECIMIENTO.NOMBRE ESNOMBRE, t5ESTABLECIMIENTO.NIF ESNIF, t5ESTABLECIMIENTO.ESNOCO ESNOCO, t5ESTABLECIMIENTO.COEM ESCOEM, t5ESTABLECIMIENTO.NRTEL ESNRTEL, t5ESTABLECIMIENTO.INADAR ESINADAR, t5ESTABLECIMIENTO.NOMBRE_PROVINCIA ESNOMBRE_PROVINCIA,t5ESTABLECIMIENTO.NOMBRE_MUNICIPIO ESNOMBRE_MUNICIPIO,t5ESTABLECIMIENTO.NOMBRE_LOCALIDAD ESNOMBRE_LOCALIDAD, t5ESTABLECIMIENTO.EXTRANJERO ESEXTRANJERO,t5ESTABLECIMIENTO.NOMBRE_PAIS ESNOMBRE_PAIS,t5ESTABLECIMIENTO.DIRECCION_NOCAPV ESDIRECCION_NOCAPV, t5ESTABLECIMIENTO.SECODIGO SECODIGO, t5ESTABLECIMIENTO.SENOMBRE SENOMBRE, t5ESTABLECIMIENTO.SENOMBREE SENOMBREE, t4.HDCODIGO HDCODIGO, t4.HDFEHD HDFEHD, t4.HDNROR HDNROR, t4.HDINSOMA HDINSOMA, t4.HDCAPTSO HDCAPTSO, t4.HDTESO HDTESO, t4.HDCOSC HDCOSC, t8.MOCODIGO MOCODIGO, t8.MONOMBRE MONOMBRE, t9.PSCODIGO PSCODIGO, t9.PSNOMBRE PSNOMBRE, t9.PSNOMBREE PSNOMBREE, t4.HDNOPS HDNOPS, t4.HDNOMAPS HDNOMAPS, t4.HDNOMOPS HDNOMOPS, t4.HDNRLOPS HDNRLOPS, t4.HDFEDMPS HDFEDMPS, t10.TIRCODIGO TIRCODIGO, t10.TIRNOMBRE TIRNOMBRE, t11.TSRCODIGO TSRCODIGO,t11.TSRNOMBRE TSRNOMBRE,t11.TSRNOMBREE TSRNOMBREE, t12.HCCOOR HCCOOR, t13.FCODIGO FCODIGO, t13.FNOMBRE FNOMBRE, t13.FNOMBREE FNOMBREE, t14.TRCODIGO TRCODIGO, t14.TRNOMBRE TRNOMBRE, t14.TRNOMBREE TRNOMBREE, t4.HDFECHACIERRE HDFECHACIERRE, t4.TRPOSIBLECODIGO TRPOSIBLECODIGO, t4.HDIDIOMA HDIDIOMA,t4.HDNUMREGISTROORIGEN HDNUMREGISTROORIGEN,t4.HDFECHAREGISTROORIGEN HDFECHAREGISTROORIGEN,t4.HDFORMAVENTA HDFORMAVENTA, t15.FVNOMBRE FVNOMBRE, t15.FVNOMBREE FVNOMBREE, t12.HCCOTTD HCCOTTD, t12.HCFEDE HCFEDE, t4.HDCODIGOBARRAS HDCODIGOBARRAS, t4.HDINTERESADO HDINTERESADO, t4.HDDENUNCIAAACCEMPRESAS HDDENUNCIAAACCEMPRESAS, t1.DENOMBRETELEMATICO DENOMBRETELEMATICO, t1.DEDIRECCIONTELEMATICO DEDIRECCIONTELEMATICO, t4.HDESNOMBRETELEMATICO HDNOMBRETELEMATICO, t4.HDESDIRECCIONTELEMATICO HDDIRECCIONTELEMATICO, t4.HDTIPODENUNCIANTE HDTIPODENUNCIANTE, t4.HDIDIOMARECLAMADO HDIDIOMARECLAMADO, t4.HDPARTICIPACIONRECLAMADO HDPARTICIPACIONRECLAMADO, t4.HDDESTNOTIFICARECLAMANTE HDDESTNOTIFICARECLAMANTE, t4.HDDESTNOTIFICARECLAMADO HDDESTNOTIFICARECLAMADO, t4.HDIDPARTICIPACIONRECLAMANTE HDIDPARTICIPACIONRECLAMANTE, t4.HDIDPARTICIPACIONRECLAMADO HDIDPARTICIPACIONRECLAMADO, t4.ISSIR ISSIR,t4.ARSOLICITANTE ARSOLICITANTE,t4.ARRESUMEN ARRESUMEN "
					+ "FROM DENUNCIA t1 ,FORMA_PRESENTACION t2,INTERVINIENTES t3CONSUMIDOR,HECHO_DENUNCIADO t4, INTERVINIENTES t5ESTABLECIMIENTO, CENSO_MONITOR t8, PRODUCTO t9, MOTIVO t10, TIPO_RECLAMACION t11, DECISION_HECHO t12, FASE t13, TRAMITE t14, FORMAS_VENTA t15 "
					+ "WHERE 1=1 AND t1.DECOTFP= t2.TFPCODIGO(+) AND t1.DECODIGO= t4.HDCODE(+) AND t4.HDCODIGO= t3CONSUMIDOR.HDCODIGO(+) AND t3CONSUMIDOR.TIPO_INTERVINIENTE(+)='I' AND t4.HDCODIGO= t5ESTABLECIMIENTO.HDCODIGO(+) AND t5ESTABLECIMIENTO.TIPO_INTERVINIENTE(+)='D' AND t4.HDCOMO = t8.MOCODIGO(+) AND t4.HDCOPS = t9.PSCODIGO(+) AND t4.HDCOTIR = t10.TIRCODIGO(+) AND t4.HDCOTSR = t11.TSRCODIGO(+) AND t4.HDCODIGO = t12.HCCOHD(+) AND t4.FCODIGOACTUAL = t13.FCODIGO(+) AND t4.TRCODIGOACTUAL = t14.TRCODIGO(+) AND t4.HDFORMAVENTA = t15.FVCODIGO(+) AND t4.HDNUMREGISTROENTRADA=? AND ROWNUM = 1 ";

			return (SolicitudDetalle) this.jdbcTemplate.queryForObject(query, new RowMapper<SolicitudDetalle>() {
				public SolicitudDetalle mapRow(ResultSet resultSet, int rowNum) throws SQLException {

					return new SolicitudDetalle(resultSet.getString("DECODIGO"), resultSet.getString("DECOOR"),
							resultSet.getInt("DENRAN"), resultSet.getLong("DENROR"), resultSet.getDate("DEFEDE"),
							resultSet.getDate("DEFERE"), resultSet.getString("DEHOJARECLAMACION"),
							resultSet.getString("TFPCODIGO"), resultSet.getString("TFPNOMBRE"),
							resultSet.getString("TFPNOMBREE"), resultSet.getString("HDCODEXPEDIENTEORIGEN"),
							resultSet.getString("HDFORMANOTIFICACION"),
							resultSet.getString("HDFORMANOTIFESTABLECIMIENTO"),

							resultSet.getString("HDESNOMBRETELEMATICO"), resultSet.getString("HDESDIRECCIONTELEMATICO"),
							resultSet.getString("ISTELEMATICO"),

							resultSet.getString("HDNUMREGISTROENTRADA"), resultSet.getString("DECODT"),
							resultSet.getString("DTNOMBRE"), resultSet.getString("DTAPELLIDO1"),
							resultSet.getString("DTAPELLIDO2"), resultSet.getString("DTNIF"),
							resultSet.getString("DTTECOEM"), resultSet.getString("DTNRTEL"),
							resultSet.getString("DTNOMBRE_PROVINCIA"), resultSet.getString("DTNOMBRE_MUNICIPIO"),
							resultSet.getString("DTNOMBRE_LOCALIDAD"), resultSet.getString("DTEXTRANJERO"),
							resultSet.getString("DTNOMBRE_PAIS"), resultSet.getString("DTDIRECCION_NOCAPV"),
							resultSet.getString("HDCOES"), resultSet.getString("ESNOMBRE"),
							resultSet.getString("ESNIF"), resultSet.getString("ESNOCO"), resultSet.getString("ESCOEM"),
							resultSet.getString("ESNRTEL"), resultSet.getString("ESINADAR"),
							resultSet.getString("ESNOMBRE_PROVINCIA"), resultSet.getString("ESNOMBRE_MUNICIPIO"),
							resultSet.getString("ESNOMBRE_LOCALIDAD"), resultSet.getString("ESEXTRANJERO"),
							resultSet.getString("ESNOMBRE_PAIS"), resultSet.getString("ESDIRECCION_NOCAPV"),
							resultSet.getString("SECODIGO"), resultSet.getString("SENOMBRE"),
							resultSet.getString("SENOMBREE"), resultSet.getString("HDCODIGO"),
							resultSet.getDate("HDFEHD"), null, resultSet.getLong("HDNROR"),
							resultSet.getString("HDINSOMA"), resultSet.getBigDecimal("HDCAPTSO"),
							resultSet.getString("HDTESO"), resultSet.getString("HDCOSC"),
							resultSet.getString("MOCODIGO"), resultSet.getString("MONOMBRE"),
							resultSet.getString("PSCODIGO"), resultSet.getString("PSNOMBRE"),
							resultSet.getString("PSNOMBREE"), resultSet.getString("HDNOPS"),
							resultSet.getString("HDNOMAPS"), resultSet.getString("HDCODIGOBARRAS"),
							resultSet.getString("HDINTERESADO"), resultSet.getString("HDNOMOPS"),
							resultSet.getString("HDNRLOPS"), resultSet.getDate("HDFEDMPS"),
							resultSet.getString("TIRCODIGO"), resultSet.getString("TIRNOMBRE"),
							resultSet.getString("TSRCODIGO"), resultSet.getString("TSRNOMBRE"),
							resultSet.getString("TSRNOMBREE"), null, null, null, resultSet.getString("HCCOOR"),
							resultSet.getDate("HCFEDE"), null, null, null, resultSet.getString("FCODIGO"),
							resultSet.getString("FNOMBRE"), resultSet.getString("FNOMBREE"),
							resultSet.getString("TRCODIGO"), resultSet.getString("TRNOMBRE"),
							resultSet.getString("TRNOMBREE"), resultSet.getString("TRPOSIBLECODIGO"), null, null, null,
							null, resultSet.getDate("HDFECHACIERRE"), resultSet.getString("HDIDIOMA"),
							resultSet.getString("HDNUMREGISTROORIGEN"), resultSet.getDate("HDFECHAREGISTROORIGEN"),
							resultSet.getString("HDFORMAVENTA"), resultSet.getString("FVNOMBRE"),
							resultSet.getString("FVNOMBREE"), null, null, null, resultSet.getString("HCCOTTD"), null,
							resultSet.getString("HDDENUNCIAAACCEMPRESAS"),

							resultSet.getString("DENOMBRETELEMATICO"), resultSet.getString("DEDIRECCIONTELEMATICO"),
							resultSet.getString("HDNOMBRETELEMATICO"), resultSet.getString("HDDIRECCIONTELEMATICO"),
							resultSet.getString("HDTIPODENUNCIANTE"), resultSet.getString("HDIDIOMARECLAMADO"),
							resultSet.getString("HDPARTICIPACIONRECLAMADO"),
							resultSet.getString("HDDESTNOTIFICARECLAMANTE"),
							resultSet.getString("HDDESTNOTIFICARECLAMADO"),
							resultSet.getString("HDIDPARTICIPACIONRECLAMANTE"),
							resultSet.getString("HDIDPARTICIPACIONRECLAMADO"), resultSet.getString("ISSIR"),
							resultSet.getString("ARSOLICITANTE"), resultSet.getString("ARRESUMEN"));

				}
			}, solicitudDetalle.getNumregistroentrada());
		} catch (EmptyResultDataAccessException e) {
			return new SolicitudDetalle();
		}
	}

	/**
	 * Finds a single row in the HechoDenunciado table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @return SolicitudDetalle
	 */
	@Transactional(readOnly = true)
	public SolicitudDetalle findLobTablaTemporal(SolicitudDetalle solicitudDetalle) {
		String query = "SELECT HDCODIGO, HDTE " + "FROM HECHO_DENUNCIADO  " + "WHERE HDCODIGO = ? ";
		return (SolicitudDetalle) this.jdbcTemplate.queryForObject(query, new RowMapper<SolicitudDetalle>() {
			public SolicitudDetalle mapRow(ResultSet resultSet, int rowNum) throws SQLException {
				return new SolicitudDetalle(resultSet.getString("HDCODIGO"), resultSet.getString("HDTE"));
			}
		}, solicitudDetalle.getHdcodigo());
	}

	/**
	 * Finds a single row in the HechoDenunciado table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @return PlantillaSolicitudDetalle
	 */
	@Transactional(readOnly = true)
	public PlantillaSolicitudDetalle findPlantillaSolicitudDetalle(SolicitudDetalle solicitudDetalle) {

		String query = "SELECT t1.DECODIGO DECODIGO, t1.DECOOR DECOOR, t1.DENRAN DENRAN, t1.DENROR DENROR, t1.DEFEDE DEFEDE, t1.DEFERE DEFERE, t2.TFPCODIGO TFPCODIGO, t2.TFPNOMBRE TFPNOMBRE, t2.TFPNOMBREE TFPNOMBREE, "
				+ "t1.DECODT DTCODIGO, t3.NOMBRE || ' ' || t3.APELLIDO1 || ' ' || t3.APELLIDO2 DTNOMBRE, t3.NIF DTNIF, t3.COEM DTTECOEM, t3.NRTEL DTNRTEL, t3.NRTEL2 DTNRTEL2, '' DTNRFAX, "
				+ "t3.NORA_PROVINCIA_ID DTNORAPROVINCIAID, t3.NOMBRE_PROVINCIA DTNOMBREPROVINCIA, t3.NORA_MUNICIPIO_ID DTNORAMUNICIPIOID, t3.NOMBRE_MUNICIPIO DTNOMBREMUNICIPIO, t3.NORA_LOCALIDAD_ID DTNORALOCALIDADID, t3.NOMBRE_LOCALIDAD DTNOMBRELOCALIDAD, "
				+ "t3.NORA_CALLE_ID DTNORACALLEID, t3.NOMBRE_CALLE DTNOMBRECALLE, t3.NORA_CP_ID DTNORACPID, t3.NOMBRE_CP DTNOMBRECP, t3.NORA_PORTAL_ID DTNORAPORTALID, t3.NOMBRE_PORTAL DTNOMBREPORTAL, t3.NOMBRE_PISO DTNOMBREPISO, '' DTNOLO, '' DTNODIR, '' DTNRCOPO, t3.DIRECCION_NOCAPV DTDIRECCION_NOCAPV, t3.DIRECCION_ANTIGUA DTDIRECCION_ANTIGUA, "
				+ "t4.HDCODIGO HDCODIGO, t4.HDFEHD HDFEHD, t4.HDNROR HDNROR, t4.HDCAPTSO HDCAPTSO, t4.HDTESO HDTESO, t4.HDNUMREGISTROENTRADA HDNUMREGISTROENTRADA,"
				+ "t4.HDCOES ESCODIGO, t5.NOMBRE ESNOMBRE, t5.NIF ESNIF, t5.ESNOCO ESNOCO, t5.NRTEL ESNRTEL, t5.NRTEL2 ESNRTEL2, '' ESNRFAX, t5.COEM ESCOEM, "
				+ "t5.NORA_PROVINCIA_ID ESNORAPROVINCIAID, t5.NOMBRE_PROVINCIA ESNOMBREPROVINCIA, t5.NORA_MUNICIPIO_ID ESNORAMUNICIPIOID, t5.NOMBRE_MUNICIPIO ESNOMBREMUNICIPIO, t5.NORA_LOCALIDAD_ID ESNORALOCALIDADID, t5.NOMBRE_LOCALIDAD ESNOMBRELOCALIDAD, "
				+ "t5.NORA_CALLE_ID ESNORACALLEID, t5.NOMBRE_CALLE ESNOMBRECALLE, t5.NORA_CP_ID ESNORACPID, t5.NOMBRE_CP ESNOMBRECP, t5.NORA_PORTAL_ID ESNORAPORTALID, t5.NOMBRE_PORTAL ESNOMBREPORTAL, t5.NOMBRE_PISO ESNOMBREPISO, '' ESNOLO, '' ESNODIR, '' ESNRCOPO, t5.DIRECCION_NOCAPV ESDIRECCION_NOCAPV,  t5.DIRECCION_ANTIGUA ESDIRECCION_ANTIGUA, "
				+ "t6.MOCODIGO MOCODIGO, t6.MONOMBRE MONOMBRE, t7.PSCODIGO PSCODIGO, t7.PSNOMBRE PSNOMBRE, t7.PSNOMBREE PSNOMBREE, t8.TIRCODIGO TIRCODIGO, t8.TIRNOMBRE TIRNOMBRE, t9.TSRCODIGO TSRCODIGO,t9.TSRNOMBRE TSRNOMBRE,t9.TSRNOMBREE TSRNOMBREE, t10.HCFEDE HCFEDE, t11.DENOMBRE DECISIONDENOMBRE, t11.DENOMBREE DECISIONDENOMBREE, t12.COD_ORG CODORG, t12.NOMBRE_ES NOMBREES, t12.NOMBRE_EU NOMBREEU,  t12.TELEFONO TELEFONO, t12.FAX FAX, t12.EMAIL EMAIL, t12.URL URL, t12.NORA_PAIS_ID NORAPAISID, t12.NOMBRE_PAIS NOMBREPAIS, t12.NORA_PROVINCIA_ID NORAPROVINCIAID, t12.NOMBRE_PROVINCIA NOMBREPROVINCIA, t12.NORA_MUNICIPIO_ID NORAMUNICIPIOID, t12.NOMBRE_MUNICIPIO NOMBREMUNICIPIO, t12.NORA_LOCALIDAD_ID NORALOCALIDADID, t12.NOMBRE_LOCALIDAD NOMBRELOCALIDAD, t12.NORA_CALLE_ID NORACALLEID, t12.NOMBRE_CALLE NOMBRECALLE, t12.NORA_CP_ID NORACPID, t12.NOMBRE_CP NOMBRECP, t12.NORA_PORTAL_ID NORAPORTALID, t12.NOMBRE_PORTAL NOMBREPORTAL "
				+ "FROM DENUNCIA t1 ,FORMA_PRESENTACION t2,INTERVINIENTES t3,HECHO_DENUNCIADO t4, INTERVINIENTES t5, CENSO_MONITOR t6, PRODUCTO t7, MOTIVO t8, TIPO_RECLAMACION t9, DECISION_HECHO t10, DECISION t11, ORGANISMO t12 "
				+ "WHERE 1=1 AND t1.DECOTFP= t2.TFPCODIGO(+) AND t4.HDCODIGO= t3.HDCODIGO(+) AND t3.TIPO_INTERVINIENTE(+)='I' AND t1.DECODIGO= t4.HDCODE(+) AND t4.HDCODIGO= t5.HDCODIGO(+) AND t5.TIPO_INTERVINIENTE(+)='D' AND t4.HDCOMO = t6.MOCODIGO(+) AND t4.HDCOPS = t7.PSCODIGO(+) AND t4.HDCOTIR = t8.TIRCODIGO(+) AND t4.HDCOTSR = t9.TSRCODIGO(+) AND t4.HDCODIGO = t10.HCCOHD(+) AND t10.HCCOTTD= t11.DECODIGO(+) AND t10.HCCOOR= t12.COD_ORG(+) AND t4.HDCODIGO= ? ";

		return (PlantillaSolicitudDetalle) this.jdbcTemplate.queryForObject(query,
				new RowMapper<PlantillaSolicitudDetalle>() {
					public PlantillaSolicitudDetalle mapRow(ResultSet resultSet, int rowNum) throws SQLException {
						return new PlantillaSolicitudDetalle(null, resultSet.getString("DECODIGO"),
								resultSet.getString("DECOOR"), resultSet.getBigDecimal("DENRAN"),
								resultSet.getBigDecimal("DENROR"), resultSet.getDate("DEFEDE"),
								resultSet.getDate("DEFERE"), resultSet.getString("TFPCODIGO"),
								resultSet.getString("TFPNOMBRE"), resultSet.getString("TFPNOMBREE"),
								resultSet.getString("MOCODIGO"), resultSet.getString("MONOMBRE"),
								resultSet.getString("CODORG"), resultSet.getString("NOMBREES"),
								resultSet.getString("NOMBREEU"), resultSet.getString("TELEFONO"),
								resultSet.getString("FAX"), resultSet.getString("EMAIL"), resultSet.getString("URL"),
								resultSet.getString("NORAPAISID"), resultSet.getString("NOMBREPAIS"),
								resultSet.getString("NORAPROVINCIAID"), resultSet.getString("NOMBREPROVINCIA"),
								resultSet.getString("NORAMUNICIPIOID"), resultSet.getString("NOMBREMUNICIPIO"),
								resultSet.getString("NORALOCALIDADID"), resultSet.getString("NOMBRELOCALIDAD"),
								resultSet.getString("NORACALLEID"), resultSet.getString("NOMBRECALLE"),
								resultSet.getString("NORACPID"), resultSet.getString("NOMBRECP"),
								resultSet.getString("NORAPORTALID"), resultSet.getString("NOMBREPORTAL"),
								resultSet.getString("DTCODIGO"), resultSet.getString("DTNOMBRE"),
								resultSet.getString("DTNIF"), resultSet.getString("DTTECOEM"),
								resultSet.getString("DTNRTEL"), resultSet.getString("DTNRTEL2"),
								resultSet.getString("DTNRFAX"), resultSet.getString("DTNORAPROVINCIAID"),
								resultSet.getString("DTNOMBREPROVINCIA"), resultSet.getString("DTNORAMUNICIPIOID"),
								resultSet.getString("DTNOMBREMUNICIPIO"), resultSet.getString("DTNORALOCALIDADID"),
								resultSet.getString("DTNOMBRELOCALIDAD"), resultSet.getString("DTNORACALLEID"),
								resultSet.getString("DTNOMBRECALLE"), resultSet.getString("DTNORACPID"),
								resultSet.getString("DTNOMBRECP"), resultSet.getString("DTNORAPORTALID"),
								resultSet.getString("DTNOMBREPORTAL"), resultSet.getString("DTNOMBREPISO"),
								resultSet.getString("DTNOLO"), resultSet.getString("DTNODIR"),
								resultSet.getString("DTNRCOPO"), resultSet.getString("DTDIRECCION_NOCAPV"),
								resultSet.getString("ESCODIGO"), resultSet.getString("ESNOMBRE"),
								resultSet.getString("ESNIF"), resultSet.getString("ESNOCO"),
								resultSet.getString("ESNRTEL"), resultSet.getString("ESNRTEL2"),
								resultSet.getString("ESNRFAX"), resultSet.getString("ESCOEM"),
								resultSet.getString("ESNORAPROVINCIAID"), resultSet.getString("ESNOMBREPROVINCIA"),
								resultSet.getString("ESNORAMUNICIPIOID"), resultSet.getString("ESNOMBREMUNICIPIO"),
								resultSet.getString("ESNORALOCALIDADID"), resultSet.getString("ESNOMBRELOCALIDAD"),
								resultSet.getString("ESNORACALLEID"), resultSet.getString("ESNOMBRECALLE"),
								resultSet.getString("ESNORACPID"), resultSet.getString("ESNOMBRECP"),
								resultSet.getString("ESNORAPORTALID"), resultSet.getString("ESNOMBREPORTAL"),
								resultSet.getString("ESNOMBREPISO"), resultSet.getString("ESNOLO"),
								resultSet.getString("ESNODIR"), resultSet.getString("ESNRCOPO"),
								resultSet.getString("ESDIRECCION_NOCAPV"), resultSet.getString("HDCODIGO"),
								resultSet.getBigDecimal("HDNROR"), resultSet.getDate("HDFEHD"), null,
								resultSet.getBigDecimal("HDCAPTSO"), resultSet.getString("HDTESO"),
								resultSet.getString("HDNUMREGISTROENTRADA"), resultSet.getString("TSRCODIGO"),
								resultSet.getString("TSRNOMBRE"), resultSet.getString("TSRNOMBREE"),
								resultSet.getString("PSCODIGO"), resultSet.getString("PSNOMBRE"),
								resultSet.getString("PSNOMBREE"), resultSet.getString("TIRCODIGO"),
								resultSet.getString("TIRNOMBRE"), resultSet.getDate("HCFEDE"),
								resultSet.getString("DECISIONDENOMBRE"), resultSet.getString("DECISIONDENOMBREE"), null,
								null, null, null);
					}
				}, solicitudDetalle.getHdcodigo());
	}

	/**
	 * Devuelve una lista con la carga de trabajo (expedientes cerrados) de los
	 * monitores de un organismo en el ultimo año.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<CargaTrabajo> findAllExpedientesCerradosOrganismo(CensoMonitor censoMonitor, Pagination pagination) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();

		where.append(
				" where t1.MOCODIGO = t2.HDCOMO and t2.HDCODE= t3.DECODIGO and t3.DEFEDE >= add_months(sysdate,-12) and t3.DEFEDE <= sysdate AND t2.HDCODIGO = t4.HCCOHD ");

		StringBuffer query = new StringBuffer(
				" select t1.MOCODIGO MOCODIGO, t1.MONOMBRE MONOMBRE, (COUNT(*)-COUNT(t2.HDFECHACIERRE)) EXPEDIENTESABIERTOS, COUNT(t2.HDFECHACIERRE) EXPEDIENTESCERRADOS "
						+ "from CENSO_MONITOR t1, HECHO_DENUNCIADO t2, DENUNCIA t3,DECISION_HECHO t4 ");

		where.append(" and t1.MOFECBAJA IS NULL ");
		// En este caso, hay que usar injeccin de parametros en vez de ?, ya
		// que la tarda mucho dependiendo de la cantidad de datos.
		// De 2 minutos a 7 segundos.
		where.append(" and t1.MOCOOR = '" + censoMonitor.getOrganismo().getCodOrg() + "' ");
		where.append(" AND t4.HCCOOR = '" + censoMonitor.getOrganismo().getCodOrg() + "' ");

		where.append(" group by t1.MOCODIGO, t1.MONOMBRE ");

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		} else {
			order.append(" ORDER BY t1.MONOMBRE ");
			query.append(order);
		}

		return (List<CargaTrabajo>) this.jdbcTemplate.query(query.toString(), new RowMapper<CargaTrabajo>() {
			public CargaTrabajo mapRow(ResultSet resultSet, int rowNum) throws SQLException {
				return new CargaTrabajo(resultSet.getString("MOCODIGO"), resultSet.getString("MONOMBRE"),
						resultSet.getBigDecimal("EXPEDIENTESCERRADOS"), resultSet.getBigDecimal("EXPEDIENTESABIERTOS"));
			}
		}, params.toArray());
	}

	/**
	 * Devuelve una lista con la carga de trabajo (expedientes abiertos) de los
	 * monitores de un organismo en el ultimo año.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<CargaTrabajo> findAllExpedientesAbiertosOrganismo(CensoMonitor censoMonitor, Pagination pagination) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();

		where.append(
				" where t1.MOCODIGO = t2.HDCOMO and t2.HDCODE= t3.DECODIGO AND t2.HDFECHACIERRE IS NULL and t3.DEFEDE >= add_months(sysdate,-12) and t3.DEFEDE <= sysdate AND t2.HDCODIGO = t4.HCCOHD ");

		StringBuffer query = new StringBuffer(
				" select t1.MOCODIGO MOCODIGO, t1.MONOMBRE MONOMBRE, count(*) EXPEDIENTESABIERTOS "
						+ "from CENSO_MONITOR t1, HECHO_DENUNCIADO t2, DENUNCIA t3,DECISION_HECHO t4 ");

		where.append(" and t1.MOCOOR = ? ");
		params.add(censoMonitor.getOrganismo().getCodOrg());

		where.append(" and t1.MOFECBAJA IS NULL ");

		where.append(" AND t4.HCCOOR = ? ");
		params.add(censoMonitor.getOrganismo().getCodOrg());

		where.append(" group by t1.MOCODIGO, t1.MONOMBRE ");

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		} else {
			order.append(" ORDER BY t1.MONOMBRE ");
			query.append(order);
		}

		return (List<CargaTrabajo>) this.jdbcTemplate.query(query.toString(), new RowMapper<CargaTrabajo>() {
			public CargaTrabajo mapRow(ResultSet resultSet, int rowNum) throws SQLException {
				return new CargaTrabajo(resultSet.getString("MOCODIGO"), resultSet.getString("MONOMBRE"),
						new BigDecimal(0), resultSet.getBigDecimal("EXPEDIENTESABIERTOS"));
			}
		}, params.toArray());
	}

	/**
	 * Inserts a single row in the HechoDenunciaDescriptor table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @return SolicitudDetalle
	 */
	public SolicitudDetalle addHechoDenunciadoDescriptor(SolicitudDetalle solicitudDetalle) {
		String query = "INSERT INTO HECHODENUNCIA_DESCRIPTOR " + "( HDCODIGO,ID_DESCRIPTOR) " + " values (?, ?)";

		List<Descriptor> descriptorAux = solicitudDetalle.getDescriptores();
		Iterator<Descriptor> it = descriptorAux.iterator();
		while (it.hasNext()) {
			Descriptor descriptor = (Descriptor) it.next();
			this.jdbcTemplate.update(query, solicitudDetalle.getHdcodigo(), descriptor.getIdDescriptor());
		}
		return solicitudDetalle;
	}

	/**
	 * Deletes a single row in the HechoDenunciaDescriptor table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @return
	 */
	public void removeHechoDenunciadoDescriptor(SolicitudDetalle solicitudDetalle) {
		String query = "DELETE  FROM HECHODENUNCIA_DESCRIPTOR " + " WHERE HDCODIGO=? AND ID_DESCRIPTOR=?";
		List<Descriptor> descriptorAux = solicitudDetalle.getDescriptores();
		Iterator<Descriptor> it = descriptorAux.iterator();
		while (it.hasNext()) {
			Descriptor descriptor = (Descriptor) it.next();
			this.jdbcTemplate.update(query, solicitudDetalle.getHdcodigo(), descriptor.getIdDescriptor());
		}
	}

	/**
	 * Deletes a single row in the HechoDenunciaDescriptor table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 */
	public void removeAllHechoDenunciadoDescriptor(SolicitudDetalle solicitudDetalle) {
		String query = "DELETE  FROM HECHODENUNCIA_DESCRIPTOR " + " WHERE HDCODIGO=? ";
		this.jdbcTemplate.update(query, solicitudDetalle.getHdcodigo());
	}

	/**
	 * Updates a single row in the HechoDenunciaDescriptor table.
	 * 
	 * @param descriptorAEliminar
	 *            Descriptor
	 * @param descriptorBueno
	 *            Descriptor
	 * @return Descriptor
	 */
	public Descriptor updateHechoDenunciadoDescriptor(Descriptor descriptorAEliminar, Descriptor descriptorBueno) {
		String query = "UPDATE HECHODENUNCIA_DESCRIPTOR SET ID_DESCRIPTOR=? WHERE ID_DESCRIPTOR=?";

		this.jdbcTemplate.update(query, descriptorBueno.getIdDescriptor(), descriptorAEliminar.getIdDescriptor());

		return descriptorAEliminar;
	}

	/**
	 * Find a single row in the HechoDenunciaDescriptor Many To Many
	 * relationship.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<SolicitudDetalle> findAllHechosDenunciadosDescriptores(SolicitudDetalle solicitudDetalle,
			Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 ");

		StringBuffer query = new StringBuffer("select t1.HDCODIGO HDCODIGO " + "FROM HECHODENUNCIA_DESCRIPTOR t1 ");

		if (solicitudDetalle != null && solicitudDetalle.getDescriptores() != null
				&& solicitudDetalle.getDescriptores().size() > 0) {

			where.append(" AND ( ");
			boolean firstElement = true;

			for (Descriptor e : solicitudDetalle.getDescriptores()) {

				if (firstElement) {

					where.append("ID_DESCRIPTOR = ?");
					params.add(e.getIdDescriptor());
					firstElement = false;

				} else {

					where.append(" OR ID_DESCRIPTOR = ?");
					params.add(e.getIdDescriptor());
				}
			}

			where.append(") ");
		}

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		}
		return (List<SolicitudDetalle>) this.jdbcTemplate.query(query.toString(), new RowMapper<SolicitudDetalle>() {
			public SolicitudDetalle mapRow(ResultSet resultSet, int rowNum) throws SQLException {
				return new SolicitudDetalle(resultSet.getString("HDCODIGO"), null);
			}
		}, params.toArray());

	}

	/**
	 * Find a single row in the HechoDenunciaDescriptor Many To Many
	 * relationship.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Descriptor> findAllHechoDenunciadoDescriptor(SolicitudDetalle solicitudDetalle, Pagination pagination) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();

		where.append("where t1.ID_DESCRIPTOR = t2.ID_DESCRIPTOR AND t1.HDCODIGO=?");

		params.add(solicitudDetalle.getHdcodigo());

		StringBuffer query = new StringBuffer(
				"SELECT t2.ID_DESCRIPTOR IDDESCRIPTOR, t2.NOMBRE NOMBRE FROM HECHODENUNCIA_DESCRIPTOR t1,DESCRIPTOR t2  ");
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY UPPER(" + pagination.getSort() + ") " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		}
		return (List<Descriptor>) this.jdbcTemplate.query(query.toString(), new RowMapper<Descriptor>() {
			public Descriptor mapRow(ResultSet resultSet, int rowNum) throws SQLException {
				return new Descriptor(resultSet.getString("IDDESCRIPTOR"), resultSet.getString("NOMBRE"));
			}
		}, params.toArray());
	}

	/**
	 * Devuelve una lista con las solicitudes de un organismo.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<SolicitudBusqueda> findAllSolicitudesRelacionar(SolicitudBusqueda solicitudesBusqueda, String hdcodigo,
			String relacionados, Pagination pagination) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();

		where.append(
				" WHERE 1=1   AND t4.HDCODE = t1.DECODIGO AND t4.HDCOMO = t8.MOCODIGO(+) AND t4.HDCODIGO = t9.HCCOHD ");

		StringBuffer query = new StringBuffer(
				"SELECT t1.DECOOR DECOOR, t1.DENRAN DENRAN, t1.DENROR DENROR, t1.DEFEDE DEFEDE,t1.DEFERE DEFERE,t4.HDNROR HDNROR, t4.HDCODIGO HDCODIGO,  t8.MOCODIGO MOCODIGO, t8.MONOMBRE MONOMBRE, T4.HDFEHD  HDFEHD "
						+ "FROM DENUNCIA t1, HECHO_DENUNCIADO t4, CENSO_MONITOR t8, DECISION_HECHO t9 ");

		where.append(" and t4.HDCODIGO <> '").append(hdcodigo).append("'");
		if (!"".equals(relacionados)) {
			String[] arrayValores = relacionados.split(",");
			for (int i = 0; i < arrayValores.length; i++) {
				where.append("AND t4.HDCODIGO <> '").append(arrayValores[i]).append("'");
			}
		}

		// organismo
		if (solicitudesBusqueda != null && solicitudesBusqueda.getDecoor() != null) {
			where.append(" AND UPPER(t1.DECOOR) like ? ESCAPE  '\\'");
			params.add("%" + solicitudesBusqueda.getDecoor().toUpperCase() + "%");
			where.append(" AND t1.DECOOR IS NOT NULL");
		}

		// anyo
		if (solicitudesBusqueda != null && solicitudesBusqueda.getDenran() != null) {
			where.append(" AND t1.DENRAN = ? ");
			params.add(solicitudesBusqueda.getDenran());
		}

		// correlativo
		if (solicitudesBusqueda != null && solicitudesBusqueda.getDenror() != null) {
			where.append(" AND t1.DENROR = ? ");
			params.add(solicitudesBusqueda.getDenror());
		}
		// fecha presentacion desde
		if (solicitudesBusqueda != null && solicitudesBusqueda.getDefedeDesde() != null) {
			where.append(" AND t1.DEFEDE >= ?");
			params.add(solicitudesBusqueda.getDefedeDesde());
		}
		// fecha presentacion hasta
		if (solicitudesBusqueda != null && solicitudesBusqueda.getDefedeHasta() != null) {
			where.append(" AND t1.DEFEDE <= ?");
			params.add(solicitudesBusqueda.getDefedeHasta());
		}

		// fecha hecho desde
		if (solicitudesBusqueda != null && solicitudesBusqueda.getHdfehdDesde() != null) {
			where.append(" AND t4.HDFEHD >= ?");
			params.add(solicitudesBusqueda.getHdfehdDesde());
		}
		// fecha hecho hasta
		if (solicitudesBusqueda != null && solicitudesBusqueda.getHdfehdHasta() != null) {
			where.append(" AND t4.HDFEHD <= ?");
			params.add(solicitudesBusqueda.getHdfehdHasta());
		}

		// Decision
		if (solicitudesBusqueda != null && solicitudesBusqueda.getDecodigo() != null) {
			where.append(" AND t9.HCCOTTD = ? ");
			params.add(solicitudesBusqueda.getDecodigo());
		}

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		}

		return (List<SolicitudBusqueda>) this.jdbcTemplate.query(query.toString(), new RowMapper<SolicitudBusqueda>() {
			public SolicitudBusqueda mapRow(ResultSet resultSet, int rowNum) throws SQLException {
				return new SolicitudBusqueda(resultSet.getString("HDCODIGO"), resultSet.getString("DECOOR"),
						resultSet.getBigDecimal("DENRAN"), resultSet.getBigDecimal("DENROR"),
						resultSet.getBigDecimal("HDNROR"), null, null, null, resultSet.getString("MOCODIGO"),
						resultSet.getString("MONOMBRE"), resultSet.getDate("DEFEDE"), null, null, null,
						resultSet.getDate("DEFERE"), null, null, null, null, null, null, null, null, null, null, null,
						null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
						null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
						null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
						null, null, null, null, null, null, null, null, null, resultSet.getDate("HDFEHD"));
			}
		}, params.toArray());
	}

	/**
	 * Counts rows in the HechoDenunciado table.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCountSolicitudesRelacionar(SolicitudBusqueda solicitudesBusqueda, String hdcodigo,
			String relacionados) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(
				" WHERE 1=1   AND t4.HDCODE = t1.DECODIGO AND t4.HDCOMO = t8.MOCODIGO(+) AND t4.HDCODIGO = t9.HCCOHD ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(t4.HDCODIGO) FROM DENUNCIA t1, HECHO_DENUNCIADO t4, CENSO_MONITOR t8, DECISION_HECHO t9 ");

		where.append(" and t4.HDCODIGO <> '").append(hdcodigo).append("'");
		if (!"".equals(relacionados)) {
			String[] arrayValores = relacionados.split(",");
			for (int i = 0; i < arrayValores.length; i++) {
				where.append("AND t4.HDCODIGO <> '").append(arrayValores[i]).append("'");
			}
		}
		// organismo
		if (solicitudesBusqueda != null && solicitudesBusqueda.getDecoor() != null) {
			where.append(" AND UPPER(t1.DECOOR) like ? ESCAPE  '\\'");
			params.add("%" + solicitudesBusqueda.getDecoor().toUpperCase() + "%");
			where.append(" AND t1.DECOOR IS NOT NULL");
		}

		// anyo
		if (solicitudesBusqueda != null && solicitudesBusqueda.getDenran() != null) {
			where.append(" AND t1.DENRAN = ? ");
			params.add(solicitudesBusqueda.getDenran());
		}

		// correlativo
		if (solicitudesBusqueda != null && solicitudesBusqueda.getDenror() != null) {
			where.append(" AND t1.DENROR = ? ");
			params.add(solicitudesBusqueda.getDenror());
		}
		// fecha presentacion desde
		if (solicitudesBusqueda != null && solicitudesBusqueda.getDefedeDesde() != null) {
			where.append(" AND t1.DEFEDE >= ?");
			params.add(solicitudesBusqueda.getDefedeDesde());
		}
		// fecha presentacion hasta
		if (solicitudesBusqueda != null && solicitudesBusqueda.getDefedeHasta() != null) {
			where.append(" AND t1.DEFEDE <= ?");
			params.add(solicitudesBusqueda.getDefedeHasta());
		}

		// Decision
		if (solicitudesBusqueda != null && solicitudesBusqueda.getDecodigo() != null) {
			where.append(" AND t9.HCCOTTD = ? ");
			params.add(solicitudesBusqueda.getDecodigo());
		}

		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Devuelve una lista con las posibles solicitudes a relacionar con una
	 * sanción.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<SolicitudBusqueda> findAllSolicitudesRelacionarNuevaSancion(SolicitudBusqueda solicitudesBusqueda,
			String hdcodigo, String relacionados, Pagination pagination) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();

		where.append(
				" WHERE 1=1   AND t4.HDCODE = t1.DECODIGO AND t4.HDCOMO = t8.MOCODIGO(+) AND t4.HDCODIGO = t9.HCCOHD AND t4.HDCOES= t3.ESCODIGO(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT distinct t1.DECOOR DECOOR, t1.DENRAN DENRAN, t1.DENROR DENROR, t1.DEFEDE DEFEDE,t1.DEFERE DEFERE,t4.HDNROR HDNROR, t4.HDCODIGO HDCODIGO,  t8.MOCODIGO MOCODIGO, t8.MONOMBRE MONOMBRE, t4.HDFEHD HDFEHD "
						+ "FROM DENUNCIA t1, HECHO_DENUNCIADO t4, CENSO_MONITOR t8, DECISION_HECHO t9, ESTABLECIMIENTO t3 ");

		where.append(" and t4.HDCODIGO <> '").append(hdcodigo).append("'");
		if (!"".equals(relacionados)) {
			String[] arrayValores = relacionados.split(",");
			for (int i = 0; i < arrayValores.length; i++) {
				where.append("AND t4.HDCODIGO <> '").append(arrayValores[i]).append("'");
			}
		}

		// organismo
		if (solicitudesBusqueda != null && solicitudesBusqueda.getDecoor() != null) {
			where.append(" AND UPPER(t1.DECOOR) like ? ESCAPE  '\\'");
			params.add("%" + solicitudesBusqueda.getDecoor().toUpperCase() + "%");
			where.append(" AND t1.DECOOR IS NOT NULL");
		}

		// anyo
		if (solicitudesBusqueda != null && solicitudesBusqueda.getDenran() != null) {
			where.append(" AND t1.DENRAN = ? ");
			params.add(solicitudesBusqueda.getDenran());
		}

		// correlativo
		if (solicitudesBusqueda != null && solicitudesBusqueda.getDenror() != null) {
			where.append(" AND t1.DENROR = ? ");
			params.add(solicitudesBusqueda.getDenror());
		}
		// fecha presentacion desde
		if (solicitudesBusqueda != null && solicitudesBusqueda.getDefedeDesde() != null) {
			where.append(" AND t1.DEFEDE >= ?");
			params.add(solicitudesBusqueda.getDefedeDesde());
		}
		// fecha presentacion hasta
		if (solicitudesBusqueda != null && solicitudesBusqueda.getDefedeHasta() != null) {
			where.append(" AND t1.DEFEDE <= ?");
			params.add(solicitudesBusqueda.getDefedeHasta());
		}

		// fecha hecho desde
		if (solicitudesBusqueda != null && solicitudesBusqueda.getHdfehdDesde() != null) {
			where.append(" AND t4.HDFEHD >= ?");
			params.add(solicitudesBusqueda.getHdfehdDesde());
		}
		// fecha hecho hasta
		if (solicitudesBusqueda != null && solicitudesBusqueda.getHdfehdHasta() != null) {
			where.append(" AND t4.HDFEHD <= ?");
			params.add(solicitudesBusqueda.getHdfehdHasta());
		}
		//
		// Decision
		// se quita esta restriccion a peticin de Carlos el 19/05/2015
		// where.append(" AND t9.HCCOTTD IN (?,?,?) ");
		// params.add(Y41bConstantes.DECISION_PROPUESTA_SAN_DENUNCIA);
		// params.add(Y41bConstantes.DECISION_PROPUESTA_SAN_QUEJA);
		// params.add(Y41bConstantes.DECISION_PROPUESTA_SAN_RECLAMACION);

		// NIF Sancionado para acumulacion desde la ficha del sancionador
		if (solicitudesBusqueda != null && !Y41bUtils.esNullOCadenaVacia(solicitudesBusqueda.getEsnif())) {
			where.append(" AND t3.ESNIF = ?");
			params.add(solicitudesBusqueda.getEsnif());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		}

		return (List<SolicitudBusqueda>) this.jdbcTemplate.query(query.toString(), new RowMapper<SolicitudBusqueda>() {
			public SolicitudBusqueda mapRow(ResultSet resultSet, int rowNum) throws SQLException {
				return new SolicitudBusqueda(resultSet.getString("HDCODIGO"), resultSet.getString("DECOOR"),
						resultSet.getBigDecimal("DENRAN"), resultSet.getBigDecimal("DENROR"),
						resultSet.getBigDecimal("HDNROR"), null, null, null, resultSet.getString("MOCODIGO"),
						resultSet.getString("MONOMBRE"), resultSet.getDate("DEFEDE"), null, null, null,
						resultSet.getDate("DEFERE"), null, null, null, null, null, null, null, null, null, null, null,
						null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
						null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
						null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
						null, null, null, null, null, null, null, null, null, resultSet.getDate("HDFEHD"));
			}
		}, params.toArray());
	}

	/**
	 * Counts rows in the SolicitudBusqueda table.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCountSolicitudesRelacionarNuevaSancion(SolicitudBusqueda solicitudesBusqueda, String hdcodigo,
			String relacionados) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(
				" WHERE 1=1   AND t4.HDCODE = t1.DECODIGO AND t4.HDCOMO = t8.MOCODIGO(+) AND t4.HDCODIGO = t9.HCCOHD AND t4.HDCOES= t3.ESCODIGO(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(distinct t4.HDCODIGO) FROM DENUNCIA t1, HECHO_DENUNCIADO t4, CENSO_MONITOR t8, DECISION_HECHO t9, ESTABLECIMIENTO t3  ");

		where.append(" and t4.HDCODIGO <> '").append(hdcodigo).append("'");
		if (!"".equals(relacionados)) {
			String[] arrayValores = relacionados.split(",");
			for (int i = 0; i < arrayValores.length; i++) {
				where.append("AND t4.HDCODIGO <> '").append(arrayValores[i]).append("'");
			}
		}
		// organismo
		if (solicitudesBusqueda != null && solicitudesBusqueda.getDecoor() != null) {
			where.append(" AND UPPER(t1.DECOOR) like ? ESCAPE  '\\'");
			params.add("%" + solicitudesBusqueda.getDecoor().toUpperCase() + "%");
			where.append(" AND t1.DECOOR IS NOT NULL");
		}

		// anyo
		if (solicitudesBusqueda != null && solicitudesBusqueda.getDenran() != null) {
			where.append(" AND t1.DENRAN = ? ");
			params.add(solicitudesBusqueda.getDenran());
		}

		// correlativo
		if (solicitudesBusqueda != null && solicitudesBusqueda.getDenror() != null) {
			where.append(" AND t1.DENROR = ? ");
			params.add(solicitudesBusqueda.getDenror());
		}
		// fecha presentacion desde
		if (solicitudesBusqueda != null && solicitudesBusqueda.getDefedeDesde() != null) {
			where.append(" AND t1.DEFEDE >= ?");
			params.add(solicitudesBusqueda.getDefedeDesde());
		}
		// fecha presentacion hasta
		if (solicitudesBusqueda != null && solicitudesBusqueda.getDefedeHasta() != null) {
			where.append(" AND t1.DEFEDE <= ?");
			params.add(solicitudesBusqueda.getDefedeHasta());
		}

		// Decision
		// se quita esta restriccion a peticin de Carlos el 19/05/2015
		// where.append(" AND t9.HCCOTTD IN (?,?,?) ");
		// params.add(Y41bConstantes.DECISION_PROPUESTA_SAN_DENUNCIA);
		// params.add(Y41bConstantes.DECISION_PROPUESTA_SAN_QUEJA);
		// params.add(Y41bConstantes.DECISION_PROPUESTA_SAN_RECLAMACION);

		// NIF Sancionado para acumulacion desde la ficha del sancionador
		if (solicitudesBusqueda != null && !Y41bUtils.esNullOCadenaVacia(solicitudesBusqueda.getEsnif())) {
			where.append(" AND t3.ESNIF = ?");
			params.add(solicitudesBusqueda.getEsnif());
		}

		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	public Long findAllLikeSolicitudesReclamanteArbitraje(SolicitudBusqueda solicitudesBusqueda, Boolean startsWith) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(
				" WHERE 1=1  AND t1.DECODIGO= t4.HDCODE AND t1.DECODT= tt3CONSUMIDOR.DTCODIGO(+) AND t4.HDCODIGO= t3CONSUMIDOR.HDCODIGO(+) AND t3CONSUMIDOR.TIPO_INTERVINIENTE(+)='I' AND t4.HDCOES= tt7ESTABLECIMIENTO.ESCODIGO(+) AND t4.HDCODIGO= t7ESTABLECIMIENTO.HDCODIGO(+) AND t7ESTABLECIMIENTO.TIPO_INTERVINIENTE(+)='D' AND t4.FCODIGOACTUAL = t5.FCODIGO(+) AND t4.TRCODIGOACTUAL = t6.TRCODIGO(+) AND t4.HDCOMO = t8.MOCODIGO(+) AND t4.HDCODIGO = t9.HCCOHD AND t9.HCCOTTD=t14.DECODIGO(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(t4.HDCODIGO) FROM DENUNCIA t1,INTERVINIENTES t3CONSUMIDOR, CONSUMIDOR tt3CONSUMIDOR, HECHO_DENUNCIADO t4, INTERVINIENTES t7ESTABLECIMIENTO, ESTABLECIMIENTO tt7ESTABLECIMIENTO, FASE t5, TRAMITE t6, CENSO_MONITOR t8,DECISION_HECHO t9, DECISION t14 ");

		// Tipo solicitud
		if (solicitudesBusqueda != null && solicitudesBusqueda.getHdcosc() != null) {
			where.append(" AND t4.HDCOSC = ? ");
			params.add(solicitudesBusqueda.getHdcosc());
		}

		// fecha presentacion desde
		if (solicitudesBusqueda != null && solicitudesBusqueda.getDefedeDesde() != null) {
			where.append(" AND t1.DEFEDE >= ?");
			params.add(solicitudesBusqueda.getDefedeDesde());
		}
		// fecha presentacion hasta
		if (solicitudesBusqueda != null && solicitudesBusqueda.getDefedeHasta() != null) {
			where.append(" AND t1.DEFEDE <= ?");
			params.add(solicitudesBusqueda.getDefedeHasta());
		}

		// Dni persona consumidora
		if (solicitudesBusqueda != null && solicitudesBusqueda.getDtcodigo() != null) {
			where.append(" AND ((UPPER(t3CONSUMIDOR.DTCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudesBusqueda.getDtcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudesBusqueda.getDtcodigo().toUpperCase() + "%");
			}
			where.append(" AND t3CONSUMIDOR.DTCODIGO IS NOT NULL AND t4.FCODIGOACTUAL IS NOT NULL) ");

			where.append(" OR (UPPER(tt3CONSUMIDOR.DTCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudesBusqueda.getDtcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudesBusqueda.getDtcodigo().toUpperCase() + "%");
			}
			where.append(" AND tt3CONSUMIDOR.DTCODIGO IS NOT NULL AND t4.FCODIGOACTUAL IS NULL)) ");
		}

		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds a single row in the HechoDenunciado table.
	 * 
	 * @param hechodenunciado
	 *            HechoDenunciado
	 * @return HechoDenunciado
	 */
	@Transactional(readOnly = true)
	public HechoDenunciado findUltimoTramite(HechoDenunciado hechodenunciado) {

		String query = "SELECT t1.HDCODIGO HDCODIGO, t1.TRCODIGOACTUAL TRCODIGOACTUAL, t1.TRPOSIBLECODIGO TRPOSIBLECODIGO "
				+ "FROM HECHO_DENUNCIADO t1 " + "WHERE t1.HDCODIGO = ?";
		return (HechoDenunciado) this.jdbcTemplate.queryForObject(query, new RowMapper<HechoDenunciado>() {
			public HechoDenunciado mapRow(ResultSet resultSet, int rowNum) throws SQLException {

				HechoDenunciado hecDen = new HechoDenunciado();
				hecDen.setHdcodigo(resultSet.getString("HDCODIGO"));
				hecDen.setTrcodigoactual(resultSet.getString("TRCODIGOACTUAL"));
				hecDen.setTrposiblecodigo(resultSet.getString("TRPOSIBLECODIGO"));

				return hecDen;
			}
		}, hechodenunciado.getHdcodigo());
	}

	/**
	 * Updates a single row in the HechoDenunciado table.
	 * 
	 * @param hechodenunciado
	 *            HechoDenunciado
	 * @return HechoDenunciado
	 */
	public HechoDenunciado updateParticipacionReclamado(HechoDenunciado hechodenunciado) {
		String query = "UPDATE HECHO_DENUNCIADO SET HDPARTICIPACIONRECLAMADO=? WHERE HDCODIGO=?";

		this.jdbcTemplate.update(query, hechodenunciado.getHdparticipacionreclamado(), hechodenunciado.getHdcodigo());

		return hechodenunciado;
	}
}
