package com.ejie.y41b.dao;

import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.BusquedaCombinada;
import com.ejie.y41b.model.CargaTrabajo;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.ConsumidorReclamaciones;
import com.ejie.y41b.model.Descriptor;
import com.ejie.y41b.model.EstablecimientoDecisionAnyo;
import com.ejie.y41b.model.EstablecimientoReclamacionesAnyo;
import com.ejie.y41b.model.HechoDenunciado;
import com.ejie.y41b.model.Intervinientes;
import com.ejie.y41b.model.PlantillaSolicitudDetalle;
import com.ejie.y41b.model.SolicitudBusqueda;
import com.ejie.y41b.model.SolicitudDetalle;
import com.ejie.y41b.model.TramiteHechoDetalle;

/**
 * * HechoDenunciadoDao  
 * 
 *  
 */

public interface HechoDenunciadoDao {

	/**
	 * Inserts a single row in the HechoDenunciado table.
	 * 
	 * @param hechodenunciado
	 *            HechoDenunciado
	 * @return HechoDenunciado
	 */
	HechoDenunciado add(HechoDenunciado hechodenunciado);

	/**
	 * Inserts a single row in the HechoDenunciado table.
	 * 
	 * @param hechodenunciado
	 *            Pagination
	 * @return HechoDenunciado
	 */
	HechoDenunciado addHechoDenunciado(HechoDenunciado hechodenunciado);

	/**
	 * Inserts a single row in the Denuncia table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 */
	public void enviarHechoDenunciadoTelematico(SolicitudDetalle solicitudDetalle);

	/**
	 * Removes a single row in the Denuncia table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @return
	 */
	public void removeHechoDenunciadoTelematico(SolicitudDetalle solicitudDetalle);

	/**
	 * Finds a single row in the HechoDenunciado table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @return SolicitudDetalle
	 */
	public SolicitudDetalle findLobTablaTemporalTelematica(SolicitudDetalle solicitudDetalle);

	/**
	 * Updates a single row in the HechoDenunciado table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @return SolicitudDetalle
	 */
	public SolicitudDetalle updateHDTE(SolicitudDetalle solicitudDetalle);

	/**
	 * Updates a single row in the HechoDenunciado table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @return SolicitudDetalle
	 */
	public SolicitudDetalle updateFechaCierre(SolicitudDetalle solicitudDetalle);

	/**
	 * Updates a single row in the HechoDenunciado table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @return SolicitudDetalle
	 */
	public SolicitudDetalle updateFechaCierreReabrirExpediente(SolicitudDetalle solicitudDetalle);

	/**
	 * Updates a single row in the HechoDenunciado table.
	 * 
	 * @param hechodenunciado
	 *            HechoDenunciado
	 * @return HechoDenunciado
	 */
	HechoDenunciado update(HechoDenunciado hechodenunciado);

	/**
	 * Updates a single row in the HechoDenunciado table.
	 * 
	 * @param hechodenunciado
	 *            Pagination
	 * @return HechoDenunciado
	 */
	HechoDenunciado updateEstablecimiento(HechoDenunciado hechodenunciado);

	/**
	 * Updates a single row in the HechoDenunciado table.
	 * 
	 * @param hechodenunciado
	 *            Pagination
	 * @return HechoDenunciado
	 */
	HechoDenunciado updateIndicadorArbitraje(HechoDenunciado hechodenunciado);

	/**
	 * Updates a single row in the HechoDenunciado table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @return SolicitudDetalle
	 */
	public SolicitudDetalle updateDenunciaAACC(SolicitudDetalle solicitudDetalle);

	/**
	 * Updates a single row in the HechoDenunciado table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @return SolicitudDetalle
	 */
	public SolicitudDetalle updateDenunciaAACCEnSolicitud(SolicitudDetalle solicitudDetalle);

	/**
	 * Updates a single row in the HechoDenunciado table.
	 * 
	 * @param hechodenunciado
	 *            Pagination
	 * @return HechoDenunciado
	 */
	public HechoDenunciado updateNumregistroEntrada(HechoDenunciado hechodenunciado);

	/**
	 * Updates a single row in the HechoDenunciado table.
	 * 
	 * @param hechodenunciado
	 *            Pagination
	 * @return HechoDenunciado
	 */
	public HechoDenunciado updateTramiteCambioInstructor(HechoDenunciado hechodenunciado);

	/**
	 * Updates a single row in the HechoDenunciado table.
	 * 
	 * @param hechodenunciado
	 *            Pagination
	 * @return HechoDenunciado
	 */
	public HechoDenunciado updateInstructor(HechoDenunciado hechodenunciado);

	/**
	 * Updates a single row in the HechoDenunciado table.
	 * 
	 * @param hechodenunciado
	 *            Pagination
	 * @return HechoDenunciado
	 */
	public HechoDenunciado updateUltimoTramiteConFase(HechoDenunciado hechodenunciado);

	/**
	 * Updates a single row in the HechoDenunciado table.
	 * 
	 * @param hechodenunciado
	 *            Pagination
	 * @return HechoDenunciado
	 */
	public HechoDenunciado updateUltimoTramiteGenerico(HechoDenunciado hechodenunciado);

	/**
	 * Updates a single row in the HechoDenunciado table.
	 * 
	 * @param hechodenunciado
	 *            Pagination
	 * @return HechoDenunciado
	 */
	public HechoDenunciado updateUltimoTramiteConFaseGenerico(HechoDenunciado hechodenunciado);

	/**
	 * Updates a single row in the HechoDenunciado table.
	 * 
	 * @param hechodenunciado
	 *            Pagination
	 * @return HechoDenunciado
	 */
	public HechoDenunciado updateTramitacionTramitePosible(HechoDenunciado hechodenunciado);

	/**
	 * Updates a single row in the HechoDenunciado table.
	 * 
	 * @param hechodenunciado
	 *            Pagination
	 * @return HechoDenunciado
	 */
	public HechoDenunciado updateFormaNotificacion(HechoDenunciado hechodenunciado);

	/**
	 * Updates a single row in the HechoDenunciado table.
	 * 
	 * @param hechodenunciado
	 *            Pagination
	 * @return HechoDenunciado
	 */
	public HechoDenunciado updateIdiomaReclamante(HechoDenunciado hechodenunciado);

	/**
	 * Updates a single row in the HechoDenunciado table.
	 * 
	 * @param hechodenunciado
	 *            Pagination
	 * @return HechoDenunciado
	 */
	public HechoDenunciado updateIdiomaReclamado(HechoDenunciado hechodenunciado);

	/**
	 * Updates a single row in the HechoDenunciado table.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @return Intervinientes
	 */
	public Intervinientes updateHDIDPARTICIPACIONRECLAMANTE(Intervinientes intervinientes);

	/**
	 * Updates a single row in the HechoDenunciado table.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @return Intervinientes
	 */
	public Intervinientes updateHDIDPARTICIPACIONRECLAMADO(Intervinientes intervinientes);

	/**
	 * Finds a single row in the HechoDenunciado table.
	 * 
	 * @param hechodenunciado
	 *            HechoDenunciado
	 * @return HechoDenunciado
	 */
	HechoDenunciado find(HechoDenunciado hechodenunciado);

	/**
	 * Finds a single row in the HechoDenunciado table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @return SolicitudDetalle
	 */
	SolicitudDetalle findSolicitud(SolicitudDetalle solicitudDetalle);

	/**
	 * Finds a single row in the HechoDenunciado table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @return SolicitudDetalle
	 */
	public SolicitudDetalle findSolicitudByNumeroExpediente(SolicitudDetalle solicitudDetalle);

	/**
	 * Finds a single row in the HechoDenunciado table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @return SolicitudDetalle
	 */
	public SolicitudDetalle findSolicitudByRegistryNumber(SolicitudDetalle solicitudDetalle);

	/**
	 * Deletes a single row in the HechoDenunciado table.
	 * 
	 * @param hechodenunciado
	 *            HechoDenunciado
	 * @return
	 */
	void remove(HechoDenunciado hechodenunciado);

	/**
	 * Finds a List of rows in the HechoDenunciado table.
	 * 
	 * @param hechodenunciado
	 *            HechoDenunciado
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<HechoDenunciado> findAllHechosEstablecimiento(HechoDenunciado hechodenunciado, Pagination pagination);

	/**
	 * Finds a List of rows in the HechoDenunciado table.
	 * 
	 * @param hechodenunciado
	 *            HechoDenunciado
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<HechoDenunciado> findAll(HechoDenunciado hechodenunciado, Pagination pagination);

	/**
	 * Counts rows in the HechoDenunciado table.
	 * 
	 * @param hechodenunciado
	 *            HechoDenunciado
	 * @return List
	 */
	Long findAllCount(HechoDenunciado hechodenunciado);

	/**
	 * Counts rows in the HechoDenunciado table.
	 * 
	 * @param hechodenunciado
	 *            HechoDenunciado
	 * @return List
	 */
	Long findAllExpedientesAbiertosCount(HechoDenunciado hechodenunciado);

	/**
	 * Finds rows in the HechoDenunciado table using like.
	 * 
	 * @param hechodenunciado
	 *            HechoDenunciado
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<HechoDenunciado> findAllLike(HechoDenunciado hechodenunciado, Pagination pagination, Boolean startsWith);

	/**
	 * Devuelve una lista con el numero de reclamaciones de un establecimiento
	 * por año.
	 * 
	 * @param hechodenunciado
	 *            HechoDenunciado
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<EstablecimientoReclamacionesAnyo> findAllEstablecimientoReclamacionesAnyo(HechoDenunciado hechodenunciado,
			Pagination pagination);

	/**
	 * Counts rows in the HechoDenunciado table.
	 * 
	 * @param hechodenunciado
	 *            HechoDenunciado
	 * @return Long
	 */
	Long findAllEstablecimientoReclamacionesAnyoCount(HechoDenunciado hechodenunciado);

	/**
	 * Devuelve una lista con el numero de reclamaciones de un establecimiento
	 * por decision y por año.
	 * 
	 * @param hechodenunciado
	 *            HechoDenunciado
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<EstablecimientoDecisionAnyo> findAllEstablecimientoDecisionAnyo(HechoDenunciado hechodenunciado,
			Pagination pagination);

	/**
	 * Counts rows in the HechoDenunciado table.
	 * 
	 * @param hechodenunciado
	 *            HechoDenunciado
	 * @return Long
	 */
	Long findAllEstablecimientoDecisionAnyoCount(HechoDenunciado hechodenunciado);

	/**
	 * Devuelve una lista con las reclamaciones de un consumidor.
	 * 
	 * @param hechodenunciado
	 *            HechoDenunciado
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<ConsumidorReclamaciones> findAllConsumidorReclamaciones(HechoDenunciado hechodenunciado,
			Pagination pagination);

	/**
	 * Counts rows in the HechoDenunciado table.
	 * 
	 * @param hechodenunciado
	 *            HechoDenunciado
	 * @return Long
	 */
	Long findAllConsumidorReclamacionesCount(HechoDenunciado hechodenunciado);

	/**
	 * Devuelve una lista con las solicitudes de un organismo.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<SolicitudBusqueda> findAllLikeSolicitudes(SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the HechoDenunciado table.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeSolicitudesCount(SolicitudBusqueda solicitudesBusqueda, Boolean startsWith);

	/**
	 * Devuelve una lista con las solicitudes de un organismo.
	 * 
	 * @param busquedaCombinada
	 *            BusquedaCombinada
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<SolicitudBusqueda> findAllLikeSolicitudesBusquedaCombinada(BusquedaCombinada busquedaCombinada,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the HechoDenunciado table.
	 * 
	 * @param busquedaCombinada
	 *            BusquedaCombinada
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeSolicitudesBusquedaCombinadaCount(BusquedaCombinada busquedaCombinada, Boolean startsWith);

	/**
	 * Devuelve una lista con las solicitudes de un organismo.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<SolicitudBusqueda> findAllSolicitudesAbiertasInstructor(SolicitudBusqueda solicitudesBusqueda,
			Pagination pagination);

	/**
	 * Counts rows in the HechoDenunciado table.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @return Long
	 */
	public Long findAllSolicitudesAbiertasInstructorCount(SolicitudBusqueda solicitudesBusqueda);

	/**
	 * Finds a single row in the Tramite Hecho table.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @return TramiteHechoDetalle
	 */
	TramiteHechoDetalle findUltimoTramite(SolicitudBusqueda solicitudesBusqueda);

	/**
	 * Finds a single row in the HechoDenunciado table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @return PlantillaSolicitudDetalle
	 */
	PlantillaSolicitudDetalle findPlantillaSolicitudDetalle(SolicitudDetalle solicitudDetalle);

	/**
	 * Finds a single row in the HechoDenunciado table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @return SolicitudDetalle
	 */
	SolicitudDetalle findLobTablaTemporal(SolicitudDetalle solicitudDetalle);

	/**
	 * Devuelve una lista con la carga de trabajo (expedientes cerrados) de los
	 * monitores de un organismo en el ultimo año.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<CargaTrabajo> findAllExpedientesCerradosOrganismo(CensoMonitor censoMonitor, Pagination pagination);

	/**
	 * Devuelve una lista con la carga de trabajo (expedientes abiertos) de los
	 * monitores de un organismo en el ultimo año.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<CargaTrabajo> findAllExpedientesAbiertosOrganismo(CensoMonitor censoMonitor, Pagination pagination);

	/**
	 * Inserts a single row in the HechoDenunciaDescriptor table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @return SolicitudDetalle
	 */
	public SolicitudDetalle addHechoDenunciadoDescriptor(SolicitudDetalle solicitudDetalle);

	/**
	 * Deletes a single row in the HechoDenunciaDescriptor table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @return
	 */
	public void removeHechoDenunciadoDescriptor(SolicitudDetalle solicitudDetalle);

	/**
	 * Deletes a single row in the HechoDenunciaDescriptor table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 */
	public void removeAllHechoDenunciadoDescriptor(SolicitudDetalle solicitudDetalle);

	/**
	 * Updates a single row in the HechoDenunciaDescriptor table.
	 * 
	 * @param descriptorAEliminar
	 *            Descriptor
	 * @param descriptorBueno
	 *            Descriptor
	 * @return Descriptor
	 */
	public Descriptor updateHechoDenunciadoDescriptor(Descriptor descriptorAEliminar, Descriptor descriptorBueno);

	/**
	 * Find a single row in the HechoDenunciaDescriptor Many To Many
	 * relationship.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<SolicitudDetalle> findAllHechosDenunciadosDescriptores(SolicitudDetalle solicitudDetalle,
			Pagination pagination);

	/**
	 * Find a single row in the HechoDenunciaDescriptor Many To Many
	 * relationship.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Descriptor> findAllHechoDenunciadoDescriptor(SolicitudDetalle solicitudDetalle, Pagination pagination);

	/**
	 * Devuelve una lista con las solicitudes de un organismo.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param hdcodigo
	 *            String
	 * @param relacionados
	 *            String
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<SolicitudBusqueda> findAllSolicitudesRelacionar(SolicitudBusqueda solicitudesBusqueda, String hdcodigo,
			String relacionados, Pagination pagination);

	/**
	 * Counts rows in the HechoDenunciado table.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param hdcodigo
	 *            String
	 * @param relacionados
	 *            String
	 * @return Long
	 */
	public Long findAllCountSolicitudesRelacionar(SolicitudBusqueda solicitudesBusqueda, String hdcodigo,
			String relacionados);

	/**
	 * Devuelve una lista con las posibles solicitudes a relacionar con una
	 * sanción.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param hdcodigo
	 *            String
	 * @param relacionados
	 *            String
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<SolicitudBusqueda> findAllSolicitudesRelacionarNuevaSancion(SolicitudBusqueda solicitudesBusqueda,
			String hdcodigo, String relacionados, Pagination pagination);

	/**
	 * Counts rows in the SolicitudBusqueda table.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param hdcodigo
	 *            String
	 * @param relacionados
	 *            String
	 * @return Long
	 */
	public Long findAllCountSolicitudesRelacionarNuevaSancion(SolicitudBusqueda solicitudesBusqueda, String hdcodigo,
			String relacionados);

	/**
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param startsWith
	 *            String
	 * @return Long
	 */
	public Long findAllLikeSolicitudesReclamanteArbitraje(SolicitudBusqueda solicitudesBusqueda, Boolean startsWith);

	/**
	 * Finds a single row in the HechoDenunciado table.
	 * 
	 * @param hechodenunciado
	 *            HechoDenunciado
	 * @return HechoDenunciado
	 */
	@Transactional(readOnly = true)
	public HechoDenunciado findUltimoTramite(HechoDenunciado hechodenunciado);

	/**
	 * Updates a single row in the HechoDenunciado table.
	 * 
	 * @param hechodenunciado
	 *            HechoDenunciado
	 * @return HechoDenunciado
	 */
	public HechoDenunciado updateParticipacionReclamado(HechoDenunciado hechodenunciado);
}
