package com.ejie.y41b.dao;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Y41bGrupoOrganismoTree;
import com.ejie.y41b.model.Y41bOrganismoTree;

/**
 * GrupoOrganismoDao  
 * 
 *  
 */
public interface GrupoOrganismoDao {

	/**
	 * Finds a single row in the Grupos table.
	 * 
	 * @param grupos
	 *            Y41bGrupoOrganismoTree
	 * @return Y41bGrupoOrganismoTree
	 */
	Y41bGrupoOrganismoTree find(Y41bGrupoOrganismoTree grupos);

	/**
	 * Finds a List of rows in the Grupos table.
	 * 
	 * @param grupo
	 *            Grupos
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Y41bGrupoOrganismoTree> findAll(Y41bGrupoOrganismoTree grupo,
			Pagination pagination);

	/**
	 * Finds a List of rows in the Grupos table.
	 * 
	 * @param grupo
	 *            Y41bGrupoOrganismoTree
	 * @return List
	 */
	List<Y41bGrupoOrganismoTree> findAllChildren(Y41bGrupoOrganismoTree grupo);

	/**
	 * Find a single row in the findGrupoEntidad Many To Many relationship.
	 * 
	 * @param grupo
	 *            Y41bGrupoOrganismoTree
	 * @param entidad
	 *            Y41bOrganismoTree
	 * @param pagination
	 *            Pagination
	 * @return Y41bGrupoOrganismoTree
	 */
	Y41bGrupoOrganismoTree findGrupoEntidad(Y41bGrupoOrganismoTree grupo,
			Y41bOrganismoTree organismo, Pagination pagination);

	/**
	 * Counts rows in the Grupo table.
	 * 
	 * @param Y41bGrupoOrganismoTree
	 *            Y41bGrupoOrganismoTree
	 * @return Long
	 */
	Long countEntidadesKontsumonet(Y41bGrupoOrganismoTree Y41bGrupoOrganismoTree);
}
