package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.FormasVenta;

/**
 * FormasVentaDaoImpl  
 *  
 */
 
@Repository
@Transactional
public class FormasVentaDaoImpl implements FormasVentaDao {
    private JdbcTemplate jdbcTemplate;
	private RowMapper<FormasVenta> rwMap = new RowMapper<FormasVenta>() {
		public FormasVenta mapRow(ResultSet resultSet, int rowNum) throws SQLException {
           return new FormasVenta(
               resultSet.getString("FVCODIGO"), resultSet.getString("FVNOMBRE"), resultSet.getString("FVNOMBREE")
           ); } } ;

	/**
     * Method use to set the datasource.
     *
     * @param dataSource DataSource
     * @return
     */
    @Resource
    public void setDataSource(DataSource dataSource) {
    	this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    /**
     * Inserts a single row in the FormasVenta table.
     *
     * @param formasventa Pagination
     * @return FormasVenta
     */
	public FormasVenta add(FormasVenta formasventa) {
    	String query = "INSERT INTO FORMAS_VENTA (FVCODIGO, FVNOMBRE, FVNOMBREE) VALUES (?,?,?)";
		this.jdbcTemplate.update(query, formasventa.getFvcodigo(), formasventa.getFvnombre(), formasventa.getFvnombree());
		return formasventa;
	}

    /**
     * Updates a single row in the FormasVenta table.
     *
     * @param formasventa Pagination
     * @return FormasVenta
     */
    public FormasVenta update(FormasVenta formasventa) {
		String query = "UPDATE FORMAS_VENTA SET FVNOMBRE=?, FVNOMBREE=? WHERE FVCODIGO=?";
		this.jdbcTemplate.update(query, formasventa.getFvnombre(), formasventa.getFvnombree(), formasventa.getFvcodigo());
		return formasventa;
	}

    /**
     * Finds a single row in the FormasVenta table.
     *
     * @param formasventa Pagination
     * @return FormasVenta
     */
    @Transactional (readOnly = true)
    public FormasVenta find(FormasVenta formasventa) {
		String query = "SELECT t1.FVCODIGO FVCODIGO, t1.FVNOMBRE FVNOMBRE, t1.FVNOMBREE FVNOMBREE FROM FORMAS_VENTA t1  WHERE t1.FVCODIGO = ?  ";
		
		List<FormasVenta> formasventaList = this.jdbcTemplate.query(query, this.rwMap, formasventa.getFvcodigo());
		return (FormasVenta) DataAccessUtils.uniqueResult(formasventaList);
    }

    /**
     * Removes a single row in the FormasVenta table.
     *
     * @param formasventa Pagination
     * @return
     */
    public void remove(FormasVenta formasventa) {
		String query = "DELETE FROM FORMAS_VENTA WHERE FVCODIGO=?";
		this.jdbcTemplate.update(query, formasventa.getFvcodigo());
    }
    
   /**
    * Finds a List of rows in the FormasVenta table.
    * 
    * @param formasventa FormasVenta
    * @param pagination Pagination
    * @return List 
    */
	@Transactional (readOnly = true)
    public List<FormasVenta> findAll(FormasVenta formasventa, Pagination pagination) {
		StringBuilder query = new StringBuilder("SELECT  t1.FVCODIGO FVCODIGO,t1.FVNOMBRE FVNOMBRE,t1.FVNOMBREE FVNOMBREE "); 
		query.append("FROM FORMAS_VENTA t1 ");
		
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(formasventa); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		
		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		
		return (List<FormasVenta>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}
	
    /**
     * Counts rows in the FormasVenta table.
     * 
     * @param formasventa FormasVenta
     * @return Long
     */
    @Transactional (readOnly = true)
    public Long findAllCount(FormasVenta formasventa) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM FORMAS_VENTA t1 ");
		
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(formasventa); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);		
		
		List<?> params = (List<?>) mapaWhere.get("params");
		
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
	
	/**
	 * Finds rows in the FormasVenta table using like.
     * 
     * @param formasventa FormasVenta
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List 
     */
	@Transactional (readOnly = true)
    public List<FormasVenta> findAllLike(FormasVenta formasventa, Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT  t1.FVCODIGO FVCODIGO,t1.FVNOMBRE FVNOMBRE,t1.FVNOMBREE FVNOMBREE "); 
        query.append("FROM FORMAS_VENTA t1 ");
      	
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(formasventa,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		
		return (List<FormasVenta>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}
	
	/**
	 * Counts rows in the FormasVenta table using like.
     * 
     * @param formasventa FormasVenta
     * @param startsWith Boolean
     * @return Long 
     */
	@Transactional (readOnly = true)
    public Long findAllLikeCount(FormasVenta formasventa, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM FORMAS_VENTA t1 ");

		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(formasventa,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
	
	/**
	 * Returns a map with the needed value to create the conditions to filter by 
	 * the FormasVenta entity 
	 * 
	 * @param formasventa FormasVenta
	 *            Bean with the criteria values to filter by.
	 * @return Map created with two keys
	 *         key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap (FormasVenta formasventa){
		
		StringBuilder where = new StringBuilder(FormasVentaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (formasventa  != null  && formasventa.getFvcodigo() != null ) {
			where.append(" AND t1.FVCODIGO = ?");
			params.add(formasventa.getFvcodigo());
		}
		if (formasventa  != null  && formasventa.getFvnombre() != null ) {
			where.append(" AND t1.FVNOMBRE = ?");
			params.add(formasventa.getFvnombre());
		}
		if (formasventa  != null  && formasventa.getFvnombree() != null ) {
			where.append(" AND t1.FVNOMBREE = ?");
			params.add(formasventa.getFvnombree());
		}

		Map<String,Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		
		return mapWhere;		
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA
	
	/**
	 * Returns a map with the needed value to create the conditions to filter by  
	 * the FormasVenta entity 
	 * 
	 * @param formasventa FormasVenta
	 *            Bean with the criteria values to filter by.
     * @param startsWith Boolean	 
	 * @return Map created with two keys
	 *         key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap (FormasVenta formasventa, Boolean startsWith){
		
		StringBuilder where = new StringBuilder(FormasVentaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (formasventa  != null  && formasventa.getFvcodigo() != null ) {
			where.append(" AND UPPER(t1.FVCODIGO) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(formasventa.getFvcodigo().toUpperCase() +"%");
			}else{
				params.add("%"+formasventa.getFvcodigo().toUpperCase() +"%");
			}
			where.append(" AND t1.FVCODIGO IS NOT NULL");
	     }			
		if (formasventa  != null  && formasventa.getFvnombre() != null ) {
			where.append(" AND UPPER(t1.FVNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(formasventa.getFvnombre().toUpperCase() +"%");
			}else{
				params.add("%"+formasventa.getFvnombre().toUpperCase() +"%");
			}
			where.append(" AND t1.FVNOMBRE IS NOT NULL");
	     }			
		if (formasventa  != null  && formasventa.getFvnombree() != null ) {
			where.append(" AND UPPER(t1.FVNOMBREE) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(formasventa.getFvnombree().toUpperCase() +"%");
			}else{
				params.add("%"+formasventa.getFvnombree().toUpperCase() +"%");
			}
			where.append(" AND t1.FVNOMBREE IS NOT NULL");
	     }			

		Map<String,Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		
		return mapWhere;		
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA
	
	/**
	 * StringBuilder initilization value
	 */
	 public static final int STRING_BUILDER_INIT = 4096;}

