package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.FormaPresentacion;

/**
 * * FormaPresentacionDaoImpl  
 * 
 *  
 */
// CHECKSTYLE:OFF
@SuppressWarnings(value = { "deprecation" })
@Repository
@Transactional
public class FormaPresentacionDaoImpl implements FormaPresentacionDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<FormaPresentacion> rwMap = new RowMapper<FormaPresentacion>() {
		public FormaPresentacion mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new FormaPresentacion(resultSet.getString("TFPCODIGO"), resultSet.getString("TFPNOMBRE"),
					resultSet.getString("TFPNOMBREE"), resultSet.getString("TFPNOMBREI"),
					resultSet.getString("TFPNOMBREF"), resultSet.getString("TFPNOMBREA"),
					resultSet.getString("TFPCONSULTAS"), resultSet.getString("TFPSOLICITUDES"),
					resultSet.getString("TFPARBITRAJES"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the FormaPresentacion table.
	 * 
	 * @param formapresentacion
	 *            Pagination
	 * @return FormaPresentacion
	 */
	public FormaPresentacion add(FormaPresentacion formapresentacion) {

		String query = "INSERT INTO FORMA_PRESENTACION( TFPCODIGO,TFPNOMBRE,TFPNOMBREE,TFPNOMBREI,TFPNOMBREF,TFPNOMBREA,TFPCONSULTAS,TFPSOLICITUDES, TFPARBITRAJES)"
				+ "VALUES (?,?,?,?,?,?,?,?)";

		/*
		 * String query =
		 * "INSERT INTO FORMA_PRESENTACION( TFPCODIGO,TFPNOMBRE,TFPNOMBREE,TFPNOMBREI,TFPNOMBREF,TFPNOMBREA,TFPCONSULTAS,TFPSOLICITUDES)"
		 * + "VALUES (?,?,?,?,?,?,?,?)";
		 */

		this.jdbcTemplate.update(query, formapresentacion.getTfpcodigo(), formapresentacion.getTfpnombre(),
				formapresentacion.getTfpnombree(), formapresentacion.getTfpnombrei(), formapresentacion.getTfpnombref(),
				formapresentacion.getTfpnombrea(), formapresentacion.getTfpconsultas(),
				formapresentacion.getTfpsolicitudes(), formapresentacion.getTfparbitrajes());
		return formapresentacion;
	}

	/**
	 * Updates a single row in the FormaPresentacion table.
	 * 
	 * @param formapresentacion
	 *            Pagination
	 * @return FormaPresentacion
	 */
	public FormaPresentacion update(FormaPresentacion formapresentacion) {

		String query = "UPDATE FORMA_PRESENTACION SET TFPNOMBRE=?,TFPNOMBREE=?,TFPNOMBREI=?,TFPNOMBREF=?,TFPNOMBREA=?,TFPCONSULTAS=?,TFPSOLICITUDES=?, TFPARBITRAJES=? WHERE TFPCODIGO=?";

		// String query =
		// "UPDATE FORMA_PRESENTACION SET
		// TFPNOMBRE=?,TFPNOMBREE=?,TFPNOMBREI=?,TFPNOMBREF=?,TFPNOMBREA=?,TFPCONSULTAS=?,TFPSOLICITUDES=?
		// WHERE TFPCODIGO=?";

		this.jdbcTemplate.update(query, formapresentacion.getTfpnombre(), formapresentacion.getTfpnombree(),
				formapresentacion.getTfpnombrei(), formapresentacion.getTfpnombref(), formapresentacion.getTfpnombrea(),
				formapresentacion.getTfpconsultas(), formapresentacion.getTfpsolicitudes(),
				formapresentacion.getTfparbitrajes(), formapresentacion.getTfpcodigo());
		return formapresentacion;
	}

	/**
	 * Updates a single row in the FormaPresentacion table.
	 * 
	 * @param formapresentacion
	 *            Pagination
	 * @return FormaPresentacion
	 */
	public FormaPresentacion updateFechaBaja(FormaPresentacion formapresentacion) {
		String query = "UPDATE FORMA_PRESENTACION SET TFPFECBAJA=SYSDATE WHERE TFPCODIGO=?";
		this.jdbcTemplate.update(query, formapresentacion.getTfpcodigo());
		return formapresentacion;
	}

	/**
	 * Finds a single row in the FormaPresentacion table.
	 * 
	 * @param formapresentacion
	 *            Pagination
	 * @return FormaPresentacion
	 */
	@Transactional(readOnly = true)
	public FormaPresentacion find(FormaPresentacion formapresentacion) {

		String query = "SELECT t1.TFPCODIGO TFPCODIGO, t1.TFPNOMBRE TFPNOMBRE, t1.TFPNOMBREE TFPNOMBREE, t1.TFPNOMBREI TFPNOMBREI, t1.TFPNOMBREF TFPNOMBREF, t1.TFPNOMBREA TFPNOMBREA, t1.TFPCONSULTAS, t1.TFPSOLICITUDES, t1.TFPARBITRAJES "
				+ "FROM FORMA_PRESENTACION t1  " + "WHERE t1.TFPCODIGO = ?    ";

		/*
		 * String query =
		 * "SELECT t1.TFPCODIGO TFPCODIGO, t1.TFPNOMBRE TFPNOMBRE, t1.TFPNOMBREE TFPNOMBREE, t1.TFPNOMBREI TFPNOMBREI, t1.TFPNOMBREF TFPNOMBREF, t1.TFPNOMBREA TFPNOMBREA, t1.TFPCONSULTAS, t1.TFPSOLICITUDES "
		 * + "FROM FORMA_PRESENTACION t1  " + "WHERE t1.TFPCODIGO = ?    ";
		 */

		return (FormaPresentacion) this.jdbcTemplate.queryForObject(query, rwMap, formapresentacion.getTfpcodigo());
	}

	/**
	 * Removes a single row in the FormaPresentacion table.
	 * 
	 * @param formapresentacion
	 *            Pagination
	 * @return
	 */
	public void remove(FormaPresentacion formapresentacion) {
		String query = "DELETE  FROM FORMA_PRESENTACION WHERE TFPCODIGO=?";
		this.jdbcTemplate.update(query, formapresentacion.getTfpcodigo());
	}

	/**
	 * Finds a List of rows in the FormaPresentacion table.
	 * 
	 * @param formapresentacion
	 *            FormaPresentacion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<FormaPresentacion> findAll(FormaPresentacion formapresentacion, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.TFPCODIGO TFPCODIGO,t1.TFPNOMBRE TFPNOMBRE,NVL(t1.TFPNOMBREE,t1.TFPNOMBRE) TFPNOMBREE,t1.TFPNOMBREI TFPNOMBREI,t1.TFPNOMBREF TFPNOMBREF,t1.TFPNOMBREA TFPNOMBREA, t1.TFPCONSULTAS, t1.TFPSOLICITUDES, t1.TFPARBITRAJES "
						+ "FROM FORMA_PRESENTACION t1 ");

		/*
		 * StringBuffer query = new StringBuffer(
		 * "SELECT  t1.TFPCODIGO TFPCODIGO,t1.TFPNOMBRE TFPNOMBRE,NVL(t1.TFPNOMBREE,t1.TFPNOMBRE) TFPNOMBREE,t1.TFPNOMBREI TFPNOMBREI,t1.TFPNOMBREF TFPNOMBREF,t1.TFPNOMBREA TFPNOMBREA, t1.TFPCONSULTAS, t1.TFPSOLICITUDES "
		 * + "FROM FORMA_PRESENTACION t1 ");
		 */

		if (formapresentacion != null && formapresentacion.getTfpcodigo() != null) {
			where.append(" AND t1.TFPCODIGO = ?");
			params.add(formapresentacion.getTfpcodigo());
		}
		if (formapresentacion != null && formapresentacion.getTfpnombre() != null) {
			where.append(" AND t1.TFPNOMBRE = ?");
			params.add(formapresentacion.getTfpnombre());
		}
		if (formapresentacion != null && formapresentacion.getTfpnombree() != null) {
			where.append(" AND t1.TFPNOMBREE = ?");
			params.add(formapresentacion.getTfpnombree());
		}
		if (formapresentacion != null && formapresentacion.getTfpnombrei() != null) {
			where.append(" AND t1.TFPNOMBREI = ?");
			params.add(formapresentacion.getTfpnombrei());
		}
		if (formapresentacion != null && formapresentacion.getTfpnombref() != null) {
			where.append(" AND t1.TFPNOMBREF = ?");
			params.add(formapresentacion.getTfpnombref());
		}
		if (formapresentacion != null && formapresentacion.getTfpnombrea() != null) {
			where.append(" AND t1.TFPNOMBREA = ?");
			params.add(formapresentacion.getTfpnombrea());
		}
		if (formapresentacion != null && formapresentacion.getTfpconsultas() != null) {
			where.append(" AND t1.TFPCONSULTAS = ?");
			params.add(formapresentacion.getTfpconsultas());
		}
		if (formapresentacion != null && formapresentacion.getTfpsolicitudes() != null) {
			where.append(" AND t1.TFPSOLICITUDES = ?");
			params.add(formapresentacion.getTfpsolicitudes());
		}
		if (formapresentacion != null && formapresentacion.getTfparbitrajes() != null) {
			where.append(" AND t1.TFPARBITRAJES = ?");
			params.add(formapresentacion.getTfparbitrajes());
		}

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		}
		return (List<FormaPresentacion>) this.jdbcTemplate.query(query.toString(), rwMap, params.toArray());
	}

	/**
	 * Finds a List of rows in the FormaPresentacion table.
	 * 
	 * @param formapresentacion
	 *            FormaPresentacion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<FormaPresentacion> findAllConsultasOrSolicitudes(FormaPresentacion formapresentacion,
			Pagination pagination, String consultas) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		if (consultas.equals("C")) {
			where.append(" WHERE TFPCONSULTAS='S' ");
		} else if (consultas.equals("S")) {
			where.append(" WHERE TFPSOLICITUDES='S'	");
		} else if (consultas.equals("E")) {
			where.append(" WHERE TFPAACCEMPRESAS ='S' ");
		} else
			where.append(" WHERE TFPARBITRAJES='S' ");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.TFPCODIGO TFPCODIGO,t1.TFPNOMBRE TFPNOMBRE,NVL(t1.TFPNOMBREE,t1.TFPNOMBRE) TFPNOMBREE,t1.TFPNOMBREI TFPNOMBREI,t1.TFPNOMBREF TFPNOMBREF,t1.TFPNOMBREA TFPNOMBREA, t1.TFPCONSULTAS, t1.TFPSOLICITUDES, t1.TFPARBITRAJES "
						+ "FROM FORMA_PRESENTACION t1 ");

		/*
		 * StringBuffer query = new StringBuffer(
		 * "SELECT  t1.TFPCODIGO TFPCODIGO,t1.TFPNOMBRE TFPNOMBRE,NVL(t1.TFPNOMBREE,t1.TFPNOMBRE) TFPNOMBREE,t1.TFPNOMBREI TFPNOMBREI,t1.TFPNOMBREF TFPNOMBREF,t1.TFPNOMBREA TFPNOMBREA, t1.TFPCONSULTAS, t1.TFPSOLICITUDES "
		 * + "FROM FORMA_PRESENTACION t1 ");
		 */

		if (formapresentacion != null && formapresentacion.getTfpcodigo() != null) {
			where.append(" AND t1.TFPCODIGO = ?");
			params.add(formapresentacion.getTfpcodigo());
		}
		if (formapresentacion != null && formapresentacion.getTfpnombre() != null) {
			where.append(" AND t1.TFPNOMBRE = ?");
			params.add(formapresentacion.getTfpnombre());
		}
		if (formapresentacion != null && formapresentacion.getTfpnombree() != null) {
			where.append(" AND t1.TFPNOMBREE = ?");
			params.add(formapresentacion.getTfpnombree());
		}
		if (formapresentacion != null && formapresentacion.getTfpnombrei() != null) {
			where.append(" AND t1.TFPNOMBREI = ?");
			params.add(formapresentacion.getTfpnombrei());
		}
		if (formapresentacion != null && formapresentacion.getTfpnombref() != null) {
			where.append(" AND t1.TFPNOMBREF = ?");
			params.add(formapresentacion.getTfpnombref());
		}
		if (formapresentacion != null && formapresentacion.getTfpnombrea() != null) {
			where.append(" AND t1.TFPNOMBREA = ?");
			params.add(formapresentacion.getTfpnombrea());
		}
		if (formapresentacion != null && formapresentacion.getTfpconsultas() != null) {
			where.append(" AND t1.TFPCONSULTAS = ?");
			params.add(formapresentacion.getTfpconsultas());
		}
		if (formapresentacion != null && formapresentacion.getTfpsolicitudes() != null) {
			where.append(" AND t1.TFPSOLICITUDES = ?");
			params.add(formapresentacion.getTfpsolicitudes());
		}
		if (formapresentacion != null && formapresentacion.getTfparbitrajes() != null) {
			where.append(" AND t1.TFPARBITRAJES = ?");
			params.add(formapresentacion.getTfparbitrajes());
		}

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		}
		return (List<FormaPresentacion>) this.jdbcTemplate.query(query.toString(), rwMap, params.toArray());
	}

	/**
	 * Finds a List of rows in the FormaPresentacion table.
	 * 
	 * @param formapresentacion
	 *            FormaPresentacion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<FormaPresentacion> findAllConsultasOrSolicitudesSinWeb(FormaPresentacion formapresentacion,
			Pagination pagination, String consultas, String sir) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		if (consultas.equals("C")) {
			where.append(
					" WHERE TFPCONSULTAS='S' AND t1.TFPCODIGO != ? AND t1.TFPCODIGO != ? AND t1.TFPCODIGO != ? AND t1.TFPCODIGO != ? ");
			params.add(Y41bConstantes.FORMA_PRESENTACION_SOLICITUD_WEB);
			params.add(Y41bConstantes.FORMA_PRESENTACION_SOLICITUD_WEB_POR_APP);
			params.add(Y41bConstantes.FORMA_PRESENTACION_WEB_SINCERTIFICADO);
			params.add(Y41bConstantes.FORMA_PRESENTACION_SIR);

		} else {

			if (consultas.equals("E")) {
				where.append(
						" WHERE TFPAACCEMPRESAS='S'	AND t1.TFPCODIGO != ? AND t1.TFPCODIGO != ? AND t1.TFPCODIGO != ? ");
			} else {
				where.append(
						" WHERE TFPSOLICITUDES='S'	AND t1.TFPCODIGO != ? AND t1.TFPCODIGO != ? AND t1.TFPCODIGO != ? ");
				if (sir.equalsIgnoreCase("N")) {
					where.append("AND t1.TFPCODIGO != ? ");
					params.add(Y41bConstantes.FORMA_PRESENTACION_SIR);
				}
			}

			params.add(Y41bConstantes.FORMA_PRESENTACION_SOLICITUD_WEB);
			params.add(Y41bConstantes.FORMA_PRESENTACION_SOLICITUD_WEB_POR_APP);
			params.add(Y41bConstantes.FORMA_PRESENTACION_WEB_SINCERTIFICADO);

		}

		StringBuffer query = new StringBuffer(
				"SELECT  t1.TFPCODIGO TFPCODIGO,t1.TFPNOMBRE TFPNOMBRE,NVL(t1.TFPNOMBREE,t1.TFPNOMBRE) TFPNOMBREE,t1.TFPNOMBREI TFPNOMBREI,t1.TFPNOMBREF TFPNOMBREF,t1.TFPNOMBREA TFPNOMBREA, t1.TFPCONSULTAS, t1.TFPSOLICITUDES, t1.TFPARBITRAJES "
						+ "FROM FORMA_PRESENTACION t1 ");

		/*
		 * StringBuffer query = new StringBuffer(
		 * "SELECT  t1.TFPCODIGO TFPCODIGO,t1.TFPNOMBRE TFPNOMBRE,NVL(t1.TFPNOMBREE,t1.TFPNOMBRE) TFPNOMBREE,t1.TFPNOMBREI TFPNOMBREI,t1.TFPNOMBREF TFPNOMBREF,t1.TFPNOMBREA TFPNOMBREA, t1.TFPCONSULTAS, t1.TFPSOLICITUDES "
		 * + "FROM FORMA_PRESENTACION t1 ");
		 */

		if (formapresentacion != null && formapresentacion.getTfpcodigo() != null) {
			where.append(" AND t1.TFPCODIGO = ?");
			params.add(formapresentacion.getTfpcodigo());
		}
		if (formapresentacion != null && formapresentacion.getTfpnombre() != null) {
			where.append(" AND t1.TFPNOMBRE = ?");
			params.add(formapresentacion.getTfpnombre());
		}
		if (formapresentacion != null && formapresentacion.getTfpnombree() != null) {
			where.append(" AND t1.TFPNOMBREE = ?");
			params.add(formapresentacion.getTfpnombree());
		}
		if (formapresentacion != null && formapresentacion.getTfpnombrei() != null) {
			where.append(" AND t1.TFPNOMBREI = ?");
			params.add(formapresentacion.getTfpnombrei());
		}
		if (formapresentacion != null && formapresentacion.getTfpnombref() != null) {
			where.append(" AND t1.TFPNOMBREF = ?");
			params.add(formapresentacion.getTfpnombref());
		}
		if (formapresentacion != null && formapresentacion.getTfpnombrea() != null) {
			where.append(" AND t1.TFPNOMBREA = ?");
			params.add(formapresentacion.getTfpnombrea());
		}
		if (formapresentacion != null && formapresentacion.getTfpconsultas() != null) {
			where.append(" AND t1.TFPCONSULTAS = ?");
			params.add(formapresentacion.getTfpconsultas());
		}
		if (formapresentacion != null && formapresentacion.getTfpsolicitudes() != null) {
			where.append(" AND t1.TFPSOLICITUDES = ?");
			params.add(formapresentacion.getTfpsolicitudes());
		}
		if (formapresentacion != null && formapresentacion.getTfparbitrajes() != null) {
			where.append(" AND t1.TFPARBITRAJES = ?");
			params.add(formapresentacion.getTfparbitrajes());
		}

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		}
		return (List<FormaPresentacion>) this.jdbcTemplate.query(query.toString(), rwMap, params.toArray());
	}

	/**
	 * Finds a List of rows in the FormaPresentacion table.
	 * 
	 * @param formapresentacion
	 *            FormaPresentacion
	 * @param pagination
	 *            Pagination
	 * @param consultas
	 *            String
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<FormaPresentacion> findAllConsultasOrSolicitudesAlta(FormaPresentacion formapresentacion,
			Pagination pagination, String consultas) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		if (consultas.equals("C")) {
			where.append(" WHERE TFPCONSULTAS='S' ");
		} else if (consultas.equals("S")) {
			where.append(" WHERE TFPSOLICITUDES='S'	");
		} else
			where.append(" WHERE TFPARBITRAJES='S' ");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.TFPCODIGO TFPCODIGO,t1.TFPNOMBRE TFPNOMBRE,NVL(t1.TFPNOMBREE,t1.TFPNOMBRE) TFPNOMBREE,t1.TFPNOMBREI TFPNOMBREI,t1.TFPNOMBREF TFPNOMBREF,t1.TFPNOMBREA TFPNOMBREA, t1.TFPCONSULTAS, t1.TFPSOLICITUDES, t1.TFPARBITRAJES "
						+ "FROM FORMA_PRESENTACION t1 ");

		/*
		 * StringBuffer query = new StringBuffer(
		 * "SELECT  t1.TFPCODIGO TFPCODIGO,t1.TFPNOMBRE TFPNOMBRE,NVL(t1.TFPNOMBREE,t1.TFPNOMBRE) TFPNOMBREE,t1.TFPNOMBREI TFPNOMBREI,t1.TFPNOMBREF TFPNOMBREF,t1.TFPNOMBREA TFPNOMBREA, t1.TFPCONSULTAS, t1.TFPSOLICITUDES "
		 * + "FROM FORMA_PRESENTACION t1 ");
		 */

		if (formapresentacion != null && formapresentacion.getTfpcodigo() != null) {
			where.append(" AND t1.TFPCODIGO = ?");
			params.add(formapresentacion.getTfpcodigo());
		}
		if (formapresentacion != null && formapresentacion.getTfpnombre() != null) {
			where.append(" AND t1.TFPNOMBRE = ?");
			params.add(formapresentacion.getTfpnombre());
		}
		if (formapresentacion != null && formapresentacion.getTfpnombree() != null) {
			where.append(" AND t1.TFPNOMBREE = ?");
			params.add(formapresentacion.getTfpnombree());
		}
		if (formapresentacion != null && formapresentacion.getTfpnombrei() != null) {
			where.append(" AND t1.TFPNOMBREI = ?");
			params.add(formapresentacion.getTfpnombrei());
		}
		if (formapresentacion != null && formapresentacion.getTfpnombref() != null) {
			where.append(" AND t1.TFPNOMBREF = ?");
			params.add(formapresentacion.getTfpnombref());
		}
		if (formapresentacion != null && formapresentacion.getTfpnombrea() != null) {
			where.append(" AND t1.TFPNOMBREA = ?");
			params.add(formapresentacion.getTfpnombrea());
		}
		if (formapresentacion != null && formapresentacion.getTfpconsultas() != null) {
			where.append(" AND t1.TFPCONSULTAS = ?");
			params.add(formapresentacion.getTfpconsultas());
		}
		if (formapresentacion != null && formapresentacion.getTfpsolicitudes() != null) {
			where.append(" AND t1.TFPSOLICITUDES = ?");
			params.add(formapresentacion.getTfpsolicitudes());
		}
		if (formapresentacion != null && formapresentacion.getTfparbitrajes() != null) {
			where.append(" AND t1.TFPARBITRAJES = ?");
			params.add(formapresentacion.getTfparbitrajes());
		}

		where.append(" AND t1.TFPFECBAJA IS NULL ");

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		}
		return (List<FormaPresentacion>) this.jdbcTemplate.query(query.toString(), rwMap, params.toArray());
	}

	/**
	 * Finds a List of rows in the FormaPresentacion table.
	 * 
	 * @param formapresentacion
	 *            FormaPresentacion
	 * @param pagination
	 *            Pagination
	 * @param consultas
	 *            String
	 * @param sir
	 *            String
	 * 
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<FormaPresentacion> findAllConsultasOrSolicitudesAltaSinWeb(FormaPresentacion formapresentacion,
			Pagination pagination, String consultas, String sir) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		if (consultas.equals("C")) {
			where.append(
					" WHERE TFPCONSULTAS='S' AND t1.TFPCODIGO != ? AND t1.TFPCODIGO != ? AND t1.TFPCODIGO != ? AND t1.TFPCODIGO != ?");
			params.add(Y41bConstantes.FORMA_PRESENTACION_SOLICITUD_WEB);
			params.add(Y41bConstantes.FORMA_PRESENTACION_SOLICITUD_WEB_POR_APP);
			params.add(Y41bConstantes.FORMA_PRESENTACION_WEB_SINCERTIFICADO);
			params.add(Y41bConstantes.FORMA_PRESENTACION_SIR);
		} else {

			if (consultas.equals("E")) {
				where.append(
						" WHERE TFPAACCEMPRESAS='S'	AND t1.TFPCODIGO != ? AND t1.TFPCODIGO != ? AND t1.TFPCODIGO != ? ");
			} else {
				where.append(
						" WHERE TFPSOLICITUDES='S'	AND t1.TFPCODIGO != ? AND t1.TFPCODIGO != ? AND t1.TFPCODIGO != ? ");
				if (sir.equalsIgnoreCase("N")) {
					where.append("AND t1.TFPCODIGO != ? ");
					params.add(Y41bConstantes.FORMA_PRESENTACION_SIR);
				}
			}

			params.add(Y41bConstantes.FORMA_PRESENTACION_SOLICITUD_WEB);
			params.add(Y41bConstantes.FORMA_PRESENTACION_SOLICITUD_WEB_POR_APP);
			params.add(Y41bConstantes.FORMA_PRESENTACION_WEB_SINCERTIFICADO);

		}

		StringBuffer query = new StringBuffer(
				"SELECT  t1.TFPCODIGO TFPCODIGO,t1.TFPNOMBRE TFPNOMBRE,NVL(t1.TFPNOMBREE,t1.TFPNOMBRE) TFPNOMBREE,t1.TFPNOMBREI TFPNOMBREI,t1.TFPNOMBREF TFPNOMBREF,t1.TFPNOMBREA TFPNOMBREA, t1.TFPCONSULTAS, t1.TFPSOLICITUDES, t1.TFPARBITRAJES "
						+ "FROM FORMA_PRESENTACION t1 ");

		/*
		 * StringBuffer query = new StringBuffer(
		 * "SELECT  t1.TFPCODIGO TFPCODIGO,t1.TFPNOMBRE TFPNOMBRE,NVL(t1.TFPNOMBREE,t1.TFPNOMBRE) TFPNOMBREE,t1.TFPNOMBREI TFPNOMBREI,t1.TFPNOMBREF TFPNOMBREF,t1.TFPNOMBREA TFPNOMBREA, t1.TFPCONSULTAS, t1.TFPSOLICITUDES "
		 * + "FROM FORMA_PRESENTACION t1 ");
		 */

		if (formapresentacion != null && formapresentacion.getTfpcodigo() != null) {
			where.append(" AND t1.TFPCODIGO = ?");
			params.add(formapresentacion.getTfpcodigo());
		}
		if (formapresentacion != null && formapresentacion.getTfpnombre() != null) {
			where.append(" AND t1.TFPNOMBRE = ?");
			params.add(formapresentacion.getTfpnombre());
		}
		if (formapresentacion != null && formapresentacion.getTfpnombree() != null) {
			where.append(" AND t1.TFPNOMBREE = ?");
			params.add(formapresentacion.getTfpnombree());
		}
		if (formapresentacion != null && formapresentacion.getTfpnombrei() != null) {
			where.append(" AND t1.TFPNOMBREI = ?");
			params.add(formapresentacion.getTfpnombrei());
		}
		if (formapresentacion != null && formapresentacion.getTfpnombref() != null) {
			where.append(" AND t1.TFPNOMBREF = ?");
			params.add(formapresentacion.getTfpnombref());
		}
		if (formapresentacion != null && formapresentacion.getTfpnombrea() != null) {
			where.append(" AND t1.TFPNOMBREA = ?");
			params.add(formapresentacion.getTfpnombrea());
		}
		if (formapresentacion != null && formapresentacion.getTfpconsultas() != null) {
			where.append(" AND t1.TFPCONSULTAS = ?");
			params.add(formapresentacion.getTfpconsultas());
		}
		if (formapresentacion != null && formapresentacion.getTfpsolicitudes() != null) {
			where.append(" AND t1.TFPSOLICITUDES = ?");
			params.add(formapresentacion.getTfpsolicitudes());
		}
		if (formapresentacion != null && formapresentacion.getTfparbitrajes() != null) {
			where.append(" AND t1.TFPARBITRAJES = ?");
			params.add(formapresentacion.getTfparbitrajes());
		}

		where.append(" AND t1.TFPFECBAJA IS NULL ");

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		}
		return (List<FormaPresentacion>) this.jdbcTemplate.query(query.toString(), rwMap, params.toArray());
	}

	/**
	 * Counts rows in the FormaPresentacion table.
	 * 
	 * @param formapresentacion
	 *            FormaPresentacion
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(FormaPresentacion formapresentacion) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuffer query = new StringBuffer("SELECT COUNT(1) FROM  FORMA_PRESENTACION t1  ");
		if (formapresentacion != null && formapresentacion.getTfpcodigo() != null) {
			where.append(" AND t1.TFPCODIGO = ?");
			params.add(formapresentacion.getTfpcodigo());
		}
		if (formapresentacion != null && formapresentacion.getTfpnombre() != null) {
			where.append(" AND t1.TFPNOMBRE = ?");
			params.add(formapresentacion.getTfpnombre());
		}
		if (formapresentacion != null && formapresentacion.getTfpnombree() != null) {
			where.append(" AND t1.TFPNOMBREE = ?");
			params.add(formapresentacion.getTfpnombree());
		}
		if (formapresentacion != null && formapresentacion.getTfpnombrei() != null) {
			where.append(" AND t1.TFPNOMBREI = ?");
			params.add(formapresentacion.getTfpnombrei());
		}
		if (formapresentacion != null && formapresentacion.getTfpnombref() != null) {
			where.append(" AND t1.TFPNOMBREF = ?");
			params.add(formapresentacion.getTfpnombref());
		}
		if (formapresentacion != null && formapresentacion.getTfpnombrea() != null) {
			where.append(" AND t1.TFPNOMBREA = ?");
			params.add(formapresentacion.getTfpnombrea());
		}
		if (formapresentacion != null && formapresentacion.getTfpconsultas() != null) {
			where.append(" AND t1.TFPCONSULTAS = ?");
			params.add(formapresentacion.getTfpconsultas());
		}
		if (formapresentacion != null && formapresentacion.getTfpsolicitudes() != null) {
			where.append(" AND t1.TFPSOLICITUDES = ?");
			params.add(formapresentacion.getTfpsolicitudes());
		}
		if (formapresentacion != null && formapresentacion.getTfparbitrajes() != null) {
			where.append(" AND t1.TFPARBITRAJES = ?");
			params.add(formapresentacion.getTfparbitrajes());
		}

		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds rows in the FormaPresentacion table using like.
	 * 
	 * @param formapresentacion
	 *            FormaPresentacion
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<FormaPresentacion> findAllLike(FormaPresentacion formapresentacion, Pagination pagination,
			Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.TFPCODIGO TFPCODIGO,t1.TFPNOMBRE TFPNOMBRE,NVL(t1.TFPNOMBREE,t1.TFPNOMBRE) TFPNOMBREE,t1.TFPNOMBREI TFPNOMBREI,t1.TFPNOMBREF TFPNOMBREF,t1.TFPNOMBREA TFPNOMBREA, t1.TFPCONSULTAS, t1.TFPSOLICITUDES, t1.TFPARBITRAJES "
						+ "FROM FORMA_PRESENTACION t1 ");

		/*
		 * StringBuffer query = new StringBuffer(
		 * "SELECT  t1.TFPCODIGO TFPCODIGO,t1.TFPNOMBRE TFPNOMBRE,NVL(t1.TFPNOMBREE,t1.TFPNOMBRE) TFPNOMBREE,t1.TFPNOMBREI TFPNOMBREI,t1.TFPNOMBREF TFPNOMBREF,t1.TFPNOMBREA TFPNOMBREA, t1.TFPCONSULTAS, t1.TFPSOLICITUDES "
		 * + "FROM FORMA_PRESENTACION t1 ");
		 */

		if (formapresentacion != null && formapresentacion.getTfpcodigo() != null) {
			where.append(" AND UPPER(t1.TFPCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(formapresentacion.getTfpcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + formapresentacion.getTfpcodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.TFPCODIGO IS NOT NULL");
		}
		if (formapresentacion != null && formapresentacion.getTfpnombre() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.TFPNOMBRE),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(formapresentacion.getTfpnombre().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + formapresentacion.getTfpnombre().toUpperCase().replaceAll("", "A")
						.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.TFPNOMBRE IS NOT NULL");
		}
		if (formapresentacion != null && formapresentacion.getTfpnombree() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.TFPNOMBREE),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(formapresentacion.getTfpnombree().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + formapresentacion.getTfpnombree().toUpperCase().replaceAll("", "A")
						.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.TFPNOMBREE IS NOT NULL");
		}
		if (formapresentacion != null && formapresentacion.getTfpnombrei() != null) {
			where.append(" AND UPPER(t1.TFPNOMBREI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(formapresentacion.getTfpnombrei().toUpperCase() + "%");
			} else {
				params.add("%" + formapresentacion.getTfpnombrei().toUpperCase() + "%");
			}
			where.append(" AND t1.TFPNOMBREI IS NOT NULL");
		}
		if (formapresentacion != null && formapresentacion.getTfpnombref() != null) {
			where.append(" AND UPPER(t1.TFPNOMBREF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(formapresentacion.getTfpnombref().toUpperCase() + "%");
			} else {
				params.add("%" + formapresentacion.getTfpnombref().toUpperCase() + "%");
			}
			where.append(" AND t1.TFPNOMBREF IS NOT NULL");
		}
		if (formapresentacion != null && formapresentacion.getTfpnombrea() != null) {
			where.append(" AND UPPER(t1.TFPNOMBREA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(formapresentacion.getTfpnombrea().toUpperCase() + "%");
			} else {
				params.add("%" + formapresentacion.getTfpnombrea().toUpperCase() + "%");
			}
			where.append(" AND t1.TFPNOMBREA IS NOT NULL");
		}

		where.append(" AND t1.TFPFECBAJA IS NULL");

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination, query.toString()));
		}
		return (List<FormaPresentacion>) this.jdbcTemplate.query(query.toString(), rwMap, params.toArray());
	}

	/**
	 * Counts rows in the FormaPresentacion table.
	 * 
	 * @param formapresentacion
	 *            FormaPresentacion
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(FormaPresentacion formapresentacion, Boolean startsWith) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuffer query = new StringBuffer("SELECT COUNT(1) FROM  FORMA_PRESENTACION t1  ");
		if (formapresentacion != null && formapresentacion.getTfpcodigo() != null) {
			where.append(" AND UPPER(t1.TFPCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(formapresentacion.getTfpcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + formapresentacion.getTfpcodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.TFPCODIGO IS NOT NULL");
		}
		if (formapresentacion != null && formapresentacion.getTfpnombre() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.TFPNOMBRE),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(formapresentacion.getTfpnombre().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + formapresentacion.getTfpnombre().toUpperCase().replaceAll("", "A")
						.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.TFPNOMBRE IS NOT NULL");
		}
		if (formapresentacion != null && formapresentacion.getTfpnombree() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.TFPNOMBREE),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(formapresentacion.getTfpnombree().toUpperCase().replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%" + formapresentacion.getTfpnombree().toUpperCase().replaceAll("", "A")
						.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			}
			where.append(" AND t1.TFPNOMBREE IS NOT NULL");
		}
		if (formapresentacion != null && formapresentacion.getTfpnombrei() != null) {
			where.append(" AND UPPER(t1.TFPNOMBREI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(formapresentacion.getTfpnombrei().toUpperCase() + "%");
			} else {
				params.add("%" + formapresentacion.getTfpnombrei().toUpperCase() + "%");
			}
			where.append(" AND t1.TFPNOMBREI IS NOT NULL");
		}
		if (formapresentacion != null && formapresentacion.getTfpnombref() != null) {
			where.append(" AND UPPER(t1.TFPNOMBREF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(formapresentacion.getTfpnombref().toUpperCase() + "%");
			} else {
				params.add("%" + formapresentacion.getTfpnombref().toUpperCase() + "%");
			}
			where.append(" AND t1.TFPNOMBREF IS NOT NULL");
		}
		if (formapresentacion != null && formapresentacion.getTfpnombrea() != null) {
			where.append(" AND UPPER(t1.TFPNOMBREA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(formapresentacion.getTfpnombrea().toUpperCase() + "%");
			} else {
				params.add("%" + formapresentacion.getTfpnombrea().toUpperCase() + "%");
			}
			where.append(" AND t1.TFPNOMBREA IS NOT NULL");
		}

		where.append(" AND t1.TFPFECBAJA IS NULL");

		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

}
