package com.ejie.y41b.dao;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.FormaPresentacion;

/**
 * * FormaPresentacionDao  
 * 
 *  
 */

public interface FormaPresentacionDao {

	/**
	 * Inserts a single row in the FormaPresentacion table.
	 * 
	 * @param formapresentacion
	 *            FormaPresentacion
	 * @return FormaPresentacion
	 */
	FormaPresentacion add(FormaPresentacion formapresentacion);

	/**
	 * Updates a single row in the FormaPresentacion table.
	 * 
	 * @param formapresentacion
	 *            FormaPresentacion
	 * @return FormaPresentacion
	 */
	FormaPresentacion update(FormaPresentacion formapresentacion);

	/**
	 * Updates a single row in the FormaPresentacion table.
	 * 
	 * @param formapresentacion
	 *            Pagination
	 * @return FormaPresentacion
	 */
	public FormaPresentacion updateFechaBaja(FormaPresentacion formapresentacion);

	/**
	 * Finds a single row in the FormaPresentacion table.
	 * 
	 * @param formapresentacion
	 *            FormaPresentacion
	 * @return FormaPresentacion
	 */
	FormaPresentacion find(FormaPresentacion formapresentacion);

	/**
	 * Deletes a single row in the FormaPresentacion table.
	 * 
	 * @param formapresentacion
	 *            FormaPresentacion
	 * @return
	 */
	void remove(FormaPresentacion formapresentacion);

	/**
	 * Finds a List of rows in the FormaPresentacion table.
	 * 
	 * @param formapresentacion
	 *            FormaPresentacion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<FormaPresentacion> findAll(FormaPresentacion formapresentacion, Pagination pagination);

	/**
	 * Finds a List of rows in the FormaPresentacion filetring by Consultas or
	 * Solicitudes.
	 * 
	 * @param formapresentacion
	 *            FormaPresentacion
	 * @param pagination
	 *            Pagination
	 * @param consultas
	 *            String
	 * @param sir
	 *            String
	 * @return List
	 */
	public List<FormaPresentacion> findAllConsultasOrSolicitudes(FormaPresentacion formapresentacion,
			Pagination pagination, String consultas);

	/**
	 * Finds a List of rows in the FormaPresentacion table.
	 * 
	 * @param formapresentacion
	 *            FormaPresentacion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<FormaPresentacion> findAllConsultasOrSolicitudesSinWeb(FormaPresentacion formapresentacion,
			Pagination pagination, String consultas, String sir);

	/**
	 * Finds a List of rows in the FormaPresentacion table.
	 * 
	 * @param formapresentacion
	 *            FormaPresentacion
	 * @param pagination
	 *            Pagination
	 * @param consultas
	 *            String
	 * @return List
	 */
	public List<FormaPresentacion> findAllConsultasOrSolicitudesAlta(FormaPresentacion formapresentacion,
			Pagination pagination, String consultas);

	/**
	 * Finds a List of rows in the FormaPresentacion table.
	 * 
	 * @param formapresentacion
	 *            FormaPresentacion
	 * @param pagination
	 *            Pagination
	 * @param consultas
	 *            String
	 * @param sir
	 *            String
	 * 
	 * @return List
	 */
	public List<FormaPresentacion> findAllConsultasOrSolicitudesAltaSinWeb(FormaPresentacion formapresentacion,
			Pagination pagination, String consultas, String sir);

	/**
	 * Counts rows in the FormaPresentacion table.
	 * 
	 * @param formapresentacion
	 *            FormaPresentacion
	 * @return List
	 */
	Long findAllCount(FormaPresentacion formapresentacion);

	/**
	 * Finds rows in the FormaPresentacion table using like.
	 * 
	 * @param formapresentacion
	 *            FormaPresentacion
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<FormaPresentacion> findAllLike(FormaPresentacion formapresentacion, Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the FormaPresentacion table.
	 * 
	 * @param formapresentacion
	 *            FormaPresentacion
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(FormaPresentacion formapresentacion, Boolean startsWith);
}
