package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.TipoProcedimiento;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Fase;

/**
 * FaseDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class FaseDaoImpl implements FaseDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Fase> rwMap = new RowMapper<Fase>() {
		public Fase mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new Fase(resultSet.getString("FCODIGO"),
					resultSet.getString("FNOMBRE"),
					resultSet.getString("FNOMBREE"),
					resultSet.getDate("FBAJA"), new TipoProcedimiento(
							resultSet.getString("TipoProcedimientoPCODIGO"),
							resultSet.getString("TipoProcedimientoPNOMBRE"),
							resultSet.getString("TipoProcedimientoPNOMBREE"),
							resultSet.getDate("TipoProcedimientoPBAJA")));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Fase table.
	 * 
	 * @param fase
	 *            Pagination
	 * @return Fase
	 */
	public Fase add(Fase fase) {
		String query = "INSERT INTO FASE (FCODIGO, PCODIGO, FNOMBRE, FNOMBREE, FBAJA) VALUES (?,?,?,?,?)";
		Object getTipoProcedimientoPcodigoAux = null;
		if (fase.getTipoProcedimiento() != null
				&& fase.getTipoProcedimiento().getPcodigo() != null) {
			getTipoProcedimientoPcodigoAux = fase.getTipoProcedimiento()
					.getPcodigo();
		}
		this.jdbcTemplate.update(query, fase.getFcodigo(),
				getTipoProcedimientoPcodigoAux, fase.getFnombre(),
				fase.getFnombree(), fase.getFbaja());
		return fase;
	}

	/**
	 * Updates a single row in the Fase table.
	 * 
	 * @param fase
	 *            Pagination
	 * @return Fase
	 */
	public Fase update(Fase fase) {
		String query = "UPDATE FASE SET PCODIGO=?, FNOMBRE=?, FNOMBREE=?, FBAJA=? WHERE FCODIGO=?";
		Object getTipoProcedimientoPcodigoAux = null;
		if (fase.getTipoProcedimiento() != null
				&& fase.getTipoProcedimiento().getPcodigo() != null) {
			getTipoProcedimientoPcodigoAux = fase.getTipoProcedimiento()
					.getPcodigo();
		}
		this.jdbcTemplate.update(query, getTipoProcedimientoPcodigoAux,
				fase.getFnombre(), fase.getFnombree(), fase.getFbaja(),
				fase.getFcodigo());
		return fase;
	}

	/**
	 * Finds a single row in the Fase table.
	 * 
	 * @param fase
	 *            Pagination
	 * @return Fase
	 */
	@Transactional(readOnly = true)
	public Fase find(Fase fase) {
		String query = "SELECT t1.FCODIGO FCODIGO, t1.FNOMBRE FNOMBRE, t1.FNOMBREE FNOMBREE, t1.FBAJA FBAJA, t2.PCODIGO TIPOPROCEDIMIENTOPCODIGO, t2.PNOMBRE TIPOPROCEDIMIENTOPNOMBRE, t2.PNOMBREE TIPOPROCEDIMIENTOPNOMBREE, t2.PBAJA TIPOPROCEDIMIENTOPBAJA FROM FASE t1 , TIPO_PROCEDIMIENTO t2  WHERE t1.FCODIGO = ?   AND t1.PCODIGO= t2.PCODIGO(+)";

		List<Fase> faseList = this.jdbcTemplate.query(query, this.rwMap,
				fase.getFcodigo());
		return (Fase) DataAccessUtils.uniqueResult(faseList);
	}

	/**
	 * Removes a single row in the Fase table.
	 * 
	 * @param fase
	 *            Pagination
	 * @return
	 */
	public void remove(Fase fase) {
		String query = "DELETE FROM FASE WHERE FCODIGO=?";
		this.jdbcTemplate.update(query, fase.getFcodigo());
	}

	/**
	 * Finds a List of rows in the Fase table.
	 * 
	 * @param fase
	 *            Fase
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Fase> findAll(Fase fase, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.FCODIGO FCODIGO,t1.FNOMBRE FNOMBRE,NVL(t1.FNOMBREE,t1.FNOMBRE) FNOMBREE,t1.FBAJA FBAJA,t2.PCODIGO TIPOPROCEDIMIENTOPCODIGO,t2.PNOMBRE TIPOPROCEDIMIENTOPNOMBRE,t2.PNOMBREE TIPOPROCEDIMIENTOPNOMBREE,t2.PBAJA TIPOPROCEDIMIENTOPBAJA ");
		query.append("FROM FASE t1 ,TIPO_PROCEDIMIENTO t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(fase);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.PCODIGO= t2.PCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Fase>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Fase table.
	 * 
	 * @param fase
	 *            Fase
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Fase fase) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM FASE t1 , TIPO_PROCEDIMIENTO t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(fase);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.PCODIGO= t2.PCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Fase table using like.
	 * 
	 * @param fase
	 *            Fase
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Fase> findAllLike(Fase fase, Pagination pagination,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.FCODIGO FCODIGO,t1.FNOMBRE FNOMBRE,NVL(t1.FNOMBREE,t1.FNOMBRE) FNOMBREE,t1.FBAJA FBAJA,t2.PCODIGO TIPOPROCEDIMIENTOPCODIGO,t2.PNOMBRE TIPOPROCEDIMIENTOPNOMBRE,t2.PNOMBREE TIPOPROCEDIMIENTOPNOMBREE,t2.PBAJA TIPOPROCEDIMIENTOPBAJA ");
		query.append("FROM FASE t1 ,TIPO_PROCEDIMIENTO t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(fase, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.PCODIGO= t2.PCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Fase>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Fase table using like.
	 * 
	 * @param fase
	 *            Fase
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Fase fase, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM FASE t1 ,TIPO_PROCEDIMIENTO t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(fase, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.PCODIGO= t2.PCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Fase entity
	 * 
	 * @param fase
	 *            Fase Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Fase fase) {

		StringBuilder where = new StringBuilder(FaseDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (fase != null && fase.getFcodigo() != null) {
			where.append(" AND t1.FCODIGO = ?");
			params.add(fase.getFcodigo());
		}
		if (fase != null && fase.getTipoProcedimiento() != null
				&& fase.getTipoProcedimiento().getPcodigo() != null) {
			where.append(" AND t2.PCODIGO = ?");
			params.add(fase.getTipoProcedimiento().getPcodigo());
		}
		if (fase != null && fase.getTipoProcedimiento() != null
				&& fase.getTipoProcedimiento().getPnombre() != null) {
			where.append(" AND t2.PNOMBRE = ?");
			params.add(fase.getTipoProcedimiento().getPnombre());
		}
		if (fase != null && fase.getTipoProcedimiento() != null
				&& fase.getTipoProcedimiento().getPnombree() != null) {
			where.append(" AND t2.PNOMBREE = ?");
			params.add(fase.getTipoProcedimiento().getPnombree());
		}
		if (fase != null && fase.getTipoProcedimiento() != null
				&& fase.getTipoProcedimiento().getPbaja() != null) {
			where.append(" AND t2.PBAJA = ?");
			params.add(fase.getTipoProcedimiento().getPbaja());
		}
		if (fase != null && fase.getFnombre() != null) {
			where.append(" AND t1.FNOMBRE = ?");
			params.add(fase.getFnombre());
		}
		if (fase != null && fase.getFnombree() != null) {
			where.append(" AND t1.FNOMBREE = ?");
			params.add(fase.getFnombree());
		}
		if (fase != null && fase.getFbaja() != null) {
			where.append(" AND t1.FBAJA = ?");
			params.add(fase.getFbaja());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Fase entity
	 * 
	 * @param fase
	 *            Fase Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Fase fase, Boolean startsWith) {

		StringBuilder where = new StringBuilder(FaseDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (fase != null && fase.getFcodigo() != null) {
			where.append(" AND UPPER(t1.FCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(fase.getFcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + fase.getFcodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.FCODIGO IS NOT NULL");
		}
		if (fase != null && fase.getTipoProcedimiento() != null
				&& fase.getTipoProcedimiento().getPcodigo() != null) {
			where.append(" AND t2.PCODIGO = ?");
			params.add(fase.getTipoProcedimiento().getPcodigo());
		}
		if (fase != null && fase.getTipoProcedimiento() != null
				&& fase.getTipoProcedimiento().getPnombre() != null) {
			where.append(" AND UPPER(t2.PNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(fase.getTipoProcedimiento().getPnombre()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ fase.getTipoProcedimiento().getPnombre()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.PNOMBRE IS NOT NULL");
		}
		if (fase != null && fase.getTipoProcedimiento() != null
				&& fase.getTipoProcedimiento().getPnombree() != null) {
			where.append(" AND UPPER(t2.PNOMBREE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(fase.getTipoProcedimiento().getPnombree()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ fase.getTipoProcedimiento().getPnombree()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.PNOMBREE IS NOT NULL");
		}
		if (fase != null && fase.getTipoProcedimiento() != null
				&& fase.getTipoProcedimiento().getPbaja() != null) {
			where.append(" AND t2.PBAJA = ?");
			params.add(fase.getTipoProcedimiento().getPbaja());
		}
		if (fase != null && fase.getFnombre() != null) {
			where.append(" AND UPPER(t1.FNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(fase.getFnombre().toUpperCase() + "%");
			} else {
				params.add("%" + fase.getFnombre().toUpperCase() + "%");
			}
			where.append(" AND t1.FNOMBRE IS NOT NULL");
		}
		if (fase != null && fase.getFnombree() != null) {
			where.append(" AND UPPER(t1.FNOMBREE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(fase.getFnombree().toUpperCase() + "%");
			} else {
				params.add("%" + fase.getFnombree().toUpperCase() + "%");
			}
			where.append(" AND t1.FNOMBREE IS NOT NULL");
		}
		if (fase != null && fase.getFbaja() != null) {
			where.append(" AND t1.FBAJA = ?");
			params.add(fase.getFbaja());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
