package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.Fase;

/**
 * FaseDao  
 *  
 */

public interface FaseDao {
    
    /**
     * Inserts a single row in the Fase table.
     *
     * @param fase Fase
     * @return Fase
     */
    Fase add(Fase fase);

    /**
     * Updates a single row in the Fase table.
     *
     * @param fase Fase
     * @return Fase
     */
    Fase update(Fase fase);

    /**
     * Finds a single row in the Fase table.
     *
     * @param fase Fase
     * @return Fase
     */
    Fase find(Fase fase);

    /**
     * Deletes a single row in the Fase table.
     *
     * @param fase Fase
     * @return 
     */
    void remove(Fase fase);

    /**
     * Finds a List of rows in the Fase table.
     *
     * @param fase Fase
     * @param pagination Pagination
     * @return List
     */
    List<Fase> findAll(Fase fase, Pagination pagination);

    /**
     * Counts rows in the Fase table.
     *
     * @param fase Fase
     * @return Long
     */
    Long findAllCount(Fase fase);
	
	/**
     * Finds rows in the Fase table using like.
     *
     * @param fase Fase
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List
     */
	List<Fase> findAllLike(Fase fase, Pagination pagination, Boolean startsWith);
	
    /**
     * Counts rows in the Fase table using like.
     *
     * @param fase Fase
     * @param startsWith Boolean
     * @return Long
     */
    Long findAllLikeCount(Fase fase, Boolean startsWith);
}

